vcpkg_check_linkage(ONLY_STATIC_LIBRARY)

string(REGEX MATCH "([0-9]+)\\.([0-9]+)\\.([0-9]+)" RAQM_VERSION "${VERSION}")
set(RAQM_VERSION_MAJOR ${CMAKE_MATCH_1})
set(RAQM_VERSION_MINOR ${CMAKE_MATCH_2})
set(RAQM_VERSION_MICRO ${CMAKE_MATCH_3})

vcpkg_from_github(
    OUT_SOURCE_PATH SOURCE_PATH
    REPO HOST-Oman/libraqm
    REF v${RAQM_VERSION_MAJOR}.${RAQM_VERSION_MINOR}.${RAQM_VERSION_MICRO}
    SHA512 ba0b16ac2240580c3091ff8b673c10345b94c54dff7e102b893855e3d33a1396c681025d3326e53f5ebcde97ceef6ab4dfd9366d0864b422e578d38146692b62
    HEAD_REF master
)

file(COPY "${CURRENT_PORT_DIR}/FindFribidi.cmake" DESTINATION "${SOURCE_PATH}")
file(COPY "${CURRENT_PORT_DIR}/CMakeLists.txt" DESTINATION "${SOURCE_PATH}")

vcpkg_cmake_configure(
    SOURCE_PATH ${SOURCE_PATH}
    OPTIONS
        -DCURRENT_PACKAGES_DIR=${CURRENT_PACKAGES_DIR}
        -DRAQM_VERSION_MAJOR=${RAQM_VERSION_MAJOR}
        -DRAQM_VERSION_MINOR=${RAQM_VERSION_MINOR}
        -DRAQM_VERSION_MICRO=${RAQM_VERSION_MICRO}
)

vcpkg_cmake_install()

vcpkg_copy_pdbs()

# Handle copyright
vcpkg_install_copyright(FILE_LIST "${SOURCE_PATH}/COPYING")

