vcpkg_from_github(
    OUT_SOURCE_PATH SOURCE_PATH
    REPO ingeniamc/sercomm
    REF 1.3.2
    SHA512 f1581f2dfa262ffb1b3aec5a1e6d32493c322c94541fbacc98efff23b3b42b14c9abdcfb063a78b7c54fb1f9d8dbf59d8064099601de2175af6c6d830708324c
    HEAD_REF master
    PATCHES
        dev-SER_END_DECL-fix.patch # https://github.com/ingeniamc/sercomm/pull/3
)

vcpkg_check_features(
    OUT_FEATURE_OPTIONS FEATURE_OPTIONS
    FEATURES
        errdesc WITH_ERRDESC
        devmon  WITH_DEVMON
)

vcpkg_cmake_configure(
    SOURCE_PATH "${SOURCE_PATH}"
    DISABLE_PARALLEL_CONFIGURE
    OPTIONS
        ${FEATURE_OPTIONS}
)

vcpkg_cmake_install()

vcpkg_cmake_config_fixup(
	PACKAGE_NAME sercomm
	CONFIG_PATH lib/cmake/sercomm
)

# Remove includes in debug
file(REMOVE_RECURSE "${CURRENT_PACKAGES_DIR}/debug/include")
file(REMOVE_RECURSE "${CURRENT_PACKAGES_DIR}/debug/share")
if(VCPKG_LIBRARY_LINKAGE STREQUAL "static")
    file(REMOVE_RECURSE "${CURRENT_PACKAGES_DIR}/bin" "${CURRENT_PACKAGES_DIR}/debug/bin")
endif()
# Handle copyright
file(INSTALL "${SOURCE_PATH}/LICENSE" DESTINATION "${CURRENT_PACKAGES_DIR}/share/${PORT}" RENAME copyright)

# Copy pdb files
vcpkg_copy_pdbs()
