/* File: globals.c
 *
 * This file is part of XSCHEM,
 * a schematic capture and Spice/Vhdl/Verilog netlisting tool for circuit
 * simulation.
 * Copyright (C) 1998-2024 Stefan Frederik Schippers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#include "xschem.h"


/* ------------------------------------------------ */
/* X11 specific globals                             */
/* ------------------------------------------------ */
Display *display = NULL;

#ifdef HAS_XCB
xcb_connection_t *xcb_conn;
#endif

Colormap colormap;
unsigned char **pixdata;
unsigned char pixdata_init[22][32]={    /* fill patterns... indexed by laynumb. */
  { /* 0 */
     0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
     0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
  },
  { /* 1 */
     0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
     0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
  },
  { /* 2 */
     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
  },
  { /* 3 */
     0x55, 0x55, 0x00, 0x00, 0xaa, 0xaa, 0x00, 0x00, 0x55, 0x55, 0x00, 0x00, 0xaa, 0xaa, 0x00, 0x00,
     0x55, 0x55, 0x00, 0x00, 0xaa, 0xaa, 0x00, 0x00, 0x55, 0x55, 0x00, 0x00, 0xaa, 0xaa, 0x00, 0x00
  },
  { /* 4 */
     0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
     0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
  },
  { /* 5 */
     0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
     0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
  },
  { /* 6 */
     0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
     0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
  },
  { /* 7 */
     0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00,
     0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02
  },
  { /* 8 */
     0x11, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
     0x11, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
  },
  { /* 9 */
     0x04, 0x41, 0x00, 0x00, 0x10, 0x04, 0x00, 0x00, 0x41, 0x10, 0x00, 0x00, 0x04, 0x41, 0x00, 0x00,
     0x10, 0x04, 0x00, 0x00, 0x41, 0x10, 0x00, 0x00, 0x04, 0x41, 0x00, 0x00, 0x10, 0x04, 0x00, 0x00
  },
  { /* 10 */
     0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
     0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
  },
  { /* 11 */
     0x11, 0x11, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x11, 0x11, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00,
     0x11, 0x11, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x11, 0x11, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00
  },
  { /* 12 */
     0x04, 0x04, 0x02, 0x02, 0x01, 0x01, 0x80, 0x80, 0x40, 0x40, 0x20, 0x20, 0x10, 0x10, 0x08, 0x08,
     0x04, 0x04, 0x02, 0x02, 0x01, 0x01, 0x80, 0x80, 0x40, 0x40, 0x20, 0x20, 0x10, 0x10, 0x08, 0x08
  },
  { /*13 */
     0x11, 0x11, 0x22, 0x22, 0x44, 0x44, 0x88, 0x88, 0x11, 0x11, 0x22, 0x22, 0x44, 0x44, 0x88, 0x88,
     0x11, 0x11, 0x22, 0x22, 0x44, 0x44, 0x88, 0x88, 0x11, 0x11, 0x22, 0x22, 0x44, 0x44, 0x88, 0x88
  },
  { /* 14 */
     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
  },
  { /* 15 */
     0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
     0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
  },
  { /* 16 */
     0x11, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
     0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
  },
  { /* 17 */
     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
  },
  { /* 18 */
     0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa,
     0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa
  },
  { /* 19 */
     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
  },
  { /* 20 */
     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
  },
  { /* 21 */
     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
  }
};
int screen_number;
int screendepth;
Pixmap cad_icon_pixmap=0, cad_icon_mask=0;
/* following global is declared in icon.c */
/* char *cad_icon[] */
Pixmap *pixmap = NULL;
Visual *visual;
#ifdef __unix__
int _unix = 1;
#else
int _unix = 0;
#endif

#ifdef FIX_BROKEN_TILED_FILL
int fix_broken_tiled_fill = 1;
#else
int fix_broken_tiled_fill = 0;
#endif

/* this fix uses an alternative method for getting mouse coordinates on KeyPress/KeyRelease
 * events. Some remote connection softwares do not generate the correct coordinates
 * on such events */
int fix_mouse_coord = 0;

/* ---------------------------------------------- */
/* These variables are mirrored in tcl code       */
/* ---------------------------------------------- */
int cadlayers=0;
int has_x=1;
int rainbow_colors = 0;
int color_ps=-1;
double nocairo_vert_correct=0.0;
/* lift up the text by 'n' pixels (zoom corrected) within the bbox.  */
/* This correction is used to better align existing schematics */
/* compared to the nocairo xschem version. */
/* allowed values should be in the range [-4, 4] */
double cairo_vert_correct=0.0;
double cairo_font_scale=1.0; /* default: 1.0, allows to adjust font size */
double cairo_font_line_spacing = 1.0; /* value taken from xschemrc / xschem.tcl */
int debug_var=-10;  /* will be set to 0 in xinit.c */

/* -------------------------------------------- */
/* These variables are NOT mirrored in tcl code */
/* -------------------------------------------- */
int help=0; /* help option set to global scope, printing help is deferred */
            /* when configuration xschemrc has been read 20140406 */
FILE *errfp = NULL;
int exit_code = 0; /* success */
char home_dir[PATH_MAX]; /* home dir obtained via getpwuid */
char user_conf_dir[PATH_MAX];
char sel_file[PATH_MAX]="";
char clip_file[PATH_MAX]="";
char pwd_dir[PATH_MAX];  /* obtained via getcwd() */
char xschem_web_dirname[PATH_MAX]=""; /* cache dir for remote URLs */
int tcp_port = 0;
int text_svg=1; /* use <text> svg element for text instead of xschem's internal vector font */
int text_ps=1;  /* use ps font for text instead of xschem's internal vector font */
char bus_char[3] = {0, 0, 0};
int yyparse_error = 0;
char *xschem_executable=NULL;
Tcl_Interp *interp = NULL;
double *character[256]; /* array or per-char coordinates of xschem internal vector font */
char old_winpath[PATH_MAX] = ".drw"; /* previously switched window, used in callback() */
#ifndef __unix__
char win_temp_dir[PATH_MAX]="";
const char fopen_read_mode[] = "rb";
#else
const char fopen_read_mode[] = "r";
#endif

/* ---------------------------------------------------------- */
/* Cmdline options (used at xinit, and then not used anymore) */
/* ---------------------------------------------------------- */
int cli_opt_argc, cli_argc;
char **cli_opt_argv = NULL;
int cli_opt_netlist_type = 0;
int cli_opt_flat_netlist = 0;
char cli_opt_plotfile[PATH_MAX] = "";
char cli_opt_diff[PATH_MAX] = "";
char cli_opt_netlist_dir[PATH_MAX] = "";
char cli_opt_filename[PATH_MAX] = ""; /* filename given on cmdline */
int cli_opt_no_readline=0;
char *cli_opt_tcl_command = NULL; /* tcl command given on command line with --tcl <script> */
char *cli_opt_preinit_command = NULL; /* tcl command given on command line with --preinit <script>
                                       * this commands will be executed before loading xschemrc */
char *cli_opt_tcl_post_command = NULL; /* tcl command given on command line with --command <script> */
int cli_opt_do_print=0;
int cli_opt_do_netlist=0;  /* set by process_options if user wants netllist from cmdline */
int cli_opt_do_simulation=0;
int cli_opt_do_waves=0;
int cli_opt_detach = 0; /* no tcl console if set; batch mode */
int cli_opt_quit=0;  /* set from process_options (ex netlist from cmdline and quit) */
char cli_opt_tcl_script[PATH_MAX] = {'\0'};
char cli_opt_initial_netlist_name[PATH_MAX]={0};
char cli_opt_rcfile[PATH_MAX] = {'\0'};
int cli_opt_load_initfile=1;

/* --------------------------------------------------- */
/* Following data is relative to the current schematic */
/* --------------------------------------------------- */
Xschem_ctx *xctx = NULL;
