/* This file is generated by venus-protocol.  See vn_protocol_renderer.h. */

/*
 * Copyright 2020 Google LLC
 * SPDX-License-Identifier: MIT
 */

#ifndef VN_PROTOCOL_RENDERER_DEVICE_H
#define VN_PROTOCOL_RENDERER_DEVICE_H

#include "vn_protocol_renderer_structs.h"

#pragma GCC diagnostic push
#if !defined(__clang__) && defined(__GNUC__) && __GNUC__ >= 12
#pragma GCC diagnostic ignored "-Wdangling-pointer"
#endif
#pragma GCC diagnostic ignored "-Wpointer-arith"
#pragma GCC diagnostic ignored "-Wunused-parameter"

/*
 * These structs/unions/commands are not included
 *
 *   vkGetDeviceProcAddr
 */

/* struct VkPhysicalDeviceLimits */

static inline void
vn_encode_VkPhysicalDeviceLimits(struct vn_cs_encoder *enc, const VkPhysicalDeviceLimits *val)
{
    vn_encode_uint32_t(enc, &val->maxImageDimension1D);
    vn_encode_uint32_t(enc, &val->maxImageDimension2D);
    vn_encode_uint32_t(enc, &val->maxImageDimension3D);
    vn_encode_uint32_t(enc, &val->maxImageDimensionCube);
    vn_encode_uint32_t(enc, &val->maxImageArrayLayers);
    vn_encode_uint32_t(enc, &val->maxTexelBufferElements);
    vn_encode_uint32_t(enc, &val->maxUniformBufferRange);
    vn_encode_uint32_t(enc, &val->maxStorageBufferRange);
    vn_encode_uint32_t(enc, &val->maxPushConstantsSize);
    vn_encode_uint32_t(enc, &val->maxMemoryAllocationCount);
    vn_encode_uint32_t(enc, &val->maxSamplerAllocationCount);
    vn_encode_VkDeviceSize(enc, &val->bufferImageGranularity);
    vn_encode_VkDeviceSize(enc, &val->sparseAddressSpaceSize);
    vn_encode_uint32_t(enc, &val->maxBoundDescriptorSets);
    vn_encode_uint32_t(enc, &val->maxPerStageDescriptorSamplers);
    vn_encode_uint32_t(enc, &val->maxPerStageDescriptorUniformBuffers);
    vn_encode_uint32_t(enc, &val->maxPerStageDescriptorStorageBuffers);
    vn_encode_uint32_t(enc, &val->maxPerStageDescriptorSampledImages);
    vn_encode_uint32_t(enc, &val->maxPerStageDescriptorStorageImages);
    vn_encode_uint32_t(enc, &val->maxPerStageDescriptorInputAttachments);
    vn_encode_uint32_t(enc, &val->maxPerStageResources);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetSamplers);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetUniformBuffers);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetUniformBuffersDynamic);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetStorageBuffers);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetStorageBuffersDynamic);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetSampledImages);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetStorageImages);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetInputAttachments);
    vn_encode_uint32_t(enc, &val->maxVertexInputAttributes);
    vn_encode_uint32_t(enc, &val->maxVertexInputBindings);
    vn_encode_uint32_t(enc, &val->maxVertexInputAttributeOffset);
    vn_encode_uint32_t(enc, &val->maxVertexInputBindingStride);
    vn_encode_uint32_t(enc, &val->maxVertexOutputComponents);
    vn_encode_uint32_t(enc, &val->maxTessellationGenerationLevel);
    vn_encode_uint32_t(enc, &val->maxTessellationPatchSize);
    vn_encode_uint32_t(enc, &val->maxTessellationControlPerVertexInputComponents);
    vn_encode_uint32_t(enc, &val->maxTessellationControlPerVertexOutputComponents);
    vn_encode_uint32_t(enc, &val->maxTessellationControlPerPatchOutputComponents);
    vn_encode_uint32_t(enc, &val->maxTessellationControlTotalOutputComponents);
    vn_encode_uint32_t(enc, &val->maxTessellationEvaluationInputComponents);
    vn_encode_uint32_t(enc, &val->maxTessellationEvaluationOutputComponents);
    vn_encode_uint32_t(enc, &val->maxGeometryShaderInvocations);
    vn_encode_uint32_t(enc, &val->maxGeometryInputComponents);
    vn_encode_uint32_t(enc, &val->maxGeometryOutputComponents);
    vn_encode_uint32_t(enc, &val->maxGeometryOutputVertices);
    vn_encode_uint32_t(enc, &val->maxGeometryTotalOutputComponents);
    vn_encode_uint32_t(enc, &val->maxFragmentInputComponents);
    vn_encode_uint32_t(enc, &val->maxFragmentOutputAttachments);
    vn_encode_uint32_t(enc, &val->maxFragmentDualSrcAttachments);
    vn_encode_uint32_t(enc, &val->maxFragmentCombinedOutputResources);
    vn_encode_uint32_t(enc, &val->maxComputeSharedMemorySize);
    vn_encode_array_size(enc, 3);
    vn_encode_uint32_t_array(enc, val->maxComputeWorkGroupCount, 3);
    vn_encode_uint32_t(enc, &val->maxComputeWorkGroupInvocations);
    vn_encode_array_size(enc, 3);
    vn_encode_uint32_t_array(enc, val->maxComputeWorkGroupSize, 3);
    vn_encode_uint32_t(enc, &val->subPixelPrecisionBits);
    vn_encode_uint32_t(enc, &val->subTexelPrecisionBits);
    vn_encode_uint32_t(enc, &val->mipmapPrecisionBits);
    vn_encode_uint32_t(enc, &val->maxDrawIndexedIndexValue);
    vn_encode_uint32_t(enc, &val->maxDrawIndirectCount);
    vn_encode_float(enc, &val->maxSamplerLodBias);
    vn_encode_float(enc, &val->maxSamplerAnisotropy);
    vn_encode_uint32_t(enc, &val->maxViewports);
    vn_encode_array_size(enc, 2);
    vn_encode_uint32_t_array(enc, val->maxViewportDimensions, 2);
    vn_encode_array_size(enc, 2);
    vn_encode_float_array(enc, val->viewportBoundsRange, 2);
    vn_encode_uint32_t(enc, &val->viewportSubPixelBits);
    vn_encode_size_t(enc, &val->minMemoryMapAlignment);
    vn_encode_VkDeviceSize(enc, &val->minTexelBufferOffsetAlignment);
    vn_encode_VkDeviceSize(enc, &val->minUniformBufferOffsetAlignment);
    vn_encode_VkDeviceSize(enc, &val->minStorageBufferOffsetAlignment);
    vn_encode_int32_t(enc, &val->minTexelOffset);
    vn_encode_uint32_t(enc, &val->maxTexelOffset);
    vn_encode_int32_t(enc, &val->minTexelGatherOffset);
    vn_encode_uint32_t(enc, &val->maxTexelGatherOffset);
    vn_encode_float(enc, &val->minInterpolationOffset);
    vn_encode_float(enc, &val->maxInterpolationOffset);
    vn_encode_uint32_t(enc, &val->subPixelInterpolationOffsetBits);
    vn_encode_uint32_t(enc, &val->maxFramebufferWidth);
    vn_encode_uint32_t(enc, &val->maxFramebufferHeight);
    vn_encode_uint32_t(enc, &val->maxFramebufferLayers);
    vn_encode_VkFlags(enc, &val->framebufferColorSampleCounts);
    vn_encode_VkFlags(enc, &val->framebufferDepthSampleCounts);
    vn_encode_VkFlags(enc, &val->framebufferStencilSampleCounts);
    vn_encode_VkFlags(enc, &val->framebufferNoAttachmentsSampleCounts);
    vn_encode_uint32_t(enc, &val->maxColorAttachments);
    vn_encode_VkFlags(enc, &val->sampledImageColorSampleCounts);
    vn_encode_VkFlags(enc, &val->sampledImageIntegerSampleCounts);
    vn_encode_VkFlags(enc, &val->sampledImageDepthSampleCounts);
    vn_encode_VkFlags(enc, &val->sampledImageStencilSampleCounts);
    vn_encode_VkFlags(enc, &val->storageImageSampleCounts);
    vn_encode_uint32_t(enc, &val->maxSampleMaskWords);
    vn_encode_VkBool32(enc, &val->timestampComputeAndGraphics);
    vn_encode_float(enc, &val->timestampPeriod);
    vn_encode_uint32_t(enc, &val->maxClipDistances);
    vn_encode_uint32_t(enc, &val->maxCullDistances);
    vn_encode_uint32_t(enc, &val->maxCombinedClipAndCullDistances);
    vn_encode_uint32_t(enc, &val->discreteQueuePriorities);
    vn_encode_array_size(enc, 2);
    vn_encode_float_array(enc, val->pointSizeRange, 2);
    vn_encode_array_size(enc, 2);
    vn_encode_float_array(enc, val->lineWidthRange, 2);
    vn_encode_float(enc, &val->pointSizeGranularity);
    vn_encode_float(enc, &val->lineWidthGranularity);
    vn_encode_VkBool32(enc, &val->strictLines);
    vn_encode_VkBool32(enc, &val->standardSampleLocations);
    vn_encode_VkDeviceSize(enc, &val->optimalBufferCopyOffsetAlignment);
    vn_encode_VkDeviceSize(enc, &val->optimalBufferCopyRowPitchAlignment);
    vn_encode_VkDeviceSize(enc, &val->nonCoherentAtomSize);
}

static inline void
vn_decode_VkPhysicalDeviceLimits_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceLimits *val)
{
    /* skip val->maxImageDimension1D */
    /* skip val->maxImageDimension2D */
    /* skip val->maxImageDimension3D */
    /* skip val->maxImageDimensionCube */
    /* skip val->maxImageArrayLayers */
    /* skip val->maxTexelBufferElements */
    /* skip val->maxUniformBufferRange */
    /* skip val->maxStorageBufferRange */
    /* skip val->maxPushConstantsSize */
    /* skip val->maxMemoryAllocationCount */
    /* skip val->maxSamplerAllocationCount */
    /* skip val->bufferImageGranularity */
    /* skip val->sparseAddressSpaceSize */
    /* skip val->maxBoundDescriptorSets */
    /* skip val->maxPerStageDescriptorSamplers */
    /* skip val->maxPerStageDescriptorUniformBuffers */
    /* skip val->maxPerStageDescriptorStorageBuffers */
    /* skip val->maxPerStageDescriptorSampledImages */
    /* skip val->maxPerStageDescriptorStorageImages */
    /* skip val->maxPerStageDescriptorInputAttachments */
    /* skip val->maxPerStageResources */
    /* skip val->maxDescriptorSetSamplers */
    /* skip val->maxDescriptorSetUniformBuffers */
    /* skip val->maxDescriptorSetUniformBuffersDynamic */
    /* skip val->maxDescriptorSetStorageBuffers */
    /* skip val->maxDescriptorSetStorageBuffersDynamic */
    /* skip val->maxDescriptorSetSampledImages */
    /* skip val->maxDescriptorSetStorageImages */
    /* skip val->maxDescriptorSetInputAttachments */
    /* skip val->maxVertexInputAttributes */
    /* skip val->maxVertexInputBindings */
    /* skip val->maxVertexInputAttributeOffset */
    /* skip val->maxVertexInputBindingStride */
    /* skip val->maxVertexOutputComponents */
    /* skip val->maxTessellationGenerationLevel */
    /* skip val->maxTessellationPatchSize */
    /* skip val->maxTessellationControlPerVertexInputComponents */
    /* skip val->maxTessellationControlPerVertexOutputComponents */
    /* skip val->maxTessellationControlPerPatchOutputComponents */
    /* skip val->maxTessellationControlTotalOutputComponents */
    /* skip val->maxTessellationEvaluationInputComponents */
    /* skip val->maxTessellationEvaluationOutputComponents */
    /* skip val->maxGeometryShaderInvocations */
    /* skip val->maxGeometryInputComponents */
    /* skip val->maxGeometryOutputComponents */
    /* skip val->maxGeometryOutputVertices */
    /* skip val->maxGeometryTotalOutputComponents */
    /* skip val->maxFragmentInputComponents */
    /* skip val->maxFragmentOutputAttachments */
    /* skip val->maxFragmentDualSrcAttachments */
    /* skip val->maxFragmentCombinedOutputResources */
    /* skip val->maxComputeSharedMemorySize */
    /* skip val->maxComputeWorkGroupCount */
    /* skip val->maxComputeWorkGroupInvocations */
    /* skip val->maxComputeWorkGroupSize */
    /* skip val->subPixelPrecisionBits */
    /* skip val->subTexelPrecisionBits */
    /* skip val->mipmapPrecisionBits */
    /* skip val->maxDrawIndexedIndexValue */
    /* skip val->maxDrawIndirectCount */
    /* skip val->maxSamplerLodBias */
    /* skip val->maxSamplerAnisotropy */
    /* skip val->maxViewports */
    /* skip val->maxViewportDimensions */
    /* skip val->viewportBoundsRange */
    /* skip val->viewportSubPixelBits */
    /* skip val->minMemoryMapAlignment */
    /* skip val->minTexelBufferOffsetAlignment */
    /* skip val->minUniformBufferOffsetAlignment */
    /* skip val->minStorageBufferOffsetAlignment */
    /* skip val->minTexelOffset */
    /* skip val->maxTexelOffset */
    /* skip val->minTexelGatherOffset */
    /* skip val->maxTexelGatherOffset */
    /* skip val->minInterpolationOffset */
    /* skip val->maxInterpolationOffset */
    /* skip val->subPixelInterpolationOffsetBits */
    /* skip val->maxFramebufferWidth */
    /* skip val->maxFramebufferHeight */
    /* skip val->maxFramebufferLayers */
    /* skip val->framebufferColorSampleCounts */
    /* skip val->framebufferDepthSampleCounts */
    /* skip val->framebufferStencilSampleCounts */
    /* skip val->framebufferNoAttachmentsSampleCounts */
    /* skip val->maxColorAttachments */
    /* skip val->sampledImageColorSampleCounts */
    /* skip val->sampledImageIntegerSampleCounts */
    /* skip val->sampledImageDepthSampleCounts */
    /* skip val->sampledImageStencilSampleCounts */
    /* skip val->storageImageSampleCounts */
    /* skip val->maxSampleMaskWords */
    /* skip val->timestampComputeAndGraphics */
    /* skip val->timestampPeriod */
    /* skip val->maxClipDistances */
    /* skip val->maxCullDistances */
    /* skip val->maxCombinedClipAndCullDistances */
    /* skip val->discreteQueuePriorities */
    /* skip val->pointSizeRange */
    /* skip val->lineWidthRange */
    /* skip val->pointSizeGranularity */
    /* skip val->lineWidthGranularity */
    /* skip val->strictLines */
    /* skip val->standardSampleLocations */
    /* skip val->optimalBufferCopyOffsetAlignment */
    /* skip val->optimalBufferCopyRowPitchAlignment */
    /* skip val->nonCoherentAtomSize */
}

/* struct VkPhysicalDeviceSparseProperties */

static inline void
vn_encode_VkPhysicalDeviceSparseProperties(struct vn_cs_encoder *enc, const VkPhysicalDeviceSparseProperties *val)
{
    vn_encode_VkBool32(enc, &val->residencyStandard2DBlockShape);
    vn_encode_VkBool32(enc, &val->residencyStandard2DMultisampleBlockShape);
    vn_encode_VkBool32(enc, &val->residencyStandard3DBlockShape);
    vn_encode_VkBool32(enc, &val->residencyAlignedMipSize);
    vn_encode_VkBool32(enc, &val->residencyNonResidentStrict);
}

static inline void
vn_decode_VkPhysicalDeviceSparseProperties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceSparseProperties *val)
{
    /* skip val->residencyStandard2DBlockShape */
    /* skip val->residencyStandard2DMultisampleBlockShape */
    /* skip val->residencyStandard3DBlockShape */
    /* skip val->residencyAlignedMipSize */
    /* skip val->residencyNonResidentStrict */
}

/* struct VkPhysicalDeviceProperties */

static inline void
vn_encode_VkPhysicalDeviceProperties(struct vn_cs_encoder *enc, const VkPhysicalDeviceProperties *val)
{
    vn_encode_uint32_t(enc, &val->apiVersion);
    vn_encode_uint32_t(enc, &val->driverVersion);
    vn_encode_uint32_t(enc, &val->vendorID);
    vn_encode_uint32_t(enc, &val->deviceID);
    vn_encode_VkPhysicalDeviceType(enc, &val->deviceType);
    vn_encode_array_size(enc, VK_MAX_PHYSICAL_DEVICE_NAME_SIZE);
    vn_encode_char_array(enc, val->deviceName, VK_MAX_PHYSICAL_DEVICE_NAME_SIZE);
    vn_encode_array_size(enc, VK_UUID_SIZE);
    vn_encode_uint8_t_array(enc, val->pipelineCacheUUID, VK_UUID_SIZE);
    vn_encode_VkPhysicalDeviceLimits(enc, &val->limits);
    vn_encode_VkPhysicalDeviceSparseProperties(enc, &val->sparseProperties);
}

static inline void
vn_decode_VkPhysicalDeviceProperties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceProperties *val)
{
    /* skip val->apiVersion */
    /* skip val->driverVersion */
    /* skip val->vendorID */
    /* skip val->deviceID */
    /* skip val->deviceType */
    /* skip val->deviceName */
    /* skip val->pipelineCacheUUID */
    vn_decode_VkPhysicalDeviceLimits_partial_temp(dec, &val->limits);
    vn_decode_VkPhysicalDeviceSparseProperties_partial_temp(dec, &val->sparseProperties);
}

/* struct VkQueueFamilyProperties */

static inline void
vn_encode_VkQueueFamilyProperties(struct vn_cs_encoder *enc, const VkQueueFamilyProperties *val)
{
    vn_encode_VkFlags(enc, &val->queueFlags);
    vn_encode_uint32_t(enc, &val->queueCount);
    vn_encode_uint32_t(enc, &val->timestampValidBits);
    vn_encode_VkExtent3D(enc, &val->minImageTransferGranularity);
}

static inline void
vn_decode_VkQueueFamilyProperties_partial_temp(struct vn_cs_decoder *dec, VkQueueFamilyProperties *val)
{
    /* skip val->queueFlags */
    /* skip val->queueCount */
    /* skip val->timestampValidBits */
    vn_decode_VkExtent3D_partial_temp(dec, &val->minImageTransferGranularity);
}

/* struct VkMemoryType */

static inline void
vn_encode_VkMemoryType(struct vn_cs_encoder *enc, const VkMemoryType *val)
{
    vn_encode_VkFlags(enc, &val->propertyFlags);
    vn_encode_uint32_t(enc, &val->heapIndex);
}

static inline void
vn_decode_VkMemoryType_partial_temp(struct vn_cs_decoder *dec, VkMemoryType *val)
{
    /* skip val->propertyFlags */
    /* skip val->heapIndex */
}

/* struct VkMemoryHeap */

static inline void
vn_encode_VkMemoryHeap(struct vn_cs_encoder *enc, const VkMemoryHeap *val)
{
    vn_encode_VkDeviceSize(enc, &val->size);
    vn_encode_VkFlags(enc, &val->flags);
}

static inline void
vn_decode_VkMemoryHeap_partial_temp(struct vn_cs_decoder *dec, VkMemoryHeap *val)
{
    /* skip val->size */
    /* skip val->flags */
}

/* struct VkPhysicalDeviceMemoryProperties */

static inline void
vn_encode_VkPhysicalDeviceMemoryProperties(struct vn_cs_encoder *enc, const VkPhysicalDeviceMemoryProperties *val)
{
    vn_encode_uint32_t(enc, &val->memoryTypeCount);
    vn_encode_array_size(enc, VK_MAX_MEMORY_TYPES);
    for (uint32_t i = 0; i < VK_MAX_MEMORY_TYPES; i++)
        vn_encode_VkMemoryType(enc, &val->memoryTypes[i]);
    vn_encode_uint32_t(enc, &val->memoryHeapCount);
    vn_encode_array_size(enc, VK_MAX_MEMORY_HEAPS);
    for (uint32_t i = 0; i < VK_MAX_MEMORY_HEAPS; i++)
        vn_encode_VkMemoryHeap(enc, &val->memoryHeaps[i]);
}

static inline void
vn_decode_VkPhysicalDeviceMemoryProperties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMemoryProperties *val)
{
    /* skip val->memoryTypeCount */
    {
        const uint32_t iter_count = vn_decode_array_size(dec, VK_MAX_MEMORY_TYPES);
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkMemoryType_partial_temp(dec, &val->memoryTypes[i]);
    }
    /* skip val->memoryHeapCount */
    {
        const uint32_t iter_count = vn_decode_array_size(dec, VK_MAX_MEMORY_HEAPS);
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkMemoryHeap_partial_temp(dec, &val->memoryHeaps[i]);
    }
}

/* struct VkPhysicalDeviceFeatures */

static inline void
vn_encode_VkPhysicalDeviceFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceFeatures *val)
{
    vn_encode_VkBool32(enc, &val->robustBufferAccess);
    vn_encode_VkBool32(enc, &val->fullDrawIndexUint32);
    vn_encode_VkBool32(enc, &val->imageCubeArray);
    vn_encode_VkBool32(enc, &val->independentBlend);
    vn_encode_VkBool32(enc, &val->geometryShader);
    vn_encode_VkBool32(enc, &val->tessellationShader);
    vn_encode_VkBool32(enc, &val->sampleRateShading);
    vn_encode_VkBool32(enc, &val->dualSrcBlend);
    vn_encode_VkBool32(enc, &val->logicOp);
    vn_encode_VkBool32(enc, &val->multiDrawIndirect);
    vn_encode_VkBool32(enc, &val->drawIndirectFirstInstance);
    vn_encode_VkBool32(enc, &val->depthClamp);
    vn_encode_VkBool32(enc, &val->depthBiasClamp);
    vn_encode_VkBool32(enc, &val->fillModeNonSolid);
    vn_encode_VkBool32(enc, &val->depthBounds);
    vn_encode_VkBool32(enc, &val->wideLines);
    vn_encode_VkBool32(enc, &val->largePoints);
    vn_encode_VkBool32(enc, &val->alphaToOne);
    vn_encode_VkBool32(enc, &val->multiViewport);
    vn_encode_VkBool32(enc, &val->samplerAnisotropy);
    vn_encode_VkBool32(enc, &val->textureCompressionETC2);
    vn_encode_VkBool32(enc, &val->textureCompressionASTC_LDR);
    vn_encode_VkBool32(enc, &val->textureCompressionBC);
    vn_encode_VkBool32(enc, &val->occlusionQueryPrecise);
    vn_encode_VkBool32(enc, &val->pipelineStatisticsQuery);
    vn_encode_VkBool32(enc, &val->vertexPipelineStoresAndAtomics);
    vn_encode_VkBool32(enc, &val->fragmentStoresAndAtomics);
    vn_encode_VkBool32(enc, &val->shaderTessellationAndGeometryPointSize);
    vn_encode_VkBool32(enc, &val->shaderImageGatherExtended);
    vn_encode_VkBool32(enc, &val->shaderStorageImageExtendedFormats);
    vn_encode_VkBool32(enc, &val->shaderStorageImageMultisample);
    vn_encode_VkBool32(enc, &val->shaderStorageImageReadWithoutFormat);
    vn_encode_VkBool32(enc, &val->shaderStorageImageWriteWithoutFormat);
    vn_encode_VkBool32(enc, &val->shaderUniformBufferArrayDynamicIndexing);
    vn_encode_VkBool32(enc, &val->shaderSampledImageArrayDynamicIndexing);
    vn_encode_VkBool32(enc, &val->shaderStorageBufferArrayDynamicIndexing);
    vn_encode_VkBool32(enc, &val->shaderStorageImageArrayDynamicIndexing);
    vn_encode_VkBool32(enc, &val->shaderClipDistance);
    vn_encode_VkBool32(enc, &val->shaderCullDistance);
    vn_encode_VkBool32(enc, &val->shaderFloat64);
    vn_encode_VkBool32(enc, &val->shaderInt64);
    vn_encode_VkBool32(enc, &val->shaderInt16);
    vn_encode_VkBool32(enc, &val->shaderResourceResidency);
    vn_encode_VkBool32(enc, &val->shaderResourceMinLod);
    vn_encode_VkBool32(enc, &val->sparseBinding);
    vn_encode_VkBool32(enc, &val->sparseResidencyBuffer);
    vn_encode_VkBool32(enc, &val->sparseResidencyImage2D);
    vn_encode_VkBool32(enc, &val->sparseResidencyImage3D);
    vn_encode_VkBool32(enc, &val->sparseResidency2Samples);
    vn_encode_VkBool32(enc, &val->sparseResidency4Samples);
    vn_encode_VkBool32(enc, &val->sparseResidency8Samples);
    vn_encode_VkBool32(enc, &val->sparseResidency16Samples);
    vn_encode_VkBool32(enc, &val->sparseResidencyAliased);
    vn_encode_VkBool32(enc, &val->variableMultisampleRate);
    vn_encode_VkBool32(enc, &val->inheritedQueries);
}

static inline void
vn_decode_VkPhysicalDeviceFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceFeatures *val)
{
    vn_decode_VkBool32(dec, &val->robustBufferAccess);
    vn_decode_VkBool32(dec, &val->fullDrawIndexUint32);
    vn_decode_VkBool32(dec, &val->imageCubeArray);
    vn_decode_VkBool32(dec, &val->independentBlend);
    vn_decode_VkBool32(dec, &val->geometryShader);
    vn_decode_VkBool32(dec, &val->tessellationShader);
    vn_decode_VkBool32(dec, &val->sampleRateShading);
    vn_decode_VkBool32(dec, &val->dualSrcBlend);
    vn_decode_VkBool32(dec, &val->logicOp);
    vn_decode_VkBool32(dec, &val->multiDrawIndirect);
    vn_decode_VkBool32(dec, &val->drawIndirectFirstInstance);
    vn_decode_VkBool32(dec, &val->depthClamp);
    vn_decode_VkBool32(dec, &val->depthBiasClamp);
    vn_decode_VkBool32(dec, &val->fillModeNonSolid);
    vn_decode_VkBool32(dec, &val->depthBounds);
    vn_decode_VkBool32(dec, &val->wideLines);
    vn_decode_VkBool32(dec, &val->largePoints);
    vn_decode_VkBool32(dec, &val->alphaToOne);
    vn_decode_VkBool32(dec, &val->multiViewport);
    vn_decode_VkBool32(dec, &val->samplerAnisotropy);
    vn_decode_VkBool32(dec, &val->textureCompressionETC2);
    vn_decode_VkBool32(dec, &val->textureCompressionASTC_LDR);
    vn_decode_VkBool32(dec, &val->textureCompressionBC);
    vn_decode_VkBool32(dec, &val->occlusionQueryPrecise);
    vn_decode_VkBool32(dec, &val->pipelineStatisticsQuery);
    vn_decode_VkBool32(dec, &val->vertexPipelineStoresAndAtomics);
    vn_decode_VkBool32(dec, &val->fragmentStoresAndAtomics);
    vn_decode_VkBool32(dec, &val->shaderTessellationAndGeometryPointSize);
    vn_decode_VkBool32(dec, &val->shaderImageGatherExtended);
    vn_decode_VkBool32(dec, &val->shaderStorageImageExtendedFormats);
    vn_decode_VkBool32(dec, &val->shaderStorageImageMultisample);
    vn_decode_VkBool32(dec, &val->shaderStorageImageReadWithoutFormat);
    vn_decode_VkBool32(dec, &val->shaderStorageImageWriteWithoutFormat);
    vn_decode_VkBool32(dec, &val->shaderUniformBufferArrayDynamicIndexing);
    vn_decode_VkBool32(dec, &val->shaderSampledImageArrayDynamicIndexing);
    vn_decode_VkBool32(dec, &val->shaderStorageBufferArrayDynamicIndexing);
    vn_decode_VkBool32(dec, &val->shaderStorageImageArrayDynamicIndexing);
    vn_decode_VkBool32(dec, &val->shaderClipDistance);
    vn_decode_VkBool32(dec, &val->shaderCullDistance);
    vn_decode_VkBool32(dec, &val->shaderFloat64);
    vn_decode_VkBool32(dec, &val->shaderInt64);
    vn_decode_VkBool32(dec, &val->shaderInt16);
    vn_decode_VkBool32(dec, &val->shaderResourceResidency);
    vn_decode_VkBool32(dec, &val->shaderResourceMinLod);
    vn_decode_VkBool32(dec, &val->sparseBinding);
    vn_decode_VkBool32(dec, &val->sparseResidencyBuffer);
    vn_decode_VkBool32(dec, &val->sparseResidencyImage2D);
    vn_decode_VkBool32(dec, &val->sparseResidencyImage3D);
    vn_decode_VkBool32(dec, &val->sparseResidency2Samples);
    vn_decode_VkBool32(dec, &val->sparseResidency4Samples);
    vn_decode_VkBool32(dec, &val->sparseResidency8Samples);
    vn_decode_VkBool32(dec, &val->sparseResidency16Samples);
    vn_decode_VkBool32(dec, &val->sparseResidencyAliased);
    vn_decode_VkBool32(dec, &val->variableMultisampleRate);
    vn_decode_VkBool32(dec, &val->inheritedQueries);
}

static inline void
vn_decode_VkPhysicalDeviceFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceFeatures *val)
{
    /* skip val->robustBufferAccess */
    /* skip val->fullDrawIndexUint32 */
    /* skip val->imageCubeArray */
    /* skip val->independentBlend */
    /* skip val->geometryShader */
    /* skip val->tessellationShader */
    /* skip val->sampleRateShading */
    /* skip val->dualSrcBlend */
    /* skip val->logicOp */
    /* skip val->multiDrawIndirect */
    /* skip val->drawIndirectFirstInstance */
    /* skip val->depthClamp */
    /* skip val->depthBiasClamp */
    /* skip val->fillModeNonSolid */
    /* skip val->depthBounds */
    /* skip val->wideLines */
    /* skip val->largePoints */
    /* skip val->alphaToOne */
    /* skip val->multiViewport */
    /* skip val->samplerAnisotropy */
    /* skip val->textureCompressionETC2 */
    /* skip val->textureCompressionASTC_LDR */
    /* skip val->textureCompressionBC */
    /* skip val->occlusionQueryPrecise */
    /* skip val->pipelineStatisticsQuery */
    /* skip val->vertexPipelineStoresAndAtomics */
    /* skip val->fragmentStoresAndAtomics */
    /* skip val->shaderTessellationAndGeometryPointSize */
    /* skip val->shaderImageGatherExtended */
    /* skip val->shaderStorageImageExtendedFormats */
    /* skip val->shaderStorageImageMultisample */
    /* skip val->shaderStorageImageReadWithoutFormat */
    /* skip val->shaderStorageImageWriteWithoutFormat */
    /* skip val->shaderUniformBufferArrayDynamicIndexing */
    /* skip val->shaderSampledImageArrayDynamicIndexing */
    /* skip val->shaderStorageBufferArrayDynamicIndexing */
    /* skip val->shaderStorageImageArrayDynamicIndexing */
    /* skip val->shaderClipDistance */
    /* skip val->shaderCullDistance */
    /* skip val->shaderFloat64 */
    /* skip val->shaderInt64 */
    /* skip val->shaderInt16 */
    /* skip val->shaderResourceResidency */
    /* skip val->shaderResourceMinLod */
    /* skip val->sparseBinding */
    /* skip val->sparseResidencyBuffer */
    /* skip val->sparseResidencyImage2D */
    /* skip val->sparseResidencyImage3D */
    /* skip val->sparseResidency2Samples */
    /* skip val->sparseResidency4Samples */
    /* skip val->sparseResidency8Samples */
    /* skip val->sparseResidency16Samples */
    /* skip val->sparseResidencyAliased */
    /* skip val->variableMultisampleRate */
    /* skip val->inheritedQueries */
}

static inline void
vn_replace_VkPhysicalDeviceFeatures_handle(VkPhysicalDeviceFeatures *val)
{
    /* skip val->robustBufferAccess */
    /* skip val->fullDrawIndexUint32 */
    /* skip val->imageCubeArray */
    /* skip val->independentBlend */
    /* skip val->geometryShader */
    /* skip val->tessellationShader */
    /* skip val->sampleRateShading */
    /* skip val->dualSrcBlend */
    /* skip val->logicOp */
    /* skip val->multiDrawIndirect */
    /* skip val->drawIndirectFirstInstance */
    /* skip val->depthClamp */
    /* skip val->depthBiasClamp */
    /* skip val->fillModeNonSolid */
    /* skip val->depthBounds */
    /* skip val->wideLines */
    /* skip val->largePoints */
    /* skip val->alphaToOne */
    /* skip val->multiViewport */
    /* skip val->samplerAnisotropy */
    /* skip val->textureCompressionETC2 */
    /* skip val->textureCompressionASTC_LDR */
    /* skip val->textureCompressionBC */
    /* skip val->occlusionQueryPrecise */
    /* skip val->pipelineStatisticsQuery */
    /* skip val->vertexPipelineStoresAndAtomics */
    /* skip val->fragmentStoresAndAtomics */
    /* skip val->shaderTessellationAndGeometryPointSize */
    /* skip val->shaderImageGatherExtended */
    /* skip val->shaderStorageImageExtendedFormats */
    /* skip val->shaderStorageImageMultisample */
    /* skip val->shaderStorageImageReadWithoutFormat */
    /* skip val->shaderStorageImageWriteWithoutFormat */
    /* skip val->shaderUniformBufferArrayDynamicIndexing */
    /* skip val->shaderSampledImageArrayDynamicIndexing */
    /* skip val->shaderStorageBufferArrayDynamicIndexing */
    /* skip val->shaderStorageImageArrayDynamicIndexing */
    /* skip val->shaderClipDistance */
    /* skip val->shaderCullDistance */
    /* skip val->shaderFloat64 */
    /* skip val->shaderInt64 */
    /* skip val->shaderInt16 */
    /* skip val->shaderResourceResidency */
    /* skip val->shaderResourceMinLod */
    /* skip val->sparseBinding */
    /* skip val->sparseResidencyBuffer */
    /* skip val->sparseResidencyImage2D */
    /* skip val->sparseResidencyImage3D */
    /* skip val->sparseResidency2Samples */
    /* skip val->sparseResidency4Samples */
    /* skip val->sparseResidency8Samples */
    /* skip val->sparseResidency16Samples */
    /* skip val->sparseResidencyAliased */
    /* skip val->variableMultisampleRate */
    /* skip val->inheritedQueries */
}

/* struct VkFormatProperties */

static inline void
vn_encode_VkFormatProperties(struct vn_cs_encoder *enc, const VkFormatProperties *val)
{
    vn_encode_VkFlags(enc, &val->linearTilingFeatures);
    vn_encode_VkFlags(enc, &val->optimalTilingFeatures);
    vn_encode_VkFlags(enc, &val->bufferFeatures);
}

static inline void
vn_decode_VkFormatProperties_partial_temp(struct vn_cs_decoder *dec, VkFormatProperties *val)
{
    /* skip val->linearTilingFeatures */
    /* skip val->optimalTilingFeatures */
    /* skip val->bufferFeatures */
}

/* struct VkImageFormatProperties */

static inline void
vn_encode_VkImageFormatProperties(struct vn_cs_encoder *enc, const VkImageFormatProperties *val)
{
    vn_encode_VkExtent3D(enc, &val->maxExtent);
    vn_encode_uint32_t(enc, &val->maxMipLevels);
    vn_encode_uint32_t(enc, &val->maxArrayLayers);
    vn_encode_VkFlags(enc, &val->sampleCounts);
    vn_encode_VkDeviceSize(enc, &val->maxResourceSize);
}

static inline void
vn_decode_VkImageFormatProperties_partial_temp(struct vn_cs_decoder *dec, VkImageFormatProperties *val)
{
    vn_decode_VkExtent3D_partial_temp(dec, &val->maxExtent);
    /* skip val->maxMipLevels */
    /* skip val->maxArrayLayers */
    /* skip val->sampleCounts */
    /* skip val->maxResourceSize */
}

/* struct VkDeviceQueueCreateInfo chain */

static inline void *
vn_decode_VkDeviceQueueCreateInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkDeviceQueueCreateInfo_self_temp(struct vn_cs_decoder *dec, VkDeviceQueueCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->flags);
    vn_decode_uint32_t(dec, &val->queueFamilyIndex);
    vn_decode_uint32_t(dec, &val->queueCount);
    if (vn_peek_array_size(dec)) {
        const size_t array_size = vn_decode_array_size(dec, val->queueCount);
        val->pQueuePriorities = vn_cs_decoder_alloc_temp_array(dec, sizeof(*val->pQueuePriorities), array_size);
        if (!val->pQueuePriorities) return;
        vn_decode_float_array(dec, (float *)val->pQueuePriorities, array_size);
    } else {
        vn_decode_array_size(dec, val->queueCount);
        val->pQueuePriorities = NULL;
    }
}

static inline void
vn_decode_VkDeviceQueueCreateInfo_temp(struct vn_cs_decoder *dec, VkDeviceQueueCreateInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_DEVICE_QUEUE_CREATE_INFO)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkDeviceQueueCreateInfo_pnext_temp(dec);
    vn_decode_VkDeviceQueueCreateInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkDeviceQueueCreateInfo_handle_self(VkDeviceQueueCreateInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->flags */
    /* skip val->queueFamilyIndex */
    /* skip val->queueCount */
    /* skip val->pQueuePriorities */
}

static inline void
vn_replace_VkDeviceQueueCreateInfo_handle(VkDeviceQueueCreateInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_DEVICE_QUEUE_CREATE_INFO:
            vn_replace_VkDeviceQueueCreateInfo_handle_self((VkDeviceQueueCreateInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkDevicePrivateDataCreateInfo chain */

static inline void *
vn_decode_VkDevicePrivateDataCreateInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkDevicePrivateDataCreateInfo_self_temp(struct vn_cs_decoder *dec, VkDevicePrivateDataCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint32_t(dec, &val->privateDataSlotRequestCount);
}

static inline void
vn_decode_VkDevicePrivateDataCreateInfo_temp(struct vn_cs_decoder *dec, VkDevicePrivateDataCreateInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_DEVICE_PRIVATE_DATA_CREATE_INFO)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkDevicePrivateDataCreateInfo_pnext_temp(dec);
    vn_decode_VkDevicePrivateDataCreateInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkDevicePrivateDataCreateInfo_handle_self(VkDevicePrivateDataCreateInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->privateDataSlotRequestCount */
}

static inline void
vn_replace_VkDevicePrivateDataCreateInfo_handle(VkDevicePrivateDataCreateInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_DEVICE_PRIVATE_DATA_CREATE_INFO:
            vn_replace_VkDevicePrivateDataCreateInfo_handle_self((VkDevicePrivateDataCreateInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDevicePrivateDataFeatures chain */

static inline void
vn_encode_VkPhysicalDevicePrivateDataFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDevicePrivateDataFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDevicePrivateDataFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->privateData);
}

static inline void
vn_encode_VkPhysicalDevicePrivateDataFeatures(struct vn_cs_encoder *enc, const VkPhysicalDevicePrivateDataFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES });
    vn_encode_VkPhysicalDevicePrivateDataFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDevicePrivateDataFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDevicePrivateDataFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDevicePrivateDataFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDevicePrivateDataFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->privateData);
}

static inline void
vn_decode_VkPhysicalDevicePrivateDataFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDevicePrivateDataFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDevicePrivateDataFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDevicePrivateDataFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDevicePrivateDataFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDevicePrivateDataFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDevicePrivateDataFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->privateData */
}

static inline void
vn_decode_VkPhysicalDevicePrivateDataFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDevicePrivateDataFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDevicePrivateDataFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDevicePrivateDataFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDevicePrivateDataFeatures_handle_self(VkPhysicalDevicePrivateDataFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->privateData */
}

static inline void
vn_replace_VkPhysicalDevicePrivateDataFeatures_handle(VkPhysicalDevicePrivateDataFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES:
            vn_replace_VkPhysicalDevicePrivateDataFeatures_handle_self((VkPhysicalDevicePrivateDataFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceVariablePointersFeatures chain */

static inline void
vn_encode_VkPhysicalDeviceVariablePointersFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceVariablePointersFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceVariablePointersFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->variablePointersStorageBuffer);
    vn_encode_VkBool32(enc, &val->variablePointers);
}

static inline void
vn_encode_VkPhysicalDeviceVariablePointersFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceVariablePointersFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES });
    vn_encode_VkPhysicalDeviceVariablePointersFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceVariablePointersFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceVariablePointersFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceVariablePointersFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVariablePointersFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->variablePointersStorageBuffer);
    vn_decode_VkBool32(dec, &val->variablePointers);
}

static inline void
vn_decode_VkPhysicalDeviceVariablePointersFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVariablePointersFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceVariablePointersFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceVariablePointersFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceVariablePointersFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceVariablePointersFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVariablePointersFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->variablePointersStorageBuffer */
    /* skip val->variablePointers */
}

static inline void
vn_decode_VkPhysicalDeviceVariablePointersFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVariablePointersFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceVariablePointersFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceVariablePointersFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceVariablePointersFeatures_handle_self(VkPhysicalDeviceVariablePointersFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->variablePointersStorageBuffer */
    /* skip val->variablePointers */
}

static inline void
vn_replace_VkPhysicalDeviceVariablePointersFeatures_handle(VkPhysicalDeviceVariablePointersFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES:
            vn_replace_VkPhysicalDeviceVariablePointersFeatures_handle_self((VkPhysicalDeviceVariablePointersFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceMultiviewFeatures chain */

static inline void
vn_encode_VkPhysicalDeviceMultiviewFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceMultiviewFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceMultiviewFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->multiview);
    vn_encode_VkBool32(enc, &val->multiviewGeometryShader);
    vn_encode_VkBool32(enc, &val->multiviewTessellationShader);
}

static inline void
vn_encode_VkPhysicalDeviceMultiviewFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceMultiviewFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES });
    vn_encode_VkPhysicalDeviceMultiviewFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceMultiviewFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceMultiviewFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceMultiviewFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMultiviewFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->multiview);
    vn_decode_VkBool32(dec, &val->multiviewGeometryShader);
    vn_decode_VkBool32(dec, &val->multiviewTessellationShader);
}

static inline void
vn_decode_VkPhysicalDeviceMultiviewFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMultiviewFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceMultiviewFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceMultiviewFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceMultiviewFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceMultiviewFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMultiviewFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->multiview */
    /* skip val->multiviewGeometryShader */
    /* skip val->multiviewTessellationShader */
}

static inline void
vn_decode_VkPhysicalDeviceMultiviewFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMultiviewFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceMultiviewFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceMultiviewFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceMultiviewFeatures_handle_self(VkPhysicalDeviceMultiviewFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->multiview */
    /* skip val->multiviewGeometryShader */
    /* skip val->multiviewTessellationShader */
}

static inline void
vn_replace_VkPhysicalDeviceMultiviewFeatures_handle(VkPhysicalDeviceMultiviewFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES:
            vn_replace_VkPhysicalDeviceMultiviewFeatures_handle_self((VkPhysicalDeviceMultiviewFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDevice16BitStorageFeatures chain */

static inline void
vn_encode_VkPhysicalDevice16BitStorageFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDevice16BitStorageFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDevice16BitStorageFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->storageBuffer16BitAccess);
    vn_encode_VkBool32(enc, &val->uniformAndStorageBuffer16BitAccess);
    vn_encode_VkBool32(enc, &val->storagePushConstant16);
    vn_encode_VkBool32(enc, &val->storageInputOutput16);
}

static inline void
vn_encode_VkPhysicalDevice16BitStorageFeatures(struct vn_cs_encoder *enc, const VkPhysicalDevice16BitStorageFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES });
    vn_encode_VkPhysicalDevice16BitStorageFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDevice16BitStorageFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDevice16BitStorageFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDevice16BitStorageFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDevice16BitStorageFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->storageBuffer16BitAccess);
    vn_decode_VkBool32(dec, &val->uniformAndStorageBuffer16BitAccess);
    vn_decode_VkBool32(dec, &val->storagePushConstant16);
    vn_decode_VkBool32(dec, &val->storageInputOutput16);
}

static inline void
vn_decode_VkPhysicalDevice16BitStorageFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDevice16BitStorageFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDevice16BitStorageFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDevice16BitStorageFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDevice16BitStorageFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDevice16BitStorageFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDevice16BitStorageFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->storageBuffer16BitAccess */
    /* skip val->uniformAndStorageBuffer16BitAccess */
    /* skip val->storagePushConstant16 */
    /* skip val->storageInputOutput16 */
}

static inline void
vn_decode_VkPhysicalDevice16BitStorageFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDevice16BitStorageFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDevice16BitStorageFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDevice16BitStorageFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDevice16BitStorageFeatures_handle_self(VkPhysicalDevice16BitStorageFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->storageBuffer16BitAccess */
    /* skip val->uniformAndStorageBuffer16BitAccess */
    /* skip val->storagePushConstant16 */
    /* skip val->storageInputOutput16 */
}

static inline void
vn_replace_VkPhysicalDevice16BitStorageFeatures_handle(VkPhysicalDevice16BitStorageFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES:
            vn_replace_VkPhysicalDevice16BitStorageFeatures_handle_self((VkPhysicalDevice16BitStorageFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures chain */

static inline void
vn_encode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->shaderSubgroupExtendedTypes);
}

static inline void
vn_encode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES });
    vn_encode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->shaderSubgroupExtendedTypes);
}

static inline void
vn_decode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->shaderSubgroupExtendedTypes */
}

static inline void
vn_decode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_handle_self(VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->shaderSubgroupExtendedTypes */
}

static inline void
vn_replace_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_handle(VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES:
            vn_replace_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_handle_self((VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceSamplerYcbcrConversionFeatures chain */

static inline void
vn_encode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceSamplerYcbcrConversionFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->samplerYcbcrConversion);
}

static inline void
vn_encode_VkPhysicalDeviceSamplerYcbcrConversionFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceSamplerYcbcrConversionFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES });
    vn_encode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceSamplerYcbcrConversionFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->samplerYcbcrConversion);
}

static inline void
vn_decode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceSamplerYcbcrConversionFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceSamplerYcbcrConversionFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->samplerYcbcrConversion */
}

static inline void
vn_decode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceSamplerYcbcrConversionFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceSamplerYcbcrConversionFeatures_handle_self(VkPhysicalDeviceSamplerYcbcrConversionFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->samplerYcbcrConversion */
}

static inline void
vn_replace_VkPhysicalDeviceSamplerYcbcrConversionFeatures_handle(VkPhysicalDeviceSamplerYcbcrConversionFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES:
            vn_replace_VkPhysicalDeviceSamplerYcbcrConversionFeatures_handle_self((VkPhysicalDeviceSamplerYcbcrConversionFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceProtectedMemoryFeatures chain */

static inline void
vn_encode_VkPhysicalDeviceProtectedMemoryFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceProtectedMemoryFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceProtectedMemoryFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->protectedMemory);
}

static inline void
vn_encode_VkPhysicalDeviceProtectedMemoryFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceProtectedMemoryFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES });
    vn_encode_VkPhysicalDeviceProtectedMemoryFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceProtectedMemoryFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceProtectedMemoryFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceProtectedMemoryFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceProtectedMemoryFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->protectedMemory);
}

static inline void
vn_decode_VkPhysicalDeviceProtectedMemoryFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceProtectedMemoryFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceProtectedMemoryFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceProtectedMemoryFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceProtectedMemoryFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceProtectedMemoryFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceProtectedMemoryFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->protectedMemory */
}

static inline void
vn_decode_VkPhysicalDeviceProtectedMemoryFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceProtectedMemoryFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceProtectedMemoryFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceProtectedMemoryFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceProtectedMemoryFeatures_handle_self(VkPhysicalDeviceProtectedMemoryFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->protectedMemory */
}

static inline void
vn_replace_VkPhysicalDeviceProtectedMemoryFeatures_handle(VkPhysicalDeviceProtectedMemoryFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES:
            vn_replace_VkPhysicalDeviceProtectedMemoryFeatures_handle_self((VkPhysicalDeviceProtectedMemoryFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceMultiDrawFeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceMultiDrawFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceMultiDrawFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceMultiDrawFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->multiDraw);
}

static inline void
vn_encode_VkPhysicalDeviceMultiDrawFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceMultiDrawFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceMultiDrawFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceMultiDrawFeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceMultiDrawFeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceMultiDrawFeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMultiDrawFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->multiDraw);
}

static inline void
vn_decode_VkPhysicalDeviceMultiDrawFeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMultiDrawFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceMultiDrawFeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceMultiDrawFeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceMultiDrawFeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceMultiDrawFeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMultiDrawFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->multiDraw */
}

static inline void
vn_decode_VkPhysicalDeviceMultiDrawFeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMultiDrawFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceMultiDrawFeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceMultiDrawFeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceMultiDrawFeaturesEXT_handle_self(VkPhysicalDeviceMultiDrawFeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->multiDraw */
}

static inline void
vn_replace_VkPhysicalDeviceMultiDrawFeaturesEXT_handle(VkPhysicalDeviceMultiDrawFeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceMultiDrawFeaturesEXT_handle_self((VkPhysicalDeviceMultiDrawFeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceInlineUniformBlockFeatures chain */

static inline void
vn_encode_VkPhysicalDeviceInlineUniformBlockFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceInlineUniformBlockFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceInlineUniformBlockFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->inlineUniformBlock);
    vn_encode_VkBool32(enc, &val->descriptorBindingInlineUniformBlockUpdateAfterBind);
}

static inline void
vn_encode_VkPhysicalDeviceInlineUniformBlockFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceInlineUniformBlockFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES });
    vn_encode_VkPhysicalDeviceInlineUniformBlockFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceInlineUniformBlockFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceInlineUniformBlockFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceInlineUniformBlockFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceInlineUniformBlockFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->inlineUniformBlock);
    vn_decode_VkBool32(dec, &val->descriptorBindingInlineUniformBlockUpdateAfterBind);
}

static inline void
vn_decode_VkPhysicalDeviceInlineUniformBlockFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceInlineUniformBlockFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceInlineUniformBlockFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceInlineUniformBlockFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceInlineUniformBlockFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceInlineUniformBlockFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceInlineUniformBlockFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->inlineUniformBlock */
    /* skip val->descriptorBindingInlineUniformBlockUpdateAfterBind */
}

static inline void
vn_decode_VkPhysicalDeviceInlineUniformBlockFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceInlineUniformBlockFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceInlineUniformBlockFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceInlineUniformBlockFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceInlineUniformBlockFeatures_handle_self(VkPhysicalDeviceInlineUniformBlockFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->inlineUniformBlock */
    /* skip val->descriptorBindingInlineUniformBlockUpdateAfterBind */
}

static inline void
vn_replace_VkPhysicalDeviceInlineUniformBlockFeatures_handle(VkPhysicalDeviceInlineUniformBlockFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES:
            vn_replace_VkPhysicalDeviceInlineUniformBlockFeatures_handle_self((VkPhysicalDeviceInlineUniformBlockFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceMaintenance4Features chain */

static inline void
vn_encode_VkPhysicalDeviceMaintenance4Features_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceMaintenance4Features_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceMaintenance4Features *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->maintenance4);
}

static inline void
vn_encode_VkPhysicalDeviceMaintenance4Features(struct vn_cs_encoder *enc, const VkPhysicalDeviceMaintenance4Features *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES });
    vn_encode_VkPhysicalDeviceMaintenance4Features_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceMaintenance4Features_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceMaintenance4Features_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceMaintenance4Features_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMaintenance4Features *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->maintenance4);
}

static inline void
vn_decode_VkPhysicalDeviceMaintenance4Features_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMaintenance4Features *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceMaintenance4Features_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceMaintenance4Features_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceMaintenance4Features_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceMaintenance4Features_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMaintenance4Features *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->maintenance4 */
}

static inline void
vn_decode_VkPhysicalDeviceMaintenance4Features_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMaintenance4Features *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceMaintenance4Features_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceMaintenance4Features_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceMaintenance4Features_handle_self(VkPhysicalDeviceMaintenance4Features *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->maintenance4 */
}

static inline void
vn_replace_VkPhysicalDeviceMaintenance4Features_handle(VkPhysicalDeviceMaintenance4Features *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES:
            vn_replace_VkPhysicalDeviceMaintenance4Features_handle_self((VkPhysicalDeviceMaintenance4Features *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceShaderDrawParametersFeatures chain */

static inline void
vn_encode_VkPhysicalDeviceShaderDrawParametersFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceShaderDrawParametersFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderDrawParametersFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->shaderDrawParameters);
}

static inline void
vn_encode_VkPhysicalDeviceShaderDrawParametersFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderDrawParametersFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES });
    vn_encode_VkPhysicalDeviceShaderDrawParametersFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceShaderDrawParametersFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceShaderDrawParametersFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceShaderDrawParametersFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderDrawParametersFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->shaderDrawParameters);
}

static inline void
vn_decode_VkPhysicalDeviceShaderDrawParametersFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderDrawParametersFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceShaderDrawParametersFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceShaderDrawParametersFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceShaderDrawParametersFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceShaderDrawParametersFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderDrawParametersFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->shaderDrawParameters */
}

static inline void
vn_decode_VkPhysicalDeviceShaderDrawParametersFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderDrawParametersFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceShaderDrawParametersFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceShaderDrawParametersFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceShaderDrawParametersFeatures_handle_self(VkPhysicalDeviceShaderDrawParametersFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->shaderDrawParameters */
}

static inline void
vn_replace_VkPhysicalDeviceShaderDrawParametersFeatures_handle(VkPhysicalDeviceShaderDrawParametersFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES:
            vn_replace_VkPhysicalDeviceShaderDrawParametersFeatures_handle_self((VkPhysicalDeviceShaderDrawParametersFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceShaderFloat16Int8Features chain */

static inline void
vn_encode_VkPhysicalDeviceShaderFloat16Int8Features_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceShaderFloat16Int8Features_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderFloat16Int8Features *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->shaderFloat16);
    vn_encode_VkBool32(enc, &val->shaderInt8);
}

static inline void
vn_encode_VkPhysicalDeviceShaderFloat16Int8Features(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderFloat16Int8Features *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES });
    vn_encode_VkPhysicalDeviceShaderFloat16Int8Features_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceShaderFloat16Int8Features_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceShaderFloat16Int8Features_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceShaderFloat16Int8Features_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderFloat16Int8Features *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->shaderFloat16);
    vn_decode_VkBool32(dec, &val->shaderInt8);
}

static inline void
vn_decode_VkPhysicalDeviceShaderFloat16Int8Features_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderFloat16Int8Features *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceShaderFloat16Int8Features_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceShaderFloat16Int8Features_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceShaderFloat16Int8Features_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceShaderFloat16Int8Features_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderFloat16Int8Features *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->shaderFloat16 */
    /* skip val->shaderInt8 */
}

static inline void
vn_decode_VkPhysicalDeviceShaderFloat16Int8Features_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderFloat16Int8Features *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceShaderFloat16Int8Features_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceShaderFloat16Int8Features_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceShaderFloat16Int8Features_handle_self(VkPhysicalDeviceShaderFloat16Int8Features *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->shaderFloat16 */
    /* skip val->shaderInt8 */
}

static inline void
vn_replace_VkPhysicalDeviceShaderFloat16Int8Features_handle(VkPhysicalDeviceShaderFloat16Int8Features *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES:
            vn_replace_VkPhysicalDeviceShaderFloat16Int8Features_handle_self((VkPhysicalDeviceShaderFloat16Int8Features *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceHostQueryResetFeatures chain */

static inline void
vn_encode_VkPhysicalDeviceHostQueryResetFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceHostQueryResetFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceHostQueryResetFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->hostQueryReset);
}

static inline void
vn_encode_VkPhysicalDeviceHostQueryResetFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceHostQueryResetFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES });
    vn_encode_VkPhysicalDeviceHostQueryResetFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceHostQueryResetFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceHostQueryResetFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceHostQueryResetFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceHostQueryResetFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->hostQueryReset);
}

static inline void
vn_decode_VkPhysicalDeviceHostQueryResetFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceHostQueryResetFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceHostQueryResetFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceHostQueryResetFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceHostQueryResetFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceHostQueryResetFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceHostQueryResetFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->hostQueryReset */
}

static inline void
vn_decode_VkPhysicalDeviceHostQueryResetFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceHostQueryResetFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceHostQueryResetFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceHostQueryResetFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceHostQueryResetFeatures_handle_self(VkPhysicalDeviceHostQueryResetFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->hostQueryReset */
}

static inline void
vn_replace_VkPhysicalDeviceHostQueryResetFeatures_handle(VkPhysicalDeviceHostQueryResetFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES:
            vn_replace_VkPhysicalDeviceHostQueryResetFeatures_handle_self((VkPhysicalDeviceHostQueryResetFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceDescriptorIndexingFeatures chain */

static inline void
vn_encode_VkPhysicalDeviceDescriptorIndexingFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceDescriptorIndexingFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceDescriptorIndexingFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->shaderInputAttachmentArrayDynamicIndexing);
    vn_encode_VkBool32(enc, &val->shaderUniformTexelBufferArrayDynamicIndexing);
    vn_encode_VkBool32(enc, &val->shaderStorageTexelBufferArrayDynamicIndexing);
    vn_encode_VkBool32(enc, &val->shaderUniformBufferArrayNonUniformIndexing);
    vn_encode_VkBool32(enc, &val->shaderSampledImageArrayNonUniformIndexing);
    vn_encode_VkBool32(enc, &val->shaderStorageBufferArrayNonUniformIndexing);
    vn_encode_VkBool32(enc, &val->shaderStorageImageArrayNonUniformIndexing);
    vn_encode_VkBool32(enc, &val->shaderInputAttachmentArrayNonUniformIndexing);
    vn_encode_VkBool32(enc, &val->shaderUniformTexelBufferArrayNonUniformIndexing);
    vn_encode_VkBool32(enc, &val->shaderStorageTexelBufferArrayNonUniformIndexing);
    vn_encode_VkBool32(enc, &val->descriptorBindingUniformBufferUpdateAfterBind);
    vn_encode_VkBool32(enc, &val->descriptorBindingSampledImageUpdateAfterBind);
    vn_encode_VkBool32(enc, &val->descriptorBindingStorageImageUpdateAfterBind);
    vn_encode_VkBool32(enc, &val->descriptorBindingStorageBufferUpdateAfterBind);
    vn_encode_VkBool32(enc, &val->descriptorBindingUniformTexelBufferUpdateAfterBind);
    vn_encode_VkBool32(enc, &val->descriptorBindingStorageTexelBufferUpdateAfterBind);
    vn_encode_VkBool32(enc, &val->descriptorBindingUpdateUnusedWhilePending);
    vn_encode_VkBool32(enc, &val->descriptorBindingPartiallyBound);
    vn_encode_VkBool32(enc, &val->descriptorBindingVariableDescriptorCount);
    vn_encode_VkBool32(enc, &val->runtimeDescriptorArray);
}

static inline void
vn_encode_VkPhysicalDeviceDescriptorIndexingFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceDescriptorIndexingFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES });
    vn_encode_VkPhysicalDeviceDescriptorIndexingFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceDescriptorIndexingFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceDescriptorIndexingFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceDescriptorIndexingFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDescriptorIndexingFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->shaderInputAttachmentArrayDynamicIndexing);
    vn_decode_VkBool32(dec, &val->shaderUniformTexelBufferArrayDynamicIndexing);
    vn_decode_VkBool32(dec, &val->shaderStorageTexelBufferArrayDynamicIndexing);
    vn_decode_VkBool32(dec, &val->shaderUniformBufferArrayNonUniformIndexing);
    vn_decode_VkBool32(dec, &val->shaderSampledImageArrayNonUniformIndexing);
    vn_decode_VkBool32(dec, &val->shaderStorageBufferArrayNonUniformIndexing);
    vn_decode_VkBool32(dec, &val->shaderStorageImageArrayNonUniformIndexing);
    vn_decode_VkBool32(dec, &val->shaderInputAttachmentArrayNonUniformIndexing);
    vn_decode_VkBool32(dec, &val->shaderUniformTexelBufferArrayNonUniformIndexing);
    vn_decode_VkBool32(dec, &val->shaderStorageTexelBufferArrayNonUniformIndexing);
    vn_decode_VkBool32(dec, &val->descriptorBindingUniformBufferUpdateAfterBind);
    vn_decode_VkBool32(dec, &val->descriptorBindingSampledImageUpdateAfterBind);
    vn_decode_VkBool32(dec, &val->descriptorBindingStorageImageUpdateAfterBind);
    vn_decode_VkBool32(dec, &val->descriptorBindingStorageBufferUpdateAfterBind);
    vn_decode_VkBool32(dec, &val->descriptorBindingUniformTexelBufferUpdateAfterBind);
    vn_decode_VkBool32(dec, &val->descriptorBindingStorageTexelBufferUpdateAfterBind);
    vn_decode_VkBool32(dec, &val->descriptorBindingUpdateUnusedWhilePending);
    vn_decode_VkBool32(dec, &val->descriptorBindingPartiallyBound);
    vn_decode_VkBool32(dec, &val->descriptorBindingVariableDescriptorCount);
    vn_decode_VkBool32(dec, &val->runtimeDescriptorArray);
}

static inline void
vn_decode_VkPhysicalDeviceDescriptorIndexingFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDescriptorIndexingFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceDescriptorIndexingFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceDescriptorIndexingFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceDescriptorIndexingFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceDescriptorIndexingFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDescriptorIndexingFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->shaderInputAttachmentArrayDynamicIndexing */
    /* skip val->shaderUniformTexelBufferArrayDynamicIndexing */
    /* skip val->shaderStorageTexelBufferArrayDynamicIndexing */
    /* skip val->shaderUniformBufferArrayNonUniformIndexing */
    /* skip val->shaderSampledImageArrayNonUniformIndexing */
    /* skip val->shaderStorageBufferArrayNonUniformIndexing */
    /* skip val->shaderStorageImageArrayNonUniformIndexing */
    /* skip val->shaderInputAttachmentArrayNonUniformIndexing */
    /* skip val->shaderUniformTexelBufferArrayNonUniformIndexing */
    /* skip val->shaderStorageTexelBufferArrayNonUniformIndexing */
    /* skip val->descriptorBindingUniformBufferUpdateAfterBind */
    /* skip val->descriptorBindingSampledImageUpdateAfterBind */
    /* skip val->descriptorBindingStorageImageUpdateAfterBind */
    /* skip val->descriptorBindingStorageBufferUpdateAfterBind */
    /* skip val->descriptorBindingUniformTexelBufferUpdateAfterBind */
    /* skip val->descriptorBindingStorageTexelBufferUpdateAfterBind */
    /* skip val->descriptorBindingUpdateUnusedWhilePending */
    /* skip val->descriptorBindingPartiallyBound */
    /* skip val->descriptorBindingVariableDescriptorCount */
    /* skip val->runtimeDescriptorArray */
}

static inline void
vn_decode_VkPhysicalDeviceDescriptorIndexingFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDescriptorIndexingFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceDescriptorIndexingFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceDescriptorIndexingFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceDescriptorIndexingFeatures_handle_self(VkPhysicalDeviceDescriptorIndexingFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->shaderInputAttachmentArrayDynamicIndexing */
    /* skip val->shaderUniformTexelBufferArrayDynamicIndexing */
    /* skip val->shaderStorageTexelBufferArrayDynamicIndexing */
    /* skip val->shaderUniformBufferArrayNonUniformIndexing */
    /* skip val->shaderSampledImageArrayNonUniformIndexing */
    /* skip val->shaderStorageBufferArrayNonUniformIndexing */
    /* skip val->shaderStorageImageArrayNonUniformIndexing */
    /* skip val->shaderInputAttachmentArrayNonUniformIndexing */
    /* skip val->shaderUniformTexelBufferArrayNonUniformIndexing */
    /* skip val->shaderStorageTexelBufferArrayNonUniformIndexing */
    /* skip val->descriptorBindingUniformBufferUpdateAfterBind */
    /* skip val->descriptorBindingSampledImageUpdateAfterBind */
    /* skip val->descriptorBindingStorageImageUpdateAfterBind */
    /* skip val->descriptorBindingStorageBufferUpdateAfterBind */
    /* skip val->descriptorBindingUniformTexelBufferUpdateAfterBind */
    /* skip val->descriptorBindingStorageTexelBufferUpdateAfterBind */
    /* skip val->descriptorBindingUpdateUnusedWhilePending */
    /* skip val->descriptorBindingPartiallyBound */
    /* skip val->descriptorBindingVariableDescriptorCount */
    /* skip val->runtimeDescriptorArray */
}

static inline void
vn_replace_VkPhysicalDeviceDescriptorIndexingFeatures_handle(VkPhysicalDeviceDescriptorIndexingFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES:
            vn_replace_VkPhysicalDeviceDescriptorIndexingFeatures_handle_self((VkPhysicalDeviceDescriptorIndexingFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceTimelineSemaphoreFeatures chain */

static inline void
vn_encode_VkPhysicalDeviceTimelineSemaphoreFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceTimelineSemaphoreFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceTimelineSemaphoreFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->timelineSemaphore);
}

static inline void
vn_encode_VkPhysicalDeviceTimelineSemaphoreFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceTimelineSemaphoreFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES });
    vn_encode_VkPhysicalDeviceTimelineSemaphoreFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceTimelineSemaphoreFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceTimelineSemaphoreFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceTimelineSemaphoreFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceTimelineSemaphoreFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->timelineSemaphore);
}

static inline void
vn_decode_VkPhysicalDeviceTimelineSemaphoreFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceTimelineSemaphoreFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceTimelineSemaphoreFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceTimelineSemaphoreFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceTimelineSemaphoreFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceTimelineSemaphoreFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceTimelineSemaphoreFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->timelineSemaphore */
}

static inline void
vn_decode_VkPhysicalDeviceTimelineSemaphoreFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceTimelineSemaphoreFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceTimelineSemaphoreFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceTimelineSemaphoreFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceTimelineSemaphoreFeatures_handle_self(VkPhysicalDeviceTimelineSemaphoreFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->timelineSemaphore */
}

static inline void
vn_replace_VkPhysicalDeviceTimelineSemaphoreFeatures_handle(VkPhysicalDeviceTimelineSemaphoreFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES:
            vn_replace_VkPhysicalDeviceTimelineSemaphoreFeatures_handle_self((VkPhysicalDeviceTimelineSemaphoreFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDevice8BitStorageFeatures chain */

static inline void
vn_encode_VkPhysicalDevice8BitStorageFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDevice8BitStorageFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDevice8BitStorageFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->storageBuffer8BitAccess);
    vn_encode_VkBool32(enc, &val->uniformAndStorageBuffer8BitAccess);
    vn_encode_VkBool32(enc, &val->storagePushConstant8);
}

static inline void
vn_encode_VkPhysicalDevice8BitStorageFeatures(struct vn_cs_encoder *enc, const VkPhysicalDevice8BitStorageFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES });
    vn_encode_VkPhysicalDevice8BitStorageFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDevice8BitStorageFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDevice8BitStorageFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDevice8BitStorageFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDevice8BitStorageFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->storageBuffer8BitAccess);
    vn_decode_VkBool32(dec, &val->uniformAndStorageBuffer8BitAccess);
    vn_decode_VkBool32(dec, &val->storagePushConstant8);
}

static inline void
vn_decode_VkPhysicalDevice8BitStorageFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDevice8BitStorageFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDevice8BitStorageFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDevice8BitStorageFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDevice8BitStorageFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDevice8BitStorageFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDevice8BitStorageFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->storageBuffer8BitAccess */
    /* skip val->uniformAndStorageBuffer8BitAccess */
    /* skip val->storagePushConstant8 */
}

static inline void
vn_decode_VkPhysicalDevice8BitStorageFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDevice8BitStorageFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDevice8BitStorageFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDevice8BitStorageFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDevice8BitStorageFeatures_handle_self(VkPhysicalDevice8BitStorageFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->storageBuffer8BitAccess */
    /* skip val->uniformAndStorageBuffer8BitAccess */
    /* skip val->storagePushConstant8 */
}

static inline void
vn_replace_VkPhysicalDevice8BitStorageFeatures_handle(VkPhysicalDevice8BitStorageFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES:
            vn_replace_VkPhysicalDevice8BitStorageFeatures_handle_self((VkPhysicalDevice8BitStorageFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceConditionalRenderingFeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceConditionalRenderingFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceConditionalRenderingFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceConditionalRenderingFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->conditionalRendering);
    vn_encode_VkBool32(enc, &val->inheritedConditionalRendering);
}

static inline void
vn_encode_VkPhysicalDeviceConditionalRenderingFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceConditionalRenderingFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONDITIONAL_RENDERING_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONDITIONAL_RENDERING_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceConditionalRenderingFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceConditionalRenderingFeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceConditionalRenderingFeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceConditionalRenderingFeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceConditionalRenderingFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->conditionalRendering);
    vn_decode_VkBool32(dec, &val->inheritedConditionalRendering);
}

static inline void
vn_decode_VkPhysicalDeviceConditionalRenderingFeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceConditionalRenderingFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONDITIONAL_RENDERING_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceConditionalRenderingFeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceConditionalRenderingFeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceConditionalRenderingFeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceConditionalRenderingFeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceConditionalRenderingFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->conditionalRendering */
    /* skip val->inheritedConditionalRendering */
}

static inline void
vn_decode_VkPhysicalDeviceConditionalRenderingFeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceConditionalRenderingFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONDITIONAL_RENDERING_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceConditionalRenderingFeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceConditionalRenderingFeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceConditionalRenderingFeaturesEXT_handle_self(VkPhysicalDeviceConditionalRenderingFeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->conditionalRendering */
    /* skip val->inheritedConditionalRendering */
}

static inline void
vn_replace_VkPhysicalDeviceConditionalRenderingFeaturesEXT_handle(VkPhysicalDeviceConditionalRenderingFeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONDITIONAL_RENDERING_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceConditionalRenderingFeaturesEXT_handle_self((VkPhysicalDeviceConditionalRenderingFeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceVulkanMemoryModelFeatures chain */

static inline void
vn_encode_VkPhysicalDeviceVulkanMemoryModelFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceVulkanMemoryModelFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkanMemoryModelFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->vulkanMemoryModel);
    vn_encode_VkBool32(enc, &val->vulkanMemoryModelDeviceScope);
    vn_encode_VkBool32(enc, &val->vulkanMemoryModelAvailabilityVisibilityChains);
}

static inline void
vn_encode_VkPhysicalDeviceVulkanMemoryModelFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkanMemoryModelFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES });
    vn_encode_VkPhysicalDeviceVulkanMemoryModelFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceVulkanMemoryModelFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceVulkanMemoryModelFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceVulkanMemoryModelFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkanMemoryModelFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->vulkanMemoryModel);
    vn_decode_VkBool32(dec, &val->vulkanMemoryModelDeviceScope);
    vn_decode_VkBool32(dec, &val->vulkanMemoryModelAvailabilityVisibilityChains);
}

static inline void
vn_decode_VkPhysicalDeviceVulkanMemoryModelFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkanMemoryModelFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceVulkanMemoryModelFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceVulkanMemoryModelFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceVulkanMemoryModelFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceVulkanMemoryModelFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkanMemoryModelFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->vulkanMemoryModel */
    /* skip val->vulkanMemoryModelDeviceScope */
    /* skip val->vulkanMemoryModelAvailabilityVisibilityChains */
}

static inline void
vn_decode_VkPhysicalDeviceVulkanMemoryModelFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkanMemoryModelFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceVulkanMemoryModelFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceVulkanMemoryModelFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceVulkanMemoryModelFeatures_handle_self(VkPhysicalDeviceVulkanMemoryModelFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->vulkanMemoryModel */
    /* skip val->vulkanMemoryModelDeviceScope */
    /* skip val->vulkanMemoryModelAvailabilityVisibilityChains */
}

static inline void
vn_replace_VkPhysicalDeviceVulkanMemoryModelFeatures_handle(VkPhysicalDeviceVulkanMemoryModelFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES:
            vn_replace_VkPhysicalDeviceVulkanMemoryModelFeatures_handle_self((VkPhysicalDeviceVulkanMemoryModelFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceShaderAtomicInt64Features chain */

static inline void
vn_encode_VkPhysicalDeviceShaderAtomicInt64Features_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceShaderAtomicInt64Features_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderAtomicInt64Features *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->shaderBufferInt64Atomics);
    vn_encode_VkBool32(enc, &val->shaderSharedInt64Atomics);
}

static inline void
vn_encode_VkPhysicalDeviceShaderAtomicInt64Features(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderAtomicInt64Features *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES });
    vn_encode_VkPhysicalDeviceShaderAtomicInt64Features_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceShaderAtomicInt64Features_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceShaderAtomicInt64Features_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceShaderAtomicInt64Features_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderAtomicInt64Features *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->shaderBufferInt64Atomics);
    vn_decode_VkBool32(dec, &val->shaderSharedInt64Atomics);
}

static inline void
vn_decode_VkPhysicalDeviceShaderAtomicInt64Features_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderAtomicInt64Features *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceShaderAtomicInt64Features_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceShaderAtomicInt64Features_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceShaderAtomicInt64Features_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceShaderAtomicInt64Features_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderAtomicInt64Features *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->shaderBufferInt64Atomics */
    /* skip val->shaderSharedInt64Atomics */
}

static inline void
vn_decode_VkPhysicalDeviceShaderAtomicInt64Features_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderAtomicInt64Features *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceShaderAtomicInt64Features_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceShaderAtomicInt64Features_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceShaderAtomicInt64Features_handle_self(VkPhysicalDeviceShaderAtomicInt64Features *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->shaderBufferInt64Atomics */
    /* skip val->shaderSharedInt64Atomics */
}

static inline void
vn_replace_VkPhysicalDeviceShaderAtomicInt64Features_handle(VkPhysicalDeviceShaderAtomicInt64Features *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES:
            vn_replace_VkPhysicalDeviceShaderAtomicInt64Features_handle_self((VkPhysicalDeviceShaderAtomicInt64Features *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->vertexAttributeInstanceRateDivisor);
    vn_encode_VkBool32(enc, &val->vertexAttributeInstanceRateZeroDivisor);
}

static inline void
vn_encode_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->vertexAttributeInstanceRateDivisor);
    vn_decode_VkBool32(dec, &val->vertexAttributeInstanceRateZeroDivisor);
}

static inline void
vn_decode_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->vertexAttributeInstanceRateDivisor */
    /* skip val->vertexAttributeInstanceRateZeroDivisor */
}

static inline void
vn_decode_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT_handle_self(VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->vertexAttributeInstanceRateDivisor */
    /* skip val->vertexAttributeInstanceRateZeroDivisor */
}

static inline void
vn_replace_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT_handle(VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT_handle_self((VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceTransformFeedbackFeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceTransformFeedbackFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->transformFeedback);
    vn_encode_VkBool32(enc, &val->geometryStreams);
}

static inline void
vn_encode_VkPhysicalDeviceTransformFeedbackFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceTransformFeedbackFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceTransformFeedbackFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->transformFeedback);
    vn_decode_VkBool32(dec, &val->geometryStreams);
}

static inline void
vn_decode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceTransformFeedbackFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceTransformFeedbackFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->transformFeedback */
    /* skip val->geometryStreams */
}

static inline void
vn_decode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceTransformFeedbackFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceTransformFeedbackFeaturesEXT_handle_self(VkPhysicalDeviceTransformFeedbackFeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->transformFeedback */
    /* skip val->geometryStreams */
}

static inline void
vn_replace_VkPhysicalDeviceTransformFeedbackFeaturesEXT_handle(VkPhysicalDeviceTransformFeedbackFeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceTransformFeedbackFeaturesEXT_handle_self((VkPhysicalDeviceTransformFeedbackFeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceScalarBlockLayoutFeatures chain */

static inline void
vn_encode_VkPhysicalDeviceScalarBlockLayoutFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceScalarBlockLayoutFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceScalarBlockLayoutFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->scalarBlockLayout);
}

static inline void
vn_encode_VkPhysicalDeviceScalarBlockLayoutFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceScalarBlockLayoutFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES });
    vn_encode_VkPhysicalDeviceScalarBlockLayoutFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceScalarBlockLayoutFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceScalarBlockLayoutFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceScalarBlockLayoutFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceScalarBlockLayoutFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->scalarBlockLayout);
}

static inline void
vn_decode_VkPhysicalDeviceScalarBlockLayoutFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceScalarBlockLayoutFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceScalarBlockLayoutFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceScalarBlockLayoutFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceScalarBlockLayoutFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceScalarBlockLayoutFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceScalarBlockLayoutFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->scalarBlockLayout */
}

static inline void
vn_decode_VkPhysicalDeviceScalarBlockLayoutFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceScalarBlockLayoutFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceScalarBlockLayoutFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceScalarBlockLayoutFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceScalarBlockLayoutFeatures_handle_self(VkPhysicalDeviceScalarBlockLayoutFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->scalarBlockLayout */
}

static inline void
vn_replace_VkPhysicalDeviceScalarBlockLayoutFeatures_handle(VkPhysicalDeviceScalarBlockLayoutFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES:
            vn_replace_VkPhysicalDeviceScalarBlockLayoutFeatures_handle_self((VkPhysicalDeviceScalarBlockLayoutFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceUniformBufferStandardLayoutFeatures chain */

static inline void
vn_encode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceUniformBufferStandardLayoutFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->uniformBufferStandardLayout);
}

static inline void
vn_encode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceUniformBufferStandardLayoutFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES });
    vn_encode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceUniformBufferStandardLayoutFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->uniformBufferStandardLayout);
}

static inline void
vn_decode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceUniformBufferStandardLayoutFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceUniformBufferStandardLayoutFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->uniformBufferStandardLayout */
}

static inline void
vn_decode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceUniformBufferStandardLayoutFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_handle_self(VkPhysicalDeviceUniformBufferStandardLayoutFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->uniformBufferStandardLayout */
}

static inline void
vn_replace_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_handle(VkPhysicalDeviceUniformBufferStandardLayoutFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES:
            vn_replace_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_handle_self((VkPhysicalDeviceUniformBufferStandardLayoutFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceDepthClipEnableFeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceDepthClipEnableFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceDepthClipEnableFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceDepthClipEnableFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->depthClipEnable);
}

static inline void
vn_encode_VkPhysicalDeviceDepthClipEnableFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceDepthClipEnableFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_ENABLE_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_ENABLE_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceDepthClipEnableFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceDepthClipEnableFeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceDepthClipEnableFeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceDepthClipEnableFeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDepthClipEnableFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->depthClipEnable);
}

static inline void
vn_decode_VkPhysicalDeviceDepthClipEnableFeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDepthClipEnableFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_ENABLE_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceDepthClipEnableFeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceDepthClipEnableFeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceDepthClipEnableFeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceDepthClipEnableFeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDepthClipEnableFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->depthClipEnable */
}

static inline void
vn_decode_VkPhysicalDeviceDepthClipEnableFeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDepthClipEnableFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_ENABLE_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceDepthClipEnableFeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceDepthClipEnableFeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceDepthClipEnableFeaturesEXT_handle_self(VkPhysicalDeviceDepthClipEnableFeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->depthClipEnable */
}

static inline void
vn_replace_VkPhysicalDeviceDepthClipEnableFeaturesEXT_handle(VkPhysicalDeviceDepthClipEnableFeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_ENABLE_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceDepthClipEnableFeaturesEXT_handle_self((VkPhysicalDeviceDepthClipEnableFeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceBufferDeviceAddressFeatures chain */

static inline void
vn_encode_VkPhysicalDeviceBufferDeviceAddressFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceBufferDeviceAddressFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceBufferDeviceAddressFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->bufferDeviceAddress);
    vn_encode_VkBool32(enc, &val->bufferDeviceAddressCaptureReplay);
    vn_encode_VkBool32(enc, &val->bufferDeviceAddressMultiDevice);
}

static inline void
vn_encode_VkPhysicalDeviceBufferDeviceAddressFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceBufferDeviceAddressFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES });
    vn_encode_VkPhysicalDeviceBufferDeviceAddressFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceBufferDeviceAddressFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceBufferDeviceAddressFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceBufferDeviceAddressFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceBufferDeviceAddressFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->bufferDeviceAddress);
    vn_decode_VkBool32(dec, &val->bufferDeviceAddressCaptureReplay);
    vn_decode_VkBool32(dec, &val->bufferDeviceAddressMultiDevice);
}

static inline void
vn_decode_VkPhysicalDeviceBufferDeviceAddressFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceBufferDeviceAddressFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceBufferDeviceAddressFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceBufferDeviceAddressFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceBufferDeviceAddressFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceBufferDeviceAddressFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceBufferDeviceAddressFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->bufferDeviceAddress */
    /* skip val->bufferDeviceAddressCaptureReplay */
    /* skip val->bufferDeviceAddressMultiDevice */
}

static inline void
vn_decode_VkPhysicalDeviceBufferDeviceAddressFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceBufferDeviceAddressFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceBufferDeviceAddressFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceBufferDeviceAddressFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceBufferDeviceAddressFeatures_handle_self(VkPhysicalDeviceBufferDeviceAddressFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->bufferDeviceAddress */
    /* skip val->bufferDeviceAddressCaptureReplay */
    /* skip val->bufferDeviceAddressMultiDevice */
}

static inline void
vn_replace_VkPhysicalDeviceBufferDeviceAddressFeatures_handle(VkPhysicalDeviceBufferDeviceAddressFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES:
            vn_replace_VkPhysicalDeviceBufferDeviceAddressFeatures_handle_self((VkPhysicalDeviceBufferDeviceAddressFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceImagelessFramebufferFeatures chain */

static inline void
vn_encode_VkPhysicalDeviceImagelessFramebufferFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceImagelessFramebufferFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceImagelessFramebufferFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->imagelessFramebuffer);
}

static inline void
vn_encode_VkPhysicalDeviceImagelessFramebufferFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceImagelessFramebufferFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES });
    vn_encode_VkPhysicalDeviceImagelessFramebufferFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceImagelessFramebufferFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceImagelessFramebufferFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceImagelessFramebufferFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceImagelessFramebufferFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->imagelessFramebuffer);
}

static inline void
vn_decode_VkPhysicalDeviceImagelessFramebufferFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceImagelessFramebufferFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceImagelessFramebufferFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceImagelessFramebufferFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceImagelessFramebufferFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceImagelessFramebufferFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceImagelessFramebufferFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->imagelessFramebuffer */
}

static inline void
vn_decode_VkPhysicalDeviceImagelessFramebufferFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceImagelessFramebufferFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceImagelessFramebufferFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceImagelessFramebufferFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceImagelessFramebufferFeatures_handle_self(VkPhysicalDeviceImagelessFramebufferFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->imagelessFramebuffer */
}

static inline void
vn_replace_VkPhysicalDeviceImagelessFramebufferFeatures_handle(VkPhysicalDeviceImagelessFramebufferFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES:
            vn_replace_VkPhysicalDeviceImagelessFramebufferFeatures_handle_self((VkPhysicalDeviceImagelessFramebufferFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceTextureCompressionASTCHDRFeatures chain */

static inline void
vn_encode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceTextureCompressionASTCHDRFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->textureCompressionASTC_HDR);
}

static inline void
vn_encode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceTextureCompressionASTCHDRFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES });
    vn_encode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceTextureCompressionASTCHDRFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->textureCompressionASTC_HDR);
}

static inline void
vn_decode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceTextureCompressionASTCHDRFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceTextureCompressionASTCHDRFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->textureCompressionASTC_HDR */
}

static inline void
vn_decode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceTextureCompressionASTCHDRFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_handle_self(VkPhysicalDeviceTextureCompressionASTCHDRFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->textureCompressionASTC_HDR */
}

static inline void
vn_replace_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_handle(VkPhysicalDeviceTextureCompressionASTCHDRFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES:
            vn_replace_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_handle_self((VkPhysicalDeviceTextureCompressionASTCHDRFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceShaderClockFeaturesKHR chain */

static inline void
vn_encode_VkPhysicalDeviceShaderClockFeaturesKHR_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceShaderClockFeaturesKHR_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderClockFeaturesKHR *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->shaderSubgroupClock);
    vn_encode_VkBool32(enc, &val->shaderDeviceClock);
}

static inline void
vn_encode_VkPhysicalDeviceShaderClockFeaturesKHR(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderClockFeaturesKHR *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CLOCK_FEATURES_KHR);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CLOCK_FEATURES_KHR });
    vn_encode_VkPhysicalDeviceShaderClockFeaturesKHR_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceShaderClockFeaturesKHR_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceShaderClockFeaturesKHR_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceShaderClockFeaturesKHR_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderClockFeaturesKHR *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->shaderSubgroupClock);
    vn_decode_VkBool32(dec, &val->shaderDeviceClock);
}

static inline void
vn_decode_VkPhysicalDeviceShaderClockFeaturesKHR_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderClockFeaturesKHR *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CLOCK_FEATURES_KHR)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceShaderClockFeaturesKHR_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceShaderClockFeaturesKHR_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceShaderClockFeaturesKHR_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceShaderClockFeaturesKHR_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderClockFeaturesKHR *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->shaderSubgroupClock */
    /* skip val->shaderDeviceClock */
}

static inline void
vn_decode_VkPhysicalDeviceShaderClockFeaturesKHR_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderClockFeaturesKHR *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CLOCK_FEATURES_KHR)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceShaderClockFeaturesKHR_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceShaderClockFeaturesKHR_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceShaderClockFeaturesKHR_handle_self(VkPhysicalDeviceShaderClockFeaturesKHR *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->shaderSubgroupClock */
    /* skip val->shaderDeviceClock */
}

static inline void
vn_replace_VkPhysicalDeviceShaderClockFeaturesKHR_handle(VkPhysicalDeviceShaderClockFeaturesKHR *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CLOCK_FEATURES_KHR:
            vn_replace_VkPhysicalDeviceShaderClockFeaturesKHR_handle_self((VkPhysicalDeviceShaderClockFeaturesKHR *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceIndexTypeUint8FeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceIndexTypeUint8FeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceIndexTypeUint8FeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceIndexTypeUint8FeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->indexTypeUint8);
}

static inline void
vn_encode_VkPhysicalDeviceIndexTypeUint8FeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceIndexTypeUint8FeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceIndexTypeUint8FeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceIndexTypeUint8FeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceIndexTypeUint8FeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceIndexTypeUint8FeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceIndexTypeUint8FeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->indexTypeUint8);
}

static inline void
vn_decode_VkPhysicalDeviceIndexTypeUint8FeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceIndexTypeUint8FeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceIndexTypeUint8FeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceIndexTypeUint8FeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceIndexTypeUint8FeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceIndexTypeUint8FeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceIndexTypeUint8FeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->indexTypeUint8 */
}

static inline void
vn_decode_VkPhysicalDeviceIndexTypeUint8FeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceIndexTypeUint8FeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceIndexTypeUint8FeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceIndexTypeUint8FeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceIndexTypeUint8FeaturesEXT_handle_self(VkPhysicalDeviceIndexTypeUint8FeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->indexTypeUint8 */
}

static inline void
vn_replace_VkPhysicalDeviceIndexTypeUint8FeaturesEXT_handle(VkPhysicalDeviceIndexTypeUint8FeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceIndexTypeUint8FeaturesEXT_handle_self((VkPhysicalDeviceIndexTypeUint8FeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->fragmentShaderSampleInterlock);
    vn_encode_VkBool32(enc, &val->fragmentShaderPixelInterlock);
    vn_encode_VkBool32(enc, &val->fragmentShaderShadingRateInterlock);
}

static inline void
vn_encode_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_INTERLOCK_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_INTERLOCK_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->fragmentShaderSampleInterlock);
    vn_decode_VkBool32(dec, &val->fragmentShaderPixelInterlock);
    vn_decode_VkBool32(dec, &val->fragmentShaderShadingRateInterlock);
}

static inline void
vn_decode_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_INTERLOCK_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->fragmentShaderSampleInterlock */
    /* skip val->fragmentShaderPixelInterlock */
    /* skip val->fragmentShaderShadingRateInterlock */
}

static inline void
vn_decode_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_INTERLOCK_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_handle_self(VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->fragmentShaderSampleInterlock */
    /* skip val->fragmentShaderPixelInterlock */
    /* skip val->fragmentShaderShadingRateInterlock */
}

static inline void
vn_replace_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_handle(VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_INTERLOCK_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_handle_self((VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures chain */

static inline void
vn_encode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->separateDepthStencilLayouts);
}

static inline void
vn_encode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES });
    vn_encode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->separateDepthStencilLayouts);
}

static inline void
vn_decode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->separateDepthStencilLayouts */
}

static inline void
vn_decode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_handle_self(VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->separateDepthStencilLayouts */
}

static inline void
vn_replace_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_handle(VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES:
            vn_replace_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_handle_self((VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->primitiveTopologyListRestart);
    vn_encode_VkBool32(enc, &val->primitiveTopologyPatchListRestart);
}

static inline void
vn_encode_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVE_TOPOLOGY_LIST_RESTART_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVE_TOPOLOGY_LIST_RESTART_FEATURES_EXT });
    vn_encode_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->primitiveTopologyListRestart);
    vn_decode_VkBool32(dec, &val->primitiveTopologyPatchListRestart);
}

static inline void
vn_decode_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVE_TOPOLOGY_LIST_RESTART_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->primitiveTopologyListRestart */
    /* skip val->primitiveTopologyPatchListRestart */
}

static inline void
vn_decode_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVE_TOPOLOGY_LIST_RESTART_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_handle_self(VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->primitiveTopologyListRestart */
    /* skip val->primitiveTopologyPatchListRestart */
}

static inline void
vn_replace_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_handle(VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVE_TOPOLOGY_LIST_RESTART_FEATURES_EXT:
            vn_replace_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_handle_self((VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures chain */

static inline void
vn_encode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->shaderDemoteToHelperInvocation);
}

static inline void
vn_encode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES });
    vn_encode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->shaderDemoteToHelperInvocation);
}

static inline void
vn_decode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->shaderDemoteToHelperInvocation */
}

static inline void
vn_decode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_handle_self(VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->shaderDemoteToHelperInvocation */
}

static inline void
vn_replace_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_handle(VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES:
            vn_replace_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_handle_self((VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->texelBufferAlignment);
}

static inline void
vn_encode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->texelBufferAlignment);
}

static inline void
vn_decode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->texelBufferAlignment */
}

static inline void
vn_decode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_handle_self(VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->texelBufferAlignment */
}

static inline void
vn_replace_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_handle(VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_handle_self((VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceSubgroupSizeControlFeatures chain */

static inline void
vn_encode_VkPhysicalDeviceSubgroupSizeControlFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceSubgroupSizeControlFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceSubgroupSizeControlFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->subgroupSizeControl);
    vn_encode_VkBool32(enc, &val->computeFullSubgroups);
}

static inline void
vn_encode_VkPhysicalDeviceSubgroupSizeControlFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceSubgroupSizeControlFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES });
    vn_encode_VkPhysicalDeviceSubgroupSizeControlFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceSubgroupSizeControlFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceSubgroupSizeControlFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceSubgroupSizeControlFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceSubgroupSizeControlFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->subgroupSizeControl);
    vn_decode_VkBool32(dec, &val->computeFullSubgroups);
}

static inline void
vn_decode_VkPhysicalDeviceSubgroupSizeControlFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceSubgroupSizeControlFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceSubgroupSizeControlFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceSubgroupSizeControlFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceSubgroupSizeControlFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceSubgroupSizeControlFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceSubgroupSizeControlFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->subgroupSizeControl */
    /* skip val->computeFullSubgroups */
}

static inline void
vn_decode_VkPhysicalDeviceSubgroupSizeControlFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceSubgroupSizeControlFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceSubgroupSizeControlFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceSubgroupSizeControlFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceSubgroupSizeControlFeatures_handle_self(VkPhysicalDeviceSubgroupSizeControlFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->subgroupSizeControl */
    /* skip val->computeFullSubgroups */
}

static inline void
vn_replace_VkPhysicalDeviceSubgroupSizeControlFeatures_handle(VkPhysicalDeviceSubgroupSizeControlFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES:
            vn_replace_VkPhysicalDeviceSubgroupSizeControlFeatures_handle_self((VkPhysicalDeviceSubgroupSizeControlFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceLineRasterizationFeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceLineRasterizationFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceLineRasterizationFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceLineRasterizationFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->rectangularLines);
    vn_encode_VkBool32(enc, &val->bresenhamLines);
    vn_encode_VkBool32(enc, &val->smoothLines);
    vn_encode_VkBool32(enc, &val->stippledRectangularLines);
    vn_encode_VkBool32(enc, &val->stippledBresenhamLines);
    vn_encode_VkBool32(enc, &val->stippledSmoothLines);
}

static inline void
vn_encode_VkPhysicalDeviceLineRasterizationFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceLineRasterizationFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceLineRasterizationFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceLineRasterizationFeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceLineRasterizationFeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceLineRasterizationFeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceLineRasterizationFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->rectangularLines);
    vn_decode_VkBool32(dec, &val->bresenhamLines);
    vn_decode_VkBool32(dec, &val->smoothLines);
    vn_decode_VkBool32(dec, &val->stippledRectangularLines);
    vn_decode_VkBool32(dec, &val->stippledBresenhamLines);
    vn_decode_VkBool32(dec, &val->stippledSmoothLines);
}

static inline void
vn_decode_VkPhysicalDeviceLineRasterizationFeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceLineRasterizationFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceLineRasterizationFeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceLineRasterizationFeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceLineRasterizationFeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceLineRasterizationFeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceLineRasterizationFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->rectangularLines */
    /* skip val->bresenhamLines */
    /* skip val->smoothLines */
    /* skip val->stippledRectangularLines */
    /* skip val->stippledBresenhamLines */
    /* skip val->stippledSmoothLines */
}

static inline void
vn_decode_VkPhysicalDeviceLineRasterizationFeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceLineRasterizationFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceLineRasterizationFeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceLineRasterizationFeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceLineRasterizationFeaturesEXT_handle_self(VkPhysicalDeviceLineRasterizationFeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->rectangularLines */
    /* skip val->bresenhamLines */
    /* skip val->smoothLines */
    /* skip val->stippledRectangularLines */
    /* skip val->stippledBresenhamLines */
    /* skip val->stippledSmoothLines */
}

static inline void
vn_replace_VkPhysicalDeviceLineRasterizationFeaturesEXT_handle(VkPhysicalDeviceLineRasterizationFeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceLineRasterizationFeaturesEXT_handle_self((VkPhysicalDeviceLineRasterizationFeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDevicePipelineCreationCacheControlFeatures chain */

static inline void
vn_encode_VkPhysicalDevicePipelineCreationCacheControlFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDevicePipelineCreationCacheControlFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDevicePipelineCreationCacheControlFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->pipelineCreationCacheControl);
}

static inline void
vn_encode_VkPhysicalDevicePipelineCreationCacheControlFeatures(struct vn_cs_encoder *enc, const VkPhysicalDevicePipelineCreationCacheControlFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES });
    vn_encode_VkPhysicalDevicePipelineCreationCacheControlFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDevicePipelineCreationCacheControlFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDevicePipelineCreationCacheControlFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDevicePipelineCreationCacheControlFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDevicePipelineCreationCacheControlFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->pipelineCreationCacheControl);
}

static inline void
vn_decode_VkPhysicalDevicePipelineCreationCacheControlFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDevicePipelineCreationCacheControlFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDevicePipelineCreationCacheControlFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDevicePipelineCreationCacheControlFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDevicePipelineCreationCacheControlFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDevicePipelineCreationCacheControlFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDevicePipelineCreationCacheControlFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->pipelineCreationCacheControl */
}

static inline void
vn_decode_VkPhysicalDevicePipelineCreationCacheControlFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDevicePipelineCreationCacheControlFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDevicePipelineCreationCacheControlFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDevicePipelineCreationCacheControlFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDevicePipelineCreationCacheControlFeatures_handle_self(VkPhysicalDevicePipelineCreationCacheControlFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->pipelineCreationCacheControl */
}

static inline void
vn_replace_VkPhysicalDevicePipelineCreationCacheControlFeatures_handle(VkPhysicalDevicePipelineCreationCacheControlFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES:
            vn_replace_VkPhysicalDevicePipelineCreationCacheControlFeatures_handle_self((VkPhysicalDevicePipelineCreationCacheControlFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceVulkan11Features chain */

static inline void
vn_encode_VkPhysicalDeviceVulkan11Features_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceVulkan11Features_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan11Features *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->storageBuffer16BitAccess);
    vn_encode_VkBool32(enc, &val->uniformAndStorageBuffer16BitAccess);
    vn_encode_VkBool32(enc, &val->storagePushConstant16);
    vn_encode_VkBool32(enc, &val->storageInputOutput16);
    vn_encode_VkBool32(enc, &val->multiview);
    vn_encode_VkBool32(enc, &val->multiviewGeometryShader);
    vn_encode_VkBool32(enc, &val->multiviewTessellationShader);
    vn_encode_VkBool32(enc, &val->variablePointersStorageBuffer);
    vn_encode_VkBool32(enc, &val->variablePointers);
    vn_encode_VkBool32(enc, &val->protectedMemory);
    vn_encode_VkBool32(enc, &val->samplerYcbcrConversion);
    vn_encode_VkBool32(enc, &val->shaderDrawParameters);
}

static inline void
vn_encode_VkPhysicalDeviceVulkan11Features(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan11Features *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES });
    vn_encode_VkPhysicalDeviceVulkan11Features_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceVulkan11Features_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceVulkan11Features_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceVulkan11Features_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan11Features *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->storageBuffer16BitAccess);
    vn_decode_VkBool32(dec, &val->uniformAndStorageBuffer16BitAccess);
    vn_decode_VkBool32(dec, &val->storagePushConstant16);
    vn_decode_VkBool32(dec, &val->storageInputOutput16);
    vn_decode_VkBool32(dec, &val->multiview);
    vn_decode_VkBool32(dec, &val->multiviewGeometryShader);
    vn_decode_VkBool32(dec, &val->multiviewTessellationShader);
    vn_decode_VkBool32(dec, &val->variablePointersStorageBuffer);
    vn_decode_VkBool32(dec, &val->variablePointers);
    vn_decode_VkBool32(dec, &val->protectedMemory);
    vn_decode_VkBool32(dec, &val->samplerYcbcrConversion);
    vn_decode_VkBool32(dec, &val->shaderDrawParameters);
}

static inline void
vn_decode_VkPhysicalDeviceVulkan11Features_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan11Features *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceVulkan11Features_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceVulkan11Features_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceVulkan11Features_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceVulkan11Features_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan11Features *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->storageBuffer16BitAccess */
    /* skip val->uniformAndStorageBuffer16BitAccess */
    /* skip val->storagePushConstant16 */
    /* skip val->storageInputOutput16 */
    /* skip val->multiview */
    /* skip val->multiviewGeometryShader */
    /* skip val->multiviewTessellationShader */
    /* skip val->variablePointersStorageBuffer */
    /* skip val->variablePointers */
    /* skip val->protectedMemory */
    /* skip val->samplerYcbcrConversion */
    /* skip val->shaderDrawParameters */
}

static inline void
vn_decode_VkPhysicalDeviceVulkan11Features_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan11Features *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceVulkan11Features_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceVulkan11Features_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceVulkan11Features_handle_self(VkPhysicalDeviceVulkan11Features *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->storageBuffer16BitAccess */
    /* skip val->uniformAndStorageBuffer16BitAccess */
    /* skip val->storagePushConstant16 */
    /* skip val->storageInputOutput16 */
    /* skip val->multiview */
    /* skip val->multiviewGeometryShader */
    /* skip val->multiviewTessellationShader */
    /* skip val->variablePointersStorageBuffer */
    /* skip val->variablePointers */
    /* skip val->protectedMemory */
    /* skip val->samplerYcbcrConversion */
    /* skip val->shaderDrawParameters */
}

static inline void
vn_replace_VkPhysicalDeviceVulkan11Features_handle(VkPhysicalDeviceVulkan11Features *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES:
            vn_replace_VkPhysicalDeviceVulkan11Features_handle_self((VkPhysicalDeviceVulkan11Features *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceVulkan12Features chain */

static inline void
vn_encode_VkPhysicalDeviceVulkan12Features_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceVulkan12Features_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan12Features *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->samplerMirrorClampToEdge);
    vn_encode_VkBool32(enc, &val->drawIndirectCount);
    vn_encode_VkBool32(enc, &val->storageBuffer8BitAccess);
    vn_encode_VkBool32(enc, &val->uniformAndStorageBuffer8BitAccess);
    vn_encode_VkBool32(enc, &val->storagePushConstant8);
    vn_encode_VkBool32(enc, &val->shaderBufferInt64Atomics);
    vn_encode_VkBool32(enc, &val->shaderSharedInt64Atomics);
    vn_encode_VkBool32(enc, &val->shaderFloat16);
    vn_encode_VkBool32(enc, &val->shaderInt8);
    vn_encode_VkBool32(enc, &val->descriptorIndexing);
    vn_encode_VkBool32(enc, &val->shaderInputAttachmentArrayDynamicIndexing);
    vn_encode_VkBool32(enc, &val->shaderUniformTexelBufferArrayDynamicIndexing);
    vn_encode_VkBool32(enc, &val->shaderStorageTexelBufferArrayDynamicIndexing);
    vn_encode_VkBool32(enc, &val->shaderUniformBufferArrayNonUniformIndexing);
    vn_encode_VkBool32(enc, &val->shaderSampledImageArrayNonUniformIndexing);
    vn_encode_VkBool32(enc, &val->shaderStorageBufferArrayNonUniformIndexing);
    vn_encode_VkBool32(enc, &val->shaderStorageImageArrayNonUniformIndexing);
    vn_encode_VkBool32(enc, &val->shaderInputAttachmentArrayNonUniformIndexing);
    vn_encode_VkBool32(enc, &val->shaderUniformTexelBufferArrayNonUniformIndexing);
    vn_encode_VkBool32(enc, &val->shaderStorageTexelBufferArrayNonUniformIndexing);
    vn_encode_VkBool32(enc, &val->descriptorBindingUniformBufferUpdateAfterBind);
    vn_encode_VkBool32(enc, &val->descriptorBindingSampledImageUpdateAfterBind);
    vn_encode_VkBool32(enc, &val->descriptorBindingStorageImageUpdateAfterBind);
    vn_encode_VkBool32(enc, &val->descriptorBindingStorageBufferUpdateAfterBind);
    vn_encode_VkBool32(enc, &val->descriptorBindingUniformTexelBufferUpdateAfterBind);
    vn_encode_VkBool32(enc, &val->descriptorBindingStorageTexelBufferUpdateAfterBind);
    vn_encode_VkBool32(enc, &val->descriptorBindingUpdateUnusedWhilePending);
    vn_encode_VkBool32(enc, &val->descriptorBindingPartiallyBound);
    vn_encode_VkBool32(enc, &val->descriptorBindingVariableDescriptorCount);
    vn_encode_VkBool32(enc, &val->runtimeDescriptorArray);
    vn_encode_VkBool32(enc, &val->samplerFilterMinmax);
    vn_encode_VkBool32(enc, &val->scalarBlockLayout);
    vn_encode_VkBool32(enc, &val->imagelessFramebuffer);
    vn_encode_VkBool32(enc, &val->uniformBufferStandardLayout);
    vn_encode_VkBool32(enc, &val->shaderSubgroupExtendedTypes);
    vn_encode_VkBool32(enc, &val->separateDepthStencilLayouts);
    vn_encode_VkBool32(enc, &val->hostQueryReset);
    vn_encode_VkBool32(enc, &val->timelineSemaphore);
    vn_encode_VkBool32(enc, &val->bufferDeviceAddress);
    vn_encode_VkBool32(enc, &val->bufferDeviceAddressCaptureReplay);
    vn_encode_VkBool32(enc, &val->bufferDeviceAddressMultiDevice);
    vn_encode_VkBool32(enc, &val->vulkanMemoryModel);
    vn_encode_VkBool32(enc, &val->vulkanMemoryModelDeviceScope);
    vn_encode_VkBool32(enc, &val->vulkanMemoryModelAvailabilityVisibilityChains);
    vn_encode_VkBool32(enc, &val->shaderOutputViewportIndex);
    vn_encode_VkBool32(enc, &val->shaderOutputLayer);
    vn_encode_VkBool32(enc, &val->subgroupBroadcastDynamicId);
}

static inline void
vn_encode_VkPhysicalDeviceVulkan12Features(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan12Features *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES });
    vn_encode_VkPhysicalDeviceVulkan12Features_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceVulkan12Features_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceVulkan12Features_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceVulkan12Features_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan12Features *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->samplerMirrorClampToEdge);
    vn_decode_VkBool32(dec, &val->drawIndirectCount);
    vn_decode_VkBool32(dec, &val->storageBuffer8BitAccess);
    vn_decode_VkBool32(dec, &val->uniformAndStorageBuffer8BitAccess);
    vn_decode_VkBool32(dec, &val->storagePushConstant8);
    vn_decode_VkBool32(dec, &val->shaderBufferInt64Atomics);
    vn_decode_VkBool32(dec, &val->shaderSharedInt64Atomics);
    vn_decode_VkBool32(dec, &val->shaderFloat16);
    vn_decode_VkBool32(dec, &val->shaderInt8);
    vn_decode_VkBool32(dec, &val->descriptorIndexing);
    vn_decode_VkBool32(dec, &val->shaderInputAttachmentArrayDynamicIndexing);
    vn_decode_VkBool32(dec, &val->shaderUniformTexelBufferArrayDynamicIndexing);
    vn_decode_VkBool32(dec, &val->shaderStorageTexelBufferArrayDynamicIndexing);
    vn_decode_VkBool32(dec, &val->shaderUniformBufferArrayNonUniformIndexing);
    vn_decode_VkBool32(dec, &val->shaderSampledImageArrayNonUniformIndexing);
    vn_decode_VkBool32(dec, &val->shaderStorageBufferArrayNonUniformIndexing);
    vn_decode_VkBool32(dec, &val->shaderStorageImageArrayNonUniformIndexing);
    vn_decode_VkBool32(dec, &val->shaderInputAttachmentArrayNonUniformIndexing);
    vn_decode_VkBool32(dec, &val->shaderUniformTexelBufferArrayNonUniformIndexing);
    vn_decode_VkBool32(dec, &val->shaderStorageTexelBufferArrayNonUniformIndexing);
    vn_decode_VkBool32(dec, &val->descriptorBindingUniformBufferUpdateAfterBind);
    vn_decode_VkBool32(dec, &val->descriptorBindingSampledImageUpdateAfterBind);
    vn_decode_VkBool32(dec, &val->descriptorBindingStorageImageUpdateAfterBind);
    vn_decode_VkBool32(dec, &val->descriptorBindingStorageBufferUpdateAfterBind);
    vn_decode_VkBool32(dec, &val->descriptorBindingUniformTexelBufferUpdateAfterBind);
    vn_decode_VkBool32(dec, &val->descriptorBindingStorageTexelBufferUpdateAfterBind);
    vn_decode_VkBool32(dec, &val->descriptorBindingUpdateUnusedWhilePending);
    vn_decode_VkBool32(dec, &val->descriptorBindingPartiallyBound);
    vn_decode_VkBool32(dec, &val->descriptorBindingVariableDescriptorCount);
    vn_decode_VkBool32(dec, &val->runtimeDescriptorArray);
    vn_decode_VkBool32(dec, &val->samplerFilterMinmax);
    vn_decode_VkBool32(dec, &val->scalarBlockLayout);
    vn_decode_VkBool32(dec, &val->imagelessFramebuffer);
    vn_decode_VkBool32(dec, &val->uniformBufferStandardLayout);
    vn_decode_VkBool32(dec, &val->shaderSubgroupExtendedTypes);
    vn_decode_VkBool32(dec, &val->separateDepthStencilLayouts);
    vn_decode_VkBool32(dec, &val->hostQueryReset);
    vn_decode_VkBool32(dec, &val->timelineSemaphore);
    vn_decode_VkBool32(dec, &val->bufferDeviceAddress);
    vn_decode_VkBool32(dec, &val->bufferDeviceAddressCaptureReplay);
    vn_decode_VkBool32(dec, &val->bufferDeviceAddressMultiDevice);
    vn_decode_VkBool32(dec, &val->vulkanMemoryModel);
    vn_decode_VkBool32(dec, &val->vulkanMemoryModelDeviceScope);
    vn_decode_VkBool32(dec, &val->vulkanMemoryModelAvailabilityVisibilityChains);
    vn_decode_VkBool32(dec, &val->shaderOutputViewportIndex);
    vn_decode_VkBool32(dec, &val->shaderOutputLayer);
    vn_decode_VkBool32(dec, &val->subgroupBroadcastDynamicId);
}

static inline void
vn_decode_VkPhysicalDeviceVulkan12Features_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan12Features *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceVulkan12Features_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceVulkan12Features_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceVulkan12Features_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceVulkan12Features_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan12Features *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->samplerMirrorClampToEdge */
    /* skip val->drawIndirectCount */
    /* skip val->storageBuffer8BitAccess */
    /* skip val->uniformAndStorageBuffer8BitAccess */
    /* skip val->storagePushConstant8 */
    /* skip val->shaderBufferInt64Atomics */
    /* skip val->shaderSharedInt64Atomics */
    /* skip val->shaderFloat16 */
    /* skip val->shaderInt8 */
    /* skip val->descriptorIndexing */
    /* skip val->shaderInputAttachmentArrayDynamicIndexing */
    /* skip val->shaderUniformTexelBufferArrayDynamicIndexing */
    /* skip val->shaderStorageTexelBufferArrayDynamicIndexing */
    /* skip val->shaderUniformBufferArrayNonUniformIndexing */
    /* skip val->shaderSampledImageArrayNonUniformIndexing */
    /* skip val->shaderStorageBufferArrayNonUniformIndexing */
    /* skip val->shaderStorageImageArrayNonUniformIndexing */
    /* skip val->shaderInputAttachmentArrayNonUniformIndexing */
    /* skip val->shaderUniformTexelBufferArrayNonUniformIndexing */
    /* skip val->shaderStorageTexelBufferArrayNonUniformIndexing */
    /* skip val->descriptorBindingUniformBufferUpdateAfterBind */
    /* skip val->descriptorBindingSampledImageUpdateAfterBind */
    /* skip val->descriptorBindingStorageImageUpdateAfterBind */
    /* skip val->descriptorBindingStorageBufferUpdateAfterBind */
    /* skip val->descriptorBindingUniformTexelBufferUpdateAfterBind */
    /* skip val->descriptorBindingStorageTexelBufferUpdateAfterBind */
    /* skip val->descriptorBindingUpdateUnusedWhilePending */
    /* skip val->descriptorBindingPartiallyBound */
    /* skip val->descriptorBindingVariableDescriptorCount */
    /* skip val->runtimeDescriptorArray */
    /* skip val->samplerFilterMinmax */
    /* skip val->scalarBlockLayout */
    /* skip val->imagelessFramebuffer */
    /* skip val->uniformBufferStandardLayout */
    /* skip val->shaderSubgroupExtendedTypes */
    /* skip val->separateDepthStencilLayouts */
    /* skip val->hostQueryReset */
    /* skip val->timelineSemaphore */
    /* skip val->bufferDeviceAddress */
    /* skip val->bufferDeviceAddressCaptureReplay */
    /* skip val->bufferDeviceAddressMultiDevice */
    /* skip val->vulkanMemoryModel */
    /* skip val->vulkanMemoryModelDeviceScope */
    /* skip val->vulkanMemoryModelAvailabilityVisibilityChains */
    /* skip val->shaderOutputViewportIndex */
    /* skip val->shaderOutputLayer */
    /* skip val->subgroupBroadcastDynamicId */
}

static inline void
vn_decode_VkPhysicalDeviceVulkan12Features_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan12Features *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceVulkan12Features_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceVulkan12Features_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceVulkan12Features_handle_self(VkPhysicalDeviceVulkan12Features *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->samplerMirrorClampToEdge */
    /* skip val->drawIndirectCount */
    /* skip val->storageBuffer8BitAccess */
    /* skip val->uniformAndStorageBuffer8BitAccess */
    /* skip val->storagePushConstant8 */
    /* skip val->shaderBufferInt64Atomics */
    /* skip val->shaderSharedInt64Atomics */
    /* skip val->shaderFloat16 */
    /* skip val->shaderInt8 */
    /* skip val->descriptorIndexing */
    /* skip val->shaderInputAttachmentArrayDynamicIndexing */
    /* skip val->shaderUniformTexelBufferArrayDynamicIndexing */
    /* skip val->shaderStorageTexelBufferArrayDynamicIndexing */
    /* skip val->shaderUniformBufferArrayNonUniformIndexing */
    /* skip val->shaderSampledImageArrayNonUniformIndexing */
    /* skip val->shaderStorageBufferArrayNonUniformIndexing */
    /* skip val->shaderStorageImageArrayNonUniformIndexing */
    /* skip val->shaderInputAttachmentArrayNonUniformIndexing */
    /* skip val->shaderUniformTexelBufferArrayNonUniformIndexing */
    /* skip val->shaderStorageTexelBufferArrayNonUniformIndexing */
    /* skip val->descriptorBindingUniformBufferUpdateAfterBind */
    /* skip val->descriptorBindingSampledImageUpdateAfterBind */
    /* skip val->descriptorBindingStorageImageUpdateAfterBind */
    /* skip val->descriptorBindingStorageBufferUpdateAfterBind */
    /* skip val->descriptorBindingUniformTexelBufferUpdateAfterBind */
    /* skip val->descriptorBindingStorageTexelBufferUpdateAfterBind */
    /* skip val->descriptorBindingUpdateUnusedWhilePending */
    /* skip val->descriptorBindingPartiallyBound */
    /* skip val->descriptorBindingVariableDescriptorCount */
    /* skip val->runtimeDescriptorArray */
    /* skip val->samplerFilterMinmax */
    /* skip val->scalarBlockLayout */
    /* skip val->imagelessFramebuffer */
    /* skip val->uniformBufferStandardLayout */
    /* skip val->shaderSubgroupExtendedTypes */
    /* skip val->separateDepthStencilLayouts */
    /* skip val->hostQueryReset */
    /* skip val->timelineSemaphore */
    /* skip val->bufferDeviceAddress */
    /* skip val->bufferDeviceAddressCaptureReplay */
    /* skip val->bufferDeviceAddressMultiDevice */
    /* skip val->vulkanMemoryModel */
    /* skip val->vulkanMemoryModelDeviceScope */
    /* skip val->vulkanMemoryModelAvailabilityVisibilityChains */
    /* skip val->shaderOutputViewportIndex */
    /* skip val->shaderOutputLayer */
    /* skip val->subgroupBroadcastDynamicId */
}

static inline void
vn_replace_VkPhysicalDeviceVulkan12Features_handle(VkPhysicalDeviceVulkan12Features *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES:
            vn_replace_VkPhysicalDeviceVulkan12Features_handle_self((VkPhysicalDeviceVulkan12Features *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceVulkan13Features chain */

static inline void
vn_encode_VkPhysicalDeviceVulkan13Features_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceVulkan13Features_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan13Features *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->robustImageAccess);
    vn_encode_VkBool32(enc, &val->inlineUniformBlock);
    vn_encode_VkBool32(enc, &val->descriptorBindingInlineUniformBlockUpdateAfterBind);
    vn_encode_VkBool32(enc, &val->pipelineCreationCacheControl);
    vn_encode_VkBool32(enc, &val->privateData);
    vn_encode_VkBool32(enc, &val->shaderDemoteToHelperInvocation);
    vn_encode_VkBool32(enc, &val->shaderTerminateInvocation);
    vn_encode_VkBool32(enc, &val->subgroupSizeControl);
    vn_encode_VkBool32(enc, &val->computeFullSubgroups);
    vn_encode_VkBool32(enc, &val->synchronization2);
    vn_encode_VkBool32(enc, &val->textureCompressionASTC_HDR);
    vn_encode_VkBool32(enc, &val->shaderZeroInitializeWorkgroupMemory);
    vn_encode_VkBool32(enc, &val->dynamicRendering);
    vn_encode_VkBool32(enc, &val->shaderIntegerDotProduct);
    vn_encode_VkBool32(enc, &val->maintenance4);
}

static inline void
vn_encode_VkPhysicalDeviceVulkan13Features(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan13Features *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES });
    vn_encode_VkPhysicalDeviceVulkan13Features_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceVulkan13Features_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceVulkan13Features_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceVulkan13Features_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan13Features *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->robustImageAccess);
    vn_decode_VkBool32(dec, &val->inlineUniformBlock);
    vn_decode_VkBool32(dec, &val->descriptorBindingInlineUniformBlockUpdateAfterBind);
    vn_decode_VkBool32(dec, &val->pipelineCreationCacheControl);
    vn_decode_VkBool32(dec, &val->privateData);
    vn_decode_VkBool32(dec, &val->shaderDemoteToHelperInvocation);
    vn_decode_VkBool32(dec, &val->shaderTerminateInvocation);
    vn_decode_VkBool32(dec, &val->subgroupSizeControl);
    vn_decode_VkBool32(dec, &val->computeFullSubgroups);
    vn_decode_VkBool32(dec, &val->synchronization2);
    vn_decode_VkBool32(dec, &val->textureCompressionASTC_HDR);
    vn_decode_VkBool32(dec, &val->shaderZeroInitializeWorkgroupMemory);
    vn_decode_VkBool32(dec, &val->dynamicRendering);
    vn_decode_VkBool32(dec, &val->shaderIntegerDotProduct);
    vn_decode_VkBool32(dec, &val->maintenance4);
}

static inline void
vn_decode_VkPhysicalDeviceVulkan13Features_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan13Features *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceVulkan13Features_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceVulkan13Features_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceVulkan13Features_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceVulkan13Features_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan13Features *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->robustImageAccess */
    /* skip val->inlineUniformBlock */
    /* skip val->descriptorBindingInlineUniformBlockUpdateAfterBind */
    /* skip val->pipelineCreationCacheControl */
    /* skip val->privateData */
    /* skip val->shaderDemoteToHelperInvocation */
    /* skip val->shaderTerminateInvocation */
    /* skip val->subgroupSizeControl */
    /* skip val->computeFullSubgroups */
    /* skip val->synchronization2 */
    /* skip val->textureCompressionASTC_HDR */
    /* skip val->shaderZeroInitializeWorkgroupMemory */
    /* skip val->dynamicRendering */
    /* skip val->shaderIntegerDotProduct */
    /* skip val->maintenance4 */
}

static inline void
vn_decode_VkPhysicalDeviceVulkan13Features_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan13Features *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceVulkan13Features_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceVulkan13Features_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceVulkan13Features_handle_self(VkPhysicalDeviceVulkan13Features *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->robustImageAccess */
    /* skip val->inlineUniformBlock */
    /* skip val->descriptorBindingInlineUniformBlockUpdateAfterBind */
    /* skip val->pipelineCreationCacheControl */
    /* skip val->privateData */
    /* skip val->shaderDemoteToHelperInvocation */
    /* skip val->shaderTerminateInvocation */
    /* skip val->subgroupSizeControl */
    /* skip val->computeFullSubgroups */
    /* skip val->synchronization2 */
    /* skip val->textureCompressionASTC_HDR */
    /* skip val->shaderZeroInitializeWorkgroupMemory */
    /* skip val->dynamicRendering */
    /* skip val->shaderIntegerDotProduct */
    /* skip val->maintenance4 */
}

static inline void
vn_replace_VkPhysicalDeviceVulkan13Features_handle(VkPhysicalDeviceVulkan13Features *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES:
            vn_replace_VkPhysicalDeviceVulkan13Features_handle_self((VkPhysicalDeviceVulkan13Features *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceCustomBorderColorFeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceCustomBorderColorFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceCustomBorderColorFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceCustomBorderColorFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->customBorderColors);
    vn_encode_VkBool32(enc, &val->customBorderColorWithoutFormat);
}

static inline void
vn_encode_VkPhysicalDeviceCustomBorderColorFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceCustomBorderColorFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceCustomBorderColorFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceCustomBorderColorFeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceCustomBorderColorFeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceCustomBorderColorFeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceCustomBorderColorFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->customBorderColors);
    vn_decode_VkBool32(dec, &val->customBorderColorWithoutFormat);
}

static inline void
vn_decode_VkPhysicalDeviceCustomBorderColorFeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceCustomBorderColorFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceCustomBorderColorFeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceCustomBorderColorFeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceCustomBorderColorFeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceCustomBorderColorFeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceCustomBorderColorFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->customBorderColors */
    /* skip val->customBorderColorWithoutFormat */
}

static inline void
vn_decode_VkPhysicalDeviceCustomBorderColorFeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceCustomBorderColorFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceCustomBorderColorFeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceCustomBorderColorFeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceCustomBorderColorFeaturesEXT_handle_self(VkPhysicalDeviceCustomBorderColorFeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->customBorderColors */
    /* skip val->customBorderColorWithoutFormat */
}

static inline void
vn_replace_VkPhysicalDeviceCustomBorderColorFeaturesEXT_handle(VkPhysicalDeviceCustomBorderColorFeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceCustomBorderColorFeaturesEXT_handle_self((VkPhysicalDeviceCustomBorderColorFeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceBorderColorSwizzleFeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceBorderColorSwizzleFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->borderColorSwizzle);
    vn_encode_VkBool32(enc, &val->borderColorSwizzleFromImage);
}

static inline void
vn_encode_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceBorderColorSwizzleFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BORDER_COLOR_SWIZZLE_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BORDER_COLOR_SWIZZLE_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceBorderColorSwizzleFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->borderColorSwizzle);
    vn_decode_VkBool32(dec, &val->borderColorSwizzleFromImage);
}

static inline void
vn_decode_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceBorderColorSwizzleFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BORDER_COLOR_SWIZZLE_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceBorderColorSwizzleFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->borderColorSwizzle */
    /* skip val->borderColorSwizzleFromImage */
}

static inline void
vn_decode_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceBorderColorSwizzleFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BORDER_COLOR_SWIZZLE_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_handle_self(VkPhysicalDeviceBorderColorSwizzleFeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->borderColorSwizzle */
    /* skip val->borderColorSwizzleFromImage */
}

static inline void
vn_replace_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_handle(VkPhysicalDeviceBorderColorSwizzleFeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BORDER_COLOR_SWIZZLE_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_handle_self((VkPhysicalDeviceBorderColorSwizzleFeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceExtendedDynamicStateFeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceExtendedDynamicStateFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->extendedDynamicState);
}

static inline void
vn_encode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceExtendedDynamicStateFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceExtendedDynamicStateFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->extendedDynamicState);
}

static inline void
vn_decode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceExtendedDynamicStateFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceExtendedDynamicStateFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->extendedDynamicState */
}

static inline void
vn_decode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceExtendedDynamicStateFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_handle_self(VkPhysicalDeviceExtendedDynamicStateFeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->extendedDynamicState */
}

static inline void
vn_replace_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_handle(VkPhysicalDeviceExtendedDynamicStateFeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_handle_self((VkPhysicalDeviceExtendedDynamicStateFeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceExtendedDynamicState2FeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceExtendedDynamicState2FeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->extendedDynamicState2);
    vn_encode_VkBool32(enc, &val->extendedDynamicState2LogicOp);
    vn_encode_VkBool32(enc, &val->extendedDynamicState2PatchControlPoints);
}

static inline void
vn_encode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceExtendedDynamicState2FeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceExtendedDynamicState2FeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->extendedDynamicState2);
    vn_decode_VkBool32(dec, &val->extendedDynamicState2LogicOp);
    vn_decode_VkBool32(dec, &val->extendedDynamicState2PatchControlPoints);
}

static inline void
vn_decode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceExtendedDynamicState2FeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceExtendedDynamicState2FeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->extendedDynamicState2 */
    /* skip val->extendedDynamicState2LogicOp */
    /* skip val->extendedDynamicState2PatchControlPoints */
}

static inline void
vn_decode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceExtendedDynamicState2FeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_handle_self(VkPhysicalDeviceExtendedDynamicState2FeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->extendedDynamicState2 */
    /* skip val->extendedDynamicState2LogicOp */
    /* skip val->extendedDynamicState2PatchControlPoints */
}

static inline void
vn_replace_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_handle(VkPhysicalDeviceExtendedDynamicState2FeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_handle_self((VkPhysicalDeviceExtendedDynamicState2FeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures chain */

static inline void
vn_encode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->shaderZeroInitializeWorkgroupMemory);
}

static inline void
vn_encode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES });
    vn_encode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->shaderZeroInitializeWorkgroupMemory);
}

static inline void
vn_decode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->shaderZeroInitializeWorkgroupMemory */
}

static inline void
vn_decode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_handle_self(VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->shaderZeroInitializeWorkgroupMemory */
}

static inline void
vn_replace_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_handle(VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES:
            vn_replace_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_handle_self((VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceRobustness2FeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceRobustness2FeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceRobustness2FeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceRobustness2FeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->robustBufferAccess2);
    vn_encode_VkBool32(enc, &val->robustImageAccess2);
    vn_encode_VkBool32(enc, &val->nullDescriptor);
}

static inline void
vn_encode_VkPhysicalDeviceRobustness2FeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceRobustness2FeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceRobustness2FeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceRobustness2FeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceRobustness2FeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceRobustness2FeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceRobustness2FeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->robustBufferAccess2);
    vn_decode_VkBool32(dec, &val->robustImageAccess2);
    vn_decode_VkBool32(dec, &val->nullDescriptor);
}

static inline void
vn_decode_VkPhysicalDeviceRobustness2FeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceRobustness2FeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceRobustness2FeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceRobustness2FeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceRobustness2FeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceRobustness2FeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceRobustness2FeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->robustBufferAccess2 */
    /* skip val->robustImageAccess2 */
    /* skip val->nullDescriptor */
}

static inline void
vn_decode_VkPhysicalDeviceRobustness2FeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceRobustness2FeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceRobustness2FeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceRobustness2FeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceRobustness2FeaturesEXT_handle_self(VkPhysicalDeviceRobustness2FeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->robustBufferAccess2 */
    /* skip val->robustImageAccess2 */
    /* skip val->nullDescriptor */
}

static inline void
vn_replace_VkPhysicalDeviceRobustness2FeaturesEXT_handle(VkPhysicalDeviceRobustness2FeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceRobustness2FeaturesEXT_handle_self((VkPhysicalDeviceRobustness2FeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceImageRobustnessFeatures chain */

static inline void
vn_encode_VkPhysicalDeviceImageRobustnessFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceImageRobustnessFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceImageRobustnessFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->robustImageAccess);
}

static inline void
vn_encode_VkPhysicalDeviceImageRobustnessFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceImageRobustnessFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES });
    vn_encode_VkPhysicalDeviceImageRobustnessFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceImageRobustnessFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceImageRobustnessFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceImageRobustnessFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceImageRobustnessFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->robustImageAccess);
}

static inline void
vn_decode_VkPhysicalDeviceImageRobustnessFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceImageRobustnessFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceImageRobustnessFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceImageRobustnessFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceImageRobustnessFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceImageRobustnessFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceImageRobustnessFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->robustImageAccess */
}

static inline void
vn_decode_VkPhysicalDeviceImageRobustnessFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceImageRobustnessFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceImageRobustnessFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceImageRobustnessFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceImageRobustnessFeatures_handle_self(VkPhysicalDeviceImageRobustnessFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->robustImageAccess */
}

static inline void
vn_replace_VkPhysicalDeviceImageRobustnessFeatures_handle(VkPhysicalDeviceImageRobustnessFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES:
            vn_replace_VkPhysicalDeviceImageRobustnessFeatures_handle_self((VkPhysicalDeviceImageRobustnessFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDevice4444FormatsFeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDevice4444FormatsFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDevice4444FormatsFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDevice4444FormatsFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->formatA4R4G4B4);
    vn_encode_VkBool32(enc, &val->formatA4B4G4R4);
}

static inline void
vn_encode_VkPhysicalDevice4444FormatsFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDevice4444FormatsFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT });
    vn_encode_VkPhysicalDevice4444FormatsFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDevice4444FormatsFeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDevice4444FormatsFeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDevice4444FormatsFeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDevice4444FormatsFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->formatA4R4G4B4);
    vn_decode_VkBool32(dec, &val->formatA4B4G4R4);
}

static inline void
vn_decode_VkPhysicalDevice4444FormatsFeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDevice4444FormatsFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDevice4444FormatsFeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDevice4444FormatsFeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDevice4444FormatsFeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDevice4444FormatsFeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDevice4444FormatsFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->formatA4R4G4B4 */
    /* skip val->formatA4B4G4R4 */
}

static inline void
vn_decode_VkPhysicalDevice4444FormatsFeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDevice4444FormatsFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDevice4444FormatsFeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDevice4444FormatsFeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDevice4444FormatsFeaturesEXT_handle_self(VkPhysicalDevice4444FormatsFeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->formatA4R4G4B4 */
    /* skip val->formatA4B4G4R4 */
}

static inline void
vn_replace_VkPhysicalDevice4444FormatsFeaturesEXT_handle(VkPhysicalDevice4444FormatsFeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT:
            vn_replace_VkPhysicalDevice4444FormatsFeaturesEXT_handle_self((VkPhysicalDevice4444FormatsFeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceShaderTerminateInvocationFeatures chain */

static inline void
vn_encode_VkPhysicalDeviceShaderTerminateInvocationFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceShaderTerminateInvocationFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderTerminateInvocationFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->shaderTerminateInvocation);
}

static inline void
vn_encode_VkPhysicalDeviceShaderTerminateInvocationFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderTerminateInvocationFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES });
    vn_encode_VkPhysicalDeviceShaderTerminateInvocationFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceShaderTerminateInvocationFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceShaderTerminateInvocationFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceShaderTerminateInvocationFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderTerminateInvocationFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->shaderTerminateInvocation);
}

static inline void
vn_decode_VkPhysicalDeviceShaderTerminateInvocationFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderTerminateInvocationFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceShaderTerminateInvocationFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceShaderTerminateInvocationFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceShaderTerminateInvocationFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceShaderTerminateInvocationFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderTerminateInvocationFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->shaderTerminateInvocation */
}

static inline void
vn_decode_VkPhysicalDeviceShaderTerminateInvocationFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderTerminateInvocationFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceShaderTerminateInvocationFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceShaderTerminateInvocationFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceShaderTerminateInvocationFeatures_handle_self(VkPhysicalDeviceShaderTerminateInvocationFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->shaderTerminateInvocation */
}

static inline void
vn_replace_VkPhysicalDeviceShaderTerminateInvocationFeatures_handle(VkPhysicalDeviceShaderTerminateInvocationFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES:
            vn_replace_VkPhysicalDeviceShaderTerminateInvocationFeatures_handle_self((VkPhysicalDeviceShaderTerminateInvocationFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceImage2DViewOf3DFeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceImage2DViewOf3DFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->image2DViewOf3D);
    vn_encode_VkBool32(enc, &val->sampler2DViewOf3D);
}

static inline void
vn_encode_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceImage2DViewOf3DFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_2D_VIEW_OF_3D_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_2D_VIEW_OF_3D_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceImage2DViewOf3DFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->image2DViewOf3D);
    vn_decode_VkBool32(dec, &val->sampler2DViewOf3D);
}

static inline void
vn_decode_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceImage2DViewOf3DFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_2D_VIEW_OF_3D_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceImage2DViewOf3DFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->image2DViewOf3D */
    /* skip val->sampler2DViewOf3D */
}

static inline void
vn_decode_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceImage2DViewOf3DFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_2D_VIEW_OF_3D_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_handle_self(VkPhysicalDeviceImage2DViewOf3DFeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->image2DViewOf3D */
    /* skip val->sampler2DViewOf3D */
}

static inline void
vn_replace_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_handle(VkPhysicalDeviceImage2DViewOf3DFeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_2D_VIEW_OF_3D_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_handle_self((VkPhysicalDeviceImage2DViewOf3DFeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->mutableDescriptorType);
}

static inline void
vn_encode_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MUTABLE_DESCRIPTOR_TYPE_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MUTABLE_DESCRIPTOR_TYPE_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->mutableDescriptorType);
}

static inline void
vn_decode_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MUTABLE_DESCRIPTOR_TYPE_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->mutableDescriptorType */
}

static inline void
vn_decode_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MUTABLE_DESCRIPTOR_TYPE_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_handle_self(VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->mutableDescriptorType */
}

static inline void
vn_replace_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_handle(VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MUTABLE_DESCRIPTOR_TYPE_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_handle_self((VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceDepthClipControlFeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceDepthClipControlFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceDepthClipControlFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceDepthClipControlFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->depthClipControl);
}

static inline void
vn_encode_VkPhysicalDeviceDepthClipControlFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceDepthClipControlFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_CONTROL_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_CONTROL_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceDepthClipControlFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceDepthClipControlFeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceDepthClipControlFeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceDepthClipControlFeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDepthClipControlFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->depthClipControl);
}

static inline void
vn_decode_VkPhysicalDeviceDepthClipControlFeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDepthClipControlFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_CONTROL_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceDepthClipControlFeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceDepthClipControlFeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceDepthClipControlFeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceDepthClipControlFeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDepthClipControlFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->depthClipControl */
}

static inline void
vn_decode_VkPhysicalDeviceDepthClipControlFeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDepthClipControlFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_CONTROL_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceDepthClipControlFeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceDepthClipControlFeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceDepthClipControlFeaturesEXT_handle_self(VkPhysicalDeviceDepthClipControlFeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->depthClipControl */
}

static inline void
vn_replace_VkPhysicalDeviceDepthClipControlFeaturesEXT_handle(VkPhysicalDeviceDepthClipControlFeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_CONTROL_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceDepthClipControlFeaturesEXT_handle_self((VkPhysicalDeviceDepthClipControlFeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceColorWriteEnableFeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceColorWriteEnableFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceColorWriteEnableFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceColorWriteEnableFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->colorWriteEnable);
}

static inline void
vn_encode_VkPhysicalDeviceColorWriteEnableFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceColorWriteEnableFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COLOR_WRITE_ENABLE_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COLOR_WRITE_ENABLE_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceColorWriteEnableFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceColorWriteEnableFeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceColorWriteEnableFeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceColorWriteEnableFeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceColorWriteEnableFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->colorWriteEnable);
}

static inline void
vn_decode_VkPhysicalDeviceColorWriteEnableFeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceColorWriteEnableFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COLOR_WRITE_ENABLE_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceColorWriteEnableFeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceColorWriteEnableFeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceColorWriteEnableFeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceColorWriteEnableFeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceColorWriteEnableFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->colorWriteEnable */
}

static inline void
vn_decode_VkPhysicalDeviceColorWriteEnableFeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceColorWriteEnableFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COLOR_WRITE_ENABLE_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceColorWriteEnableFeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceColorWriteEnableFeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceColorWriteEnableFeaturesEXT_handle_self(VkPhysicalDeviceColorWriteEnableFeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->colorWriteEnable */
}

static inline void
vn_replace_VkPhysicalDeviceColorWriteEnableFeaturesEXT_handle(VkPhysicalDeviceColorWriteEnableFeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COLOR_WRITE_ENABLE_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceColorWriteEnableFeaturesEXT_handle_self((VkPhysicalDeviceColorWriteEnableFeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceSynchronization2Features chain */

static inline void
vn_encode_VkPhysicalDeviceSynchronization2Features_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceSynchronization2Features_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceSynchronization2Features *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->synchronization2);
}

static inline void
vn_encode_VkPhysicalDeviceSynchronization2Features(struct vn_cs_encoder *enc, const VkPhysicalDeviceSynchronization2Features *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES });
    vn_encode_VkPhysicalDeviceSynchronization2Features_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceSynchronization2Features_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceSynchronization2Features_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceSynchronization2Features_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceSynchronization2Features *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->synchronization2);
}

static inline void
vn_decode_VkPhysicalDeviceSynchronization2Features_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceSynchronization2Features *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceSynchronization2Features_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceSynchronization2Features_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceSynchronization2Features_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceSynchronization2Features_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceSynchronization2Features *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->synchronization2 */
}

static inline void
vn_decode_VkPhysicalDeviceSynchronization2Features_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceSynchronization2Features *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceSynchronization2Features_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceSynchronization2Features_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceSynchronization2Features_handle_self(VkPhysicalDeviceSynchronization2Features *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->synchronization2 */
}

static inline void
vn_replace_VkPhysicalDeviceSynchronization2Features_handle(VkPhysicalDeviceSynchronization2Features *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES:
            vn_replace_VkPhysicalDeviceSynchronization2Features_handle_self((VkPhysicalDeviceSynchronization2Features *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->primitivesGeneratedQuery);
    vn_encode_VkBool32(enc, &val->primitivesGeneratedQueryWithRasterizerDiscard);
    vn_encode_VkBool32(enc, &val->primitivesGeneratedQueryWithNonZeroStreams);
}

static inline void
vn_encode_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVES_GENERATED_QUERY_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVES_GENERATED_QUERY_FEATURES_EXT });
    vn_encode_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->primitivesGeneratedQuery);
    vn_decode_VkBool32(dec, &val->primitivesGeneratedQueryWithRasterizerDiscard);
    vn_decode_VkBool32(dec, &val->primitivesGeneratedQueryWithNonZeroStreams);
}

static inline void
vn_decode_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVES_GENERATED_QUERY_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->primitivesGeneratedQuery */
    /* skip val->primitivesGeneratedQueryWithRasterizerDiscard */
    /* skip val->primitivesGeneratedQueryWithNonZeroStreams */
}

static inline void
vn_decode_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVES_GENERATED_QUERY_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_handle_self(VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->primitivesGeneratedQuery */
    /* skip val->primitivesGeneratedQueryWithRasterizerDiscard */
    /* skip val->primitivesGeneratedQueryWithNonZeroStreams */
}

static inline void
vn_replace_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_handle(VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVES_GENERATED_QUERY_FEATURES_EXT:
            vn_replace_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_handle_self((VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->ycbcr2plane444Formats);
}

static inline void
vn_encode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->ycbcr2plane444Formats);
}

static inline void
vn_decode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->ycbcr2plane444Formats */
}

static inline void
vn_decode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_handle_self(VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->ycbcr2plane444Formats */
}

static inline void
vn_replace_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_handle(VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_handle_self((VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceProvokingVertexFeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceProvokingVertexFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceProvokingVertexFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceProvokingVertexFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->provokingVertexLast);
    vn_encode_VkBool32(enc, &val->transformFeedbackPreservesProvokingVertex);
}

static inline void
vn_encode_VkPhysicalDeviceProvokingVertexFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceProvokingVertexFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceProvokingVertexFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceProvokingVertexFeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceProvokingVertexFeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceProvokingVertexFeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceProvokingVertexFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->provokingVertexLast);
    vn_decode_VkBool32(dec, &val->transformFeedbackPreservesProvokingVertex);
}

static inline void
vn_decode_VkPhysicalDeviceProvokingVertexFeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceProvokingVertexFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceProvokingVertexFeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceProvokingVertexFeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceProvokingVertexFeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceProvokingVertexFeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceProvokingVertexFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->provokingVertexLast */
    /* skip val->transformFeedbackPreservesProvokingVertex */
}

static inline void
vn_decode_VkPhysicalDeviceProvokingVertexFeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceProvokingVertexFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceProvokingVertexFeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceProvokingVertexFeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceProvokingVertexFeaturesEXT_handle_self(VkPhysicalDeviceProvokingVertexFeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->provokingVertexLast */
    /* skip val->transformFeedbackPreservesProvokingVertex */
}

static inline void
vn_replace_VkPhysicalDeviceProvokingVertexFeaturesEXT_handle(VkPhysicalDeviceProvokingVertexFeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceProvokingVertexFeaturesEXT_handle_self((VkPhysicalDeviceProvokingVertexFeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceShaderIntegerDotProductFeatures chain */

static inline void
vn_encode_VkPhysicalDeviceShaderIntegerDotProductFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceShaderIntegerDotProductFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderIntegerDotProductFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->shaderIntegerDotProduct);
}

static inline void
vn_encode_VkPhysicalDeviceShaderIntegerDotProductFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderIntegerDotProductFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES });
    vn_encode_VkPhysicalDeviceShaderIntegerDotProductFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceShaderIntegerDotProductFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceShaderIntegerDotProductFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceShaderIntegerDotProductFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderIntegerDotProductFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->shaderIntegerDotProduct);
}

static inline void
vn_decode_VkPhysicalDeviceShaderIntegerDotProductFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderIntegerDotProductFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceShaderIntegerDotProductFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceShaderIntegerDotProductFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceShaderIntegerDotProductFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceShaderIntegerDotProductFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderIntegerDotProductFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->shaderIntegerDotProduct */
}

static inline void
vn_decode_VkPhysicalDeviceShaderIntegerDotProductFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderIntegerDotProductFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceShaderIntegerDotProductFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceShaderIntegerDotProductFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceShaderIntegerDotProductFeatures_handle_self(VkPhysicalDeviceShaderIntegerDotProductFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->shaderIntegerDotProduct */
}

static inline void
vn_replace_VkPhysicalDeviceShaderIntegerDotProductFeatures_handle(VkPhysicalDeviceShaderIntegerDotProductFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES:
            vn_replace_VkPhysicalDeviceShaderIntegerDotProductFeatures_handle_self((VkPhysicalDeviceShaderIntegerDotProductFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceDynamicRenderingFeatures chain */

static inline void
vn_encode_VkPhysicalDeviceDynamicRenderingFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceDynamicRenderingFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceDynamicRenderingFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->dynamicRendering);
}

static inline void
vn_encode_VkPhysicalDeviceDynamicRenderingFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceDynamicRenderingFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES });
    vn_encode_VkPhysicalDeviceDynamicRenderingFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceDynamicRenderingFeatures_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceDynamicRenderingFeatures_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceDynamicRenderingFeatures_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDynamicRenderingFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->dynamicRendering);
}

static inline void
vn_decode_VkPhysicalDeviceDynamicRenderingFeatures_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDynamicRenderingFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceDynamicRenderingFeatures_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceDynamicRenderingFeatures_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceDynamicRenderingFeatures_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceDynamicRenderingFeatures_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDynamicRenderingFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->dynamicRendering */
}

static inline void
vn_decode_VkPhysicalDeviceDynamicRenderingFeatures_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDynamicRenderingFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceDynamicRenderingFeatures_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceDynamicRenderingFeatures_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceDynamicRenderingFeatures_handle_self(VkPhysicalDeviceDynamicRenderingFeatures *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->dynamicRendering */
}

static inline void
vn_replace_VkPhysicalDeviceDynamicRenderingFeatures_handle(VkPhysicalDeviceDynamicRenderingFeatures *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES:
            vn_replace_VkPhysicalDeviceDynamicRenderingFeatures_handle_self((VkPhysicalDeviceDynamicRenderingFeatures *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceImageViewMinLodFeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceImageViewMinLodFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceImageViewMinLodFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceImageViewMinLodFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->minLod);
}

static inline void
vn_encode_VkPhysicalDeviceImageViewMinLodFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceImageViewMinLodFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_MIN_LOD_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_MIN_LOD_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceImageViewMinLodFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceImageViewMinLodFeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceImageViewMinLodFeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceImageViewMinLodFeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceImageViewMinLodFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->minLod);
}

static inline void
vn_decode_VkPhysicalDeviceImageViewMinLodFeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceImageViewMinLodFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_MIN_LOD_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceImageViewMinLodFeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceImageViewMinLodFeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceImageViewMinLodFeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceImageViewMinLodFeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceImageViewMinLodFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->minLod */
}

static inline void
vn_decode_VkPhysicalDeviceImageViewMinLodFeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceImageViewMinLodFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_MIN_LOD_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceImageViewMinLodFeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceImageViewMinLodFeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceImageViewMinLodFeaturesEXT_handle_self(VkPhysicalDeviceImageViewMinLodFeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->minLod */
}

static inline void
vn_replace_VkPhysicalDeviceImageViewMinLodFeaturesEXT_handle(VkPhysicalDeviceImageViewMinLodFeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_MIN_LOD_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceImageViewMinLodFeaturesEXT_handle_self((VkPhysicalDeviceImageViewMinLodFeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->rasterizationOrderColorAttachmentAccess);
    vn_encode_VkBool32(enc, &val->rasterizationOrderDepthAttachmentAccess);
    vn_encode_VkBool32(enc, &val->rasterizationOrderStencilAttachmentAccess);
}

static inline void
vn_encode_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->rasterizationOrderColorAttachmentAccess);
    vn_decode_VkBool32(dec, &val->rasterizationOrderDepthAttachmentAccess);
    vn_decode_VkBool32(dec, &val->rasterizationOrderStencilAttachmentAccess);
}

static inline void
vn_decode_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->rasterizationOrderColorAttachmentAccess */
    /* skip val->rasterizationOrderDepthAttachmentAccess */
    /* skip val->rasterizationOrderStencilAttachmentAccess */
}

static inline void
vn_decode_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_handle_self(VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->rasterizationOrderColorAttachmentAccess */
    /* skip val->rasterizationOrderDepthAttachmentAccess */
    /* skip val->rasterizationOrderStencilAttachmentAccess */
}

static inline void
vn_replace_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_handle(VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_handle_self((VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->nonSeamlessCubeMap);
}

static inline void
vn_encode_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NON_SEAMLESS_CUBE_MAP_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NON_SEAMLESS_CUBE_MAP_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->nonSeamlessCubeMap);
}

static inline void
vn_decode_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NON_SEAMLESS_CUBE_MAP_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->nonSeamlessCubeMap */
}

static inline void
vn_decode_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NON_SEAMLESS_CUBE_MAP_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_handle_self(VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->nonSeamlessCubeMap */
}

static inline void
vn_replace_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_handle(VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NON_SEAMLESS_CUBE_MAP_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_handle_self((VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->dynamicRenderingUnusedAttachments);
}

static inline void
vn_encode_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_UNUSED_ATTACHMENTS_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_UNUSED_ATTACHMENTS_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->dynamicRenderingUnusedAttachments);
}

static inline void
vn_decode_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_UNUSED_ATTACHMENTS_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->dynamicRenderingUnusedAttachments */
}

static inline void
vn_decode_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_UNUSED_ATTACHMENTS_FEATURES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_handle_self(VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->dynamicRenderingUnusedAttachments */
}

static inline void
vn_replace_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_handle(VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_UNUSED_ATTACHMENTS_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_handle_self((VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceFeatures2 chain */

static inline void
vn_encode_VkPhysicalDeviceFeatures2_pnext(struct vn_cs_encoder *enc, const void *val)
{
    const VkBaseInStructure *pnext = val;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDevicePrivateDataFeatures_self(enc, (const VkPhysicalDevicePrivateDataFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVariablePointersFeatures_self(enc, (const VkPhysicalDeviceVariablePointersFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceMultiviewFeatures_self(enc, (const VkPhysicalDeviceMultiviewFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDevice16BitStorageFeatures_self(enc, (const VkPhysicalDevice16BitStorageFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_self(enc, (const VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_self(enc, (const VkPhysicalDeviceSamplerYcbcrConversionFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceProtectedMemoryFeatures_self(enc, (const VkPhysicalDeviceProtectedMemoryFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceMultiDrawFeaturesEXT_self(enc, (const VkPhysicalDeviceMultiDrawFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceInlineUniformBlockFeatures_self(enc, (const VkPhysicalDeviceInlineUniformBlockFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceMaintenance4Features_self(enc, (const VkPhysicalDeviceMaintenance4Features *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderDrawParametersFeatures_self(enc, (const VkPhysicalDeviceShaderDrawParametersFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderFloat16Int8Features_self(enc, (const VkPhysicalDeviceShaderFloat16Int8Features *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceHostQueryResetFeatures_self(enc, (const VkPhysicalDeviceHostQueryResetFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceDescriptorIndexingFeatures_self(enc, (const VkPhysicalDeviceDescriptorIndexingFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceTimelineSemaphoreFeatures_self(enc, (const VkPhysicalDeviceTimelineSemaphoreFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDevice8BitStorageFeatures_self(enc, (const VkPhysicalDevice8BitStorageFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONDITIONAL_RENDERING_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceConditionalRenderingFeaturesEXT_self(enc, (const VkPhysicalDeviceConditionalRenderingFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVulkanMemoryModelFeatures_self(enc, (const VkPhysicalDeviceVulkanMemoryModelFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderAtomicInt64Features_self(enc, (const VkPhysicalDeviceShaderAtomicInt64Features *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT_self(enc, (const VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_self(enc, (const VkPhysicalDeviceTransformFeedbackFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceScalarBlockLayoutFeatures_self(enc, (const VkPhysicalDeviceScalarBlockLayoutFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_self(enc, (const VkPhysicalDeviceUniformBufferStandardLayoutFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_ENABLE_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceDepthClipEnableFeaturesEXT_self(enc, (const VkPhysicalDeviceDepthClipEnableFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceBufferDeviceAddressFeatures_self(enc, (const VkPhysicalDeviceBufferDeviceAddressFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceImagelessFramebufferFeatures_self(enc, (const VkPhysicalDeviceImagelessFramebufferFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_self(enc, (const VkPhysicalDeviceTextureCompressionASTCHDRFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CLOCK_FEATURES_KHR:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderClockFeaturesKHR_self(enc, (const VkPhysicalDeviceShaderClockFeaturesKHR *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceIndexTypeUint8FeaturesEXT_self(enc, (const VkPhysicalDeviceIndexTypeUint8FeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_INTERLOCK_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_self(enc, (const VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_self(enc, (const VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVE_TOPOLOGY_LIST_RESTART_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_self(enc, (const VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_self(enc, (const VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_self(enc, (const VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceSubgroupSizeControlFeatures_self(enc, (const VkPhysicalDeviceSubgroupSizeControlFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceLineRasterizationFeaturesEXT_self(enc, (const VkPhysicalDeviceLineRasterizationFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDevicePipelineCreationCacheControlFeatures_self(enc, (const VkPhysicalDevicePipelineCreationCacheControlFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVulkan11Features_self(enc, (const VkPhysicalDeviceVulkan11Features *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVulkan12Features_self(enc, (const VkPhysicalDeviceVulkan12Features *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVulkan13Features_self(enc, (const VkPhysicalDeviceVulkan13Features *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceCustomBorderColorFeaturesEXT_self(enc, (const VkPhysicalDeviceCustomBorderColorFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BORDER_COLOR_SWIZZLE_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_self(enc, (const VkPhysicalDeviceBorderColorSwizzleFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_self(enc, (const VkPhysicalDeviceExtendedDynamicStateFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_self(enc, (const VkPhysicalDeviceExtendedDynamicState2FeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_self(enc, (const VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceRobustness2FeaturesEXT_self(enc, (const VkPhysicalDeviceRobustness2FeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceImageRobustnessFeatures_self(enc, (const VkPhysicalDeviceImageRobustnessFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDevice4444FormatsFeaturesEXT_self(enc, (const VkPhysicalDevice4444FormatsFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderTerminateInvocationFeatures_self(enc, (const VkPhysicalDeviceShaderTerminateInvocationFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_2D_VIEW_OF_3D_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_self(enc, (const VkPhysicalDeviceImage2DViewOf3DFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MUTABLE_DESCRIPTOR_TYPE_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_self(enc, (const VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_CONTROL_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceDepthClipControlFeaturesEXT_self(enc, (const VkPhysicalDeviceDepthClipControlFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COLOR_WRITE_ENABLE_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceColorWriteEnableFeaturesEXT_self(enc, (const VkPhysicalDeviceColorWriteEnableFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceSynchronization2Features_self(enc, (const VkPhysicalDeviceSynchronization2Features *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVES_GENERATED_QUERY_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_self(enc, (const VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_self(enc, (const VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceProvokingVertexFeaturesEXT_self(enc, (const VkPhysicalDeviceProvokingVertexFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderIntegerDotProductFeatures_self(enc, (const VkPhysicalDeviceShaderIntegerDotProductFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceDynamicRenderingFeatures_self(enc, (const VkPhysicalDeviceDynamicRenderingFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_MIN_LOD_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceImageViewMinLodFeaturesEXT_self(enc, (const VkPhysicalDeviceImageViewMinLodFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_self(enc, (const VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NON_SEAMLESS_CUBE_MAP_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_self(enc, (const VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_UNUSED_ATTACHMENTS_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_self(enc, (const VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT *)pnext);
            return;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceFeatures2_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceFeatures2 *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkPhysicalDeviceFeatures(enc, &val->features);
}

static inline void
vn_encode_VkPhysicalDeviceFeatures2(struct vn_cs_encoder *enc, const VkPhysicalDeviceFeatures2 *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2 });
    vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceFeatures2_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(struct vn_cs_decoder *dec)
{
    VkBaseOutStructure *pnext;
    VkStructureType stype;

    if (!vn_decode_simple_pointer(dec))
        return NULL;

    vn_decode_VkStructureType(dec, &stype);
    switch ((int32_t)stype) {
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDevicePrivateDataFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDevicePrivateDataFeatures_self_temp(dec, (VkPhysicalDevicePrivateDataFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceVariablePointersFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceVariablePointersFeatures_self_temp(dec, (VkPhysicalDeviceVariablePointersFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceMultiviewFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceMultiviewFeatures_self_temp(dec, (VkPhysicalDeviceMultiviewFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDevice16BitStorageFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDevice16BitStorageFeatures_self_temp(dec, (VkPhysicalDevice16BitStorageFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_self_temp(dec, (VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceSamplerYcbcrConversionFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_self_temp(dec, (VkPhysicalDeviceSamplerYcbcrConversionFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceProtectedMemoryFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceProtectedMemoryFeatures_self_temp(dec, (VkPhysicalDeviceProtectedMemoryFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceMultiDrawFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceMultiDrawFeaturesEXT_self_temp(dec, (VkPhysicalDeviceMultiDrawFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceInlineUniformBlockFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceInlineUniformBlockFeatures_self_temp(dec, (VkPhysicalDeviceInlineUniformBlockFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceMaintenance4Features));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceMaintenance4Features_self_temp(dec, (VkPhysicalDeviceMaintenance4Features *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderDrawParametersFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceShaderDrawParametersFeatures_self_temp(dec, (VkPhysicalDeviceShaderDrawParametersFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderFloat16Int8Features));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceShaderFloat16Int8Features_self_temp(dec, (VkPhysicalDeviceShaderFloat16Int8Features *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceHostQueryResetFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceHostQueryResetFeatures_self_temp(dec, (VkPhysicalDeviceHostQueryResetFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceDescriptorIndexingFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceDescriptorIndexingFeatures_self_temp(dec, (VkPhysicalDeviceDescriptorIndexingFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceTimelineSemaphoreFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceTimelineSemaphoreFeatures_self_temp(dec, (VkPhysicalDeviceTimelineSemaphoreFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDevice8BitStorageFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDevice8BitStorageFeatures_self_temp(dec, (VkPhysicalDevice8BitStorageFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONDITIONAL_RENDERING_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceConditionalRenderingFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceConditionalRenderingFeaturesEXT_self_temp(dec, (VkPhysicalDeviceConditionalRenderingFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceVulkanMemoryModelFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceVulkanMemoryModelFeatures_self_temp(dec, (VkPhysicalDeviceVulkanMemoryModelFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderAtomicInt64Features));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceShaderAtomicInt64Features_self_temp(dec, (VkPhysicalDeviceShaderAtomicInt64Features *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT_self_temp(dec, (VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceTransformFeedbackFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_self_temp(dec, (VkPhysicalDeviceTransformFeedbackFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceScalarBlockLayoutFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceScalarBlockLayoutFeatures_self_temp(dec, (VkPhysicalDeviceScalarBlockLayoutFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceUniformBufferStandardLayoutFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_self_temp(dec, (VkPhysicalDeviceUniformBufferStandardLayoutFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_ENABLE_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceDepthClipEnableFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceDepthClipEnableFeaturesEXT_self_temp(dec, (VkPhysicalDeviceDepthClipEnableFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceBufferDeviceAddressFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceBufferDeviceAddressFeatures_self_temp(dec, (VkPhysicalDeviceBufferDeviceAddressFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceImagelessFramebufferFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceImagelessFramebufferFeatures_self_temp(dec, (VkPhysicalDeviceImagelessFramebufferFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceTextureCompressionASTCHDRFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_self_temp(dec, (VkPhysicalDeviceTextureCompressionASTCHDRFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CLOCK_FEATURES_KHR:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderClockFeaturesKHR));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceShaderClockFeaturesKHR_self_temp(dec, (VkPhysicalDeviceShaderClockFeaturesKHR *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceIndexTypeUint8FeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceIndexTypeUint8FeaturesEXT_self_temp(dec, (VkPhysicalDeviceIndexTypeUint8FeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_INTERLOCK_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_self_temp(dec, (VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_self_temp(dec, (VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVE_TOPOLOGY_LIST_RESTART_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_self_temp(dec, (VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_self_temp(dec, (VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_self_temp(dec, (VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceSubgroupSizeControlFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceSubgroupSizeControlFeatures_self_temp(dec, (VkPhysicalDeviceSubgroupSizeControlFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceLineRasterizationFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceLineRasterizationFeaturesEXT_self_temp(dec, (VkPhysicalDeviceLineRasterizationFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDevicePipelineCreationCacheControlFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDevicePipelineCreationCacheControlFeatures_self_temp(dec, (VkPhysicalDevicePipelineCreationCacheControlFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceVulkan11Features));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceVulkan11Features_self_temp(dec, (VkPhysicalDeviceVulkan11Features *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceVulkan12Features));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceVulkan12Features_self_temp(dec, (VkPhysicalDeviceVulkan12Features *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceVulkan13Features));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceVulkan13Features_self_temp(dec, (VkPhysicalDeviceVulkan13Features *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceCustomBorderColorFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceCustomBorderColorFeaturesEXT_self_temp(dec, (VkPhysicalDeviceCustomBorderColorFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BORDER_COLOR_SWIZZLE_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceBorderColorSwizzleFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_self_temp(dec, (VkPhysicalDeviceBorderColorSwizzleFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceExtendedDynamicStateFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_self_temp(dec, (VkPhysicalDeviceExtendedDynamicStateFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceExtendedDynamicState2FeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_self_temp(dec, (VkPhysicalDeviceExtendedDynamicState2FeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_self_temp(dec, (VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceRobustness2FeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceRobustness2FeaturesEXT_self_temp(dec, (VkPhysicalDeviceRobustness2FeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceImageRobustnessFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceImageRobustnessFeatures_self_temp(dec, (VkPhysicalDeviceImageRobustnessFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDevice4444FormatsFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDevice4444FormatsFeaturesEXT_self_temp(dec, (VkPhysicalDevice4444FormatsFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderTerminateInvocationFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceShaderTerminateInvocationFeatures_self_temp(dec, (VkPhysicalDeviceShaderTerminateInvocationFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_2D_VIEW_OF_3D_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceImage2DViewOf3DFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_self_temp(dec, (VkPhysicalDeviceImage2DViewOf3DFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MUTABLE_DESCRIPTOR_TYPE_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_self_temp(dec, (VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_CONTROL_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceDepthClipControlFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceDepthClipControlFeaturesEXT_self_temp(dec, (VkPhysicalDeviceDepthClipControlFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COLOR_WRITE_ENABLE_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceColorWriteEnableFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceColorWriteEnableFeaturesEXT_self_temp(dec, (VkPhysicalDeviceColorWriteEnableFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceSynchronization2Features));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceSynchronization2Features_self_temp(dec, (VkPhysicalDeviceSynchronization2Features *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVES_GENERATED_QUERY_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_self_temp(dec, (VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_self_temp(dec, (VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceProvokingVertexFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceProvokingVertexFeaturesEXT_self_temp(dec, (VkPhysicalDeviceProvokingVertexFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderIntegerDotProductFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceShaderIntegerDotProductFeatures_self_temp(dec, (VkPhysicalDeviceShaderIntegerDotProductFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceDynamicRenderingFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceDynamicRenderingFeatures_self_temp(dec, (VkPhysicalDeviceDynamicRenderingFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_MIN_LOD_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceImageViewMinLodFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceImageViewMinLodFeaturesEXT_self_temp(dec, (VkPhysicalDeviceImageViewMinLodFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_self_temp(dec, (VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NON_SEAMLESS_CUBE_MAP_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_self_temp(dec, (VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_UNUSED_ATTACHMENTS_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_self_temp(dec, (VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT *)pnext);
        }
        break;
    default:
        /* unexpected struct */
        pnext = NULL;
        vn_cs_decoder_set_fatal(dec);
        break;
    }

    return pnext;
}

static inline void
vn_decode_VkPhysicalDeviceFeatures2_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceFeatures2 *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkPhysicalDeviceFeatures_temp(dec, &val->features);
}

static inline void
vn_decode_VkPhysicalDeviceFeatures2_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceFeatures2 *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceFeatures2_self_temp(dec, val);
}

static inline void *
vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    VkBaseOutStructure *pnext;
    VkStructureType stype;

    if (!vn_decode_simple_pointer(dec))
        return NULL;

    vn_decode_VkStructureType(dec, &stype);
    switch ((int32_t)stype) {
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDevicePrivateDataFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDevicePrivateDataFeatures_self_partial_temp(dec, (VkPhysicalDevicePrivateDataFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceVariablePointersFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceVariablePointersFeatures_self_partial_temp(dec, (VkPhysicalDeviceVariablePointersFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceMultiviewFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceMultiviewFeatures_self_partial_temp(dec, (VkPhysicalDeviceMultiviewFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDevice16BitStorageFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDevice16BitStorageFeatures_self_partial_temp(dec, (VkPhysicalDevice16BitStorageFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_self_partial_temp(dec, (VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceSamplerYcbcrConversionFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_self_partial_temp(dec, (VkPhysicalDeviceSamplerYcbcrConversionFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceProtectedMemoryFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceProtectedMemoryFeatures_self_partial_temp(dec, (VkPhysicalDeviceProtectedMemoryFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceMultiDrawFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceMultiDrawFeaturesEXT_self_partial_temp(dec, (VkPhysicalDeviceMultiDrawFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceInlineUniformBlockFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceInlineUniformBlockFeatures_self_partial_temp(dec, (VkPhysicalDeviceInlineUniformBlockFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceMaintenance4Features));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceMaintenance4Features_self_partial_temp(dec, (VkPhysicalDeviceMaintenance4Features *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderDrawParametersFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceShaderDrawParametersFeatures_self_partial_temp(dec, (VkPhysicalDeviceShaderDrawParametersFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderFloat16Int8Features));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceShaderFloat16Int8Features_self_partial_temp(dec, (VkPhysicalDeviceShaderFloat16Int8Features *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceHostQueryResetFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceHostQueryResetFeatures_self_partial_temp(dec, (VkPhysicalDeviceHostQueryResetFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceDescriptorIndexingFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceDescriptorIndexingFeatures_self_partial_temp(dec, (VkPhysicalDeviceDescriptorIndexingFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceTimelineSemaphoreFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceTimelineSemaphoreFeatures_self_partial_temp(dec, (VkPhysicalDeviceTimelineSemaphoreFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDevice8BitStorageFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDevice8BitStorageFeatures_self_partial_temp(dec, (VkPhysicalDevice8BitStorageFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONDITIONAL_RENDERING_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceConditionalRenderingFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceConditionalRenderingFeaturesEXT_self_partial_temp(dec, (VkPhysicalDeviceConditionalRenderingFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceVulkanMemoryModelFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceVulkanMemoryModelFeatures_self_partial_temp(dec, (VkPhysicalDeviceVulkanMemoryModelFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderAtomicInt64Features));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceShaderAtomicInt64Features_self_partial_temp(dec, (VkPhysicalDeviceShaderAtomicInt64Features *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT_self_partial_temp(dec, (VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceTransformFeedbackFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_self_partial_temp(dec, (VkPhysicalDeviceTransformFeedbackFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceScalarBlockLayoutFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceScalarBlockLayoutFeatures_self_partial_temp(dec, (VkPhysicalDeviceScalarBlockLayoutFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceUniformBufferStandardLayoutFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_self_partial_temp(dec, (VkPhysicalDeviceUniformBufferStandardLayoutFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_ENABLE_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceDepthClipEnableFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceDepthClipEnableFeaturesEXT_self_partial_temp(dec, (VkPhysicalDeviceDepthClipEnableFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceBufferDeviceAddressFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceBufferDeviceAddressFeatures_self_partial_temp(dec, (VkPhysicalDeviceBufferDeviceAddressFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceImagelessFramebufferFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceImagelessFramebufferFeatures_self_partial_temp(dec, (VkPhysicalDeviceImagelessFramebufferFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceTextureCompressionASTCHDRFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_self_partial_temp(dec, (VkPhysicalDeviceTextureCompressionASTCHDRFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CLOCK_FEATURES_KHR:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderClockFeaturesKHR));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceShaderClockFeaturesKHR_self_partial_temp(dec, (VkPhysicalDeviceShaderClockFeaturesKHR *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceIndexTypeUint8FeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceIndexTypeUint8FeaturesEXT_self_partial_temp(dec, (VkPhysicalDeviceIndexTypeUint8FeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_INTERLOCK_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_self_partial_temp(dec, (VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_self_partial_temp(dec, (VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVE_TOPOLOGY_LIST_RESTART_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_self_partial_temp(dec, (VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_self_partial_temp(dec, (VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_self_partial_temp(dec, (VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceSubgroupSizeControlFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceSubgroupSizeControlFeatures_self_partial_temp(dec, (VkPhysicalDeviceSubgroupSizeControlFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceLineRasterizationFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceLineRasterizationFeaturesEXT_self_partial_temp(dec, (VkPhysicalDeviceLineRasterizationFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDevicePipelineCreationCacheControlFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDevicePipelineCreationCacheControlFeatures_self_partial_temp(dec, (VkPhysicalDevicePipelineCreationCacheControlFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceVulkan11Features));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceVulkan11Features_self_partial_temp(dec, (VkPhysicalDeviceVulkan11Features *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceVulkan12Features));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceVulkan12Features_self_partial_temp(dec, (VkPhysicalDeviceVulkan12Features *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceVulkan13Features));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceVulkan13Features_self_partial_temp(dec, (VkPhysicalDeviceVulkan13Features *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceCustomBorderColorFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceCustomBorderColorFeaturesEXT_self_partial_temp(dec, (VkPhysicalDeviceCustomBorderColorFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BORDER_COLOR_SWIZZLE_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceBorderColorSwizzleFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_self_partial_temp(dec, (VkPhysicalDeviceBorderColorSwizzleFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceExtendedDynamicStateFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_self_partial_temp(dec, (VkPhysicalDeviceExtendedDynamicStateFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceExtendedDynamicState2FeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_self_partial_temp(dec, (VkPhysicalDeviceExtendedDynamicState2FeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_self_partial_temp(dec, (VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceRobustness2FeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceRobustness2FeaturesEXT_self_partial_temp(dec, (VkPhysicalDeviceRobustness2FeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceImageRobustnessFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceImageRobustnessFeatures_self_partial_temp(dec, (VkPhysicalDeviceImageRobustnessFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDevice4444FormatsFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDevice4444FormatsFeaturesEXT_self_partial_temp(dec, (VkPhysicalDevice4444FormatsFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderTerminateInvocationFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceShaderTerminateInvocationFeatures_self_partial_temp(dec, (VkPhysicalDeviceShaderTerminateInvocationFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_2D_VIEW_OF_3D_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceImage2DViewOf3DFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_self_partial_temp(dec, (VkPhysicalDeviceImage2DViewOf3DFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MUTABLE_DESCRIPTOR_TYPE_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_self_partial_temp(dec, (VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_CONTROL_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceDepthClipControlFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceDepthClipControlFeaturesEXT_self_partial_temp(dec, (VkPhysicalDeviceDepthClipControlFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COLOR_WRITE_ENABLE_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceColorWriteEnableFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceColorWriteEnableFeaturesEXT_self_partial_temp(dec, (VkPhysicalDeviceColorWriteEnableFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceSynchronization2Features));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceSynchronization2Features_self_partial_temp(dec, (VkPhysicalDeviceSynchronization2Features *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVES_GENERATED_QUERY_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_self_partial_temp(dec, (VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_self_partial_temp(dec, (VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceProvokingVertexFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceProvokingVertexFeaturesEXT_self_partial_temp(dec, (VkPhysicalDeviceProvokingVertexFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderIntegerDotProductFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceShaderIntegerDotProductFeatures_self_partial_temp(dec, (VkPhysicalDeviceShaderIntegerDotProductFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceDynamicRenderingFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceDynamicRenderingFeatures_self_partial_temp(dec, (VkPhysicalDeviceDynamicRenderingFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_MIN_LOD_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceImageViewMinLodFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceImageViewMinLodFeaturesEXT_self_partial_temp(dec, (VkPhysicalDeviceImageViewMinLodFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_self_partial_temp(dec, (VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NON_SEAMLESS_CUBE_MAP_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_self_partial_temp(dec, (VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_UNUSED_ATTACHMENTS_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_self_partial_temp(dec, (VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT *)pnext);
        }
        break;
    default:
        /* unexpected struct */
        pnext = NULL;
        vn_cs_decoder_set_fatal(dec);
        break;
    }

    return pnext;
}

static inline void
vn_decode_VkPhysicalDeviceFeatures2_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceFeatures2 *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkPhysicalDeviceFeatures_partial_temp(dec, &val->features);
}

static inline void
vn_decode_VkPhysicalDeviceFeatures2_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceFeatures2 *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceFeatures2_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceFeatures2_self_partial_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceFeatures2_handle_self(VkPhysicalDeviceFeatures2 *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    vn_replace_VkPhysicalDeviceFeatures_handle(&val->features);
}

static inline void
vn_replace_VkPhysicalDeviceFeatures2_handle(VkPhysicalDeviceFeatures2 *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2:
            vn_replace_VkPhysicalDeviceFeatures2_handle_self((VkPhysicalDeviceFeatures2 *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES:
            vn_replace_VkPhysicalDevicePrivateDataFeatures_handle_self((VkPhysicalDevicePrivateDataFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES:
            vn_replace_VkPhysicalDeviceVariablePointersFeatures_handle_self((VkPhysicalDeviceVariablePointersFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES:
            vn_replace_VkPhysicalDeviceMultiviewFeatures_handle_self((VkPhysicalDeviceMultiviewFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES:
            vn_replace_VkPhysicalDevice16BitStorageFeatures_handle_self((VkPhysicalDevice16BitStorageFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES:
            vn_replace_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_handle_self((VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES:
            vn_replace_VkPhysicalDeviceSamplerYcbcrConversionFeatures_handle_self((VkPhysicalDeviceSamplerYcbcrConversionFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES:
            vn_replace_VkPhysicalDeviceProtectedMemoryFeatures_handle_self((VkPhysicalDeviceProtectedMemoryFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceMultiDrawFeaturesEXT_handle_self((VkPhysicalDeviceMultiDrawFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES:
            vn_replace_VkPhysicalDeviceInlineUniformBlockFeatures_handle_self((VkPhysicalDeviceInlineUniformBlockFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES:
            vn_replace_VkPhysicalDeviceMaintenance4Features_handle_self((VkPhysicalDeviceMaintenance4Features *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES:
            vn_replace_VkPhysicalDeviceShaderDrawParametersFeatures_handle_self((VkPhysicalDeviceShaderDrawParametersFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES:
            vn_replace_VkPhysicalDeviceShaderFloat16Int8Features_handle_self((VkPhysicalDeviceShaderFloat16Int8Features *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES:
            vn_replace_VkPhysicalDeviceHostQueryResetFeatures_handle_self((VkPhysicalDeviceHostQueryResetFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES:
            vn_replace_VkPhysicalDeviceDescriptorIndexingFeatures_handle_self((VkPhysicalDeviceDescriptorIndexingFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES:
            vn_replace_VkPhysicalDeviceTimelineSemaphoreFeatures_handle_self((VkPhysicalDeviceTimelineSemaphoreFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES:
            vn_replace_VkPhysicalDevice8BitStorageFeatures_handle_self((VkPhysicalDevice8BitStorageFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONDITIONAL_RENDERING_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceConditionalRenderingFeaturesEXT_handle_self((VkPhysicalDeviceConditionalRenderingFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES:
            vn_replace_VkPhysicalDeviceVulkanMemoryModelFeatures_handle_self((VkPhysicalDeviceVulkanMemoryModelFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES:
            vn_replace_VkPhysicalDeviceShaderAtomicInt64Features_handle_self((VkPhysicalDeviceShaderAtomicInt64Features *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT_handle_self((VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceTransformFeedbackFeaturesEXT_handle_self((VkPhysicalDeviceTransformFeedbackFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES:
            vn_replace_VkPhysicalDeviceScalarBlockLayoutFeatures_handle_self((VkPhysicalDeviceScalarBlockLayoutFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES:
            vn_replace_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_handle_self((VkPhysicalDeviceUniformBufferStandardLayoutFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_ENABLE_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceDepthClipEnableFeaturesEXT_handle_self((VkPhysicalDeviceDepthClipEnableFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES:
            vn_replace_VkPhysicalDeviceBufferDeviceAddressFeatures_handle_self((VkPhysicalDeviceBufferDeviceAddressFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES:
            vn_replace_VkPhysicalDeviceImagelessFramebufferFeatures_handle_self((VkPhysicalDeviceImagelessFramebufferFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES:
            vn_replace_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_handle_self((VkPhysicalDeviceTextureCompressionASTCHDRFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CLOCK_FEATURES_KHR:
            vn_replace_VkPhysicalDeviceShaderClockFeaturesKHR_handle_self((VkPhysicalDeviceShaderClockFeaturesKHR *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceIndexTypeUint8FeaturesEXT_handle_self((VkPhysicalDeviceIndexTypeUint8FeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_INTERLOCK_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_handle_self((VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES:
            vn_replace_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_handle_self((VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVE_TOPOLOGY_LIST_RESTART_FEATURES_EXT:
            vn_replace_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_handle_self((VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES:
            vn_replace_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_handle_self((VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_handle_self((VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES:
            vn_replace_VkPhysicalDeviceSubgroupSizeControlFeatures_handle_self((VkPhysicalDeviceSubgroupSizeControlFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceLineRasterizationFeaturesEXT_handle_self((VkPhysicalDeviceLineRasterizationFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES:
            vn_replace_VkPhysicalDevicePipelineCreationCacheControlFeatures_handle_self((VkPhysicalDevicePipelineCreationCacheControlFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES:
            vn_replace_VkPhysicalDeviceVulkan11Features_handle_self((VkPhysicalDeviceVulkan11Features *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES:
            vn_replace_VkPhysicalDeviceVulkan12Features_handle_self((VkPhysicalDeviceVulkan12Features *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES:
            vn_replace_VkPhysicalDeviceVulkan13Features_handle_self((VkPhysicalDeviceVulkan13Features *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceCustomBorderColorFeaturesEXT_handle_self((VkPhysicalDeviceCustomBorderColorFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BORDER_COLOR_SWIZZLE_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_handle_self((VkPhysicalDeviceBorderColorSwizzleFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_handle_self((VkPhysicalDeviceExtendedDynamicStateFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_handle_self((VkPhysicalDeviceExtendedDynamicState2FeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES:
            vn_replace_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_handle_self((VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceRobustness2FeaturesEXT_handle_self((VkPhysicalDeviceRobustness2FeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES:
            vn_replace_VkPhysicalDeviceImageRobustnessFeatures_handle_self((VkPhysicalDeviceImageRobustnessFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT:
            vn_replace_VkPhysicalDevice4444FormatsFeaturesEXT_handle_self((VkPhysicalDevice4444FormatsFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES:
            vn_replace_VkPhysicalDeviceShaderTerminateInvocationFeatures_handle_self((VkPhysicalDeviceShaderTerminateInvocationFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_2D_VIEW_OF_3D_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_handle_self((VkPhysicalDeviceImage2DViewOf3DFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MUTABLE_DESCRIPTOR_TYPE_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_handle_self((VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_CONTROL_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceDepthClipControlFeaturesEXT_handle_self((VkPhysicalDeviceDepthClipControlFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COLOR_WRITE_ENABLE_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceColorWriteEnableFeaturesEXT_handle_self((VkPhysicalDeviceColorWriteEnableFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES:
            vn_replace_VkPhysicalDeviceSynchronization2Features_handle_self((VkPhysicalDeviceSynchronization2Features *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVES_GENERATED_QUERY_FEATURES_EXT:
            vn_replace_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_handle_self((VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_handle_self((VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceProvokingVertexFeaturesEXT_handle_self((VkPhysicalDeviceProvokingVertexFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES:
            vn_replace_VkPhysicalDeviceShaderIntegerDotProductFeatures_handle_self((VkPhysicalDeviceShaderIntegerDotProductFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES:
            vn_replace_VkPhysicalDeviceDynamicRenderingFeatures_handle_self((VkPhysicalDeviceDynamicRenderingFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_MIN_LOD_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceImageViewMinLodFeaturesEXT_handle_self((VkPhysicalDeviceImageViewMinLodFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_handle_self((VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NON_SEAMLESS_CUBE_MAP_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_handle_self((VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_UNUSED_ATTACHMENTS_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_handle_self((VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkDeviceGroupDeviceCreateInfo chain */

static inline void *
vn_decode_VkDeviceGroupDeviceCreateInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkDeviceGroupDeviceCreateInfo_self_temp(struct vn_cs_decoder *dec, VkDeviceGroupDeviceCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint32_t(dec, &val->physicalDeviceCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, val->physicalDeviceCount);
        val->pPhysicalDevices = vn_cs_decoder_alloc_temp_array(dec, sizeof(*val->pPhysicalDevices), iter_count);
        if (!val->pPhysicalDevices) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkPhysicalDevice_lookup(dec, &((VkPhysicalDevice *)val->pPhysicalDevices)[i]);
    } else {
        vn_decode_array_size(dec, val->physicalDeviceCount);
        val->pPhysicalDevices = NULL;
    }
}

static inline void
vn_decode_VkDeviceGroupDeviceCreateInfo_temp(struct vn_cs_decoder *dec, VkDeviceGroupDeviceCreateInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkDeviceGroupDeviceCreateInfo_pnext_temp(dec);
    vn_decode_VkDeviceGroupDeviceCreateInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkDeviceGroupDeviceCreateInfo_handle_self(VkDeviceGroupDeviceCreateInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->physicalDeviceCount */
    if (val->pPhysicalDevices) {
       for (uint32_t i = 0; i < val->physicalDeviceCount; i++)
            vn_replace_VkPhysicalDevice_handle(&((VkPhysicalDevice *)val->pPhysicalDevices)[i]);
    }
}

static inline void
vn_replace_VkDeviceGroupDeviceCreateInfo_handle(VkDeviceGroupDeviceCreateInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO:
            vn_replace_VkDeviceGroupDeviceCreateInfo_handle_self((VkDeviceGroupDeviceCreateInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkDeviceCreateInfo chain */

static inline void *
vn_decode_VkDeviceCreateInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    VkBaseOutStructure *pnext;
    VkStructureType stype;

    if (!vn_decode_simple_pointer(dec))
        return NULL;

    vn_decode_VkStructureType(dec, &stype);
    switch ((int32_t)stype) {
    case VK_STRUCTURE_TYPE_DEVICE_PRIVATE_DATA_CREATE_INFO:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkDevicePrivateDataCreateInfo));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkDevicePrivateDataCreateInfo_self_temp(dec, (VkDevicePrivateDataCreateInfo *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDevicePrivateDataFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDevicePrivateDataFeatures_self_temp(dec, (VkPhysicalDevicePrivateDataFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceFeatures2));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceFeatures2_self_temp(dec, (VkPhysicalDeviceFeatures2 *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceVariablePointersFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceVariablePointersFeatures_self_temp(dec, (VkPhysicalDeviceVariablePointersFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceMultiviewFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceMultiviewFeatures_self_temp(dec, (VkPhysicalDeviceMultiviewFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkDeviceGroupDeviceCreateInfo));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkDeviceGroupDeviceCreateInfo_self_temp(dec, (VkDeviceGroupDeviceCreateInfo *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDevice16BitStorageFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDevice16BitStorageFeatures_self_temp(dec, (VkPhysicalDevice16BitStorageFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_self_temp(dec, (VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceSamplerYcbcrConversionFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_self_temp(dec, (VkPhysicalDeviceSamplerYcbcrConversionFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceProtectedMemoryFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceProtectedMemoryFeatures_self_temp(dec, (VkPhysicalDeviceProtectedMemoryFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceMultiDrawFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceMultiDrawFeaturesEXT_self_temp(dec, (VkPhysicalDeviceMultiDrawFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceInlineUniformBlockFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceInlineUniformBlockFeatures_self_temp(dec, (VkPhysicalDeviceInlineUniformBlockFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceMaintenance4Features));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceMaintenance4Features_self_temp(dec, (VkPhysicalDeviceMaintenance4Features *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderDrawParametersFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceShaderDrawParametersFeatures_self_temp(dec, (VkPhysicalDeviceShaderDrawParametersFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderFloat16Int8Features));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceShaderFloat16Int8Features_self_temp(dec, (VkPhysicalDeviceShaderFloat16Int8Features *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceHostQueryResetFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceHostQueryResetFeatures_self_temp(dec, (VkPhysicalDeviceHostQueryResetFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceDescriptorIndexingFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceDescriptorIndexingFeatures_self_temp(dec, (VkPhysicalDeviceDescriptorIndexingFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceTimelineSemaphoreFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceTimelineSemaphoreFeatures_self_temp(dec, (VkPhysicalDeviceTimelineSemaphoreFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDevice8BitStorageFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDevice8BitStorageFeatures_self_temp(dec, (VkPhysicalDevice8BitStorageFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONDITIONAL_RENDERING_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceConditionalRenderingFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceConditionalRenderingFeaturesEXT_self_temp(dec, (VkPhysicalDeviceConditionalRenderingFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceVulkanMemoryModelFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceVulkanMemoryModelFeatures_self_temp(dec, (VkPhysicalDeviceVulkanMemoryModelFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderAtomicInt64Features));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceShaderAtomicInt64Features_self_temp(dec, (VkPhysicalDeviceShaderAtomicInt64Features *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT_self_temp(dec, (VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceTransformFeedbackFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_self_temp(dec, (VkPhysicalDeviceTransformFeedbackFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceScalarBlockLayoutFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceScalarBlockLayoutFeatures_self_temp(dec, (VkPhysicalDeviceScalarBlockLayoutFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceUniformBufferStandardLayoutFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_self_temp(dec, (VkPhysicalDeviceUniformBufferStandardLayoutFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_ENABLE_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceDepthClipEnableFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceDepthClipEnableFeaturesEXT_self_temp(dec, (VkPhysicalDeviceDepthClipEnableFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceBufferDeviceAddressFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceBufferDeviceAddressFeatures_self_temp(dec, (VkPhysicalDeviceBufferDeviceAddressFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceImagelessFramebufferFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceImagelessFramebufferFeatures_self_temp(dec, (VkPhysicalDeviceImagelessFramebufferFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceTextureCompressionASTCHDRFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_self_temp(dec, (VkPhysicalDeviceTextureCompressionASTCHDRFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CLOCK_FEATURES_KHR:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderClockFeaturesKHR));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceShaderClockFeaturesKHR_self_temp(dec, (VkPhysicalDeviceShaderClockFeaturesKHR *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceIndexTypeUint8FeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceIndexTypeUint8FeaturesEXT_self_temp(dec, (VkPhysicalDeviceIndexTypeUint8FeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_INTERLOCK_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_self_temp(dec, (VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_self_temp(dec, (VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVE_TOPOLOGY_LIST_RESTART_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_self_temp(dec, (VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_self_temp(dec, (VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_self_temp(dec, (VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceSubgroupSizeControlFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceSubgroupSizeControlFeatures_self_temp(dec, (VkPhysicalDeviceSubgroupSizeControlFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceLineRasterizationFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceLineRasterizationFeaturesEXT_self_temp(dec, (VkPhysicalDeviceLineRasterizationFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDevicePipelineCreationCacheControlFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDevicePipelineCreationCacheControlFeatures_self_temp(dec, (VkPhysicalDevicePipelineCreationCacheControlFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceVulkan11Features));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceVulkan11Features_self_temp(dec, (VkPhysicalDeviceVulkan11Features *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceVulkan12Features));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceVulkan12Features_self_temp(dec, (VkPhysicalDeviceVulkan12Features *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceVulkan13Features));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceVulkan13Features_self_temp(dec, (VkPhysicalDeviceVulkan13Features *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceCustomBorderColorFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceCustomBorderColorFeaturesEXT_self_temp(dec, (VkPhysicalDeviceCustomBorderColorFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BORDER_COLOR_SWIZZLE_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceBorderColorSwizzleFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_self_temp(dec, (VkPhysicalDeviceBorderColorSwizzleFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceExtendedDynamicStateFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_self_temp(dec, (VkPhysicalDeviceExtendedDynamicStateFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceExtendedDynamicState2FeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_self_temp(dec, (VkPhysicalDeviceExtendedDynamicState2FeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_self_temp(dec, (VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceRobustness2FeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceRobustness2FeaturesEXT_self_temp(dec, (VkPhysicalDeviceRobustness2FeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceImageRobustnessFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceImageRobustnessFeatures_self_temp(dec, (VkPhysicalDeviceImageRobustnessFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDevice4444FormatsFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDevice4444FormatsFeaturesEXT_self_temp(dec, (VkPhysicalDevice4444FormatsFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderTerminateInvocationFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceShaderTerminateInvocationFeatures_self_temp(dec, (VkPhysicalDeviceShaderTerminateInvocationFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_2D_VIEW_OF_3D_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceImage2DViewOf3DFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_self_temp(dec, (VkPhysicalDeviceImage2DViewOf3DFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MUTABLE_DESCRIPTOR_TYPE_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_self_temp(dec, (VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_CONTROL_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceDepthClipControlFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceDepthClipControlFeaturesEXT_self_temp(dec, (VkPhysicalDeviceDepthClipControlFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COLOR_WRITE_ENABLE_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceColorWriteEnableFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceColorWriteEnableFeaturesEXT_self_temp(dec, (VkPhysicalDeviceColorWriteEnableFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceSynchronization2Features));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceSynchronization2Features_self_temp(dec, (VkPhysicalDeviceSynchronization2Features *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVES_GENERATED_QUERY_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_self_temp(dec, (VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_self_temp(dec, (VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceProvokingVertexFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceProvokingVertexFeaturesEXT_self_temp(dec, (VkPhysicalDeviceProvokingVertexFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderIntegerDotProductFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceShaderIntegerDotProductFeatures_self_temp(dec, (VkPhysicalDeviceShaderIntegerDotProductFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceDynamicRenderingFeatures));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceDynamicRenderingFeatures_self_temp(dec, (VkPhysicalDeviceDynamicRenderingFeatures *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_MIN_LOD_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceImageViewMinLodFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceImageViewMinLodFeaturesEXT_self_temp(dec, (VkPhysicalDeviceImageViewMinLodFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_self_temp(dec, (VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NON_SEAMLESS_CUBE_MAP_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_self_temp(dec, (VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_UNUSED_ATTACHMENTS_FEATURES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_self_temp(dec, (VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT *)pnext);
        }
        break;
    default:
        /* unexpected struct */
        pnext = NULL;
        vn_cs_decoder_set_fatal(dec);
        break;
    }

    return pnext;
}

static inline void
vn_decode_VkDeviceCreateInfo_self_temp(struct vn_cs_decoder *dec, VkDeviceCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->flags);
    vn_decode_uint32_t(dec, &val->queueCreateInfoCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, val->queueCreateInfoCount);
        val->pQueueCreateInfos = vn_cs_decoder_alloc_temp_array(dec, sizeof(*val->pQueueCreateInfos), iter_count);
        if (!val->pQueueCreateInfos) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkDeviceQueueCreateInfo_temp(dec, &((VkDeviceQueueCreateInfo *)val->pQueueCreateInfos)[i]);
    } else {
        vn_decode_array_size(dec, val->queueCreateInfoCount);
        val->pQueueCreateInfos = NULL;
    }
    vn_decode_uint32_t(dec, &val->enabledLayerCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, val->enabledLayerCount);
        val->ppEnabledLayerNames = vn_cs_decoder_alloc_temp_array(dec, sizeof(*val->ppEnabledLayerNames), iter_count);
        if (!val->ppEnabledLayerNames) return;
        for (uint32_t i = 0; i < iter_count; i++) {
            const size_t string_size = vn_decode_array_size_unchecked(dec);
            ((char **)val->ppEnabledLayerNames)[i] = vn_cs_decoder_alloc_temp_array(dec, sizeof(*val->ppEnabledLayerNames[i]), string_size);
            if (!val->ppEnabledLayerNames[i]) return;
            vn_decode_char_array(dec, ((char **)val->ppEnabledLayerNames)[i], string_size);
        }
    } else {
        vn_decode_array_size(dec, val->enabledLayerCount);
        val->ppEnabledLayerNames = NULL;
    }
    vn_decode_uint32_t(dec, &val->enabledExtensionCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, val->enabledExtensionCount);
        val->ppEnabledExtensionNames = vn_cs_decoder_alloc_temp_array(dec, sizeof(*val->ppEnabledExtensionNames), iter_count);
        if (!val->ppEnabledExtensionNames) return;
        for (uint32_t i = 0; i < iter_count; i++) {
            const size_t string_size = vn_decode_array_size_unchecked(dec);
            ((char **)val->ppEnabledExtensionNames)[i] = vn_cs_decoder_alloc_temp_array(dec, sizeof(*val->ppEnabledExtensionNames[i]), string_size);
            if (!val->ppEnabledExtensionNames[i]) return;
            vn_decode_char_array(dec, ((char **)val->ppEnabledExtensionNames)[i], string_size);
        }
    } else {
        vn_decode_array_size(dec, val->enabledExtensionCount);
        val->ppEnabledExtensionNames = NULL;
    }
    if (vn_decode_simple_pointer(dec)) {
        val->pEnabledFeatures = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pEnabledFeatures));
        if (!val->pEnabledFeatures) return;
        vn_decode_VkPhysicalDeviceFeatures_temp(dec, (VkPhysicalDeviceFeatures *)val->pEnabledFeatures);
    } else {
        val->pEnabledFeatures = NULL;
    }
}

static inline void
vn_decode_VkDeviceCreateInfo_temp(struct vn_cs_decoder *dec, VkDeviceCreateInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_DEVICE_CREATE_INFO)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkDeviceCreateInfo_pnext_temp(dec);
    vn_decode_VkDeviceCreateInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkDeviceCreateInfo_handle_self(VkDeviceCreateInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->flags */
    /* skip val->queueCreateInfoCount */
    if (val->pQueueCreateInfos) {
       for (uint32_t i = 0; i < val->queueCreateInfoCount; i++)
            vn_replace_VkDeviceQueueCreateInfo_handle(&((VkDeviceQueueCreateInfo *)val->pQueueCreateInfos)[i]);
    }
    /* skip val->enabledLayerCount */
    /* skip val->ppEnabledLayerNames */
    /* skip val->enabledExtensionCount */
    /* skip val->ppEnabledExtensionNames */
    if (val->pEnabledFeatures)
        vn_replace_VkPhysicalDeviceFeatures_handle((VkPhysicalDeviceFeatures *)val->pEnabledFeatures);
}

static inline void
vn_replace_VkDeviceCreateInfo_handle(VkDeviceCreateInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_DEVICE_CREATE_INFO:
            vn_replace_VkDeviceCreateInfo_handle_self((VkDeviceCreateInfo *)pnext);
            break;
        case VK_STRUCTURE_TYPE_DEVICE_PRIVATE_DATA_CREATE_INFO:
            vn_replace_VkDevicePrivateDataCreateInfo_handle_self((VkDevicePrivateDataCreateInfo *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES:
            vn_replace_VkPhysicalDevicePrivateDataFeatures_handle_self((VkPhysicalDevicePrivateDataFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2:
            vn_replace_VkPhysicalDeviceFeatures2_handle_self((VkPhysicalDeviceFeatures2 *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES:
            vn_replace_VkPhysicalDeviceVariablePointersFeatures_handle_self((VkPhysicalDeviceVariablePointersFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES:
            vn_replace_VkPhysicalDeviceMultiviewFeatures_handle_self((VkPhysicalDeviceMultiviewFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO:
            vn_replace_VkDeviceGroupDeviceCreateInfo_handle_self((VkDeviceGroupDeviceCreateInfo *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES:
            vn_replace_VkPhysicalDevice16BitStorageFeatures_handle_self((VkPhysicalDevice16BitStorageFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES:
            vn_replace_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_handle_self((VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES:
            vn_replace_VkPhysicalDeviceSamplerYcbcrConversionFeatures_handle_self((VkPhysicalDeviceSamplerYcbcrConversionFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES:
            vn_replace_VkPhysicalDeviceProtectedMemoryFeatures_handle_self((VkPhysicalDeviceProtectedMemoryFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceMultiDrawFeaturesEXT_handle_self((VkPhysicalDeviceMultiDrawFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES:
            vn_replace_VkPhysicalDeviceInlineUniformBlockFeatures_handle_self((VkPhysicalDeviceInlineUniformBlockFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES:
            vn_replace_VkPhysicalDeviceMaintenance4Features_handle_self((VkPhysicalDeviceMaintenance4Features *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES:
            vn_replace_VkPhysicalDeviceShaderDrawParametersFeatures_handle_self((VkPhysicalDeviceShaderDrawParametersFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES:
            vn_replace_VkPhysicalDeviceShaderFloat16Int8Features_handle_self((VkPhysicalDeviceShaderFloat16Int8Features *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES:
            vn_replace_VkPhysicalDeviceHostQueryResetFeatures_handle_self((VkPhysicalDeviceHostQueryResetFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES:
            vn_replace_VkPhysicalDeviceDescriptorIndexingFeatures_handle_self((VkPhysicalDeviceDescriptorIndexingFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES:
            vn_replace_VkPhysicalDeviceTimelineSemaphoreFeatures_handle_self((VkPhysicalDeviceTimelineSemaphoreFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES:
            vn_replace_VkPhysicalDevice8BitStorageFeatures_handle_self((VkPhysicalDevice8BitStorageFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONDITIONAL_RENDERING_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceConditionalRenderingFeaturesEXT_handle_self((VkPhysicalDeviceConditionalRenderingFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES:
            vn_replace_VkPhysicalDeviceVulkanMemoryModelFeatures_handle_self((VkPhysicalDeviceVulkanMemoryModelFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES:
            vn_replace_VkPhysicalDeviceShaderAtomicInt64Features_handle_self((VkPhysicalDeviceShaderAtomicInt64Features *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT_handle_self((VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceTransformFeedbackFeaturesEXT_handle_self((VkPhysicalDeviceTransformFeedbackFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES:
            vn_replace_VkPhysicalDeviceScalarBlockLayoutFeatures_handle_self((VkPhysicalDeviceScalarBlockLayoutFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES:
            vn_replace_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_handle_self((VkPhysicalDeviceUniformBufferStandardLayoutFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_ENABLE_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceDepthClipEnableFeaturesEXT_handle_self((VkPhysicalDeviceDepthClipEnableFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES:
            vn_replace_VkPhysicalDeviceBufferDeviceAddressFeatures_handle_self((VkPhysicalDeviceBufferDeviceAddressFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES:
            vn_replace_VkPhysicalDeviceImagelessFramebufferFeatures_handle_self((VkPhysicalDeviceImagelessFramebufferFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES:
            vn_replace_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_handle_self((VkPhysicalDeviceTextureCompressionASTCHDRFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CLOCK_FEATURES_KHR:
            vn_replace_VkPhysicalDeviceShaderClockFeaturesKHR_handle_self((VkPhysicalDeviceShaderClockFeaturesKHR *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceIndexTypeUint8FeaturesEXT_handle_self((VkPhysicalDeviceIndexTypeUint8FeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_INTERLOCK_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_handle_self((VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES:
            vn_replace_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_handle_self((VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVE_TOPOLOGY_LIST_RESTART_FEATURES_EXT:
            vn_replace_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_handle_self((VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES:
            vn_replace_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_handle_self((VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_handle_self((VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES:
            vn_replace_VkPhysicalDeviceSubgroupSizeControlFeatures_handle_self((VkPhysicalDeviceSubgroupSizeControlFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceLineRasterizationFeaturesEXT_handle_self((VkPhysicalDeviceLineRasterizationFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES:
            vn_replace_VkPhysicalDevicePipelineCreationCacheControlFeatures_handle_self((VkPhysicalDevicePipelineCreationCacheControlFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES:
            vn_replace_VkPhysicalDeviceVulkan11Features_handle_self((VkPhysicalDeviceVulkan11Features *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES:
            vn_replace_VkPhysicalDeviceVulkan12Features_handle_self((VkPhysicalDeviceVulkan12Features *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES:
            vn_replace_VkPhysicalDeviceVulkan13Features_handle_self((VkPhysicalDeviceVulkan13Features *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceCustomBorderColorFeaturesEXT_handle_self((VkPhysicalDeviceCustomBorderColorFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BORDER_COLOR_SWIZZLE_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_handle_self((VkPhysicalDeviceBorderColorSwizzleFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_handle_self((VkPhysicalDeviceExtendedDynamicStateFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_handle_self((VkPhysicalDeviceExtendedDynamicState2FeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES:
            vn_replace_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_handle_self((VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceRobustness2FeaturesEXT_handle_self((VkPhysicalDeviceRobustness2FeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES:
            vn_replace_VkPhysicalDeviceImageRobustnessFeatures_handle_self((VkPhysicalDeviceImageRobustnessFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT:
            vn_replace_VkPhysicalDevice4444FormatsFeaturesEXT_handle_self((VkPhysicalDevice4444FormatsFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES:
            vn_replace_VkPhysicalDeviceShaderTerminateInvocationFeatures_handle_self((VkPhysicalDeviceShaderTerminateInvocationFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_2D_VIEW_OF_3D_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_handle_self((VkPhysicalDeviceImage2DViewOf3DFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MUTABLE_DESCRIPTOR_TYPE_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_handle_self((VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_CONTROL_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceDepthClipControlFeaturesEXT_handle_self((VkPhysicalDeviceDepthClipControlFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COLOR_WRITE_ENABLE_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceColorWriteEnableFeaturesEXT_handle_self((VkPhysicalDeviceColorWriteEnableFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES:
            vn_replace_VkPhysicalDeviceSynchronization2Features_handle_self((VkPhysicalDeviceSynchronization2Features *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVES_GENERATED_QUERY_FEATURES_EXT:
            vn_replace_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_handle_self((VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_handle_self((VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceProvokingVertexFeaturesEXT_handle_self((VkPhysicalDeviceProvokingVertexFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES:
            vn_replace_VkPhysicalDeviceShaderIntegerDotProductFeatures_handle_self((VkPhysicalDeviceShaderIntegerDotProductFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES:
            vn_replace_VkPhysicalDeviceDynamicRenderingFeatures_handle_self((VkPhysicalDeviceDynamicRenderingFeatures *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_MIN_LOD_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceImageViewMinLodFeaturesEXT_handle_self((VkPhysicalDeviceImageViewMinLodFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_handle_self((VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NON_SEAMLESS_CUBE_MAP_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_handle_self((VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_UNUSED_ATTACHMENTS_FEATURES_EXT:
            vn_replace_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_handle_self((VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceMultiDrawPropertiesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceMultiDrawPropertiesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceMultiDrawPropertiesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceMultiDrawPropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->maxMultiDrawCount);
}

static inline void
vn_encode_VkPhysicalDeviceMultiDrawPropertiesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceMultiDrawPropertiesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_PROPERTIES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_PROPERTIES_EXT });
    vn_encode_VkPhysicalDeviceMultiDrawPropertiesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceMultiDrawPropertiesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceMultiDrawPropertiesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceMultiDrawPropertiesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMultiDrawPropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->maxMultiDrawCount */
}

static inline void
vn_decode_VkPhysicalDeviceMultiDrawPropertiesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMultiDrawPropertiesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_PROPERTIES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceMultiDrawPropertiesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceMultiDrawPropertiesEXT_self_partial_temp(dec, val);
}

/* struct VkPhysicalDevicePushDescriptorPropertiesKHR chain */

static inline void
vn_encode_VkPhysicalDevicePushDescriptorPropertiesKHR_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDevicePushDescriptorPropertiesKHR_self(struct vn_cs_encoder *enc, const VkPhysicalDevicePushDescriptorPropertiesKHR *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->maxPushDescriptors);
}

static inline void
vn_encode_VkPhysicalDevicePushDescriptorPropertiesKHR(struct vn_cs_encoder *enc, const VkPhysicalDevicePushDescriptorPropertiesKHR *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PUSH_DESCRIPTOR_PROPERTIES_KHR);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PUSH_DESCRIPTOR_PROPERTIES_KHR });
    vn_encode_VkPhysicalDevicePushDescriptorPropertiesKHR_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDevicePushDescriptorPropertiesKHR_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDevicePushDescriptorPropertiesKHR_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDevicePushDescriptorPropertiesKHR_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDevicePushDescriptorPropertiesKHR *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->maxPushDescriptors */
}

static inline void
vn_decode_VkPhysicalDevicePushDescriptorPropertiesKHR_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDevicePushDescriptorPropertiesKHR *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PUSH_DESCRIPTOR_PROPERTIES_KHR)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDevicePushDescriptorPropertiesKHR_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDevicePushDescriptorPropertiesKHR_self_partial_temp(dec, val);
}

/* struct VkConformanceVersion */

static inline void
vn_encode_VkConformanceVersion(struct vn_cs_encoder *enc, const VkConformanceVersion *val)
{
    vn_encode_uint8_t(enc, &val->major);
    vn_encode_uint8_t(enc, &val->minor);
    vn_encode_uint8_t(enc, &val->subminor);
    vn_encode_uint8_t(enc, &val->patch);
}

static inline void
vn_decode_VkConformanceVersion_partial_temp(struct vn_cs_decoder *dec, VkConformanceVersion *val)
{
    /* skip val->major */
    /* skip val->minor */
    /* skip val->subminor */
    /* skip val->patch */
}

/* struct VkPhysicalDeviceDriverProperties chain */

static inline void
vn_encode_VkPhysicalDeviceDriverProperties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceDriverProperties_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceDriverProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkDriverId(enc, &val->driverID);
    vn_encode_array_size(enc, VK_MAX_DRIVER_NAME_SIZE);
    vn_encode_char_array(enc, val->driverName, VK_MAX_DRIVER_NAME_SIZE);
    vn_encode_array_size(enc, VK_MAX_DRIVER_INFO_SIZE);
    vn_encode_char_array(enc, val->driverInfo, VK_MAX_DRIVER_INFO_SIZE);
    vn_encode_VkConformanceVersion(enc, &val->conformanceVersion);
}

static inline void
vn_encode_VkPhysicalDeviceDriverProperties(struct vn_cs_encoder *enc, const VkPhysicalDeviceDriverProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES });
    vn_encode_VkPhysicalDeviceDriverProperties_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceDriverProperties_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceDriverProperties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceDriverProperties_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDriverProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->driverID */
    /* skip val->driverName */
    /* skip val->driverInfo */
    vn_decode_VkConformanceVersion_partial_temp(dec, &val->conformanceVersion);
}

static inline void
vn_decode_VkPhysicalDeviceDriverProperties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDriverProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceDriverProperties_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceDriverProperties_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceIDProperties chain */

static inline void
vn_encode_VkPhysicalDeviceIDProperties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceIDProperties_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceIDProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_array_size(enc, VK_UUID_SIZE);
    vn_encode_uint8_t_array(enc, val->deviceUUID, VK_UUID_SIZE);
    vn_encode_array_size(enc, VK_UUID_SIZE);
    vn_encode_uint8_t_array(enc, val->driverUUID, VK_UUID_SIZE);
    vn_encode_array_size(enc, VK_LUID_SIZE);
    vn_encode_uint8_t_array(enc, val->deviceLUID, VK_LUID_SIZE);
    vn_encode_uint32_t(enc, &val->deviceNodeMask);
    vn_encode_VkBool32(enc, &val->deviceLUIDValid);
}

static inline void
vn_encode_VkPhysicalDeviceIDProperties(struct vn_cs_encoder *enc, const VkPhysicalDeviceIDProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES });
    vn_encode_VkPhysicalDeviceIDProperties_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceIDProperties_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceIDProperties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceIDProperties_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceIDProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->deviceUUID */
    /* skip val->driverUUID */
    /* skip val->deviceLUID */
    /* skip val->deviceNodeMask */
    /* skip val->deviceLUIDValid */
}

static inline void
vn_decode_VkPhysicalDeviceIDProperties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceIDProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceIDProperties_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceIDProperties_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceMultiviewProperties chain */

static inline void
vn_encode_VkPhysicalDeviceMultiviewProperties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceMultiviewProperties_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceMultiviewProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->maxMultiviewViewCount);
    vn_encode_uint32_t(enc, &val->maxMultiviewInstanceIndex);
}

static inline void
vn_encode_VkPhysicalDeviceMultiviewProperties(struct vn_cs_encoder *enc, const VkPhysicalDeviceMultiviewProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES });
    vn_encode_VkPhysicalDeviceMultiviewProperties_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceMultiviewProperties_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceMultiviewProperties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceMultiviewProperties_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMultiviewProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->maxMultiviewViewCount */
    /* skip val->maxMultiviewInstanceIndex */
}

static inline void
vn_decode_VkPhysicalDeviceMultiviewProperties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMultiviewProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceMultiviewProperties_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceMultiviewProperties_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceSubgroupProperties chain */

static inline void
vn_encode_VkPhysicalDeviceSubgroupProperties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceSubgroupProperties_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceSubgroupProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->subgroupSize);
    vn_encode_VkFlags(enc, &val->supportedStages);
    vn_encode_VkFlags(enc, &val->supportedOperations);
    vn_encode_VkBool32(enc, &val->quadOperationsInAllStages);
}

static inline void
vn_encode_VkPhysicalDeviceSubgroupProperties(struct vn_cs_encoder *enc, const VkPhysicalDeviceSubgroupProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_PROPERTIES });
    vn_encode_VkPhysicalDeviceSubgroupProperties_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceSubgroupProperties_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceSubgroupProperties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceSubgroupProperties_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceSubgroupProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->subgroupSize */
    /* skip val->supportedStages */
    /* skip val->supportedOperations */
    /* skip val->quadOperationsInAllStages */
}

static inline void
vn_decode_VkPhysicalDeviceSubgroupProperties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceSubgroupProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_PROPERTIES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceSubgroupProperties_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceSubgroupProperties_self_partial_temp(dec, val);
}

/* struct VkPhysicalDevicePointClippingProperties chain */

static inline void
vn_encode_VkPhysicalDevicePointClippingProperties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDevicePointClippingProperties_self(struct vn_cs_encoder *enc, const VkPhysicalDevicePointClippingProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkPointClippingBehavior(enc, &val->pointClippingBehavior);
}

static inline void
vn_encode_VkPhysicalDevicePointClippingProperties(struct vn_cs_encoder *enc, const VkPhysicalDevicePointClippingProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES });
    vn_encode_VkPhysicalDevicePointClippingProperties_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDevicePointClippingProperties_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDevicePointClippingProperties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDevicePointClippingProperties_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDevicePointClippingProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->pointClippingBehavior */
}

static inline void
vn_decode_VkPhysicalDevicePointClippingProperties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDevicePointClippingProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDevicePointClippingProperties_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDevicePointClippingProperties_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceProtectedMemoryProperties chain */

static inline void
vn_encode_VkPhysicalDeviceProtectedMemoryProperties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceProtectedMemoryProperties_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceProtectedMemoryProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->protectedNoFault);
}

static inline void
vn_encode_VkPhysicalDeviceProtectedMemoryProperties(struct vn_cs_encoder *enc, const VkPhysicalDeviceProtectedMemoryProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES });
    vn_encode_VkPhysicalDeviceProtectedMemoryProperties_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceProtectedMemoryProperties_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceProtectedMemoryProperties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceProtectedMemoryProperties_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceProtectedMemoryProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->protectedNoFault */
}

static inline void
vn_decode_VkPhysicalDeviceProtectedMemoryProperties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceProtectedMemoryProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceProtectedMemoryProperties_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceProtectedMemoryProperties_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceSamplerFilterMinmaxProperties chain */

static inline void
vn_encode_VkPhysicalDeviceSamplerFilterMinmaxProperties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceSamplerFilterMinmaxProperties_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceSamplerFilterMinmaxProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->filterMinmaxSingleComponentFormats);
    vn_encode_VkBool32(enc, &val->filterMinmaxImageComponentMapping);
}

static inline void
vn_encode_VkPhysicalDeviceSamplerFilterMinmaxProperties(struct vn_cs_encoder *enc, const VkPhysicalDeviceSamplerFilterMinmaxProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES });
    vn_encode_VkPhysicalDeviceSamplerFilterMinmaxProperties_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceSamplerFilterMinmaxProperties_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceSamplerFilterMinmaxProperties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceSamplerFilterMinmaxProperties_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceSamplerFilterMinmaxProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->filterMinmaxSingleComponentFormats */
    /* skip val->filterMinmaxImageComponentMapping */
}

static inline void
vn_decode_VkPhysicalDeviceSamplerFilterMinmaxProperties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceSamplerFilterMinmaxProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceSamplerFilterMinmaxProperties_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceSamplerFilterMinmaxProperties_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceInlineUniformBlockProperties chain */

static inline void
vn_encode_VkPhysicalDeviceInlineUniformBlockProperties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceInlineUniformBlockProperties_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceInlineUniformBlockProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->maxInlineUniformBlockSize);
    vn_encode_uint32_t(enc, &val->maxPerStageDescriptorInlineUniformBlocks);
    vn_encode_uint32_t(enc, &val->maxPerStageDescriptorUpdateAfterBindInlineUniformBlocks);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetInlineUniformBlocks);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetUpdateAfterBindInlineUniformBlocks);
}

static inline void
vn_encode_VkPhysicalDeviceInlineUniformBlockProperties(struct vn_cs_encoder *enc, const VkPhysicalDeviceInlineUniformBlockProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_PROPERTIES });
    vn_encode_VkPhysicalDeviceInlineUniformBlockProperties_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceInlineUniformBlockProperties_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceInlineUniformBlockProperties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceInlineUniformBlockProperties_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceInlineUniformBlockProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->maxInlineUniformBlockSize */
    /* skip val->maxPerStageDescriptorInlineUniformBlocks */
    /* skip val->maxPerStageDescriptorUpdateAfterBindInlineUniformBlocks */
    /* skip val->maxDescriptorSetInlineUniformBlocks */
    /* skip val->maxDescriptorSetUpdateAfterBindInlineUniformBlocks */
}

static inline void
vn_decode_VkPhysicalDeviceInlineUniformBlockProperties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceInlineUniformBlockProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_PROPERTIES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceInlineUniformBlockProperties_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceInlineUniformBlockProperties_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceMaintenance3Properties chain */

static inline void
vn_encode_VkPhysicalDeviceMaintenance3Properties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceMaintenance3Properties_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceMaintenance3Properties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->maxPerSetDescriptors);
    vn_encode_VkDeviceSize(enc, &val->maxMemoryAllocationSize);
}

static inline void
vn_encode_VkPhysicalDeviceMaintenance3Properties(struct vn_cs_encoder *enc, const VkPhysicalDeviceMaintenance3Properties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES });
    vn_encode_VkPhysicalDeviceMaintenance3Properties_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceMaintenance3Properties_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceMaintenance3Properties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceMaintenance3Properties_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMaintenance3Properties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->maxPerSetDescriptors */
    /* skip val->maxMemoryAllocationSize */
}

static inline void
vn_decode_VkPhysicalDeviceMaintenance3Properties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMaintenance3Properties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceMaintenance3Properties_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceMaintenance3Properties_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceMaintenance4Properties chain */

static inline void
vn_encode_VkPhysicalDeviceMaintenance4Properties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceMaintenance4Properties_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceMaintenance4Properties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkDeviceSize(enc, &val->maxBufferSize);
}

static inline void
vn_encode_VkPhysicalDeviceMaintenance4Properties(struct vn_cs_encoder *enc, const VkPhysicalDeviceMaintenance4Properties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_PROPERTIES });
    vn_encode_VkPhysicalDeviceMaintenance4Properties_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceMaintenance4Properties_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceMaintenance4Properties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceMaintenance4Properties_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMaintenance4Properties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->maxBufferSize */
}

static inline void
vn_decode_VkPhysicalDeviceMaintenance4Properties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMaintenance4Properties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_PROPERTIES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceMaintenance4Properties_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceMaintenance4Properties_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceFloatControlsProperties chain */

static inline void
vn_encode_VkPhysicalDeviceFloatControlsProperties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceFloatControlsProperties_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceFloatControlsProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkShaderFloatControlsIndependence(enc, &val->denormBehaviorIndependence);
    vn_encode_VkShaderFloatControlsIndependence(enc, &val->roundingModeIndependence);
    vn_encode_VkBool32(enc, &val->shaderSignedZeroInfNanPreserveFloat16);
    vn_encode_VkBool32(enc, &val->shaderSignedZeroInfNanPreserveFloat32);
    vn_encode_VkBool32(enc, &val->shaderSignedZeroInfNanPreserveFloat64);
    vn_encode_VkBool32(enc, &val->shaderDenormPreserveFloat16);
    vn_encode_VkBool32(enc, &val->shaderDenormPreserveFloat32);
    vn_encode_VkBool32(enc, &val->shaderDenormPreserveFloat64);
    vn_encode_VkBool32(enc, &val->shaderDenormFlushToZeroFloat16);
    vn_encode_VkBool32(enc, &val->shaderDenormFlushToZeroFloat32);
    vn_encode_VkBool32(enc, &val->shaderDenormFlushToZeroFloat64);
    vn_encode_VkBool32(enc, &val->shaderRoundingModeRTEFloat16);
    vn_encode_VkBool32(enc, &val->shaderRoundingModeRTEFloat32);
    vn_encode_VkBool32(enc, &val->shaderRoundingModeRTEFloat64);
    vn_encode_VkBool32(enc, &val->shaderRoundingModeRTZFloat16);
    vn_encode_VkBool32(enc, &val->shaderRoundingModeRTZFloat32);
    vn_encode_VkBool32(enc, &val->shaderRoundingModeRTZFloat64);
}

static inline void
vn_encode_VkPhysicalDeviceFloatControlsProperties(struct vn_cs_encoder *enc, const VkPhysicalDeviceFloatControlsProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES });
    vn_encode_VkPhysicalDeviceFloatControlsProperties_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceFloatControlsProperties_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceFloatControlsProperties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceFloatControlsProperties_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceFloatControlsProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->denormBehaviorIndependence */
    /* skip val->roundingModeIndependence */
    /* skip val->shaderSignedZeroInfNanPreserveFloat16 */
    /* skip val->shaderSignedZeroInfNanPreserveFloat32 */
    /* skip val->shaderSignedZeroInfNanPreserveFloat64 */
    /* skip val->shaderDenormPreserveFloat16 */
    /* skip val->shaderDenormPreserveFloat32 */
    /* skip val->shaderDenormPreserveFloat64 */
    /* skip val->shaderDenormFlushToZeroFloat16 */
    /* skip val->shaderDenormFlushToZeroFloat32 */
    /* skip val->shaderDenormFlushToZeroFloat64 */
    /* skip val->shaderRoundingModeRTEFloat16 */
    /* skip val->shaderRoundingModeRTEFloat32 */
    /* skip val->shaderRoundingModeRTEFloat64 */
    /* skip val->shaderRoundingModeRTZFloat16 */
    /* skip val->shaderRoundingModeRTZFloat32 */
    /* skip val->shaderRoundingModeRTZFloat64 */
}

static inline void
vn_decode_VkPhysicalDeviceFloatControlsProperties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceFloatControlsProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceFloatControlsProperties_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceFloatControlsProperties_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceConservativeRasterizationPropertiesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceConservativeRasterizationPropertiesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceConservativeRasterizationPropertiesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceConservativeRasterizationPropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_float(enc, &val->primitiveOverestimationSize);
    vn_encode_float(enc, &val->maxExtraPrimitiveOverestimationSize);
    vn_encode_float(enc, &val->extraPrimitiveOverestimationSizeGranularity);
    vn_encode_VkBool32(enc, &val->primitiveUnderestimation);
    vn_encode_VkBool32(enc, &val->conservativePointAndLineRasterization);
    vn_encode_VkBool32(enc, &val->degenerateTrianglesRasterized);
    vn_encode_VkBool32(enc, &val->degenerateLinesRasterized);
    vn_encode_VkBool32(enc, &val->fullyCoveredFragmentShaderInputVariable);
    vn_encode_VkBool32(enc, &val->conservativeRasterizationPostDepthCoverage);
}

static inline void
vn_encode_VkPhysicalDeviceConservativeRasterizationPropertiesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceConservativeRasterizationPropertiesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONSERVATIVE_RASTERIZATION_PROPERTIES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONSERVATIVE_RASTERIZATION_PROPERTIES_EXT });
    vn_encode_VkPhysicalDeviceConservativeRasterizationPropertiesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceConservativeRasterizationPropertiesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceConservativeRasterizationPropertiesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceConservativeRasterizationPropertiesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceConservativeRasterizationPropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->primitiveOverestimationSize */
    /* skip val->maxExtraPrimitiveOverestimationSize */
    /* skip val->extraPrimitiveOverestimationSizeGranularity */
    /* skip val->primitiveUnderestimation */
    /* skip val->conservativePointAndLineRasterization */
    /* skip val->degenerateTrianglesRasterized */
    /* skip val->degenerateLinesRasterized */
    /* skip val->fullyCoveredFragmentShaderInputVariable */
    /* skip val->conservativeRasterizationPostDepthCoverage */
}

static inline void
vn_decode_VkPhysicalDeviceConservativeRasterizationPropertiesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceConservativeRasterizationPropertiesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONSERVATIVE_RASTERIZATION_PROPERTIES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceConservativeRasterizationPropertiesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceConservativeRasterizationPropertiesEXT_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceDescriptorIndexingProperties chain */

static inline void
vn_encode_VkPhysicalDeviceDescriptorIndexingProperties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceDescriptorIndexingProperties_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceDescriptorIndexingProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->maxUpdateAfterBindDescriptorsInAllPools);
    vn_encode_VkBool32(enc, &val->shaderUniformBufferArrayNonUniformIndexingNative);
    vn_encode_VkBool32(enc, &val->shaderSampledImageArrayNonUniformIndexingNative);
    vn_encode_VkBool32(enc, &val->shaderStorageBufferArrayNonUniformIndexingNative);
    vn_encode_VkBool32(enc, &val->shaderStorageImageArrayNonUniformIndexingNative);
    vn_encode_VkBool32(enc, &val->shaderInputAttachmentArrayNonUniformIndexingNative);
    vn_encode_VkBool32(enc, &val->robustBufferAccessUpdateAfterBind);
    vn_encode_VkBool32(enc, &val->quadDivergentImplicitLod);
    vn_encode_uint32_t(enc, &val->maxPerStageDescriptorUpdateAfterBindSamplers);
    vn_encode_uint32_t(enc, &val->maxPerStageDescriptorUpdateAfterBindUniformBuffers);
    vn_encode_uint32_t(enc, &val->maxPerStageDescriptorUpdateAfterBindStorageBuffers);
    vn_encode_uint32_t(enc, &val->maxPerStageDescriptorUpdateAfterBindSampledImages);
    vn_encode_uint32_t(enc, &val->maxPerStageDescriptorUpdateAfterBindStorageImages);
    vn_encode_uint32_t(enc, &val->maxPerStageDescriptorUpdateAfterBindInputAttachments);
    vn_encode_uint32_t(enc, &val->maxPerStageUpdateAfterBindResources);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetUpdateAfterBindSamplers);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetUpdateAfterBindUniformBuffers);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetUpdateAfterBindUniformBuffersDynamic);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetUpdateAfterBindStorageBuffers);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetUpdateAfterBindStorageBuffersDynamic);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetUpdateAfterBindSampledImages);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetUpdateAfterBindStorageImages);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetUpdateAfterBindInputAttachments);
}

static inline void
vn_encode_VkPhysicalDeviceDescriptorIndexingProperties(struct vn_cs_encoder *enc, const VkPhysicalDeviceDescriptorIndexingProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES });
    vn_encode_VkPhysicalDeviceDescriptorIndexingProperties_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceDescriptorIndexingProperties_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceDescriptorIndexingProperties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceDescriptorIndexingProperties_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDescriptorIndexingProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->maxUpdateAfterBindDescriptorsInAllPools */
    /* skip val->shaderUniformBufferArrayNonUniformIndexingNative */
    /* skip val->shaderSampledImageArrayNonUniformIndexingNative */
    /* skip val->shaderStorageBufferArrayNonUniformIndexingNative */
    /* skip val->shaderStorageImageArrayNonUniformIndexingNative */
    /* skip val->shaderInputAttachmentArrayNonUniformIndexingNative */
    /* skip val->robustBufferAccessUpdateAfterBind */
    /* skip val->quadDivergentImplicitLod */
    /* skip val->maxPerStageDescriptorUpdateAfterBindSamplers */
    /* skip val->maxPerStageDescriptorUpdateAfterBindUniformBuffers */
    /* skip val->maxPerStageDescriptorUpdateAfterBindStorageBuffers */
    /* skip val->maxPerStageDescriptorUpdateAfterBindSampledImages */
    /* skip val->maxPerStageDescriptorUpdateAfterBindStorageImages */
    /* skip val->maxPerStageDescriptorUpdateAfterBindInputAttachments */
    /* skip val->maxPerStageUpdateAfterBindResources */
    /* skip val->maxDescriptorSetUpdateAfterBindSamplers */
    /* skip val->maxDescriptorSetUpdateAfterBindUniformBuffers */
    /* skip val->maxDescriptorSetUpdateAfterBindUniformBuffersDynamic */
    /* skip val->maxDescriptorSetUpdateAfterBindStorageBuffers */
    /* skip val->maxDescriptorSetUpdateAfterBindStorageBuffersDynamic */
    /* skip val->maxDescriptorSetUpdateAfterBindSampledImages */
    /* skip val->maxDescriptorSetUpdateAfterBindStorageImages */
    /* skip val->maxDescriptorSetUpdateAfterBindInputAttachments */
}

static inline void
vn_decode_VkPhysicalDeviceDescriptorIndexingProperties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDescriptorIndexingProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceDescriptorIndexingProperties_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceDescriptorIndexingProperties_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceTimelineSemaphoreProperties chain */

static inline void
vn_encode_VkPhysicalDeviceTimelineSemaphoreProperties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceTimelineSemaphoreProperties_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceTimelineSemaphoreProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint64_t(enc, &val->maxTimelineSemaphoreValueDifference);
}

static inline void
vn_encode_VkPhysicalDeviceTimelineSemaphoreProperties(struct vn_cs_encoder *enc, const VkPhysicalDeviceTimelineSemaphoreProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES });
    vn_encode_VkPhysicalDeviceTimelineSemaphoreProperties_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceTimelineSemaphoreProperties_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceTimelineSemaphoreProperties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceTimelineSemaphoreProperties_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceTimelineSemaphoreProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->maxTimelineSemaphoreValueDifference */
}

static inline void
vn_decode_VkPhysicalDeviceTimelineSemaphoreProperties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceTimelineSemaphoreProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceTimelineSemaphoreProperties_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceTimelineSemaphoreProperties_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->maxVertexAttribDivisor);
}

static inline void
vn_encode_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES_EXT });
    vn_encode_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->maxVertexAttribDivisor */
}

static inline void
vn_decode_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT_self_partial_temp(dec, val);
}

/* struct VkPhysicalDevicePCIBusInfoPropertiesEXT chain */

static inline void
vn_encode_VkPhysicalDevicePCIBusInfoPropertiesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDevicePCIBusInfoPropertiesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDevicePCIBusInfoPropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->pciDomain);
    vn_encode_uint32_t(enc, &val->pciBus);
    vn_encode_uint32_t(enc, &val->pciDevice);
    vn_encode_uint32_t(enc, &val->pciFunction);
}

static inline void
vn_encode_VkPhysicalDevicePCIBusInfoPropertiesEXT(struct vn_cs_encoder *enc, const VkPhysicalDevicePCIBusInfoPropertiesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PCI_BUS_INFO_PROPERTIES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PCI_BUS_INFO_PROPERTIES_EXT });
    vn_encode_VkPhysicalDevicePCIBusInfoPropertiesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDevicePCIBusInfoPropertiesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDevicePCIBusInfoPropertiesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDevicePCIBusInfoPropertiesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDevicePCIBusInfoPropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->pciDomain */
    /* skip val->pciBus */
    /* skip val->pciDevice */
    /* skip val->pciFunction */
}

static inline void
vn_decode_VkPhysicalDevicePCIBusInfoPropertiesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDevicePCIBusInfoPropertiesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PCI_BUS_INFO_PROPERTIES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDevicePCIBusInfoPropertiesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDevicePCIBusInfoPropertiesEXT_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceDepthStencilResolveProperties chain */

static inline void
vn_encode_VkPhysicalDeviceDepthStencilResolveProperties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceDepthStencilResolveProperties_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceDepthStencilResolveProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFlags(enc, &val->supportedDepthResolveModes);
    vn_encode_VkFlags(enc, &val->supportedStencilResolveModes);
    vn_encode_VkBool32(enc, &val->independentResolveNone);
    vn_encode_VkBool32(enc, &val->independentResolve);
}

static inline void
vn_encode_VkPhysicalDeviceDepthStencilResolveProperties(struct vn_cs_encoder *enc, const VkPhysicalDeviceDepthStencilResolveProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES });
    vn_encode_VkPhysicalDeviceDepthStencilResolveProperties_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceDepthStencilResolveProperties_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceDepthStencilResolveProperties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceDepthStencilResolveProperties_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDepthStencilResolveProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->supportedDepthResolveModes */
    /* skip val->supportedStencilResolveModes */
    /* skip val->independentResolveNone */
    /* skip val->independentResolve */
}

static inline void
vn_decode_VkPhysicalDeviceDepthStencilResolveProperties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceDepthStencilResolveProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceDepthStencilResolveProperties_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceDepthStencilResolveProperties_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceTransformFeedbackPropertiesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceTransformFeedbackPropertiesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceTransformFeedbackPropertiesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceTransformFeedbackPropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->maxTransformFeedbackStreams);
    vn_encode_uint32_t(enc, &val->maxTransformFeedbackBuffers);
    vn_encode_VkDeviceSize(enc, &val->maxTransformFeedbackBufferSize);
    vn_encode_uint32_t(enc, &val->maxTransformFeedbackStreamDataSize);
    vn_encode_uint32_t(enc, &val->maxTransformFeedbackBufferDataSize);
    vn_encode_uint32_t(enc, &val->maxTransformFeedbackBufferDataStride);
    vn_encode_VkBool32(enc, &val->transformFeedbackQueries);
    vn_encode_VkBool32(enc, &val->transformFeedbackStreamsLinesTriangles);
    vn_encode_VkBool32(enc, &val->transformFeedbackRasterizationStreamSelect);
    vn_encode_VkBool32(enc, &val->transformFeedbackDraw);
}

static inline void
vn_encode_VkPhysicalDeviceTransformFeedbackPropertiesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceTransformFeedbackPropertiesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_PROPERTIES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_PROPERTIES_EXT });
    vn_encode_VkPhysicalDeviceTransformFeedbackPropertiesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceTransformFeedbackPropertiesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceTransformFeedbackPropertiesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceTransformFeedbackPropertiesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceTransformFeedbackPropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->maxTransformFeedbackStreams */
    /* skip val->maxTransformFeedbackBuffers */
    /* skip val->maxTransformFeedbackBufferSize */
    /* skip val->maxTransformFeedbackStreamDataSize */
    /* skip val->maxTransformFeedbackBufferDataSize */
    /* skip val->maxTransformFeedbackBufferDataStride */
    /* skip val->transformFeedbackQueries */
    /* skip val->transformFeedbackStreamsLinesTriangles */
    /* skip val->transformFeedbackRasterizationStreamSelect */
    /* skip val->transformFeedbackDraw */
}

static inline void
vn_decode_VkPhysicalDeviceTransformFeedbackPropertiesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceTransformFeedbackPropertiesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_PROPERTIES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceTransformFeedbackPropertiesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceTransformFeedbackPropertiesEXT_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceTexelBufferAlignmentProperties chain */

static inline void
vn_encode_VkPhysicalDeviceTexelBufferAlignmentProperties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceTexelBufferAlignmentProperties_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceTexelBufferAlignmentProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkDeviceSize(enc, &val->storageTexelBufferOffsetAlignmentBytes);
    vn_encode_VkBool32(enc, &val->storageTexelBufferOffsetSingleTexelAlignment);
    vn_encode_VkDeviceSize(enc, &val->uniformTexelBufferOffsetAlignmentBytes);
    vn_encode_VkBool32(enc, &val->uniformTexelBufferOffsetSingleTexelAlignment);
}

static inline void
vn_encode_VkPhysicalDeviceTexelBufferAlignmentProperties(struct vn_cs_encoder *enc, const VkPhysicalDeviceTexelBufferAlignmentProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_PROPERTIES });
    vn_encode_VkPhysicalDeviceTexelBufferAlignmentProperties_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceTexelBufferAlignmentProperties_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceTexelBufferAlignmentProperties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceTexelBufferAlignmentProperties_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceTexelBufferAlignmentProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->storageTexelBufferOffsetAlignmentBytes */
    /* skip val->storageTexelBufferOffsetSingleTexelAlignment */
    /* skip val->uniformTexelBufferOffsetAlignmentBytes */
    /* skip val->uniformTexelBufferOffsetSingleTexelAlignment */
}

static inline void
vn_decode_VkPhysicalDeviceTexelBufferAlignmentProperties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceTexelBufferAlignmentProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_PROPERTIES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceTexelBufferAlignmentProperties_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceTexelBufferAlignmentProperties_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceSubgroupSizeControlProperties chain */

static inline void
vn_encode_VkPhysicalDeviceSubgroupSizeControlProperties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceSubgroupSizeControlProperties_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceSubgroupSizeControlProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->minSubgroupSize);
    vn_encode_uint32_t(enc, &val->maxSubgroupSize);
    vn_encode_uint32_t(enc, &val->maxComputeWorkgroupSubgroups);
    vn_encode_VkFlags(enc, &val->requiredSubgroupSizeStages);
}

static inline void
vn_encode_VkPhysicalDeviceSubgroupSizeControlProperties(struct vn_cs_encoder *enc, const VkPhysicalDeviceSubgroupSizeControlProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_PROPERTIES });
    vn_encode_VkPhysicalDeviceSubgroupSizeControlProperties_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceSubgroupSizeControlProperties_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceSubgroupSizeControlProperties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceSubgroupSizeControlProperties_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceSubgroupSizeControlProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->minSubgroupSize */
    /* skip val->maxSubgroupSize */
    /* skip val->maxComputeWorkgroupSubgroups */
    /* skip val->requiredSubgroupSizeStages */
}

static inline void
vn_decode_VkPhysicalDeviceSubgroupSizeControlProperties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceSubgroupSizeControlProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_PROPERTIES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceSubgroupSizeControlProperties_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceSubgroupSizeControlProperties_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceLineRasterizationPropertiesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceLineRasterizationPropertiesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceLineRasterizationPropertiesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceLineRasterizationPropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->lineSubPixelPrecisionBits);
}

static inline void
vn_encode_VkPhysicalDeviceLineRasterizationPropertiesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceLineRasterizationPropertiesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_PROPERTIES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_PROPERTIES_EXT });
    vn_encode_VkPhysicalDeviceLineRasterizationPropertiesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceLineRasterizationPropertiesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceLineRasterizationPropertiesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceLineRasterizationPropertiesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceLineRasterizationPropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->lineSubPixelPrecisionBits */
}

static inline void
vn_decode_VkPhysicalDeviceLineRasterizationPropertiesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceLineRasterizationPropertiesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_PROPERTIES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceLineRasterizationPropertiesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceLineRasterizationPropertiesEXT_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceVulkan11Properties chain */

static inline void
vn_encode_VkPhysicalDeviceVulkan11Properties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceVulkan11Properties_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan11Properties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_array_size(enc, VK_UUID_SIZE);
    vn_encode_uint8_t_array(enc, val->deviceUUID, VK_UUID_SIZE);
    vn_encode_array_size(enc, VK_UUID_SIZE);
    vn_encode_uint8_t_array(enc, val->driverUUID, VK_UUID_SIZE);
    vn_encode_array_size(enc, VK_LUID_SIZE);
    vn_encode_uint8_t_array(enc, val->deviceLUID, VK_LUID_SIZE);
    vn_encode_uint32_t(enc, &val->deviceNodeMask);
    vn_encode_VkBool32(enc, &val->deviceLUIDValid);
    vn_encode_uint32_t(enc, &val->subgroupSize);
    vn_encode_VkFlags(enc, &val->subgroupSupportedStages);
    vn_encode_VkFlags(enc, &val->subgroupSupportedOperations);
    vn_encode_VkBool32(enc, &val->subgroupQuadOperationsInAllStages);
    vn_encode_VkPointClippingBehavior(enc, &val->pointClippingBehavior);
    vn_encode_uint32_t(enc, &val->maxMultiviewViewCount);
    vn_encode_uint32_t(enc, &val->maxMultiviewInstanceIndex);
    vn_encode_VkBool32(enc, &val->protectedNoFault);
    vn_encode_uint32_t(enc, &val->maxPerSetDescriptors);
    vn_encode_VkDeviceSize(enc, &val->maxMemoryAllocationSize);
}

static inline void
vn_encode_VkPhysicalDeviceVulkan11Properties(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan11Properties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES });
    vn_encode_VkPhysicalDeviceVulkan11Properties_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceVulkan11Properties_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceVulkan11Properties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceVulkan11Properties_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan11Properties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->deviceUUID */
    /* skip val->driverUUID */
    /* skip val->deviceLUID */
    /* skip val->deviceNodeMask */
    /* skip val->deviceLUIDValid */
    /* skip val->subgroupSize */
    /* skip val->subgroupSupportedStages */
    /* skip val->subgroupSupportedOperations */
    /* skip val->subgroupQuadOperationsInAllStages */
    /* skip val->pointClippingBehavior */
    /* skip val->maxMultiviewViewCount */
    /* skip val->maxMultiviewInstanceIndex */
    /* skip val->protectedNoFault */
    /* skip val->maxPerSetDescriptors */
    /* skip val->maxMemoryAllocationSize */
}

static inline void
vn_decode_VkPhysicalDeviceVulkan11Properties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan11Properties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceVulkan11Properties_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceVulkan11Properties_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceVulkan12Properties chain */

static inline void
vn_encode_VkPhysicalDeviceVulkan12Properties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceVulkan12Properties_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan12Properties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkDriverId(enc, &val->driverID);
    vn_encode_array_size(enc, VK_MAX_DRIVER_NAME_SIZE);
    vn_encode_char_array(enc, val->driverName, VK_MAX_DRIVER_NAME_SIZE);
    vn_encode_array_size(enc, VK_MAX_DRIVER_INFO_SIZE);
    vn_encode_char_array(enc, val->driverInfo, VK_MAX_DRIVER_INFO_SIZE);
    vn_encode_VkConformanceVersion(enc, &val->conformanceVersion);
    vn_encode_VkShaderFloatControlsIndependence(enc, &val->denormBehaviorIndependence);
    vn_encode_VkShaderFloatControlsIndependence(enc, &val->roundingModeIndependence);
    vn_encode_VkBool32(enc, &val->shaderSignedZeroInfNanPreserveFloat16);
    vn_encode_VkBool32(enc, &val->shaderSignedZeroInfNanPreserveFloat32);
    vn_encode_VkBool32(enc, &val->shaderSignedZeroInfNanPreserveFloat64);
    vn_encode_VkBool32(enc, &val->shaderDenormPreserveFloat16);
    vn_encode_VkBool32(enc, &val->shaderDenormPreserveFloat32);
    vn_encode_VkBool32(enc, &val->shaderDenormPreserveFloat64);
    vn_encode_VkBool32(enc, &val->shaderDenormFlushToZeroFloat16);
    vn_encode_VkBool32(enc, &val->shaderDenormFlushToZeroFloat32);
    vn_encode_VkBool32(enc, &val->shaderDenormFlushToZeroFloat64);
    vn_encode_VkBool32(enc, &val->shaderRoundingModeRTEFloat16);
    vn_encode_VkBool32(enc, &val->shaderRoundingModeRTEFloat32);
    vn_encode_VkBool32(enc, &val->shaderRoundingModeRTEFloat64);
    vn_encode_VkBool32(enc, &val->shaderRoundingModeRTZFloat16);
    vn_encode_VkBool32(enc, &val->shaderRoundingModeRTZFloat32);
    vn_encode_VkBool32(enc, &val->shaderRoundingModeRTZFloat64);
    vn_encode_uint32_t(enc, &val->maxUpdateAfterBindDescriptorsInAllPools);
    vn_encode_VkBool32(enc, &val->shaderUniformBufferArrayNonUniformIndexingNative);
    vn_encode_VkBool32(enc, &val->shaderSampledImageArrayNonUniformIndexingNative);
    vn_encode_VkBool32(enc, &val->shaderStorageBufferArrayNonUniformIndexingNative);
    vn_encode_VkBool32(enc, &val->shaderStorageImageArrayNonUniformIndexingNative);
    vn_encode_VkBool32(enc, &val->shaderInputAttachmentArrayNonUniformIndexingNative);
    vn_encode_VkBool32(enc, &val->robustBufferAccessUpdateAfterBind);
    vn_encode_VkBool32(enc, &val->quadDivergentImplicitLod);
    vn_encode_uint32_t(enc, &val->maxPerStageDescriptorUpdateAfterBindSamplers);
    vn_encode_uint32_t(enc, &val->maxPerStageDescriptorUpdateAfterBindUniformBuffers);
    vn_encode_uint32_t(enc, &val->maxPerStageDescriptorUpdateAfterBindStorageBuffers);
    vn_encode_uint32_t(enc, &val->maxPerStageDescriptorUpdateAfterBindSampledImages);
    vn_encode_uint32_t(enc, &val->maxPerStageDescriptorUpdateAfterBindStorageImages);
    vn_encode_uint32_t(enc, &val->maxPerStageDescriptorUpdateAfterBindInputAttachments);
    vn_encode_uint32_t(enc, &val->maxPerStageUpdateAfterBindResources);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetUpdateAfterBindSamplers);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetUpdateAfterBindUniformBuffers);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetUpdateAfterBindUniformBuffersDynamic);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetUpdateAfterBindStorageBuffers);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetUpdateAfterBindStorageBuffersDynamic);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetUpdateAfterBindSampledImages);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetUpdateAfterBindStorageImages);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetUpdateAfterBindInputAttachments);
    vn_encode_VkFlags(enc, &val->supportedDepthResolveModes);
    vn_encode_VkFlags(enc, &val->supportedStencilResolveModes);
    vn_encode_VkBool32(enc, &val->independentResolveNone);
    vn_encode_VkBool32(enc, &val->independentResolve);
    vn_encode_VkBool32(enc, &val->filterMinmaxSingleComponentFormats);
    vn_encode_VkBool32(enc, &val->filterMinmaxImageComponentMapping);
    vn_encode_uint64_t(enc, &val->maxTimelineSemaphoreValueDifference);
    vn_encode_VkFlags(enc, &val->framebufferIntegerColorSampleCounts);
}

static inline void
vn_encode_VkPhysicalDeviceVulkan12Properties(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan12Properties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES });
    vn_encode_VkPhysicalDeviceVulkan12Properties_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceVulkan12Properties_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceVulkan12Properties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceVulkan12Properties_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan12Properties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->driverID */
    /* skip val->driverName */
    /* skip val->driverInfo */
    vn_decode_VkConformanceVersion_partial_temp(dec, &val->conformanceVersion);
    /* skip val->denormBehaviorIndependence */
    /* skip val->roundingModeIndependence */
    /* skip val->shaderSignedZeroInfNanPreserveFloat16 */
    /* skip val->shaderSignedZeroInfNanPreserveFloat32 */
    /* skip val->shaderSignedZeroInfNanPreserveFloat64 */
    /* skip val->shaderDenormPreserveFloat16 */
    /* skip val->shaderDenormPreserveFloat32 */
    /* skip val->shaderDenormPreserveFloat64 */
    /* skip val->shaderDenormFlushToZeroFloat16 */
    /* skip val->shaderDenormFlushToZeroFloat32 */
    /* skip val->shaderDenormFlushToZeroFloat64 */
    /* skip val->shaderRoundingModeRTEFloat16 */
    /* skip val->shaderRoundingModeRTEFloat32 */
    /* skip val->shaderRoundingModeRTEFloat64 */
    /* skip val->shaderRoundingModeRTZFloat16 */
    /* skip val->shaderRoundingModeRTZFloat32 */
    /* skip val->shaderRoundingModeRTZFloat64 */
    /* skip val->maxUpdateAfterBindDescriptorsInAllPools */
    /* skip val->shaderUniformBufferArrayNonUniformIndexingNative */
    /* skip val->shaderSampledImageArrayNonUniformIndexingNative */
    /* skip val->shaderStorageBufferArrayNonUniformIndexingNative */
    /* skip val->shaderStorageImageArrayNonUniformIndexingNative */
    /* skip val->shaderInputAttachmentArrayNonUniformIndexingNative */
    /* skip val->robustBufferAccessUpdateAfterBind */
    /* skip val->quadDivergentImplicitLod */
    /* skip val->maxPerStageDescriptorUpdateAfterBindSamplers */
    /* skip val->maxPerStageDescriptorUpdateAfterBindUniformBuffers */
    /* skip val->maxPerStageDescriptorUpdateAfterBindStorageBuffers */
    /* skip val->maxPerStageDescriptorUpdateAfterBindSampledImages */
    /* skip val->maxPerStageDescriptorUpdateAfterBindStorageImages */
    /* skip val->maxPerStageDescriptorUpdateAfterBindInputAttachments */
    /* skip val->maxPerStageUpdateAfterBindResources */
    /* skip val->maxDescriptorSetUpdateAfterBindSamplers */
    /* skip val->maxDescriptorSetUpdateAfterBindUniformBuffers */
    /* skip val->maxDescriptorSetUpdateAfterBindUniformBuffersDynamic */
    /* skip val->maxDescriptorSetUpdateAfterBindStorageBuffers */
    /* skip val->maxDescriptorSetUpdateAfterBindStorageBuffersDynamic */
    /* skip val->maxDescriptorSetUpdateAfterBindSampledImages */
    /* skip val->maxDescriptorSetUpdateAfterBindStorageImages */
    /* skip val->maxDescriptorSetUpdateAfterBindInputAttachments */
    /* skip val->supportedDepthResolveModes */
    /* skip val->supportedStencilResolveModes */
    /* skip val->independentResolveNone */
    /* skip val->independentResolve */
    /* skip val->filterMinmaxSingleComponentFormats */
    /* skip val->filterMinmaxImageComponentMapping */
    /* skip val->maxTimelineSemaphoreValueDifference */
    /* skip val->framebufferIntegerColorSampleCounts */
}

static inline void
vn_decode_VkPhysicalDeviceVulkan12Properties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan12Properties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceVulkan12Properties_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceVulkan12Properties_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceVulkan13Properties chain */

static inline void
vn_encode_VkPhysicalDeviceVulkan13Properties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceVulkan13Properties_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan13Properties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->minSubgroupSize);
    vn_encode_uint32_t(enc, &val->maxSubgroupSize);
    vn_encode_uint32_t(enc, &val->maxComputeWorkgroupSubgroups);
    vn_encode_VkFlags(enc, &val->requiredSubgroupSizeStages);
    vn_encode_uint32_t(enc, &val->maxInlineUniformBlockSize);
    vn_encode_uint32_t(enc, &val->maxPerStageDescriptorInlineUniformBlocks);
    vn_encode_uint32_t(enc, &val->maxPerStageDescriptorUpdateAfterBindInlineUniformBlocks);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetInlineUniformBlocks);
    vn_encode_uint32_t(enc, &val->maxDescriptorSetUpdateAfterBindInlineUniformBlocks);
    vn_encode_uint32_t(enc, &val->maxInlineUniformTotalSize);
    vn_encode_VkBool32(enc, &val->integerDotProduct8BitUnsignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProduct8BitSignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProduct8BitMixedSignednessAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProduct4x8BitPackedUnsignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProduct4x8BitPackedSignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProduct4x8BitPackedMixedSignednessAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProduct16BitUnsignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProduct16BitSignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProduct16BitMixedSignednessAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProduct32BitUnsignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProduct32BitSignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProduct32BitMixedSignednessAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProduct64BitUnsignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProduct64BitSignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProduct64BitMixedSignednessAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProductAccumulatingSaturating8BitUnsignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProductAccumulatingSaturating8BitSignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProductAccumulatingSaturating8BitMixedSignednessAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProductAccumulatingSaturating4x8BitPackedUnsignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProductAccumulatingSaturating4x8BitPackedSignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProductAccumulatingSaturating4x8BitPackedMixedSignednessAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProductAccumulatingSaturating16BitUnsignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProductAccumulatingSaturating16BitSignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProductAccumulatingSaturating16BitMixedSignednessAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProductAccumulatingSaturating32BitUnsignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProductAccumulatingSaturating32BitSignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProductAccumulatingSaturating32BitMixedSignednessAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProductAccumulatingSaturating64BitUnsignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProductAccumulatingSaturating64BitSignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProductAccumulatingSaturating64BitMixedSignednessAccelerated);
    vn_encode_VkDeviceSize(enc, &val->storageTexelBufferOffsetAlignmentBytes);
    vn_encode_VkBool32(enc, &val->storageTexelBufferOffsetSingleTexelAlignment);
    vn_encode_VkDeviceSize(enc, &val->uniformTexelBufferOffsetAlignmentBytes);
    vn_encode_VkBool32(enc, &val->uniformTexelBufferOffsetSingleTexelAlignment);
    vn_encode_VkDeviceSize(enc, &val->maxBufferSize);
}

static inline void
vn_encode_VkPhysicalDeviceVulkan13Properties(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan13Properties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_PROPERTIES });
    vn_encode_VkPhysicalDeviceVulkan13Properties_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceVulkan13Properties_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceVulkan13Properties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceVulkan13Properties_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan13Properties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->minSubgroupSize */
    /* skip val->maxSubgroupSize */
    /* skip val->maxComputeWorkgroupSubgroups */
    /* skip val->requiredSubgroupSizeStages */
    /* skip val->maxInlineUniformBlockSize */
    /* skip val->maxPerStageDescriptorInlineUniformBlocks */
    /* skip val->maxPerStageDescriptorUpdateAfterBindInlineUniformBlocks */
    /* skip val->maxDescriptorSetInlineUniformBlocks */
    /* skip val->maxDescriptorSetUpdateAfterBindInlineUniformBlocks */
    /* skip val->maxInlineUniformTotalSize */
    /* skip val->integerDotProduct8BitUnsignedAccelerated */
    /* skip val->integerDotProduct8BitSignedAccelerated */
    /* skip val->integerDotProduct8BitMixedSignednessAccelerated */
    /* skip val->integerDotProduct4x8BitPackedUnsignedAccelerated */
    /* skip val->integerDotProduct4x8BitPackedSignedAccelerated */
    /* skip val->integerDotProduct4x8BitPackedMixedSignednessAccelerated */
    /* skip val->integerDotProduct16BitUnsignedAccelerated */
    /* skip val->integerDotProduct16BitSignedAccelerated */
    /* skip val->integerDotProduct16BitMixedSignednessAccelerated */
    /* skip val->integerDotProduct32BitUnsignedAccelerated */
    /* skip val->integerDotProduct32BitSignedAccelerated */
    /* skip val->integerDotProduct32BitMixedSignednessAccelerated */
    /* skip val->integerDotProduct64BitUnsignedAccelerated */
    /* skip val->integerDotProduct64BitSignedAccelerated */
    /* skip val->integerDotProduct64BitMixedSignednessAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating8BitUnsignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating8BitSignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating8BitMixedSignednessAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating4x8BitPackedUnsignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating4x8BitPackedSignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating4x8BitPackedMixedSignednessAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating16BitUnsignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating16BitSignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating16BitMixedSignednessAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating32BitUnsignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating32BitSignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating32BitMixedSignednessAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating64BitUnsignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating64BitSignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating64BitMixedSignednessAccelerated */
    /* skip val->storageTexelBufferOffsetAlignmentBytes */
    /* skip val->storageTexelBufferOffsetSingleTexelAlignment */
    /* skip val->uniformTexelBufferOffsetAlignmentBytes */
    /* skip val->uniformTexelBufferOffsetSingleTexelAlignment */
    /* skip val->maxBufferSize */
}

static inline void
vn_decode_VkPhysicalDeviceVulkan13Properties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan13Properties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_PROPERTIES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceVulkan13Properties_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceVulkan13Properties_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceCustomBorderColorPropertiesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceCustomBorderColorPropertiesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceCustomBorderColorPropertiesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceCustomBorderColorPropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->maxCustomBorderColorSamplers);
}

static inline void
vn_encode_VkPhysicalDeviceCustomBorderColorPropertiesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceCustomBorderColorPropertiesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_PROPERTIES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_PROPERTIES_EXT });
    vn_encode_VkPhysicalDeviceCustomBorderColorPropertiesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceCustomBorderColorPropertiesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceCustomBorderColorPropertiesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceCustomBorderColorPropertiesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceCustomBorderColorPropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->maxCustomBorderColorSamplers */
}

static inline void
vn_decode_VkPhysicalDeviceCustomBorderColorPropertiesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceCustomBorderColorPropertiesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_PROPERTIES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceCustomBorderColorPropertiesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceCustomBorderColorPropertiesEXT_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceRobustness2PropertiesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceRobustness2PropertiesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceRobustness2PropertiesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceRobustness2PropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkDeviceSize(enc, &val->robustStorageBufferAccessSizeAlignment);
    vn_encode_VkDeviceSize(enc, &val->robustUniformBufferAccessSizeAlignment);
}

static inline void
vn_encode_VkPhysicalDeviceRobustness2PropertiesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceRobustness2PropertiesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_PROPERTIES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_PROPERTIES_EXT });
    vn_encode_VkPhysicalDeviceRobustness2PropertiesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceRobustness2PropertiesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceRobustness2PropertiesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceRobustness2PropertiesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceRobustness2PropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->robustStorageBufferAccessSizeAlignment */
    /* skip val->robustUniformBufferAccessSizeAlignment */
}

static inline void
vn_decode_VkPhysicalDeviceRobustness2PropertiesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceRobustness2PropertiesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_PROPERTIES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceRobustness2PropertiesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceRobustness2PropertiesEXT_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceProvokingVertexPropertiesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceProvokingVertexPropertiesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceProvokingVertexPropertiesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceProvokingVertexPropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->provokingVertexModePerPipeline);
    vn_encode_VkBool32(enc, &val->transformFeedbackPreservesTriangleFanProvokingVertex);
}

static inline void
vn_encode_VkPhysicalDeviceProvokingVertexPropertiesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceProvokingVertexPropertiesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_PROPERTIES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_PROPERTIES_EXT });
    vn_encode_VkPhysicalDeviceProvokingVertexPropertiesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceProvokingVertexPropertiesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceProvokingVertexPropertiesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceProvokingVertexPropertiesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceProvokingVertexPropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->provokingVertexModePerPipeline */
    /* skip val->transformFeedbackPreservesTriangleFanProvokingVertex */
}

static inline void
vn_decode_VkPhysicalDeviceProvokingVertexPropertiesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceProvokingVertexPropertiesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_PROPERTIES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceProvokingVertexPropertiesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceProvokingVertexPropertiesEXT_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceShaderIntegerDotProductProperties chain */

static inline void
vn_encode_VkPhysicalDeviceShaderIntegerDotProductProperties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceShaderIntegerDotProductProperties_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderIntegerDotProductProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->integerDotProduct8BitUnsignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProduct8BitSignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProduct8BitMixedSignednessAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProduct4x8BitPackedUnsignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProduct4x8BitPackedSignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProduct4x8BitPackedMixedSignednessAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProduct16BitUnsignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProduct16BitSignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProduct16BitMixedSignednessAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProduct32BitUnsignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProduct32BitSignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProduct32BitMixedSignednessAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProduct64BitUnsignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProduct64BitSignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProduct64BitMixedSignednessAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProductAccumulatingSaturating8BitUnsignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProductAccumulatingSaturating8BitSignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProductAccumulatingSaturating8BitMixedSignednessAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProductAccumulatingSaturating4x8BitPackedUnsignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProductAccumulatingSaturating4x8BitPackedSignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProductAccumulatingSaturating4x8BitPackedMixedSignednessAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProductAccumulatingSaturating16BitUnsignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProductAccumulatingSaturating16BitSignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProductAccumulatingSaturating16BitMixedSignednessAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProductAccumulatingSaturating32BitUnsignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProductAccumulatingSaturating32BitSignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProductAccumulatingSaturating32BitMixedSignednessAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProductAccumulatingSaturating64BitUnsignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProductAccumulatingSaturating64BitSignedAccelerated);
    vn_encode_VkBool32(enc, &val->integerDotProductAccumulatingSaturating64BitMixedSignednessAccelerated);
}

static inline void
vn_encode_VkPhysicalDeviceShaderIntegerDotProductProperties(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderIntegerDotProductProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_PROPERTIES });
    vn_encode_VkPhysicalDeviceShaderIntegerDotProductProperties_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceShaderIntegerDotProductProperties_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceShaderIntegerDotProductProperties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceShaderIntegerDotProductProperties_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderIntegerDotProductProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->integerDotProduct8BitUnsignedAccelerated */
    /* skip val->integerDotProduct8BitSignedAccelerated */
    /* skip val->integerDotProduct8BitMixedSignednessAccelerated */
    /* skip val->integerDotProduct4x8BitPackedUnsignedAccelerated */
    /* skip val->integerDotProduct4x8BitPackedSignedAccelerated */
    /* skip val->integerDotProduct4x8BitPackedMixedSignednessAccelerated */
    /* skip val->integerDotProduct16BitUnsignedAccelerated */
    /* skip val->integerDotProduct16BitSignedAccelerated */
    /* skip val->integerDotProduct16BitMixedSignednessAccelerated */
    /* skip val->integerDotProduct32BitUnsignedAccelerated */
    /* skip val->integerDotProduct32BitSignedAccelerated */
    /* skip val->integerDotProduct32BitMixedSignednessAccelerated */
    /* skip val->integerDotProduct64BitUnsignedAccelerated */
    /* skip val->integerDotProduct64BitSignedAccelerated */
    /* skip val->integerDotProduct64BitMixedSignednessAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating8BitUnsignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating8BitSignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating8BitMixedSignednessAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating4x8BitPackedUnsignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating4x8BitPackedSignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating4x8BitPackedMixedSignednessAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating16BitUnsignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating16BitSignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating16BitMixedSignednessAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating32BitUnsignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating32BitSignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating32BitMixedSignednessAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating64BitUnsignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating64BitSignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating64BitMixedSignednessAccelerated */
}

static inline void
vn_decode_VkPhysicalDeviceShaderIntegerDotProductProperties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderIntegerDotProductProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_PROPERTIES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceShaderIntegerDotProductProperties_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceShaderIntegerDotProductProperties_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceProperties2 chain */

static inline void
vn_encode_VkPhysicalDeviceProperties2_pnext(struct vn_cs_encoder *enc, const void *val)
{
    const VkBaseInStructure *pnext = val;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_PROPERTIES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceMultiDrawPropertiesEXT_self(enc, (const VkPhysicalDeviceMultiDrawPropertiesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PUSH_DESCRIPTOR_PROPERTIES_KHR:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDevicePushDescriptorPropertiesKHR_self(enc, (const VkPhysicalDevicePushDescriptorPropertiesKHR *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceDriverProperties_self(enc, (const VkPhysicalDeviceDriverProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceIDProperties_self(enc, (const VkPhysicalDeviceIDProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceMultiviewProperties_self(enc, (const VkPhysicalDeviceMultiviewProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceSubgroupProperties_self(enc, (const VkPhysicalDeviceSubgroupProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDevicePointClippingProperties_self(enc, (const VkPhysicalDevicePointClippingProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceProtectedMemoryProperties_self(enc, (const VkPhysicalDeviceProtectedMemoryProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceSamplerFilterMinmaxProperties_self(enc, (const VkPhysicalDeviceSamplerFilterMinmaxProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceInlineUniformBlockProperties_self(enc, (const VkPhysicalDeviceInlineUniformBlockProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceMaintenance3Properties_self(enc, (const VkPhysicalDeviceMaintenance3Properties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceMaintenance4Properties_self(enc, (const VkPhysicalDeviceMaintenance4Properties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceFloatControlsProperties_self(enc, (const VkPhysicalDeviceFloatControlsProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONSERVATIVE_RASTERIZATION_PROPERTIES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceConservativeRasterizationPropertiesEXT_self(enc, (const VkPhysicalDeviceConservativeRasterizationPropertiesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceDescriptorIndexingProperties_self(enc, (const VkPhysicalDeviceDescriptorIndexingProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceTimelineSemaphoreProperties_self(enc, (const VkPhysicalDeviceTimelineSemaphoreProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT_self(enc, (const VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PCI_BUS_INFO_PROPERTIES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDevicePCIBusInfoPropertiesEXT_self(enc, (const VkPhysicalDevicePCIBusInfoPropertiesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceDepthStencilResolveProperties_self(enc, (const VkPhysicalDeviceDepthStencilResolveProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_PROPERTIES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceTransformFeedbackPropertiesEXT_self(enc, (const VkPhysicalDeviceTransformFeedbackPropertiesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceTexelBufferAlignmentProperties_self(enc, (const VkPhysicalDeviceTexelBufferAlignmentProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceSubgroupSizeControlProperties_self(enc, (const VkPhysicalDeviceSubgroupSizeControlProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_PROPERTIES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceLineRasterizationPropertiesEXT_self(enc, (const VkPhysicalDeviceLineRasterizationPropertiesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVulkan11Properties_self(enc, (const VkPhysicalDeviceVulkan11Properties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVulkan12Properties_self(enc, (const VkPhysicalDeviceVulkan12Properties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVulkan13Properties_self(enc, (const VkPhysicalDeviceVulkan13Properties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_PROPERTIES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceCustomBorderColorPropertiesEXT_self(enc, (const VkPhysicalDeviceCustomBorderColorPropertiesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_PROPERTIES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceRobustness2PropertiesEXT_self(enc, (const VkPhysicalDeviceRobustness2PropertiesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_PROPERTIES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceProvokingVertexPropertiesEXT_self(enc, (const VkPhysicalDeviceProvokingVertexPropertiesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderIntegerDotProductProperties_self(enc, (const VkPhysicalDeviceShaderIntegerDotProductProperties *)pnext);
            return;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceProperties2_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceProperties2 *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkPhysicalDeviceProperties(enc, &val->properties);
}

static inline void
vn_encode_VkPhysicalDeviceProperties2(struct vn_cs_encoder *enc, const VkPhysicalDeviceProperties2 *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROPERTIES_2);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROPERTIES_2 });
    vn_encode_VkPhysicalDeviceProperties2_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceProperties2_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    VkBaseOutStructure *pnext;
    VkStructureType stype;

    if (!vn_decode_simple_pointer(dec))
        return NULL;

    vn_decode_VkStructureType(dec, &stype);
    switch ((int32_t)stype) {
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_PROPERTIES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceMultiDrawPropertiesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceMultiDrawPropertiesEXT_self_partial_temp(dec, (VkPhysicalDeviceMultiDrawPropertiesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PUSH_DESCRIPTOR_PROPERTIES_KHR:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDevicePushDescriptorPropertiesKHR));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDevicePushDescriptorPropertiesKHR_self_partial_temp(dec, (VkPhysicalDevicePushDescriptorPropertiesKHR *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceDriverProperties));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceDriverProperties_self_partial_temp(dec, (VkPhysicalDeviceDriverProperties *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceIDProperties));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceIDProperties_self_partial_temp(dec, (VkPhysicalDeviceIDProperties *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceMultiviewProperties));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceMultiviewProperties_self_partial_temp(dec, (VkPhysicalDeviceMultiviewProperties *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_PROPERTIES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceSubgroupProperties));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceSubgroupProperties_self_partial_temp(dec, (VkPhysicalDeviceSubgroupProperties *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDevicePointClippingProperties));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDevicePointClippingProperties_self_partial_temp(dec, (VkPhysicalDevicePointClippingProperties *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceProtectedMemoryProperties));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceProtectedMemoryProperties_self_partial_temp(dec, (VkPhysicalDeviceProtectedMemoryProperties *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceSamplerFilterMinmaxProperties));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceSamplerFilterMinmaxProperties_self_partial_temp(dec, (VkPhysicalDeviceSamplerFilterMinmaxProperties *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_PROPERTIES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceInlineUniformBlockProperties));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceInlineUniformBlockProperties_self_partial_temp(dec, (VkPhysicalDeviceInlineUniformBlockProperties *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceMaintenance3Properties));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceMaintenance3Properties_self_partial_temp(dec, (VkPhysicalDeviceMaintenance3Properties *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_PROPERTIES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceMaintenance4Properties));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceMaintenance4Properties_self_partial_temp(dec, (VkPhysicalDeviceMaintenance4Properties *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceFloatControlsProperties));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceFloatControlsProperties_self_partial_temp(dec, (VkPhysicalDeviceFloatControlsProperties *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONSERVATIVE_RASTERIZATION_PROPERTIES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceConservativeRasterizationPropertiesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceConservativeRasterizationPropertiesEXT_self_partial_temp(dec, (VkPhysicalDeviceConservativeRasterizationPropertiesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceDescriptorIndexingProperties));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceDescriptorIndexingProperties_self_partial_temp(dec, (VkPhysicalDeviceDescriptorIndexingProperties *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceTimelineSemaphoreProperties));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceTimelineSemaphoreProperties_self_partial_temp(dec, (VkPhysicalDeviceTimelineSemaphoreProperties *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT_self_partial_temp(dec, (VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PCI_BUS_INFO_PROPERTIES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDevicePCIBusInfoPropertiesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDevicePCIBusInfoPropertiesEXT_self_partial_temp(dec, (VkPhysicalDevicePCIBusInfoPropertiesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceDepthStencilResolveProperties));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceDepthStencilResolveProperties_self_partial_temp(dec, (VkPhysicalDeviceDepthStencilResolveProperties *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_PROPERTIES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceTransformFeedbackPropertiesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceTransformFeedbackPropertiesEXT_self_partial_temp(dec, (VkPhysicalDeviceTransformFeedbackPropertiesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_PROPERTIES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceTexelBufferAlignmentProperties));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceTexelBufferAlignmentProperties_self_partial_temp(dec, (VkPhysicalDeviceTexelBufferAlignmentProperties *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_PROPERTIES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceSubgroupSizeControlProperties));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceSubgroupSizeControlProperties_self_partial_temp(dec, (VkPhysicalDeviceSubgroupSizeControlProperties *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_PROPERTIES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceLineRasterizationPropertiesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceLineRasterizationPropertiesEXT_self_partial_temp(dec, (VkPhysicalDeviceLineRasterizationPropertiesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceVulkan11Properties));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceVulkan11Properties_self_partial_temp(dec, (VkPhysicalDeviceVulkan11Properties *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceVulkan12Properties));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceVulkan12Properties_self_partial_temp(dec, (VkPhysicalDeviceVulkan12Properties *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_PROPERTIES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceVulkan13Properties));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceVulkan13Properties_self_partial_temp(dec, (VkPhysicalDeviceVulkan13Properties *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_PROPERTIES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceCustomBorderColorPropertiesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceCustomBorderColorPropertiesEXT_self_partial_temp(dec, (VkPhysicalDeviceCustomBorderColorPropertiesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_PROPERTIES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceRobustness2PropertiesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceRobustness2PropertiesEXT_self_partial_temp(dec, (VkPhysicalDeviceRobustness2PropertiesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_PROPERTIES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceProvokingVertexPropertiesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceProvokingVertexPropertiesEXT_self_partial_temp(dec, (VkPhysicalDeviceProvokingVertexPropertiesEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_PROPERTIES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceShaderIntegerDotProductProperties));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceShaderIntegerDotProductProperties_self_partial_temp(dec, (VkPhysicalDeviceShaderIntegerDotProductProperties *)pnext);
        }
        break;
    default:
        /* unexpected struct */
        pnext = NULL;
        vn_cs_decoder_set_fatal(dec);
        break;
    }

    return pnext;
}

static inline void
vn_decode_VkPhysicalDeviceProperties2_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceProperties2 *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkPhysicalDeviceProperties_partial_temp(dec, &val->properties);
}

static inline void
vn_decode_VkPhysicalDeviceProperties2_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceProperties2 *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROPERTIES_2)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceProperties2_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceProperties2_self_partial_temp(dec, val);
}

/* struct VkDrmFormatModifierPropertiesEXT */

static inline void
vn_encode_VkDrmFormatModifierPropertiesEXT(struct vn_cs_encoder *enc, const VkDrmFormatModifierPropertiesEXT *val)
{
    vn_encode_uint64_t(enc, &val->drmFormatModifier);
    vn_encode_uint32_t(enc, &val->drmFormatModifierPlaneCount);
    vn_encode_VkFlags(enc, &val->drmFormatModifierTilingFeatures);
}

static inline void
vn_decode_VkDrmFormatModifierPropertiesEXT_partial_temp(struct vn_cs_decoder *dec, VkDrmFormatModifierPropertiesEXT *val)
{
    /* skip val->drmFormatModifier */
    /* skip val->drmFormatModifierPlaneCount */
    /* skip val->drmFormatModifierTilingFeatures */
}

/* struct VkDrmFormatModifierPropertiesListEXT chain */

static inline void
vn_encode_VkDrmFormatModifierPropertiesListEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkDrmFormatModifierPropertiesListEXT_self(struct vn_cs_encoder *enc, const VkDrmFormatModifierPropertiesListEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->drmFormatModifierCount);
    if (val->pDrmFormatModifierProperties) {
        vn_encode_array_size(enc, val->drmFormatModifierCount);
        for (uint32_t i = 0; i < val->drmFormatModifierCount; i++)
            vn_encode_VkDrmFormatModifierPropertiesEXT(enc, &val->pDrmFormatModifierProperties[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void
vn_encode_VkDrmFormatModifierPropertiesListEXT(struct vn_cs_encoder *enc, const VkDrmFormatModifierPropertiesListEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_EXT });
    vn_encode_VkDrmFormatModifierPropertiesListEXT_pnext(enc, val->pNext);
    vn_encode_VkDrmFormatModifierPropertiesListEXT_self(enc, val);
}

static inline void *
vn_decode_VkDrmFormatModifierPropertiesListEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkDrmFormatModifierPropertiesListEXT_self_partial_temp(struct vn_cs_decoder *dec, VkDrmFormatModifierPropertiesListEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint32_t(dec, &val->drmFormatModifierCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, val->drmFormatModifierCount);
        val->pDrmFormatModifierProperties = vn_cs_decoder_alloc_temp_array(dec, sizeof(*val->pDrmFormatModifierProperties), iter_count);
        if (!val->pDrmFormatModifierProperties) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkDrmFormatModifierPropertiesEXT_partial_temp(dec, &val->pDrmFormatModifierProperties[i]);
    } else {
        vn_decode_array_size_unchecked(dec);
        val->pDrmFormatModifierProperties = NULL;
    }
}

static inline void
vn_decode_VkDrmFormatModifierPropertiesListEXT_partial_temp(struct vn_cs_decoder *dec, VkDrmFormatModifierPropertiesListEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkDrmFormatModifierPropertiesListEXT_pnext_partial_temp(dec);
    vn_decode_VkDrmFormatModifierPropertiesListEXT_self_partial_temp(dec, val);
}

/* struct VkFormatProperties3 chain */

static inline void
vn_encode_VkFormatProperties3_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkFormatProperties3_self(struct vn_cs_encoder *enc, const VkFormatProperties3 *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFlags64(enc, &val->linearTilingFeatures);
    vn_encode_VkFlags64(enc, &val->optimalTilingFeatures);
    vn_encode_VkFlags64(enc, &val->bufferFeatures);
}

static inline void
vn_encode_VkFormatProperties3(struct vn_cs_encoder *enc, const VkFormatProperties3 *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_3);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_3 });
    vn_encode_VkFormatProperties3_pnext(enc, val->pNext);
    vn_encode_VkFormatProperties3_self(enc, val);
}

static inline void *
vn_decode_VkFormatProperties3_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkFormatProperties3_self_partial_temp(struct vn_cs_decoder *dec, VkFormatProperties3 *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->linearTilingFeatures */
    /* skip val->optimalTilingFeatures */
    /* skip val->bufferFeatures */
}

static inline void
vn_decode_VkFormatProperties3_partial_temp(struct vn_cs_decoder *dec, VkFormatProperties3 *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_3)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkFormatProperties3_pnext_partial_temp(dec);
    vn_decode_VkFormatProperties3_self_partial_temp(dec, val);
}

/* struct VkDrmFormatModifierProperties2EXT */

static inline void
vn_encode_VkDrmFormatModifierProperties2EXT(struct vn_cs_encoder *enc, const VkDrmFormatModifierProperties2EXT *val)
{
    vn_encode_uint64_t(enc, &val->drmFormatModifier);
    vn_encode_uint32_t(enc, &val->drmFormatModifierPlaneCount);
    vn_encode_VkFlags64(enc, &val->drmFormatModifierTilingFeatures);
}

static inline void
vn_decode_VkDrmFormatModifierProperties2EXT_partial_temp(struct vn_cs_decoder *dec, VkDrmFormatModifierProperties2EXT *val)
{
    /* skip val->drmFormatModifier */
    /* skip val->drmFormatModifierPlaneCount */
    /* skip val->drmFormatModifierTilingFeatures */
}

/* struct VkDrmFormatModifierPropertiesList2EXT chain */

static inline void
vn_encode_VkDrmFormatModifierPropertiesList2EXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkDrmFormatModifierPropertiesList2EXT_self(struct vn_cs_encoder *enc, const VkDrmFormatModifierPropertiesList2EXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->drmFormatModifierCount);
    if (val->pDrmFormatModifierProperties) {
        vn_encode_array_size(enc, val->drmFormatModifierCount);
        for (uint32_t i = 0; i < val->drmFormatModifierCount; i++)
            vn_encode_VkDrmFormatModifierProperties2EXT(enc, &val->pDrmFormatModifierProperties[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void
vn_encode_VkDrmFormatModifierPropertiesList2EXT(struct vn_cs_encoder *enc, const VkDrmFormatModifierPropertiesList2EXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_2_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_2_EXT });
    vn_encode_VkDrmFormatModifierPropertiesList2EXT_pnext(enc, val->pNext);
    vn_encode_VkDrmFormatModifierPropertiesList2EXT_self(enc, val);
}

static inline void *
vn_decode_VkDrmFormatModifierPropertiesList2EXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkDrmFormatModifierPropertiesList2EXT_self_partial_temp(struct vn_cs_decoder *dec, VkDrmFormatModifierPropertiesList2EXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint32_t(dec, &val->drmFormatModifierCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, val->drmFormatModifierCount);
        val->pDrmFormatModifierProperties = vn_cs_decoder_alloc_temp_array(dec, sizeof(*val->pDrmFormatModifierProperties), iter_count);
        if (!val->pDrmFormatModifierProperties) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkDrmFormatModifierProperties2EXT_partial_temp(dec, &val->pDrmFormatModifierProperties[i]);
    } else {
        vn_decode_array_size_unchecked(dec);
        val->pDrmFormatModifierProperties = NULL;
    }
}

static inline void
vn_decode_VkDrmFormatModifierPropertiesList2EXT_partial_temp(struct vn_cs_decoder *dec, VkDrmFormatModifierPropertiesList2EXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_2_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkDrmFormatModifierPropertiesList2EXT_pnext_partial_temp(dec);
    vn_decode_VkDrmFormatModifierPropertiesList2EXT_self_partial_temp(dec, val);
}

/* struct VkFormatProperties2 chain */

static inline void
vn_encode_VkFormatProperties2_pnext(struct vn_cs_encoder *enc, const void *val)
{
    const VkBaseInStructure *pnext = val;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkFormatProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkDrmFormatModifierPropertiesListEXT_self(enc, (const VkDrmFormatModifierPropertiesListEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_3:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkFormatProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkFormatProperties3_self(enc, (const VkFormatProperties3 *)pnext);
            return;
        case VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_2_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkFormatProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkDrmFormatModifierPropertiesList2EXT_self(enc, (const VkDrmFormatModifierPropertiesList2EXT *)pnext);
            return;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkFormatProperties2_self(struct vn_cs_encoder *enc, const VkFormatProperties2 *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFormatProperties(enc, &val->formatProperties);
}

static inline void
vn_encode_VkFormatProperties2(struct vn_cs_encoder *enc, const VkFormatProperties2 *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_2);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_2 });
    vn_encode_VkFormatProperties2_pnext(enc, val->pNext);
    vn_encode_VkFormatProperties2_self(enc, val);
}

static inline void *
vn_decode_VkFormatProperties2_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    VkBaseOutStructure *pnext;
    VkStructureType stype;

    if (!vn_decode_simple_pointer(dec))
        return NULL;

    vn_decode_VkStructureType(dec, &stype);
    switch ((int32_t)stype) {
    case VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkDrmFormatModifierPropertiesListEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkFormatProperties2_pnext_partial_temp(dec);
            vn_decode_VkDrmFormatModifierPropertiesListEXT_self_partial_temp(dec, (VkDrmFormatModifierPropertiesListEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_3:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkFormatProperties3));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkFormatProperties2_pnext_partial_temp(dec);
            vn_decode_VkFormatProperties3_self_partial_temp(dec, (VkFormatProperties3 *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_2_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkDrmFormatModifierPropertiesList2EXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkFormatProperties2_pnext_partial_temp(dec);
            vn_decode_VkDrmFormatModifierPropertiesList2EXT_self_partial_temp(dec, (VkDrmFormatModifierPropertiesList2EXT *)pnext);
        }
        break;
    default:
        /* unexpected struct */
        pnext = NULL;
        vn_cs_decoder_set_fatal(dec);
        break;
    }

    return pnext;
}

static inline void
vn_decode_VkFormatProperties2_self_partial_temp(struct vn_cs_decoder *dec, VkFormatProperties2 *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFormatProperties_partial_temp(dec, &val->formatProperties);
}

static inline void
vn_decode_VkFormatProperties2_partial_temp(struct vn_cs_decoder *dec, VkFormatProperties2 *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_2)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkFormatProperties2_pnext_partial_temp(dec);
    vn_decode_VkFormatProperties2_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceExternalImageFormatInfo chain */

static inline void *
vn_decode_VkPhysicalDeviceExternalImageFormatInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceExternalImageFormatInfo_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceExternalImageFormatInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkExternalMemoryHandleTypeFlagBits(dec, &val->handleType);
}

static inline void
vn_decode_VkPhysicalDeviceExternalImageFormatInfo_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceExternalImageFormatInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceExternalImageFormatInfo_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceExternalImageFormatInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceExternalImageFormatInfo_handle_self(VkPhysicalDeviceExternalImageFormatInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->handleType */
}

static inline void
vn_replace_VkPhysicalDeviceExternalImageFormatInfo_handle(VkPhysicalDeviceExternalImageFormatInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO:
            vn_replace_VkPhysicalDeviceExternalImageFormatInfo_handle_self((VkPhysicalDeviceExternalImageFormatInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceImageDrmFormatModifierInfoEXT chain */

static inline void *
vn_decode_VkPhysicalDeviceImageDrmFormatModifierInfoEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceImageDrmFormatModifierInfoEXT_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceImageDrmFormatModifierInfoEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint64_t(dec, &val->drmFormatModifier);
    vn_decode_VkSharingMode(dec, &val->sharingMode);
    vn_decode_uint32_t(dec, &val->queueFamilyIndexCount);
    if (vn_peek_array_size(dec)) {
        const size_t array_size = vn_decode_array_size(dec, val->queueFamilyIndexCount);
        val->pQueueFamilyIndices = vn_cs_decoder_alloc_temp_array(dec, sizeof(*val->pQueueFamilyIndices), array_size);
        if (!val->pQueueFamilyIndices) return;
        vn_decode_uint32_t_array(dec, (uint32_t *)val->pQueueFamilyIndices, array_size);
    } else {
        vn_decode_array_size_unchecked(dec);
        val->pQueueFamilyIndices = NULL;
    }
}

static inline void
vn_decode_VkPhysicalDeviceImageDrmFormatModifierInfoEXT_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceImageDrmFormatModifierInfoEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_DRM_FORMAT_MODIFIER_INFO_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceImageDrmFormatModifierInfoEXT_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceImageDrmFormatModifierInfoEXT_self_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceImageDrmFormatModifierInfoEXT_handle_self(VkPhysicalDeviceImageDrmFormatModifierInfoEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->drmFormatModifier */
    /* skip val->sharingMode */
    /* skip val->queueFamilyIndexCount */
    /* skip val->pQueueFamilyIndices */
}

static inline void
vn_replace_VkPhysicalDeviceImageDrmFormatModifierInfoEXT_handle(VkPhysicalDeviceImageDrmFormatModifierInfoEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_DRM_FORMAT_MODIFIER_INFO_EXT:
            vn_replace_VkPhysicalDeviceImageDrmFormatModifierInfoEXT_handle_self((VkPhysicalDeviceImageDrmFormatModifierInfoEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceImageFormatInfo2 chain */

static inline void *
vn_decode_VkPhysicalDeviceImageFormatInfo2_pnext_temp(struct vn_cs_decoder *dec)
{
    VkBaseOutStructure *pnext;
    VkStructureType stype;

    if (!vn_decode_simple_pointer(dec))
        return NULL;

    vn_decode_VkStructureType(dec, &stype);
    switch ((int32_t)stype) {
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceExternalImageFormatInfo));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceImageFormatInfo2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceExternalImageFormatInfo_self_temp(dec, (VkPhysicalDeviceExternalImageFormatInfo *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_IMAGE_FORMAT_LIST_CREATE_INFO:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkImageFormatListCreateInfo));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceImageFormatInfo2_pnext_temp(dec);
            vn_decode_VkImageFormatListCreateInfo_self_temp(dec, (VkImageFormatListCreateInfo *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_DRM_FORMAT_MODIFIER_INFO_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceImageDrmFormatModifierInfoEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceImageFormatInfo2_pnext_temp(dec);
            vn_decode_VkPhysicalDeviceImageDrmFormatModifierInfoEXT_self_temp(dec, (VkPhysicalDeviceImageDrmFormatModifierInfoEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_IMAGE_STENCIL_USAGE_CREATE_INFO:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkImageStencilUsageCreateInfo));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceImageFormatInfo2_pnext_temp(dec);
            vn_decode_VkImageStencilUsageCreateInfo_self_temp(dec, (VkImageStencilUsageCreateInfo *)pnext);
        }
        break;
    default:
        /* unexpected struct */
        pnext = NULL;
        vn_cs_decoder_set_fatal(dec);
        break;
    }

    return pnext;
}

static inline void
vn_decode_VkPhysicalDeviceImageFormatInfo2_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceImageFormatInfo2 *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFormat(dec, &val->format);
    vn_decode_VkImageType(dec, &val->type);
    vn_decode_VkImageTiling(dec, &val->tiling);
    vn_decode_VkFlags(dec, &val->usage);
    vn_decode_VkFlags(dec, &val->flags);
}

static inline void
vn_decode_VkPhysicalDeviceImageFormatInfo2_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceImageFormatInfo2 *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_FORMAT_INFO_2)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceImageFormatInfo2_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceImageFormatInfo2_self_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceImageFormatInfo2_handle_self(VkPhysicalDeviceImageFormatInfo2 *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->format */
    /* skip val->type */
    /* skip val->tiling */
    /* skip val->usage */
    /* skip val->flags */
}

static inline void
vn_replace_VkPhysicalDeviceImageFormatInfo2_handle(VkPhysicalDeviceImageFormatInfo2 *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_FORMAT_INFO_2:
            vn_replace_VkPhysicalDeviceImageFormatInfo2_handle_self((VkPhysicalDeviceImageFormatInfo2 *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO:
            vn_replace_VkPhysicalDeviceExternalImageFormatInfo_handle_self((VkPhysicalDeviceExternalImageFormatInfo *)pnext);
            break;
        case VK_STRUCTURE_TYPE_IMAGE_FORMAT_LIST_CREATE_INFO:
            vn_replace_VkImageFormatListCreateInfo_handle_self((VkImageFormatListCreateInfo *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_DRM_FORMAT_MODIFIER_INFO_EXT:
            vn_replace_VkPhysicalDeviceImageDrmFormatModifierInfoEXT_handle_self((VkPhysicalDeviceImageDrmFormatModifierInfoEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_IMAGE_STENCIL_USAGE_CREATE_INFO:
            vn_replace_VkImageStencilUsageCreateInfo_handle_self((VkImageStencilUsageCreateInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkExternalMemoryProperties */

static inline void
vn_encode_VkExternalMemoryProperties(struct vn_cs_encoder *enc, const VkExternalMemoryProperties *val)
{
    vn_encode_VkFlags(enc, &val->externalMemoryFeatures);
    vn_encode_VkFlags(enc, &val->exportFromImportedHandleTypes);
    vn_encode_VkFlags(enc, &val->compatibleHandleTypes);
}

static inline void
vn_decode_VkExternalMemoryProperties_partial_temp(struct vn_cs_decoder *dec, VkExternalMemoryProperties *val)
{
    /* skip val->externalMemoryFeatures */
    /* skip val->exportFromImportedHandleTypes */
    /* skip val->compatibleHandleTypes */
}

/* struct VkExternalImageFormatProperties chain */

static inline void
vn_encode_VkExternalImageFormatProperties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkExternalImageFormatProperties_self(struct vn_cs_encoder *enc, const VkExternalImageFormatProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkExternalMemoryProperties(enc, &val->externalMemoryProperties);
}

static inline void
vn_encode_VkExternalImageFormatProperties(struct vn_cs_encoder *enc, const VkExternalImageFormatProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES });
    vn_encode_VkExternalImageFormatProperties_pnext(enc, val->pNext);
    vn_encode_VkExternalImageFormatProperties_self(enc, val);
}

static inline void *
vn_decode_VkExternalImageFormatProperties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkExternalImageFormatProperties_self_partial_temp(struct vn_cs_decoder *dec, VkExternalImageFormatProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkExternalMemoryProperties_partial_temp(dec, &val->externalMemoryProperties);
}

static inline void
vn_decode_VkExternalImageFormatProperties_partial_temp(struct vn_cs_decoder *dec, VkExternalImageFormatProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkExternalImageFormatProperties_pnext_partial_temp(dec);
    vn_decode_VkExternalImageFormatProperties_self_partial_temp(dec, val);
}

/* struct VkSamplerYcbcrConversionImageFormatProperties chain */

static inline void
vn_encode_VkSamplerYcbcrConversionImageFormatProperties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkSamplerYcbcrConversionImageFormatProperties_self(struct vn_cs_encoder *enc, const VkSamplerYcbcrConversionImageFormatProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->combinedImageSamplerDescriptorCount);
}

static inline void
vn_encode_VkSamplerYcbcrConversionImageFormatProperties(struct vn_cs_encoder *enc, const VkSamplerYcbcrConversionImageFormatProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES });
    vn_encode_VkSamplerYcbcrConversionImageFormatProperties_pnext(enc, val->pNext);
    vn_encode_VkSamplerYcbcrConversionImageFormatProperties_self(enc, val);
}

static inline void *
vn_decode_VkSamplerYcbcrConversionImageFormatProperties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkSamplerYcbcrConversionImageFormatProperties_self_partial_temp(struct vn_cs_decoder *dec, VkSamplerYcbcrConversionImageFormatProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->combinedImageSamplerDescriptorCount */
}

static inline void
vn_decode_VkSamplerYcbcrConversionImageFormatProperties_partial_temp(struct vn_cs_decoder *dec, VkSamplerYcbcrConversionImageFormatProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkSamplerYcbcrConversionImageFormatProperties_pnext_partial_temp(dec);
    vn_decode_VkSamplerYcbcrConversionImageFormatProperties_self_partial_temp(dec, val);
}

/* struct VkImageFormatProperties2 chain */

static inline void
vn_encode_VkImageFormatProperties2_pnext(struct vn_cs_encoder *enc, const void *val)
{
    const VkBaseInStructure *pnext = val;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkImageFormatProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkExternalImageFormatProperties_self(enc, (const VkExternalImageFormatProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkImageFormatProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkSamplerYcbcrConversionImageFormatProperties_self(enc, (const VkSamplerYcbcrConversionImageFormatProperties *)pnext);
            return;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkImageFormatProperties2_self(struct vn_cs_encoder *enc, const VkImageFormatProperties2 *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkImageFormatProperties(enc, &val->imageFormatProperties);
}

static inline void
vn_encode_VkImageFormatProperties2(struct vn_cs_encoder *enc, const VkImageFormatProperties2 *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_IMAGE_FORMAT_PROPERTIES_2);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_IMAGE_FORMAT_PROPERTIES_2 });
    vn_encode_VkImageFormatProperties2_pnext(enc, val->pNext);
    vn_encode_VkImageFormatProperties2_self(enc, val);
}

static inline void *
vn_decode_VkImageFormatProperties2_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    VkBaseOutStructure *pnext;
    VkStructureType stype;

    if (!vn_decode_simple_pointer(dec))
        return NULL;

    vn_decode_VkStructureType(dec, &stype);
    switch ((int32_t)stype) {
    case VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkExternalImageFormatProperties));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkImageFormatProperties2_pnext_partial_temp(dec);
            vn_decode_VkExternalImageFormatProperties_self_partial_temp(dec, (VkExternalImageFormatProperties *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkSamplerYcbcrConversionImageFormatProperties));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkImageFormatProperties2_pnext_partial_temp(dec);
            vn_decode_VkSamplerYcbcrConversionImageFormatProperties_self_partial_temp(dec, (VkSamplerYcbcrConversionImageFormatProperties *)pnext);
        }
        break;
    default:
        /* unexpected struct */
        pnext = NULL;
        vn_cs_decoder_set_fatal(dec);
        break;
    }

    return pnext;
}

static inline void
vn_decode_VkImageFormatProperties2_self_partial_temp(struct vn_cs_decoder *dec, VkImageFormatProperties2 *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkImageFormatProperties_partial_temp(dec, &val->imageFormatProperties);
}

static inline void
vn_decode_VkImageFormatProperties2_partial_temp(struct vn_cs_decoder *dec, VkImageFormatProperties2 *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_IMAGE_FORMAT_PROPERTIES_2)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkImageFormatProperties2_pnext_partial_temp(dec);
    vn_decode_VkImageFormatProperties2_self_partial_temp(dec, val);
}

/* struct VkQueueFamilyProperties2 chain */

static inline void
vn_encode_VkQueueFamilyProperties2_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkQueueFamilyProperties2_self(struct vn_cs_encoder *enc, const VkQueueFamilyProperties2 *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkQueueFamilyProperties(enc, &val->queueFamilyProperties);
}

static inline void
vn_encode_VkQueueFamilyProperties2(struct vn_cs_encoder *enc, const VkQueueFamilyProperties2 *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_QUEUE_FAMILY_PROPERTIES_2);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_QUEUE_FAMILY_PROPERTIES_2 });
    vn_encode_VkQueueFamilyProperties2_pnext(enc, val->pNext);
    vn_encode_VkQueueFamilyProperties2_self(enc, val);
}

static inline void *
vn_decode_VkQueueFamilyProperties2_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkQueueFamilyProperties2_self_partial_temp(struct vn_cs_decoder *dec, VkQueueFamilyProperties2 *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkQueueFamilyProperties_partial_temp(dec, &val->queueFamilyProperties);
}

static inline void
vn_decode_VkQueueFamilyProperties2_partial_temp(struct vn_cs_decoder *dec, VkQueueFamilyProperties2 *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_QUEUE_FAMILY_PROPERTIES_2)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkQueueFamilyProperties2_pnext_partial_temp(dec);
    vn_decode_VkQueueFamilyProperties2_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceMemoryBudgetPropertiesEXT chain */

static inline void
vn_encode_VkPhysicalDeviceMemoryBudgetPropertiesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceMemoryBudgetPropertiesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceMemoryBudgetPropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_array_size(enc, VK_MAX_MEMORY_HEAPS);
    vn_encode_VkDeviceSize_array(enc, val->heapBudget, VK_MAX_MEMORY_HEAPS);
    vn_encode_array_size(enc, VK_MAX_MEMORY_HEAPS);
    vn_encode_VkDeviceSize_array(enc, val->heapUsage, VK_MAX_MEMORY_HEAPS);
}

static inline void
vn_encode_VkPhysicalDeviceMemoryBudgetPropertiesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceMemoryBudgetPropertiesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_BUDGET_PROPERTIES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_BUDGET_PROPERTIES_EXT });
    vn_encode_VkPhysicalDeviceMemoryBudgetPropertiesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceMemoryBudgetPropertiesEXT_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceMemoryBudgetPropertiesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceMemoryBudgetPropertiesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMemoryBudgetPropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->heapBudget */
    /* skip val->heapUsage */
}

static inline void
vn_decode_VkPhysicalDeviceMemoryBudgetPropertiesEXT_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMemoryBudgetPropertiesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_BUDGET_PROPERTIES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceMemoryBudgetPropertiesEXT_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceMemoryBudgetPropertiesEXT_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceMemoryProperties2 chain */

static inline void
vn_encode_VkPhysicalDeviceMemoryProperties2_pnext(struct vn_cs_encoder *enc, const void *val)
{
    const VkBaseInStructure *pnext = val;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_BUDGET_PROPERTIES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceMemoryProperties2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceMemoryBudgetPropertiesEXT_self(enc, (const VkPhysicalDeviceMemoryBudgetPropertiesEXT *)pnext);
            return;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceMemoryProperties2_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceMemoryProperties2 *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkPhysicalDeviceMemoryProperties(enc, &val->memoryProperties);
}

static inline void
vn_encode_VkPhysicalDeviceMemoryProperties2(struct vn_cs_encoder *enc, const VkPhysicalDeviceMemoryProperties2 *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PROPERTIES_2);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PROPERTIES_2 });
    vn_encode_VkPhysicalDeviceMemoryProperties2_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceMemoryProperties2_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceMemoryProperties2_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    VkBaseOutStructure *pnext;
    VkStructureType stype;

    if (!vn_decode_simple_pointer(dec))
        return NULL;

    vn_decode_VkStructureType(dec, &stype);
    switch ((int32_t)stype) {
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_BUDGET_PROPERTIES_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPhysicalDeviceMemoryBudgetPropertiesEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceMemoryProperties2_pnext_partial_temp(dec);
            vn_decode_VkPhysicalDeviceMemoryBudgetPropertiesEXT_self_partial_temp(dec, (VkPhysicalDeviceMemoryBudgetPropertiesEXT *)pnext);
        }
        break;
    default:
        /* unexpected struct */
        pnext = NULL;
        vn_cs_decoder_set_fatal(dec);
        break;
    }

    return pnext;
}

static inline void
vn_decode_VkPhysicalDeviceMemoryProperties2_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMemoryProperties2 *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkPhysicalDeviceMemoryProperties_partial_temp(dec, &val->memoryProperties);
}

static inline void
vn_decode_VkPhysicalDeviceMemoryProperties2_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceMemoryProperties2 *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PROPERTIES_2)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceMemoryProperties2_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceMemoryProperties2_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceSparseImageFormatInfo2 chain */

static inline void *
vn_decode_VkPhysicalDeviceSparseImageFormatInfo2_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceSparseImageFormatInfo2_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceSparseImageFormatInfo2 *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFormat(dec, &val->format);
    vn_decode_VkImageType(dec, &val->type);
    vn_decode_VkSampleCountFlagBits(dec, &val->samples);
    vn_decode_VkFlags(dec, &val->usage);
    vn_decode_VkImageTiling(dec, &val->tiling);
}

static inline void
vn_decode_VkPhysicalDeviceSparseImageFormatInfo2_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceSparseImageFormatInfo2 *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SPARSE_IMAGE_FORMAT_INFO_2)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceSparseImageFormatInfo2_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceSparseImageFormatInfo2_self_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceSparseImageFormatInfo2_handle_self(VkPhysicalDeviceSparseImageFormatInfo2 *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->format */
    /* skip val->type */
    /* skip val->samples */
    /* skip val->usage */
    /* skip val->tiling */
}

static inline void
vn_replace_VkPhysicalDeviceSparseImageFormatInfo2_handle(VkPhysicalDeviceSparseImageFormatInfo2 *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SPARSE_IMAGE_FORMAT_INFO_2:
            vn_replace_VkPhysicalDeviceSparseImageFormatInfo2_handle_self((VkPhysicalDeviceSparseImageFormatInfo2 *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkSparseImageFormatProperties2 chain */

static inline void
vn_encode_VkSparseImageFormatProperties2_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkSparseImageFormatProperties2_self(struct vn_cs_encoder *enc, const VkSparseImageFormatProperties2 *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkSparseImageFormatProperties(enc, &val->properties);
}

static inline void
vn_encode_VkSparseImageFormatProperties2(struct vn_cs_encoder *enc, const VkSparseImageFormatProperties2 *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_SPARSE_IMAGE_FORMAT_PROPERTIES_2);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_SPARSE_IMAGE_FORMAT_PROPERTIES_2 });
    vn_encode_VkSparseImageFormatProperties2_pnext(enc, val->pNext);
    vn_encode_VkSparseImageFormatProperties2_self(enc, val);
}

static inline void *
vn_decode_VkSparseImageFormatProperties2_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkSparseImageFormatProperties2_self_partial_temp(struct vn_cs_decoder *dec, VkSparseImageFormatProperties2 *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkSparseImageFormatProperties_partial_temp(dec, &val->properties);
}

static inline void
vn_decode_VkSparseImageFormatProperties2_partial_temp(struct vn_cs_decoder *dec, VkSparseImageFormatProperties2 *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_SPARSE_IMAGE_FORMAT_PROPERTIES_2)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkSparseImageFormatProperties2_pnext_partial_temp(dec);
    vn_decode_VkSparseImageFormatProperties2_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceExternalBufferInfo chain */

static inline void *
vn_decode_VkPhysicalDeviceExternalBufferInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceExternalBufferInfo_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceExternalBufferInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->flags);
    vn_decode_VkFlags(dec, &val->usage);
    vn_decode_VkExternalMemoryHandleTypeFlagBits(dec, &val->handleType);
}

static inline void
vn_decode_VkPhysicalDeviceExternalBufferInfo_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceExternalBufferInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_BUFFER_INFO)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceExternalBufferInfo_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceExternalBufferInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceExternalBufferInfo_handle_self(VkPhysicalDeviceExternalBufferInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->flags */
    /* skip val->usage */
    /* skip val->handleType */
}

static inline void
vn_replace_VkPhysicalDeviceExternalBufferInfo_handle(VkPhysicalDeviceExternalBufferInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_BUFFER_INFO:
            vn_replace_VkPhysicalDeviceExternalBufferInfo_handle_self((VkPhysicalDeviceExternalBufferInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkExternalBufferProperties chain */

static inline void
vn_encode_VkExternalBufferProperties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkExternalBufferProperties_self(struct vn_cs_encoder *enc, const VkExternalBufferProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkExternalMemoryProperties(enc, &val->externalMemoryProperties);
}

static inline void
vn_encode_VkExternalBufferProperties(struct vn_cs_encoder *enc, const VkExternalBufferProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_EXTERNAL_BUFFER_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_EXTERNAL_BUFFER_PROPERTIES });
    vn_encode_VkExternalBufferProperties_pnext(enc, val->pNext);
    vn_encode_VkExternalBufferProperties_self(enc, val);
}

static inline void *
vn_decode_VkExternalBufferProperties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkExternalBufferProperties_self_partial_temp(struct vn_cs_decoder *dec, VkExternalBufferProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkExternalMemoryProperties_partial_temp(dec, &val->externalMemoryProperties);
}

static inline void
vn_decode_VkExternalBufferProperties_partial_temp(struct vn_cs_decoder *dec, VkExternalBufferProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_EXTERNAL_BUFFER_PROPERTIES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkExternalBufferProperties_pnext_partial_temp(dec);
    vn_decode_VkExternalBufferProperties_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceExternalSemaphoreInfo chain */

static inline void *
vn_decode_VkPhysicalDeviceExternalSemaphoreInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    VkBaseOutStructure *pnext;
    VkStructureType stype;

    if (!vn_decode_simple_pointer(dec))
        return NULL;

    vn_decode_VkStructureType(dec, &stype);
    switch ((int32_t)stype) {
    case VK_STRUCTURE_TYPE_SEMAPHORE_TYPE_CREATE_INFO:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkSemaphoreTypeCreateInfo));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPhysicalDeviceExternalSemaphoreInfo_pnext_temp(dec);
            vn_decode_VkSemaphoreTypeCreateInfo_self_temp(dec, (VkSemaphoreTypeCreateInfo *)pnext);
        }
        break;
    default:
        /* unexpected struct */
        pnext = NULL;
        vn_cs_decoder_set_fatal(dec);
        break;
    }

    return pnext;
}

static inline void
vn_decode_VkPhysicalDeviceExternalSemaphoreInfo_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceExternalSemaphoreInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkExternalSemaphoreHandleTypeFlagBits(dec, &val->handleType);
}

static inline void
vn_decode_VkPhysicalDeviceExternalSemaphoreInfo_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceExternalSemaphoreInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_SEMAPHORE_INFO)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceExternalSemaphoreInfo_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceExternalSemaphoreInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceExternalSemaphoreInfo_handle_self(VkPhysicalDeviceExternalSemaphoreInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->handleType */
}

static inline void
vn_replace_VkPhysicalDeviceExternalSemaphoreInfo_handle(VkPhysicalDeviceExternalSemaphoreInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_SEMAPHORE_INFO:
            vn_replace_VkPhysicalDeviceExternalSemaphoreInfo_handle_self((VkPhysicalDeviceExternalSemaphoreInfo *)pnext);
            break;
        case VK_STRUCTURE_TYPE_SEMAPHORE_TYPE_CREATE_INFO:
            vn_replace_VkSemaphoreTypeCreateInfo_handle_self((VkSemaphoreTypeCreateInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkExternalSemaphoreProperties chain */

static inline void
vn_encode_VkExternalSemaphoreProperties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkExternalSemaphoreProperties_self(struct vn_cs_encoder *enc, const VkExternalSemaphoreProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFlags(enc, &val->exportFromImportedHandleTypes);
    vn_encode_VkFlags(enc, &val->compatibleHandleTypes);
    vn_encode_VkFlags(enc, &val->externalSemaphoreFeatures);
}

static inline void
vn_encode_VkExternalSemaphoreProperties(struct vn_cs_encoder *enc, const VkExternalSemaphoreProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_EXTERNAL_SEMAPHORE_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_EXTERNAL_SEMAPHORE_PROPERTIES });
    vn_encode_VkExternalSemaphoreProperties_pnext(enc, val->pNext);
    vn_encode_VkExternalSemaphoreProperties_self(enc, val);
}

static inline void *
vn_decode_VkExternalSemaphoreProperties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkExternalSemaphoreProperties_self_partial_temp(struct vn_cs_decoder *dec, VkExternalSemaphoreProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->exportFromImportedHandleTypes */
    /* skip val->compatibleHandleTypes */
    /* skip val->externalSemaphoreFeatures */
}

static inline void
vn_decode_VkExternalSemaphoreProperties_partial_temp(struct vn_cs_decoder *dec, VkExternalSemaphoreProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_EXTERNAL_SEMAPHORE_PROPERTIES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkExternalSemaphoreProperties_pnext_partial_temp(dec);
    vn_decode_VkExternalSemaphoreProperties_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceExternalFenceInfo chain */

static inline void *
vn_decode_VkPhysicalDeviceExternalFenceInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceExternalFenceInfo_self_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceExternalFenceInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkExternalFenceHandleTypeFlagBits(dec, &val->handleType);
}

static inline void
vn_decode_VkPhysicalDeviceExternalFenceInfo_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceExternalFenceInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_FENCE_INFO)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceExternalFenceInfo_pnext_temp(dec);
    vn_decode_VkPhysicalDeviceExternalFenceInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkPhysicalDeviceExternalFenceInfo_handle_self(VkPhysicalDeviceExternalFenceInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->handleType */
}

static inline void
vn_replace_VkPhysicalDeviceExternalFenceInfo_handle(VkPhysicalDeviceExternalFenceInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_FENCE_INFO:
            vn_replace_VkPhysicalDeviceExternalFenceInfo_handle_self((VkPhysicalDeviceExternalFenceInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkExternalFenceProperties chain */

static inline void
vn_encode_VkExternalFenceProperties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkExternalFenceProperties_self(struct vn_cs_encoder *enc, const VkExternalFenceProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFlags(enc, &val->exportFromImportedHandleTypes);
    vn_encode_VkFlags(enc, &val->compatibleHandleTypes);
    vn_encode_VkFlags(enc, &val->externalFenceFeatures);
}

static inline void
vn_encode_VkExternalFenceProperties(struct vn_cs_encoder *enc, const VkExternalFenceProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_EXTERNAL_FENCE_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_EXTERNAL_FENCE_PROPERTIES });
    vn_encode_VkExternalFenceProperties_pnext(enc, val->pNext);
    vn_encode_VkExternalFenceProperties_self(enc, val);
}

static inline void *
vn_decode_VkExternalFenceProperties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkExternalFenceProperties_self_partial_temp(struct vn_cs_decoder *dec, VkExternalFenceProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->exportFromImportedHandleTypes */
    /* skip val->compatibleHandleTypes */
    /* skip val->externalFenceFeatures */
}

static inline void
vn_decode_VkExternalFenceProperties_partial_temp(struct vn_cs_decoder *dec, VkExternalFenceProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_EXTERNAL_FENCE_PROPERTIES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkExternalFenceProperties_pnext_partial_temp(dec);
    vn_decode_VkExternalFenceProperties_self_partial_temp(dec, val);
}

/* struct VkPhysicalDeviceGroupProperties chain */

static inline void
vn_encode_VkPhysicalDeviceGroupProperties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceGroupProperties_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceGroupProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->physicalDeviceCount);
    vn_encode_array_size(enc, VK_MAX_DEVICE_GROUP_SIZE);
    for (uint32_t i = 0; i < VK_MAX_DEVICE_GROUP_SIZE; i++)
        vn_encode_VkPhysicalDevice(enc, &val->physicalDevices[i]);
    vn_encode_VkBool32(enc, &val->subsetAllocation);
}

static inline void
vn_encode_VkPhysicalDeviceGroupProperties(struct vn_cs_encoder *enc, const VkPhysicalDeviceGroupProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GROUP_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GROUP_PROPERTIES });
    vn_encode_VkPhysicalDeviceGroupProperties_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceGroupProperties_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceGroupProperties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceGroupProperties_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceGroupProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->physicalDeviceCount */
    {
        const uint32_t iter_count = vn_decode_array_size(dec, VK_MAX_DEVICE_GROUP_SIZE);
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkPhysicalDevice_temp(dec, &val->physicalDevices[i]);
    }
    /* skip val->subsetAllocation */
}

static inline void
vn_decode_VkPhysicalDeviceGroupProperties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceGroupProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GROUP_PROPERTIES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceGroupProperties_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceGroupProperties_self_partial_temp(dec, val);
}

/* struct VkDeviceQueueTimelineInfoMESA chain */

static inline void *
vn_decode_VkDeviceQueueTimelineInfoMESA_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkDeviceQueueTimelineInfoMESA_self_temp(struct vn_cs_decoder *dec, VkDeviceQueueTimelineInfoMESA *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint32_t(dec, &val->ringIdx);
}

static inline void
vn_decode_VkDeviceQueueTimelineInfoMESA_temp(struct vn_cs_decoder *dec, VkDeviceQueueTimelineInfoMESA *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_DEVICE_QUEUE_TIMELINE_INFO_MESA)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkDeviceQueueTimelineInfoMESA_pnext_temp(dec);
    vn_decode_VkDeviceQueueTimelineInfoMESA_self_temp(dec, val);
}

static inline void
vn_replace_VkDeviceQueueTimelineInfoMESA_handle_self(VkDeviceQueueTimelineInfoMESA *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->ringIdx */
}

static inline void
vn_replace_VkDeviceQueueTimelineInfoMESA_handle(VkDeviceQueueTimelineInfoMESA *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_DEVICE_QUEUE_TIMELINE_INFO_MESA:
            vn_replace_VkDeviceQueueTimelineInfoMESA_handle_self((VkDeviceQueueTimelineInfoMESA *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkDeviceQueueInfo2 chain */

static inline void *
vn_decode_VkDeviceQueueInfo2_pnext_temp(struct vn_cs_decoder *dec)
{
    VkBaseOutStructure *pnext;
    VkStructureType stype;

    if (!vn_decode_simple_pointer(dec))
        return NULL;

    vn_decode_VkStructureType(dec, &stype);
    switch ((int32_t)stype) {
    case VK_STRUCTURE_TYPE_DEVICE_QUEUE_TIMELINE_INFO_MESA:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkDeviceQueueTimelineInfoMESA));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDeviceQueueInfo2_pnext_temp(dec);
            vn_decode_VkDeviceQueueTimelineInfoMESA_self_temp(dec, (VkDeviceQueueTimelineInfoMESA *)pnext);
        }
        break;
    default:
        /* unexpected struct */
        pnext = NULL;
        vn_cs_decoder_set_fatal(dec);
        break;
    }

    return pnext;
}

static inline void
vn_decode_VkDeviceQueueInfo2_self_temp(struct vn_cs_decoder *dec, VkDeviceQueueInfo2 *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->flags);
    vn_decode_uint32_t(dec, &val->queueFamilyIndex);
    vn_decode_uint32_t(dec, &val->queueIndex);
}

static inline void
vn_decode_VkDeviceQueueInfo2_temp(struct vn_cs_decoder *dec, VkDeviceQueueInfo2 *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_DEVICE_QUEUE_INFO_2)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkDeviceQueueInfo2_pnext_temp(dec);
    vn_decode_VkDeviceQueueInfo2_self_temp(dec, val);
}

static inline void
vn_replace_VkDeviceQueueInfo2_handle_self(VkDeviceQueueInfo2 *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->flags */
    /* skip val->queueFamilyIndex */
    /* skip val->queueIndex */
}

static inline void
vn_replace_VkDeviceQueueInfo2_handle(VkDeviceQueueInfo2 *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_DEVICE_QUEUE_INFO_2:
            vn_replace_VkDeviceQueueInfo2_handle_self((VkDeviceQueueInfo2 *)pnext);
            break;
        case VK_STRUCTURE_TYPE_DEVICE_QUEUE_TIMELINE_INFO_MESA:
            vn_replace_VkDeviceQueueTimelineInfoMESA_handle_self((VkDeviceQueueTimelineInfoMESA *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkCalibratedTimestampInfoEXT chain */

static inline void *
vn_decode_VkCalibratedTimestampInfoEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkCalibratedTimestampInfoEXT_self_temp(struct vn_cs_decoder *dec, VkCalibratedTimestampInfoEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkTimeDomainEXT(dec, &val->timeDomain);
}

static inline void
vn_decode_VkCalibratedTimestampInfoEXT_temp(struct vn_cs_decoder *dec, VkCalibratedTimestampInfoEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_CALIBRATED_TIMESTAMP_INFO_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkCalibratedTimestampInfoEXT_pnext_temp(dec);
    vn_decode_VkCalibratedTimestampInfoEXT_self_temp(dec, val);
}

static inline void
vn_replace_VkCalibratedTimestampInfoEXT_handle_self(VkCalibratedTimestampInfoEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->timeDomain */
}

static inline void
vn_replace_VkCalibratedTimestampInfoEXT_handle(VkCalibratedTimestampInfoEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_CALIBRATED_TIMESTAMP_INFO_EXT:
            vn_replace_VkCalibratedTimestampInfoEXT_handle_self((VkCalibratedTimestampInfoEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPhysicalDeviceToolProperties chain */

static inline void
vn_encode_VkPhysicalDeviceToolProperties_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceToolProperties_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceToolProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_array_size(enc, VK_MAX_EXTENSION_NAME_SIZE);
    vn_encode_char_array(enc, val->name, VK_MAX_EXTENSION_NAME_SIZE);
    vn_encode_array_size(enc, VK_MAX_EXTENSION_NAME_SIZE);
    vn_encode_char_array(enc, val->version, VK_MAX_EXTENSION_NAME_SIZE);
    vn_encode_VkFlags(enc, &val->purposes);
    vn_encode_array_size(enc, VK_MAX_DESCRIPTION_SIZE);
    vn_encode_char_array(enc, val->description, VK_MAX_DESCRIPTION_SIZE);
    vn_encode_array_size(enc, VK_MAX_EXTENSION_NAME_SIZE);
    vn_encode_char_array(enc, val->layer, VK_MAX_EXTENSION_NAME_SIZE);
}

static inline void
vn_encode_VkPhysicalDeviceToolProperties(struct vn_cs_encoder *enc, const VkPhysicalDeviceToolProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TOOL_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TOOL_PROPERTIES });
    vn_encode_VkPhysicalDeviceToolProperties_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceToolProperties_self(enc, val);
}

static inline void *
vn_decode_VkPhysicalDeviceToolProperties_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPhysicalDeviceToolProperties_self_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceToolProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->name */
    /* skip val->version */
    /* skip val->purposes */
    /* skip val->description */
    /* skip val->layer */
}

static inline void
vn_decode_VkPhysicalDeviceToolProperties_partial_temp(struct vn_cs_decoder *dec, VkPhysicalDeviceToolProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TOOL_PROPERTIES)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPhysicalDeviceToolProperties_pnext_partial_temp(dec);
    vn_decode_VkPhysicalDeviceToolProperties_self_partial_temp(dec, val);
}

static inline void vn_decode_vkEnumeratePhysicalDevices_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkEnumeratePhysicalDevices *args)
{
    vn_decode_VkInstance_lookup(dec, &args->instance);
    if (vn_decode_simple_pointer(dec)) {
        args->pPhysicalDeviceCount = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pPhysicalDeviceCount));
        if (!args->pPhysicalDeviceCount) return;
        vn_decode_uint32_t(dec, args->pPhysicalDeviceCount);
    } else {
        args->pPhysicalDeviceCount = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, (args->pPhysicalDeviceCount ? *args->pPhysicalDeviceCount : 0));
        args->pPhysicalDevices = vn_cs_decoder_alloc_temp_array(dec, sizeof(*args->pPhysicalDevices), iter_count);
        if (!args->pPhysicalDevices) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkPhysicalDevice_temp(dec, &args->pPhysicalDevices[i]);
    } else {
        vn_decode_array_size_unchecked(dec);
        args->pPhysicalDevices = NULL;
    }
}

static inline void vn_replace_vkEnumeratePhysicalDevices_args_handle(struct vn_command_vkEnumeratePhysicalDevices *args)
{
    vn_replace_VkInstance_handle(&args->instance);
    /* skip args->pPhysicalDeviceCount */
    /* skip args->pPhysicalDevices */
}

static inline void vn_encode_vkEnumeratePhysicalDevices_reply(struct vn_cs_encoder *enc, const struct vn_command_vkEnumeratePhysicalDevices *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkEnumeratePhysicalDevices_EXT});

    vn_encode_VkResult(enc, &args->ret);
    /* skip args->instance */
    if (vn_encode_simple_pointer(enc, args->pPhysicalDeviceCount))
        vn_encode_uint32_t(enc, args->pPhysicalDeviceCount);
    if (args->pPhysicalDevices) {
        vn_encode_array_size(enc, (args->pPhysicalDeviceCount ? *args->pPhysicalDeviceCount : 0));
        for (uint32_t i = 0; i < (args->pPhysicalDeviceCount ? *args->pPhysicalDeviceCount : 0); i++)
            vn_encode_VkPhysicalDevice(enc, &args->pPhysicalDevices[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void vn_decode_vkGetPhysicalDeviceProperties_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkGetPhysicalDeviceProperties *args)
{
    vn_decode_VkPhysicalDevice_lookup(dec, &args->physicalDevice);
    if (vn_decode_simple_pointer(dec)) {
        args->pProperties = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pProperties));
        if (!args->pProperties) return;
        vn_decode_VkPhysicalDeviceProperties_partial_temp(dec, args->pProperties);
    } else {
        args->pProperties = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
}

static inline void vn_replace_vkGetPhysicalDeviceProperties_args_handle(struct vn_command_vkGetPhysicalDeviceProperties *args)
{
    vn_replace_VkPhysicalDevice_handle(&args->physicalDevice);
    /* skip args->pProperties */
}

static inline void vn_encode_vkGetPhysicalDeviceProperties_reply(struct vn_cs_encoder *enc, const struct vn_command_vkGetPhysicalDeviceProperties *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkGetPhysicalDeviceProperties_EXT});

    /* skip args->physicalDevice */
    if (vn_encode_simple_pointer(enc, args->pProperties))
        vn_encode_VkPhysicalDeviceProperties(enc, args->pProperties);
}

static inline void vn_decode_vkGetPhysicalDeviceQueueFamilyProperties_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkGetPhysicalDeviceQueueFamilyProperties *args)
{
    vn_decode_VkPhysicalDevice_lookup(dec, &args->physicalDevice);
    if (vn_decode_simple_pointer(dec)) {
        args->pQueueFamilyPropertyCount = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pQueueFamilyPropertyCount));
        if (!args->pQueueFamilyPropertyCount) return;
        vn_decode_uint32_t(dec, args->pQueueFamilyPropertyCount);
    } else {
        args->pQueueFamilyPropertyCount = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, (args->pQueueFamilyPropertyCount ? *args->pQueueFamilyPropertyCount : 0));
        args->pQueueFamilyProperties = vn_cs_decoder_alloc_temp_array(dec, sizeof(*args->pQueueFamilyProperties), iter_count);
        if (!args->pQueueFamilyProperties) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkQueueFamilyProperties_partial_temp(dec, &args->pQueueFamilyProperties[i]);
    } else {
        vn_decode_array_size_unchecked(dec);
        args->pQueueFamilyProperties = NULL;
    }
}

static inline void vn_replace_vkGetPhysicalDeviceQueueFamilyProperties_args_handle(struct vn_command_vkGetPhysicalDeviceQueueFamilyProperties *args)
{
    vn_replace_VkPhysicalDevice_handle(&args->physicalDevice);
    /* skip args->pQueueFamilyPropertyCount */
    /* skip args->pQueueFamilyProperties */
}

static inline void vn_encode_vkGetPhysicalDeviceQueueFamilyProperties_reply(struct vn_cs_encoder *enc, const struct vn_command_vkGetPhysicalDeviceQueueFamilyProperties *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkGetPhysicalDeviceQueueFamilyProperties_EXT});

    /* skip args->physicalDevice */
    if (vn_encode_simple_pointer(enc, args->pQueueFamilyPropertyCount))
        vn_encode_uint32_t(enc, args->pQueueFamilyPropertyCount);
    if (args->pQueueFamilyProperties) {
        vn_encode_array_size(enc, (args->pQueueFamilyPropertyCount ? *args->pQueueFamilyPropertyCount : 0));
        for (uint32_t i = 0; i < (args->pQueueFamilyPropertyCount ? *args->pQueueFamilyPropertyCount : 0); i++)
            vn_encode_VkQueueFamilyProperties(enc, &args->pQueueFamilyProperties[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void vn_decode_vkGetPhysicalDeviceMemoryProperties_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkGetPhysicalDeviceMemoryProperties *args)
{
    vn_decode_VkPhysicalDevice_lookup(dec, &args->physicalDevice);
    if (vn_decode_simple_pointer(dec)) {
        args->pMemoryProperties = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pMemoryProperties));
        if (!args->pMemoryProperties) return;
        vn_decode_VkPhysicalDeviceMemoryProperties_partial_temp(dec, args->pMemoryProperties);
    } else {
        args->pMemoryProperties = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
}

static inline void vn_replace_vkGetPhysicalDeviceMemoryProperties_args_handle(struct vn_command_vkGetPhysicalDeviceMemoryProperties *args)
{
    vn_replace_VkPhysicalDevice_handle(&args->physicalDevice);
    /* skip args->pMemoryProperties */
}

static inline void vn_encode_vkGetPhysicalDeviceMemoryProperties_reply(struct vn_cs_encoder *enc, const struct vn_command_vkGetPhysicalDeviceMemoryProperties *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkGetPhysicalDeviceMemoryProperties_EXT});

    /* skip args->physicalDevice */
    if (vn_encode_simple_pointer(enc, args->pMemoryProperties))
        vn_encode_VkPhysicalDeviceMemoryProperties(enc, args->pMemoryProperties);
}

static inline void vn_decode_vkGetPhysicalDeviceFeatures_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkGetPhysicalDeviceFeatures *args)
{
    vn_decode_VkPhysicalDevice_lookup(dec, &args->physicalDevice);
    if (vn_decode_simple_pointer(dec)) {
        args->pFeatures = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pFeatures));
        if (!args->pFeatures) return;
        vn_decode_VkPhysicalDeviceFeatures_partial_temp(dec, args->pFeatures);
    } else {
        args->pFeatures = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
}

static inline void vn_replace_vkGetPhysicalDeviceFeatures_args_handle(struct vn_command_vkGetPhysicalDeviceFeatures *args)
{
    vn_replace_VkPhysicalDevice_handle(&args->physicalDevice);
    /* skip args->pFeatures */
}

static inline void vn_encode_vkGetPhysicalDeviceFeatures_reply(struct vn_cs_encoder *enc, const struct vn_command_vkGetPhysicalDeviceFeatures *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkGetPhysicalDeviceFeatures_EXT});

    /* skip args->physicalDevice */
    if (vn_encode_simple_pointer(enc, args->pFeatures))
        vn_encode_VkPhysicalDeviceFeatures(enc, args->pFeatures);
}

static inline void vn_decode_vkGetPhysicalDeviceFormatProperties_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkGetPhysicalDeviceFormatProperties *args)
{
    vn_decode_VkPhysicalDevice_lookup(dec, &args->physicalDevice);
    vn_decode_VkFormat(dec, &args->format);
    if (vn_decode_simple_pointer(dec)) {
        args->pFormatProperties = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pFormatProperties));
        if (!args->pFormatProperties) return;
        vn_decode_VkFormatProperties_partial_temp(dec, args->pFormatProperties);
    } else {
        args->pFormatProperties = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
}

static inline void vn_replace_vkGetPhysicalDeviceFormatProperties_args_handle(struct vn_command_vkGetPhysicalDeviceFormatProperties *args)
{
    vn_replace_VkPhysicalDevice_handle(&args->physicalDevice);
    /* skip args->format */
    /* skip args->pFormatProperties */
}

static inline void vn_encode_vkGetPhysicalDeviceFormatProperties_reply(struct vn_cs_encoder *enc, const struct vn_command_vkGetPhysicalDeviceFormatProperties *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkGetPhysicalDeviceFormatProperties_EXT});

    /* skip args->physicalDevice */
    /* skip args->format */
    if (vn_encode_simple_pointer(enc, args->pFormatProperties))
        vn_encode_VkFormatProperties(enc, args->pFormatProperties);
}

static inline void vn_decode_vkGetPhysicalDeviceImageFormatProperties_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkGetPhysicalDeviceImageFormatProperties *args)
{
    vn_decode_VkPhysicalDevice_lookup(dec, &args->physicalDevice);
    vn_decode_VkFormat(dec, &args->format);
    vn_decode_VkImageType(dec, &args->type);
    vn_decode_VkImageTiling(dec, &args->tiling);
    vn_decode_VkFlags(dec, &args->usage);
    vn_decode_VkFlags(dec, &args->flags);
    if (vn_decode_simple_pointer(dec)) {
        args->pImageFormatProperties = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pImageFormatProperties));
        if (!args->pImageFormatProperties) return;
        vn_decode_VkImageFormatProperties_partial_temp(dec, args->pImageFormatProperties);
    } else {
        args->pImageFormatProperties = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
}

static inline void vn_replace_vkGetPhysicalDeviceImageFormatProperties_args_handle(struct vn_command_vkGetPhysicalDeviceImageFormatProperties *args)
{
    vn_replace_VkPhysicalDevice_handle(&args->physicalDevice);
    /* skip args->format */
    /* skip args->type */
    /* skip args->tiling */
    /* skip args->usage */
    /* skip args->flags */
    /* skip args->pImageFormatProperties */
}

static inline void vn_encode_vkGetPhysicalDeviceImageFormatProperties_reply(struct vn_cs_encoder *enc, const struct vn_command_vkGetPhysicalDeviceImageFormatProperties *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkGetPhysicalDeviceImageFormatProperties_EXT});

    vn_encode_VkResult(enc, &args->ret);
    /* skip args->physicalDevice */
    /* skip args->format */
    /* skip args->type */
    /* skip args->tiling */
    /* skip args->usage */
    /* skip args->flags */
    if (vn_encode_simple_pointer(enc, args->pImageFormatProperties))
        vn_encode_VkImageFormatProperties(enc, args->pImageFormatProperties);
}

static inline void vn_decode_vkCreateDevice_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCreateDevice *args)
{
    vn_decode_VkPhysicalDevice_lookup(dec, &args->physicalDevice);
    if (vn_decode_simple_pointer(dec)) {
        args->pCreateInfo = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pCreateInfo));
        if (!args->pCreateInfo) return;
        vn_decode_VkDeviceCreateInfo_temp(dec, (VkDeviceCreateInfo *)args->pCreateInfo);
    } else {
        args->pCreateInfo = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
    if (vn_decode_simple_pointer(dec)) {
        vn_cs_decoder_set_fatal(dec);
    } else {
        args->pAllocator = NULL;
    }
    if (vn_decode_simple_pointer(dec)) {
        args->pDevice = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pDevice));
        if (!args->pDevice) return;
        vn_decode_VkDevice_temp(dec, args->pDevice);
    } else {
        args->pDevice = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
}

static inline void vn_replace_vkCreateDevice_args_handle(struct vn_command_vkCreateDevice *args)
{
    vn_replace_VkPhysicalDevice_handle(&args->physicalDevice);
    if (args->pCreateInfo)
        vn_replace_VkDeviceCreateInfo_handle((VkDeviceCreateInfo *)args->pCreateInfo);
    /* skip args->pAllocator */
    /* skip args->pDevice */
}

static inline void vn_encode_vkCreateDevice_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCreateDevice *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCreateDevice_EXT});

    vn_encode_VkResult(enc, &args->ret);
    /* skip args->physicalDevice */
    /* skip args->pCreateInfo */
    /* skip args->pAllocator */
    if (vn_encode_simple_pointer(enc, args->pDevice))
        vn_encode_VkDevice(enc, args->pDevice);
}

static inline void vn_decode_vkDestroyDevice_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkDestroyDevice *args)
{
    vn_decode_VkDevice_lookup(dec, &args->device);
    if (vn_decode_simple_pointer(dec)) {
        vn_cs_decoder_set_fatal(dec);
    } else {
        args->pAllocator = NULL;
    }
}

static inline void vn_replace_vkDestroyDevice_args_handle(struct vn_command_vkDestroyDevice *args)
{
    vn_replace_VkDevice_handle(&args->device);
    /* skip args->pAllocator */
}

static inline void vn_encode_vkDestroyDevice_reply(struct vn_cs_encoder *enc, const struct vn_command_vkDestroyDevice *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkDestroyDevice_EXT});

    /* skip args->device */
    /* skip args->pAllocator */
}

static inline void vn_decode_vkEnumerateDeviceLayerProperties_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkEnumerateDeviceLayerProperties *args)
{
    vn_decode_VkPhysicalDevice_lookup(dec, &args->physicalDevice);
    if (vn_decode_simple_pointer(dec)) {
        args->pPropertyCount = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pPropertyCount));
        if (!args->pPropertyCount) return;
        vn_decode_uint32_t(dec, args->pPropertyCount);
    } else {
        args->pPropertyCount = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, (args->pPropertyCount ? *args->pPropertyCount : 0));
        args->pProperties = vn_cs_decoder_alloc_temp_array(dec, sizeof(*args->pProperties), iter_count);
        if (!args->pProperties) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkLayerProperties_partial_temp(dec, &args->pProperties[i]);
    } else {
        vn_decode_array_size_unchecked(dec);
        args->pProperties = NULL;
    }
}

static inline void vn_replace_vkEnumerateDeviceLayerProperties_args_handle(struct vn_command_vkEnumerateDeviceLayerProperties *args)
{
    vn_replace_VkPhysicalDevice_handle(&args->physicalDevice);
    /* skip args->pPropertyCount */
    /* skip args->pProperties */
}

static inline void vn_encode_vkEnumerateDeviceLayerProperties_reply(struct vn_cs_encoder *enc, const struct vn_command_vkEnumerateDeviceLayerProperties *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkEnumerateDeviceLayerProperties_EXT});

    vn_encode_VkResult(enc, &args->ret);
    /* skip args->physicalDevice */
    if (vn_encode_simple_pointer(enc, args->pPropertyCount))
        vn_encode_uint32_t(enc, args->pPropertyCount);
    if (args->pProperties) {
        vn_encode_array_size(enc, (args->pPropertyCount ? *args->pPropertyCount : 0));
        for (uint32_t i = 0; i < (args->pPropertyCount ? *args->pPropertyCount : 0); i++)
            vn_encode_VkLayerProperties(enc, &args->pProperties[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void vn_decode_vkEnumerateDeviceExtensionProperties_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkEnumerateDeviceExtensionProperties *args)
{
    vn_decode_VkPhysicalDevice_lookup(dec, &args->physicalDevice);
    if (vn_peek_array_size(dec)) {
        const size_t string_size = vn_decode_array_size_unchecked(dec);
        args->pLayerName = vn_cs_decoder_alloc_temp_array(dec, sizeof(*args->pLayerName), string_size);
        if (!args->pLayerName) return;
        vn_decode_char_array(dec, (char *)args->pLayerName, string_size);
    } else {
        vn_decode_array_size_unchecked(dec);
        args->pLayerName = NULL;
    }
    if (vn_decode_simple_pointer(dec)) {
        args->pPropertyCount = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pPropertyCount));
        if (!args->pPropertyCount) return;
        vn_decode_uint32_t(dec, args->pPropertyCount);
    } else {
        args->pPropertyCount = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, (args->pPropertyCount ? *args->pPropertyCount : 0));
        args->pProperties = vn_cs_decoder_alloc_temp_array(dec, sizeof(*args->pProperties), iter_count);
        if (!args->pProperties) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkExtensionProperties_partial_temp(dec, &args->pProperties[i]);
    } else {
        vn_decode_array_size_unchecked(dec);
        args->pProperties = NULL;
    }
}

static inline void vn_replace_vkEnumerateDeviceExtensionProperties_args_handle(struct vn_command_vkEnumerateDeviceExtensionProperties *args)
{
    vn_replace_VkPhysicalDevice_handle(&args->physicalDevice);
    /* skip args->pLayerName */
    /* skip args->pPropertyCount */
    /* skip args->pProperties */
}

static inline void vn_encode_vkEnumerateDeviceExtensionProperties_reply(struct vn_cs_encoder *enc, const struct vn_command_vkEnumerateDeviceExtensionProperties *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkEnumerateDeviceExtensionProperties_EXT});

    vn_encode_VkResult(enc, &args->ret);
    /* skip args->physicalDevice */
    /* skip args->pLayerName */
    if (vn_encode_simple_pointer(enc, args->pPropertyCount))
        vn_encode_uint32_t(enc, args->pPropertyCount);
    if (args->pProperties) {
        vn_encode_array_size(enc, (args->pPropertyCount ? *args->pPropertyCount : 0));
        for (uint32_t i = 0; i < (args->pPropertyCount ? *args->pPropertyCount : 0); i++)
            vn_encode_VkExtensionProperties(enc, &args->pProperties[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void vn_decode_vkGetDeviceQueue_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkGetDeviceQueue *args)
{
    vn_decode_VkDevice_lookup(dec, &args->device);
    vn_decode_uint32_t(dec, &args->queueFamilyIndex);
    vn_decode_uint32_t(dec, &args->queueIndex);
    if (vn_decode_simple_pointer(dec)) {
        args->pQueue = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pQueue));
        if (!args->pQueue) return;
        vn_decode_VkQueue_temp(dec, args->pQueue);
    } else {
        args->pQueue = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
}

static inline void vn_replace_vkGetDeviceQueue_args_handle(struct vn_command_vkGetDeviceQueue *args)
{
    vn_replace_VkDevice_handle(&args->device);
    /* skip args->queueFamilyIndex */
    /* skip args->queueIndex */
    /* skip args->pQueue */
}

static inline void vn_encode_vkGetDeviceQueue_reply(struct vn_cs_encoder *enc, const struct vn_command_vkGetDeviceQueue *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkGetDeviceQueue_EXT});

    /* skip args->device */
    /* skip args->queueFamilyIndex */
    /* skip args->queueIndex */
    if (vn_encode_simple_pointer(enc, args->pQueue))
        vn_encode_VkQueue(enc, args->pQueue);
}

static inline void vn_decode_vkDeviceWaitIdle_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkDeviceWaitIdle *args)
{
    vn_decode_VkDevice_lookup(dec, &args->device);
}

static inline void vn_replace_vkDeviceWaitIdle_args_handle(struct vn_command_vkDeviceWaitIdle *args)
{
    vn_replace_VkDevice_handle(&args->device);
}

static inline void vn_encode_vkDeviceWaitIdle_reply(struct vn_cs_encoder *enc, const struct vn_command_vkDeviceWaitIdle *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkDeviceWaitIdle_EXT});

    vn_encode_VkResult(enc, &args->ret);
    /* skip args->device */
}

static inline void vn_decode_vkGetPhysicalDeviceSparseImageFormatProperties_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkGetPhysicalDeviceSparseImageFormatProperties *args)
{
    vn_decode_VkPhysicalDevice_lookup(dec, &args->physicalDevice);
    vn_decode_VkFormat(dec, &args->format);
    vn_decode_VkImageType(dec, &args->type);
    vn_decode_VkSampleCountFlagBits(dec, &args->samples);
    vn_decode_VkFlags(dec, &args->usage);
    vn_decode_VkImageTiling(dec, &args->tiling);
    if (vn_decode_simple_pointer(dec)) {
        args->pPropertyCount = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pPropertyCount));
        if (!args->pPropertyCount) return;
        vn_decode_uint32_t(dec, args->pPropertyCount);
    } else {
        args->pPropertyCount = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, (args->pPropertyCount ? *args->pPropertyCount : 0));
        args->pProperties = vn_cs_decoder_alloc_temp_array(dec, sizeof(*args->pProperties), iter_count);
        if (!args->pProperties) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkSparseImageFormatProperties_partial_temp(dec, &args->pProperties[i]);
    } else {
        vn_decode_array_size_unchecked(dec);
        args->pProperties = NULL;
    }
}

static inline void vn_replace_vkGetPhysicalDeviceSparseImageFormatProperties_args_handle(struct vn_command_vkGetPhysicalDeviceSparseImageFormatProperties *args)
{
    vn_replace_VkPhysicalDevice_handle(&args->physicalDevice);
    /* skip args->format */
    /* skip args->type */
    /* skip args->samples */
    /* skip args->usage */
    /* skip args->tiling */
    /* skip args->pPropertyCount */
    /* skip args->pProperties */
}

static inline void vn_encode_vkGetPhysicalDeviceSparseImageFormatProperties_reply(struct vn_cs_encoder *enc, const struct vn_command_vkGetPhysicalDeviceSparseImageFormatProperties *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkGetPhysicalDeviceSparseImageFormatProperties_EXT});

    /* skip args->physicalDevice */
    /* skip args->format */
    /* skip args->type */
    /* skip args->samples */
    /* skip args->usage */
    /* skip args->tiling */
    if (vn_encode_simple_pointer(enc, args->pPropertyCount))
        vn_encode_uint32_t(enc, args->pPropertyCount);
    if (args->pProperties) {
        vn_encode_array_size(enc, (args->pPropertyCount ? *args->pPropertyCount : 0));
        for (uint32_t i = 0; i < (args->pPropertyCount ? *args->pPropertyCount : 0); i++)
            vn_encode_VkSparseImageFormatProperties(enc, &args->pProperties[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void vn_decode_vkGetPhysicalDeviceFeatures2_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkGetPhysicalDeviceFeatures2 *args)
{
    vn_decode_VkPhysicalDevice_lookup(dec, &args->physicalDevice);
    if (vn_decode_simple_pointer(dec)) {
        args->pFeatures = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pFeatures));
        if (!args->pFeatures) return;
        vn_decode_VkPhysicalDeviceFeatures2_partial_temp(dec, args->pFeatures);
    } else {
        args->pFeatures = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
}

static inline void vn_replace_vkGetPhysicalDeviceFeatures2_args_handle(struct vn_command_vkGetPhysicalDeviceFeatures2 *args)
{
    vn_replace_VkPhysicalDevice_handle(&args->physicalDevice);
    /* skip args->pFeatures */
}

static inline void vn_encode_vkGetPhysicalDeviceFeatures2_reply(struct vn_cs_encoder *enc, const struct vn_command_vkGetPhysicalDeviceFeatures2 *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkGetPhysicalDeviceFeatures2_EXT});

    /* skip args->physicalDevice */
    if (vn_encode_simple_pointer(enc, args->pFeatures))
        vn_encode_VkPhysicalDeviceFeatures2(enc, args->pFeatures);
}

static inline void vn_decode_vkGetPhysicalDeviceProperties2_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkGetPhysicalDeviceProperties2 *args)
{
    vn_decode_VkPhysicalDevice_lookup(dec, &args->physicalDevice);
    if (vn_decode_simple_pointer(dec)) {
        args->pProperties = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pProperties));
        if (!args->pProperties) return;
        vn_decode_VkPhysicalDeviceProperties2_partial_temp(dec, args->pProperties);
    } else {
        args->pProperties = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
}

static inline void vn_replace_vkGetPhysicalDeviceProperties2_args_handle(struct vn_command_vkGetPhysicalDeviceProperties2 *args)
{
    vn_replace_VkPhysicalDevice_handle(&args->physicalDevice);
    /* skip args->pProperties */
}

static inline void vn_encode_vkGetPhysicalDeviceProperties2_reply(struct vn_cs_encoder *enc, const struct vn_command_vkGetPhysicalDeviceProperties2 *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkGetPhysicalDeviceProperties2_EXT});

    /* skip args->physicalDevice */
    if (vn_encode_simple_pointer(enc, args->pProperties))
        vn_encode_VkPhysicalDeviceProperties2(enc, args->pProperties);
}

static inline void vn_decode_vkGetPhysicalDeviceFormatProperties2_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkGetPhysicalDeviceFormatProperties2 *args)
{
    vn_decode_VkPhysicalDevice_lookup(dec, &args->physicalDevice);
    vn_decode_VkFormat(dec, &args->format);
    if (vn_decode_simple_pointer(dec)) {
        args->pFormatProperties = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pFormatProperties));
        if (!args->pFormatProperties) return;
        vn_decode_VkFormatProperties2_partial_temp(dec, args->pFormatProperties);
    } else {
        args->pFormatProperties = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
}

static inline void vn_replace_vkGetPhysicalDeviceFormatProperties2_args_handle(struct vn_command_vkGetPhysicalDeviceFormatProperties2 *args)
{
    vn_replace_VkPhysicalDevice_handle(&args->physicalDevice);
    /* skip args->format */
    /* skip args->pFormatProperties */
}

static inline void vn_encode_vkGetPhysicalDeviceFormatProperties2_reply(struct vn_cs_encoder *enc, const struct vn_command_vkGetPhysicalDeviceFormatProperties2 *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkGetPhysicalDeviceFormatProperties2_EXT});

    /* skip args->physicalDevice */
    /* skip args->format */
    if (vn_encode_simple_pointer(enc, args->pFormatProperties))
        vn_encode_VkFormatProperties2(enc, args->pFormatProperties);
}

static inline void vn_decode_vkGetPhysicalDeviceImageFormatProperties2_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkGetPhysicalDeviceImageFormatProperties2 *args)
{
    vn_decode_VkPhysicalDevice_lookup(dec, &args->physicalDevice);
    if (vn_decode_simple_pointer(dec)) {
        args->pImageFormatInfo = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pImageFormatInfo));
        if (!args->pImageFormatInfo) return;
        vn_decode_VkPhysicalDeviceImageFormatInfo2_temp(dec, (VkPhysicalDeviceImageFormatInfo2 *)args->pImageFormatInfo);
    } else {
        args->pImageFormatInfo = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
    if (vn_decode_simple_pointer(dec)) {
        args->pImageFormatProperties = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pImageFormatProperties));
        if (!args->pImageFormatProperties) return;
        vn_decode_VkImageFormatProperties2_partial_temp(dec, args->pImageFormatProperties);
    } else {
        args->pImageFormatProperties = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
}

static inline void vn_replace_vkGetPhysicalDeviceImageFormatProperties2_args_handle(struct vn_command_vkGetPhysicalDeviceImageFormatProperties2 *args)
{
    vn_replace_VkPhysicalDevice_handle(&args->physicalDevice);
    if (args->pImageFormatInfo)
        vn_replace_VkPhysicalDeviceImageFormatInfo2_handle((VkPhysicalDeviceImageFormatInfo2 *)args->pImageFormatInfo);
    /* skip args->pImageFormatProperties */
}

static inline void vn_encode_vkGetPhysicalDeviceImageFormatProperties2_reply(struct vn_cs_encoder *enc, const struct vn_command_vkGetPhysicalDeviceImageFormatProperties2 *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkGetPhysicalDeviceImageFormatProperties2_EXT});

    vn_encode_VkResult(enc, &args->ret);
    /* skip args->physicalDevice */
    /* skip args->pImageFormatInfo */
    if (vn_encode_simple_pointer(enc, args->pImageFormatProperties))
        vn_encode_VkImageFormatProperties2(enc, args->pImageFormatProperties);
}

static inline void vn_decode_vkGetPhysicalDeviceQueueFamilyProperties2_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkGetPhysicalDeviceQueueFamilyProperties2 *args)
{
    vn_decode_VkPhysicalDevice_lookup(dec, &args->physicalDevice);
    if (vn_decode_simple_pointer(dec)) {
        args->pQueueFamilyPropertyCount = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pQueueFamilyPropertyCount));
        if (!args->pQueueFamilyPropertyCount) return;
        vn_decode_uint32_t(dec, args->pQueueFamilyPropertyCount);
    } else {
        args->pQueueFamilyPropertyCount = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, (args->pQueueFamilyPropertyCount ? *args->pQueueFamilyPropertyCount : 0));
        args->pQueueFamilyProperties = vn_cs_decoder_alloc_temp_array(dec, sizeof(*args->pQueueFamilyProperties), iter_count);
        if (!args->pQueueFamilyProperties) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkQueueFamilyProperties2_partial_temp(dec, &args->pQueueFamilyProperties[i]);
    } else {
        vn_decode_array_size_unchecked(dec);
        args->pQueueFamilyProperties = NULL;
    }
}

static inline void vn_replace_vkGetPhysicalDeviceQueueFamilyProperties2_args_handle(struct vn_command_vkGetPhysicalDeviceQueueFamilyProperties2 *args)
{
    vn_replace_VkPhysicalDevice_handle(&args->physicalDevice);
    /* skip args->pQueueFamilyPropertyCount */
    /* skip args->pQueueFamilyProperties */
}

static inline void vn_encode_vkGetPhysicalDeviceQueueFamilyProperties2_reply(struct vn_cs_encoder *enc, const struct vn_command_vkGetPhysicalDeviceQueueFamilyProperties2 *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkGetPhysicalDeviceQueueFamilyProperties2_EXT});

    /* skip args->physicalDevice */
    if (vn_encode_simple_pointer(enc, args->pQueueFamilyPropertyCount))
        vn_encode_uint32_t(enc, args->pQueueFamilyPropertyCount);
    if (args->pQueueFamilyProperties) {
        vn_encode_array_size(enc, (args->pQueueFamilyPropertyCount ? *args->pQueueFamilyPropertyCount : 0));
        for (uint32_t i = 0; i < (args->pQueueFamilyPropertyCount ? *args->pQueueFamilyPropertyCount : 0); i++)
            vn_encode_VkQueueFamilyProperties2(enc, &args->pQueueFamilyProperties[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void vn_decode_vkGetPhysicalDeviceMemoryProperties2_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkGetPhysicalDeviceMemoryProperties2 *args)
{
    vn_decode_VkPhysicalDevice_lookup(dec, &args->physicalDevice);
    if (vn_decode_simple_pointer(dec)) {
        args->pMemoryProperties = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pMemoryProperties));
        if (!args->pMemoryProperties) return;
        vn_decode_VkPhysicalDeviceMemoryProperties2_partial_temp(dec, args->pMemoryProperties);
    } else {
        args->pMemoryProperties = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
}

static inline void vn_replace_vkGetPhysicalDeviceMemoryProperties2_args_handle(struct vn_command_vkGetPhysicalDeviceMemoryProperties2 *args)
{
    vn_replace_VkPhysicalDevice_handle(&args->physicalDevice);
    /* skip args->pMemoryProperties */
}

static inline void vn_encode_vkGetPhysicalDeviceMemoryProperties2_reply(struct vn_cs_encoder *enc, const struct vn_command_vkGetPhysicalDeviceMemoryProperties2 *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkGetPhysicalDeviceMemoryProperties2_EXT});

    /* skip args->physicalDevice */
    if (vn_encode_simple_pointer(enc, args->pMemoryProperties))
        vn_encode_VkPhysicalDeviceMemoryProperties2(enc, args->pMemoryProperties);
}

static inline void vn_decode_vkGetPhysicalDeviceSparseImageFormatProperties2_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkGetPhysicalDeviceSparseImageFormatProperties2 *args)
{
    vn_decode_VkPhysicalDevice_lookup(dec, &args->physicalDevice);
    if (vn_decode_simple_pointer(dec)) {
        args->pFormatInfo = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pFormatInfo));
        if (!args->pFormatInfo) return;
        vn_decode_VkPhysicalDeviceSparseImageFormatInfo2_temp(dec, (VkPhysicalDeviceSparseImageFormatInfo2 *)args->pFormatInfo);
    } else {
        args->pFormatInfo = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
    if (vn_decode_simple_pointer(dec)) {
        args->pPropertyCount = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pPropertyCount));
        if (!args->pPropertyCount) return;
        vn_decode_uint32_t(dec, args->pPropertyCount);
    } else {
        args->pPropertyCount = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, (args->pPropertyCount ? *args->pPropertyCount : 0));
        args->pProperties = vn_cs_decoder_alloc_temp_array(dec, sizeof(*args->pProperties), iter_count);
        if (!args->pProperties) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkSparseImageFormatProperties2_partial_temp(dec, &args->pProperties[i]);
    } else {
        vn_decode_array_size_unchecked(dec);
        args->pProperties = NULL;
    }
}

static inline void vn_replace_vkGetPhysicalDeviceSparseImageFormatProperties2_args_handle(struct vn_command_vkGetPhysicalDeviceSparseImageFormatProperties2 *args)
{
    vn_replace_VkPhysicalDevice_handle(&args->physicalDevice);
    if (args->pFormatInfo)
        vn_replace_VkPhysicalDeviceSparseImageFormatInfo2_handle((VkPhysicalDeviceSparseImageFormatInfo2 *)args->pFormatInfo);
    /* skip args->pPropertyCount */
    /* skip args->pProperties */
}

static inline void vn_encode_vkGetPhysicalDeviceSparseImageFormatProperties2_reply(struct vn_cs_encoder *enc, const struct vn_command_vkGetPhysicalDeviceSparseImageFormatProperties2 *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkGetPhysicalDeviceSparseImageFormatProperties2_EXT});

    /* skip args->physicalDevice */
    /* skip args->pFormatInfo */
    if (vn_encode_simple_pointer(enc, args->pPropertyCount))
        vn_encode_uint32_t(enc, args->pPropertyCount);
    if (args->pProperties) {
        vn_encode_array_size(enc, (args->pPropertyCount ? *args->pPropertyCount : 0));
        for (uint32_t i = 0; i < (args->pPropertyCount ? *args->pPropertyCount : 0); i++)
            vn_encode_VkSparseImageFormatProperties2(enc, &args->pProperties[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void vn_decode_vkGetPhysicalDeviceExternalBufferProperties_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkGetPhysicalDeviceExternalBufferProperties *args)
{
    vn_decode_VkPhysicalDevice_lookup(dec, &args->physicalDevice);
    if (vn_decode_simple_pointer(dec)) {
        args->pExternalBufferInfo = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pExternalBufferInfo));
        if (!args->pExternalBufferInfo) return;
        vn_decode_VkPhysicalDeviceExternalBufferInfo_temp(dec, (VkPhysicalDeviceExternalBufferInfo *)args->pExternalBufferInfo);
    } else {
        args->pExternalBufferInfo = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
    if (vn_decode_simple_pointer(dec)) {
        args->pExternalBufferProperties = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pExternalBufferProperties));
        if (!args->pExternalBufferProperties) return;
        vn_decode_VkExternalBufferProperties_partial_temp(dec, args->pExternalBufferProperties);
    } else {
        args->pExternalBufferProperties = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
}

static inline void vn_replace_vkGetPhysicalDeviceExternalBufferProperties_args_handle(struct vn_command_vkGetPhysicalDeviceExternalBufferProperties *args)
{
    vn_replace_VkPhysicalDevice_handle(&args->physicalDevice);
    if (args->pExternalBufferInfo)
        vn_replace_VkPhysicalDeviceExternalBufferInfo_handle((VkPhysicalDeviceExternalBufferInfo *)args->pExternalBufferInfo);
    /* skip args->pExternalBufferProperties */
}

static inline void vn_encode_vkGetPhysicalDeviceExternalBufferProperties_reply(struct vn_cs_encoder *enc, const struct vn_command_vkGetPhysicalDeviceExternalBufferProperties *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkGetPhysicalDeviceExternalBufferProperties_EXT});

    /* skip args->physicalDevice */
    /* skip args->pExternalBufferInfo */
    if (vn_encode_simple_pointer(enc, args->pExternalBufferProperties))
        vn_encode_VkExternalBufferProperties(enc, args->pExternalBufferProperties);
}

static inline void vn_decode_vkGetPhysicalDeviceExternalSemaphoreProperties_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkGetPhysicalDeviceExternalSemaphoreProperties *args)
{
    vn_decode_VkPhysicalDevice_lookup(dec, &args->physicalDevice);
    if (vn_decode_simple_pointer(dec)) {
        args->pExternalSemaphoreInfo = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pExternalSemaphoreInfo));
        if (!args->pExternalSemaphoreInfo) return;
        vn_decode_VkPhysicalDeviceExternalSemaphoreInfo_temp(dec, (VkPhysicalDeviceExternalSemaphoreInfo *)args->pExternalSemaphoreInfo);
    } else {
        args->pExternalSemaphoreInfo = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
    if (vn_decode_simple_pointer(dec)) {
        args->pExternalSemaphoreProperties = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pExternalSemaphoreProperties));
        if (!args->pExternalSemaphoreProperties) return;
        vn_decode_VkExternalSemaphoreProperties_partial_temp(dec, args->pExternalSemaphoreProperties);
    } else {
        args->pExternalSemaphoreProperties = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
}

static inline void vn_replace_vkGetPhysicalDeviceExternalSemaphoreProperties_args_handle(struct vn_command_vkGetPhysicalDeviceExternalSemaphoreProperties *args)
{
    vn_replace_VkPhysicalDevice_handle(&args->physicalDevice);
    if (args->pExternalSemaphoreInfo)
        vn_replace_VkPhysicalDeviceExternalSemaphoreInfo_handle((VkPhysicalDeviceExternalSemaphoreInfo *)args->pExternalSemaphoreInfo);
    /* skip args->pExternalSemaphoreProperties */
}

static inline void vn_encode_vkGetPhysicalDeviceExternalSemaphoreProperties_reply(struct vn_cs_encoder *enc, const struct vn_command_vkGetPhysicalDeviceExternalSemaphoreProperties *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkGetPhysicalDeviceExternalSemaphoreProperties_EXT});

    /* skip args->physicalDevice */
    /* skip args->pExternalSemaphoreInfo */
    if (vn_encode_simple_pointer(enc, args->pExternalSemaphoreProperties))
        vn_encode_VkExternalSemaphoreProperties(enc, args->pExternalSemaphoreProperties);
}

static inline void vn_decode_vkGetPhysicalDeviceExternalFenceProperties_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkGetPhysicalDeviceExternalFenceProperties *args)
{
    vn_decode_VkPhysicalDevice_lookup(dec, &args->physicalDevice);
    if (vn_decode_simple_pointer(dec)) {
        args->pExternalFenceInfo = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pExternalFenceInfo));
        if (!args->pExternalFenceInfo) return;
        vn_decode_VkPhysicalDeviceExternalFenceInfo_temp(dec, (VkPhysicalDeviceExternalFenceInfo *)args->pExternalFenceInfo);
    } else {
        args->pExternalFenceInfo = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
    if (vn_decode_simple_pointer(dec)) {
        args->pExternalFenceProperties = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pExternalFenceProperties));
        if (!args->pExternalFenceProperties) return;
        vn_decode_VkExternalFenceProperties_partial_temp(dec, args->pExternalFenceProperties);
    } else {
        args->pExternalFenceProperties = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
}

static inline void vn_replace_vkGetPhysicalDeviceExternalFenceProperties_args_handle(struct vn_command_vkGetPhysicalDeviceExternalFenceProperties *args)
{
    vn_replace_VkPhysicalDevice_handle(&args->physicalDevice);
    if (args->pExternalFenceInfo)
        vn_replace_VkPhysicalDeviceExternalFenceInfo_handle((VkPhysicalDeviceExternalFenceInfo *)args->pExternalFenceInfo);
    /* skip args->pExternalFenceProperties */
}

static inline void vn_encode_vkGetPhysicalDeviceExternalFenceProperties_reply(struct vn_cs_encoder *enc, const struct vn_command_vkGetPhysicalDeviceExternalFenceProperties *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkGetPhysicalDeviceExternalFenceProperties_EXT});

    /* skip args->physicalDevice */
    /* skip args->pExternalFenceInfo */
    if (vn_encode_simple_pointer(enc, args->pExternalFenceProperties))
        vn_encode_VkExternalFenceProperties(enc, args->pExternalFenceProperties);
}

static inline void vn_decode_vkEnumeratePhysicalDeviceGroups_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkEnumeratePhysicalDeviceGroups *args)
{
    vn_decode_VkInstance_lookup(dec, &args->instance);
    if (vn_decode_simple_pointer(dec)) {
        args->pPhysicalDeviceGroupCount = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pPhysicalDeviceGroupCount));
        if (!args->pPhysicalDeviceGroupCount) return;
        vn_decode_uint32_t(dec, args->pPhysicalDeviceGroupCount);
    } else {
        args->pPhysicalDeviceGroupCount = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, (args->pPhysicalDeviceGroupCount ? *args->pPhysicalDeviceGroupCount : 0));
        args->pPhysicalDeviceGroupProperties = vn_cs_decoder_alloc_temp_array(dec, sizeof(*args->pPhysicalDeviceGroupProperties), iter_count);
        if (!args->pPhysicalDeviceGroupProperties) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkPhysicalDeviceGroupProperties_partial_temp(dec, &args->pPhysicalDeviceGroupProperties[i]);
    } else {
        vn_decode_array_size_unchecked(dec);
        args->pPhysicalDeviceGroupProperties = NULL;
    }
}

static inline void vn_replace_vkEnumeratePhysicalDeviceGroups_args_handle(struct vn_command_vkEnumeratePhysicalDeviceGroups *args)
{
    vn_replace_VkInstance_handle(&args->instance);
    /* skip args->pPhysicalDeviceGroupCount */
    /* skip args->pPhysicalDeviceGroupProperties */
}

static inline void vn_encode_vkEnumeratePhysicalDeviceGroups_reply(struct vn_cs_encoder *enc, const struct vn_command_vkEnumeratePhysicalDeviceGroups *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkEnumeratePhysicalDeviceGroups_EXT});

    vn_encode_VkResult(enc, &args->ret);
    /* skip args->instance */
    if (vn_encode_simple_pointer(enc, args->pPhysicalDeviceGroupCount))
        vn_encode_uint32_t(enc, args->pPhysicalDeviceGroupCount);
    if (args->pPhysicalDeviceGroupProperties) {
        vn_encode_array_size(enc, (args->pPhysicalDeviceGroupCount ? *args->pPhysicalDeviceGroupCount : 0));
        for (uint32_t i = 0; i < (args->pPhysicalDeviceGroupCount ? *args->pPhysicalDeviceGroupCount : 0); i++)
            vn_encode_VkPhysicalDeviceGroupProperties(enc, &args->pPhysicalDeviceGroupProperties[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void vn_decode_vkGetDeviceGroupPeerMemoryFeatures_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkGetDeviceGroupPeerMemoryFeatures *args)
{
    vn_decode_VkDevice_lookup(dec, &args->device);
    vn_decode_uint32_t(dec, &args->heapIndex);
    vn_decode_uint32_t(dec, &args->localDeviceIndex);
    vn_decode_uint32_t(dec, &args->remoteDeviceIndex);
    if (vn_decode_simple_pointer(dec)) {
        args->pPeerMemoryFeatures = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pPeerMemoryFeatures));
        if (!args->pPeerMemoryFeatures) return;
    } else {
        args->pPeerMemoryFeatures = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
}

static inline void vn_replace_vkGetDeviceGroupPeerMemoryFeatures_args_handle(struct vn_command_vkGetDeviceGroupPeerMemoryFeatures *args)
{
    vn_replace_VkDevice_handle(&args->device);
    /* skip args->heapIndex */
    /* skip args->localDeviceIndex */
    /* skip args->remoteDeviceIndex */
    /* skip args->pPeerMemoryFeatures */
}

static inline void vn_encode_vkGetDeviceGroupPeerMemoryFeatures_reply(struct vn_cs_encoder *enc, const struct vn_command_vkGetDeviceGroupPeerMemoryFeatures *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkGetDeviceGroupPeerMemoryFeatures_EXT});

    /* skip args->device */
    /* skip args->heapIndex */
    /* skip args->localDeviceIndex */
    /* skip args->remoteDeviceIndex */
    if (vn_encode_simple_pointer(enc, args->pPeerMemoryFeatures))
        vn_encode_VkFlags(enc, args->pPeerMemoryFeatures);
}

static inline void vn_decode_vkGetDeviceQueue2_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkGetDeviceQueue2 *args)
{
    vn_decode_VkDevice_lookup(dec, &args->device);
    if (vn_decode_simple_pointer(dec)) {
        args->pQueueInfo = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pQueueInfo));
        if (!args->pQueueInfo) return;
        vn_decode_VkDeviceQueueInfo2_temp(dec, (VkDeviceQueueInfo2 *)args->pQueueInfo);
    } else {
        args->pQueueInfo = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
    if (vn_decode_simple_pointer(dec)) {
        args->pQueue = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pQueue));
        if (!args->pQueue) return;
        vn_decode_VkQueue_temp(dec, args->pQueue);
    } else {
        args->pQueue = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
}

static inline void vn_replace_vkGetDeviceQueue2_args_handle(struct vn_command_vkGetDeviceQueue2 *args)
{
    vn_replace_VkDevice_handle(&args->device);
    if (args->pQueueInfo)
        vn_replace_VkDeviceQueueInfo2_handle((VkDeviceQueueInfo2 *)args->pQueueInfo);
    /* skip args->pQueue */
}

static inline void vn_encode_vkGetDeviceQueue2_reply(struct vn_cs_encoder *enc, const struct vn_command_vkGetDeviceQueue2 *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkGetDeviceQueue2_EXT});

    /* skip args->device */
    /* skip args->pQueueInfo */
    if (vn_encode_simple_pointer(enc, args->pQueue))
        vn_encode_VkQueue(enc, args->pQueue);
}

static inline void vn_decode_vkGetPhysicalDeviceCalibrateableTimeDomainsEXT_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkGetPhysicalDeviceCalibrateableTimeDomainsEXT *args)
{
    vn_decode_VkPhysicalDevice_lookup(dec, &args->physicalDevice);
    if (vn_decode_simple_pointer(dec)) {
        args->pTimeDomainCount = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pTimeDomainCount));
        if (!args->pTimeDomainCount) return;
        vn_decode_uint32_t(dec, args->pTimeDomainCount);
    } else {
        args->pTimeDomainCount = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
    if (vn_peek_array_size(dec)) {
        const size_t array_size = vn_decode_array_size(dec, (args->pTimeDomainCount ? *args->pTimeDomainCount : 0));
        args->pTimeDomains = vn_cs_decoder_alloc_temp_array(dec, sizeof(*args->pTimeDomains), array_size);
        if (!args->pTimeDomains) return;
    } else {
        vn_decode_array_size_unchecked(dec);
        args->pTimeDomains = NULL;
    }
}

static inline void vn_replace_vkGetPhysicalDeviceCalibrateableTimeDomainsEXT_args_handle(struct vn_command_vkGetPhysicalDeviceCalibrateableTimeDomainsEXT *args)
{
    vn_replace_VkPhysicalDevice_handle(&args->physicalDevice);
    /* skip args->pTimeDomainCount */
    /* skip args->pTimeDomains */
}

static inline void vn_encode_vkGetPhysicalDeviceCalibrateableTimeDomainsEXT_reply(struct vn_cs_encoder *enc, const struct vn_command_vkGetPhysicalDeviceCalibrateableTimeDomainsEXT *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkGetPhysicalDeviceCalibrateableTimeDomainsEXT_EXT});

    vn_encode_VkResult(enc, &args->ret);
    /* skip args->physicalDevice */
    if (vn_encode_simple_pointer(enc, args->pTimeDomainCount))
        vn_encode_uint32_t(enc, args->pTimeDomainCount);
    if (args->pTimeDomains) {
        vn_encode_array_size(enc, (args->pTimeDomainCount ? *args->pTimeDomainCount : 0));
        vn_encode_VkTimeDomainEXT_array(enc, args->pTimeDomains, (args->pTimeDomainCount ? *args->pTimeDomainCount : 0));
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void vn_decode_vkGetCalibratedTimestampsEXT_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkGetCalibratedTimestampsEXT *args)
{
    vn_decode_VkDevice_lookup(dec, &args->device);
    vn_decode_uint32_t(dec, &args->timestampCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, args->timestampCount);
        args->pTimestampInfos = vn_cs_decoder_alloc_temp_array(dec, sizeof(*args->pTimestampInfos), iter_count);
        if (!args->pTimestampInfos) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkCalibratedTimestampInfoEXT_temp(dec, &((VkCalibratedTimestampInfoEXT *)args->pTimestampInfos)[i]);
    } else {
        vn_decode_array_size(dec, args->timestampCount);
        args->pTimestampInfos = NULL;
    }
    if (vn_peek_array_size(dec)) {
        const size_t array_size = vn_decode_array_size(dec, args->timestampCount);
        args->pTimestamps = vn_cs_decoder_alloc_temp_array(dec, sizeof(*args->pTimestamps), array_size);
        if (!args->pTimestamps) return;
    } else {
        vn_decode_array_size(dec, args->timestampCount);
        args->pTimestamps = NULL;
    }
    if (vn_decode_simple_pointer(dec)) {
        args->pMaxDeviation = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pMaxDeviation));
        if (!args->pMaxDeviation) return;
    } else {
        args->pMaxDeviation = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
}

static inline void vn_replace_vkGetCalibratedTimestampsEXT_args_handle(struct vn_command_vkGetCalibratedTimestampsEXT *args)
{
    vn_replace_VkDevice_handle(&args->device);
    /* skip args->timestampCount */
    if (args->pTimestampInfos) {
       for (uint32_t i = 0; i < args->timestampCount; i++)
            vn_replace_VkCalibratedTimestampInfoEXT_handle(&((VkCalibratedTimestampInfoEXT *)args->pTimestampInfos)[i]);
    }
    /* skip args->pTimestamps */
    /* skip args->pMaxDeviation */
}

static inline void vn_encode_vkGetCalibratedTimestampsEXT_reply(struct vn_cs_encoder *enc, const struct vn_command_vkGetCalibratedTimestampsEXT *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkGetCalibratedTimestampsEXT_EXT});

    vn_encode_VkResult(enc, &args->ret);
    /* skip args->device */
    /* skip args->timestampCount */
    /* skip args->pTimestampInfos */
    if (args->pTimestamps) {
        vn_encode_array_size(enc, args->timestampCount);
        vn_encode_uint64_t_array(enc, args->pTimestamps, args->timestampCount);
    } else {
        vn_encode_array_size(enc, 0);
    }
    if (vn_encode_simple_pointer(enc, args->pMaxDeviation))
        vn_encode_uint64_t(enc, args->pMaxDeviation);
}

static inline void vn_decode_vkGetPhysicalDeviceToolProperties_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkGetPhysicalDeviceToolProperties *args)
{
    vn_decode_VkPhysicalDevice_lookup(dec, &args->physicalDevice);
    if (vn_decode_simple_pointer(dec)) {
        args->pToolCount = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pToolCount));
        if (!args->pToolCount) return;
        vn_decode_uint32_t(dec, args->pToolCount);
    } else {
        args->pToolCount = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, (args->pToolCount ? *args->pToolCount : 0));
        args->pToolProperties = vn_cs_decoder_alloc_temp_array(dec, sizeof(*args->pToolProperties), iter_count);
        if (!args->pToolProperties) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkPhysicalDeviceToolProperties_partial_temp(dec, &args->pToolProperties[i]);
    } else {
        vn_decode_array_size_unchecked(dec);
        args->pToolProperties = NULL;
    }
}

static inline void vn_replace_vkGetPhysicalDeviceToolProperties_args_handle(struct vn_command_vkGetPhysicalDeviceToolProperties *args)
{
    vn_replace_VkPhysicalDevice_handle(&args->physicalDevice);
    /* skip args->pToolCount */
    /* skip args->pToolProperties */
}

static inline void vn_encode_vkGetPhysicalDeviceToolProperties_reply(struct vn_cs_encoder *enc, const struct vn_command_vkGetPhysicalDeviceToolProperties *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkGetPhysicalDeviceToolProperties_EXT});

    vn_encode_VkResult(enc, &args->ret);
    /* skip args->physicalDevice */
    if (vn_encode_simple_pointer(enc, args->pToolCount))
        vn_encode_uint32_t(enc, args->pToolCount);
    if (args->pToolProperties) {
        vn_encode_array_size(enc, (args->pToolCount ? *args->pToolCount : 0));
        for (uint32_t i = 0; i < (args->pToolCount ? *args->pToolCount : 0); i++)
            vn_encode_VkPhysicalDeviceToolProperties(enc, &args->pToolProperties[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void vn_dispatch_vkEnumeratePhysicalDevices(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkEnumeratePhysicalDevices args;

    if (!ctx->dispatch_vkEnumeratePhysicalDevices) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkEnumeratePhysicalDevices_args_temp(ctx->decoder, &args);
    if (!args.instance) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkEnumeratePhysicalDevices(ctx, &args);

#ifdef DEBUG
    if (!vn_cs_decoder_get_fatal(ctx->decoder) && vn_dispatch_should_log_result(args.ret))
        vn_dispatch_debug_log(ctx, "vkEnumeratePhysicalDevices returned %d", args.ret);
#endif

    if ((flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT) && !vn_cs_decoder_get_fatal(ctx->decoder))
        vn_encode_vkEnumeratePhysicalDevices_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkGetPhysicalDeviceProperties(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkGetPhysicalDeviceProperties args;

    if (!ctx->dispatch_vkGetPhysicalDeviceProperties) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkGetPhysicalDeviceProperties_args_temp(ctx->decoder, &args);
    if (!args.physicalDevice) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkGetPhysicalDeviceProperties(ctx, &args);

    if ((flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT) && !vn_cs_decoder_get_fatal(ctx->decoder))
        vn_encode_vkGetPhysicalDeviceProperties_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkGetPhysicalDeviceQueueFamilyProperties(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkGetPhysicalDeviceQueueFamilyProperties args;

    if (!ctx->dispatch_vkGetPhysicalDeviceQueueFamilyProperties) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkGetPhysicalDeviceQueueFamilyProperties_args_temp(ctx->decoder, &args);
    if (!args.physicalDevice) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkGetPhysicalDeviceQueueFamilyProperties(ctx, &args);

    if ((flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT) && !vn_cs_decoder_get_fatal(ctx->decoder))
        vn_encode_vkGetPhysicalDeviceQueueFamilyProperties_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkGetPhysicalDeviceMemoryProperties(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkGetPhysicalDeviceMemoryProperties args;

    if (!ctx->dispatch_vkGetPhysicalDeviceMemoryProperties) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkGetPhysicalDeviceMemoryProperties_args_temp(ctx->decoder, &args);
    if (!args.physicalDevice) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkGetPhysicalDeviceMemoryProperties(ctx, &args);

    if ((flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT) && !vn_cs_decoder_get_fatal(ctx->decoder))
        vn_encode_vkGetPhysicalDeviceMemoryProperties_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkGetPhysicalDeviceFeatures(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkGetPhysicalDeviceFeatures args;

    if (!ctx->dispatch_vkGetPhysicalDeviceFeatures) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkGetPhysicalDeviceFeatures_args_temp(ctx->decoder, &args);
    if (!args.physicalDevice) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkGetPhysicalDeviceFeatures(ctx, &args);

    if ((flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT) && !vn_cs_decoder_get_fatal(ctx->decoder))
        vn_encode_vkGetPhysicalDeviceFeatures_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkGetPhysicalDeviceFormatProperties(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkGetPhysicalDeviceFormatProperties args;

    if (!ctx->dispatch_vkGetPhysicalDeviceFormatProperties) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkGetPhysicalDeviceFormatProperties_args_temp(ctx->decoder, &args);
    if (!args.physicalDevice) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkGetPhysicalDeviceFormatProperties(ctx, &args);

    if ((flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT) && !vn_cs_decoder_get_fatal(ctx->decoder))
        vn_encode_vkGetPhysicalDeviceFormatProperties_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkGetPhysicalDeviceImageFormatProperties(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkGetPhysicalDeviceImageFormatProperties args;

    if (!ctx->dispatch_vkGetPhysicalDeviceImageFormatProperties) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkGetPhysicalDeviceImageFormatProperties_args_temp(ctx->decoder, &args);
    if (!args.physicalDevice) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkGetPhysicalDeviceImageFormatProperties(ctx, &args);

#ifdef DEBUG
    if (!vn_cs_decoder_get_fatal(ctx->decoder) && vn_dispatch_should_log_result(args.ret))
        vn_dispatch_debug_log(ctx, "vkGetPhysicalDeviceImageFormatProperties returned %d", args.ret);
#endif

    if ((flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT) && !vn_cs_decoder_get_fatal(ctx->decoder))
        vn_encode_vkGetPhysicalDeviceImageFormatProperties_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCreateDevice(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCreateDevice args;

    if (!ctx->dispatch_vkCreateDevice) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCreateDevice_args_temp(ctx->decoder, &args);
    if (!args.physicalDevice) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCreateDevice(ctx, &args);

#ifdef DEBUG
    if (!vn_cs_decoder_get_fatal(ctx->decoder) && vn_dispatch_should_log_result(args.ret))
        vn_dispatch_debug_log(ctx, "vkCreateDevice returned %d", args.ret);
#endif

    if (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT) {
        if (!vn_cs_decoder_get_fatal(ctx->decoder))
            vn_encode_vkCreateDevice_reply(ctx->encoder, &args);
    } else if (args.ret == VK_ERROR_DEVICE_LOST) {
        vn_cs_decoder_set_fatal(ctx->decoder);
    }

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkDestroyDevice(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkDestroyDevice args;

    if (!ctx->dispatch_vkDestroyDevice) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkDestroyDevice_args_temp(ctx->decoder, &args);
    if (!args.device) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkDestroyDevice(ctx, &args);

    if ((flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT) && !vn_cs_decoder_get_fatal(ctx->decoder))
        vn_encode_vkDestroyDevice_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkEnumerateDeviceLayerProperties(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkEnumerateDeviceLayerProperties args;

    if (!ctx->dispatch_vkEnumerateDeviceLayerProperties) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkEnumerateDeviceLayerProperties_args_temp(ctx->decoder, &args);
    if (!args.physicalDevice) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkEnumerateDeviceLayerProperties(ctx, &args);

#ifdef DEBUG
    if (!vn_cs_decoder_get_fatal(ctx->decoder) && vn_dispatch_should_log_result(args.ret))
        vn_dispatch_debug_log(ctx, "vkEnumerateDeviceLayerProperties returned %d", args.ret);
#endif

    if ((flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT) && !vn_cs_decoder_get_fatal(ctx->decoder))
        vn_encode_vkEnumerateDeviceLayerProperties_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkEnumerateDeviceExtensionProperties(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkEnumerateDeviceExtensionProperties args;

    if (!ctx->dispatch_vkEnumerateDeviceExtensionProperties) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkEnumerateDeviceExtensionProperties_args_temp(ctx->decoder, &args);
    if (!args.physicalDevice) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkEnumerateDeviceExtensionProperties(ctx, &args);

#ifdef DEBUG
    if (!vn_cs_decoder_get_fatal(ctx->decoder) && vn_dispatch_should_log_result(args.ret))
        vn_dispatch_debug_log(ctx, "vkEnumerateDeviceExtensionProperties returned %d", args.ret);
#endif

    if ((flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT) && !vn_cs_decoder_get_fatal(ctx->decoder))
        vn_encode_vkEnumerateDeviceExtensionProperties_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkGetDeviceQueue(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkGetDeviceQueue args;

    if (!ctx->dispatch_vkGetDeviceQueue) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkGetDeviceQueue_args_temp(ctx->decoder, &args);
    if (!args.device) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkGetDeviceQueue(ctx, &args);

    if ((flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT) && !vn_cs_decoder_get_fatal(ctx->decoder))
        vn_encode_vkGetDeviceQueue_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkDeviceWaitIdle(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkDeviceWaitIdle args;

    if (!ctx->dispatch_vkDeviceWaitIdle) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkDeviceWaitIdle_args_temp(ctx->decoder, &args);
    if (!args.device) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkDeviceWaitIdle(ctx, &args);

#ifdef DEBUG
    if (!vn_cs_decoder_get_fatal(ctx->decoder) && vn_dispatch_should_log_result(args.ret))
        vn_dispatch_debug_log(ctx, "vkDeviceWaitIdle returned %d", args.ret);
#endif

    if (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT) {
        if (!vn_cs_decoder_get_fatal(ctx->decoder))
            vn_encode_vkDeviceWaitIdle_reply(ctx->encoder, &args);
    } else if (args.ret == VK_ERROR_DEVICE_LOST) {
        vn_cs_decoder_set_fatal(ctx->decoder);
    }

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkGetPhysicalDeviceSparseImageFormatProperties(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkGetPhysicalDeviceSparseImageFormatProperties args;

    if (!ctx->dispatch_vkGetPhysicalDeviceSparseImageFormatProperties) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkGetPhysicalDeviceSparseImageFormatProperties_args_temp(ctx->decoder, &args);
    if (!args.physicalDevice) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkGetPhysicalDeviceSparseImageFormatProperties(ctx, &args);

    if ((flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT) && !vn_cs_decoder_get_fatal(ctx->decoder))
        vn_encode_vkGetPhysicalDeviceSparseImageFormatProperties_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkGetPhysicalDeviceFeatures2(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkGetPhysicalDeviceFeatures2 args;

    if (!ctx->dispatch_vkGetPhysicalDeviceFeatures2) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkGetPhysicalDeviceFeatures2_args_temp(ctx->decoder, &args);
    if (!args.physicalDevice) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkGetPhysicalDeviceFeatures2(ctx, &args);

    if ((flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT) && !vn_cs_decoder_get_fatal(ctx->decoder))
        vn_encode_vkGetPhysicalDeviceFeatures2_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkGetPhysicalDeviceProperties2(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkGetPhysicalDeviceProperties2 args;

    if (!ctx->dispatch_vkGetPhysicalDeviceProperties2) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkGetPhysicalDeviceProperties2_args_temp(ctx->decoder, &args);
    if (!args.physicalDevice) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkGetPhysicalDeviceProperties2(ctx, &args);

    if ((flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT) && !vn_cs_decoder_get_fatal(ctx->decoder))
        vn_encode_vkGetPhysicalDeviceProperties2_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkGetPhysicalDeviceFormatProperties2(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkGetPhysicalDeviceFormatProperties2 args;

    if (!ctx->dispatch_vkGetPhysicalDeviceFormatProperties2) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkGetPhysicalDeviceFormatProperties2_args_temp(ctx->decoder, &args);
    if (!args.physicalDevice) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkGetPhysicalDeviceFormatProperties2(ctx, &args);

    if ((flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT) && !vn_cs_decoder_get_fatal(ctx->decoder))
        vn_encode_vkGetPhysicalDeviceFormatProperties2_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkGetPhysicalDeviceImageFormatProperties2(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkGetPhysicalDeviceImageFormatProperties2 args;

    if (!ctx->dispatch_vkGetPhysicalDeviceImageFormatProperties2) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkGetPhysicalDeviceImageFormatProperties2_args_temp(ctx->decoder, &args);
    if (!args.physicalDevice) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkGetPhysicalDeviceImageFormatProperties2(ctx, &args);

#ifdef DEBUG
    if (!vn_cs_decoder_get_fatal(ctx->decoder) && vn_dispatch_should_log_result(args.ret))
        vn_dispatch_debug_log(ctx, "vkGetPhysicalDeviceImageFormatProperties2 returned %d", args.ret);
#endif

    if ((flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT) && !vn_cs_decoder_get_fatal(ctx->decoder))
        vn_encode_vkGetPhysicalDeviceImageFormatProperties2_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkGetPhysicalDeviceQueueFamilyProperties2(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkGetPhysicalDeviceQueueFamilyProperties2 args;

    if (!ctx->dispatch_vkGetPhysicalDeviceQueueFamilyProperties2) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkGetPhysicalDeviceQueueFamilyProperties2_args_temp(ctx->decoder, &args);
    if (!args.physicalDevice) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkGetPhysicalDeviceQueueFamilyProperties2(ctx, &args);

    if ((flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT) && !vn_cs_decoder_get_fatal(ctx->decoder))
        vn_encode_vkGetPhysicalDeviceQueueFamilyProperties2_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkGetPhysicalDeviceMemoryProperties2(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkGetPhysicalDeviceMemoryProperties2 args;

    if (!ctx->dispatch_vkGetPhysicalDeviceMemoryProperties2) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkGetPhysicalDeviceMemoryProperties2_args_temp(ctx->decoder, &args);
    if (!args.physicalDevice) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkGetPhysicalDeviceMemoryProperties2(ctx, &args);

    if ((flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT) && !vn_cs_decoder_get_fatal(ctx->decoder))
        vn_encode_vkGetPhysicalDeviceMemoryProperties2_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkGetPhysicalDeviceSparseImageFormatProperties2(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkGetPhysicalDeviceSparseImageFormatProperties2 args;

    if (!ctx->dispatch_vkGetPhysicalDeviceSparseImageFormatProperties2) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkGetPhysicalDeviceSparseImageFormatProperties2_args_temp(ctx->decoder, &args);
    if (!args.physicalDevice) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkGetPhysicalDeviceSparseImageFormatProperties2(ctx, &args);

    if ((flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT) && !vn_cs_decoder_get_fatal(ctx->decoder))
        vn_encode_vkGetPhysicalDeviceSparseImageFormatProperties2_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkGetPhysicalDeviceExternalBufferProperties(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkGetPhysicalDeviceExternalBufferProperties args;

    if (!ctx->dispatch_vkGetPhysicalDeviceExternalBufferProperties) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkGetPhysicalDeviceExternalBufferProperties_args_temp(ctx->decoder, &args);
    if (!args.physicalDevice) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkGetPhysicalDeviceExternalBufferProperties(ctx, &args);

    if ((flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT) && !vn_cs_decoder_get_fatal(ctx->decoder))
        vn_encode_vkGetPhysicalDeviceExternalBufferProperties_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkGetPhysicalDeviceExternalSemaphoreProperties(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkGetPhysicalDeviceExternalSemaphoreProperties args;

    if (!ctx->dispatch_vkGetPhysicalDeviceExternalSemaphoreProperties) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkGetPhysicalDeviceExternalSemaphoreProperties_args_temp(ctx->decoder, &args);
    if (!args.physicalDevice) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkGetPhysicalDeviceExternalSemaphoreProperties(ctx, &args);

    if ((flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT) && !vn_cs_decoder_get_fatal(ctx->decoder))
        vn_encode_vkGetPhysicalDeviceExternalSemaphoreProperties_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkGetPhysicalDeviceExternalFenceProperties(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkGetPhysicalDeviceExternalFenceProperties args;

    if (!ctx->dispatch_vkGetPhysicalDeviceExternalFenceProperties) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkGetPhysicalDeviceExternalFenceProperties_args_temp(ctx->decoder, &args);
    if (!args.physicalDevice) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkGetPhysicalDeviceExternalFenceProperties(ctx, &args);

    if ((flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT) && !vn_cs_decoder_get_fatal(ctx->decoder))
        vn_encode_vkGetPhysicalDeviceExternalFenceProperties_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkEnumeratePhysicalDeviceGroups(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkEnumeratePhysicalDeviceGroups args;

    if (!ctx->dispatch_vkEnumeratePhysicalDeviceGroups) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkEnumeratePhysicalDeviceGroups_args_temp(ctx->decoder, &args);
    if (!args.instance) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkEnumeratePhysicalDeviceGroups(ctx, &args);

#ifdef DEBUG
    if (!vn_cs_decoder_get_fatal(ctx->decoder) && vn_dispatch_should_log_result(args.ret))
        vn_dispatch_debug_log(ctx, "vkEnumeratePhysicalDeviceGroups returned %d", args.ret);
#endif

    if ((flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT) && !vn_cs_decoder_get_fatal(ctx->decoder))
        vn_encode_vkEnumeratePhysicalDeviceGroups_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkGetDeviceGroupPeerMemoryFeatures(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkGetDeviceGroupPeerMemoryFeatures args;

    if (!ctx->dispatch_vkGetDeviceGroupPeerMemoryFeatures) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkGetDeviceGroupPeerMemoryFeatures_args_temp(ctx->decoder, &args);
    if (!args.device) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkGetDeviceGroupPeerMemoryFeatures(ctx, &args);

    if ((flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT) && !vn_cs_decoder_get_fatal(ctx->decoder))
        vn_encode_vkGetDeviceGroupPeerMemoryFeatures_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkGetDeviceQueue2(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkGetDeviceQueue2 args;

    if (!ctx->dispatch_vkGetDeviceQueue2) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkGetDeviceQueue2_args_temp(ctx->decoder, &args);
    if (!args.device) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkGetDeviceQueue2(ctx, &args);

    if ((flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT) && !vn_cs_decoder_get_fatal(ctx->decoder))
        vn_encode_vkGetDeviceQueue2_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkGetPhysicalDeviceCalibrateableTimeDomainsEXT(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkGetPhysicalDeviceCalibrateableTimeDomainsEXT args;

    if (!ctx->dispatch_vkGetPhysicalDeviceCalibrateableTimeDomainsEXT) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkGetPhysicalDeviceCalibrateableTimeDomainsEXT_args_temp(ctx->decoder, &args);
    if (!args.physicalDevice) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkGetPhysicalDeviceCalibrateableTimeDomainsEXT(ctx, &args);

#ifdef DEBUG
    if (!vn_cs_decoder_get_fatal(ctx->decoder) && vn_dispatch_should_log_result(args.ret))
        vn_dispatch_debug_log(ctx, "vkGetPhysicalDeviceCalibrateableTimeDomainsEXT returned %d", args.ret);
#endif

    if ((flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT) && !vn_cs_decoder_get_fatal(ctx->decoder))
        vn_encode_vkGetPhysicalDeviceCalibrateableTimeDomainsEXT_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkGetCalibratedTimestampsEXT(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkGetCalibratedTimestampsEXT args;

    if (!ctx->dispatch_vkGetCalibratedTimestampsEXT) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkGetCalibratedTimestampsEXT_args_temp(ctx->decoder, &args);
    if (!args.device) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkGetCalibratedTimestampsEXT(ctx, &args);

#ifdef DEBUG
    if (!vn_cs_decoder_get_fatal(ctx->decoder) && vn_dispatch_should_log_result(args.ret))
        vn_dispatch_debug_log(ctx, "vkGetCalibratedTimestampsEXT returned %d", args.ret);
#endif

    if ((flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT) && !vn_cs_decoder_get_fatal(ctx->decoder))
        vn_encode_vkGetCalibratedTimestampsEXT_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkGetPhysicalDeviceToolProperties(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkGetPhysicalDeviceToolProperties args;

    if (!ctx->dispatch_vkGetPhysicalDeviceToolProperties) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkGetPhysicalDeviceToolProperties_args_temp(ctx->decoder, &args);
    if (!args.physicalDevice) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkGetPhysicalDeviceToolProperties(ctx, &args);

#ifdef DEBUG
    if (!vn_cs_decoder_get_fatal(ctx->decoder) && vn_dispatch_should_log_result(args.ret))
        vn_dispatch_debug_log(ctx, "vkGetPhysicalDeviceToolProperties returned %d", args.ret);
#endif

    if ((flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT) && !vn_cs_decoder_get_fatal(ctx->decoder))
        vn_encode_vkGetPhysicalDeviceToolProperties_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

#pragma GCC diagnostic pop

#endif /* VN_PROTOCOL_RENDERER_DEVICE_H */
