/* i386-linux.kernel.vmlinuz.h
   created from i386-linux.kernel.vmlinuz.bin, 25052 (0x61dc) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) Markus Franz Xaver Johannes Oberhumer
   Copyright (C) Laszlo Molnar
   Copyright (C) John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ezerotven+github@gmail.com>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */

/* clang-format off */

#define STUB_I386_LINUX_KERNEL_VMLINUZ_SIZE    25052
#define STUB_I386_LINUX_KERNEL_VMLINUZ_ADLER32 0xd4c7861b
#define STUB_I386_LINUX_KERNEL_VMLINUZ_CRC32   0x49f485e5

unsigned char stub_i386_linux_kernel_vmlinuz[25052] = {
/* 0x0000 */ 127, 69, 76, 70,  1,  1,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   1,  0,  3,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */  72, 33,  0,  0,  0,  0,  0,  0, 52,  0,  0,  0,  0,  0, 40,  0,
/* 0x0030 */   0,  0,  0,  0,252,140,200,131,192,  8,142,216,142,192,142,208,
/* 0x0040 */ 141,166,  0,  0,  0,  0,137,245,102,129,190,  6,  2,  0,  0,  2,
/* 0x0050 */   2,115, 18,137,238,102,129,125, 32, 63,163,117, 18, 15,183,117,
/* 0x0060 */  34,  1,238,235, 10,139,182, 40,  2,  0,  0,133,246,116,228, 41,
/* 0x0070 */ 201,172, 65, 60,  0,117,250,137,250,191,176,151,  9,  0,141, 71,
/* 0x0080 */  79, 57,254,115, 42, 79, 78,253,243,164,252, 71,137,189, 40,  2,
/* 0x0090 */   0,  0, 41,248,137,133, 56,  2,  0,  0,137,248, 41,232,102,137,
/* 0x00a0 */  69, 34,131,231,252,137,127,248,140, 95,252, 15,178,103,248,137,
/* 0x00b0 */ 215,137,238,106,  0,157, 87,191,  0,  0,  9,  0, 87,185,148,  0,
/* 0x00c0 */   0,  0,243,165, 94, 95,188,  0,  0,  9,  0,184,  0,  0,  0,  0,
/* 0x00d0 */  14, 80, 87, 86,131,205,255,232,  0,  0,  0,  0, 93,232, 22,  0,
/* 0x00e0 */   0,  0,247,217, 57,247,118,  9,141,116, 14,252,141,124, 15,252,
/* 0x00f0 */ 253,193,233,  2,243,165,252,195,137,242, 94,139, 78,252,247,217,
/* 0x0100 */ 131,225,252,  1,204,137,231,255,214,137,239,247,223,129,231,  0,
/* 0x0110 */   0,  0,  0,247,223,191,  0,  0,  0,  0,137,224, 82,141,151,  0,
/* 0x0120 */   0,  0,  0,137,238, 82,129,194,  0,  0,  0,  0, 87,129,199,  0,
/* 0x0130 */   0,  0,  0, 87,185,  0,  0,  0,  0, 82,255,224, 94, 95, 87, 87,
/* 0x0140 */ 106,  0,104,  0,  0,  0,  0, 93, 94,137,235,129,235,  0,  0,  0,
/* 0x0150 */   0,116, 17,253,173,235,  7,  1,156,  3,  0,  0,  0,  0,173,133,
/* 0x0160 */ 192,117,244,252, 94, 49,219,255,229, 80, 80,106,  0,104,  0,  0,
/* 0x0170 */   0,  0,190,  0,  0,  0,  0,191,  0,  0,  0,  0,185,  0,  0,  0,
/* 0x0180 */   0,253,243,165,252,190,  0,  0,  0,  0,151,233,252,255,255,255,
/* 0x0190 */  71,137,125,  1, 57, 56,116,248,252,190,  0,  0,  0,  0,151,235,
/* 0x01a0 */   3,164,235,  3,138,  6, 70,136,  7, 71,  1,219,117,  7,139, 30,
/* 0x01b0 */ 131,238,252, 17,219,114,  1, 49,192, 64,138,  7,114,255,184,  1,
/* 0x01c0 */   0,  0,  0,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,192,
/* 0x01d0 */   1,219,117,  7,139, 30,131,238,252, 17,219,115,255,  1,219,115,
/* 0x01e0 */ 255,117,  9,139, 30,131,238,252, 17,219,115,255, 49,201,131,232,
/* 0x01f0 */   3,114, 13,193,224,  8,138,  6, 70,131,240,255,116,255,137,197,
/* 0x0200 */   1,219,117,  7,139, 30,131,238,252, 17,219, 17,201,  1,219,117,
/* 0x0210 */   7,139, 30,131,238,252, 17,219, 17,201,117,255, 65,  1,219,117,
/* 0x0220 */   7,139, 30,131,238,252, 17,219, 17,201,  1,219,117,  7,139, 30,
/* 0x0230 */ 131,238,252, 17,219,115, 48,  1,219,115, 48,117,  9,139, 30,131,
/* 0x0240 */ 238,252, 17,219,115, 48, 65, 65,131,193,  2,129,253,  0,243,255,
/* 0x0250 */ 255,131,209,  1, 86,141, 52, 47,243,164, 94,233,252,255,255,255,
/* 0x0260 */ 141, 20, 47,131,253,252,138,  4, 15,118,255,138,  2, 66,136,  7,
/* 0x0270 */  71, 73,117,247,233,252,255,255,255,139,  2,131,194,  4,137,  7,
/* 0x0280 */ 131,199,  4,131,233,  4,119,241,  1,207,233,252,255,255,255,235,
/* 0x0290 */   3,164,235,  3,138,  6, 70,136,  7, 71,  1,219,117,  7,139, 30,
/* 0x02a0 */ 131,238,252, 17,219,114,  1, 49,192, 64,138,  7,114,255,184,  1,
/* 0x02b0 */   0,  0,  0,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,192,
/* 0x02c0 */   1,219,117,  7,139, 30,131,238,252, 17,219,114, 15,  1,219,115,
/* 0x02d0 */  11,117, 15,139, 30,131,238,252, 17,219,114, 15, 72,  1,219,117,
/* 0x02e0 */   7,139, 30,131,238,252, 17,219, 17,192,235,255, 49,201,131,232,
/* 0x02f0 */   3,114, 17,193,224,  8,138,  6, 70,131,240,255,116,255,209,248,
/* 0x0300 */ 137,197,235, 11,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,
/* 0x0310 */ 201,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,201,117,255,
/* 0x0320 */  65,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,201,  1,219,
/* 0x0330 */ 117,  7,139, 30,131,238,252, 17,219,115, 68,  1,219,115, 68,117,
/* 0x0340 */   9,139, 30,131,238,252, 17,219,115, 68, 65, 65,131,193,  2,129,
/* 0x0350 */ 253,  0,251,255,255,131,209,  1, 86,141, 52, 47,243,164, 94,233,
/* 0x0360 */ 252,255,255,255,141, 20, 47,131,253,252,138,  4, 15,118,255,138,
/* 0x0370 */   2, 66,136,  7, 71, 73,117,247,233,252,255,255,255,139,  2,131,
/* 0x0380 */ 194,  4,137,  7,131,199,  4,131,233,  4,119,241,  1,207,233,252,
/* 0x0390 */ 255,255,255,235,  3,164,235,  3,138,  6, 70,136,  7, 71,  1,219,
/* 0x03a0 */ 117,  7,139, 30,131,238,252, 17,219,114,  1, 49,192, 64,138,  7,
/* 0x03b0 */ 114,255,184,  1,  0,  0,  0,  1,219,117,  7,139, 30,131,238,252,
/* 0x03c0 */  17,219, 17,192,  1,219,117,  7,139, 30,131,238,252, 17,219,114,
/* 0x03d0 */  30,  1,219,115, 11,117, 30,139, 30,131,238,252, 17,219,114, 30,
/* 0x03e0 */  72,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,192,235,255,
/* 0x03f0 */   1,219,117,  7,139, 30,131,238,252, 17,219, 17,201,235,255, 49,
/* 0x0400 */ 201,131,232,  3,114, 17,193,224,  8,138,  6, 70,131,240,255,116,
/* 0x0410 */ 255,209,248,137,197,235, 11,  1,219,117,  7,139, 30,131,238,252,
/* 0x0420 */  17,219,114,204, 65,  1,219,117,  7,139, 30,131,238,252, 17,219,
/* 0x0430 */ 114,190,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,201,  1,
/* 0x0440 */ 219,117,  7,139, 30,131,238,252, 17,219,115, 81,  1,219,115, 81,
/* 0x0450 */ 117,  9,139, 30,131,238,252, 17,219,115, 81, 65, 65,131,193,  2,
/* 0x0460 */ 129,253,  0,251,255,255,131,209,  2, 86,141, 52, 47,243,164, 94,
/* 0x0470 */ 233,252,255,255,255,141, 20, 47,131,253,252,138,  4, 15,118,255,
/* 0x0480 */ 138,  2, 66,136,  7, 71, 73,117,247,233,252,255,255,255,139,  2,
/* 0x0490 */ 131,194,  4,137,  7,131,199,  4,131,233,  4,119,241,  1,207,233,
/* 0x04a0 */ 252,255,255,255,137,229,141,156, 36,  0,  0,  0,  0, 49,192, 80,
/* 0x04b0 */  57,220,117,251, 70, 70, 83,104,  0,  0,  0,  0, 87,131,195,  4,
/* 0x04c0 */  83,104,  0,  0,  0,  0, 86,131,195,  4, 83, 80,199,  3,  0,  0,
/* 0x04d0 */   0,  0,137,229,139, 85,  0,172, 74,136,193, 36,  7,192,233,  3,
/* 0x04e0 */ 187,  0,253,255,255,211,227,141,164, 92,144,241,255,255,131,228,
/* 0x04f0 */ 224,106,  0,106,  0,137,227, 83,131,195,  4,139, 77,  0,255, 49,
/* 0x0500 */  87, 83,131,195,  4,136, 67,  2,172, 74,136,193, 36, 15,136,  3,
/* 0x0510 */ 192,233,  4,136, 75,  1, 82, 86, 83, 80, 85, 87,191,  0,  0,  0,
/* 0x0520 */   0, 86, 83,131,236,100,139, 84, 36,120,199, 68, 36, 92,  0,  0,
/* 0x0530 */   0,  0,141, 66,  4,137, 68, 36, 96,184,  1,  0,  0,  0, 15,182,
/* 0x0540 */  74,  2,137,195,211,227,137,217, 73,137, 76, 36, 88, 15,182, 74,
/* 0x0550 */   1,211,224,139,140, 36,144,  0,  0,  0, 72,137, 68, 36, 84,139,
/* 0x0560 */ 132, 36,132,  0,  0,  0, 15,182, 50,199, 68, 36, 76,  0,  0,  0,
/* 0x0570 */   0,199,  0,  0,  0,  0,  0,184,  0,  3,  0,  0,199, 68, 36, 72,
/* 0x0580 */   1,  0,  0,  0,137,116, 36, 80,199, 68, 36, 68,  1,  0,  0,  0,
/* 0x0590 */ 199, 68, 36, 64,  1,  0,  0,  0,199, 68, 36, 60,  1,  0,  0,  0,
/* 0x05a0 */ 199,  1,  0,  0,  0,  0, 15,182, 74,  1,  1,241,211,224,141,136,
/* 0x05b0 */  54,  7,  0,  0, 57, 76, 36, 92,115, 14,139, 68, 36, 96,102,199,
/* 0x05c0 */   0,  0,  4,131,192,  2,226,246,139,108, 36,124,199, 68, 36, 48,
/* 0x05d0 */   0,  0,  0,  0,199, 68, 36, 52,255,255,255,255,186,  0,  0,  0,
/* 0x05e0 */   0,137,235,  3,156, 36,128,  0,  0,  0,137, 92, 36, 56, 59,108,
/* 0x05f0 */  36, 56, 15,132,128,  8,  0,  0,193,100, 36, 48,  8, 66, 15,182,
/* 0x0600 */  69,  0, 69,  9, 68, 36, 48,131,250,  4,126,226,139,180, 36,140,
/* 0x0610 */   0,  0,  0, 57,116, 36, 92, 15,131,226,  1,  0,  0,139,132, 36,
/* 0x0620 */ 136,  0,  0,  0,137, 68, 36, 24,139, 84, 36, 92, 35, 84, 36, 88,
/* 0x0630 */ 139, 68, 36, 76,139, 76, 36, 96,193,224,  4,137, 84, 36, 44,  1,
/* 0x0640 */ 208,129,124, 36, 52,255,255,255,  0,141, 52, 65,119, 29, 59,108,
/* 0x0650 */  36, 56, 15,132, 32,  8,  0,  0,193,100, 36, 48,  8,193,100, 36,
/* 0x0660 */  52,  8, 15,182, 69,  0, 69,  9, 68, 36, 48,139, 68, 36, 52,102,
/* 0x0670 */ 139, 22,193,232, 11, 15,183,202, 15,175,193, 57, 68, 36, 48, 15,
/* 0x0680 */ 131, 80,  2,  0,  0,137, 68, 36, 52,184,  0,  8,  0,  0, 41,200,
/* 0x0690 */ 138, 76, 36, 80,193,248,  5,187,  1,  0,  0,  0,141,  4,  2,102,
/* 0x06a0 */ 137,  6,139, 68, 36, 92, 35, 68, 36, 84,139,116, 36, 96,211,224,
/* 0x06b0 */ 137,249, 15,182,209,185,  8,  0,  0,  0, 43, 76, 36, 80,211,250,
/* 0x06c0 */   1,208,105,192,  0,  6,  0,  0,131,124, 36, 76,  6,141,132, 48,
/* 0x06d0 */ 108, 14,  0,  0,137, 68, 36, 20, 15,142, 72,  1,  0,  0,139, 68,
/* 0x06e0 */  36, 92, 43, 68, 36, 72,139,148, 36,136,  0,  0,  0, 15,182,  4,
/* 0x06f0 */  16,137, 68, 36, 40,235, 46,137, 68, 36, 52,184,  0,  8,  0,  0,
/* 0x0700 */  41,216,137,251,193,248,  5,133,210,141,  4,  1,102,137,134,  0,
/* 0x0710 */   2,  0,  0, 15,133,106,  1,  0,  0,129,251,255,  0,  0,  0, 15,
/* 0x0720 */ 143,143,  0,  0,  0,209,100, 36, 40,139, 84, 36, 40,141, 60, 27,
/* 0x0730 */ 139, 76, 36, 20,129,226,  0,  1,  0,  0,129,124, 36, 52,255,255,
/* 0x0740 */ 255,  0,141,  4, 81,141, 52, 56,119, 29, 59,108, 36, 56, 15,132,
/* 0x0750 */  36,  7,  0,  0,193,100, 36, 48,  8,193,100, 36, 52,  8, 15,182,
/* 0x0760 */  69,  0, 69,  9, 68, 36, 48,139, 68, 36, 52,102,139,142,  0,  2,
/* 0x0770 */   0,  0,193,232, 11, 15,183,217, 15,175,195, 57, 68, 36, 48, 15,
/* 0x0780 */ 130,114,255,255,255, 41, 68, 36, 52, 41, 68, 36, 48,137,200,102,
/* 0x0790 */ 193,232,  5,141, 95,  1,102, 41,193,133,210,102,137,142,  0,  2,
/* 0x07a0 */   0,  0, 15,132,219,  0,  0,  0,129,251,255,  0,  0,  0, 15,142,
/* 0x07b0 */ 113,255,255,255,139, 84, 36, 24,137,223,136, 26, 66,255, 68, 36,
/* 0x07c0 */  92,131,124, 36, 76,  3,137, 84, 36, 24, 15,143,215,  0,  0,  0,
/* 0x07d0 */ 199, 68, 36, 76,  0,  0,  0,  0,139,132, 36,140,  0,  0,  0, 57,
/* 0x07e0 */  68, 36, 92, 15,130, 63,254,255,255,129,124, 36, 52,255,255,255,
/* 0x07f0 */   0,119, 12, 59,108, 36, 56,184,  1,  0,  0,  0,116, 32, 69, 43,
/* 0x0800 */ 108, 36,124,184,  0,  0,  0,  0,139,148, 36,132,  0,  0,  0,139,
/* 0x0810 */  92, 36, 92,139,140, 36,144,  0,  0,  0,137, 42,137, 25,131,196,
/* 0x0820 */ 100,233, 46,  8,  0,  0,129,124, 36, 52,255,255,255,  0,141, 52,
/* 0x0830 */  27,139, 68, 36, 20,141, 28,  6,119, 29, 59,108, 36, 56, 15,132,
/* 0x0840 */  52,  6,  0,  0,193,100, 36, 48,  8,193,100, 36, 52,  8, 15,182,
/* 0x0850 */  69,  0, 69,  9, 68, 36, 48,139, 68, 36, 52,102,139, 11,193,232,
/* 0x0860 */  11, 15,183,209, 15,175,194, 57, 68, 36, 48,115, 79,137, 68, 36,
/* 0x0870 */  52,184,  0,  8,  0,  0, 41,208,193,248,  5,141,  4,  1,102,137,
/* 0x0880 */   3,137,243,129,251,255,  0,  0,  0,126,155,139, 84, 36, 24,137,
/* 0x0890 */ 223,136, 26, 66,255, 68, 36, 92,131,124, 36, 76,  3,137, 84, 36,
/* 0x08a0 */  24, 15,142, 41,255,255,255,131,124, 36, 76,  9, 15,143,107,  6,
/* 0x08b0 */   0,  0,131,108, 36, 76,  3,233, 28,255,255,255, 41, 68, 36, 52,
/* 0x08c0 */  41, 68, 36, 48,137,200,102,193,232,  5,102, 41,193,102,137, 11,
/* 0x08d0 */ 141, 94,  1,235,174,139, 92, 36, 52, 41, 68, 36, 48, 41,195,137,
/* 0x08e0 */ 208,102,193,232,  5,139, 76, 36, 76,102, 41,194,129,251,255,255,
/* 0x08f0 */ 255,  0,102,137, 22,139,116, 36, 96,141, 60, 78,119, 27, 59,108,
/* 0x0900 */  36, 56, 15,132,112,  5,  0,  0,193,100, 36, 48,  8, 15,182, 69,
/* 0x0910 */   0,193,227,  8,  9, 68, 36, 48, 69,102,139,151,128,  1,  0,  0,
/* 0x0920 */ 137,216,193,232, 11, 15,183,202, 15,175,193, 57, 68, 36, 48, 15,
/* 0x0930 */ 131,228,  2,  0,  0,137,198,184,  0,  8,  0,  0, 41,200,139, 92,
/* 0x0940 */  36, 96,193,248,  5,131,124, 36, 76,  6,141,  4,  2,139, 76, 36,
/* 0x0950 */  72,139, 84, 36, 68,102,137,135,128,  1,  0,  0,139, 68, 36, 64,
/* 0x0960 */ 137, 76, 36, 68,137, 68, 36, 60,184,  0,  0,  0,  0, 15,159,192,
/* 0x0970 */ 137, 84, 36, 64,141,  4, 64,129,195,100,  6,  0,  0,137, 68, 36,
/* 0x0980 */  76,129,254,255,255,255,  0,119, 27, 59,108, 36, 56, 15,132,229,
/* 0x0990 */   4,  0,  0,193,100, 36, 48,  8, 15,182, 69,  0,193,230,  8,  9,
/* 0x09a0 */  68, 36, 48, 69,102,139, 19,137,240,193,232, 11, 15,183,202, 15,
/* 0x09b0 */ 175,193, 57, 68, 36, 48, 15,131,102,  3,  0,  0,137, 68, 36, 52,
/* 0x09c0 */ 184,  0,  8,  0,  0, 41,200,193,100, 36, 44,  4,193,248,  5,139,
/* 0x09d0 */  76, 36, 44,141,  4,  2,199, 68, 36, 32,  0,  0,  0,  0,102,137,
/* 0x09e0 */   3,141, 92, 25,  4,137, 92, 36, 16,199, 68, 36, 36,  3,  0,  0,
/* 0x09f0 */   0,139,124, 36, 36,186,  1,  0,  0,  0,235, 25,137, 68, 36, 52,
/* 0x0a00 */ 184,  0,  8,  0,  0, 41,200,193,248,  5, 79,141,  4,  2,137,242,
/* 0x0a10 */ 102,137,  3,116, 97,129,124, 36, 52,255,255,255,  0,141, 52, 18,
/* 0x0a20 */ 139, 68, 36, 16,141, 28,  6,119, 29, 59,108, 36, 56, 15,132, 69,
/* 0x0a30 */   4,  0,  0,193,100, 36, 48,  8,193,100, 36, 52,  8, 15,182, 69,
/* 0x0a40 */   0, 69,  9, 68, 36, 48,139, 68, 36, 52,102,139, 19,193,232, 11,
/* 0x0a50 */  15,183,202, 15,175,193, 57, 68, 36, 48,114,160, 41, 68, 36, 52,
/* 0x0a60 */  41, 68, 36, 48,137,208,102,193,232,  5,102, 41,194, 79,102,137,
/* 0x0a70 */  19,141, 86,  1,117,159,138, 76, 36, 36,184,  1,  0,  0,  0,211,
/* 0x0a80 */ 224, 41,194,  3, 84, 36, 32,131,124, 36, 76,  3,137, 84, 36, 12,
/* 0x0a90 */  15,143,254,  3,  0,  0,131, 68, 36, 76,  7,131,250,  3,137,208,
/* 0x0aa0 */ 126,  5,184,  3,  0,  0,  0,139, 92, 36, 96,193,224,  7,191,  6,
/* 0x0ab0 */   0,  0,  0,141,132, 24, 96,  3,  0,  0,137, 68, 36,  8,184,  1,
/* 0x0ac0 */   0,  0,  0,235, 25,137, 68, 36, 52,184,  0,  8,  0,  0, 41,200,
/* 0x0ad0 */ 193,248,  5, 79,141,  4,  2,102,137,  3,137,240,116, 97,129,124,
/* 0x0ae0 */  36, 52,255,255,255,  0,141, 52,  0,139, 68, 36,  8,141, 28,  6,
/* 0x0af0 */ 119, 29, 59,108, 36, 56, 15,132,124,  3,  0,  0,193,100, 36, 48,
/* 0x0b00 */   8,193,100, 36, 52,  8, 15,182, 69,  0, 69,  9, 68, 36, 48,139,
/* 0x0b10 */  68, 36, 52,102,139, 19,193,232, 11, 15,183,202, 15,175,193, 57,
/* 0x0b20 */  68, 36, 48,114,160, 41, 68, 36, 52, 41, 68, 36, 48,137,208,102,
/* 0x0b30 */ 193,232,  5,102, 41,194, 79,102,137, 19,141, 70,  1,117,159,141,
/* 0x0b40 */  80,192,131,250,  3,137, 84, 36,  4, 15,142, 54,  3,  0,  0,137,
/* 0x0b50 */ 211,137,208,131,227,  1,209,248,131,203,  2,131,250, 13,141,120,
/* 0x0b60 */ 255, 15,143, 66,  4,  0,  0,137,249,139,116, 36, 96,211,227,  1,
/* 0x0b70 */ 210,141,  4, 94,137, 92, 36,  4, 41,208,  5, 94,  5,  0,  0,137,
/* 0x0b80 */   4, 36,184,  1,  0,  0,  0,199, 68, 36, 28,  1,  0,  0,  0,235,
/* 0x0b90 */  33,137, 68, 36, 52,184,  0,  8,  0,  0, 41,200,193,248,  5,141,
/* 0x0ba0 */   4,  2,102,137,  3,137,240,209,100, 36, 28, 79, 15,132,211,  2,
/* 0x0bb0 */   0,  0,129,124, 36, 52,255,255,255,  0,141, 52,  0,139, 12, 36,
/* 0x0bc0 */ 141, 28, 14,119, 29, 59,108, 36, 56, 15,132,169,  2,  0,  0,193,
/* 0x0bd0 */ 100, 36, 48,  8,193,100, 36, 52,  8, 15,182, 69,  0, 69,  9, 68,
/* 0x0be0 */  36, 48,139, 68, 36, 52,102,139, 19,193,232, 11, 15,183,202, 15,
/* 0x0bf0 */ 175,193, 57, 68, 36, 48,114,153, 41, 68, 36, 52, 41, 68, 36, 48,
/* 0x0c00 */ 137,208,102,193,232,  5,102, 41,194,141, 70,  1,102,137, 19,139,
/* 0x0c10 */  92, 36, 28,  9, 92, 36,  4,235,142, 41,195, 41, 68, 36, 48,137,
/* 0x0c20 */ 208,102,193,232,  5,102, 41,194,129,251,255,255,255,  0,102,137,
/* 0x0c30 */ 151,128,  1,  0,  0, 15,134,107,  1,  0,  0,102,139,143,152,  1,
/* 0x0c40 */   0,  0,137,218,193,234, 11, 15,183,193, 15,175,208, 57, 84, 36,
/* 0x0c50 */  48, 15,131,134,  1,  0,  0,190,  0,  8,  0,  0,137,211, 41,198,
/* 0x0c60 */ 137,240,193,248,  5,141,  4,  1,139, 76, 36, 44,102,137,135,152,
/* 0x0c70 */   1,  0,  0,139, 68, 36, 76,193,224,  5,  3, 68, 36, 96,129,250,
/* 0x0c80 */ 255,255,255,  0,141, 60, 72,119, 27, 59,108, 36, 56, 15,132,229,
/* 0x0c90 */   1,  0,  0,193,100, 36, 48,  8, 15,182, 69,  0,193,227,  8,  9,
/* 0x0ca0 */  68, 36, 48, 69,102,139,151,224,  1,  0,  0,137,216,193,232, 11,
/* 0x0cb0 */  15,183,202, 15,175,193, 57, 68, 36, 48, 15,131,103,  2,  0,  0,
/* 0x0cc0 */ 137, 68, 36, 52,184,  0,  8,  0,  0, 41,200,193,248,  5,141,  4,
/* 0x0cd0 */   2,102,137,135,224,  1,  0,  0,139, 68, 36, 92,133,192, 15,132,
/* 0x0ce0 */ 148,  1,  0,  0,131,124, 36, 76,  6,184,  0,  0,  0,  0,139,156,
/* 0x0cf0 */  36,136,  0,  0,  0,139, 84, 36, 24, 15,159,192,141, 68,  0,  9,
/* 0x0d00 */ 137, 68, 36, 76,139, 68, 36, 92, 43, 68, 36, 72, 15,182, 60, 24,
/* 0x0d10 */ 137,248,136,  2, 66,255, 68, 36, 92,137, 84, 36, 24,233,182,250,
/* 0x0d20 */ 255,255, 41,198, 41, 68, 36, 48,137,208,102,193,232,  5,102, 41,
/* 0x0d30 */ 194,129,254,255,255,255,  0,102,137, 19,119, 27, 59,108, 36, 56,
/* 0x0d40 */  15,132, 50,  1,  0,  0,193,100, 36, 48,  8, 15,182, 69,  0,193,
/* 0x0d50 */ 230,  8,  9, 68, 36, 48, 69,102,139, 83,  2,137,240,193,232, 11,
/* 0x0d60 */  15,183,202, 15,175,193, 57, 68, 36, 48, 15,131,119,  1,  0,  0,
/* 0x0d70 */ 137, 68, 36, 52,184,  0,  8,  0,  0, 41,200,193,100, 36, 44,  4,
/* 0x0d80 */ 193,248,  5,139,116, 36, 44,141,  4,  2,199, 68, 36, 32,  8,  0,
/* 0x0d90 */   0,  0,102,137, 67,  2,141,156, 30,  4,  1,  0,  0,137, 92, 36,
/* 0x0da0 */  16,233, 67,252,255,255, 59,108, 36, 56, 15,132,200,  0,  0,  0,
/* 0x0db0 */ 193,100, 36, 48,  8,193,227,  8,102,139,143,152,  1,  0,  0, 15,
/* 0x0dc0 */ 182, 69,  0,137,218,  9, 68, 36, 48,193,234, 11, 15,183,193, 69,
/* 0x0dd0 */  15,175,208, 57, 84, 36, 48, 15,130,122,254,255,255,137,200, 41,
/* 0x0de0 */ 211,102,193,232,  5, 41, 84, 36, 48,102, 41,193,129,251,255,255,
/* 0x0df0 */ 255,  0,102,137,143,152,  1,  0,  0,119, 23, 59,108, 36, 56,116,
/* 0x0e00 */ 119,193,100, 36, 48,  8, 15,182, 69,  0,193,227,  8,  9, 68, 36,
/* 0x0e10 */  48, 69,102,139,151,176,  1,  0,  0,137,216,193,232, 11, 15,183,
/* 0x0e20 */ 202, 15,175,193, 57, 68, 36, 48, 15,131, 22,  1,  0,  0,137,198,
/* 0x0e30 */ 184,  0,  8,  0,  0, 41,200,193,248,  5,141,  4,  2,102,137,135,
/* 0x0e40 */ 176,  1,  0,  0,139, 68, 36, 68,139, 84, 36, 72,137, 68, 36, 72,
/* 0x0e50 */ 137, 84, 36, 68,131,124, 36, 76,  6,184,  0,  0,  0,  0,139, 92,
/* 0x0e60 */  36, 96, 15,159,192,129,195,104, 10,  0,  0,141, 68, 64,  8,137,
/* 0x0e70 */  68, 36, 76,233,  9,251,255,255,131,196,100,184,  1,  0,  0,  0,
/* 0x0e80 */ 233,207,  1,  0,  0,139,116, 36,  4, 70,137,116, 36, 72, 15,132,
/* 0x0e90 */  85,249,255,255,139, 76, 36, 12,139, 68, 36, 92,131,193,  2, 57,
/* 0x0ea0 */  68, 36, 72,119,211,137,194,139,132, 36,136,  0,  0,  0, 43, 68,
/* 0x0eb0 */  36, 72,  3,148, 36,136,  0,  0,  0,  3, 68, 36, 92, 15,182, 56,
/* 0x0ec0 */  64,137,251,136, 26, 66,255, 68, 36, 92,255, 68, 36, 24, 73, 15,
/* 0x0ed0 */ 132,  3,249,255,255,139,180, 36,140,  0,  0,  0, 57,116, 36, 92,
/* 0x0ee0 */ 114,219,233,  2,249,255,255, 41,198, 41, 68, 36, 48,137,208,137,
/* 0x0ef0 */ 116, 36, 52,102,193,232,  5,199, 68, 36, 32, 16,  0,  0,  0,102,
/* 0x0f00 */  41,194,199, 68, 36, 36,  8,  0,  0,  0,102,137, 83,  2,129,195,
/* 0x0f10 */   4,  2,  0,  0,137, 92, 36, 16,233,212,250,255,255,131,108, 36,
/* 0x0f20 */  76,  6,233,177,248,255,255,137,222, 41, 68, 36, 48, 41,198,137,
/* 0x0f30 */ 208,102,193,232,  5,102, 41,194,102,137,151,224,  1,  0,  0,233,
/* 0x0f40 */  16,255,255,255, 41,195, 41, 68, 36, 48,137,208,102,193,232,  5,
/* 0x0f50 */ 102, 41,194,129,251,255,255,255,  0,102,137,151,176,  1,  0,  0,
/* 0x0f60 */  15,134,165,  0,  0,  0,102,139,151,200,  1,  0,  0,137,216,193,
/* 0x0f70 */ 232, 11, 15,183,202, 15,175,193, 57, 68, 36, 48, 15,131,169,  0,
/* 0x0f80 */   0,  0,137,198,184,  0,  8,  0,  0, 41,200,193,248,  5,141,  4,
/* 0x0f90 */   2,102,137,135,200,  1,  0,  0,139, 68, 36, 64,139, 92, 36, 68,
/* 0x0fa0 */ 137, 92, 36, 64,233,159,254,255,255,141, 80,251,129,124, 36, 52,
/* 0x0fb0 */ 255,255,255,  0,119, 29, 59,108, 36, 56, 15,132,184,254,255,255,
/* 0x0fc0 */ 193,100, 36, 48,  8,193,100, 36, 52,  8, 15,182, 69,  0, 69,  9,
/* 0x0fd0 */  68, 36, 48,209,108, 36, 52,  1,219,139, 68, 36, 52, 57, 68, 36,
/* 0x0fe0 */  48,114,  7, 41, 68, 36, 48,131,203,  1, 74,117,191,139, 84, 36,
/* 0x0ff0 */  96,193,227,  4,191,  4,  0,  0,  0,137, 92, 36,  4,129,194, 68,
/* 0x1000 */   6,  0,  0,137, 20, 36,233,119,251,255,255, 59,108, 36, 56, 15,
/* 0x1010 */ 132, 99,254,255,255,193,100, 36, 48,  8, 15,182, 69,  0,193,227,
/* 0x1020 */   8,  9, 68, 36, 48, 69,233, 59,255,255,255,137,222, 41, 68, 36,
/* 0x1030 */  48, 41,198,137,208,102,193,232,  5,139, 76, 36, 64,102, 41,194,
/* 0x1040 */ 139, 68, 36, 60,102,137,151,200,  1,  0,  0,137, 76, 36, 60,233,
/* 0x1050 */  72,255,255,255, 91, 94, 95, 93, 85, 87,191,  0,  0,  0,  0, 86,
/* 0x1060 */  83,131,236,100,139, 84, 36,120,199, 68, 36, 92,  0,  0,  0,  0,
/* 0x1070 */ 141, 66,  4,137, 68, 36, 96,184,  1,  0,  0,  0, 15,182, 74,  2,
/* 0x1080 */ 137,195,211,227,137,217, 73,137, 76, 36, 88, 15,182, 74,  1,211,
/* 0x1090 */ 224,139,140, 36,144,  0,  0,  0, 72,137, 68, 36, 84,139,132, 36,
/* 0x10a0 */ 132,  0,  0,  0, 15,182, 50,199, 68, 36, 76,  0,  0,  0,  0,199,
/* 0x10b0 */   0,  0,  0,  0,  0,184,  0,  3,  0,  0,199, 68, 36, 72,  1,  0,
/* 0x10c0 */   0,  0,137,116, 36, 80,199, 68, 36, 68,  1,  0,  0,  0,199, 68,
/* 0x10d0 */  36, 64,  1,  0,  0,  0,199, 68, 36, 60,  1,  0,  0,  0,199,  1,
/* 0x10e0 */   0,  0,  0,  0, 15,182, 74,  1,  1,241,211,224,141,136, 54,  7,
/* 0x10f0 */   0,  0, 57, 76, 36, 92,115, 14,139, 68, 36, 96,102,199,  0,  0,
/* 0x1100 */   4,131,192,  2,226,246,139,108, 36,124,199, 68, 36, 48,  0,  0,
/* 0x1110 */   0,  0,199, 68, 36, 52,255,255,255,255,186,  0,  0,  0,  0,137,
/* 0x1120 */ 235,  3,156, 36,128,  0,  0,  0,137, 92, 36, 56, 59,108, 36, 56,
/* 0x1130 */  15,132,128,  8,  0,  0,193,100, 36, 48,  8, 66, 15,182, 69,  0,
/* 0x1140 */  69,  9, 68, 36, 48,131,250,  4,126,226,139,180, 36,140,  0,  0,
/* 0x1150 */   0, 57,116, 36, 92, 15,131,226,  1,  0,  0,139,132, 36,136,  0,
/* 0x1160 */   0,  0,137, 68, 36, 24,139, 84, 36, 92, 35, 84, 36, 88,139, 68,
/* 0x1170 */  36, 76,139, 76, 36, 96,193,224,  4,137, 84, 36, 44,  1,208,129,
/* 0x1180 */ 124, 36, 52,255,255,255,  0,141, 52, 65,119, 29, 59,108, 36, 56,
/* 0x1190 */  15,132, 32,  8,  0,  0,193,100, 36, 48,  8,193,100, 36, 52,  8,
/* 0x11a0 */  15,182, 69,  0, 69,  9, 68, 36, 48,139, 68, 36, 52,102,139, 22,
/* 0x11b0 */ 193,232, 11, 15,183,202, 15,175,193, 57, 68, 36, 48, 15,131, 80,
/* 0x11c0 */   2,  0,  0,137, 68, 36, 52,184,  0,  8,  0,  0, 41,200,138, 76,
/* 0x11d0 */  36, 80,193,248,  5,187,  1,  0,  0,  0,141,  4,  2,102,137,  6,
/* 0x11e0 */ 139, 68, 36, 92, 35, 68, 36, 84,139,116, 36, 96,211,224,137,249,
/* 0x11f0 */  15,182,209,185,  8,  0,  0,  0, 43, 76, 36, 80,211,250,  1,208,
/* 0x1200 */ 105,192,  0,  6,  0,  0,131,124, 36, 76,  6,141,132, 48,108, 14,
/* 0x1210 */   0,  0,137, 68, 36, 20, 15,142, 72,  1,  0,  0,139, 68, 36, 92,
/* 0x1220 */  43, 68, 36, 72,139,148, 36,136,  0,  0,  0, 15,182,  4, 16,137,
/* 0x1230 */  68, 36, 40,235, 46,137, 68, 36, 52,184,  0,  8,  0,  0, 41,216,
/* 0x1240 */ 137,251,193,248,  5,133,210,141,  4,  1,102,137,134,  0,  2,  0,
/* 0x1250 */   0, 15,133,106,  1,  0,  0,129,251,255,  0,  0,  0, 15,143,143,
/* 0x1260 */   0,  0,  0,209,100, 36, 40,139, 84, 36, 40,141, 60, 27,139, 76,
/* 0x1270 */  36, 20,129,226,  0,  1,  0,  0,129,124, 36, 52,255,255,255,  0,
/* 0x1280 */ 141,  4, 81,141, 52, 56,119, 29, 59,108, 36, 56, 15,132, 36,  7,
/* 0x1290 */   0,  0,193,100, 36, 48,  8,193,100, 36, 52,  8, 15,182, 69,  0,
/* 0x12a0 */  69,  9, 68, 36, 48,139, 68, 36, 52,102,139,142,  0,  2,  0,  0,
/* 0x12b0 */ 193,232, 11, 15,183,217, 15,175,195, 57, 68, 36, 48, 15,130,114,
/* 0x12c0 */ 255,255,255, 41, 68, 36, 52, 41, 68, 36, 48,137,200,102,193,232,
/* 0x12d0 */   5,141, 95,  1,102, 41,193,133,210,102,137,142,  0,  2,  0,  0,
/* 0x12e0 */  15,132,219,  0,  0,  0,129,251,255,  0,  0,  0, 15,142,113,255,
/* 0x12f0 */ 255,255,139, 84, 36, 24,137,223,136, 26, 66,255, 68, 36, 92,131,
/* 0x1300 */ 124, 36, 76,  3,137, 84, 36, 24, 15,143,215,  0,  0,  0,199, 68,
/* 0x1310 */  36, 76,  0,  0,  0,  0,139,132, 36,140,  0,  0,  0, 57, 68, 36,
/* 0x1320 */  92, 15,130, 63,254,255,255,129,124, 36, 52,255,255,255,  0,119,
/* 0x1330 */  12, 59,108, 36, 56,184,  1,  0,  0,  0,116, 32, 69, 43,108, 36,
/* 0x1340 */ 124,184,  0,  0,  0,  0,139,148, 36,132,  0,  0,  0,139, 92, 36,
/* 0x1350 */  92,139,140, 36,144,  0,  0,  0,137, 42,137, 25,131,196,100,233,
/* 0x1360 */  46,  8,  0,  0,129,124, 36, 52,255,255,255,  0,141, 52, 27,139,
/* 0x1370 */  68, 36, 20,141, 28,  6,119, 29, 59,108, 36, 56, 15,132, 52,  6,
/* 0x1380 */   0,  0,193,100, 36, 48,  8,193,100, 36, 52,  8, 15,182, 69,  0,
/* 0x1390 */  69,  9, 68, 36, 48,139, 68, 36, 52,102,139, 11,193,232, 11, 15,
/* 0x13a0 */ 183,209, 15,175,194, 57, 68, 36, 48,115, 79,137, 68, 36, 52,184,
/* 0x13b0 */   0,  8,  0,  0, 41,208,193,248,  5,141,  4,  1,102,137,  3,137,
/* 0x13c0 */ 243,129,251,255,  0,  0,  0,126,155,139, 84, 36, 24,137,223,136,
/* 0x13d0 */  26, 66,255, 68, 36, 92,131,124, 36, 76,  3,137, 84, 36, 24, 15,
/* 0x13e0 */ 142, 41,255,255,255,131,124, 36, 76,  9, 15,143,107,  6,  0,  0,
/* 0x13f0 */ 131,108, 36, 76,  3,233, 28,255,255,255, 41, 68, 36, 52, 41, 68,
/* 0x1400 */  36, 48,137,200,102,193,232,  5,102, 41,193,102,137, 11,141, 94,
/* 0x1410 */   1,235,174,139, 92, 36, 52, 41, 68, 36, 48, 41,195,137,208,102,
/* 0x1420 */ 193,232,  5,139, 76, 36, 76,102, 41,194,129,251,255,255,255,  0,
/* 0x1430 */ 102,137, 22,139,116, 36, 96,141, 60, 78,119, 27, 59,108, 36, 56,
/* 0x1440 */  15,132,112,  5,  0,  0,193,100, 36, 48,  8, 15,182, 69,  0,193,
/* 0x1450 */ 227,  8,  9, 68, 36, 48, 69,102,139,151,128,  1,  0,  0,137,216,
/* 0x1460 */ 193,232, 11, 15,183,202, 15,175,193, 57, 68, 36, 48, 15,131,228,
/* 0x1470 */   2,  0,  0,137,198,184,  0,  8,  0,  0, 41,200,139, 92, 36, 96,
/* 0x1480 */ 193,248,  5,131,124, 36, 76,  6,141,  4,  2,139, 76, 36, 72,139,
/* 0x1490 */  84, 36, 68,102,137,135,128,  1,  0,  0,139, 68, 36, 64,137, 76,
/* 0x14a0 */  36, 68,137, 68, 36, 60,184,  0,  0,  0,  0, 15,159,192,137, 84,
/* 0x14b0 */  36, 64,141,  4, 64,129,195,100,  6,  0,  0,137, 68, 36, 76,129,
/* 0x14c0 */ 254,255,255,255,  0,119, 27, 59,108, 36, 56, 15,132,229,  4,  0,
/* 0x14d0 */   0,193,100, 36, 48,  8, 15,182, 69,  0,193,230,  8,  9, 68, 36,
/* 0x14e0 */  48, 69,102,139, 19,137,240,193,232, 11, 15,183,202, 15,175,193,
/* 0x14f0 */  57, 68, 36, 48, 15,131,102,  3,  0,  0,137, 68, 36, 52,184,  0,
/* 0x1500 */   8,  0,  0, 41,200,193,100, 36, 44,  4,193,248,  5,139, 76, 36,
/* 0x1510 */  44,141,  4,  2,199, 68, 36, 32,  0,  0,  0,  0,102,137,  3,141,
/* 0x1520 */  92, 25,  4,137, 92, 36, 16,199, 68, 36, 36,  3,  0,  0,  0,139,
/* 0x1530 */ 124, 36, 36,186,  1,  0,  0,  0,235, 25,137, 68, 36, 52,184,  0,
/* 0x1540 */   8,  0,  0, 41,200,193,248,  5, 79,141,  4,  2,137,242,102,137,
/* 0x1550 */   3,116, 97,129,124, 36, 52,255,255,255,  0,141, 52, 18,139, 68,
/* 0x1560 */  36, 16,141, 28,  6,119, 29, 59,108, 36, 56, 15,132, 69,  4,  0,
/* 0x1570 */   0,193,100, 36, 48,  8,193,100, 36, 52,  8, 15,182, 69,  0, 69,
/* 0x1580 */   9, 68, 36, 48,139, 68, 36, 52,102,139, 19,193,232, 11, 15,183,
/* 0x1590 */ 202, 15,175,193, 57, 68, 36, 48,114,160, 41, 68, 36, 52, 41, 68,
/* 0x15a0 */  36, 48,137,208,102,193,232,  5,102, 41,194, 79,102,137, 19,141,
/* 0x15b0 */  86,  1,117,159,138, 76, 36, 36,184,  1,  0,  0,  0,211,224, 41,
/* 0x15c0 */ 194,  3, 84, 36, 32,131,124, 36, 76,  3,137, 84, 36, 12, 15,143,
/* 0x15d0 */ 254,  3,  0,  0,131, 68, 36, 76,  7,131,250,  3,137,208,126,  5,
/* 0x15e0 */ 184,  3,  0,  0,  0,139, 92, 36, 96,193,224,  7,191,  6,  0,  0,
/* 0x15f0 */   0,141,132, 24, 96,  3,  0,  0,137, 68, 36,  8,184,  1,  0,  0,
/* 0x1600 */   0,235, 25,137, 68, 36, 52,184,  0,  8,  0,  0, 41,200,193,248,
/* 0x1610 */   5, 79,141,  4,  2,102,137,  3,137,240,116, 97,129,124, 36, 52,
/* 0x1620 */ 255,255,255,  0,141, 52,  0,139, 68, 36,  8,141, 28,  6,119, 29,
/* 0x1630 */  59,108, 36, 56, 15,132,124,  3,  0,  0,193,100, 36, 48,  8,193,
/* 0x1640 */ 100, 36, 52,  8, 15,182, 69,  0, 69,  9, 68, 36, 48,139, 68, 36,
/* 0x1650 */  52,102,139, 19,193,232, 11, 15,183,202, 15,175,193, 57, 68, 36,
/* 0x1660 */  48,114,160, 41, 68, 36, 52, 41, 68, 36, 48,137,208,102,193,232,
/* 0x1670 */   5,102, 41,194, 79,102,137, 19,141, 70,  1,117,159,141, 80,192,
/* 0x1680 */ 131,250,  3,137, 84, 36,  4, 15,142, 54,  3,  0,  0,137,211,137,
/* 0x1690 */ 208,131,227,  1,209,248,131,203,  2,131,250, 13,141,120,255, 15,
/* 0x16a0 */ 143, 66,  4,  0,  0,137,249,139,116, 36, 96,211,227,  1,210,141,
/* 0x16b0 */   4, 94,137, 92, 36,  4, 41,208,  5, 94,  5,  0,  0,137,  4, 36,
/* 0x16c0 */ 184,  1,  0,  0,  0,199, 68, 36, 28,  1,  0,  0,  0,235, 33,137,
/* 0x16d0 */  68, 36, 52,184,  0,  8,  0,  0, 41,200,193,248,  5,141,  4,  2,
/* 0x16e0 */ 102,137,  3,137,240,209,100, 36, 28, 79, 15,132,211,  2,  0,  0,
/* 0x16f0 */ 129,124, 36, 52,255,255,255,  0,141, 52,  0,139, 12, 36,141, 28,
/* 0x1700 */  14,119, 29, 59,108, 36, 56, 15,132,169,  2,  0,  0,193,100, 36,
/* 0x1710 */  48,  8,193,100, 36, 52,  8, 15,182, 69,  0, 69,  9, 68, 36, 48,
/* 0x1720 */ 139, 68, 36, 52,102,139, 19,193,232, 11, 15,183,202, 15,175,193,
/* 0x1730 */  57, 68, 36, 48,114,153, 41, 68, 36, 52, 41, 68, 36, 48,137,208,
/* 0x1740 */ 102,193,232,  5,102, 41,194,141, 70,  1,102,137, 19,139, 92, 36,
/* 0x1750 */  28,  9, 92, 36,  4,235,142, 41,195, 41, 68, 36, 48,137,208,102,
/* 0x1760 */ 193,232,  5,102, 41,194,129,251,255,255,255,  0,102,137,151,128,
/* 0x1770 */   1,  0,  0, 15,134,107,  1,  0,  0,102,139,143,152,  1,  0,  0,
/* 0x1780 */ 137,218,193,234, 11, 15,183,193, 15,175,208, 57, 84, 36, 48, 15,
/* 0x1790 */ 131,134,  1,  0,  0,190,  0,  8,  0,  0,137,211, 41,198,137,240,
/* 0x17a0 */ 193,248,  5,141,  4,  1,139, 76, 36, 44,102,137,135,152,  1,  0,
/* 0x17b0 */   0,139, 68, 36, 76,193,224,  5,  3, 68, 36, 96,129,250,255,255,
/* 0x17c0 */ 255,  0,141, 60, 72,119, 27, 59,108, 36, 56, 15,132,229,  1,  0,
/* 0x17d0 */   0,193,100, 36, 48,  8, 15,182, 69,  0,193,227,  8,  9, 68, 36,
/* 0x17e0 */  48, 69,102,139,151,224,  1,  0,  0,137,216,193,232, 11, 15,183,
/* 0x17f0 */ 202, 15,175,193, 57, 68, 36, 48, 15,131,103,  2,  0,  0,137, 68,
/* 0x1800 */  36, 52,184,  0,  8,  0,  0, 41,200,193,248,  5,141,  4,  2,102,
/* 0x1810 */ 137,135,224,  1,  0,  0,139, 68, 36, 92,133,192, 15,132,148,  1,
/* 0x1820 */   0,  0,131,124, 36, 76,  6,184,  0,  0,  0,  0,139,156, 36,136,
/* 0x1830 */   0,  0,  0,139, 84, 36, 24, 15,159,192,141, 68,  0,  9,137, 68,
/* 0x1840 */  36, 76,139, 68, 36, 92, 43, 68, 36, 72, 15,182, 60, 24,137,248,
/* 0x1850 */ 136,  2, 66,255, 68, 36, 92,137, 84, 36, 24,233,182,250,255,255,
/* 0x1860 */  41,198, 41, 68, 36, 48,137,208,102,193,232,  5,102, 41,194,129,
/* 0x1870 */ 254,255,255,255,  0,102,137, 19,119, 27, 59,108, 36, 56, 15,132,
/* 0x1880 */  50,  1,  0,  0,193,100, 36, 48,  8, 15,182, 69,  0,193,230,  8,
/* 0x1890 */   9, 68, 36, 48, 69,102,139, 83,  2,137,240,193,232, 11, 15,183,
/* 0x18a0 */ 202, 15,175,193, 57, 68, 36, 48, 15,131,119,  1,  0,  0,137, 68,
/* 0x18b0 */  36, 52,184,  0,  8,  0,  0, 41,200,193,100, 36, 44,  4,193,248,
/* 0x18c0 */   5,139,116, 36, 44,141,  4,  2,199, 68, 36, 32,  8,  0,  0,  0,
/* 0x18d0 */ 102,137, 67,  2,141,156, 30,  4,  1,  0,  0,137, 92, 36, 16,233,
/* 0x18e0 */  67,252,255,255, 59,108, 36, 56, 15,132,200,  0,  0,  0,193,100,
/* 0x18f0 */  36, 48,  8,193,227,  8,102,139,143,152,  1,  0,  0, 15,182, 69,
/* 0x1900 */   0,137,218,  9, 68, 36, 48,193,234, 11, 15,183,193, 69, 15,175,
/* 0x1910 */ 208, 57, 84, 36, 48, 15,130,122,254,255,255,137,200, 41,211,102,
/* 0x1920 */ 193,232,  5, 41, 84, 36, 48,102, 41,193,129,251,255,255,255,  0,
/* 0x1930 */ 102,137,143,152,  1,  0,  0,119, 23, 59,108, 36, 56,116,119,193,
/* 0x1940 */ 100, 36, 48,  8, 15,182, 69,  0,193,227,  8,  9, 68, 36, 48, 69,
/* 0x1950 */ 102,139,151,176,  1,  0,  0,137,216,193,232, 11, 15,183,202, 15,
/* 0x1960 */ 175,193, 57, 68, 36, 48, 15,131, 22,  1,  0,  0,137,198,184,  0,
/* 0x1970 */   8,  0,  0, 41,200,193,248,  5,141,  4,  2,102,137,135,176,  1,
/* 0x1980 */   0,  0,139, 68, 36, 68,139, 84, 36, 72,137, 68, 36, 72,137, 84,
/* 0x1990 */  36, 68,131,124, 36, 76,  6,184,  0,  0,  0,  0,139, 92, 36, 96,
/* 0x19a0 */  15,159,192,129,195,104, 10,  0,  0,141, 68, 64,  8,137, 68, 36,
/* 0x19b0 */  76,233,  9,251,255,255,131,196,100,184,  1,  0,  0,  0,233,207,
/* 0x19c0 */   1,  0,  0,139,116, 36,  4, 70,137,116, 36, 72, 15,132, 85,249,
/* 0x19d0 */ 255,255,139, 76, 36, 12,139, 68, 36, 92,131,193,  2, 57, 68, 36,
/* 0x19e0 */  72,119,211,137,194,139,132, 36,136,  0,  0,  0, 43, 68, 36, 72,
/* 0x19f0 */   3,148, 36,136,  0,  0,  0,  3, 68, 36, 92, 15,182, 56, 64,137,
/* 0x1a00 */ 251,136, 26, 66,255, 68, 36, 92,255, 68, 36, 24, 73, 15,132,  3,
/* 0x1a10 */ 249,255,255,139,180, 36,140,  0,  0,  0, 57,116, 36, 92,114,219,
/* 0x1a20 */ 233,  2,249,255,255, 41,198, 41, 68, 36, 48,137,208,137,116, 36,
/* 0x1a30 */  52,102,193,232,  5,199, 68, 36, 32, 16,  0,  0,  0,102, 41,194,
/* 0x1a40 */ 199, 68, 36, 36,  8,  0,  0,  0,102,137, 83,  2,129,195,  4,  2,
/* 0x1a50 */   0,  0,137, 92, 36, 16,233,212,250,255,255,131,108, 36, 76,  6,
/* 0x1a60 */ 233,177,248,255,255,137,222, 41, 68, 36, 48, 41,198,137,208,102,
/* 0x1a70 */ 193,232,  5,102, 41,194,102,137,151,224,  1,  0,  0,233, 16,255,
/* 0x1a80 */ 255,255, 41,195, 41, 68, 36, 48,137,208,102,193,232,  5,102, 41,
/* 0x1a90 */ 194,129,251,255,255,255,  0,102,137,151,176,  1,  0,  0, 15,134,
/* 0x1aa0 */ 165,  0,  0,  0,102,139,151,200,  1,  0,  0,137,216,193,232, 11,
/* 0x1ab0 */  15,183,202, 15,175,193, 57, 68, 36, 48, 15,131,169,  0,  0,  0,
/* 0x1ac0 */ 137,198,184,  0,  8,  0,  0, 41,200,193,248,  5,141,  4,  2,102,
/* 0x1ad0 */ 137,135,200,  1,  0,  0,139, 68, 36, 64,139, 92, 36, 68,137, 92,
/* 0x1ae0 */  36, 64,233,159,254,255,255,141, 80,251,129,124, 36, 52,255,255,
/* 0x1af0 */ 255,  0,119, 29, 59,108, 36, 56, 15,132,184,254,255,255,193,100,
/* 0x1b00 */  36, 48,  8,193,100, 36, 52,  8, 15,182, 69,  0, 69,  9, 68, 36,
/* 0x1b10 */  48,209,108, 36, 52,  1,219,139, 68, 36, 52, 57, 68, 36, 48,114,
/* 0x1b20 */   7, 41, 68, 36, 48,131,203,  1, 74,117,191,139, 84, 36, 96,193,
/* 0x1b30 */ 227,  4,191,  4,  0,  0,  0,137, 92, 36,  4,129,194, 68,  6,  0,
/* 0x1b40 */   0,137, 20, 36,233,119,251,255,255, 59,108, 36, 56, 15,132, 99,
/* 0x1b50 */ 254,255,255,193,100, 36, 48,  8, 15,182, 69,  0,193,227,  8,  9,
/* 0x1b60 */  68, 36, 48, 69,233, 59,255,255,255,137,222, 41, 68, 36, 48, 41,
/* 0x1b70 */ 198,137,208,102,193,232,  5,139, 76, 36, 64,102, 41,194,139, 68,
/* 0x1b80 */  36, 60,102,137,151,200,  1,  0,  0,137, 76, 36, 60,233, 72,255,
/* 0x1b90 */ 255,255, 91, 94, 95, 93,  3,115,252,  3,123,248, 49,192,141,140,
/* 0x1ba0 */  36,  0,255,255,255,137,236, 80, 57,204,117,251,137,236, 49,201,
/* 0x1bb0 */  89, 90, 95,137,254,235, 31,138,  7, 71, 60,128,114, 10, 60,143,
/* 0x1bc0 */ 119,  6,128,127,254, 15,116,  5, 44,232, 60,  1,119,255,131,249,
/* 0x1bd0 */   4,114,  4,139,  7, 40,208,117,255,134,196,193,192, 16,134,196,
/* 0x1be0 */  41,248,  1,240,131,233,  4,171,131,233,  1,114,  4,138,  7, 71,
/* 0x1bf0 */ 235, 13,131,233,  1,115,  3, 95,185,  0,  0,  0,  0,138,  7, 71,
/* 0x1c00 */  44,232, 60,  1,119,247,128, 63,  0,117,  4,139,  7,138, 95,  4,
/* 0x1c10 */ 102,193,232,  8,134,196,193,192, 16,134,196, 41,248,128,235,232,
/* 0x1c20 */ 137,  7,131,199,  5,136,216,226,  9,185,  0,  0,  0,  0,176,232,
/* 0x1c30 */ 176,233,242,174,117,  4,128, 63,  0,117,255,139,  7,102,193,232,
/* 0x1c40 */   8,134,196,193,192, 16,134,196, 41,248,171,235,  4, 94, 95, 49,
/* 0x1c50 */ 219,203, 85, 80, 88, 33,161,216,208,213,  0,  0,  0,  0,  0,  0,
/* 0x1c60 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1c70 */   0, 45,102,105,108,101, 32,102,111,114,109, 97,116, 32,101,108,
/* 0x1c80 */ 102, 51, 50, 45,105, 51, 56, 54, 10, 10, 83,101, 99,116,105,111,
/* 0x1c90 */ 110,115, 58, 10, 73,100,120, 32, 78, 97,109,101, 32, 32, 32, 32,
/* 0x1ca0 */  32, 32, 32, 32, 32, 32, 83,105,122,101, 32, 32, 32, 32, 32, 32,
/* 0x1cb0 */  86, 77, 65, 32, 32, 32, 32, 32, 32, 32, 76, 77, 65, 32, 32, 32,
/* 0x1cc0 */  32, 32, 32, 32, 70,105,108,101, 32,111,102,102, 32, 32, 65,108,
/* 0x1cd0 */ 103,110, 32, 32, 70,108, 97,103,115, 10, 32, 32, 48, 32, 76, 73,
/* 0x1ce0 */  78, 85, 90, 86, 71, 65, 32, 32, 32, 32, 32, 32, 48, 32, 32, 48,
/* 0x1cf0 */  32, 32, 48, 32, 32, 48, 51, 52, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x1d00 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 49, 32, 76, 73, 78,
/* 0x1d10 */  85, 90, 48, 48, 48, 32, 32, 32, 32, 32, 32, 48, 57, 50, 32, 32,
/* 0x1d20 */  48, 32, 32, 48, 32, 32, 48, 51, 52, 32, 32, 50, 42, 42, 48, 32,
/* 0x1d30 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 50, 32, 76, 73,
/* 0x1d40 */  78, 85, 90, 48, 48, 49, 32, 32, 32, 32, 32, 32, 48, 53, 32, 32,
/* 0x1d50 */  48, 32, 32, 48, 32, 32, 48, 99, 54, 32, 32, 50, 42, 42, 48, 32,
/* 0x1d60 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 51, 32, 76, 73,
/* 0x1d70 */  78, 85, 90, 48, 48, 53, 32, 32, 32, 32, 32, 32, 48, 57, 32, 32,
/* 0x1d80 */  48, 32, 32, 48, 32, 32, 48, 99, 98, 32, 32, 50, 42, 42, 48, 32,
/* 0x1d90 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 52, 32, 76, 73,
/* 0x1da0 */  78, 85, 90, 48, 49, 48, 32, 32, 32, 32, 32, 32, 48, 51, 32, 32,
/* 0x1db0 */  48, 32, 32, 48, 32, 32, 48,100, 52, 32, 32, 50, 42, 42, 48, 32,
/* 0x1dc0 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 53, 32, 76, 73,
/* 0x1dd0 */  78, 85, 90, 49, 48, 49, 32, 32, 32, 32, 32, 32, 48, 53, 32, 32,
/* 0x1de0 */  48, 32, 32, 48, 32, 32, 48,100, 55, 32, 32, 50, 42, 42, 48, 32,
/* 0x1df0 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 54, 32, 76, 73,
/* 0x1e00 */  78, 85, 90, 49, 49, 48, 32, 32, 32, 32, 32, 32, 48, 50,100, 32,
/* 0x1e10 */  32, 48, 32, 32, 48, 32, 32, 48,100, 99, 32, 32, 50, 42, 42, 48,
/* 0x1e20 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 55, 32, 76,
/* 0x1e30 */  73, 78, 85, 90, 49, 50, 48, 32, 32, 32, 32, 32, 32, 48, 99, 32,
/* 0x1e40 */  32, 48, 32, 32, 48, 32, 32, 48, 49, 48, 57, 32, 32, 50, 42, 42,
/* 0x1e50 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 56, 32,
/* 0x1e60 */  76, 73, 78, 85, 90, 49, 51, 48, 32, 32, 32, 32, 32, 32, 48, 53,
/* 0x1e70 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 49, 53, 32, 32, 50, 42,
/* 0x1e80 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 57,
/* 0x1e90 */  32, 76, 73, 78, 85, 90, 49, 52, 48, 32, 32, 32, 32, 32, 32, 48,
/* 0x1ea0 */  50, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 49, 97, 32, 32,
/* 0x1eb0 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x1ec0 */  49, 48, 32, 76, 73, 78, 85, 90, 49, 52, 49, 32, 32, 32, 32, 32,
/* 0x1ed0 */  32, 48, 51, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 51, 99, 32,
/* 0x1ee0 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x1ef0 */  32, 49, 49, 32, 76, 73, 78, 85, 90, 49, 52, 53, 32, 32, 32, 32,
/* 0x1f00 */  32, 32, 48, 56, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 51,102,
/* 0x1f10 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x1f20 */  10, 32, 49, 50, 32, 76, 73, 78, 85, 90, 49, 53, 48, 32, 32, 32,
/* 0x1f30 */  32, 32, 32, 48, 50, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49,
/* 0x1f40 */  52, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x1f50 */  84, 83, 10, 32, 49, 51, 32, 76, 90, 67, 65, 76, 76, 84, 49, 32,
/* 0x1f60 */  32, 32, 32, 32, 32, 48, 49, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x1f70 */  49, 54, 57, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x1f80 */  78, 84, 83, 10, 32, 49, 52, 32, 76, 90, 67, 75, 76, 76, 84, 49,
/* 0x1f90 */  32, 32, 32, 32, 32, 32, 48, 56, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x1fa0 */  48, 49, 54, 97, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x1fb0 */  69, 78, 84, 83, 10, 32, 49, 53, 32, 76, 66, 90, 73, 77, 65, 71,
/* 0x1fc0 */  69, 32, 32, 32, 32, 32, 32, 48, 49,101, 32, 32, 48, 32, 32, 48,
/* 0x1fd0 */  32, 32, 48, 49, 55, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x1fe0 */  78, 84, 69, 78, 84, 83, 10, 32, 49, 54, 32, 76, 90, 73, 77, 65,
/* 0x1ff0 */  71, 69, 48, 32, 32, 32, 32, 32, 32, 48,102, 32, 32, 48, 32, 32,
/* 0x2000 */  48, 32, 32, 48, 49, 57, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x2010 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 55, 32, 76, 90, 67, 85,
/* 0x2020 */  84, 80, 79, 73, 32, 32, 32, 32, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x2030 */  48, 32, 32, 48, 49, 57,102, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x2040 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 56, 32, 78, 50, 66, 83,
/* 0x2050 */  77, 65, 49, 48, 32, 32, 32, 32, 32, 32, 48, 51, 32, 32, 48, 32,
/* 0x2060 */  32, 48, 32, 32, 48, 49, 57,102, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x2070 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 57, 32, 78, 50, 66,
/* 0x2080 */  70, 65, 83, 49, 48, 32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48,
/* 0x2090 */  32, 32, 48, 32, 32, 48, 49, 97, 50, 32, 32, 50, 42, 42, 48, 32,
/* 0x20a0 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 50, 48, 32, 78, 50,
/* 0x20b0 */  66, 70, 65, 83, 49, 49, 32, 32, 32, 32, 32, 32, 48, 54, 32, 32,
/* 0x20c0 */  48, 32, 32, 48, 32, 32, 48, 49, 97, 52, 32, 32, 50, 42, 42, 48,
/* 0x20d0 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 50, 49, 32, 78,
/* 0x20e0 */  50, 66, 68, 69, 67, 49, 48, 32, 32, 32, 32, 32, 32, 48, 98, 32,
/* 0x20f0 */  32, 48, 32, 32, 48, 32, 32, 48, 49, 97, 97, 32, 32, 50, 42, 42,
/* 0x2100 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 50, 50, 32,
/* 0x2110 */  78, 50, 66, 83, 77, 65, 50, 48, 32, 32, 32, 32, 32, 32, 48, 53,
/* 0x2120 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 98, 53, 32, 32, 50, 42,
/* 0x2130 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 50, 51,
/* 0x2140 */  32, 78, 50, 66, 70, 65, 83, 50, 48, 32, 32, 32, 32, 32, 32, 48,
/* 0x2150 */  57, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 98, 97, 32, 32, 50,
/* 0x2160 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 50,
/* 0x2170 */  52, 32, 78, 50, 66, 68, 69, 67, 50, 48, 32, 32, 32, 32, 32, 32,
/* 0x2180 */  48,100, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 99, 51, 32, 32,
/* 0x2190 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x21a0 */  50, 53, 32, 78, 50, 66, 83, 77, 65, 51, 48, 32, 32, 32, 32, 32,
/* 0x21b0 */  32, 48,100, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49,100, 48, 32,
/* 0x21c0 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x21d0 */  32, 50, 54, 32, 78, 50, 66, 70, 65, 83, 51, 48, 32, 32, 32, 32,
/* 0x21e0 */  32, 32, 48,102, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49,100,100,
/* 0x21f0 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x2200 */  10, 32, 50, 55, 32, 78, 50, 66, 68, 69, 67, 51, 48, 32, 32, 32,
/* 0x2210 */  32, 32, 32, 48, 51,101, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49,
/* 0x2220 */ 101, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x2230 */  84, 83, 10, 32, 50, 56, 32, 78, 50, 66, 83, 77, 65, 52, 48, 32,
/* 0x2240 */  32, 32, 32, 32, 32, 48,100, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x2250 */  50, 50, 97, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x2260 */  78, 84, 83, 10, 32, 50, 57, 32, 78, 50, 66, 70, 65, 83, 52, 48,
/* 0x2270 */  32, 32, 32, 32, 32, 32, 48,102, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x2280 */  48, 50, 51, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x2290 */  69, 78, 84, 83, 10, 32, 51, 48, 32, 78, 50, 66, 83, 77, 65, 53,
/* 0x22a0 */  48, 32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32,
/* 0x22b0 */  32, 48, 50, 52, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x22c0 */  84, 69, 78, 84, 83, 10, 32, 51, 49, 32, 78, 50, 66, 70, 65, 83,
/* 0x22d0 */  53, 48, 32, 32, 32, 32, 32, 32, 48, 51, 32, 32, 48, 32, 32, 48,
/* 0x22e0 */  32, 32, 48, 50, 52, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x22f0 */  78, 84, 69, 78, 84, 83, 10, 32, 51, 50, 32, 78, 50, 66, 68, 69,
/* 0x2300 */  67, 53, 48, 32, 32, 32, 32, 32, 32, 48, 57, 32, 32, 48, 32, 32,
/* 0x2310 */  48, 32, 32, 48, 50, 52, 98, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x2320 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 51, 51, 32, 78, 50, 66, 83,
/* 0x2330 */  77, 65, 54, 48, 32, 32, 32, 32, 32, 32, 48, 99, 32, 32, 48, 32,
/* 0x2340 */  32, 48, 32, 32, 48, 50, 53, 52, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x2350 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 51, 52, 32, 78, 50, 66,
/* 0x2360 */  70, 65, 83, 54, 48, 32, 32, 32, 32, 32, 32, 48, 49, 57, 32, 32,
/* 0x2370 */  48, 32, 32, 48, 32, 32, 48, 50, 54, 48, 32, 32, 50, 42, 42, 48,
/* 0x2380 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 51, 53, 32, 78,
/* 0x2390 */  50, 66, 70, 65, 83, 54, 49, 32, 32, 32, 32, 32, 32, 48, 49, 54,
/* 0x23a0 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 50, 55, 57, 32, 32, 50, 42,
/* 0x23b0 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 51, 54,
/* 0x23c0 */  32, 78, 50, 66, 68, 69, 67, 54, 48, 32, 32, 32, 32, 32, 32, 48,
/* 0x23d0 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 50, 56,102, 32, 32, 50, 42,
/* 0x23e0 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 51, 55,
/* 0x23f0 */  32, 78, 50, 68, 83, 77, 65, 49, 48, 32, 32, 32, 32, 32, 32, 48,
/* 0x2400 */  51, 32, 32, 48, 32, 32, 48, 32, 32, 48, 50, 56,102, 32, 32, 50,
/* 0x2410 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 51,
/* 0x2420 */  56, 32, 78, 50, 68, 70, 65, 83, 49, 48, 32, 32, 32, 32, 32, 32,
/* 0x2430 */  48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 50, 57, 50, 32, 32,
/* 0x2440 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x2450 */  51, 57, 32, 78, 50, 68, 70, 65, 83, 49, 49, 32, 32, 32, 32, 32,
/* 0x2460 */  32, 48, 54, 32, 32, 48, 32, 32, 48, 32, 32, 48, 50, 57, 52, 32,
/* 0x2470 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x2480 */  32, 52, 48, 32, 78, 50, 68, 68, 69, 67, 49, 48, 32, 32, 32, 32,
/* 0x2490 */  32, 32, 48, 98, 32, 32, 48, 32, 32, 48, 32, 32, 48, 50, 57, 97,
/* 0x24a0 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x24b0 */  10, 32, 52, 49, 32, 78, 50, 68, 83, 77, 65, 50, 48, 32, 32, 32,
/* 0x24c0 */  32, 32, 32, 48, 53, 32, 32, 48, 32, 32, 48, 32, 32, 48, 50, 97,
/* 0x24d0 */  53, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x24e0 */  83, 10, 32, 52, 50, 32, 78, 50, 68, 70, 65, 83, 50, 48, 32, 32,
/* 0x24f0 */  32, 32, 32, 32, 48, 57, 32, 32, 48, 32, 32, 48, 32, 32, 48, 50,
/* 0x2500 */  97, 97, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x2510 */  84, 83, 10, 32, 52, 51, 32, 78, 50, 68, 68, 69, 67, 50, 48, 32,
/* 0x2520 */  32, 32, 32, 32, 32, 48,100, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x2530 */  50, 98, 51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x2540 */  78, 84, 83, 10, 32, 52, 52, 32, 78, 50, 68, 83, 77, 65, 51, 48,
/* 0x2550 */  32, 32, 32, 32, 32, 32, 48,100, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x2560 */  48, 50, 99, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x2570 */  69, 78, 84, 83, 10, 32, 52, 53, 32, 78, 50, 68, 70, 65, 83, 51,
/* 0x2580 */  48, 32, 32, 32, 32, 32, 32, 48,102, 32, 32, 48, 32, 32, 48, 32,
/* 0x2590 */  32, 48, 50, 99,100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x25a0 */  84, 69, 78, 84, 83, 10, 32, 52, 54, 32, 78, 50, 68, 68, 69, 67,
/* 0x25b0 */  51, 48, 32, 32, 32, 32, 32, 32, 48, 53, 50, 32, 32, 48, 32, 32,
/* 0x25c0 */  48, 32, 32, 48, 50,100, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x25d0 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 52, 55, 32, 78, 50, 68, 83,
/* 0x25e0 */  77, 65, 52, 48, 32, 32, 32, 32, 32, 32, 48,100, 32, 32, 48, 32,
/* 0x25f0 */  32, 48, 32, 32, 48, 51, 50,101, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x2600 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 52, 56, 32, 78, 50, 68,
/* 0x2610 */  70, 65, 83, 52, 48, 32, 32, 32, 32, 32, 32, 48,102, 32, 32, 48,
/* 0x2620 */  32, 32, 48, 32, 32, 48, 51, 51, 98, 32, 32, 50, 42, 42, 48, 32,
/* 0x2630 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 52, 57, 32, 78, 50,
/* 0x2640 */  68, 83, 77, 65, 53, 48, 32, 32, 32, 32, 32, 32, 48, 50, 32, 32,
/* 0x2650 */  48, 32, 32, 48, 32, 32, 48, 51, 52, 97, 32, 32, 50, 42, 42, 48,
/* 0x2660 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 53, 48, 32, 78,
/* 0x2670 */  50, 68, 70, 65, 83, 53, 48, 32, 32, 32, 32, 32, 32, 48, 51, 32,
/* 0x2680 */  32, 48, 32, 32, 48, 32, 32, 48, 51, 52, 99, 32, 32, 50, 42, 42,
/* 0x2690 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 53, 49, 32,
/* 0x26a0 */  78, 50, 68, 68, 69, 67, 53, 48, 32, 32, 32, 32, 32, 32, 48, 57,
/* 0x26b0 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 51, 52,102, 32, 32, 50, 42,
/* 0x26c0 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 53, 50,
/* 0x26d0 */  32, 78, 50, 68, 83, 77, 65, 54, 48, 32, 32, 32, 32, 32, 32, 48,
/* 0x26e0 */  99, 32, 32, 48, 32, 32, 48, 32, 32, 48, 51, 53, 56, 32, 32, 50,
/* 0x26f0 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 53,
/* 0x2700 */  51, 32, 78, 50, 68, 70, 65, 83, 54, 48, 32, 32, 32, 32, 32, 32,
/* 0x2710 */  48, 49, 57, 32, 32, 48, 32, 32, 48, 32, 32, 48, 51, 54, 52, 32,
/* 0x2720 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x2730 */  32, 53, 52, 32, 78, 50, 68, 70, 65, 83, 54, 49, 32, 32, 32, 32,
/* 0x2740 */  32, 32, 48, 49, 54, 32, 32, 48, 32, 32, 48, 32, 32, 48, 51, 55,
/* 0x2750 */ 100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x2760 */  83, 10, 32, 53, 53, 32, 78, 50, 68, 68, 69, 67, 54, 48, 32, 32,
/* 0x2770 */  32, 32, 32, 32, 48, 32, 32, 48, 32, 32, 48, 32, 32, 48, 51, 57,
/* 0x2780 */  51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x2790 */  83, 10, 32, 53, 54, 32, 78, 50, 69, 83, 77, 65, 49, 48, 32, 32,
/* 0x27a0 */  32, 32, 32, 32, 48, 51, 32, 32, 48, 32, 32, 48, 32, 32, 48, 51,
/* 0x27b0 */  57, 51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x27c0 */  84, 83, 10, 32, 53, 55, 32, 78, 50, 69, 70, 65, 83, 49, 48, 32,
/* 0x27d0 */  32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x27e0 */  51, 57, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x27f0 */  78, 84, 83, 10, 32, 53, 56, 32, 78, 50, 69, 70, 65, 83, 49, 49,
/* 0x2800 */  32, 32, 32, 32, 32, 32, 48, 54, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x2810 */  48, 51, 57, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x2820 */  69, 78, 84, 83, 10, 32, 53, 57, 32, 78, 50, 69, 68, 69, 67, 49,
/* 0x2830 */  48, 32, 32, 32, 32, 32, 32, 48, 98, 32, 32, 48, 32, 32, 48, 32,
/* 0x2840 */  32, 48, 51, 57,101, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x2850 */  84, 69, 78, 84, 83, 10, 32, 54, 48, 32, 78, 50, 69, 83, 77, 65,
/* 0x2860 */  50, 48, 32, 32, 32, 32, 32, 32, 48, 53, 32, 32, 48, 32, 32, 48,
/* 0x2870 */  32, 32, 48, 51, 97, 57, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x2880 */  78, 84, 69, 78, 84, 83, 10, 32, 54, 49, 32, 78, 50, 69, 70, 65,
/* 0x2890 */  83, 50, 48, 32, 32, 32, 32, 32, 32, 48, 57, 32, 32, 48, 32, 32,
/* 0x28a0 */  48, 32, 32, 48, 51, 97,101, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x28b0 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 54, 50, 32, 78, 50, 69, 68,
/* 0x28c0 */  69, 67, 50, 48, 32, 32, 32, 32, 32, 32, 48,100, 32, 32, 48, 32,
/* 0x28d0 */  32, 48, 32, 32, 48, 51, 98, 55, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x28e0 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 54, 51, 32, 78, 50, 69,
/* 0x28f0 */  83, 77, 65, 51, 48, 32, 32, 32, 32, 32, 32, 48,100, 32, 32, 48,
/* 0x2900 */  32, 32, 48, 32, 32, 48, 51, 99, 52, 32, 32, 50, 42, 42, 48, 32,
/* 0x2910 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 54, 52, 32, 78, 50,
/* 0x2920 */  69, 70, 65, 83, 51, 48, 32, 32, 32, 32, 32, 32, 48,102, 32, 32,
/* 0x2930 */  48, 32, 32, 48, 32, 32, 48, 51,100, 49, 32, 32, 50, 42, 42, 48,
/* 0x2940 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 54, 53, 32, 78,
/* 0x2950 */  50, 69, 68, 69, 67, 51, 48, 32, 32, 32, 32, 32, 32, 48, 53,102,
/* 0x2960 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 51,101, 48, 32, 32, 50, 42,
/* 0x2970 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 54, 54,
/* 0x2980 */  32, 78, 50, 69, 83, 77, 65, 52, 48, 32, 32, 32, 32, 32, 32, 48,
/* 0x2990 */ 100, 32, 32, 48, 32, 32, 48, 32, 32, 48, 52, 51,102, 32, 32, 50,
/* 0x29a0 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 54,
/* 0x29b0 */  55, 32, 78, 50, 69, 70, 65, 83, 52, 48, 32, 32, 32, 32, 32, 32,
/* 0x29c0 */  48,102, 32, 32, 48, 32, 32, 48, 32, 32, 48, 52, 52, 99, 32, 32,
/* 0x29d0 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x29e0 */  54, 56, 32, 78, 50, 69, 83, 77, 65, 53, 48, 32, 32, 32, 32, 32,
/* 0x29f0 */  32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 52, 53, 98, 32,
/* 0x2a00 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x2a10 */  32, 54, 57, 32, 78, 50, 69, 70, 65, 83, 53, 48, 32, 32, 32, 32,
/* 0x2a20 */  32, 32, 48, 51, 32, 32, 48, 32, 32, 48, 32, 32, 48, 52, 53,100,
/* 0x2a30 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x2a40 */  10, 32, 55, 48, 32, 78, 50, 69, 68, 69, 67, 53, 48, 32, 32, 32,
/* 0x2a50 */  32, 32, 32, 48, 57, 32, 32, 48, 32, 32, 48, 32, 32, 48, 52, 54,
/* 0x2a60 */  48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x2a70 */  83, 10, 32, 55, 49, 32, 78, 50, 69, 83, 77, 65, 54, 48, 32, 32,
/* 0x2a80 */  32, 32, 32, 32, 48, 99, 32, 32, 48, 32, 32, 48, 32, 32, 48, 52,
/* 0x2a90 */  54, 57, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x2aa0 */  84, 83, 10, 32, 55, 50, 32, 78, 50, 69, 70, 65, 83, 54, 48, 32,
/* 0x2ab0 */  32, 32, 32, 32, 32, 48, 49, 57, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x2ac0 */  48, 52, 55, 53, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x2ad0 */  69, 78, 84, 83, 10, 32, 55, 51, 32, 78, 50, 69, 70, 65, 83, 54,
/* 0x2ae0 */  49, 32, 32, 32, 32, 32, 32, 48, 49, 54, 32, 32, 48, 32, 32, 48,
/* 0x2af0 */  32, 32, 48, 52, 56,101, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x2b00 */  78, 84, 69, 78, 84, 83, 10, 32, 55, 52, 32, 78, 50, 69, 68, 69,
/* 0x2b10 */  67, 54, 48, 32, 32, 32, 32, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x2b20 */  32, 32, 48, 52, 97, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x2b30 */  78, 84, 69, 78, 84, 83, 10, 32, 55, 53, 32, 76, 90, 77, 65, 95,
/* 0x2b40 */  68, 69, 67, 48, 48, 32, 32, 32, 32, 48, 50,101, 32, 32, 48, 32,
/* 0x2b50 */  32, 48, 32, 32, 48, 52, 97, 52, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x2b60 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 55, 54, 32, 76, 90, 77,
/* 0x2b70 */  65, 95, 69, 76, 70, 48, 48, 32, 32, 32, 32, 48, 52, 56, 32, 32,
/* 0x2b80 */  48, 32, 32, 48, 32, 32, 48, 52,100, 50, 32, 32, 50, 42, 42, 48,
/* 0x2b90 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 55, 55, 32, 76,
/* 0x2ba0 */  90, 77, 65, 95, 68, 69, 67, 49, 48, 32, 32, 32, 32, 48, 98, 51,
/* 0x2bb0 */ 101, 32, 32, 48, 32, 32, 48, 32, 32, 48, 53, 49, 97, 32, 32, 50,
/* 0x2bc0 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 55,
/* 0x2bd0 */  56, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 32, 32, 32, 32,
/* 0x2be0 */  48, 98, 51,101, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 48, 53,
/* 0x2bf0 */  56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x2c00 */  83, 10, 32, 55, 57, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48,
/* 0x2c10 */  32, 32, 32, 32, 48, 49, 97, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x2c20 */  49, 98, 57, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x2c30 */  69, 78, 84, 83, 10, 32, 56, 48, 32, 76, 90, 67, 75, 76, 76, 84,
/* 0x2c40 */  57, 32, 32, 32, 32, 32, 32, 48, 51, 32, 32, 48, 32, 32, 48, 32,
/* 0x2c50 */  32, 48, 49, 98, 98, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x2c60 */  78, 84, 69, 78, 84, 83, 10, 32, 56, 49, 32, 99,116,111,107, 51,
/* 0x2c70 */  50, 46, 48, 48, 32, 32, 32, 32, 32, 48, 55, 32, 32, 48, 32, 32,
/* 0x2c80 */  48, 32, 32, 48, 49, 98, 98, 51, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x2c90 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 56, 50, 32, 99,116,111,
/* 0x2ca0 */ 107, 51, 50, 46, 49, 48, 32, 32, 32, 32, 32, 48,101, 32, 32, 48,
/* 0x2cb0 */  32, 32, 48, 32, 32, 48, 49, 98, 98, 97, 32, 32, 50, 42, 42, 48,
/* 0x2cc0 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 56, 51, 32, 99,
/* 0x2cd0 */ 116,111,107, 51, 50, 46, 50, 48, 32, 32, 32, 32, 32, 48, 50, 48,
/* 0x2ce0 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 98, 99, 56, 32, 32, 50,
/* 0x2cf0 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 56,
/* 0x2d00 */  52, 32, 99,116,111,107, 51, 50, 46, 51, 48, 32, 32, 32, 32, 32,
/* 0x2d10 */  48, 97, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 98,101, 56, 32,
/* 0x2d20 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x2d30 */  32, 56, 53, 32, 99,116,111,107, 51, 50, 46, 52, 48, 32, 32, 32,
/* 0x2d40 */  32, 32, 48, 53, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 98,102,
/* 0x2d50 */  50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x2d60 */  83, 10, 32, 56, 54, 32, 76, 90, 67, 65, 76, 76, 84, 57, 32, 32,
/* 0x2d70 */  32, 32, 32, 32, 48, 49, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49,
/* 0x2d80 */  98,102, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x2d90 */  78, 84, 83, 10, 32, 56, 55, 32, 67, 65, 76, 76, 84, 82, 48, 48,
/* 0x2da0 */  32, 32, 32, 32, 32, 32, 48,101, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x2db0 */  48, 49, 98,102, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x2dc0 */  84, 69, 78, 84, 83, 10, 32, 56, 56, 32, 67, 84, 67, 76, 69, 86,
/* 0x2dd0 */  69, 49, 32, 32, 32, 32, 32, 32, 48, 53, 32, 32, 48, 32, 32, 48,
/* 0x2de0 */  32, 32, 48, 49, 99, 48, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x2df0 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 56, 57, 32, 67, 65, 76, 76,
/* 0x2e00 */  84, 82, 48, 49, 32, 32, 32, 32, 32, 32, 48, 53, 32, 32, 48, 32,
/* 0x2e10 */  32, 48, 32, 32, 48, 49, 99, 48, 98, 32, 32, 50, 42, 42, 48, 32,
/* 0x2e20 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 57, 48, 32, 67, 84,
/* 0x2e30 */  66, 83, 72, 82, 48, 49, 32, 32, 32, 32, 32, 32, 48, 52, 32, 32,
/* 0x2e40 */  48, 32, 32, 48, 32, 32, 48, 49, 99, 49, 48, 32, 32, 50, 42, 42,
/* 0x2e50 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 57, 49, 32,
/* 0x2e60 */  67, 84, 66, 82, 79, 82, 48, 49, 32, 32, 32, 32, 32, 32, 48, 50,
/* 0x2e70 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 99, 49, 52, 32, 32, 50,
/* 0x2e80 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 57,
/* 0x2e90 */  50, 32, 67, 84, 66, 83, 87, 65, 48, 49, 32, 32, 32, 32, 32, 32,
/* 0x2ea0 */  48, 53, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 99, 49, 54, 32,
/* 0x2eb0 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x2ec0 */  32, 57, 51, 32, 67, 65, 76, 76, 84, 82, 48, 50, 32, 32, 32, 32,
/* 0x2ed0 */  32, 32, 48,101, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 99, 49,
/* 0x2ee0 */  98, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x2ef0 */  83, 10, 32, 57, 52, 32, 67, 65, 76, 76, 84, 82, 49, 48, 32, 32,
/* 0x2f00 */  32, 32, 32, 32, 48, 53, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49,
/* 0x2f10 */  99, 50, 57, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x2f20 */  78, 84, 83, 10, 32, 57, 53, 32, 67, 65, 76, 76, 84, 82, 69, 56,
/* 0x2f30 */  32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x2f40 */  48, 49, 99, 50,101, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x2f50 */  84, 69, 78, 84, 83, 10, 32, 57, 54, 32, 67, 65, 76, 76, 84, 82,
/* 0x2f60 */  69, 57, 32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48,
/* 0x2f70 */  32, 32, 48, 49, 99, 51, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x2f80 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 57, 55, 32, 67, 65, 76, 76,
/* 0x2f90 */  84, 82, 49, 49, 32, 32, 32, 32, 32, 32, 48, 52, 32, 32, 48, 32,
/* 0x2fa0 */  32, 48, 32, 32, 48, 49, 99, 51, 50, 32, 32, 50, 42, 42, 48, 32,
/* 0x2fb0 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 57, 56, 32, 67, 84,
/* 0x2fc0 */  67, 76, 69, 86, 69, 50, 32, 32, 32, 32, 32, 32, 48, 53, 32, 32,
/* 0x2fd0 */  48, 32, 32, 48, 32, 32, 48, 49, 99, 51, 54, 32, 32, 50, 42, 42,
/* 0x2fe0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 57, 57, 32,
/* 0x2ff0 */  67, 65, 76, 76, 84, 82, 49, 50, 32, 32, 32, 32, 32, 32, 48, 50,
/* 0x3000 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 99, 51, 98, 32, 32, 50,
/* 0x3010 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 48,
/* 0x3020 */  48, 32, 67, 84, 66, 83, 72, 82, 49, 49, 32, 32, 32, 32, 32, 32,
/* 0x3030 */  48, 52, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 99, 51,100, 32,
/* 0x3040 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x3050 */  49, 48, 49, 32, 67, 84, 66, 82, 79, 82, 49, 49, 32, 32, 32, 32,
/* 0x3060 */  32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 99, 52,
/* 0x3070 */  49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x3080 */  83, 10, 49, 48, 50, 32, 67, 84, 66, 83, 87, 65, 49, 49, 32, 32,
/* 0x3090 */  32, 32, 32, 32, 48, 53, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49,
/* 0x30a0 */  99, 52, 51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x30b0 */  78, 84, 83, 10, 49, 48, 51, 32, 67, 65, 76, 76, 84, 82, 49, 51,
/* 0x30c0 */  32, 32, 32, 32, 32, 32, 48, 53, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x30d0 */  48, 49, 99, 52, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x30e0 */  84, 69, 78, 84, 83, 10, 49, 48, 52, 32, 76, 73, 78, 85, 90, 57,
/* 0x30f0 */  57, 48, 32, 32, 32, 32, 32, 32, 48, 53, 32, 32, 48, 32, 32, 48,
/* 0x3100 */  32, 32, 48, 49, 99, 52,100, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x3110 */  79, 78, 84, 69, 78, 84, 83, 10, 49, 48, 53, 32, 85, 80, 88, 49,
/* 0x3120 */  72, 69, 65, 68, 32, 32, 32, 32, 32, 32, 48, 50, 48, 32, 32, 48,
/* 0x3130 */  32, 32, 48, 32, 32, 48, 49, 99, 53, 50, 32, 32, 50, 42, 42, 48,
/* 0x3140 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 83, 89, 77, 66, 79,
/* 0x3150 */  76, 32, 84, 65, 66, 76, 69, 58, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3160 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 83, 77, 65,
/* 0x3170 */  49, 48, 32, 48, 32, 78, 50, 66, 83, 77, 65, 49, 48, 10, 48, 48,
/* 0x3180 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,
/* 0x3190 */  50, 66, 70, 65, 83, 49, 49, 32, 48, 32, 78, 50, 66, 70, 65, 83,
/* 0x31a0 */  49, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x31b0 */  32,100, 32, 32, 78, 50, 66, 68, 69, 67, 49, 48, 32, 48, 32, 78,
/* 0x31c0 */  50, 66, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x31d0 */  32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 68, 69, 67, 50,
/* 0x31e0 */  48, 32, 48, 32, 78, 50, 66, 68, 69, 67, 50, 48, 10, 48, 48, 48,
/* 0x31f0 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50,
/* 0x3200 */  66, 68, 69, 67, 51, 48, 32, 48, 32, 78, 50, 66, 68, 69, 67, 51,
/* 0x3210 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x3220 */ 100, 32, 32, 78, 50, 66, 68, 69, 67, 53, 48, 32, 48, 32, 78, 50,
/* 0x3230 */  66, 68, 69, 67, 53, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3240 */ 108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 70, 65, 83, 54, 49,
/* 0x3250 */  32, 48, 32, 78, 50, 66, 70, 65, 83, 54, 49, 10, 48, 48, 48, 48,
/* 0x3260 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66,
/* 0x3270 */  68, 69, 67, 54, 48, 32, 48, 32, 78, 50, 66, 68, 69, 67, 54, 48,
/* 0x3280 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x3290 */  32, 32, 78, 50, 68, 83, 77, 65, 49, 48, 32, 48, 32, 78, 50, 68,
/* 0x32a0 */  83, 77, 65, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x32b0 */  32, 32, 32, 32,100, 32, 32, 78, 50, 68, 70, 65, 83, 49, 49, 32,
/* 0x32c0 */  48, 32, 78, 50, 68, 70, 65, 83, 49, 49, 10, 48, 48, 48, 48, 48,
/* 0x32d0 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 68,
/* 0x32e0 */  69, 67, 49, 48, 32, 48, 32, 78, 50, 68, 68, 69, 67, 49, 48, 10,
/* 0x32f0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x3300 */  32, 78, 50, 68, 68, 69, 67, 50, 48, 32, 48, 32, 78, 50, 68, 68,
/* 0x3310 */  69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x3320 */  32, 32, 32,100, 32, 32, 78, 50, 68, 68, 69, 67, 51, 48, 32, 48,
/* 0x3330 */  32, 78, 50, 68, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x3340 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 68, 69,
/* 0x3350 */  67, 53, 48, 32, 48, 32, 78, 50, 68, 68, 69, 67, 53, 48, 10, 48,
/* 0x3360 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x3370 */  78, 50, 68, 70, 65, 83, 54, 49, 32, 48, 32, 78, 50, 68, 70, 65,
/* 0x3380 */  83, 54, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x3390 */  32, 32,100, 32, 32, 78, 50, 68, 68, 69, 67, 54, 48, 32, 48, 32,
/* 0x33a0 */  78, 50, 68, 68, 69, 67, 54, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x33b0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 83, 77, 65,
/* 0x33c0 */  49, 48, 32, 48, 32, 78, 50, 69, 83, 77, 65, 49, 48, 10, 48, 48,
/* 0x33d0 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,
/* 0x33e0 */  50, 69, 70, 65, 83, 49, 49, 32, 48, 32, 78, 50, 69, 70, 65, 83,
/* 0x33f0 */  49, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x3400 */  32,100, 32, 32, 78, 50, 69, 68, 69, 67, 49, 48, 32, 48, 32, 78,
/* 0x3410 */  50, 69, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3420 */  32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 68, 69, 67, 50,
/* 0x3430 */  48, 32, 48, 32, 78, 50, 69, 68, 69, 67, 50, 48, 10, 48, 48, 48,
/* 0x3440 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50,
/* 0x3450 */  69, 68, 69, 67, 51, 48, 32, 48, 32, 78, 50, 69, 68, 69, 67, 51,
/* 0x3460 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x3470 */ 100, 32, 32, 78, 50, 69, 68, 69, 67, 53, 48, 32, 48, 32, 78, 50,
/* 0x3480 */  69, 68, 69, 67, 53, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3490 */ 108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 70, 65, 83, 54, 49,
/* 0x34a0 */  32, 48, 32, 78, 50, 69, 70, 65, 83, 54, 49, 10, 48, 48, 48, 48,
/* 0x34b0 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69,
/* 0x34c0 */  68, 69, 67, 54, 48, 32, 48, 32, 78, 50, 69, 68, 69, 67, 54, 48,
/* 0x34d0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x34e0 */  32, 32, 99,116,111,107, 51, 50, 46, 48, 48, 32, 48, 32, 99,116,
/* 0x34f0 */ 111,107, 51, 50, 46, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3500 */  32,108, 32, 32, 32, 32,100, 32, 32, 99,116,111,107, 51, 50, 46,
/* 0x3510 */  49, 48, 32, 48, 32, 99,116,111,107, 51, 50, 46, 49, 48, 10, 48,
/* 0x3520 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x3530 */  99,116,111,107, 51, 50, 46, 50, 48, 32, 48, 32, 99,116,111,107,
/* 0x3540 */  51, 50, 46, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x3550 */  32, 32, 32, 32,100, 32, 32, 99,116,111,107, 51, 50, 46, 52, 48,
/* 0x3560 */  32, 48, 32, 99,116,111,107, 51, 50, 46, 52, 48, 10, 48, 48, 48,
/* 0x3570 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 65,
/* 0x3580 */  76, 76, 84, 82, 48, 48, 32, 48, 32, 67, 65, 76, 76, 84, 82, 48,
/* 0x3590 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x35a0 */ 100, 32, 32, 67, 65, 76, 76, 84, 82, 49, 48, 32, 48, 32, 67, 65,
/* 0x35b0 */  76, 76, 84, 82, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x35c0 */ 108, 32, 32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84, 82, 49, 49,
/* 0x35d0 */  32, 48, 32, 67, 65, 76, 76, 84, 82, 49, 49, 10, 48, 48, 48, 48,
/* 0x35e0 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 65, 76,
/* 0x35f0 */  76, 84, 82, 49, 51, 32, 48, 32, 67, 65, 76, 76, 84, 82, 49, 51,
/* 0x3600 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x3610 */  32, 32, 76, 73, 78, 85, 90, 86, 71, 65, 32, 48, 32, 76, 73, 78,
/* 0x3620 */  85, 90, 86, 71, 65, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x3630 */  32, 32, 32, 32,100, 32, 32, 76, 73, 78, 85, 90, 48, 48, 48, 32,
/* 0x3640 */  48, 32, 76, 73, 78, 85, 90, 48, 48, 48, 10, 48, 48, 48, 48, 48,
/* 0x3650 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 73, 78, 85,
/* 0x3660 */  90, 48, 48, 49, 32, 48, 32, 76, 73, 78, 85, 90, 48, 48, 49, 10,
/* 0x3670 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x3680 */  32, 76, 73, 78, 85, 90, 48, 48, 53, 32, 48, 32, 76, 73, 78, 85,
/* 0x3690 */  90, 48, 48, 53, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x36a0 */  32, 32, 32,100, 32, 32, 76, 73, 78, 85, 90, 48, 49, 48, 32, 48,
/* 0x36b0 */  32, 76, 73, 78, 85, 90, 48, 49, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x36c0 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 73, 78, 85, 90,
/* 0x36d0 */  49, 48, 49, 32, 48, 32, 76, 73, 78, 85, 90, 49, 48, 49, 10, 48,
/* 0x36e0 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x36f0 */  76, 73, 78, 85, 90, 49, 49, 48, 32, 48, 32, 76, 73, 78, 85, 90,
/* 0x3700 */  49, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x3710 */  32, 32,100, 32, 32, 76, 73, 78, 85, 90, 49, 50, 48, 32, 48, 32,
/* 0x3720 */  76, 73, 78, 85, 90, 49, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3730 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 73, 78, 85, 90, 49,
/* 0x3740 */  51, 48, 32, 48, 32, 76, 73, 78, 85, 90, 49, 51, 48, 10, 48, 48,
/* 0x3750 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76,
/* 0x3760 */  73, 78, 85, 90, 49, 52, 48, 32, 48, 32, 76, 73, 78, 85, 90, 49,
/* 0x3770 */  52, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x3780 */  32,100, 32, 32, 76, 73, 78, 85, 90, 49, 52, 49, 32, 48, 32, 76,
/* 0x3790 */  73, 78, 85, 90, 49, 52, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x37a0 */  32,108, 32, 32, 32, 32,100, 32, 32, 76, 73, 78, 85, 90, 49, 52,
/* 0x37b0 */  53, 32, 48, 32, 76, 73, 78, 85, 90, 49, 52, 53, 10, 48, 48, 48,
/* 0x37c0 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 73,
/* 0x37d0 */  78, 85, 90, 49, 53, 48, 32, 48, 32, 76, 73, 78, 85, 90, 49, 53,
/* 0x37e0 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x37f0 */ 100, 32, 32, 76, 90, 67, 65, 76, 76, 84, 49, 32, 48, 32, 76, 90,
/* 0x3800 */  67, 65, 76, 76, 84, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3810 */ 108, 32, 32, 32, 32,100, 32, 32, 76, 90, 67, 75, 76, 76, 84, 49,
/* 0x3820 */  32, 48, 32, 76, 90, 67, 75, 76, 76, 84, 49, 10, 48, 48, 48, 48,
/* 0x3830 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 66, 90,
/* 0x3840 */  73, 77, 65, 71, 69, 32, 48, 32, 76, 66, 90, 73, 77, 65, 71, 69,
/* 0x3850 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x3860 */  32, 32, 76, 90, 73, 77, 65, 71, 69, 48, 32, 48, 32, 76, 90, 73,
/* 0x3870 */  77, 65, 71, 69, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x3880 */  32, 32, 32, 32,100, 32, 32, 76, 90, 67, 85, 84, 80, 79, 73, 32,
/* 0x3890 */  48, 32, 76, 90, 67, 85, 84, 80, 79, 73, 10, 48, 48, 48, 48, 48,
/* 0x38a0 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 70,
/* 0x38b0 */  65, 83, 49, 48, 32, 48, 32, 78, 50, 66, 70, 65, 83, 49, 48, 10,
/* 0x38c0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x38d0 */  32, 78, 50, 66, 83, 77, 65, 50, 48, 32, 48, 32, 78, 50, 66, 83,
/* 0x38e0 */  77, 65, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x38f0 */  32, 32, 32,100, 32, 32, 78, 50, 66, 70, 65, 83, 50, 48, 32, 48,
/* 0x3900 */  32, 78, 50, 66, 70, 65, 83, 50, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x3910 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 83, 77,
/* 0x3920 */  65, 51, 48, 32, 48, 32, 78, 50, 66, 83, 77, 65, 51, 48, 10, 48,
/* 0x3930 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x3940 */  78, 50, 66, 70, 65, 83, 51, 48, 32, 48, 32, 78, 50, 66, 70, 65,
/* 0x3950 */  83, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x3960 */  32, 32,100, 32, 32, 78, 50, 66, 83, 77, 65, 52, 48, 32, 48, 32,
/* 0x3970 */  78, 50, 66, 83, 77, 65, 52, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3980 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 70, 65, 83,
/* 0x3990 */  52, 48, 32, 48, 32, 78, 50, 66, 70, 65, 83, 52, 48, 10, 48, 48,
/* 0x39a0 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,
/* 0x39b0 */  50, 66, 83, 77, 65, 53, 48, 32, 48, 32, 78, 50, 66, 83, 77, 65,
/* 0x39c0 */  53, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x39d0 */  32,100, 32, 32, 78, 50, 66, 70, 65, 83, 53, 48, 32, 48, 32, 78,
/* 0x39e0 */  50, 66, 70, 65, 83, 53, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x39f0 */  32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 83, 77, 65, 54,
/* 0x3a00 */  48, 32, 48, 32, 78, 50, 66, 83, 77, 65, 54, 48, 10, 48, 48, 48,
/* 0x3a10 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50,
/* 0x3a20 */  66, 70, 65, 83, 54, 48, 32, 48, 32, 78, 50, 66, 70, 65, 83, 54,
/* 0x3a30 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x3a40 */ 100, 32, 32, 78, 50, 68, 70, 65, 83, 49, 48, 32, 48, 32, 78, 50,
/* 0x3a50 */  68, 70, 65, 83, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3a60 */ 108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 83, 77, 65, 50, 48,
/* 0x3a70 */  32, 48, 32, 78, 50, 68, 83, 77, 65, 50, 48, 10, 48, 48, 48, 48,
/* 0x3a80 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68,
/* 0x3a90 */  70, 65, 83, 50, 48, 32, 48, 32, 78, 50, 68, 70, 65, 83, 50, 48,
/* 0x3aa0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x3ab0 */  32, 32, 78, 50, 68, 83, 77, 65, 51, 48, 32, 48, 32, 78, 50, 68,
/* 0x3ac0 */  83, 77, 65, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x3ad0 */  32, 32, 32, 32,100, 32, 32, 78, 50, 68, 70, 65, 83, 51, 48, 32,
/* 0x3ae0 */  48, 32, 78, 50, 68, 70, 65, 83, 51, 48, 10, 48, 48, 48, 48, 48,
/* 0x3af0 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 83,
/* 0x3b00 */  77, 65, 52, 48, 32, 48, 32, 78, 50, 68, 83, 77, 65, 52, 48, 10,
/* 0x3b10 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x3b20 */  32, 78, 50, 68, 70, 65, 83, 52, 48, 32, 48, 32, 78, 50, 68, 70,
/* 0x3b30 */  65, 83, 52, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x3b40 */  32, 32, 32,100, 32, 32, 78, 50, 68, 83, 77, 65, 53, 48, 32, 48,
/* 0x3b50 */  32, 78, 50, 68, 83, 77, 65, 53, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x3b60 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 70, 65,
/* 0x3b70 */  83, 53, 48, 32, 48, 32, 78, 50, 68, 70, 65, 83, 53, 48, 10, 48,
/* 0x3b80 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x3b90 */  78, 50, 68, 83, 77, 65, 54, 48, 32, 48, 32, 78, 50, 68, 83, 77,
/* 0x3ba0 */  65, 54, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x3bb0 */  32, 32,100, 32, 32, 78, 50, 68, 70, 65, 83, 54, 48, 32, 48, 32,
/* 0x3bc0 */  78, 50, 68, 70, 65, 83, 54, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3bd0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 70, 65, 83,
/* 0x3be0 */  49, 48, 32, 48, 32, 78, 50, 69, 70, 65, 83, 49, 48, 10, 48, 48,
/* 0x3bf0 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,
/* 0x3c00 */  50, 69, 83, 77, 65, 50, 48, 32, 48, 32, 78, 50, 69, 83, 77, 65,
/* 0x3c10 */  50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x3c20 */  32,100, 32, 32, 78, 50, 69, 70, 65, 83, 50, 48, 32, 48, 32, 78,
/* 0x3c30 */  50, 69, 70, 65, 83, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3c40 */  32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 83, 77, 65, 51,
/* 0x3c50 */  48, 32, 48, 32, 78, 50, 69, 83, 77, 65, 51, 48, 10, 48, 48, 48,
/* 0x3c60 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50,
/* 0x3c70 */  69, 70, 65, 83, 51, 48, 32, 48, 32, 78, 50, 69, 70, 65, 83, 51,
/* 0x3c80 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x3c90 */ 100, 32, 32, 78, 50, 69, 83, 77, 65, 52, 48, 32, 48, 32, 78, 50,
/* 0x3ca0 */  69, 83, 77, 65, 52, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3cb0 */ 108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 70, 65, 83, 52, 48,
/* 0x3cc0 */  32, 48, 32, 78, 50, 69, 70, 65, 83, 52, 48, 10, 48, 48, 48, 48,
/* 0x3cd0 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69,
/* 0x3ce0 */  83, 77, 65, 53, 48, 32, 48, 32, 78, 50, 69, 83, 77, 65, 53, 48,
/* 0x3cf0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x3d00 */  32, 32, 78, 50, 69, 70, 65, 83, 53, 48, 32, 48, 32, 78, 50, 69,
/* 0x3d10 */  70, 65, 83, 53, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x3d20 */  32, 32, 32, 32,100, 32, 32, 78, 50, 69, 83, 77, 65, 54, 48, 32,
/* 0x3d30 */  48, 32, 78, 50, 69, 83, 77, 65, 54, 48, 10, 48, 48, 48, 48, 48,
/* 0x3d40 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 70,
/* 0x3d50 */  65, 83, 54, 48, 32, 48, 32, 78, 50, 69, 70, 65, 83, 54, 48, 10,
/* 0x3d60 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x3d70 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 48, 48, 32, 48, 32, 76, 90,
/* 0x3d80 */  77, 65, 95, 68, 69, 67, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3d90 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 69,
/* 0x3da0 */  76, 70, 48, 48, 32, 48, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48,
/* 0x3db0 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x3dc0 */ 100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 32, 48, 32,
/* 0x3dd0 */  76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48,
/* 0x3de0 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65,
/* 0x3df0 */  95, 68, 69, 67, 50, 48, 32, 48, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x3e00 */  67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x3e10 */  32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 32,
/* 0x3e20 */  48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 10, 48, 48, 48,
/* 0x3e30 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90,
/* 0x3e40 */  67, 75, 76, 76, 84, 57, 32, 48, 32, 76, 90, 67, 75, 76, 76, 84,
/* 0x3e50 */  57, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x3e60 */ 100, 32, 32, 99,116,111,107, 51, 50, 46, 51, 48, 32, 48, 32, 99,
/* 0x3e70 */ 116,111,107, 51, 50, 46, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3e80 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 67, 65, 76, 76,
/* 0x3e90 */  84, 57, 32, 48, 32, 76, 90, 67, 65, 76, 76, 84, 57, 10, 48, 48,
/* 0x3ea0 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67,
/* 0x3eb0 */  84, 67, 76, 69, 86, 69, 49, 32, 48, 32, 67, 84, 67, 76, 69, 86,
/* 0x3ec0 */  69, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x3ed0 */  32,100, 32, 32, 67, 65, 76, 76, 84, 82, 48, 49, 32, 48, 32, 67,
/* 0x3ee0 */  65, 76, 76, 84, 82, 48, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3ef0 */  32,108, 32, 32, 32, 32,100, 32, 32, 67, 84, 66, 83, 72, 82, 48,
/* 0x3f00 */  49, 32, 48, 32, 67, 84, 66, 83, 72, 82, 48, 49, 10, 48, 48, 48,
/* 0x3f10 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84,
/* 0x3f20 */  66, 82, 79, 82, 48, 49, 32, 48, 32, 67, 84, 66, 82, 79, 82, 48,
/* 0x3f30 */  49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x3f40 */ 100, 32, 32, 67, 84, 66, 83, 87, 65, 48, 49, 32, 48, 32, 67, 84,
/* 0x3f50 */  66, 83, 87, 65, 48, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3f60 */ 108, 32, 32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84, 82, 48, 50,
/* 0x3f70 */  32, 48, 32, 67, 65, 76, 76, 84, 82, 48, 50, 10, 48, 48, 48, 48,
/* 0x3f80 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 65, 76,
/* 0x3f90 */  76, 84, 82, 69, 56, 32, 48, 32, 67, 65, 76, 76, 84, 82, 69, 56,
/* 0x3fa0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x3fb0 */  32, 32, 67, 65, 76, 76, 84, 82, 69, 57, 32, 48, 32, 67, 65, 76,
/* 0x3fc0 */  76, 84, 82, 69, 57, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x3fd0 */  32, 32, 32, 32,100, 32, 32, 67, 84, 67, 76, 69, 86, 69, 50, 32,
/* 0x3fe0 */  48, 32, 67, 84, 67, 76, 69, 86, 69, 50, 10, 48, 48, 48, 48, 48,
/* 0x3ff0 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 65, 76, 76,
/* 0x4000 */  84, 82, 49, 50, 32, 48, 32, 67, 65, 76, 76, 84, 82, 49, 50, 10,
/* 0x4010 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x4020 */  32, 67, 84, 66, 83, 72, 82, 49, 49, 32, 48, 32, 67, 84, 66, 83,
/* 0x4030 */  72, 82, 49, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x4040 */  32, 32, 32,100, 32, 32, 67, 84, 66, 82, 79, 82, 49, 49, 32, 48,
/* 0x4050 */  32, 67, 84, 66, 82, 79, 82, 49, 49, 10, 48, 48, 48, 48, 48, 48,
/* 0x4060 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84, 66, 83, 87,
/* 0x4070 */  65, 49, 49, 32, 48, 32, 67, 84, 66, 83, 87, 65, 49, 49, 10, 48,
/* 0x4080 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x4090 */  76, 73, 78, 85, 90, 57, 57, 48, 32, 48, 32, 76, 73, 78, 85, 90,
/* 0x40a0 */  57, 57, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x40b0 */  32, 32,100, 32, 32, 85, 80, 88, 49, 72, 69, 65, 68, 32, 48, 32,
/* 0x40c0 */  85, 80, 88, 49, 72, 69, 65, 68, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x40d0 */  48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32,
/* 0x40e0 */  48, 32,115,116, 97, 99,107, 95,111,102,102,115,101,116, 10, 48,
/* 0x40f0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4100 */  42, 85, 78, 68, 42, 32, 48, 32,111,114,105,103,105,110, 97,108,
/* 0x4110 */  95,101,110,116,114,121, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x4120 */  32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32, 48, 32,
/* 0x4130 */  99,111,109,112,114,101,115,115,101,100, 95,108,101,110,103,116,
/* 0x4140 */ 104, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32,
/* 0x4150 */  32, 32, 32, 42, 85, 78, 68, 42, 32, 48, 32,110,101,103, 95, 99,
/* 0x4160 */ 111,110,102,105,103, 95,112,104,121,115,105, 99, 97,108, 95, 97,
/* 0x4170 */ 108,105,103,110, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32,
/* 0x4180 */  32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32, 48, 32,108,111,
/* 0x4190 */  97,100, 95,112,104,121,115,105, 99, 97,108, 95, 97,100,100,114,
/* 0x41a0 */ 101,115,115, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32,
/* 0x41b0 */  32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32, 48, 32,117,110, 99,
/* 0x41c0 */  95,108,101,110,103,116,104, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x41d0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32, 48,
/* 0x41e0 */  32,100,101, 99, 95,111,102,102,115,101,116, 10, 48, 48, 48, 48,
/* 0x41f0 */  48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78,
/* 0x4200 */  68, 42, 32, 48, 32,117,110, 99, 95,111,102,102,115,101,116, 10,
/* 0x4210 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4220 */  32, 42, 85, 78, 68, 42, 32, 48, 32,110,101,103, 95,108,101,110,
/* 0x4230 */ 103,116,104, 95,109,111,118, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4240 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32, 48,
/* 0x4250 */  32,102,105,108,116,101,114, 95, 99,116,111, 10, 48, 48, 48, 48,
/* 0x4260 */  48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78,
/* 0x4270 */  68, 42, 32, 48, 32,102,105,108,116,101,114, 95,108,101,110,103,
/* 0x4280 */ 116,104, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32,
/* 0x4290 */  32, 32, 32, 32, 42, 85, 78, 68, 42, 32, 48, 32,110,101,103, 95,
/* 0x42a0 */ 112, 97,103,101, 95,111,102,102,115,101,116, 10, 48, 48, 48, 48,
/* 0x42b0 */  48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78,
/* 0x42c0 */  68, 42, 32, 48, 32, 99,111,112,121, 95,115,111,117,114, 99,101,
/* 0x42d0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32,
/* 0x42e0 */  32, 32, 42, 85, 78, 68, 42, 32, 48, 32, 99,111,112,121, 95,100,
/* 0x42f0 */ 101,115,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32,
/* 0x4300 */  32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32, 48, 32,119,111,114,
/* 0x4310 */ 100,115, 95,116,111, 95, 99,111,112,121, 10, 48, 48, 48, 48, 48,
/* 0x4320 */  48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68,
/* 0x4330 */  42, 32, 48, 32,115,114, 99, 95,102,111,114, 95,100,101, 99,111,
/* 0x4340 */ 109,112,114,101,115,115,111,114, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4350 */  48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32,
/* 0x4360 */  48, 32,100,101, 99,111,109,112,114,101,115,115,111,114, 10, 48,
/* 0x4370 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4380 */  42, 85, 78, 68, 42, 32, 48, 32,108,122,109, 97, 95,115,116, 97,
/* 0x4390 */  99,107, 95, 97,100,106,117,115,116, 10, 48, 48, 48, 48, 48, 48,
/* 0x43a0 */  48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,
/* 0x43b0 */  32, 48, 32,108,122,109, 97, 95,117, 95,108,101,110, 10, 48, 48,
/* 0x43c0 */  48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42,
/* 0x43d0 */  85, 78, 68, 42, 32, 48, 32,108,122,109, 97, 95, 99, 95,108,101,
/* 0x43e0 */ 110, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32,
/* 0x43f0 */  32, 32, 32, 42, 85, 78, 68, 42, 32, 48, 32,108,122,109, 97, 95,
/* 0x4400 */ 112,114,111,112,101,114,116,105,101,115, 10, 10, 82, 69, 76, 79,
/* 0x4410 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x4420 */  79, 82, 32, 91, 76, 73, 78, 85, 90, 48, 48, 48, 93, 58, 10, 79,
/* 0x4430 */  70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x4440 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x4450 */  48, 48, 48, 48, 48, 48, 48,101, 32, 82, 95, 51, 56, 54, 95, 51,
/* 0x4460 */  50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,115,116, 97, 99,107,
/* 0x4470 */  95,111,102,102,115,101,116, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x4480 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x4490 */  91, 76, 73, 78, 85, 90, 48, 48, 53, 93, 58, 10, 79, 70, 70, 83,
/* 0x44a0 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x44b0 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x44c0 */  48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32,
/* 0x44d0 */  32, 32, 32, 32, 32, 32, 32, 32,111,114,105,103,105,110, 97,108,
/* 0x44e0 */  95,101,110,116,114,121, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x44f0 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x4500 */  76, 73, 78, 85, 90, 49, 48, 49, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x4510 */  84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4520 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x4530 */  48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32,
/* 0x4540 */  32, 32, 32, 32, 32, 32, 32, 99,111,109,112,114,101,115,115,101,
/* 0x4550 */ 100, 95,108,101,110,103,116,104, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x4560 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x4570 */  32, 91, 76, 73, 78, 85, 90, 49, 50, 48, 93, 58, 10, 79, 70, 70,
/* 0x4580 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x4590 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x45a0 */  48, 48, 48, 48, 48, 54, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32,
/* 0x45b0 */  32, 32, 32, 32, 32, 32, 32, 32, 32,110,101,103, 95, 99,111,110,
/* 0x45c0 */ 102,105,103, 95,112,104,121,115,105, 99, 97,108, 95, 97,108,105,
/* 0x45d0 */ 103,110, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x45e0 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 73, 78, 85,
/* 0x45f0 */  90, 49, 51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x4600 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4610 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49,
/* 0x4620 */  32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32,
/* 0x4630 */  32, 32, 32,108,111, 97,100, 95,112,104,121,115,105, 99, 97,108,
/* 0x4640 */  95, 97,100,100,114,101,115,115, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x4650 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x4660 */  32, 91, 76, 73, 78, 85, 90, 49, 52, 48, 93, 58, 10, 79, 70, 70,
/* 0x4670 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x4680 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x4690 */  48, 48, 48, 48, 48, 53, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32,
/* 0x46a0 */  32, 32, 32, 32, 32, 32, 32, 32, 32,117,110, 99, 95,108,101,110,
/* 0x46b0 */ 103,116,104, 10, 48, 48, 48, 48, 48, 48, 48,101, 32, 82, 95, 51,
/* 0x46c0 */  56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,100,
/* 0x46d0 */ 101, 99, 95,111,102,102,115,101,116, 10, 48, 48, 48, 48, 48, 48,
/* 0x46e0 */  49, 53, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32,
/* 0x46f0 */  32, 32, 32, 32, 32,117,110, 99, 95,111,102,102,115,101,116, 10,
/* 0x4700 */  48, 48, 48, 48, 48, 48, 49, 98, 32, 82, 95, 51, 56, 54, 95, 51,
/* 0x4710 */  50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,110,101,103, 95,108,
/* 0x4720 */ 101,110,103,116,104, 95,109,111,118, 10, 10, 82, 69, 76, 79, 67,
/* 0x4730 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x4740 */  82, 32, 91, 76, 73, 78, 85, 90, 49, 52, 53, 93, 58, 10, 79, 70,
/* 0x4750 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x4760 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x4770 */  48, 48, 48, 48, 48, 48, 50, 32, 82, 95, 51, 56, 54, 95, 56, 32,
/* 0x4780 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32,102,105,108,116,101,114,
/* 0x4790 */  95, 99,116,111, 10, 48, 48, 48, 48, 48, 48, 48, 52, 32, 82, 95,
/* 0x47a0 */  51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x47b0 */ 102,105,108,116,101,114, 95,108,101,110,103,116,104, 10, 10, 82,
/* 0x47c0 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x47d0 */  83, 32, 70, 79, 82, 32, 91, 76, 73, 78, 85, 90, 49, 53, 48, 93,
/* 0x47e0 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x47f0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x4800 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 54, 32, 82, 95, 51, 56,
/* 0x4810 */  54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,108,111,
/* 0x4820 */  97,100, 95,112,104,121,115,105, 99, 97,108, 95, 97,100,100,114,
/* 0x4830 */ 101,115,115, 10, 48, 48, 48, 48, 48, 48, 49, 51, 32, 82, 95, 51,
/* 0x4840 */  56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,110,
/* 0x4850 */ 101,103, 95,112, 97,103,101, 95,111,102,102,115,101,116, 10, 10,
/* 0x4860 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x4870 */  68, 83, 32, 70, 79, 82, 32, 91, 76, 90, 67, 75, 76, 76, 84, 49,
/* 0x4880 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x4890 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x48a0 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 50, 32, 82, 95, 51,
/* 0x48b0 */  56, 54, 95, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,102,
/* 0x48c0 */ 105,108,116,101,114, 95, 99,116,111, 10, 48, 48, 48, 48, 48, 48,
/* 0x48d0 */  48, 52, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32,
/* 0x48e0 */  32, 32, 32, 32, 32,102,105,108,116,101,114, 95,108,101,110,103,
/* 0x48f0 */ 116,104, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x4900 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 66, 90, 73,
/* 0x4910 */  77, 65, 71, 69, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x4920 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4930 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49,
/* 0x4940 */  32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32,
/* 0x4950 */  32, 32, 32, 99,111,112,121, 95,115,111,117,114, 99,101, 10, 48,
/* 0x4960 */  48, 48, 48, 48, 48, 48, 54, 32, 82, 95, 51, 56, 54, 95, 51, 50,
/* 0x4970 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 99,111,112,121, 95,100,
/* 0x4980 */ 101,115,116, 10, 48, 48, 48, 48, 48, 48, 48, 98, 32, 82, 95, 51,
/* 0x4990 */  56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,119,
/* 0x49a0 */ 111,114,100,115, 95,116,111, 95, 99,111,112,121, 10, 48, 48, 48,
/* 0x49b0 */  48, 48, 48, 49, 52, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32,
/* 0x49c0 */  32, 32, 32, 32, 32, 32, 32, 32,115,114, 99, 95,102,111,114, 95,
/* 0x49d0 */ 100,101, 99,111,109,112,114,101,115,115,111,114, 10, 48, 48, 48,
/* 0x49e0 */  48, 48, 48, 49, 97, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50,
/* 0x49f0 */  32, 32, 32, 32, 32, 32, 32, 32,100,101, 99,111,109,112,114,101,
/* 0x4a00 */ 115,115,111,114, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x4a10 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 90,
/* 0x4a20 */  73, 77, 65, 71, 69, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x4a30 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4a40 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x4a50 */  48, 97, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32,
/* 0x4a60 */  32, 32, 32, 32, 32,115,114, 99, 95,102,111,114, 95,100,101, 99,
/* 0x4a70 */ 111,109,112,114,101,115,115,111,114, 10, 10, 82, 69, 76, 79, 67,
/* 0x4a80 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x4a90 */  82, 32, 91, 78, 50, 66, 83, 77, 65, 49, 48, 93, 58, 10, 79, 70,
/* 0x4aa0 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x4ab0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x4ac0 */  48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67,
/* 0x4ad0 */  56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67,
/* 0x4ae0 */  49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x4af0 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 70,
/* 0x4b00 */  65, 83, 49, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x4b10 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4b20 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49,
/* 0x4b30 */  32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,
/* 0x4b40 */  32, 32, 32, 78, 50, 66, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76,
/* 0x4b50 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x4b60 */  70, 79, 82, 32, 91, 78, 50, 66, 83, 77, 65, 50, 48, 93, 58, 10,
/* 0x4b70 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x4b80 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x4b90 */  10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95,
/* 0x4ba0 */  80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 83,
/* 0x4bb0 */  77, 65, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x4bc0 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50,
/* 0x4bd0 */  66, 70, 65, 83, 50, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x4be0 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4bf0 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x4c00 */  48, 51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32,
/* 0x4c10 */  32, 32, 32, 32, 32, 78, 50, 66, 70, 65, 83, 49, 49, 10, 10, 82,
/* 0x4c20 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x4c30 */  83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 83, 77, 65, 51, 48, 93,
/* 0x4c40 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x4c50 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x4c60 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 99, 32, 82, 95, 51, 56,
/* 0x4c70 */  54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50,
/* 0x4c80 */  66, 68, 69, 67, 50, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x4c90 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x4ca0 */  78, 50, 66, 70, 65, 83, 51, 48, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x4cb0 */  84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4cc0 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x4cd0 */  48, 48, 48, 51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32,
/* 0x4ce0 */  32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 50, 48, 10,
/* 0x4cf0 */  48, 48, 48, 48, 48, 48, 48,101, 32, 82, 95, 51, 56, 54, 95, 80,
/* 0x4d00 */  67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69,
/* 0x4d10 */  67, 50, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x4d20 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66,
/* 0x4d30 */  68, 69, 67, 51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x4d40 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4d50 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 49,
/* 0x4d60 */  49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32,
/* 0x4d70 */  32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 54, 48, 10, 48, 48, 48,
/* 0x4d80 */  48, 48, 48, 50,102, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x4d90 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 53, 48,
/* 0x4da0 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x4db0 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 83, 77, 65,
/* 0x4dc0 */  52, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,
/* 0x4dd0 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4de0 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 99, 32, 82,
/* 0x4df0 */  95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4e00 */  32, 78, 50, 66, 68, 69, 67, 51, 48, 10, 10, 82, 69, 76, 79, 67,
/* 0x4e10 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x4e20 */  82, 32, 91, 78, 50, 66, 70, 65, 83, 52, 48, 93, 58, 10, 79, 70,
/* 0x4e30 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x4e40 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x4e50 */  48, 48, 48, 48, 48, 48, 51, 32, 82, 95, 51, 56, 54, 95, 80, 67,
/* 0x4e60 */  56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67,
/* 0x4e70 */  51, 48, 10, 48, 48, 48, 48, 48, 48, 48,101, 32, 82, 95, 51, 56,
/* 0x4e80 */  54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50,
/* 0x4e90 */  66, 68, 69, 67, 51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x4ea0 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x4eb0 */  78, 50, 66, 83, 77, 65, 54, 48, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x4ec0 */  84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4ed0 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x4ee0 */  48, 48, 48, 56, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32,
/* 0x4ef0 */  32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 49, 48, 10,
/* 0x4f00 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x4f10 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 70, 65, 83, 54,
/* 0x4f20 */  48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,
/* 0x4f30 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x4f40 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 97, 32, 82, 95,
/* 0x4f50 */  51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4f60 */  78, 50, 66, 70, 65, 83, 54, 49, 10, 48, 48, 48, 48, 48, 48, 49,
/* 0x4f70 */  53, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32,
/* 0x4f80 */  32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 49, 48, 10, 10, 82, 69,
/* 0x4f90 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x4fa0 */  32, 70, 79, 82, 32, 91, 78, 50, 66, 70, 65, 83, 54, 49, 93, 58,
/* 0x4fb0 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x4fc0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x4fd0 */  69, 10, 48, 48, 48, 48, 48, 48, 49, 50, 32, 82, 95, 51, 56, 54,
/* 0x4fe0 */  95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66,
/* 0x4ff0 */  68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x5000 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78,
/* 0x5010 */  50, 68, 83, 77, 65, 49, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x5020 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5030 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x5040 */  48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,
/* 0x5050 */  32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 49, 48, 10, 10,
/* 0x5060 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x5070 */  68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 70, 65, 83, 49, 48,
/* 0x5080 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x5090 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x50a0 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51,
/* 0x50b0 */  56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x50c0 */  50, 68, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x50d0 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x50e0 */  91, 78, 50, 68, 83, 77, 65, 50, 48, 93, 58, 10, 79, 70, 70, 83,
/* 0x50f0 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x5100 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x5110 */  48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x5120 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 83, 77, 65, 49, 48,
/* 0x5130 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x5140 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 70, 65, 83,
/* 0x5150 */  50, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,
/* 0x5160 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5170 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82,
/* 0x5180 */  95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5190 */  32, 78, 50, 68, 70, 65, 83, 49, 49, 10, 10, 82, 69, 76, 79, 67,
/* 0x51a0 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x51b0 */  82, 32, 91, 78, 50, 68, 83, 77, 65, 51, 48, 93, 58, 10, 79, 70,
/* 0x51c0 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x51d0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x51e0 */  48, 48, 48, 48, 48, 48, 99, 32, 82, 95, 51, 56, 54, 95, 80, 67,
/* 0x51f0 */  56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67,
/* 0x5200 */  51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x5210 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 70,
/* 0x5220 */  65, 83, 51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x5230 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5240 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 53,
/* 0x5250 */  32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,
/* 0x5260 */  32, 32, 32, 78, 50, 68, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48,
/* 0x5270 */  48, 48, 48,101, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32,
/* 0x5280 */  32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 51, 48, 10,
/* 0x5290 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x52a0 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 68, 69, 67, 51,
/* 0x52b0 */  48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,
/* 0x52c0 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x52d0 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,102, 32, 82, 95,
/* 0x52e0 */  51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x52f0 */  78, 50, 68, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 50,
/* 0x5300 */  49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32,
/* 0x5310 */  32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 54, 48, 10, 48, 48, 48,
/* 0x5320 */  48, 48, 48, 52, 51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x5330 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 53, 48,
/* 0x5340 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x5350 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 83, 77, 65,
/* 0x5360 */  52, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,
/* 0x5370 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5380 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 99, 32, 82,
/* 0x5390 */  95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x53a0 */  32, 78, 50, 68, 68, 69, 67, 51, 48, 10, 10, 82, 69, 76, 79, 67,
/* 0x53b0 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x53c0 */  82, 32, 91, 78, 50, 68, 70, 65, 83, 52, 48, 93, 58, 10, 79, 70,
/* 0x53d0 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x53e0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x53f0 */  48, 48, 48, 48, 48, 48, 51, 32, 82, 95, 51, 56, 54, 95, 80, 67,
/* 0x5400 */  56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67,
/* 0x5410 */  51, 48, 10, 48, 48, 48, 48, 48, 48, 48,101, 32, 82, 95, 51, 56,
/* 0x5420 */  54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50,
/* 0x5430 */  68, 68, 69, 67, 51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x5440 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x5450 */  78, 50, 68, 83, 77, 65, 54, 48, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x5460 */  84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5470 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x5480 */  48, 48, 48, 56, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32,
/* 0x5490 */  32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 49, 48, 10,
/* 0x54a0 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x54b0 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 70, 65, 83, 54,
/* 0x54c0 */  48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,
/* 0x54d0 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x54e0 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 97, 32, 82, 95,
/* 0x54f0 */  51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5500 */  78, 50, 68, 70, 65, 83, 54, 49, 10, 48, 48, 48, 48, 48, 48, 49,
/* 0x5510 */  53, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32,
/* 0x5520 */  32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 49, 48, 10, 10, 82, 69,
/* 0x5530 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x5540 */  32, 70, 79, 82, 32, 91, 78, 50, 68, 70, 65, 83, 54, 49, 93, 58,
/* 0x5550 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x5560 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x5570 */  69, 10, 48, 48, 48, 48, 48, 48, 49, 50, 32, 82, 95, 51, 56, 54,
/* 0x5580 */  95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68,
/* 0x5590 */  68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x55a0 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78,
/* 0x55b0 */  50, 69, 83, 77, 65, 49, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x55c0 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x55d0 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x55e0 */  48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,
/* 0x55f0 */  32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 49, 48, 10, 10,
/* 0x5600 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x5610 */  68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 70, 65, 83, 49, 48,
/* 0x5620 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x5630 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x5640 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51,
/* 0x5650 */  56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x5660 */  50, 69, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x5670 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x5680 */  91, 78, 50, 69, 83, 77, 65, 50, 48, 93, 58, 10, 79, 70, 70, 83,
/* 0x5690 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x56a0 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x56b0 */  48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x56c0 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 83, 77, 65, 49, 48,
/* 0x56d0 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x56e0 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 70, 65, 83,
/* 0x56f0 */  50, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,
/* 0x5700 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5710 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82,
/* 0x5720 */  95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5730 */  32, 78, 50, 69, 70, 65, 83, 49, 49, 10, 10, 82, 69, 76, 79, 67,
/* 0x5740 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x5750 */  82, 32, 91, 78, 50, 69, 83, 77, 65, 51, 48, 93, 58, 10, 79, 70,
/* 0x5760 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x5770 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x5780 */  48, 48, 48, 48, 48, 48, 99, 32, 82, 95, 51, 56, 54, 95, 80, 67,
/* 0x5790 */  56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67,
/* 0x57a0 */  51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x57b0 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 70,
/* 0x57c0 */  65, 83, 51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x57d0 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x57e0 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 53,
/* 0x57f0 */  32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,
/* 0x5800 */  32, 32, 32, 78, 50, 69, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48,
/* 0x5810 */  48, 48, 48,101, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32,
/* 0x5820 */  32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 51, 48, 10,
/* 0x5830 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x5840 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 68, 69, 67, 51,
/* 0x5850 */  48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,
/* 0x5860 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x5870 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,102, 32, 82, 95,
/* 0x5880 */  51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5890 */  78, 50, 69, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 49,
/* 0x58a0 */ 101, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32,
/* 0x58b0 */  32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 53, 48, 10, 48, 48, 48,
/* 0x58c0 */  48, 48, 48, 51, 48, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x58d0 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 54, 48,
/* 0x58e0 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x58f0 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 83, 77, 65,
/* 0x5900 */  52, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,
/* 0x5910 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5920 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 99, 32, 82,
/* 0x5930 */  95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5940 */  32, 78, 50, 69, 68, 69, 67, 51, 48, 10, 10, 82, 69, 76, 79, 67,
/* 0x5950 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x5960 */  82, 32, 91, 78, 50, 69, 70, 65, 83, 52, 48, 93, 58, 10, 79, 70,
/* 0x5970 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x5980 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x5990 */  48, 48, 48, 48, 48, 48, 51, 32, 82, 95, 51, 56, 54, 95, 80, 67,
/* 0x59a0 */  56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67,
/* 0x59b0 */  51, 48, 10, 48, 48, 48, 48, 48, 48, 48,101, 32, 82, 95, 51, 56,
/* 0x59c0 */  54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50,
/* 0x59d0 */  69, 68, 69, 67, 51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x59e0 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x59f0 */  78, 50, 69, 83, 77, 65, 54, 48, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x5a00 */  84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5a10 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x5a20 */  48, 48, 48, 56, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32,
/* 0x5a30 */  32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 49, 48, 10,
/* 0x5a40 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x5a50 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 70, 65, 83, 54,
/* 0x5a60 */  48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,
/* 0x5a70 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x5a80 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 97, 32, 82, 95,
/* 0x5a90 */  51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5aa0 */  78, 50, 69, 70, 65, 83, 54, 49, 10, 48, 48, 48, 48, 48, 48, 49,
/* 0x5ab0 */  53, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32,
/* 0x5ac0 */  32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 49, 48, 10, 10, 82, 69,
/* 0x5ad0 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x5ae0 */  32, 70, 79, 82, 32, 91, 78, 50, 69, 70, 65, 83, 54, 49, 93, 58,
/* 0x5af0 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x5b00 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x5b10 */  69, 10, 48, 48, 48, 48, 48, 48, 49, 50, 32, 82, 95, 51, 56, 54,
/* 0x5b20 */  95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69,
/* 0x5b30 */  68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x5b40 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76,
/* 0x5b50 */  90, 77, 65, 95, 68, 69, 67, 48, 48, 93, 58, 10, 79, 70, 70, 83,
/* 0x5b60 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x5b70 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x5b80 */  48, 48, 48, 48, 53, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32,
/* 0x5b90 */  32, 32, 32, 32, 32, 32, 32, 32,108,122,109, 97, 95,115,116, 97,
/* 0x5ba0 */  99,107, 95, 97,100,106,117,115,116, 10, 48, 48, 48, 48, 48, 48,
/* 0x5bb0 */  49, 52, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32,
/* 0x5bc0 */  32, 32, 32, 32, 32,108,122,109, 97, 95,117, 95,108,101,110, 10,
/* 0x5bd0 */  48, 48, 48, 48, 48, 48, 49,101, 32, 82, 95, 51, 56, 54, 95, 51,
/* 0x5be0 */  50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,108,122,109, 97, 95,
/* 0x5bf0 */  99, 95,108,101,110, 10, 48, 48, 48, 48, 48, 48, 50, 97, 32, 82,
/* 0x5c00 */  95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5c10 */  32,108,122,109, 97, 95,112,114,111,112,101,114,116,105,101,115,
/* 0x5c20 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x5c30 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 99,116,111,107, 51, 50,
/* 0x5c40 */  46, 48, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x5c50 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5c60 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 51, 32,
/* 0x5c70 */  82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x5c80 */  32, 32, 99,116,111,107, 51, 50, 46, 50, 48, 10, 10, 82, 69, 76,
/* 0x5c90 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x5ca0 */  70, 79, 82, 32, 91, 99,116,111,107, 51, 50, 46, 49, 48, 93, 58,
/* 0x5cb0 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x5cc0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x5cd0 */  69, 10, 48, 48, 48, 48, 48, 48, 48,100, 32, 82, 95, 51, 56, 54,
/* 0x5ce0 */  95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 99,116,111,
/* 0x5cf0 */ 107, 51, 50, 46, 50, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x5d00 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x5d10 */  99,116,111,107, 51, 50, 46, 50, 48, 93, 58, 10, 79, 70, 70, 83,
/* 0x5d20 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x5d30 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x5d40 */  48, 48, 48, 48, 53, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x5d50 */  32, 32, 32, 32, 32, 32, 32, 32, 99,116,111,107, 51, 50, 46, 52,
/* 0x5d60 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 97, 32, 82, 95, 51, 56, 54,
/* 0x5d70 */  95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 99,116,111,
/* 0x5d80 */ 107, 51, 50, 46, 52, 48, 10, 48, 48, 48, 48, 48, 48, 49, 48, 32,
/* 0x5d90 */  82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x5da0 */  32, 32, 99,116,111,107, 51, 50, 46, 52, 48, 10, 10, 82, 69, 76,
/* 0x5db0 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x5dc0 */  70, 79, 82, 32, 91, 99,116,111,107, 51, 50, 46, 51, 48, 93, 58,
/* 0x5dd0 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x5de0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x5df0 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 51, 56, 54,
/* 0x5e00 */  95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 99,116,111,
/* 0x5e10 */ 107, 51, 50, 46, 52, 48, 10, 48, 48, 48, 48, 48, 48, 48, 57, 32,
/* 0x5e20 */  82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x5e30 */  32, 32, 99,116,111,107, 51, 50, 46, 49, 48, 10, 10, 82, 69, 76,
/* 0x5e40 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x5e50 */  70, 79, 82, 32, 91, 99,116,111,107, 51, 50, 46, 52, 48, 93, 58,
/* 0x5e60 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x5e70 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x5e80 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 51, 56, 54,
/* 0x5e90 */  95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 99,116,111,
/* 0x5ea0 */ 107, 51, 50, 46, 48, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x5eb0 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x5ec0 */  67, 65, 76, 76, 84, 82, 48, 48, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x5ed0 */  84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5ee0 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x5ef0 */  48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32,
/* 0x5f00 */  32, 32, 32, 32, 32, 32, 32,102,105,108,116,101,114, 95,108,101,
/* 0x5f10 */ 110,103,116,104, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x5f20 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 84,
/* 0x5f30 */  67, 76, 69, 86, 69, 49, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x5f40 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5f50 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x5f60 */  48, 50, 32, 82, 95, 51, 56, 54, 95, 56, 32, 32, 32, 32, 32, 32,
/* 0x5f70 */  32, 32, 32, 32, 32,102,105,108,116,101,114, 95, 99,116,111, 10,
/* 0x5f80 */  48, 48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 51, 56, 54, 95, 80,
/* 0x5f90 */  67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 67, 65, 76, 76, 84,
/* 0x5fa0 */  82, 48, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x5fb0 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 65, 76,
/* 0x5fc0 */  76, 84, 82, 48, 50, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x5fd0 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5fe0 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x5ff0 */ 100, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32,
/* 0x6000 */  32, 32, 32, 32, 67, 65, 76, 76, 84, 82, 48, 48, 10, 10, 82, 69,
/* 0x6010 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x6020 */  32, 70, 79, 82, 32, 91, 67, 65, 76, 76, 84, 82, 49, 48, 93, 58,
/* 0x6030 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x6040 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x6050 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54,
/* 0x6060 */  95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,102,105,108,
/* 0x6070 */ 116,101,114, 95,108,101,110,103,116,104, 10, 10, 82, 69, 76, 79,
/* 0x6080 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x6090 */  79, 82, 32, 91, 67, 65, 76, 76, 84, 82, 49, 49, 93, 58, 10, 79,
/* 0x60a0 */  70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x60b0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x60c0 */  48, 48, 48, 48, 48, 48, 48, 51, 32, 82, 95, 51, 56, 54, 95, 80,
/* 0x60d0 */  67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 67, 65, 76, 76, 84,
/* 0x60e0 */  82, 49, 51, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x60f0 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 84, 67,
/* 0x6100 */  76, 69, 86, 69, 50, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x6110 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6120 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x6130 */  50, 32, 82, 95, 51, 56, 54, 95, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x6140 */  32, 32, 32, 32,102,105,108,116,101,114, 95, 99,116,111, 10, 48,
/* 0x6150 */  48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 51, 56, 54, 95, 80, 67,
/* 0x6160 */  56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 67, 65, 76, 76, 84, 82,
/* 0x6170 */  49, 49, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x6180 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 65, 76, 76,
/* 0x6190 */  84, 82, 49, 51, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x61a0 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x61b0 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 52,
/* 0x61c0 */  32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,
/* 0x61d0 */  32, 32, 32, 67, 65, 76, 76, 84, 82, 49, 48, 10
};
