try:
	from setuptools import setup
except ImportError:
	from distutils.core import setup

import os

def read(fname):
    return open(os.path.join(os.path.dirname(__file__),"torchCL", fname)).read()

long_desc = """
	TorchCL allows you to create messages, time enteries and expenses from the command line. Why might you want to do this? Because if you have terminal access you can build this into an automation routine where otherwise you might need to hire a programmer. 
"""


setup(name="TorchCL",
      version=read("version.txt"),
      description="Torch Project Management's command line interface",
      author="Ben Smith",
      author_email="ben@wbpsystems.com",
      url="http://torch.wbpsystems.com/cl.php",
      license="Apache Software License",
      packages=['Tposter','TUnicodeCSV','TWebBrowser'],
	  scripts=['torchCL/torchCL'],
	  package_dir={'Tposter':'torchCL/Tposter','TUnicodeCSV':'torchCL/TUnicodeCSV','TWebBrowser':'torchCL/TWebBrowser'},
      long_description=long_desc,
      classifiers=[
          'Topic :: Internet :: WWW/HTTP',
          'Environment :: Console',
          'Development Status :: 5 - Production/Stable',
          'Operating System :: POSIX',
          'Intended Audience :: Developers',
          'Intended Audience :: End Users/Desktop'
      ]
     )
