# Building libnyquist

libnyquist's build system is very minimal. It does not have any build options
except `BUILD_STATIC`, which is off by default.

## Dependencies
The only dependencies libnyquist needs are PortAudio and libsndfile. On Linux,
they can be installed via your distro's package manager. On Windows and macOS,
you can use vcpkg with libnyquist to install these packages.

### Linux
Note: if you do not see your system here, feel free to add it.

To install the appropriate dependencies, run the following:

**Debian/Ubuntu (and Derivatives)**
```
sudo apt install build-essential cmake git portaudio19-dev libsndfile1 libsndfile1-dev
```

**Arch Linux**
```
sudo pacman -S git cmake gcc portaudio libsndfile
```

### vcpkg
Clone vcpkg from https://github.com/microsoft/vcpkg and bootstrap it.

## Configuring libnyquist

First, create a new build folder (preferrably inside the source tree) and `cd`
into it. Then, on all platforms, run the following command:

```
cmake ..
```

If you are using vcpkg (you will on Windows and macOS), you need to add
`-DCMAKE_TOOLCHAIN_FILE=/path/to/vcpkg/scripts/buildsystems/vcpkg.cmake`.

Alternatively, you can use Ninja instead of the default CMake generator on your
platform. Just add `-G Ninja` to the command above. Note that Ninja has only
been tested (and is actually preferred over make) on Linux.

### Building a static version

By default, libnyquist is set to be built as a shared library. If you want a
static version of the library, you can `-DBUILD_STATIC=ON` to the command
above.

## Building libnyquist

Finally, in the build directory, run `cmake --build .`. This starts the build.
Alternatively, you can use the build tool that CMake generated files for
directly (e.g., you can run `ninja -j $(nproc)` on Linux if you used CMake's
Ninja generator).

# Build options

- **BUILD_STATIC**: Builds a static version of libnyquist.
