/*
 * TEMPO - Topographic Eeg Mapping PrOgram.
 * 
 * Copyright (C) 1995, 1996, 2003, 2004 Aleksandar B. Samardzic
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59
 * Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include "sensors.h"

Sensors        *
sensors_create(char *name)
{
	Sensors        *sensors;/* Sensors object. */
	FILE           *file;	/* Input file. */
	int             length;	/* Current sensor name lenght. */
	int             error;	/* Result returned by input functions. */
	int             i, j;	/* Loop indices. */

	/* Create new sensors object. */
	sensors = (Sensors *) malloc(sizeof(Sensors));
	assert(sensors != NULL);

	/* Open input file. */
	file = fopen(name, "r");
	assert(file != NULL);

	/*
	 * Read sensors count and allocate memory for sensors names and
	 * coordinates.
	 */
	fscanf(file, "%d", &sensors->count);
	sensors->names = (char **)malloc(sensors->count * sizeof(char *));
	assert(sensors->names != NULL);
	sensors->points = (Vector *) malloc(sensors->count * sizeof(Vector));
	assert(sensors->points != NULL);

	/* For each sensor,... */
	for (i = 0; i < sensors->count; i++) {
		/*
		 * ...read sensor name length and allocate memory for sensor
		 * name,...
		 */
		assert(fscanf(file, "%d", &length) == 1);
		sensors->names[i] = (char *)malloc((length + 1) * sizeof(char));
		assert(sensors->names[i] != NULL);

		/* ...read sensor name... */
		for (; fgetc(file) != '\"';);
		for (j = 0; (sensors->names[i][j] = (char)fgetc(file)) != '\"'; j++);
		sensors->names[i][j] = 0;

		/* ...and coordinates. */
		assert(fscanf(file, "%f%f%f", &sensors->points[i][X], &sensors->points[i][Y], &sensors->points[i][Z]) == 3);
	}

	/* Close input file. */
	fclose(file);

	return sensors;
}

void
sensors_destroy(Sensors * sensors)
{
	int             i;	/* Loop index. */

	/*
	 * Free memory used for sensors names, for arrays of sensors names
	 * and coordinates, as well as for sensors object itself.
	 */
	for (i = 0; i < sensors->count; i++)
		free(sensors->names[i]);
	free(sensors->names);
	free(sensors->points);
	free(sensors);
}
