/*
 * TEMPO - Topographic Eeg Mapping PrOgram.
 * 
 * Copyright (C) 1995, 1996, 2003, 2004 Aleksandar B. Samardzic
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59
 * Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef quaternion_h
#define quaternion_h

#include "vector.h"

/* Quaternion data type. */
typedef float   Quaternion[4];

/* Multiply quaternion with other quaternion. */
void            quaternion_mult(Quaternion q, Quaternion other);

/*
 * Calculate quaternion corresponding to rotation around vector given as
 * first argument for angle given as second argument.
 */
void            quaternion_from_axis_angle(Vector axis, float angle, Quaternion q);

/*
 * Calculate vector and angle of rotation corresponding to quaternion given
 * as first argument.
 */
void            quaternion_to_axis_angle(Quaternion q, Vector axis, float *angle);

#endif
