/*
 * TEMPO - Topographic Eeg Mapping PrOgram.
 * 
 * Copyright (C) 1995, 1996, 2003, 2004 Aleksandar B. Samardzic
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59
 * Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef input_h
#define input_h

#include <time.h>
#include "sensors.h"
#include "signal.h"

/* Score identifiers. */
#define RAW_POTENTIAL 0
#define DFT_AMPLITUDE 1
#define DFT_PHASE 2

/*
 * Minimal number of signals that have to exist in data file in order to be
 * able to create visualization.
 */
#define MIN_COUNT 6

/* Input object data type. */
typedef struct {
	char           *patient;/* Patient information. */
	char           *recording;	/* Recording information. */
	struct tm       date_and_time;	/* Start date and time of recording. */
	int             offset;	/* Number of bytes in header. */
	int             data;	/* Number of data records. */
	int             duration;	/* Duration of data records (in
					 * seconds). */
	int             count;	/* Signals count. */
	Signal        **signals;/* Signal objects. */
	int             curr, last;	/* Current and last record. */
	float           frequency;	/* Sampling frequency. */
	float           physical_lo, physical_hi;	/* Physical minimum and
							 * maximum. */
	int            *sensors;/* Indices of sensors corresponding to
				 * signals. */
}               Input;

/*
 * Create input object.  Arguments are filename to read data from and an
 * array with information about sensors.
 */
Input          *input_create(char *name, Sensors * sensors);

/* Destroy input object. */
void            input_destroy(Input * input);

/*
 * Calculate score values.  First argument is input object, second argument
 * is position to read data from, third argument is score to be calculated,
 * fourth argument is length of vector to be given as next argument and fifth
 * argument is vector to store calculated values to. Depending on score,
 * function may have more arguments:  for DFT scores sixth argument is DFT
 * window length and seventh argument is frequency to return values for.
 */
void            input_values(Input * input, int at, int score, int count, float *values,...);

#endif
