/*
 * TEMPO - Topographic Eeg Mapping PrOgram.
 * 
 * Copyright (C) 1995, 1996, 2003, 2004 Aleksandar B. Samardzic
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59
 * Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#if HAVE_CONFIG_H
#include "config.h"
#endif

#include <assert.h>
#include <stdlib.h>
#include "gettext.h"
#include "info_controls.h"
#include "input.h"

#define _(String) gettext(String)

GtkWidget      *
info_controls_create(GtkWidget * window)
{
	Input          *input;	/* Input object. */
	GtkTooltips    *tooltips;	/* Tooltips object. */
	GtkWidget      *frame;	/* Frame containing info controls. */
	GtkWidget      *eventbox;	/* Event box widget. */
	GtkWidget      *table;	/* Table widget. */
	GtkWidget      *hbox;	/* Horizontal box for widgets packing. */
	GtkWidget      *label;	/* Label widget. */
        char            date_and_time[81];	/* String representing date
                                                   and time of recording. */

	/* Get input object. */
	input = (Input *) g_object_get_data(G_OBJECT(window), "input");
	assert(input != NULL);

	/* Get tooltips object. */
	tooltips = GTK_TOOLTIPS(g_object_get_data(G_OBJECT(window), "tooltips"));

	/* Create frame widget for info controls layout. */
	frame = gtk_frame_new(_("Info"));

	/* Create and setup table widget. */
	table = gtk_table_new(3, 2, FALSE);
	gtk_container_set_border_width(GTK_CONTAINER(table), 3);
	gtk_table_set_row_spacings(GTK_TABLE(table), 3);
	gtk_table_set_col_spacings(GTK_TABLE(table), 3);
	gtk_container_add(GTK_CONTAINER(frame), table);

	/*
	 * Create and setup horizontal box and label for first row, first
	 * column table cell .
	 */
	hbox = gtk_hbox_new(FALSE, 0);
	gtk_table_attach_defaults(GTK_TABLE(table), hbox, 0, 1, 0, 1);
	label = gtk_label_new(_("Patient: "));
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);

	/*
	 * Create and setup horizontal box and label for first row, second
	 * column table cell .
	 */
	hbox = gtk_hbox_new(FALSE, 0);
	gtk_table_attach_defaults(GTK_TABLE(table), hbox, 1, 2, 0, 1);
	eventbox = gtk_event_box_new();
	gtk_tooltips_set_tip(GTK_TOOLTIPS(tooltips), eventbox, _("Patient identification"), NULL);
	gtk_box_pack_start(GTK_BOX(hbox), eventbox, FALSE, FALSE, 0);
	label = gtk_label_new(input->patient);
	gtk_container_add(GTK_CONTAINER(eventbox), label);

	/*
	 * Create and setup horizontal box and label for second row, first
	 * column table cell .
	 */
	hbox = gtk_hbox_new(FALSE, 0);
	gtk_table_attach_defaults(GTK_TABLE(table), hbox, 0, 1, 1, 2);
	label = gtk_label_new(_("Recording: "));
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);

	/*
	 * Create and setup horizontal box and label for second row, second
	 * column table cell .
	 */
	hbox = gtk_hbox_new(FALSE, 0);
	gtk_table_attach_defaults(GTK_TABLE(table), hbox, 1, 2, 1, 2);
	eventbox = gtk_event_box_new();
	gtk_tooltips_set_tip(GTK_TOOLTIPS(tooltips), eventbox, _("Recording identification"), NULL);
	gtk_box_pack_start(GTK_BOX(hbox), eventbox, FALSE, FALSE, 0);
	label = gtk_label_new(input->recording);
	gtk_container_add(GTK_CONTAINER(eventbox), label);

	/*
	 * Create and setup horizontal box and label for third row, first
	 * column table cell .
	 */
	hbox = gtk_hbox_new(FALSE, 0);
	gtk_table_attach_defaults(GTK_TABLE(table), hbox, 0, 1, 2, 3);
	label = gtk_label_new(_("Date and time: "));
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);

	/*
	 * Create and setup horizontal box and label for third row, second
	 * column table cell .
	 */
	hbox = gtk_hbox_new(FALSE, 0);
	gtk_table_attach_defaults(GTK_TABLE(table), hbox, 1, 2, 2, 3);
	eventbox = gtk_event_box_new();
	gtk_tooltips_set_tip(GTK_TOOLTIPS(tooltips), eventbox, _("Start date and time of recording"), NULL);
	gtk_box_pack_start(GTK_BOX(hbox), eventbox, FALSE, FALSE, 0);
        strftime(date_and_time, 81, "%x %X", &input->date_and_time);
	label = gtk_label_new(date_and_time);
	gtk_container_add(GTK_CONTAINER(eventbox), label);

	return frame;
}
