## $Id: yat_cxx11.m4 4207 2022-08-26 04:36:28Z peter $
#
# serial 7  (yat 0.20)
#
# see http://www.gnu.org/software/automake/manual/automake.html#Serials
#
# SYNOPSIS
#
#   YAT_CXX11([search], [action-if-found], [action-if-not-found])
#   YAT_CXX_ATOMIC([ACTION-IF-FOUND], [ACTION-IF-NOT-FOUND])
#   YAT_CXX_RVALUE([ACTION-IF-FOUND], [ACTION-IF-NOT-FOUND])
#   YAT_CXX_LOG2([ACTION-IF-FOUND], [ACTION-IF-NOT-FOUND])
#
# DESCRIPTION
#
#   Test whether $CXX supports cxx11 features
#
# LAST MODIFICATION
#
#   $Date: 2022-08-26 14:36:28 +1000 (Fri, 26 Aug 2022) $
#
# COPYLEFT
#
#   Copyright (C) 2017, 2018, 2019, 2020, 2021 Peter Johansson
#
#   This file is part of the yat library, http://dev.thep.lu.se/yat
#
#   The yat library is free software; you can redistribute it and/or
#   modify it under the terms of the GNU General Public License as
#   published by the Free Software Foundation; either version 3 of the
#   License, or (at your option) any later version.
#
#   The yat library is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#   General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with yat. If not, see <http://www.gnu.org/licenses/>.
#

# YAT_CXX11([search], [action-if-found], [action-if-not-found])
#
# Test whether $CXX is a C++11 compliant compiler. If not and search
# is 'yes', then search different switches to $CXX to see if
# compliance can be turned on. If a C++11 compliant compiler is found,
# AC_DEFINE HAVE_CXX11, set shell variable HAVE_CXX11 to 1 and
# AC_SUBST it. Otherwise set HAVE_CXX11 to 0 and execute
# action-if-not-found.
AC_DEFUN([YAT_CXX11], [

AC_MSG_CHECKING([whether $CXX supports C++11 features])
AC_COMPILE_IFELSE([AC_LANG_SOURCE([_AX_CXX_COMPILE_STDCXX_testbody_11])], [
    AC_MSG_RESULT([yes])
    HAVE_CXX11=1
    AC_DEFINE([HAVE_CXX11], [1], [define if the compiler supports C++11 syntax])
  ], [
    AC_MSG_RESULT([no])
    HAVE_CXX11=0
    AS_IF([test x"$1" = x"yes"], [
      # This macro sets HAVE_CXX11=1 if successful and AC_DEFINE
      AX_CXX_COMPILE_STDCXX([11], [noext], [optional])
	  ])
  ])
AC_SUBST([HAVE_CXX11])
# ACTION
AS_VAR_IF([HAVE_CXX11], [1], [$2], [$3])

]) # end of YAT_CXX11


# YAT_CXX_ATOMIC([action-if-found], [action-if-not-found], [search-options])
#
# Test whether $CXX supports std::atomic. If not and search-options is
# 'yes', try turning on support with a number of different
# switches. If a successful switch is found invoke shell
# action-if-found; else issue action-if-not-found.
AC_DEFUN([YAT_CXX_ATOMIC],
[
YAT_CXX_TRY_CXX11([atomic],
  [@%:@include <atomic>],
  [std::atomic<bool> ready(false);],
  [$1], [$2], [$3])
])


# YAT_CXX_RVALUE([action-if-found], [action-if-not-found], [search-options])
#
# Test whether $CXX supports rvalue. If not and search-options is
# 'yes', try turning on support with a number of different
# switches. If a successful switch is found invoke shell
# action-if-found; else issue action-if-not-found.
AC_DEFUN([YAT_CXX_RVALUE],
[
YAT_CXX_TRY_CXX11([rvalue], [ dnl header
  @%:@include <utility>

  class MyClass
  {
  public:
    MyClass(void);
    MyClass(const MyClass&); // copy constructor
    MyClass(MyClass&&); // move constructor
    MyClass& operator=(const MyClass&); // copy assignment
    MyClass& operator=(MyClass&&); // move assignment
  };
  ],[ dnl body
  MyClass mc;
  MyClass mc2 = std::move(mc);
  ], [$1], [$2], [$3])
])


# YAT_CXX_LOG2([action-if-found], [action-if-not-found], [search-options])
#
# Test whether $CXX supports std::log2. If not and search-options is
# 'yes', try turning on support with a number of different
# switches. If a successful switch is found invoke shell
# action-if-found; else issue action-if-not-found.
AC_DEFUN([YAT_CXX_LOG2],
[
YAT_CXX_TRY_CXX11([log2], [ dnl header
  @%:@include <cmath>
  void foo(double x);
  ],[ dnl body
  double x = std::log2(3.14);
  foo(x);
  ], [$1], [$2], [$3])
])


# YAT_CXX_THROW_IF_NESTED([action-if-found], [action-if-not-found],
#                         [search-options])
#
# Test whether $CXX supports std::nested_exception. If not and
# search-options is 'yes', try turning on support with a number of
# different switches. If a successful switch is found invoke shell
# action-if-found; else issue action-if-not-found.
AC_DEFUN([YAT_CXX_THROW_IF_NESTED],
[
YAT_CXX_TRY_CXX11([throw_if_nested], [ dnl header
  @%:@include <exception>
  @%:@include <stdexcept>
  void foo(void);
  ],[ dnl body
  try {
    foo();
  }
  catch (std::runtime_error& e) {
    std::throw_with_nested(std::runtime_error("foo"));
  }
  catch (std::exception& e) {
    std::rethrow_if_nested(e);
  }
  ], [$1], [$2], [$3])
])


# YAT_CXX_TRY_CXX11(feature, prologue, body, [action-if-success],
#                   [action-if-failed], [search-options])
#
# Try c++11 feature, feature, by using code with prologue and body. If
# successful, issue shell code action-if-success, otherwise if
# search-options is 'yes' retry with different CXX options as detailed
# in YAT_CXX_SEARCH_CXX11; if none works, issue shell code action-if-failed.
AC_DEFUN([YAT_CXX_TRY_CXX11],
[
AS_IF([test x"$6" = x"yes"], [
  YAT_CXX_SEARCH_CXX11([$1], [$2], [$3], [$4], [$5])
], [
  AS_VAR_PUSHDEF([my_CACHE], [yat_cv_cxx_try_$1])dnl
  AC_CACHE_CHECK([if $CXX supports $1],
    [my_CACHE],
    [AC_COMPILE_IFELSE([AC_LANG_PROGRAM([$2], [$3])],
                       [my_CACHE=yes],
                       [my_CACHE=no])])
  AS_VAR_IF([my_CACHE], [yes], [$4], [$5])
  AS_VAR_POPDEF([my_CACHE])
])
]) #YAT_CXX_TRY_CXX11


# YAT_CXX_SEARCH_CXX11([feature], [prologue], [body], [action-if-found],
#                      [action-if-not-found])
#
# Try feature by using code with prologue and body, first with CXX and
# then by adding switches to CXX. If a switch is found with which code
# compiles, issue action-if-found; otherwise issue
# action-if-not-found.
AC_DEFUN([YAT_CXX_SEARCH_CXX11],
[
AS_VAR_PUSHDEF([my_CACHE], [yat_cv_cxx_search_$1])dnl
AC_CACHE_CHECK([for $CXX option to enable $1],
  [my_CACHE],
  [my_CACHE=no
   AS_VAR_PUSHDEF([my_save_CXX], [yat_cxx_$1_save_CXX])dnl
   my_save_CXX="$CXX"
# From autoconf 'c.m4' we have
# GCC -std=c++11 -std=c++0x
# IBM XL C -qlanglvl=stdcxx11
# HP aC++ -AA
# INTEL -std=c++11 -std=c++0x
# from ax_cxx_compile_stdcxx.m4 we have
# HP's aCC needs +std=c++11
# Cray's crayCC '-h std=c++11'
# but first we try with empty string, hoping compiler is modern.
   for yat_arg in '' -std=c++11 -std=c++0x -qlanglvl=stdcxx11 -AA +std=c++11 "-h std=c++11" ; do
     CXX="$my_save_CXX $yat_arg"
     AC_COMPILE_IFELSE([AC_LANG_PROGRAM([$2], [$3])],
                       [my_CACHE="$yat_arg"],
                       [])
     AS_VAR_IF([my_CACHE], [no], [], [break])
   done
   # restore CXX
   CXX="$my_save_CXX"

   AS_CASE([x"$my_CACHE"],
           [x], [my_CACHE="none needed"],
           [x"no"], [my_CACHE=unsupported])

   AS_VAR_POPDEF([my_save_CXX])
  ])

AS_CASE([$my_CACHE],
        ["none needed"], [$4],
        [unsupported], [$5],
        [CXX="$CXX $my_CACHE"
         $4])
AS_VAR_POPDEF([my_CACHE])
])
