/*
 * Decompiled with CFR 0.152.
 */
package it.polito.appeal.traci;

import de.tudresden.sumo.util.CommandProcessor;
import de.tudresden.sumo.util.SumoCommand;
import it.polito.appeal.traci.CloseQuery;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;

public class SumoTraciConnection {
    private String configFile;
    private int randomSeed;
    private int remotePort;
    private Socket socket;
    private String net_file;
    private String route_file;
    String sumoEXE = "/opt/sumo/sumo-0.15.0/bin/sumo";
    private CommandProcessor cp;
    private Process sumoProcess;
    private static final int CONNECT_RETRIES = 3;
    private CloseQuery closeQuery;
    private List<String> args = new ArrayList<String>();
    private boolean remote = false;

    public SumoTraciConnection(String string, String string2, String string3) {
        this.sumoEXE = string;
        this.net_file = string2;
        this.route_file = string3;
    }

    public SumoTraciConnection(String string, String string2) {
        this.sumoEXE = string;
        this.configFile = string2;
    }

    public SumoTraciConnection(String string, int n, boolean bl) {
        this.randomSeed = n;
        this.configFile = string;
    }

    public SumoTraciConnection(SocketAddress socketAddress) throws IOException, InterruptedException {
        this.remote = true;
        this.socket = new Socket();
        int n = 500;
        for (int i = 0; i < 3; ++i) {
            try {
                this.socket.connect(socketAddress);
                break;
            }
            catch (ConnectException connectException) {
                Thread.sleep(n);
                n *= 2;
                continue;
            }
        }
        if (!this.socket.isConnected()) {
            throw new IOException("can't connect to SUMO server");
        }
        this.cp = new CommandProcessor(this.socket);
    }

    public void addOption(String string, String string2) {
        this.args.add("--" + string);
        if (string2 != null) {
            this.args.add(string2);
        }
    }

    public void runServer() throws IOException {
        if (!this.remote) {
            this.findAvailablePort();
            this.runSUMO();
            int n = 500;
            try {
                for (int i = 0; i < 3; ++i) {
                    this.socket = new Socket();
                    try {
                        this.socket.connect(new InetSocketAddress("127.0.0.1", this.remotePort));
                        break;
                    }
                    catch (ConnectException connectException) {
                        Thread.sleep(n);
                        n *= 2;
                        continue;
                    }
                }
                if (!this.socket.isConnected()) {
                    throw new IOException("can't connect to SUMO server");
                }
                this.cp = new CommandProcessor(this.socket);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            this.closeQuery = new CloseQuery(this.socket);
        }
    }

    private void runSUMO() throws IOException {
        this.args.add(0, this.sumoEXE);
        if (this.configFile != null) {
            this.args.add("-c");
            this.args.add(this.configFile);
        } else {
            this.args.add("--net-file");
            this.args.add(this.net_file);
            this.args.add("--route-files");
            this.args.add(this.route_file);
        }
        this.args.add("--remote-port");
        this.args.add(Integer.toString(this.remotePort));
        if (this.randomSeed != -1) {
            this.args.add("--seed");
            this.args.add(Integer.toString(this.randomSeed));
        }
        String[] stringArray = new String[this.args.size()];
        this.args.toArray(stringArray);
        this.sumoProcess = Runtime.getRuntime().exec(stringArray);
        StreamLogger streamLogger = new StreamLogger(this.sumoProcess.getErrorStream(), "SUMO-err:");
        StreamLogger streamLogger2 = new StreamLogger(this.sumoProcess.getInputStream(), "SUMO-out:");
        new Thread((Runnable)streamLogger, "StreamLogger-SUMO-err").start();
        new Thread((Runnable)streamLogger2, "StreamLogger-SUMO-out").start();
    }

    private void findAvailablePort() throws IOException {
        ServerSocket serverSocket = new ServerSocket(0);
        this.remotePort = serverSocket.getLocalPort();
        serverSocket.close();
        serverSocket = null;
    }

    public void close() {
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void closeAndDontCareAboutInterruptedException() {
        this.close();
    }

    public boolean isClosed() {
        return this.socket == null || this.socket.isClosed();
    }

    public synchronized void do_job_set(SumoCommand sumoCommand) throws Exception {
        if (this.isClosed()) {
            throw new IllegalStateException("connection is closed");
        }
        try {
            this.cp.do_job_set(sumoCommand);
        }
        catch (Exception exception) {
            this.closeAndDontCareAboutInterruptedException();
            throw exception;
        }
    }

    public synchronized Object do_job_get(SumoCommand sumoCommand) throws Exception {
        Object object = null;
        if (this.isClosed()) {
            throw new IllegalStateException("connection is closed");
        }
        try {
            object = this.cp.do_job_get(sumoCommand);
        }
        catch (Exception exception) {
            this.closeAndDontCareAboutInterruptedException();
            throw exception;
        }
        return object;
    }

    public synchronized void do_timestep() throws Exception {
        if (this.isClosed()) {
            throw new IllegalStateException("connection is closed");
        }
        try {
            this.cp.do_job_set(new SumoCommand(2, 0));
        }
        catch (Exception exception) {
            this.closeAndDontCareAboutInterruptedException();
            throw exception;
        }
    }

    private static class StreamLogger
    implements Runnable {
        final InputStream stream;
        final String prefix;

        public StreamLogger(InputStream inputStream, String string) {
            this.stream = inputStream;
            this.prefix = string;
        }

        @Override
        public void run() {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.stream));
            try {
                String string;
                while ((string = bufferedReader.readLine()) != null) {
                    if (!string.contains("Error:") || string.contains("peer shutdown")) continue;
                    System.err.println(string);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

