/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.sumo.util;

import it.polito.appeal.traci.TraCIException;
import it.polito.appeal.traci.protocol.Command;
import it.polito.appeal.traci.protocol.RequestMessage;
import it.polito.appeal.traci.protocol.ResponseContainer;
import it.polito.appeal.traci.protocol.ResponseMessage;
import it.polito.appeal.traci.protocol.StatusResponse;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.List;

public abstract class Query {
    private final DataOutputStream outStream;
    private final DataInputStream inStream;

    public Query(Socket socket) throws IOException {
        this.outStream = new DataOutputStream(socket.getOutputStream());
        this.inStream = new DataInputStream(socket.getInputStream());
    }

    protected ResponseMessage doQuery(RequestMessage requestMessage) throws IOException {
        requestMessage.writeTo(this.getOutStream());
        return new ResponseMessage(this.inStream);
    }

    protected ResponseMessage queryAndVerify(RequestMessage requestMessage) throws IOException {
        requestMessage.writeTo(this.getOutStream());
        ResponseMessage responseMessage = new ResponseMessage(this.inStream);
        List<Command> list = requestMessage.commands();
        List<ResponseContainer> list2 = responseMessage.responses();
        if (list.size() > list2.size()) {
            throw new TraCIException("not enough responses received");
        }
        for (int i = 0; i < list.size(); ++i) {
            Command command = list.get(i);
            ResponseContainer responseContainer = list2.get(i);
            StatusResponse statusResponse = responseContainer.getStatus();
            Query.verify("command and status IDs match", (Object)command.id(), statusResponse.id());
            if (statusResponse.result() == 0) continue;
            throw new TraCIException("SUMO error for command " + statusResponse.id() + ": " + statusResponse.description());
        }
        return responseMessage;
    }

    protected ResponseContainer doQuerySingle(Command command) throws IOException {
        RequestMessage requestMessage = new RequestMessage();
        requestMessage.append(command);
        ResponseMessage responseMessage = this.doQuery(requestMessage);
        return responseMessage.responses().iterator().next();
    }

    protected ResponseContainer queryAndVerifySingle(Command command) throws IOException {
        RequestMessage requestMessage = new RequestMessage();
        requestMessage.append(command);
        ResponseMessage responseMessage = this.queryAndVerify(requestMessage);
        return responseMessage.responses().iterator().next();
    }

    protected static String verifyGetVarResponse(Command command, int n, int n2, String string) throws TraCIException.UnexpectedData {
        Query.verify("response code", (Object)n, command.id());
        Query.verify("variable ID", (Object)n2, (Object)command.content().readUnsignedByte());
        String string2 = command.content().readStringASCII();
        if (string != null) {
            Query.verify("object ID", string, string2);
        }
        return string2;
    }

    protected static void verify(String string, Object object, Object object2) throws TraCIException.UnexpectedData {
        if (!object2.equals(object)) {
            throw new TraCIException.UnexpectedData(string, object, object2);
        }
    }

    protected static void verify(String string, int n, short s) throws TraCIException.UnexpectedData {
        Query.verify(string, (Object)n, (Object)s);
    }

    protected static void verify(String string, int n, byte by) throws TraCIException.UnexpectedData {
        Query.verify(string, (Object)n, (Object)by);
    }

    public DataOutputStream getOutStream() {
        return this.outStream;
    }
}

