/*
 * Decompiled with CFR 0.152.
 */
package cadyts.interfaces.sumo;

import cadyts.calibrators.filebased.xml.XMLPopulationFileReader;
import cadyts.demand.ODRelation;
import cadyts.demand.PlanBuilder;
import cadyts.interfaces.sumo.SumoAgent;
import cadyts.interfaces.sumo.SumoPopulationHandler;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

class SumoAgentCloner {
    private final PlanBuilder<String> planBuilder;
    private final Map<ODRelation<String>, List<Object>> od2agentIDs;
    private final Set<Object> cloneAgentIDs;

    SumoAgentCloner(PlanBuilder<String> planBuilder) {
        if (planBuilder == null) {
            throw new IllegalArgumentException("planBuilder is null");
        }
        this.planBuilder = planBuilder;
        this.od2agentIDs = new LinkedHashMap<ODRelation<String>, List<Object>>();
        this.cloneAgentIDs = new LinkedHashSet<Object>();
    }

    Set<Object> getClonedAgentIDs() {
        return this.cloneAgentIDs;
    }

    void run(String[] fileNames, double demandScale) {
        if (fileNames == null) {
            throw new IllegalArgumentException("file name is null");
        }
        if (demandScale < 1.0 || demandScale > 2.0) {
            throw new IllegalArgumentException("demand scale of " + demandScale + " is not in [1,2]");
        }
        this.od2agentIDs.clear();
        String[] stringArray = fileNames;
        int n = fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            if (fileName != null && fileName.length() > 0) {
                Logger.getLogger(this.getClass().getName()).info("cloning file: " + fileName);
                XMLPopulationFileReader<SumoAgent> reader = new XMLPopulationFileReader<SumoAgent>();
                SumoPopulationHandler handler = new SumoPopulationHandler(this.planBuilder, null, 1.0);
                reader.setPopulationHandler(handler);
                for (SumoAgent agent : reader.getPopulationSource(fileName)) {
                    List<Object> agentIDs = this.od2agentIDs.get(agent.getODRelation());
                    if (agentIDs == null) {
                        agentIDs = new ArrayList<Object>();
                        this.od2agentIDs.put(agent.getODRelation(), agentIDs);
                    }
                    agentIDs.add(agent.getId());
                }
            }
            ++n2;
        }
        this.cloneAgentIDs.clear();
        double m = 1.0 / (demandScale - 1.0);
        int totalCnt = 0;
        for (Map.Entry<ODRelation<String>, List<Object>> entry : this.od2agentIDs.entrySet()) {
            double cnt = 0.0;
            for (Object agentID : entry.getValue()) {
                ++totalCnt;
                if (!((cnt += 1.0) >= m)) continue;
                this.cloneAgentIDs.add(agentID);
                cnt -= m;
            }
        }
        Logger.getLogger(this.getClass().getName()).info("cloned " + this.cloneAgentIDs.size() + " out of " + totalCnt + " agents");
    }

    public static void main(String[] args) {
        SumoAgentCloner g = new SumoAgentCloner(new PlanBuilder<String>());
        g.run(new String[]{"testdata/sumo/choiceset.xml", "testdata/sumo/emptyChoiceSet.xml"}, 1.333);
        System.out.println("DONE");
    }
}

