/*
 * Decompiled with CFR 0.152.
 */
package ui.propertypanels;

import classes.Project;
import classes.TypeSelection;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import simulation.VehicleType;
import trafficdefinition.HotSpot;
import ui.controls.SimTimeEdit;
import ui.dialogs.DlgSelectTypes;

public class PnlHotSpotProperties
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JButton btnChangeColor = null;
    private JButton btnSelectVehicleTypes = null;
    private JCheckBox chkDirectionIn = null;
    private JCheckBox chkDirectionOut = null;
    private HotSpot currentHotSpot = null;
    private ButtonGroup IncomingTimeTypeGroup = new ButtonGroup();
    private JLabel lblColorTitle = null;
    private JLabel lblIncomingEndTime = null;
    private JLabel lblInIcon = null;
    private JLabel lblNameTitle = null;
    private JLabel lblNumberOfVehiclesTitle = null;
    private JLabel lblOutgoingBeginTime = null;
    private JLabel lblOutgoingEndTime = null;
    private JLabel lblOutIcon = null;
    private JRadioButton rbIncomingTypeArrival = null;
    private JRadioButton rbIncomingTypeDeparture = null;
    private JSpinner spnNumberOfVehicles = null;
    private SimTimeEdit steIncomingBeginTime = null;
    private SimTimeEdit steIncomingEndTime = null;
    private SimTimeEdit steOutgoingBeginTime = null;
    private SimTimeEdit steOutgoingEndTime = null;
    private JTextField txtName = null;
    private JCheckBox chkEnabled = null;
    private JLabel lblIncomingBeginTime = null;

    public PnlHotSpotProperties() {
        this.initialize();
    }

    public void setHotSpot(HotSpot hotSpot) {
        this.currentHotSpot = hotSpot;
        this.txtName.setText(this.currentHotSpot.getName());
        this.spnNumberOfVehicles.setValue(this.currentHotSpot.getNumberOfVehicles());
        this.btnChangeColor.setBackground(this.currentHotSpot.getColor());
        this.chkDirectionIn.setSelected(this.currentHotSpot.isDirectionIn());
        this.chkDirectionOut.setSelected(this.currentHotSpot.isDirectionOut());
        if (this.currentHotSpot.getDirectionInType() == HotSpot.DirectionInTimeType.TimeOfArrivalToDestination) {
            this.rbIncomingTypeArrival.setSelected(true);
            this.rbIncomingTypeDeparture.setSelected(false);
        } else if (this.currentHotSpot.getDirectionInType() == HotSpot.DirectionInTimeType.TimeOfDepartureFromSource) {
            this.rbIncomingTypeArrival.setSelected(false);
            this.rbIncomingTypeDeparture.setSelected(true);
        }
        this.steIncomingBeginTime.setValue(this.currentHotSpot.getDirectionInBeginTime());
        this.steIncomingEndTime.setValue(this.currentHotSpot.getDirectionInEndTime());
        this.steOutgoingBeginTime.setValue(this.currentHotSpot.getDirectionOutBeginTime());
        this.steOutgoingEndTime.setValue(this.currentHotSpot.getDirectionOutEndTime());
        this.chkEnabled.setSelected(this.currentHotSpot.isEnabled());
    }

    private JButton getBtnChangeColor() {
        if (this.btnChangeColor == null) {
            this.btnChangeColor = new JButton();
            this.btnChangeColor.setPreferredSize(new Dimension(86, 20));
            this.btnChangeColor.setText("");
            this.btnChangeColor.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PnlHotSpotProperties.this.ChangeColor();
                }
            });
        }
        return this.btnChangeColor;
    }

    private JButton getBtnSelectVehicleTypes() {
        if (this.btnSelectVehicleTypes == null) {
            this.btnSelectVehicleTypes = new JButton();
            this.btnSelectVehicleTypes.setPreferredSize(new Dimension(150, 20));
            this.btnSelectVehicleTypes.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/vehicletypes.png")));
            this.btnSelectVehicleTypes.setText("Vehicle types...");
            this.btnSelectVehicleTypes.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PnlHotSpotProperties.this.SelectVehicleTypes();
                }
            });
        }
        return this.btnSelectVehicleTypes;
    }

    private JCheckBox getChkDirectionIn() {
        if (this.chkDirectionIn == null) {
            this.chkDirectionIn = new JCheckBox();
            this.chkDirectionIn.setText("Incoming");
            this.chkDirectionIn.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        PnlHotSpotProperties.this.DisableEnableIncomingControls(true);
                        PnlHotSpotProperties.this.currentHotSpot.setDirectionIn(true);
                    } else {
                        PnlHotSpotProperties.this.DisableEnableIncomingControls(false);
                        PnlHotSpotProperties.this.currentHotSpot.setDirectionIn(false);
                    }
                }
            });
        }
        return this.chkDirectionIn;
    }

    private JCheckBox getChkDirectionOut() {
        if (this.chkDirectionOut == null) {
            this.chkDirectionOut = new JCheckBox();
            this.chkDirectionOut.setText("Outgoing");
            this.chkDirectionOut.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        PnlHotSpotProperties.this.DisableEnableOutgoingControls(true);
                        PnlHotSpotProperties.this.currentHotSpot.setDirectionOut(true);
                    } else {
                        PnlHotSpotProperties.this.DisableEnableOutgoingControls(false);
                        PnlHotSpotProperties.this.currentHotSpot.setDirectionOut(false);
                    }
                }
            });
        }
        return this.chkDirectionOut;
    }

    private JRadioButton getRbIncomingTypeArrival() {
        if (this.rbIncomingTypeArrival == null) {
            this.rbIncomingTypeArrival = new JRadioButton();
            this.rbIncomingTypeArrival.setText("Time of arrival to destination");
            this.rbIncomingTypeArrival.setEnabled(false);
            this.rbIncomingTypeArrival.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        PnlHotSpotProperties.this.currentHotSpot.setDirectionInType(HotSpot.DirectionInTimeType.TimeOfArrivalToDestination);
                    } else {
                        PnlHotSpotProperties.this.currentHotSpot.setDirectionInType(HotSpot.DirectionInTimeType.TimeOfDepartureFromSource);
                    }
                }
            });
        }
        return this.rbIncomingTypeArrival;
    }

    private JRadioButton getRbIncomingTypeDeparture() {
        if (this.rbIncomingTypeDeparture == null) {
            this.rbIncomingTypeDeparture = new JRadioButton();
            this.rbIncomingTypeDeparture.setText("Time of departure from source");
            this.rbIncomingTypeDeparture.setEnabled(false);
            this.rbIncomingTypeDeparture.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        PnlHotSpotProperties.this.currentHotSpot.setDirectionInType(HotSpot.DirectionInTimeType.TimeOfDepartureFromSource);
                    } else {
                        PnlHotSpotProperties.this.currentHotSpot.setDirectionInType(HotSpot.DirectionInTimeType.TimeOfArrivalToDestination);
                    }
                }
            });
        }
        return this.rbIncomingTypeDeparture;
    }

    private JSpinner getSpnNumberOfVehicles() {
        if (this.spnNumberOfVehicles == null) {
            this.spnNumberOfVehicles = new JSpinner();
            this.spnNumberOfVehicles.setPreferredSize(new Dimension(70, 20));
            this.spnNumberOfVehicles.setModel(new SpinnerNumberModel(1, 1, 1000000, 1));
            this.spnNumberOfVehicles.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    PnlHotSpotProperties.this.currentHotSpot.setNumberOfVehicles((Integer)PnlHotSpotProperties.this.spnNumberOfVehicles.getValue());
                }
            });
        }
        return this.spnNumberOfVehicles;
    }

    private SimTimeEdit getSteIncomingBeginTime() {
        if (this.steIncomingBeginTime == null) {
            this.steIncomingBeginTime = new SimTimeEdit();
            this.steIncomingBeginTime.setEnabled(false);
            this.steIncomingBeginTime.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    PnlHotSpotProperties.this.currentHotSpot.setDirectionInBeginTime(PnlHotSpotProperties.this.steIncomingBeginTime.getValue());
                }
            });
        }
        return this.steIncomingBeginTime;
    }

    private SimTimeEdit getSteIncomingEndTime() {
        if (this.steIncomingEndTime == null) {
            this.steIncomingEndTime = new SimTimeEdit();
            this.steIncomingEndTime.setEnabled(false);
            this.steIncomingEndTime.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    PnlHotSpotProperties.this.currentHotSpot.setDirectionInEndTime(PnlHotSpotProperties.this.steIncomingEndTime.getValue());
                }
            });
        }
        return this.steIncomingEndTime;
    }

    private SimTimeEdit getSteOutgoingBeginTime() {
        if (this.steOutgoingBeginTime == null) {
            this.steOutgoingBeginTime = new SimTimeEdit();
            this.steOutgoingBeginTime.setEnabled(false);
            this.steOutgoingBeginTime.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    PnlHotSpotProperties.this.currentHotSpot.setDirectionOutBeginTime(PnlHotSpotProperties.this.steOutgoingBeginTime.getValue());
                }
            });
        }
        return this.steOutgoingBeginTime;
    }

    private SimTimeEdit getSteOutgoingEndTime() {
        if (this.steOutgoingEndTime == null) {
            this.steOutgoingEndTime = new SimTimeEdit();
            this.steOutgoingEndTime.setEnabled(false);
            this.steOutgoingEndTime.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    PnlHotSpotProperties.this.currentHotSpot.setDirectionOutEndTime(PnlHotSpotProperties.this.steOutgoingEndTime.getValue());
                }
            });
        }
        return this.steOutgoingEndTime;
    }

    private JTextField getTxtName() {
        if (this.txtName == null) {
            this.txtName = new JTextField();
            this.txtName.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    PnlHotSpotProperties.this.currentHotSpot.setName(PnlHotSpotProperties.this.txtName.getText());
                }
            });
        }
        return this.txtName;
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 10);
        gridBagConstraints.anchor = 12;
        gridBagConstraints.gridy = 8;
        this.lblIncomingBeginTime = new JLabel();
        this.lblIncomingBeginTime.setText("Begin Time:");
        this.lblIncomingBeginTime.setEnabled(false);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.gridy = 8;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.gridy = 3;
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 1;
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.gridy = 11;
        this.lblOutIcon = new JLabel();
        this.lblOutIcon.setText("");
        this.lblOutIcon.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/hotspotout.png")));
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 1;
        gridBagConstraints5.anchor = 17;
        gridBagConstraints5.gridy = 5;
        this.lblInIcon = new JLabel();
        this.lblInIcon.setText("");
        this.lblInIcon.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/hotspotin.png")));
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridx = 0;
        gridBagConstraints6.anchor = 12;
        gridBagConstraints6.insets = new Insets(5, 0, 0, 5);
        gridBagConstraints6.gridy = 13;
        this.lblOutgoingEndTime = new JLabel();
        this.lblOutgoingEndTime.setText("End time:");
        this.lblOutgoingEndTime.setEnabled(false);
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.gridx = 0;
        gridBagConstraints7.anchor = 12;
        gridBagConstraints7.insets = new Insets(5, 0, 0, 5);
        gridBagConstraints7.gridy = 12;
        this.lblOutgoingBeginTime = new JLabel();
        this.lblOutgoingBeginTime.setText("Begin time:");
        this.lblOutgoingBeginTime.setEnabled(false);
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.gridx = 0;
        gridBagConstraints8.anchor = 12;
        gridBagConstraints8.insets = new Insets(5, 0, 0, 10);
        gridBagConstraints8.gridy = 9;
        this.lblIncomingEndTime = new JLabel();
        this.lblIncomingEndTime.setText("End time:");
        this.lblIncomingEndTime.setEnabled(false);
        GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
        gridBagConstraints9.gridx = 0;
        gridBagConstraints9.anchor = 12;
        gridBagConstraints9.insets = new Insets(10, 0, 0, 5);
        gridBagConstraints9.gridy = 7;
        GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
        gridBagConstraints10.anchor = 18;
        gridBagConstraints10.gridx = 1;
        gridBagConstraints10.gridy = 13;
        gridBagConstraints10.weighty = 1.0;
        gridBagConstraints10.insets = new Insets(5, 10, 0, 0);
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.anchor = 12;
        gridBagConstraints11.gridx = 0;
        gridBagConstraints11.gridy = 13;
        gridBagConstraints11.weighty = 1.0;
        gridBagConstraints11.insets = new Insets(5, 0, 0, 10);
        GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
        gridBagConstraints12.insets = new Insets(5, 10, 2, 0);
        gridBagConstraints12.gridy = 12;
        gridBagConstraints12.anchor = 18;
        gridBagConstraints12.gridx = 1;
        GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
        gridBagConstraints13.anchor = 12;
        gridBagConstraints13.gridx = 0;
        gridBagConstraints13.gridy = 12;
        gridBagConstraints13.insets = new Insets(5, 0, 0, 10);
        GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
        gridBagConstraints14.anchor = 18;
        gridBagConstraints14.gridx = 1;
        gridBagConstraints14.gridy = 9;
        gridBagConstraints14.insets = new Insets(5, 10, 2, 0);
        GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
        gridBagConstraints15.anchor = 12;
        gridBagConstraints15.gridx = 0;
        gridBagConstraints15.gridy = 9;
        gridBagConstraints15.insets = new Insets(5, 0, 0, 10);
        GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
        gridBagConstraints16.insets = new Insets(10, 10, 2, 0);
        gridBagConstraints16.gridy = 8;
        gridBagConstraints16.anchor = 18;
        gridBagConstraints16.gridx = 1;
        GridBagConstraints gridBagConstraints17 = new GridBagConstraints();
        gridBagConstraints17.anchor = 17;
        gridBagConstraints17.gridx = 0;
        gridBagConstraints17.gridy = 7;
        gridBagConstraints17.gridwidth = 2;
        gridBagConstraints17.insets = new Insets(0, 20, 0, 0);
        GridBagConstraints gridBagConstraints18 = new GridBagConstraints();
        gridBagConstraints18.anchor = 17;
        gridBagConstraints18.gridx = 0;
        gridBagConstraints18.gridy = 6;
        gridBagConstraints18.weightx = 0.0;
        gridBagConstraints18.gridwidth = 2;
        gridBagConstraints18.insets = new Insets(0, 20, 0, 0);
        GridBagConstraints gridBagConstraints19 = new GridBagConstraints();
        gridBagConstraints19.gridx = 0;
        gridBagConstraints19.insets = new Insets(0, 10, 0, 0);
        gridBagConstraints19.anchor = 17;
        gridBagConstraints19.gridy = 11;
        GridBagConstraints gridBagConstraints20 = new GridBagConstraints();
        gridBagConstraints20.gridx = 0;
        gridBagConstraints20.anchor = 17;
        gridBagConstraints20.insets = new Insets(0, 10, 0, 0);
        gridBagConstraints20.gridy = 5;
        GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
        gridBagConstraints21.gridx = 1;
        gridBagConstraints21.anchor = 17;
        gridBagConstraints21.gridy = 1;
        GridBagConstraints gridBagConstraints22 = new GridBagConstraints();
        gridBagConstraints22.gridx = 0;
        gridBagConstraints22.insets = new Insets(10, 2, 10, 2);
        gridBagConstraints22.anchor = 11;
        gridBagConstraints22.gridwidth = 2;
        gridBagConstraints22.gridy = 4;
        GridBagConstraints gridBagConstraints23 = new GridBagConstraints();
        gridBagConstraints23.gridx = 1;
        gridBagConstraints23.insets = new Insets(2, 0, 2, 10);
        gridBagConstraints23.fill = 1;
        gridBagConstraints23.gridy = 2;
        GridBagConstraints gridBagConstraints24 = new GridBagConstraints();
        gridBagConstraints24.gridx = 0;
        gridBagConstraints24.anchor = 17;
        gridBagConstraints24.insets = new Insets(0, 10, 0, 0);
        gridBagConstraints24.gridy = 2;
        this.lblColorTitle = new JLabel();
        this.lblColorTitle.setText("Color:");
        GridBagConstraints gridBagConstraints25 = new GridBagConstraints();
        gridBagConstraints25.gridx = 0;
        gridBagConstraints25.anchor = 17;
        gridBagConstraints25.insets = new Insets(0, 10, 0, 5);
        gridBagConstraints25.gridy = 1;
        this.lblNumberOfVehiclesTitle = new JLabel();
        this.lblNumberOfVehiclesTitle.setText("Number of vehicles:");
        GridBagConstraints gridBagConstraints26 = new GridBagConstraints();
        gridBagConstraints26.fill = 2;
        gridBagConstraints26.gridy = 0;
        gridBagConstraints26.weightx = 1.0;
        gridBagConstraints26.insets = new Insets(10, 0, 0, 10);
        gridBagConstraints26.gridx = 1;
        GridBagConstraints gridBagConstraints27 = new GridBagConstraints();
        gridBagConstraints27.gridx = 0;
        gridBagConstraints27.anchor = 17;
        gridBagConstraints27.insets = new Insets(10, 10, 0, 0);
        gridBagConstraints27.gridy = 0;
        this.lblNameTitle = new JLabel();
        this.lblNameTitle.setText("Name:");
        this.setSize(315, 433);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.lblNameTitle, gridBagConstraints27);
        this.add((Component)this.getTxtName(), gridBagConstraints26);
        this.add((Component)this.lblNumberOfVehiclesTitle, gridBagConstraints25);
        this.add((Component)this.lblColorTitle, gridBagConstraints24);
        this.add((Component)this.getBtnChangeColor(), gridBagConstraints23);
        this.add((Component)this.getBtnSelectVehicleTypes(), gridBagConstraints22);
        this.add((Component)this.getSpnNumberOfVehicles(), gridBagConstraints21);
        this.add((Component)this.getChkDirectionIn(), gridBagConstraints20);
        this.add((Component)this.getChkDirectionOut(), gridBagConstraints19);
        this.add((Component)this.getRbIncomingTypeDeparture(), gridBagConstraints18);
        this.add((Component)this.getRbIncomingTypeArrival(), gridBagConstraints17);
        this.add((Component)this.getSteIncomingBeginTime(), gridBagConstraints16);
        this.add((Component)this.getSteIncomingEndTime(), gridBagConstraints14);
        this.add((Component)this.getSteOutgoingBeginTime(), gridBagConstraints12);
        this.add((Component)this.getSteOutgoingEndTime(), gridBagConstraints10);
        this.add((Component)this.lblInIcon, gridBagConstraints5);
        this.add((Component)this.lblOutIcon, gridBagConstraints4);
        this.add((Component)this.getChkEnabled(), gridBagConstraints3);
        this.add((Component)this.lblIncomingBeginTime, gridBagConstraints);
        this.add((Component)this.lblIncomingEndTime, gridBagConstraints8);
        this.add((Component)this.lblOutgoingBeginTime, gridBagConstraints7);
        this.add((Component)this.lblOutgoingEndTime, gridBagConstraints6);
        this.IncomingTimeTypeGroup.add(this.rbIncomingTypeArrival);
        this.IncomingTimeTypeGroup.add(this.rbIncomingTypeDeparture);
    }

    protected void ChangeColor() {
        Color color = JColorChooser.showDialog(this, "Select flow color", this.currentHotSpot.getColor());
        if (color != null) {
            this.currentHotSpot.setColor(color);
            this.btnChangeColor.setBackground(color);
        }
    }

    protected void DisableEnableIncomingControls(boolean bl) {
        this.rbIncomingTypeArrival.setEnabled(bl);
        this.rbIncomingTypeDeparture.setEnabled(bl);
        this.lblIncomingBeginTime.setEnabled(bl);
        this.lblIncomingEndTime.setEnabled(bl);
        this.steIncomingBeginTime.setEnabled(bl);
        this.steIncomingEndTime.setEnabled(bl);
    }

    protected void DisableEnableOutgoingControls(boolean bl) {
        this.lblOutgoingBeginTime.setEnabled(bl);
        this.lblOutgoingEndTime.setEnabled(bl);
        this.steOutgoingBeginTime.setEnabled(bl);
        this.steOutgoingEndTime.setEnabled(bl);
    }

    protected void SelectVehicleTypes() {
        TypeSelection<VehicleType> typeSelection = new TypeSelection<VehicleType>(Project.getCurrentlyLoadedProject().getVehicleTypes());
        TypeSelection<VehicleType> typeSelection2 = new TypeSelection<VehicleType>(this.currentHotSpot.getVehicleSelection());
        typeSelection2.addTypesNotInSelection(typeSelection);
        DlgSelectTypes<VehicleType> dlgSelectTypes = new DlgSelectTypes<VehicleType>(typeSelection2);
        dlgSelectTypes.setVisible(true);
        if (dlgSelectTypes.getAnswer() == 0) {
            typeSelection2.removeTypesWithZeroPercentage();
            this.currentHotSpot.setVehicleSelection(typeSelection2);
        }
    }

    private JCheckBox getChkEnabled() {
        if (this.chkEnabled == null) {
            this.chkEnabled = new JCheckBox();
            this.chkEnabled.setText("Enabled");
            this.chkEnabled.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    PnlHotSpotProperties.this.currentHotSpot.setEnabled(PnlHotSpotProperties.this.chkEnabled.isSelected());
                }
            });
        }
        return this.chkEnabled;
    }
}

