/*
 * Decompiled with CFR 0.152.
 */
package ui.controls;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SimTimeEdit
extends JPanel
implements ChangeListener {
    private static final long serialVersionUID = 1L;
    private JSpinner spnRealTime = null;
    private JSpinner spnSimTime = null;
    private int value = 0;
    private JLabel lblRealTime = null;
    private JLabel lblSimTime = null;
    private List<ChangeListener> changeListeners = new ArrayList<ChangeListener>();

    public void addChangeListener(ChangeListener changeListener) {
        if (!this.changeListeners.contains(changeListener)) {
            this.changeListeners.add(changeListener);
        }
    }

    public void removeChangeListener(ChangeListener changeListener) {
        if (this.changeListeners.contains(changeListener)) {
            this.changeListeners.remove(changeListener);
        }
    }

    private void NotifyValueChanged() {
        for (ChangeListener changeListener : this.changeListeners) {
            changeListener.stateChanged(new ChangeEvent(this));
        }
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int n) {
        this.value = n;
        Date date = new Date();
        date.setHours(n / 3600);
        date.setMinutes(n % 3600 / 60);
        date.setSeconds(n % 3600 % 60);
        this.spnRealTime.setValue(date);
        this.spnSimTime.setValue(n);
        this.spnSimTime.addChangeListener(this);
        this.spnRealTime.addChangeListener(this);
    }

    public SimTimeEdit() {
        this.initialize();
        this.setValue(0);
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints.gridy = 1;
        this.lblSimTime = new JLabel();
        this.lblSimTime.setText("Simulation time:");
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.anchor = 18;
        gridBagConstraints2.gridy = 0;
        this.lblRealTime = new JLabel();
        this.lblRealTime.setText("Real time:");
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.weighty = 1.0;
        gridBagConstraints3.insets = new Insets(0, 0, 0, 10);
        gridBagConstraints3.anchor = 18;
        gridBagConstraints3.gridy = 1;
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 1;
        gridBagConstraints4.weighty = 1.0;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.anchor = 18;
        gridBagConstraints4.gridy = 0;
        this.setSize(163, 49);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getSpnRealTime(), gridBagConstraints4);
        this.add((Component)this.getSpnSimTime(), gridBagConstraints3);
        this.add((Component)this.lblRealTime, gridBagConstraints2);
        this.add((Component)this.lblSimTime, gridBagConstraints);
    }

    private JSpinner getSpnRealTime() {
        if (this.spnRealTime == null) {
            this.spnRealTime = new JSpinner();
            this.spnRealTime.setModel(new SpinnerDateModel(new Date(), null, null, 12));
            JSpinner.DateEditor dateEditor = new JSpinner.DateEditor(this.spnRealTime, "HH:mm");
            this.spnRealTime.setEditor(dateEditor);
            this.spnRealTime.setPreferredSize(new Dimension(60, 20));
        }
        return this.spnRealTime;
    }

    private JSpinner getSpnSimTime() {
        if (this.spnSimTime == null) {
            this.spnSimTime = new JSpinner();
            this.spnSimTime.setModel(new SpinnerNumberModel(0, 0, 86400, 60));
            this.spnSimTime.setPreferredSize(new Dimension(60, 20));
        }
        return this.spnSimTime;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.spnSimTime.removeChangeListener(this);
        this.spnRealTime.removeChangeListener(this);
        if (changeEvent.getSource().equals(this.spnRealTime)) {
            Date date = (Date)this.spnRealTime.getValue();
            this.value = date.getHours() * 3600 + date.getMinutes() * 60 + date.getSeconds();
            this.spnSimTime.setValue(this.value);
        } else if (changeEvent.getSource().equals(this.spnSimTime)) {
            this.value = (Integer)this.spnSimTime.getValue();
            Date date = new Date();
            date.setHours(this.value / 3600);
            date.setMinutes(this.value % 3600 / 60);
            date.setSeconds(this.value % 3600 % 60);
            this.spnRealTime.setValue(date);
        }
        this.spnSimTime.addChangeListener(this);
        this.spnRealTime.addChangeListener(this);
        this.NotifyValueChanged();
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.spnRealTime.setEnabled(bl);
        this.spnSimTime.setEnabled(bl);
        this.lblSimTime.setEnabled(bl);
        this.lblRealTime.setEnabled(bl);
    }
}

