/*
 * Decompiled with CFR 0.152.
 */
package ui;

import classes.Layer;
import classes.Project;
import classes.ProjectElement;
import enums.TrafficDefinitionLayerType;
import helpers.Broadcaster;
import interfaces.CurrentLayerChangedListener;
import interfaces.ProjectChangedListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import roadnetwork.RoadNetwork;
import trafficdefinition.TrafficDefinitionLayer;
import ui.controls.JTrafficLayerTree;
import ui.controls.JTrafficLayerTreeModel;
import ui.controls.ProjectTreeCellRenderer;

public class PnlLayers
extends JPanel
implements TreeSelectionListener,
ProjectChangedListener,
TreeWillExpandListener {
    private static final long serialVersionUID = 1L;
    private JButton btnDelete = null;
    private JButton btnDuplicate = null;
    private JButton btnNew = null;
    private List<CurrentLayerChangedListener> currentLayerChangedListeners = new ArrayList<CurrentLayerChangedListener>();
    private Project project = null;
    private JScrollPane scrlLayerList = null;
    private JToolBar tlbLayers = null;
    private JTrafficLayerTree treeLayers = null;

    public PnlLayers() {
        this.initialize();
        Broadcaster.addProjectChangedListener(this);
        this.treeLayers.addTreeWillExpandListener(this);
    }

    public void addCurrentLayerChangedListener(CurrentLayerChangedListener currentLayerChangedListener) {
        this.currentLayerChangedListeners.add(currentLayerChangedListener);
    }

    public void NotifyCurrentLayerChanged(Layer<? extends ProjectElement> layer) {
        for (CurrentLayerChangedListener currentLayerChangedListener : this.currentLayerChangedListeners) {
            currentLayerChangedListener.CurrentLayerChanged(layer);
        }
    }

    @Override
    public void ProjectChanged(Project project) {
        this.project = project;
        if (this.project == null) {
            this.treeLayers.removeTreeSelectionListener(this);
            this.treeLayers.setModel(new DefaultTreeModel(new DefaultMutableTreeNode("No project loaded")));
            this.treeLayers.updateUI();
            this.btnDelete.setEnabled(false);
            this.btnDuplicate.setEnabled(false);
            this.btnNew.setEnabled(false);
        } else {
            Serializable serializable;
            Serializable serializable22;
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Project");
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(this.project.getRoadNetwork());
            DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("Traffic Layers");
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            for (Serializable serializable22 : this.project.getTrafficLayers()) {
                serializable = new DefaultMutableTreeNode(serializable22);
                defaultMutableTreeNode3.add((MutableTreeNode)((Object)serializable));
            }
            defaultMutableTreeNode.add(defaultMutableTreeNode3);
            JTrafficLayerTreeModel jTrafficLayerTreeModel = new JTrafficLayerTreeModel(defaultMutableTreeNode);
            this.treeLayers.setModel(jTrafficLayerTreeModel);
            serializable22 = defaultMutableTreeNode2;
            serializable = new TreePath(((DefaultTreeModel)this.treeLayers.getModel()).getPathToRoot((TreeNode)((Object)serializable22)));
            this.treeLayers.addTreeSelectionListener(this);
            this.treeLayers.setSelectionPath((TreePath)serializable);
        }
    }

    public void removeCurrentLayerChangedListener(CurrentLayerChangedListener currentLayerChangedListener) {
        if (this.currentLayerChangedListeners.contains(currentLayerChangedListener)) {
            this.currentLayerChangedListeners.remove(currentLayerChangedListener);
        }
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
        throw new ExpandVetoException(treeExpansionEvent);
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        Object object = ((DefaultMutableTreeNode)treeSelectionEvent.getNewLeadSelectionPath().getLastPathComponent()).getUserObject();
        if (object instanceof TrafficDefinitionLayer) {
            this.NotifyCurrentLayerChanged((TrafficDefinitionLayer)object);
            this.btnDelete.setEnabled(true);
            this.btnNew.setEnabled(true);
            this.btnDuplicate.setEnabled(true);
        } else if (object instanceof RoadNetwork) {
            this.NotifyCurrentLayerChanged((RoadNetwork)object);
            this.btnDelete.setEnabled(false);
            this.btnNew.setEnabled(false);
            this.btnDuplicate.setEnabled(false);
        } else if (object instanceof String) {
            String string = (String)object;
            if (string.equals("Project")) {
                this.treeLayers.setSelectionPath(treeSelectionEvent.getOldLeadSelectionPath());
                return;
            }
            if (string.equals("Traffic Layers")) {
                TreePath treePath = treeSelectionEvent.getNewLeadSelectionPath();
                DefaultMutableTreeNode defaultMutableTreeNode = ((DefaultMutableTreeNode)treePath.getLastPathComponent()).getFirstLeaf();
                TreePath treePath2 = new TreePath(((DefaultTreeModel)this.treeLayers.getModel()).getPathToRoot(defaultMutableTreeNode));
                this.treeLayers.setSelectionPath(treePath2);
            }
        }
    }

    private JButton getBtnDelete() {
        if (this.btnDelete == null) {
            this.btnDelete = new JButton();
            this.btnDelete.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/deletelayer.png")));
            this.btnDelete.setToolTipText("Delete layer");
            this.btnDelete.setEnabled(false);
            this.btnDelete.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PnlLayers.this.DeleteCurrentTrafficLayer();
                }
            });
        }
        return this.btnDelete;
    }

    private JButton getBtnDuplicate() {
        if (this.btnDuplicate == null) {
            this.btnDuplicate = new JButton();
            this.btnDuplicate.setEnabled(false);
            this.btnDuplicate.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/duplicatelayer.png")));
            this.btnDuplicate.setToolTipText("Duplicate layer");
            this.btnDuplicate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PnlLayers.this.DuplicateCurrentTrafficLayer();
                }
            });
        }
        return this.btnDuplicate;
    }

    private JButton getBtnNew() {
        if (this.btnNew == null) {
            this.btnNew = new JButton();
            this.btnNew.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/addlayer.png")));
            this.btnNew.setToolTipText("Add new layer");
            this.btnNew.setSize(new Dimension(28, 20));
            this.btnNew.setEnabled(false);
            this.btnNew.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PnlLayers.this.CreateNewTrafficLayer(null);
                }
            });
        }
        return this.btnNew;
    }

    private JScrollPane getScrlLayerList() {
        if (this.scrlLayerList == null) {
            this.scrlLayerList = new JScrollPane();
            this.scrlLayerList.setPreferredSize(new Dimension(100, 100));
            this.scrlLayerList.setViewportView(this.getTreeLayers());
        }
        return this.scrlLayerList;
    }

    private JToolBar getTlbLayers() {
        if (this.tlbLayers == null) {
            this.tlbLayers = new JToolBar();
            this.tlbLayers.setSize(new Dimension(211, 30));
            this.tlbLayers.setFloatable(false);
            this.tlbLayers.setPreferredSize(new Dimension(18, 26));
            this.tlbLayers.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            this.tlbLayers.add(this.getBtnNew());
            this.tlbLayers.add(this.getBtnDelete());
            this.tlbLayers.add(this.getBtnDuplicate());
        }
        return this.tlbLayers;
    }

    private JTree getTreeLayers() {
        if (this.treeLayers == null) {
            this.treeLayers = new JTrafficLayerTree();
            this.treeLayers.setShowsRootHandles(false);
            this.treeLayers.setToggleClickCount(-1);
            this.treeLayers.setModel(new DefaultTreeModel(new DefaultMutableTreeNode("No project loaded")));
            this.treeLayers.setEditable(true);
            this.treeLayers.setCellRenderer(new ProjectTreeCellRenderer());
            this.treeLayers.getSelectionModel().setSelectionMode(1);
        }
        return this.treeLayers;
    }

    private void initialize() {
        this.setSize(162, 200);
        this.setLayout(new BorderLayout());
        this.add((Component)this.getScrlLayerList(), "Center");
        this.add((Component)this.getTlbLayers(), "South");
    }

    protected void CreateNewTrafficLayer(TrafficDefinitionLayerType trafficDefinitionLayerType) {
        Object object;
        if (trafficDefinitionLayerType == null) {
            object = (String)JOptionPane.showInputDialog(this, "Select the type of the new layer", "Create new traffic definition layer", 1, new ImageIcon(this.getClass().getResource("/resources/icons/addlayer.png")), new String[]{"User-defined", "Activity-based", "Random"}, "User-Defined");
            if (object != null && ((String)object).length() > 0) {
                if (((String)object).equals("User-defined")) {
                    trafficDefinitionLayerType = TrafficDefinitionLayerType.UserDefined;
                } else if (((String)object).equals("Activity-based")) {
                    trafficDefinitionLayerType = TrafficDefinitionLayerType.ActivityBased;
                } else if (((String)object).equals("Random")) {
                    trafficDefinitionLayerType = TrafficDefinitionLayerType.Random;
                }
            } else {
                return;
            }
        }
        object = this.project.createNewLayer(trafficDefinitionLayerType);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(object);
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)((DefaultMutableTreeNode)this.treeLayers.getModel().getRoot()).getChildAt(1);
        defaultMutableTreeNode2.add(defaultMutableTreeNode);
        this.treeLayers.setSelectionPath(new TreePath(defaultMutableTreeNode.getPath()));
        this.treeLayers.updateUI();
    }

    protected void DeleteCurrentTrafficLayer() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.treeLayers.getSelectionPath().getLastPathComponent();
        TrafficDefinitionLayer trafficDefinitionLayer = (TrafficDefinitionLayer)defaultMutableTreeNode.getUserObject();
        if (JOptionPane.showConfirmDialog(this, "Delete layer " + trafficDefinitionLayer.getName() + " ?") == 0) {
            this.project.DeleteLayer((TrafficDefinitionLayer)defaultMutableTreeNode.getUserObject());
            if (defaultMutableTreeNode.getSiblingCount() == 1) {
                JOptionPane.showMessageDialog(this, "The project must have at least one traffic layer. An empty layer will be inserted to the project.");
                this.CreateNewTrafficLayer(TrafficDefinitionLayerType.UserDefined);
            }
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)((DefaultMutableTreeNode)this.treeLayers.getModel().getRoot()).getChildAt(1);
            defaultMutableTreeNode2.remove(defaultMutableTreeNode);
            this.treeLayers.setSelectionPath(new TreePath(((DefaultMutableTreeNode)defaultMutableTreeNode2.getFirstChild()).getPath()));
            this.treeLayers.updateUI();
        }
    }

    protected void DuplicateCurrentTrafficLayer() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.treeLayers.getSelectionPath().getLastPathComponent();
        TrafficDefinitionLayer trafficDefinitionLayer = this.project.createDuplicateLayer((TrafficDefinitionLayer)defaultMutableTreeNode.getUserObject());
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(trafficDefinitionLayer);
        DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)((DefaultMutableTreeNode)this.treeLayers.getModel().getRoot()).getChildAt(1);
        defaultMutableTreeNode3.add(defaultMutableTreeNode2);
        this.treeLayers.setSelectionPath(new TreePath(defaultMutableTreeNode2.getPath()));
        this.treeLayers.updateUI();
    }
}

