/*
 * Decompiled with CFR 0.152.
 */
package ui;

import classes.Layer;
import classes.Project;
import classes.ProjectElement;
import enums.EditingMode;
import enums.SelectionType;
import enums.ToolType;
import helpers.Broadcaster;
import helpers.CursorProvider;
import interfaces.CurrentLayerChangedListener;
import interfaces.ProjectChangedListener;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import roadnetwork.Edge;
import roadnetwork.RoadNetwork;
import roadnetwork.RoadNetworkElement;
import trafficdefinition.Accident;
import trafficdefinition.AreaFlow;
import trafficdefinition.Flow;
import trafficdefinition.Handle;
import trafficdefinition.HotSpot;
import trafficdefinition.School;
import trafficdefinition.TrafficArea;
import trafficdefinition.TrafficDefinitionElement;
import trafficdefinition.TrafficDefinitionLayer;

public class Display
extends JComponent
implements CurrentLayerChangedListener,
ProjectChangedListener,
MouseListener,
MouseMotionListener,
MouseWheelListener,
AdjustmentListener,
KeyListener {
    private static final long serialVersionUID = 7162061244639610972L;
    private JScrollBar scrlVertical = null;
    private JScrollBar scrlHorizontal = null;
    private TrafficDefinitionLayer currentTrafficLayer;
    private RoadNetwork roadNetwork;
    private boolean projectLoaded = false;
    private double translateX;
    private double translateY;
    private double mintranslateX;
    private double maxtranslateX;
    private double mintranslateY;
    private double maxtranslateY;
    private double scale;
    private Point previousMouseLocation;
    private boolean areaZoom;
    private ToolType tool = ToolType.None;
    private SelectionType selectionType = SelectionType.New;
    private TrafficDefinitionElement newElement;
    private boolean drawAllTrafficLayers = false;
    private GeneralPath areaPath;
    private boolean creatingNewElement = false;
    private Handle currentHandle = null;
    private Rectangle marquee;
    private Point marqueeStart;
    private Point marqueeEnd;
    private AffineTransform tx = new AffineTransform();
    private EditingMode editingMode;
    private boolean manipulatingHandle = false;

    public Display(JScrollBar jScrollBar, JScrollBar jScrollBar2) {
        this.scrlVertical = jScrollBar;
        this.scrlHorizontal = jScrollBar2;
        this.translateX = 0.0;
        this.translateY = 0.0;
        this.scale = 1.0;
        this.setOpaque(true);
        this.setDoubleBuffered(true);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.addKeyListener(this);
        this.scrlVertical.addAdjustmentListener(this);
        this.scrlHorizontal.addAdjustmentListener(this);
        Broadcaster.addProjectChangedListener(this);
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (adjustmentEvent.getSource() == this.scrlHorizontal) {
            this.translateX = Math.max(this.maxtranslateX, this.mintranslateX) - (double)adjustmentEvent.getValue() + Math.min(this.maxtranslateX, this.mintranslateX);
            this.repaint();
        } else if (adjustmentEvent.getSource() == this.scrlVertical) {
            this.translateY = Math.max(this.maxtranslateY, this.mintranslateY) - (double)adjustmentEvent.getValue() + Math.min(this.maxtranslateY, this.mintranslateY);
            this.repaint();
        }
    }

    @Override
    public void CurrentLayerChanged(Layer<? extends ProjectElement> layer) {
        if (this.currentTrafficLayer != null) {
            this.currentTrafficLayer.SelectNoneElements();
        }
        if (this.roadNetwork != null) {
            this.roadNetwork.SelectNoneElements();
        }
        if (layer instanceof RoadNetwork) {
            this.setEditingMode(EditingMode.Map);
            this.currentTrafficLayer = null;
        } else if (layer instanceof TrafficDefinitionLayer) {
            this.currentTrafficLayer = (TrafficDefinitionLayer)layer;
            this.setEditingMode(EditingMode.GenericTraffic);
        }
        this.repaint();
    }

    public void DeleteSelectedObjects() {
        switch (this.editingMode) {
            case Map: {
                this.roadNetwork.DeleteSelectedElements();
                break;
            }
            case GenericTraffic: {
                this.currentTrafficLayer.DeleteSelectedElements();
            }
        }
        this.repaint();
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (!this.projectLoaded) {
            return;
        }
        if (keyEvent.getKeyCode() == 127) {
            this.DeleteSelectedObjects();
            return;
        }
        if (keyEvent.getKeyCode() == 27 && this.creatingNewElement) {
            this.creatingNewElement = false;
            this.newElement = null;
            this.repaint();
            return;
        }
        if (this.tool == ToolType.Select && keyEvent.getKeyCode() == 17) {
            this.setCursor(CursorProvider.getCursor(CursorProvider.Cursors.SelectAdd));
            return;
        }
        if (this.tool == ToolType.Select && keyEvent.getKeyCode() == 16) {
            this.setCursor(CursorProvider.getCursor(CursorProvider.Cursors.SelectRemove));
            return;
        }
        if (this.tool == ToolType.Zoom && keyEvent.getKeyCode() == 17) {
            this.setCursor(CursorProvider.getCursor(CursorProvider.Cursors.ZoomOut));
            return;
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (!this.projectLoaded) {
            return;
        }
        if (this.tool == ToolType.Select && (keyEvent.getKeyCode() == 17 || keyEvent.getKeyCode() == 16)) {
            this.setCursor(CursorProvider.getCursor(CursorProvider.Cursors.Select));
            return;
        }
        if (this.tool == ToolType.Zoom && keyEvent.getKeyCode() == 17) {
            this.setCursor(CursorProvider.getCursor(CursorProvider.Cursors.ZoomIn));
            return;
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (!this.projectLoaded) {
            return;
        }
        Point2D.Double double_ = this.TransformPoint(mouseEvent.getPoint());
        if (double_ == null) {
            return;
        }
        switch (this.tool) {
            case School: {
                if (mouseEvent.getButton() == 1) {
                    this.currentTrafficLayer.AddTrafficElement(new School(double_));
                }
                this.repaint();
                break;
            }
            case Hotspot: {
                if (this.creatingNewElement && mouseEvent.getButton() == 3) {
                    this.creatingNewElement = false;
                    this.newElement = null;
                    this.repaint();
                    return;
                }
                if (this.creatingNewElement) {
                    ((HotSpot)this.newElement).createHandles();
                    this.currentTrafficLayer.AddTrafficElement(this.newElement);
                    this.newElement = null;
                    this.creatingNewElement = false;
                    this.repaint();
                } else {
                    this.newElement = new HotSpot(double_);
                    this.creatingNewElement = true;
                }
                return;
            }
            case AreaFlow: {
                if (this.creatingNewElement && mouseEvent.getButton() == 3) {
                    this.creatingNewElement = false;
                    this.newElement = null;
                    this.repaint();
                    return;
                }
                if (this.creatingNewElement) {
                    AreaFlow areaFlow = (AreaFlow)this.newElement;
                    ++areaFlow.constructionPhase;
                    if (areaFlow.constructionPhase == 3) {
                        areaFlow.createHandles();
                        this.currentTrafficLayer.AddTrafficElement(this.newElement);
                        this.creatingNewElement = false;
                        this.newElement = null;
                        this.repaint();
                    }
                } else {
                    this.newElement = new AreaFlow();
                    ((AreaFlow)this.newElement).setStartAreaCenter(double_);
                    ((AreaFlow)this.newElement).constructionPhase = 0;
                    this.creatingNewElement = true;
                }
                return;
            }
            case Flow: {
                RoadNetworkElement roadNetworkElement = (RoadNetworkElement)this.roadNetwork.PointHitTest(double_);
                if (this.creatingNewElement && (mouseEvent.getButton() == 3 || roadNetworkElement == null || !(roadNetworkElement instanceof Edge))) {
                    this.creatingNewElement = false;
                    this.newElement = null;
                    this.repaint();
                    return;
                }
                if (roadNetworkElement != null && roadNetworkElement instanceof Edge) {
                    if (this.creatingNewElement) {
                        ((Flow)this.newElement).setTo(new Point2D.Double(roadNetworkElement.getBounds().getCenterX(), roadNetworkElement.getBounds().getCenterY()));
                        ((Flow)this.newElement).setEnd((Edge)roadNetworkElement);
                        ((Flow)this.newElement).SetDependencies();
                        this.currentTrafficLayer.AddTrafficElement(this.newElement);
                        this.creatingNewElement = false;
                        this.newElement = null;
                        this.repaint();
                    } else {
                        this.newElement = new Flow();
                        ((Flow)this.newElement).setStart((Edge)roadNetworkElement);
                        ((Flow)this.newElement).setFrom(new Point2D.Float((float)roadNetworkElement.getBounds().getCenterX(), (float)roadNetworkElement.getBounds().getCenterY()));
                        this.creatingNewElement = true;
                    }
                }
                return;
            }
            case Accident: {
                RoadNetworkElement roadNetworkElement = (RoadNetworkElement)this.roadNetwork.PointHitTest(double_);
                if (roadNetworkElement != null && roadNetworkElement instanceof Edge && mouseEvent.getButton() == 1) {
                    this.currentTrafficLayer.AddTrafficElement(new Accident((Edge)roadNetworkElement, double_));
                }
                this.repaint();
                break;
            }
            case Select: {
                switch (this.editingMode) {
                    case Map: {
                        if (mouseEvent.isControlDown()) {
                            this.roadNetwork.AlterSelection(new Rectangle((int)Math.round(double_.x), (int)Math.round(double_.y), 1, 1), SelectionType.Add);
                        } else if (mouseEvent.isShiftDown()) {
                            this.roadNetwork.AlterSelection(new Rectangle((int)Math.round(double_.x), (int)Math.round(double_.y), 1, 1), SelectionType.Remove);
                        } else {
                            this.roadNetwork.AlterSelection(new Rectangle((int)Math.round(double_.x), (int)Math.round(double_.y), 1, 1), this.selectionType);
                        }
                        this.repaint();
                        break;
                    }
                    case GenericTraffic: {
                        if (mouseEvent.isControlDown()) {
                            this.currentTrafficLayer.AlterSelection(new Rectangle((int)Math.round(double_.x), (int)Math.round(double_.y), 1, 1), SelectionType.Add);
                        } else if (mouseEvent.isShiftDown()) {
                            this.currentTrafficLayer.AlterSelection(new Rectangle((int)Math.round(double_.x), (int)Math.round(double_.y), 1, 1), SelectionType.Remove);
                        } else {
                            this.currentTrafficLayer.AlterSelection(new Rectangle((int)Math.round(double_.x), (int)Math.round(double_.y), 1, 1), this.selectionType);
                        }
                        this.repaint();
                    }
                }
                break;
            }
            case Zoom: {
                if (mouseEvent.isControlDown()) {
                    if ((double)this.getWidth() > this.roadNetwork.getBounds().width * this.scale && (double)this.getHeight() > this.roadNetwork.getBounds().height * this.scale) {
                        return;
                    }
                    this.scale -= 0.5;
                } else {
                    this.scale += 0.5;
                }
                this.MoveMapPointToDisplayCenter(double_);
                this.UpdateScrollBars();
                this.repaint();
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.projectLoaded) {
            return;
        }
        Point2D.Double double_ = this.TransformPoint(mouseEvent.getPoint());
        if (double_ == null) {
            return;
        }
        switch (this.tool) {
            case Pan: {
                this.translateX += (double)mouseEvent.getX() - this.previousMouseLocation.getX();
                this.translateY += (double)mouseEvent.getY() - this.previousMouseLocation.getY();
                this.previousMouseLocation = mouseEvent.getPoint();
                this.UpdateScrollBars();
                this.repaint();
                break;
            }
            case Zoom: {
                this.areaZoom = true;
                this.marqueeEnd = mouseEvent.getPoint();
                this.marquee.setFrameFromDiagonal(this.marqueeStart, this.marqueeEnd);
                this.repaint();
                break;
            }
            case Select: {
                if (this.manipulatingHandle) {
                    this.currentHandle.setLocationAndNotify(double_);
                } else {
                    this.areaZoom = true;
                    this.marqueeEnd = mouseEvent.getPoint();
                    this.marquee.setFrameFromDiagonal(this.marqueeStart, this.marqueeEnd);
                }
                this.repaint();
                break;
            }
            case Area: {
                this.areaPath.lineTo((float)double_.x, (float)double_.y);
                this.repaint();
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.setFocusable(true);
        this.requestFocus(true);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.manipulatingHandle = false;
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (!this.projectLoaded) {
            return;
        }
        Point2D.Double double_ = this.TransformPoint(mouseEvent.getPoint());
        if (double_ == null) {
            return;
        }
        ProjectElement projectElement = null;
        RoadNetworkElement roadNetworkElement = (RoadNetworkElement)this.roadNetwork.PointHitTest(double_);
        if (this.currentTrafficLayer != null) {
            projectElement = (TrafficDefinitionElement)this.currentTrafficLayer.PointHitTest(double_);
        }
        if (projectElement != null) {
            this.setToolTipText(projectElement.getToolTip());
        } else if (roadNetworkElement != null) {
            this.setToolTipText(roadNetworkElement.getToolTip());
        } else {
            this.setToolTipText(null);
        }
        switch (this.tool) {
            case Select: {
                this.currentHandle = null;
                boolean bl = false;
                if (this.currentTrafficLayer != null) {
                    List<TrafficDefinitionElement> list = this.currentTrafficLayer.getSelectedElements();
                    for (TrafficDefinitionElement trafficDefinitionElement : list) {
                        this.currentHandle = trafficDefinitionElement.handleHit(mouseEvent.getPoint(), this.tx);
                        if (this.currentHandle == null) continue;
                        bl = true;
                        break;
                    }
                }
                if (bl) {
                    this.setCursor(CursorProvider.getCursor(CursorProvider.Cursors.Hand));
                    break;
                }
                this.setCursor(CursorProvider.getCursor(CursorProvider.Cursors.Select));
                break;
            }
            case Hotspot: {
                if (!this.creatingNewElement) break;
                HotSpot hotSpot = (HotSpot)this.newElement;
                hotSpot.setRadius(double_);
                this.repaint();
                break;
            }
            case AreaFlow: {
                if (!this.creatingNewElement) break;
                AreaFlow areaFlow = (AreaFlow)this.newElement;
                switch (areaFlow.constructionPhase) {
                    case 0: {
                        areaFlow.setStartAreaRadius(double_);
                        break;
                    }
                    case 1: {
                        areaFlow.setEndAreaCenter(double_);
                        break;
                    }
                    case 2: {
                        areaFlow.setEndAreaRadius(double_);
                    }
                }
                this.repaint();
                break;
            }
            case Flow: {
                if (roadNetworkElement != null && roadNetworkElement instanceof Edge) {
                    this.setCursor(Cursor.getPredefinedCursor(1));
                } else {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                }
                if (!this.creatingNewElement) {
                    return;
                }
                ((Flow)this.newElement).setTo(double_);
                this.repaint();
                break;
            }
            case Accident: {
                if (roadNetworkElement != null && roadNetworkElement instanceof Edge) {
                    this.setCursor(Cursor.getPredefinedCursor(1));
                    break;
                }
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.projectLoaded) {
            return;
        }
        this.previousMouseLocation = mouseEvent.getPoint();
        Point2D.Double double_ = this.TransformPoint(mouseEvent.getPoint());
        if (double_ == null) {
            return;
        }
        switch (this.tool) {
            case Select: {
                if (this.currentHandle != null) {
                    this.setCursor(CursorProvider.getCursor(CursorProvider.Cursors.HandClosed));
                    this.manipulatingHandle = true;
                    break;
                }
                if (this.selectionType == SelectionType.New && !mouseEvent.isShiftDown() && !mouseEvent.isControlDown()) {
                    switch (this.editingMode) {
                        case Map: {
                            this.roadNetwork.SelectNoneElements();
                            break;
                        }
                        case GenericTraffic: {
                            this.currentTrafficLayer.SelectNoneElements();
                        }
                    }
                }
                this.areaZoom = false;
                this.marquee = new Rectangle();
                this.marqueeStart = mouseEvent.getPoint();
                this.manipulatingHandle = false;
                break;
            }
            case Zoom: {
                this.areaZoom = false;
                this.marquee = new Rectangle();
                this.marqueeStart = mouseEvent.getPoint();
                break;
            }
            case Pan: {
                this.setCursor(CursorProvider.getCursor(CursorProvider.Cursors.HandClosed));
                break;
            }
            case Area: {
                this.areaPath = new GeneralPath();
                this.areaPath.moveTo((float)double_.x, (float)double_.y);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.projectLoaded) {
            return;
        }
        switch (this.tool) {
            case Pan: {
                this.setCursor(CursorProvider.getCursor(CursorProvider.Cursors.Hand));
                break;
            }
            case Zoom: {
                if (!this.areaZoom || this.marquee.height * this.marquee.width < 10) {
                    return;
                }
                Point2D.Double double_ = this.TransformPoint(this.marqueeStart);
                Point2D.Double double_2 = this.TransformPoint(this.marqueeEnd);
                if (double_ == null || double_2 == null) {
                    return;
                }
                Rectangle rectangle = new Rectangle();
                rectangle.setFrameFromDiagonal(double_, double_2);
                this.ZoomToRectangleAndCenter(rectangle);
                this.UpdateScrollBars();
                this.marquee = null;
                this.repaint();
                break;
            }
            case Select: {
                if (this.manipulatingHandle) {
                    this.manipulatingHandle = false;
                    break;
                }
                if (!this.areaZoom || this.marquee.height * this.marquee.width < 10) {
                    return;
                }
                Point2D.Double double_ = this.TransformPoint(this.marqueeStart);
                Point2D.Double double_3 = this.TransformPoint(this.marqueeEnd);
                if (double_ == null || double_3 == null) {
                    return;
                }
                Rectangle rectangle = new Rectangle();
                rectangle.setFrameFromDiagonal(double_, double_3);
                switch (this.editingMode) {
                    case Map: {
                        if (mouseEvent.isControlDown()) {
                            this.roadNetwork.AlterSelection(rectangle, SelectionType.Add);
                        } else if (mouseEvent.isShiftDown()) {
                            this.roadNetwork.AlterSelection(rectangle, SelectionType.Remove);
                        } else {
                            this.roadNetwork.AlterSelection(rectangle, this.selectionType);
                        }
                        this.repaint();
                        break;
                    }
                    case GenericTraffic: {
                        if (mouseEvent.isControlDown()) {
                            this.currentTrafficLayer.AlterSelection(rectangle, SelectionType.Add);
                        } else if (mouseEvent.isShiftDown()) {
                            this.currentTrafficLayer.AlterSelection(rectangle, SelectionType.Remove);
                        } else {
                            this.currentTrafficLayer.AlterSelection(rectangle, this.selectionType);
                        }
                        this.repaint();
                    }
                }
                this.marquee = null;
                this.repaint();
                break;
            }
            case Area: {
                this.areaPath.closePath();
                this.currentTrafficLayer.AddTrafficElement(new TrafficArea(this.areaPath));
                this.areaPath = null;
                this.repaint();
            }
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (mouseWheelEvent.getScrollType() == 0) {
            if (mouseWheelEvent.getWheelRotation() < 0 && (double)this.getWidth() > this.roadNetwork.getBounds().width * this.scale && (double)this.getHeight() > this.roadNetwork.getBounds().height * this.scale) {
                return;
            }
            Point2D.Double double_ = this.TransformPoint(mouseWheelEvent.getPoint());
            if (double_ == null) {
                return;
            }
            this.scale += 0.01 * (double)mouseWheelEvent.getWheelRotation();
            this.MoveMapPointToDisplayPoint(double_, mouseWheelEvent.getPoint());
            this.UpdateScrollBars();
            this.repaint();
        }
    }

    private void MoveMapPointToDisplayPoint(Point2D.Double double_, Point point) {
        this.translateX = (double)point.x - double_.x * this.scale;
        this.translateY = (double)point.y + double_.y * this.scale;
    }

    public void MoveMapPointToDisplayCenter(Point2D.Double double_) {
        this.MoveMapPointToDisplayPoint(double_, new Point(this.getWidth() / 2, this.getHeight() / 2));
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Rectangle rectangle = graphics2D.getClipBounds();
        if (rectangle.x != 0 || rectangle.y != 0) {
            this.repaint();
            return;
        }
        graphics2D.setColor(Color.GRAY);
        graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (!this.projectLoaded) {
            return;
        }
        this.tx.setToIdentity();
        this.tx.translate(this.translateX, this.translateY);
        this.tx.scale(this.scale, -this.scale);
        graphics2D.setTransform(this.tx);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(Color.WHITE);
        graphics2D.fill(this.roadNetwork.getBounds());
        graphics2D.setColor(Color.BLACK);
        graphics2D.draw(this.roadNetwork.getBounds());
        this.roadNetwork.Draw(graphics2D, this.scale);
        if (this.drawAllTrafficLayers) {
            for (TrafficDefinitionLayer trafficDefinitionLayer : Project.getCurrentlyLoadedProject().getTrafficLayers()) {
                trafficDefinitionLayer.Draw(graphics2D, this.scale);
            }
        } else if (this.currentTrafficLayer != null) {
            this.currentTrafficLayer.Draw(graphics2D, this.scale);
        }
        if (this.newElement != null) {
            graphics2D.setColor(Color.RED);
            this.newElement.Draw(graphics2D, this.scale, false, false);
        }
        if (this.areaPath != null) {
            graphics2D.setColor(new Color(120, 65, 87, 125));
            graphics2D.fill(this.areaPath);
        }
        if (this.marquee != null) {
            graphics2D.setTransform(new AffineTransform());
            graphics2D.setColor(Color.RED);
            graphics2D.draw(this.marquee);
        }
    }

    @Override
    public void ProjectChanged(Project project) {
        if (project == null) {
            this.projectLoaded = false;
            this.roadNetwork = null;
            this.currentTrafficLayer = null;
            this.repaint();
        } else {
            this.projectLoaded = true;
            this.roadNetwork = project.getRoadNetwork();
            this.ZoomToFitAndCenter();
            this.UpdateScrollBars();
            this.setEditingMode(EditingMode.Map);
        }
    }

    public void Refresh() {
        this.repaint();
    }

    public void SelectAll() {
        switch (this.editingMode) {
            case Map: {
                this.roadNetwork.SelectAllElements();
                break;
            }
            case GenericTraffic: {
                this.currentTrafficLayer.SelectAllElements();
            }
        }
        this.repaint();
    }

    public void SelectInverse() {
        switch (this.editingMode) {
            case Map: {
                this.roadNetwork.SelectInverseElements();
                break;
            }
            case GenericTraffic: {
                this.currentTrafficLayer.SelectInverseElements();
            }
        }
        this.repaint();
    }

    public void SelectNone() {
        switch (this.editingMode) {
            case Map: {
                this.roadNetwork.SelectNoneElements();
                break;
            }
            case GenericTraffic: {
                this.currentTrafficLayer.SelectNoneElements();
            }
        }
        this.repaint();
    }

    public void setEditingMode(EditingMode editingMode) {
        this.editingMode = editingMode;
    }

    public void setSelectionType(SelectionType selectionType) {
        this.selectionType = selectionType;
    }

    public void setShowDeleted(boolean bl) {
        if (!this.projectLoaded) {
            return;
        }
        this.roadNetwork.setShowDeleted(bl);
        this.repaint();
    }

    public void setDrawAllTrafficLayers(boolean bl) {
        this.drawAllTrafficLayers = bl;
    }

    public void setTool(ToolType toolType) {
        this.tool = toolType;
        switch (toolType) {
            case Pan: {
                this.setCursor(CursorProvider.getCursor(CursorProvider.Cursors.Hand));
                break;
            }
            case Zoom: {
                this.setCursor(CursorProvider.getCursor(CursorProvider.Cursors.ZoomIn));
                break;
            }
            case Select: {
                this.setCursor(CursorProvider.getCursor(CursorProvider.Cursors.Select));
                break;
            }
            default: {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    public void UndeleteSelectedObjects() {
        this.roadNetwork.UndeleteSelectedMapElements();
        this.repaint();
    }

    public void ZoomToFitAndCenter() {
        if (!this.projectLoaded) {
            return;
        }
        this.ZoomToRectangleAndCenter(this.roadNetwork.getBounds());
        this.UpdateScrollBars();
        this.repaint();
    }

    private Point2D.Double TransformPoint(Point point) {
        try {
            return (Point2D.Double)this.tx.inverseTransform(new Point2D.Double(point.getX(), point.getY()), null);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            return null;
        }
    }

    private void UpdateScrollBars() {
        this.mintranslateX = (double)(this.getWidth() / 2) - this.roadNetwork.getBounds().getMinX() * this.scale;
        this.maxtranslateX = (double)(this.getWidth() / 2) - this.roadNetwork.getBounds().getMaxX() * this.scale;
        this.mintranslateY = (double)(this.getHeight() / 2) + this.roadNetwork.getBounds().getMinY() * this.scale;
        this.maxtranslateY = (double)(this.getHeight() / 2) + this.roadNetwork.getBounds().getMaxY() * this.scale;
        this.scrlVertical.removeAdjustmentListener(this);
        this.scrlVertical.setMinimum((int)Math.min(this.mintranslateY, this.maxtranslateY));
        this.scrlVertical.setMaximum((int)Math.max(this.mintranslateY, this.maxtranslateY));
        this.scrlVertical.setValue((int)(-this.translateY) + (int)Math.max(this.maxtranslateY, this.mintranslateY) + (int)Math.min(this.maxtranslateY, this.mintranslateY));
        this.scrlVertical.addAdjustmentListener(this);
        this.scrlHorizontal.removeAdjustmentListener(this);
        this.scrlHorizontal.setMinimum((int)Math.min(this.mintranslateX, this.maxtranslateX));
        this.scrlHorizontal.setMaximum((int)Math.max(this.mintranslateX, this.maxtranslateX));
        this.scrlHorizontal.setValue((int)(-this.translateX) + (int)Math.max(this.maxtranslateX, this.mintranslateX) + (int)Math.min(this.maxtranslateX, this.mintranslateX));
        this.scrlHorizontal.addAdjustmentListener(this);
    }

    private void ZoomToRectangleAndCenter(RectangularShape rectangularShape) {
        if (rectangularShape.getHeight() > rectangularShape.getWidth()) {
            this.scale = (double)this.getHeight() / rectangularShape.getHeight();
        } else if (rectangularShape.getHeight() < rectangularShape.getWidth()) {
            this.scale = (double)this.getWidth() / rectangularShape.getWidth();
        } else {
            int n = Math.min(this.getWidth(), this.getHeight());
            this.scale = (double)n / rectangularShape.getWidth();
        }
        this.MoveMapPointToDisplayCenter(new Point2D.Double(rectangularShape.getCenterX(), rectangularShape.getCenterY()));
    }

    public void CenterAndZoomOnElement(ProjectElement projectElement) {
        this.MoveMapPointToDisplayCenter(new Point2D.Double(projectElement.getBounds().getCenterX(), projectElement.getBounds().getCenterY()));
        this.UpdateScrollBars();
        this.repaint();
    }
}

