/*
 * Decompiled with CFR 0.152.
 */
package trafficdefinition;

import classes.Layer;
import enums.SelectionType;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.List;
import trafficdefinition.Flow;
import trafficdefinition.TrafficDefinitionElement;

public abstract class TrafficDefinitionLayer
extends Layer<TrafficDefinitionElement>
implements Serializable {
    private static int increment = 1;
    private static final long serialVersionUID = 1L;
    protected String name = null;

    public TrafficDefinitionLayer() {
        this.name = "New Layer " + String.valueOf(increment);
        ++increment;
    }

    public TrafficDefinitionLayer(TrafficDefinitionLayer trafficDefinitionLayer) {
        TrafficDefinitionElement trafficDefinitionElement;
        for (TrafficDefinitionElement trafficDefinitionElement2 : trafficDefinitionLayer.elements) {
            trafficDefinitionElement = trafficDefinitionElement2.elementClone();
            trafficDefinitionElement.setLayer(this);
            this.elements.add(trafficDefinitionElement);
        }
        for (TrafficDefinitionElement trafficDefinitionElement2 : trafficDefinitionLayer.selectedElements) {
            trafficDefinitionElement = trafficDefinitionElement2.elementClone();
            trafficDefinitionElement.setLayer(this);
            this.selectedElements.add(trafficDefinitionElement2.elementClone());
        }
        this.name = "Copy of " + trafficDefinitionLayer.getName();
    }

    public abstract TrafficDefinitionLayer duplicate();

    public void DeleteTrafficElement(TrafficDefinitionElement trafficDefinitionElement) {
        this.elements.remove(trafficDefinitionElement);
    }

    public void AddTrafficElement(TrafficDefinitionElement trafficDefinitionElement) {
        this.elements.add(trafficDefinitionElement);
        trafficDefinitionElement.setLayer(this);
        this.SelectElement(trafficDefinitionElement);
        this.NotifyCollectionModified();
        this.NotifySelectionChanged();
    }

    @Override
    public void AlterSelection(Rectangle rectangle, SelectionType selectionType) {
        switch (selectionType) {
            case New: {
                this.SelectNoneElements();
            }
            case Add: {
                super.AddToSelection(rectangle);
                break;
            }
            case Remove: {
                super.RemoveFromSelection(rectangle);
            }
        }
        this.NotifySelectionChanged();
    }

    @Override
    public void DeleteSelectedElements() {
        for (TrafficDefinitionElement trafficDefinitionElement : this.selectedElements) {
            if (!(trafficDefinitionElement instanceof Flow)) continue;
            ((Flow)trafficDefinitionElement).ReleaseDependencies();
        }
        this.selectedElements.clear();
        this.NotifyCollectionModified();
        this.NotifySelectionChanged();
    }

    @Override
    public void Draw(Graphics2D graphics2D, double d) {
        for (TrafficDefinitionElement trafficDefinitionElement : this.elements) {
            trafficDefinitionElement.Draw(graphics2D, d, false, false);
        }
        for (TrafficDefinitionElement trafficDefinitionElement : this.selectedElements) {
            trafficDefinitionElement.Draw(graphics2D, d, false, true);
        }
    }

    public String getName() {
        return this.name;
    }

    public List<TrafficDefinitionElement> getSelectedElements() {
        return this.selectedElements;
    }

    public boolean isElementSelected(TrafficDefinitionElement trafficDefinitionElement) {
        return this.selectedElements.contains(trafficDefinitionElement);
    }

    @Override
    public void SelectAllElements() {
        super.SelectAllElements();
        this.NotifySelectionChanged();
    }

    @Override
    public void SelectInverseElements() {
        super.SelectInverseElements();
        this.NotifySelectionChanged();
    }

    @Override
    public void SelectNoneElements() {
        super.SelectNoneElements();
        this.NotifySelectionChanged();
    }

    public void setName(String string) {
        this.name = string;
    }

    public String toString() {
        return this.name;
    }

    public abstract String toXML();
}

