/*
 * Decompiled with CFR 0.152.
 */
package trafficdefinition;

import classes.ProjectElement;
import interfaces.DrawableElement;
import interfaces.HandleListener;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import trafficdefinition.Handle;
import trafficdefinition.TrafficDefinitionLayer;

public abstract class TrafficDefinitionElement
extends ProjectElement
implements Serializable,
HandleListener,
DrawableElement {
    private static final long serialVersionUID = -8283034182313177579L;
    protected static int increment = 1;
    protected Hashtable<String, Handle> handles;
    protected String name = null;
    protected boolean exportPolygon = false;
    protected boolean enabled = true;
    protected TrafficDefinitionLayer layer = null;

    public TrafficDefinitionElement() {
        this.handles = new Hashtable();
    }

    protected TrafficDefinitionElement(TrafficDefinitionElement trafficDefinitionElement) {
        this.name = trafficDefinitionElement.name;
        this.handles = new Hashtable();
        for (Map.Entry<String, Handle> entry : trafficDefinitionElement.handles.entrySet()) {
            Handle handle = new Handle(entry.getValue());
            handle.setHandleListener(this);
            this.handles.put(entry.getKey(), handle);
        }
        this.exportPolygon = trafficDefinitionElement.exportPolygon;
    }

    public abstract TrafficDefinitionElement elementClone();

    @Override
    public void Draw(Graphics2D graphics2D, double d, boolean bl, boolean bl2) {
        if (bl2) {
            for (Handle handle : this.handles.values()) {
                handle.Draw(graphics2D);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public Handle handleHit(Point point, AffineTransform affineTransform) {
        for (Handle handle : this.handles.values()) {
            if (!handle.hit(point, affineTransform)) continue;
            return handle;
        }
        return null;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String toString() {
        return this.name;
    }

    protected void addHandles(List<Handle> list) {
        for (Handle handle : list) {
            this.handles.put(handle.getName(), handle);
            handle.setHandleListener(this);
        }
    }

    public boolean getExportPolygon() {
        return this.exportPolygon;
    }

    public void setExportPolygon(boolean bl) {
        this.exportPolygon = bl;
    }

    public String getGeometryXML() {
        return "";
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public abstract String toXML();

    public TrafficDefinitionLayer getLayer() {
        return this.layer;
    }

    public void setLayer(TrafficDefinitionLayer trafficDefinitionLayer) {
        this.layer = trafficDefinitionLayer;
    }
}

