/*
 * Decompiled with CFR 0.152.
 */
package trafficdefinition;

import classes.Pair;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import roadnetwork.Edge;
import roadnetwork.Lane;
import shapes.Line2DExt;
import shapes.Point2DExt;
import shapes.Rectangle2DExt;
import trafficdefinition.Handle;
import trafficdefinition.TrafficDefinitionElement;

public class Accident
extends TrafficDefinitionElement
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Edge edge = null;
    private Point2DExt location = null;
    private float edgeRelativeLocation = 0.0f;
    private int endingTime;
    private Shape shape = null;
    private int startingTime;
    private List<Pair<Lane, Boolean>> affectedLanes = new ArrayList<Pair<Lane, Boolean>>();

    public Accident(Accident accident) {
        super(accident);
        this.startingTime = accident.startingTime;
        this.endingTime = accident.endingTime;
        this.edge = accident.edge;
        this.shape = accident.shape;
        this.location = accident.location;
        this.edgeRelativeLocation = accident.edgeRelativeLocation;
        for (Pair<Lane, Boolean> pair : accident.affectedLanes) {
            this.affectedLanes.add(new Pair<Lane, Boolean>(pair.getFirst(), pair.getSecond()));
        }
        this.edge.AddDependentTrafficElement(this);
    }

    public Accident(Edge edge, Point2D.Double double_) {
        this.name = "Accident " + String.valueOf(increment++);
        this.edge = edge;
        this.location = new Point2DExt(double_);
        this.shape = new Rectangle2DExt(double_.x - 10.0, double_.y - 10.0, 20.0, 20.0);
        Point2D.Double double_2 = edge.getLanes().get(0).GetPoint(0);
        double d = Math.min(double_2.distance(this.location), (double)edge.getLength());
        this.edgeRelativeLocation = d > (double)edge.getLength() ? edge.getLength() / 2.0f : (float)d;
        for (Lane lane : edge.getLanes()) {
            this.affectedLanes.add(new Pair<Lane, Boolean>(lane, true));
        }
        edge.AddDependentTrafficElement(this);
    }

    @Override
    public void Draw(Graphics2D graphics2D, double d, boolean bl, boolean bl2) {
        Color color = graphics2D.getColor();
        if (!bl2) {
            graphics2D.setColor(Color.RED);
        }
        if (bl2) {
            graphics2D.setColor(Color.GREEN);
        }
        Line2DExt line2DExt = new Line2DExt(new Point2DExt(this.location.x - 10.0, this.location.y - 10.0), new Point2DExt(this.location.x + 10.0, this.location.y + 10.0));
        Line2DExt line2DExt2 = new Line2DExt(new Point2DExt(this.location.x - 10.0, this.location.y + 10.0), new Point2DExt(this.location.x + 10.0, this.location.y - 10.0));
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(new BasicStroke(6.0f, 1, 0));
        graphics2D.draw(line2DExt);
        graphics2D.draw(line2DExt2);
        graphics2D.setColor(color);
        graphics2D.setStroke(stroke);
    }

    @Override
    public TrafficDefinitionElement elementClone() {
        return new Accident(this);
    }

    public int getEndingTime() {
        return this.endingTime;
    }

    public int getStartingTime() {
        return this.startingTime;
    }

    @Override
    public String getToolTip() {
        String string = "<html><b>Accident</b> " + this.name + "<br>" + "<b>Starting time: </b> " + String.valueOf(this.startingTime) + "<br>" + "<b>Ending time: </b>" + String.valueOf(this.endingTime);
        return string;
    }

    @Override
    public Rectangle2DExt getBounds() {
        return new Rectangle2DExt((Rectangle2D.Double)this.shape.getBounds2D());
    }

    @Override
    public void handleLocationChanged(Handle handle) {
    }

    @Override
    public boolean Hit(Point point) {
        return this.shape.getBounds2D().contains(point.x, point.y) && this.shape.contains(point.x, point.y);
    }

    @Override
    public boolean Hit(Rectangle rectangle) {
        return this.shape.intersects(rectangle);
    }

    public void setEndingTime(int n) {
        this.endingTime = n;
    }

    public void setStartingTime(int n) {
        this.startingTime = n;
    }

    public Edge getEdge() {
        return this.edge;
    }

    public List<Pair<Lane, Boolean>> getAffectedLanes() {
        return this.affectedLanes;
    }

    public float getEdgeRelativeLocation() {
        return this.edgeRelativeLocation;
    }

    @Override
    public String toXML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<accident name=\"" + this.name + "\" streetName=\"" + this.edge.getId() + "\" startingTime=\"" + String.valueOf(this.startingTime) + "\" endingTime=\"" + String.valueOf(this.endingTime) + "\" location=\"" + String.valueOf(this.edgeRelativeLocation) + "\" >\n");
        stringBuilder.append("<affectedLanes>\n");
        for (Pair<Lane, Boolean> pair : this.affectedLanes) {
            if (!pair.getSecond().booleanValue()) continue;
            stringBuilder.append("<lane name=\"" + pair.getFirst().getId() + "\" />\n");
        }
        stringBuilder.append("</affectedLanes>\n");
        stringBuilder.append("</accident>\n");
        return stringBuilder.toString();
    }
}

