/*
 * Decompiled with CFR 0.152.
 */
package simulation;

import cern.jet.random.Poisson;
import classes.Constants;
import classes.Pair;
import classes.TypeSelection;
import enums.SchoolType;
import helpers.RandomNumberProvider;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import roadnetwork.Edge;
import roadnetwork.Lane;
import roadnetwork.RoadNetwork;
import simulation.Adult;
import simulation.Child;
import simulation.House;
import simulation.JobType;
import simulation.Route;
import simulation.SUMOInstructionList;
import simulation.Trip;
import simulation.VehicleType;
import trafficdefinition.Accident;
import trafficdefinition.AreaFlow;
import trafficdefinition.Flow;
import trafficdefinition.HotSpot;
import trafficdefinition.RandomTrafficDefinitionLayer;
import trafficdefinition.School;
import trafficdefinition.TrafficArea;
import trafficdefinition.TrafficDefinitionElement;
import trafficdefinition.UserDefinedTrafficDefinitionLayer;

public class TrafficGenerator {
    public static void GenerateUserDefinedLayerTraffic(RoadNetwork roadNetwork, UserDefinedTrafficDefinitionLayer userDefinedTrafficDefinitionLayer, SUMOInstructionList<Trip> sUMOInstructionList, SUMOInstructionList<Route> sUMOInstructionList2) throws Exception {
        List list = userDefinedTrafficDefinitionLayer.getElements();
        for (TrafficDefinitionElement trafficDefinitionElement : list) {
            if (!trafficDefinitionElement.isEnabled()) continue;
            if (trafficDefinitionElement instanceof Flow) {
                sUMOInstructionList.addAll(TrafficGenerator.GenerateFlowTraffic((Flow)trafficDefinitionElement));
                continue;
            }
            if (trafficDefinitionElement instanceof AreaFlow) {
                sUMOInstructionList.addAll(TrafficGenerator.GenerateAreaFlowTraffic((AreaFlow)trafficDefinitionElement, roadNetwork));
                continue;
            }
            if (trafficDefinitionElement instanceof HotSpot) {
                sUMOInstructionList.addAll(TrafficGenerator.GenerateHotSpotTraffic((HotSpot)trafficDefinitionElement, roadNetwork));
                continue;
            }
            if (!(trafficDefinitionElement instanceof Accident)) continue;
            sUMOInstructionList2.addAll(TrafficGenerator.GenerateAccidentTraffic((Accident)trafficDefinitionElement, roadNetwork));
        }
    }

    public static void GenerateRandomLayerTraffic(RoadNetwork roadNetwork, RandomTrafficDefinitionLayer randomTrafficDefinitionLayer, SUMOInstructionList<Trip> sUMOInstructionList) throws Exception {
        Random random = RandomNumberProvider.getRandom();
        List<Object> list = new ArrayList();
        list = roadNetwork.getEdges();
        int n = list.size();
        String string = "1,0,0";
        if (n == 0) {
            return;
        }
        int n2 = randomTrafficDefinitionLayer.getEndingTime() - randomTrafficDefinitionLayer.getStartingTime();
        int n3 = randomTrafficDefinitionLayer.getVehiclesPerSecond() * n2;
        for (int i = 0; i < n3; ++i) {
            VehicleType vehicleType = randomTrafficDefinitionLayer.getVehicleSelection().getRandomType();
            Edge edge = (Edge)list.get(random.nextInt(n));
            Edge edge2 = (Edge)list.get(random.nextInt(n));
            int n4 = randomTrafficDefinitionLayer.getStartingTime() + random.nextInt(randomTrafficDefinitionLayer.getEndingTime() + 1 - randomTrafficDefinitionLayer.getStartingTime());
            sUMOInstructionList.add(new Trip(n4, "<trip id=\"" + randomTrafficDefinitionLayer.getName() + "-In-" + String.valueOf(i) + "\" depart=\"" + String.valueOf(n4) + "\" from=\"" + edge.getId() + "\" to=\"" + edge2.getId() + "\" color=\"" + string + "\" type=\"" + vehicleType.getName() + "\" />\n"));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void GenerateActivityBasedTraffic(RoadNetwork roadNetwork, List<JobType> list, TypeSelection<VehicleType> typeSelection, List<TrafficDefinitionElement> list2, SUMOInstructionList<Trip> sUMOInstructionList, SUMOInstructionList<Route> sUMOInstructionList2) throws Exception {
        ArrayList<TrafficArea> arrayList = new ArrayList<TrafficArea>();
        ArrayList<School> arrayList2 = new ArrayList<School>();
        for (TrafficDefinitionElement object : list2) {
            if (object instanceof TrafficArea) {
                arrayList.add((TrafficArea)object);
                continue;
            }
            if (!(object instanceof School)) continue;
            arrayList2.add((School)object);
        }
        for (School school : arrayList2) {
            school.setAvailableCapacity(school.getCapacity());
            school.setClosestEdge(roadNetwork.findClosestEdge(school.getLocation()));
        }
        Hashtable hashtable = new Hashtable();
        for (JobType jobType : list) {
            ArrayList<Pair<TrafficArea, Integer>> arrayList3 = new ArrayList<Pair<TrafficArea, Integer>>();
            for (TrafficArea trafficArea : arrayList) {
                float f = trafficArea.getWorkersJobSelection().getTypePossibility(jobType).floatValue();
                if (!(f > 0.0f)) continue;
                arrayList3.add(new Pair<TrafficArea, Integer>(trafficArea, Math.round(f * (float)trafficArea.getWorkPositions())));
            }
            hashtable.put(jobType, arrayList3);
        }
        boolean bl = false;
        for (TrafficArea trafficArea : arrayList) {
            Object object2;
            Iterator iterator;
            ArrayList arrayList4 = new ArrayList();
            Random random = RandomNumberProvider.getRandom();
            for (int i = trafficArea.getPopulation(); i > 0; i -= ((House)((Object)iterator)).getNumberOfResidents()) {
                void var9_14;
                iterator = new House(trafficArea, (int)(++var9_14));
                object2 = trafficArea.getRandomPointInArea();
                ((House)((Object)iterator)).setAddress(roadNetwork.findClosestEdge((Point2D.Double)object2));
                ((House)((Object)iterator)).setLocation((Point2D.Double)object2);
                int n = Math.round((float)(random.nextGaussian() * 0.8 + (double)trafficArea.getAverageAdultsPerHouse()));
                if (n < 1) {
                    n = 1;
                }
                int n2 = Poisson.staticNextInt((double)trafficArea.getAverageChildrenPerHouse());
                ((House)((Object)iterator)).createAdults(n, trafficArea.getPossibilityAdultIsDriver(), trafficArea.getPossibilityAdultHasJob());
                ((House)((Object)iterator)).createChildren(n2);
                ((House)((Object)iterator)).assignVehiclesToDrivers(trafficArea.getPossibilityDriverHasCar(), typeSelection);
                for (Child child : ((House)((Object)iterator)).getChildren()) {
                    School school = TrafficGenerator.FindClosestSchoolToLocation(arrayList2, child.getSchoolType(), ((House)((Object)iterator)).getLocation());
                    child.setSchool(school);
                    if (school == null) continue;
                    school.setAvailableCapacity(school.getAvailableCapacity() - 1);
                }
                arrayList4.add(iterator);
            }
            for (Object object2 : arrayList4) {
                for (Adult adult : ((House)object2).getWorkingAdults()) {
                    JobType jobType = trafficArea.getResidentsJobSelection().getRandomType();
                    List list3 = (List)hashtable.get(jobType);
                    if (list3.size() > 0) {
                        int n = random.nextInt(list3.size());
                        Point2D.Double double_ = ((TrafficArea)((Pair)list3.get(n)).getFirst()).getRandomPointInArea();
                        adult.setJobLocation(jobType, roadNetwork.findClosestEdge(double_));
                        if ((Integer)((Pair)list3.get(n)).getSecond() == 1) {
                            list3.remove(n);
                            continue;
                        }
                        ((Pair)list3.get(n)).setSecond((Integer)((Pair)list3.get(n)).getSecond() - 1);
                        continue;
                    }
                    adult.setHasJob(false);
                }
            }
            iterator = arrayList4.iterator();
            while (iterator.hasNext()) {
                object2 = (House)iterator.next();
                System.out.println(trafficArea.getName() + " " + String.valueOf(((House)object2).getId()));
                ((House)object2).createActivities(sUMOInstructionList, sUMOInstructionList2);
            }
        }
    }

    private static SUMOInstructionList<Trip> GenerateHotSpotTraffic(HotSpot hotSpot, RoadNetwork roadNetwork) {
        Object object2;
        Random random = RandomNumberProvider.getRandom();
        SUMOInstructionList<Trip> sUMOInstructionList = new SUMOInstructionList<Trip>();
        List<Object> list = new ArrayList();
        list = roadNetwork.SelectEdges(hotSpot.getArea());
        int n = list.size();
        List<Object> list2 = new ArrayList();
        list2 = roadNetwork.getEdges();
        for (Object object2 : list) {
            if (!list2.contains(object2)) continue;
            list2.remove(object2);
        }
        int n2 = list2.size();
        object2 = new Float((float)hotSpot.getColor().getRed() / 255.0f).toString() + "," + new Float((float)hotSpot.getColor().getGreen() / 255.0f).toString() + "," + new Float((float)hotSpot.getColor().getBlue() / 255.0f).toString();
        if (n2 == 0 || n == 0) {
            return null;
        }
        for (int i = 0; i < hotSpot.getNumberOfVehicles(); ++i) {
            int n3;
            VehicleType vehicleType = hotSpot.getVehicleSelection().getRandomType();
            Edge edge = (Edge)list.get(random.nextInt(n));
            Edge edge2 = (Edge)list2.get(random.nextInt(n2));
            if (hotSpot.isDirectionIn()) {
                n3 = 0;
                if (hotSpot.getDirectionInType() == HotSpot.DirectionInTimeType.TimeOfDepartureFromSource) {
                    n3 = hotSpot.getDirectionInBeginTime() + random.nextInt(hotSpot.getDirectionInEndTime() + 1 - hotSpot.getDirectionInBeginTime());
                } else if (hotSpot.getDirectionInType() == HotSpot.DirectionInTimeType.TimeOfArrivalToDestination) {
                    float f = edge.DistanceFrom(edge2);
                    int n4 = Math.round(f / Constants.averageSpeed);
                    n3 = hotSpot.getDirectionInBeginTime() + random.nextInt(hotSpot.getDirectionInEndTime() + 1 - hotSpot.getDirectionInBeginTime()) - n4;
                    n3 = Math.min(n3, 0);
                }
                sUMOInstructionList.add(new Trip(n3, "<trip id=\"" + hotSpot.getName() + "-In-" + String.valueOf(i) + "\" depart=\"" + String.valueOf(n3) + "\" from=\"" + edge2.getId() + "\" to=\"" + edge.getId() + "\" color=\"" + (String)object2 + "\" type=\"" + vehicleType.getName() + "\" />\n"));
            }
            if (!hotSpot.isDirectionOut()) continue;
            n3 = hotSpot.getDirectionOutBeginTime() + random.nextInt(hotSpot.getDirectionOutEndTime() + 1 - hotSpot.getDirectionOutBeginTime());
            sUMOInstructionList.add(new Trip(n3, "<trip id=\"" + hotSpot.getName() + "-Out-" + String.valueOf(i) + "\" depart=\"" + String.valueOf(n3) + "\" from=\"" + edge.getId() + "\" to=\"" + edge2.getId() + "\" color=\"" + (String)object2 + "\" type=\"" + vehicleType.getName() + "\" />\n"));
        }
        return sUMOInstructionList;
    }

    private static SUMOInstructionList<Trip> GenerateFlowTraffic(Flow flow) {
        Random random = RandomNumberProvider.getRandom();
        SUMOInstructionList<Trip> sUMOInstructionList = new SUMOInstructionList<Trip>();
        for (int i = 0; i < flow.getNumberOfVehicles(); ++i) {
            int n = flow.getBeginTime() + random.nextInt(flow.getEndTime() + 1 - flow.getBeginTime());
            String string = new Float((float)flow.getColor().getRed() / 255.0f).toString() + "," + new Float((float)flow.getColor().getGreen() / 255.0f).toString() + "," + new Float((float)flow.getColor().getBlue() / 255.0f).toString();
            sUMOInstructionList.add(new Trip(n, "<trip id=\"" + flow.getName() + "-" + String.valueOf(i) + "\" depart=\"" + String.valueOf(n) + "\" from=\"" + flow.getStart().getId() + "\" to=\"" + flow.getEnd().getId() + "\" color=\"" + string + "\" type=\"" + flow.getVehicleSelection().getRandomType().getName() + "\" />\n"));
        }
        return sUMOInstructionList;
    }

    private static SUMOInstructionList<Route> GenerateAccidentTraffic(Accident accident, RoadNetwork roadNetwork) throws Exception {
        SUMOInstructionList<Route> sUMOInstructionList = new SUMOInstructionList<Route>();
        for (Pair<Lane, Boolean> pair : accident.getAffectedLanes()) {
            Edge edge;
            if (!pair.getSecond().booleanValue()) continue;
            String string = accident.getEdge().getId();
            if (pair.getFirst().getConnectedEdges().size() > 0 && (edge = roadNetwork.findEdge(pair.getFirst().getConnectedEdges().get(0))) != null) {
                string = string + " " + edge.getId();
            }
            sUMOInstructionList.add(new Route(accident.getStartingTime(), "<vehicle id=\"Accident-" + accident.getName() + "-" + pair.getFirst().getId() + "\" type=\"Default\" depart=\"" + String.valueOf(accident.getStartingTime()) + "\" color=\"1,0,0\">\n" + "     <route color=\"1,0,0\">" + string + "</route>\n" + "     <stop lane=\"" + pair.getFirst().getId() + "\" pos=\"" + accident.getEdgeRelativeLocation() + "\" duration=\"" + String.valueOf(accident.getEndingTime() - accident.getStartingTime()) + "\"/>\n" + "</vehicle>\n"));
        }
        return sUMOInstructionList;
    }

    private static SUMOInstructionList<Trip> GenerateAreaFlowTraffic(AreaFlow areaFlow, RoadNetwork roadNetwork) {
        Random random = RandomNumberProvider.getRandom();
        SUMOInstructionList<Trip> sUMOInstructionList = new SUMOInstructionList<Trip>();
        List<Object> list = new ArrayList();
        list = roadNetwork.SelectEdges(areaFlow.getStartArea());
        int n = list.size();
        List<Object> list2 = new ArrayList();
        list2 = roadNetwork.SelectEdges(areaFlow.getEndArea());
        int n2 = list2.size();
        if (n2 == 0 || n == 0) {
            return null;
        }
        for (int i = 0; i < areaFlow.getNumberOfVehicles(); ++i) {
            Edge edge = (Edge)list.get(random.nextInt(n));
            Edge edge2 = (Edge)list2.get(random.nextInt(n2));
            int n3 = areaFlow.getBeginTime() + random.nextInt(areaFlow.getEndTime() + 1 - areaFlow.getBeginTime());
            String string = new Float((float)areaFlow.getColor().getRed() / 255.0f).toString() + "," + new Float((float)areaFlow.getColor().getGreen() / 255.0f).toString() + "," + new Float((float)areaFlow.getColor().getBlue() / 255.0f).toString();
            sUMOInstructionList.add(new Trip(n3, "<trip id=\"" + areaFlow.getName() + "-" + String.valueOf(i) + "\" depart=\"" + String.valueOf(n3) + "\" from=\"" + edge.getId() + "\" to=\"" + edge2.getId() + "\" color=\"" + string + "\" type=\"" + areaFlow.getVehicleSelection().getRandomType().getName() + "\" />\n"));
        }
        return sUMOInstructionList;
    }

    private static School FindClosestSchoolToLocation(List<School> list, SchoolType schoolType, Point2D.Double double_) {
        School school = null;
        double d = 3.4028234663852886E38;
        for (School school2 : list) {
            double d2;
            if (school2.getSchoolType() != schoolType || school2.getAvailableCapacity() <= 0 || !((d2 = school2.getLocation().distance(double_)) < d)) continue;
            d = d2;
            school = school2;
        }
        return school;
    }
}

