/*
 * Decompiled with CFR 0.152.
 */
package simulation;

import classes.Project;
import helpers.ApplicationSettings;
import helpers.StreamGobbler;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JOptionPane;
import roadnetwork.RoadNetwork;
import simulation.CustomComparator;
import simulation.Route;
import simulation.SUMOInstructionList;
import simulation.Simulation;
import simulation.TrafficGenerator;
import simulation.Trip;
import simulation.VehicleType;
import trafficdefinition.ActivityBasedTrafficDefinitionLayer;
import trafficdefinition.RandomTrafficDefinitionLayer;
import trafficdefinition.TrafficDefinitionElement;
import trafficdefinition.TrafficDefinitionLayer;
import trafficdefinition.UserDefinedTrafficDefinitionLayer;

public class SimulationExporter {
    private static void ExportNet(RoadNetwork roadNetwork, String string, String string2, boolean bl) throws Exception {
        FileOutputStream fileOutputStream = new FileOutputStream(string + File.separator + string2 + ".edg.xml");
        FileOutputStream fileOutputStream2 = new FileOutputStream(string + File.separator + string2 + ".nod.xml");
        roadNetwork.RemoveDeletedFromXMLDocuments(fileOutputStream2, fileOutputStream);
        fileOutputStream.close();
        fileOutputStream2.close();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(ApplicationSettings.getNetConvertPath());
        arrayList.add("-n");
        arrayList.add(string2 + ".nod.xml");
        arrayList.add("-e");
        arrayList.add(string2 + ".edg.xml");
        arrayList.add("-o");
        arrayList.add(string2 + ".net.xml");
        if (bl) {
            arrayList.add("--speed-in-kmh");
        }
        ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
        processBuilder.directory(new File(string));
        Process process = processBuilder.start();
        StreamGobbler streamGobbler = new StreamGobbler(process.getInputStream());
        StreamGobbler streamGobbler2 = new StreamGobbler(process.getErrorStream());
        streamGobbler.start();
        streamGobbler2.start();
        int n = process.waitFor();
        streamGobbler.stop();
        streamGobbler2.stop();
        List<String> list = streamGobbler.getReadLines();
        List<String> list2 = streamGobbler2.getReadLines();
        for (String string3 : list2) {
            System.out.println(string3);
        }
    }

    private static void ExportPolygons(List<TrafficDefinitionLayer> list, String string, String string2) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        for (TrafficDefinitionLayer trafficDefinitionLayer : list) {
            for (TrafficDefinitionElement trafficDefinitionElement : trafficDefinitionLayer.getElements()) {
                if (!trafficDefinitionElement.getExportPolygon() || !trafficDefinitionElement.isEnabled()) continue;
                stringBuilder.append(trafficDefinitionElement.getGeometryXML());
            }
        }
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string + File.separator + string2 + ".geometry.xml"));
        bufferedWriter.write("<polys>\n");
        bufferedWriter.write(stringBuilder.toString());
        bufferedWriter.write("</polys>\n");
        bufferedWriter.close();
    }

    public static void ExportSimulation(Project project, List<TrafficDefinitionLayer> list) {
        Object object;
        Serializable serializable;
        Simulation simulation = project.getSimulation();
        if (JOptionPane.showConfirmDialog(null, "All files in the folder " + simulation.getExportPath() + " will be deleted.\nAre you sure you want to continue?", "Confirm file deletion", 0, 2) == 0) {
            serializable = new File(simulation.getExportPath());
            for (File object22 : ((File)serializable).listFiles()) {
                if (object22.delete()) continue;
                JOptionPane.showMessageDialog(null, "Unable to empty simulation export folder. The operation was cancelled.", "Error", 0);
                return;
            }
        } else {
            return;
        }
        try {
            SimulationExporter.ExportNet(project.getRoadNetwork(), simulation.getExportPath(), simulation.getName(), simulation.isRoadNetworkSpeedInKMH());
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "Error while exporting road network", "Error", 0);
            exception.printStackTrace();
            return;
        }
        if (simulation.getExportPolygons()) {
            try {
                SimulationExporter.ExportPolygons(list, simulation.getExportPath(), simulation.getName());
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, "Error while exporting element geometry", "Error", 0);
                exception.printStackTrace();
                return;
            }
        }
        serializable = new SUMOInstructionList();
        SUMOInstructionList sUMOInstructionList = new SUMOInstructionList();
        SUMOInstructionList<Route> sUMOInstructionList2 = new SUMOInstructionList<Route>();
        try {
            object = new ArrayList<TrafficDefinitionElement>();
            for (TrafficDefinitionLayer trafficDefinitionLayer : list) {
                if (trafficDefinitionLayer instanceof UserDefinedTrafficDefinitionLayer) {
                    TrafficGenerator.GenerateUserDefinedLayerTraffic(project.getRoadNetwork(), (UserDefinedTrafficDefinitionLayer)trafficDefinitionLayer, (SUMOInstructionList<Trip>)serializable, sUMOInstructionList2);
                    continue;
                }
                if (trafficDefinitionLayer instanceof RandomTrafficDefinitionLayer) {
                    TrafficGenerator.GenerateRandomLayerTraffic(project.getRoadNetwork(), (RandomTrafficDefinitionLayer)trafficDefinitionLayer, (SUMOInstructionList<Trip>)serializable);
                    continue;
                }
                if (!(trafficDefinitionLayer instanceof ActivityBasedTrafficDefinitionLayer)) continue;
                for (Object object2 : trafficDefinitionLayer.getElements()) {
                    if (!((TrafficDefinitionElement)object2).isEnabled()) continue;
                    object.add((TrafficDefinitionElement)object2);
                }
            }
            TrafficGenerator.GenerateActivityBasedTraffic(project.getRoadNetwork(), project.getJobTypes(), project.getActivityBasedTrafficVehicleSelection(), object, (SUMOInstructionList<Trip>)serializable, sUMOInstructionList);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "Error while creating traffic for selected layers");
            exception.printStackTrace();
            return;
        }
        if (((ArrayList)serializable).isEmpty() && sUMOInstructionList.isEmpty() && sUMOInstructionList2.isEmpty()) {
            JOptionPane.showMessageDialog(null, "No trips or routes were generated");
        }
        Collections.sort(serializable, new CustomComparator());
        Collections.sort(sUMOInstructionList, new CustomComparator());
        Collections.sort(sUMOInstructionList2, new CustomComparator());
        if (!((ArrayList)serializable).isEmpty()) {
            try {
                object = new BufferedWriter(new FileWriter(simulation.getExportPath() + File.separator + simulation.getName() + ".generated-trips.xml"));
                ((Writer)object).write("<trips>\n");
                for (VehicleType vehicleType : project.getVehicleTypes()) {
                    ((Writer)object).write(vehicleType.toXML());
                }
                ((Writer)object).write(((SUMOInstructionList)serializable).toString());
                ((Writer)object).write("</trips>");
                ((BufferedWriter)object).close();
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, "Error while writing trip file", "Error", 0);
                exception.printStackTrace();
                return;
            }
        }
        if (!sUMOInstructionList.isEmpty()) {
            try {
                object = new BufferedWriter(new FileWriter(simulation.getExportPath() + File.separator + simulation.getName() + ".generated-routes.xml"));
                ((Writer)object).write("<routes>\n");
                for (VehicleType vehicleType : project.getVehicleTypes()) {
                    ((Writer)object).write(vehicleType.toXML());
                }
                ((Writer)object).write(sUMOInstructionList.toString());
                ((Writer)object).write("</routes>");
                ((BufferedWriter)object).close();
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, "Error while writing route file", "Error", 0);
                exception.printStackTrace();
                return;
            }
        }
        if (!sUMOInstructionList2.isEmpty()) {
            try {
                object = new BufferedWriter(new FileWriter(simulation.getExportPath() + File.separator + simulation.getName() + ".accidents.xml"));
                ((Writer)object).write("<routes>\n");
                if (sUMOInstructionList.isEmpty() && ((ArrayList)serializable).isEmpty()) {
                    for (VehicleType vehicleType : project.getVehicleTypes()) {
                        ((Writer)object).write(vehicleType.toXML());
                    }
                }
                ((Writer)object).write(sUMOInstructionList2.toString());
                ((Writer)object).write("</routes>");
                ((BufferedWriter)object).close();
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, "Error while writing accident routes file", "Error", 0);
                exception.printStackTrace();
                return;
            }
        }
        if (!((ArrayList)serializable).isEmpty() || !sUMOInstructionList.isEmpty()) {
            object = new ArrayList();
            object.add((TrafficDefinitionElement)((Object)ApplicationSettings.getDUARouterPath()));
            if (!((ArrayList)serializable).isEmpty()) {
                object.add((TrafficDefinitionElement)((Object)"-t"));
                object.add(simulation.getName() + ".generated-trips.xml");
            }
            if (!sUMOInstructionList.isEmpty()) {
                object.add("-r");
                object.add(simulation.getName() + ".generated-routes.xml");
            }
            object.add("-n");
            object.add(simulation.getName() + ".net.xml");
            object.add("-o");
            object.add(simulation.getName() + ".rou.xml");
            object.add("--ignore-errors");
            try {
                Object object2;
                ProcessBuilder processBuilder = new ProcessBuilder((List<String>)object);
                processBuilder.directory(new File(simulation.getExportPath()));
                Process process = processBuilder.start();
                StreamGobbler streamGobbler = new StreamGobbler(process.getInputStream());
                object2 = new StreamGobbler(process.getErrorStream());
                streamGobbler.start();
                ((Thread)object2).start();
                int n = process.waitFor();
                streamGobbler.stop();
                ((Thread)object2).stop();
                List<String> list2 = streamGobbler.getReadLines();
                List<String> list3 = ((StreamGobbler)object2).getReadLines();
                for (String string : list3) {
                    System.out.println(string);
                }
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, "Error while generating routes from trips", "Error", 0);
                exception.printStackTrace();
                return;
            }
        }
        try {
            object = new BufferedWriter(new FileWriter(simulation.getExportPath() + File.separator + simulation.getName() + ".sumocfg"));
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<configuration>\n");
            stringBuilder.append("<input-files>\n");
            stringBuilder.append("<net-file>" + simulation.getName() + ".net.xml</net-file>\n");
            if (!(((ArrayList)serializable).isEmpty() && sUMOInstructionList.isEmpty() && sUMOInstructionList2.isEmpty())) {
                if (!(((ArrayList)serializable).isEmpty() && sUMOInstructionList.isEmpty() || !sUMOInstructionList2.isEmpty())) {
                    stringBuilder.append("<route-files>");
                    stringBuilder.append(simulation.getName() + ".rou.xml");
                    stringBuilder.append("</route-files>\n");
                } else if (((ArrayList)serializable).isEmpty() && sUMOInstructionList.isEmpty() && !sUMOInstructionList2.isEmpty()) {
                    stringBuilder.append("<route-files>");
                    stringBuilder.append(simulation.getName() + ".accidents.xml");
                    stringBuilder.append("</route-files>\n");
                } else {
                    stringBuilder.append("<route-files>");
                    stringBuilder.append(simulation.getName() + ".rou.xml" + ";" + simulation.getName() + ".accidents.xml");
                    stringBuilder.append("</route-files>\n");
                }
            }
            if (simulation.getExportPolygons()) {
                stringBuilder.append("<additional-files>" + simulation.getName() + ".geometry.xml</additional-files>\n");
            }
            stringBuilder.append("</input-files>\n");
            stringBuilder.append("<netstate-dump>" + simulation.getName() + ".netdmp.xml</netstate-dump>\n");
            stringBuilder.append("<simulation>\n");
            stringBuilder.append("<begin>" + simulation.getBeginTime() + "</begin>\n");
            stringBuilder.append("<end>" + simulation.getEndTime() + "</end>\n");
            stringBuilder.append("</simulation>\n");
            stringBuilder.append("</configuration>\n");
            ((Writer)object).write(stringBuilder.toString());
            ((BufferedWriter)object).close();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "Error while writing simulation file", "Error", 0);
            exception.printStackTrace();
            return;
        }
    }
}

