/*
 * Decompiled with CFR 0.152.
 */
package simulation;

import classes.TypeSelection;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import roadnetwork.Edge;
import simulation.Adult;
import simulation.Child;
import simulation.Route;
import simulation.SUMOInstructionList;
import simulation.Trip;
import simulation.VehicleType;
import trafficdefinition.School;
import trafficdefinition.TrafficArea;

public class House {
    private List<Adult> adults = new ArrayList<Adult>();
    private List<Child> children = new ArrayList<Child>();
    private Edge address;
    private TrafficArea area;
    private int id;
    private Point2D.Double location;

    public House(TrafficArea trafficArea, int n) {
        this.id = n;
        this.area = trafficArea;
    }

    public void assignVehiclesToDrivers(float f, TypeSelection<VehicleType> typeSelection) {
        ArrayList<VehicleType> arrayList = new ArrayList<VehicleType>();
        int n = Math.round(f * (float)this.getNumberOfDrivers());
        for (int i = 0; i < n; ++i) {
            arrayList.add(typeSelection.getRandomType());
        }
        ArrayList<VehicleType> arrayList2 = new ArrayList<VehicleType>();
        arrayList2.addAll(arrayList);
        List<Adult> list = this.getWorkingDrivers();
        List<Adult> list2 = this.getNonWorkingDrivers();
        while (!arrayList2.isEmpty()) {
            if (!list.isEmpty()) {
                list.get(0).setVehicle((VehicleType)arrayList2.get(0));
                list.remove(0);
            } else {
                list2.get(0).setVehicle((VehicleType)arrayList2.get(0));
                list2.remove(0);
            }
            arrayList2.remove(0);
        }
    }

    public void createActivities(SUMOInstructionList<Trip> sUMOInstructionList, SUMOInstructionList<Route> sUMOInstructionList2) throws Exception {
        String string = new Float((float)this.area.getColor().getRed() / 255.0f).toString() + "," + new Float((float)this.area.getColor().getGreen() / 255.0f).toString() + "," + new Float((float)this.area.getColor().getBlue() / 255.0f).toString();
        Hashtable hashtable = new Hashtable();
        ArrayList<School> arrayList = new ArrayList<School>();
        for (Child object : this.children) {
            if (object.getSchool() == null) continue;
            if (!hashtable.containsKey(object.getSchool())) {
                hashtable.put(object.getSchool(), new ArrayList());
                arrayList.add(object.getSchool());
            }
            ((List)hashtable.get(object.getSchool())).add(object);
        }
        Collections.sort(arrayList, new School.SchoolPriorityComparator());
        block1: for (School school : arrayList) {
            for (Adult adult : this.getAdultsWithVehicleOrderByEmploymentStatus()) {
                if (!adult.canTakeChildToSchool(school, 600)) continue;
                adult.takeChildrenToSchool((List)hashtable.get(school));
                break;
            }
            for (Adult adult : this.getAdultsWithVehicleOrderByEmploymentStatus()) {
                if (!adult.canPickupChildFromSchool(school)) continue;
                adult.pickupChildrenFromSchool((List)hashtable.get(school));
                continue block1;
            }
        }
        int n = 0;
        for (Adult adult : this.adults) {
            adult.createTrips(string, sUMOInstructionList, sUMOInstructionList2, n++);
        }
    }

    public void createAdults(int n, float f, float f2) {
        for (int i = 0; i < n; ++i) {
            this.adults.add(new Adult(this, f, f2));
        }
    }

    public void createChildren(int n) {
        for (int i = 0; i < n; ++i) {
            this.children.add(new Child());
        }
    }

    public List<Child> getChildren() {
        return this.children;
    }

    public Edge getAddress() {
        return this.address;
    }

    public Point2D.Double getLocation() {
        return this.location;
    }

    public int getNumberOfResidents() {
        return this.adults.size() + this.children.size();
    }

    public List<Adult> getWorkingAdults() {
        ArrayList<Adult> arrayList = new ArrayList<Adult>();
        for (Adult adult : this.adults) {
            if (!adult.hasJob()) continue;
            arrayList.add(adult);
        }
        return arrayList;
    }

    public void setAddress(Edge edge) {
        this.address = edge;
    }

    public void setLocation(Point2D.Double double_) {
        this.location = double_;
    }

    private List<Adult> getNonWorkingDrivers() {
        ArrayList<Adult> arrayList = new ArrayList<Adult>();
        for (Adult adult : this.adults) {
            if (!adult.canDrive() || adult.hasJob()) continue;
            arrayList.add(adult);
        }
        return arrayList;
    }

    private List<Adult> getAdultsWithVehicleOrderByEmploymentStatus() {
        ArrayList<Adult> arrayList = new ArrayList<Adult>();
        for (Adult adult : this.adults) {
            if (adult.hasJob() || adult.getVehicle() == null) continue;
            arrayList.add(adult);
        }
        for (Adult adult : this.adults) {
            if (!adult.hasJob() || adult.getVehicle() == null) continue;
            arrayList.add(adult);
        }
        return arrayList;
    }

    private int getNumberOfDrivers() {
        int n = 0;
        for (Adult adult : this.adults) {
            if (!adult.canDrive()) continue;
            ++n;
        }
        return n;
    }

    private List<Adult> getWorkingDrivers() {
        ArrayList<Adult> arrayList = new ArrayList<Adult>();
        for (Adult adult : this.adults) {
            if (!adult.canDrive() || !adult.hasJob()) continue;
            arrayList.add(adult);
        }
        return arrayList;
    }

    public int getId() {
        return this.id;
    }
}

