/*
 * Decompiled with CFR 0.152.
 */
package roadnetwork;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import roadnetwork.Edge;
import roadnetwork.Junction;
import roadnetwork.Lane;
import roadnetwork.RoadNetwork;
import shapes.Point2DExt;

public class RoadNetworkParser {
    public RoadNetwork ParseXMLNetFile(Document document) throws Exception {
        RoadNetwork roadNetwork = new RoadNetwork();
        Element element = document.getDocumentElement();
        NodeList nodeList = element.getElementsByTagName("edge");
        List<Edge> list = this.ParseEdges(nodeList);
        NodeList nodeList2 = element.getElementsByTagName("succ");
        this.ParseDeprecatedSuccessors(nodeList2, list);
        NodeList nodeList3 = element.getElementsByTagName("connection");
        this.ParseNewSuccessors(nodeList2, list);
        roadNetwork.AddElements(list);
        NodeList nodeList4 = element.getElementsByTagName("junction");
        List<Junction> list2 = this.ParseJunctions(nodeList4);
        roadNetwork.AddElements(list2);
        return roadNetwork;
    }

    private List<Edge> ParseEdges(NodeList nodeList) {
        ArrayList<Edge> arrayList = new ArrayList<Edge>();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            NamedNodeMap namedNodeMap = node.getAttributes();
            Node node2 = namedNodeMap.getNamedItem("function");
            if (node2 != null && !node2.getNodeValue().equals("normal")) continue;
            Edge edge = new Edge();
            edge.setId(namedNodeMap.getNamedItem("id").getNodeValue());
            edge.setFrom(namedNodeMap.getNamedItem("from").getNodeValue());
            edge.setTo(namedNodeMap.getNamedItem("to").getNodeValue());
            Node node3 = namedNodeMap.getNamedItem("priority");
            if (node3 != null) {
                edge.setPriority(Integer.parseInt(node3.getNodeValue()));
            } else {
                edge.setPriority(-1);
            }
            NodeList nodeList2 = ((Element)node).getElementsByTagName("lane");
            int n2 = nodeList2.getLength();
            for (int j = 0; j < n2; ++j) {
                String[] stringArray;
                Node node4 = nodeList2.item(j);
                Lane lane = new Lane();
                NamedNodeMap namedNodeMap2 = node4.getAttributes();
                if (j == 0) {
                    edge.setLength(Float.parseFloat(namedNodeMap2.getNamedItem("length").getNodeValue()));
                    edge.setSpeedLimit(Float.parseFloat(namedNodeMap2.getNamedItem("speed").getNodeValue()));
                }
                lane.setId(namedNodeMap2.getNamedItem("id").getNodeValue());
                ArrayList<Point2DExt> arrayList2 = new ArrayList<Point2DExt>();
                for (String string : stringArray = namedNodeMap2.getNamedItem("shape").getNodeValue().split(" ")) {
                    String[] stringArray2 = string.split(",");
                    double d = Double.parseDouble(stringArray2[0]);
                    double d2 = Double.parseDouble(stringArray2[1]);
                    arrayList2.add(new Point2DExt(d, d2));
                }
                lane.SetShape(arrayList2);
                edge.AddLane(lane);
            }
            edge.CalculateShape();
            arrayList.add(edge);
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    private void ParseDeprecatedSuccessors(NodeList nodeList, List<Edge> list) {
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            void var10_13;
            Node node = nodeList.item(i);
            NamedNodeMap namedNodeMap = node.getAttributes();
            String string = namedNodeMap.getNamedItem("edge").getNodeValue();
            Edge edge = null;
            for (Edge edge2 : list) {
                if (!edge2.getId().equals(string)) continue;
                edge = edge2;
            }
            if (edge == null) continue;
            String string2 = namedNodeMap.getNamedItem("lane").getNodeValue();
            Object var10_12 = null;
            for (Lane lane : edge.getLanes()) {
                if (!lane.getId().equals(string2)) continue;
                Lane lane2 = lane;
            }
            if (var10_13 == null) {
                System.out.printf("Lane %s not found\n", string2);
                continue;
            }
            NodeList nodeList2 = node.getChildNodes();
            int n2 = nodeList2.getLength();
            for (int j = 0; j < n2; ++j) {
                NamedNodeMap namedNodeMap2;
                String string3;
                String string4;
                Node node2 = nodeList2.item(j);
                if (!node2.getNodeName().equals("succlane") || (string4 = this.findEdgeIdToLaneId(string3 = (namedNodeMap2 = node2.getAttributes()).getNamedItem("lane").getNodeValue(), list)) == null) continue;
                var10_13.AddConnectedEdge(string4);
            }
        }
    }

    private void ParseNewSuccessors(NodeList nodeList, List<Edge> list) {
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Edge edge32;
            Node node = nodeList.item(i);
            NamedNodeMap namedNodeMap = node.getAttributes();
            String string = namedNodeMap.getNamedItem("from").getNodeValue();
            Edge edge2 = null;
            for (Edge edge32 : list) {
                if (!edge32.getId().equals(string)) continue;
                edge2 = edge32;
            }
            if (edge2 == null) continue;
            String string2 = namedNodeMap.getNamedItem("to").getNodeValue();
            edge32 = null;
            for (Edge edge : list) {
                if (!edge.getId().equals(string2)) continue;
                edge32 = edge;
            }
            if (edge32 == null) continue;
            String string3 = namedNodeMap.getNamedItem("fromLane").getNodeValue();
            Lane lane = edge2.getLanes().get(Integer.parseInt(string3));
            lane.AddConnectedEdge(string2);
        }
    }

    private String findEdgeIdToLaneId(String string, List<Edge> list) {
        for (Edge edge : list) {
            for (Lane lane : edge.getLanes()) {
                if (!lane.getId().equals(string)) continue;
                return edge.getId();
            }
        }
        return null;
    }

    private List<Junction> ParseJunctions(NodeList nodeList) {
        ArrayList<Junction> arrayList = new ArrayList<Junction>();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            NamedNodeMap namedNodeMap = node.getAttributes();
            Node node2 = namedNodeMap.getNamedItem("type");
            if (node2.getNodeValue().equals("internal")) continue;
            Junction junction = new Junction();
            junction.setId(namedNodeMap.getNamedItem("id").getNodeValue());
            junction.setType(namedNodeMap.getNamedItem("type").getNodeValue());
            String string = namedNodeMap.getNamedItem("shape").getNodeValue();
            if (string.equals("")) {
                junction.SetShape(null);
            } else {
                String[] stringArray = string.split(" ");
                ArrayList<Point2D.Float> arrayList2 = new ArrayList<Point2D.Float>();
                if (stringArray.length > 0 && stringArray[0] != "") {
                    for (String string2 : stringArray) {
                        String[] stringArray2 = string2.split(",");
                        float f = Float.parseFloat(stringArray2[0]);
                        float f2 = Float.parseFloat(stringArray2[1]);
                        arrayList2.add(new Point2D.Float(f, f2));
                    }
                }
                junction.SetShape(arrayList2);
            }
            arrayList.add(junction);
        }
        return arrayList;
    }
}

