/*
 * Decompiled with CFR 0.152.
 */
package roadnetwork;

import classes.Layer;
import classes.ProjectElement;
import enums.SelectionType;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import roadnetwork.Edge;
import roadnetwork.Junction;
import roadnetwork.RoadNetworkElement;
import shapes.Rectangle2DExt;
import trafficdefinition.TrafficDefinitionElement;

public class RoadNetwork
extends Layer<RoadNetworkElement>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<RoadNetworkElement> deletedMapElements = new ArrayList<RoadNetworkElement>();
    private List<RoadNetworkElement> selectedDeletedMapElements = new ArrayList<RoadNetworkElement>();
    private String roadNetworkEdgesXML = "";
    private String roadNetworkNodesXML = "";
    private transient boolean showDeleted = false;
    Rectangle2DExt bounds = null;

    @Override
    public void AlterSelection(Rectangle rectangle, SelectionType selectionType) {
        switch (selectionType) {
            case New: {
                this.SelectNoneElements();
            }
            case Add: {
                List<RoadNetworkElement> list;
                super.AddToSelection(rectangle);
                if (!this.showDeleted || (list = super.RectangleHitTest(rectangle, this.deletedMapElements)).size() <= 0) break;
                this.deletedMapElements.removeAll(list);
                this.selectedDeletedMapElements.addAll(list);
                break;
            }
            case Remove: {
                List<RoadNetworkElement> list;
                super.RemoveFromSelection(rectangle);
                if (!this.showDeleted || (list = super.RectangleHitTest(rectangle, this.selectedDeletedMapElements)).size() <= 0) break;
                this.deletedMapElements.addAll(list);
                this.selectedDeletedMapElements.removeAll(list);
            }
        }
        this.NotifySelectionChanged();
    }

    @Override
    public void DeleteSelectedElements() {
        ProjectElement projectElement;
        Iterator iterator;
        ArrayList<Edge> arrayList = new ArrayList<Edge>();
        ArrayList<ProjectElement> arrayList2 = new ArrayList<ProjectElement>();
        for (RoadNetworkElement roadNetworkElement : this.selectedElements) {
            if (!(roadNetworkElement instanceof Edge) || !((Edge)roadNetworkElement).HasDependentTrafficElements()) continue;
            arrayList.add((Edge)roadNetworkElement);
        }
        for (Edge edge : arrayList) {
            Object object = "";
            Object object2 = edge.getDependentTrafficElements();
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                projectElement = iterator.next();
                object = (String)object + "Name: " + ((TrafficDefinitionElement)projectElement).getName() + " Layer: " + ((TrafficDefinitionElement)projectElement).getLayer().getName() + "\n";
            }
            if (JOptionPane.showConfirmDialog(null, "You have selected to delete edge " + edge.id + "\nThe following traffic elements depend on this edge:\n" + (String)object + "Should the edge be deleted anyway?") == 0) {
                iterator = object2.iterator();
                while (iterator.hasNext()) {
                    projectElement = (TrafficDefinitionElement)iterator.next();
                    edge.RemoveDependentTrafficElement((TrafficDefinitionElement)projectElement);
                    ((TrafficDefinitionElement)projectElement).getLayer().DeleteTrafficElement((TrafficDefinitionElement)projectElement);
                }
                continue;
            }
            this.elements.add(edge);
            this.selectedElements.remove(edge);
        }
        for (RoadNetworkElement roadNetworkElement : this.selectedElements) {
            if (!(roadNetworkElement instanceof Junction)) continue;
            for (Object object2 : this.elements) {
                if (!(object2 instanceof Edge)) continue;
                iterator = (Edge)object2;
                projectElement = (Junction)roadNetworkElement;
                if (!((Edge)((Object)iterator)).getFrom().equals(((RoadNetworkElement)projectElement).getId()) && !((Edge)((Object)iterator)).getTo().equals(((RoadNetworkElement)projectElement).getId())) continue;
                arrayList2.add(projectElement);
            }
        }
        for (Junction junction : arrayList2) {
            this.elements.add(junction);
            this.selectedElements.remove(junction);
        }
        this.deletedMapElements.addAll(this.selectedElements);
        this.selectedElements.clear();
        this.ReCalculateBounds();
        this.NotifyCollectionModified();
        this.NotifySelectionChanged();
    }

    @Override
    public void Draw(Graphics2D graphics2D, double d) {
        for (RoadNetworkElement roadNetworkElement : this.elements) {
            try {
                roadNetworkElement.Draw(graphics2D, d, false, false);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        for (RoadNetworkElement roadNetworkElement : this.selectedElements) {
            roadNetworkElement.Draw(graphics2D, d, false, true);
        }
        if (this.showDeleted) {
            for (RoadNetworkElement roadNetworkElement : this.deletedMapElements) {
                roadNetworkElement.Draw(graphics2D, d, true, false);
            }
            for (RoadNetworkElement roadNetworkElement : this.selectedDeletedMapElements) {
                roadNetworkElement.Draw(graphics2D, d, true, true);
            }
        }
    }

    public Edge findClosestEdge(Point2D.Double double_) {
        Edge edge = null;
        double d = 3.4028234663852886E38;
        for (Edge edge2 : this.getEdges()) {
            double d2 = edge2.DistanceFrom(double_);
            if (!(d2 < d)) continue;
            d = d2;
            edge = edge2;
        }
        return edge;
    }

    public Rectangle2DExt getBounds() {
        if (this.bounds == null) {
            this.ReCalculateBounds();
        }
        return this.bounds;
    }

    public List<RoadNetworkElement> getDeletedElements() {
        ArrayList<RoadNetworkElement> arrayList = new ArrayList<RoadNetworkElement>();
        arrayList.addAll(this.deletedMapElements);
        arrayList.addAll(this.selectedDeletedMapElements);
        return arrayList;
    }

    public List<Edge> getEdges() {
        ArrayList<Edge> arrayList = new ArrayList<Edge>();
        for (RoadNetworkElement roadNetworkElement : this.elements) {
            if (!(roadNetworkElement instanceof Edge)) continue;
            arrayList.add((Edge)roadNetworkElement);
        }
        for (RoadNetworkElement roadNetworkElement : this.selectedElements) {
            if (!(roadNetworkElement instanceof Edge)) continue;
            arrayList.add((Edge)roadNetworkElement);
        }
        return arrayList;
    }

    public List<Junction> getJunctions() {
        ArrayList<Junction> arrayList = new ArrayList<Junction>();
        for (RoadNetworkElement roadNetworkElement : this.elements) {
            if (!(roadNetworkElement instanceof Junction)) continue;
            arrayList.add((Junction)roadNetworkElement);
        }
        for (RoadNetworkElement roadNetworkElement : this.selectedElements) {
            if (!(roadNetworkElement instanceof Junction)) continue;
            arrayList.add((Junction)roadNetworkElement);
        }
        return arrayList;
    }

    @Override
    public List<RoadNetworkElement> getElements() {
        List<RoadNetworkElement> list = super.getElements();
        if (this.showDeleted) {
            list.addAll(this.deletedMapElements);
            list.addAll(this.selectedDeletedMapElements);
        }
        return list;
    }

    public String getRoadNetworkEdgesXML() {
        return this.roadNetworkEdgesXML;
    }

    public String getRoadNetworkNodesXML() {
        return this.roadNetworkNodesXML;
    }

    @Override
    public void NotifySelectionChanged() {
        if (!this.showDeleted) {
            super.NotifySelectionChanged();
        } else {
            ArrayList<RoadNetworkElement> arrayList = new ArrayList<RoadNetworkElement>();
            arrayList.addAll(this.selectedElements);
            arrayList.addAll(this.selectedDeletedMapElements);
            this.NotifySelectionChanged(arrayList);
        }
    }

    public void PurgeDeleted() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        try {
            this.RemoveDeletedFromXMLDocuments(byteArrayOutputStream2, byteArrayOutputStream);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "Error while purging deleted elements", "Error", 0);
            exception.printStackTrace();
        }
        this.roadNetworkEdgesXML = byteArrayOutputStream.toString();
        this.roadNetworkNodesXML = byteArrayOutputStream2.toString();
        this.deletedMapElements.clear();
        this.selectedDeletedMapElements.clear();
        this.ReCalculateBounds();
        this.NotifyCollectionModified();
        this.NotifySelectionChanged();
    }

    public void RemoveDeletedFromXMLDocuments(OutputStream outputStream, OutputStream outputStream2) throws Exception {
        Object object;
        int transformerFactory;
        Document document = null;
        Document document2 = null;
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        document = documentBuilder.parse(new InputSource(new StringReader(this.roadNetworkEdgesXML)));
        document2 = documentBuilder.parse(new InputSource(new StringReader(this.roadNetworkNodesXML)));
        List<RoadNetworkElement> list = this.getDeletedElements();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        for (RoadNetworkElement object32 : list) {
            if (object32 instanceof Edge) {
                hashtable.put(object32.getId(), "");
                continue;
            }
            if (!(object32 instanceof Node)) continue;
            hashtable2.put(object32.getId(), "");
        }
        NodeList nodeList = document.getDocumentElement().getElementsByTagName("edge");
        NodeList nodeList2 = document2.getDocumentElement().getElementsByTagName("node");
        int n = nodeList.getLength();
        int n2 = nodeList2.getLength();
        ArrayList<Node> arrayList = new ArrayList<Node>();
        ArrayList<Node> arrayList2 = new ArrayList<Node>();
        for (transformerFactory = 0; transformerFactory < n; ++transformerFactory) {
            Node node = nodeList.item(transformerFactory);
            object = node.getAttributes().getNamedItem("id").getNodeValue();
            if (!hashtable.containsKey(object)) continue;
            arrayList.add(node);
        }
        for (transformerFactory = 0; transformerFactory < n2; ++transformerFactory) {
            Node node = nodeList2.item(transformerFactory);
            object = node.getAttributes().getNamedItem("id").getNodeValue();
            if (!hashtable2.containsKey(object)) continue;
            arrayList2.add(node);
        }
        for (Node node : arrayList) {
            document.getDocumentElement().removeChild(node);
        }
        for (Node node : arrayList2) {
            document2.getDocumentElement().removeChild(node);
        }
        TransformerFactory transformerFactory2 = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory2.newTransformer();
        object = new DOMSource(document);
        StreamResult streamResult = new StreamResult(outputStream2);
        DOMSource dOMSource = new DOMSource(document2);
        StreamResult streamResult2 = new StreamResult(outputStream);
        transformer.transform((Source)object, streamResult);
        transformer.transform(dOMSource, streamResult2);
    }

    @Override
    public void SelectAllElements() {
        super.SelectAllElements();
        if (this.showDeleted) {
            this.selectedDeletedMapElements.addAll(this.deletedMapElements);
            this.deletedMapElements.clear();
        }
        this.NotifySelectionChanged();
    }

    public List<Edge> SelectEdges(Shape shape) {
        ArrayList<Edge> arrayList = new ArrayList<Edge>();
        for (Edge edge : this.getEdges()) {
            if (!edge.Overlaps(shape)) continue;
            arrayList.add(edge);
        }
        return arrayList;
    }

    @Override
    public boolean SelectElement(RoadNetworkElement roadNetworkElement) {
        if (super.SelectElement(roadNetworkElement)) {
            return true;
        }
        this.deletedMapElements.addAll(this.selectedDeletedMapElements);
        this.selectedDeletedMapElements.clear();
        if (this.deletedMapElements.contains(roadNetworkElement)) {
            this.selectedDeletedMapElements.add(roadNetworkElement);
            this.deletedMapElements.remove(roadNetworkElement);
            return true;
        }
        return false;
    }

    @Override
    public void SelectInverseElements() {
        super.SelectInverseElements();
        if (this.showDeleted) {
            ArrayList<RoadNetworkElement> arrayList = new ArrayList<RoadNetworkElement>();
            arrayList.addAll(this.deletedMapElements);
            this.deletedMapElements.clear();
            this.deletedMapElements.addAll(this.selectedDeletedMapElements);
            this.selectedDeletedMapElements.clear();
            this.selectedDeletedMapElements.addAll(arrayList);
        }
        this.NotifySelectionChanged();
    }

    @Override
    public void SelectNoneElements() {
        super.SelectNoneElements();
        this.deletedMapElements.addAll(this.selectedDeletedMapElements);
        this.selectedDeletedMapElements.clear();
        this.NotifySelectionChanged();
    }

    public void setRoadNetworkEdgesXML(String string) {
        this.roadNetworkEdgesXML = string;
    }

    public void setRoadNetworkNodesXML(String string) {
        this.roadNetworkNodesXML = string;
    }

    public void setShowDeleted(boolean bl) {
        this.showDeleted = bl;
        this.ReCalculateBounds();
        if (!bl) {
            this.deletedMapElements.addAll(this.selectedDeletedMapElements);
            this.selectedDeletedMapElements.clear();
        }
        this.NotifyCollectionModified();
        this.NotifySelectionChanged();
    }

    public String toString() {
        return "Road Network";
    }

    public Edge findEdge(String string) {
        for (Edge edge : this.getEdges()) {
            if (!edge.getId().equals(string)) continue;
            return edge;
        }
        return null;
    }

    public Junction findJunction(String string) {
        for (Junction junction : this.getJunctions()) {
            if (!junction.getId().equals(string)) continue;
            return junction;
        }
        return null;
    }

    public void UndeleteSelectedMapElements() {
        ArrayList<Junction> arrayList = new ArrayList<Junction>();
        for (RoadNetworkElement roadNetworkElement : this.selectedDeletedMapElements) {
            if (!(roadNetworkElement instanceof Edge)) continue;
            Edge edge = (Edge)roadNetworkElement;
            for (RoadNetworkElement roadNetworkElement2 : this.deletedMapElements) {
                if (!(roadNetworkElement2 instanceof Junction)) continue;
                Junction junction = (Junction)roadNetworkElement2;
                if (!edge.getFrom().equals(junction.getId()) && !edge.getTo().equals(junction.getId())) continue;
                arrayList.add(junction);
            }
        }
        for (Junction junction : arrayList) {
            this.selectedElements.add(junction);
            this.deletedMapElements.remove(junction);
        }
        this.selectedElements.addAll(this.selectedDeletedMapElements);
        this.selectedDeletedMapElements.clear();
        this.ReCalculateBounds();
        this.NotifyCollectionModified();
        this.NotifySelectionChanged();
    }

    private void ReCalculateBounds() {
        List<RoadNetworkElement> list = this.getElements();
        this.bounds = list.get(0).getBounds();
        for (RoadNetworkElement roadNetworkElement : list) {
            this.bounds.add(roadNetworkElement.getBounds());
        }
        double d = Math.max(this.bounds.width, this.bounds.height);
        double d2 = d * 0.1;
        this.bounds.x -= d * 0.05;
        this.bounds.y -= d * 0.05;
        this.bounds.width += d2;
        this.bounds.height += d2;
    }
}

