/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.Pair;
import classes.TypeSelection;
import enums.TrafficDefinitionLayerType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import roadnetwork.RoadNetwork;
import roadnetwork.RoadNetworkParser;
import simulation.JobType;
import simulation.Simulation;
import simulation.VehicleType;
import tdl.XMLHelpers;
import trafficdefinition.ActivityBasedTrafficDefinitionLayer;
import trafficdefinition.RandomTrafficDefinitionLayer;
import trafficdefinition.TrafficDefinitionLayer;
import trafficdefinition.UserDefinedTrafficDefinitionLayer;

public class Project {
    private static transient Project currentlyLoadedProject = null;
    private JobType defaultJobType = null;
    private VehicleType defaultVehicleType = null;
    private String fileName = null;
    private List<JobType> jobTypes = null;
    private RoadNetwork roadNetwork = null;
    private List<TrafficDefinitionLayer> trafficLayers = null;
    private List<VehicleType> vehicleTypes = null;
    private TypeSelection<VehicleType> activityBasedTrafficVehicleSelection;
    private Simulation simulation = new Simulation();

    public static Project getCurrentlyLoadedProject() {
        return currentlyLoadedProject;
    }

    public Project(String string) throws Exception {
        this.fileName = string;
        FileInputStream fileInputStream = new FileInputStream(this.fileName);
        ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
        this.roadNetwork = (RoadNetwork)objectInputStream.readObject();
        this.trafficLayers = (ArrayList)objectInputStream.readObject();
        this.simulation = (Simulation)objectInputStream.readObject();
        this.jobTypes = (ArrayList)objectInputStream.readObject();
        this.vehicleTypes = (ArrayList)objectInputStream.readObject();
        this.defaultJobType = (JobType)objectInputStream.readObject();
        this.defaultVehicleType = (VehicleType)objectInputStream.readObject();
        this.activityBasedTrafficVehicleSelection = (TypeSelection)objectInputStream.readObject();
        objectInputStream.close();
        currentlyLoadedProject = this;
    }

    public Project(String string, File file) throws Exception {
        currentlyLoadedProject = this;
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = documentBuilder.parse(file);
        this.roadNetwork = new RoadNetworkParser().ParseXMLNetFile(document);
        this.trafficLayers = new ArrayList<TrafficDefinitionLayer>();
        this.jobTypes = new ArrayList<JobType>();
        this.defaultJobType = JobType.CreateDefaultType();
        this.jobTypes.add(this.defaultJobType);
        this.vehicleTypes = new ArrayList<VehicleType>();
        this.defaultVehicleType = VehicleType.CreateDefaultType();
        this.vehicleTypes.add(this.defaultVehicleType);
        this.activityBasedTrafficVehicleSelection = new TypeSelection();
        this.activityBasedTrafficVehicleSelection.add(new Pair<VehicleType, Float>(this.defaultVehicleType, Float.valueOf(1.0f)));
        this.createNewLayer(TrafficDefinitionLayerType.UserDefined);
        this.fileName = string;
        FileOutputStream fileOutputStream = new FileOutputStream(this.fileName);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
        File file2 = new File(file.getAbsolutePath().replaceFirst(".net.", ".edg."));
        File file3 = new File(file.getAbsolutePath().replaceFirst(".net.", ".nod."));
        FileInputStream fileInputStream = new FileInputStream(file2);
        FileInputStream fileInputStream2 = new FileInputStream(file3);
        byte[] byArray = new byte[(int)file2.length()];
        byte[] byArray2 = new byte[(int)file3.length()];
        fileInputStream.read(byArray);
        fileInputStream2.read(byArray2);
        this.roadNetwork.setRoadNetworkEdgesXML(new String(byArray));
        this.roadNetwork.setRoadNetworkNodesXML(new String(byArray2));
        objectOutputStream.writeObject(this.roadNetwork);
        objectOutputStream.writeObject(this.trafficLayers);
        objectOutputStream.writeObject(this.simulation);
        objectOutputStream.writeObject(this.jobTypes);
        objectOutputStream.writeObject(this.vehicleTypes);
        objectOutputStream.writeObject(this.defaultJobType);
        objectOutputStream.writeObject(this.defaultVehicleType);
        objectOutputStream.writeObject(this.activityBasedTrafficVehicleSelection);
        objectOutputStream.close();
    }

    public void Close() {
        currentlyLoadedProject = null;
    }

    public TrafficDefinitionLayer createDuplicateLayer(TrafficDefinitionLayer trafficDefinitionLayer) {
        TrafficDefinitionLayer trafficDefinitionLayer2 = trafficDefinitionLayer.duplicate();
        this.trafficLayers.add(trafficDefinitionLayer2);
        return trafficDefinitionLayer2;
    }

    public TrafficDefinitionLayer createNewLayer(TrafficDefinitionLayerType trafficDefinitionLayerType) {
        TrafficDefinitionLayer trafficDefinitionLayer = null;
        switch (trafficDefinitionLayerType) {
            case UserDefined: {
                trafficDefinitionLayer = new UserDefinedTrafficDefinitionLayer();
                break;
            }
            case ActivityBased: {
                trafficDefinitionLayer = new ActivityBasedTrafficDefinitionLayer();
                break;
            }
            case Random: {
                trafficDefinitionLayer = new RandomTrafficDefinitionLayer();
            }
        }
        this.trafficLayers.add(trafficDefinitionLayer);
        return trafficDefinitionLayer;
    }

    public void DeleteLayer(TrafficDefinitionLayer trafficDefinitionLayer) {
        this.trafficLayers.remove(trafficDefinitionLayer);
    }

    public JobType getDefaultJobType() {
        return this.defaultJobType;
    }

    public VehicleType getDefaultVehicleType() {
        return this.defaultVehicleType;
    }

    public String getFileName() {
        return this.fileName;
    }

    public List<JobType> getJobTypes() {
        return this.jobTypes;
    }

    public TrafficDefinitionLayer getLayer(int n) {
        return this.trafficLayers.get(n);
    }

    public RoadNetwork getRoadNetwork() {
        return this.roadNetwork;
    }

    public List<TrafficDefinitionLayer> getTrafficLayers() {
        return this.trafficLayers;
    }

    public List<VehicleType> getVehicleTypes() {
        return this.vehicleTypes;
    }

    public void saveTDL(String string) throws Exception {
        FileWriter fileWriter = new FileWriter(string);
        PrintWriter printWriter = new PrintWriter(fileWriter);
        printWriter.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        printWriter.println("<trafficModel name =\"" + this.simulation.getName() + "\" startingTime =\"" + String.valueOf(this.simulation.getBeginTime()) + "\" endingTime =\"" + String.valueOf(this.simulation.getEndTime()) + "\" xmlns=\"http://tempuri.org/TDL.xsd\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" >");
        printWriter.println("<jobTypes>");
        for (JobType serializable : this.jobTypes) {
            printWriter.println("<job name=\"" + serializable.getName() + "\" startingTime=\"" + String.valueOf(serializable.getStartingTime()) + "\" endingTime=\"" + String.valueOf(serializable.getEndingTime()) + "\"/>");
        }
        printWriter.println("</jobTypes>");
        printWriter.println("<vehicleTypes>");
        for (VehicleType vehicleType : this.vehicleTypes) {
            printWriter.println("<vehicle name=\"" + vehicleType.getName() + "\" acceleration=\"" + String.valueOf(vehicleType.getAcceleration()) + "\" deceleration=\"" + String.valueOf(vehicleType.getDeceleration()) + "\" length=\"" + String.valueOf(vehicleType.getLength()) + "\" maximumSpeed=\"" + String.valueOf(vehicleType.getMaximumSpeed()) + "\" driverImperfection=\"" + String.valueOf(vehicleType.getDriverImperfection()) + "\" />");
        }
        printWriter.println("</vehicleTypes>");
        printWriter.print(XMLHelpers.vehicleSelectionToXML("activityBasedTrafficVehicleSelection", this.activityBasedTrafficVehicleSelection));
        printWriter.println("<trafficLayers>");
        for (TrafficDefinitionLayer trafficDefinitionLayer : this.trafficLayers) {
            printWriter.print(trafficDefinitionLayer.toXML());
        }
        printWriter.println("</trafficLayers>");
        printWriter.println("</trafficModel>");
        printWriter.close();
        fileWriter.close();
    }

    public void Save() throws Exception {
        FileOutputStream fileOutputStream = new FileOutputStream(this.fileName, false);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
        objectOutputStream.writeObject(this.roadNetwork);
        objectOutputStream.writeObject(this.trafficLayers);
        objectOutputStream.writeObject(this.simulation);
        objectOutputStream.writeObject(this.jobTypes);
        objectOutputStream.writeObject(this.vehicleTypes);
        objectOutputStream.writeObject(this.defaultJobType);
        objectOutputStream.writeObject(this.defaultVehicleType);
        objectOutputStream.writeObject(this.activityBasedTrafficVehicleSelection);
        objectOutputStream.close();
    }

    public void SaveAs(String string) throws Exception {
        this.fileName = string;
        this.Save();
    }

    public void setJobTypes(List<JobType> list) {
        this.jobTypes = list;
    }

    public void setVehicleTypes(List<VehicleType> list) {
        this.vehicleTypes = list;
    }

    public Simulation getSimulation() {
        return this.simulation;
    }

    public TypeSelection<VehicleType> getActivityBasedTrafficVehicleSelection() {
        return this.activityBasedTrafficVehicleSelection;
    }

    public void setActivityBasedTrafficVehicleSelection(TypeSelection<VehicleType> typeSelection) {
        this.activityBasedTrafficVehicleSelection = typeSelection;
    }
}

