#!/usr/bin/tclsh
#
# Documentation for this script. This may be output to
# if the script is invoked incorrectly.
#
set ::USAGE_MESSAGE {
This Tcl script is used to test the various compile time options 
available for building SQLite, especially options taht omit
features (the SQLITE_OMIT_xxx options). It should be invoked as follows:

    ./configure CFLAGS=-O0
    tclsh test/omittest.tcl

}

# List of all options to be tested.
#
set CompileOptionsToTest {
  SQLITE_OMIT_ALTERTABLE
  SQLITE_OMIT_ANALYZE
  SQLITE_OMIT_ATTACH
  SQLITE_OMIT_AUTHORIZATION
  SQLITE_OMIT_AUTOINCREMENT
  SQLITE_OMIT_AUTOINIT
  SQLITE_OMIT_AUTOMATIC_INDEX
  SQLITE_OMIT_AUTORESET
  SQLITE_OMIT_AUTOVACUUM
  SQLITE_OMIT_AUXILIARY_SAFETY_CHECKS
  SQLITE_OMIT_BETWEEN_OPTIMIZATION
  SQLITE_OMIT_BLOB_LITERAL
  SQLITE_OMIT_CASE_SENSITIVE_LIKE_PRAGMA
  SQLITE_OMIT_CAST
  SQLITE_OMIT_CHECK
  SQLITE_OMIT_COMPILEOPTION_DIAGS
  SQLITE_OMIT_COMPLETE
  SQLITE_OMIT_COMPOUND_SELECT
  SQLITE_OMIT_CONFLICT_CLAUSE
  SQLITE_OMIT_CTE
  SQLITE_OMIT_DATETIME_FUNCS
  SQLITE_OMIT_DECLTYPE
  SQLITE_OMIT_DEPRECATED
  SQLITE_OMIT_DESERIALIZE
  SQLITE_OMIT_DISKIO
  SQLITE_OMIT_EXPLAIN
  SQLITE_OMIT_FLAG_PRAGMAS
  SQLITE_OMIT_FLOATING_POINT
  SQLITE_OMIT_FOREIGN_KEY
  SQLITE_OMIT_GENERATED_COLUMNS
  SQLITE_OMIT_GET_TABLE
  SQLITE_OMIT_HEX_INTEGER
  SQLITE_OMIT_INCRBLOB
  SQLITE_OMIT_INTEGRITY_CHECK
  SQLITE_OMIT_INTROSPECTION_PRAGMAS
  SQLITE_OMIT_JSON
  SQLITE_OMIT_LIKE_OPTIMIZATION
  SQLITE_OMIT_LOAD_EXTENSION
  SQLITE_OMIT_LOCALTIME
  SQLITE_OMIT_LOOKASIDE
  SQLITE_OMIT_MEMORYDB
  SQLITE_OMIT_OR_OPTIMIZATION
  SQLITE_OMIT_PAGER_PRAGMAS 
  SQLITE_OMIT_PARSER_TRACE
  SQLITE_OMIT_POPEN
  SQLITE_OMIT_PRAGMA
  SQLITE_OMIT_PROGRESS_CALLBACK
  SQLITE_OMIT_QUICKBALANCE
  SQLITE_OMIT_RANDOMNESS
  SQLITE_OMIT_REINDEX
  SQLITE_OMIT_SCHEMA_PRAGMAS
  SQLITE_OMIT_SCHEMA_VERSION_PRAGMAS
  SQLITE_OMIT_SHARED_CACHE
  SQLITE_OMIT_SHUTDOWN_DIRECTORIES
  SQLITE_OMIT_SUBQUERY
  SQLITE_OMIT_TCL_VARIABLE
  SQLITE_OMIT_TEMPDB
  SQLITE_OMIT_TEST_CONTROL
  SQLITE_OMIT_TRACE
  SQLITE_OMIT_TRIGGER
  SQLITE_OMIT_TRUNCATE_OPTIMIZATION
  SQLITE_OMIT_TWOSIZE_LOOKASIDE
  SQLITE_OMIT_UPSERT
  SQLITE_OMIT_UTF
  SQLITE_OMIT_VACUUM
  SQLITE_OMIT_VIEW
  SQLITE_OMIT_VIRTUALTABLE
  SQLITE_OMIT_WAL
  SQLITE_OMIT_WINDOWFUNC
  SQLITE_OMIT_WSD
  SQLITE_OMIT_XFER_OPT
  SQLITE_ALLOW_ROWID_IN_VIEW
  SQLITE_DISABLE_DIRSYNC
  SQLITE_DISABLE_FTS
  SQLITE_DISABLE_INTRINSIC
  SQLITE_DISABLE_LFS
  SQLITE_DISABLE_PAGECACHE_OVERFLOW_STATS
  SQLITE_DISABLE_SKIPAHEAD_DISTINCT
  SQLITE_ENABLE_API_ARMOR
  SQLITE_ENABLE_ATOMIC_WRITE
  SQLITE_ENABLE_BATCH_ATOMIC_WRITE
  SQLITE_ENABLE_BYTECODE_VTAB
  SQLITE_ENABLE_CEROD
  SQLITE_ENABLE_COLUMN_METADATA
  SQLITE_ENABLE_COLUMN_USED_MASK
  SQLITE_ENABLE_COMMENTS
  SQLITE_ENABLE_CORRUPT_PGNO
  SQLITE_ENABLE_COSTMULT
  SQLITE_ENABLE_CURSOR_HINTS
  SQLITE_ENABLE_DBPAGE_VTAB
  SQLITE_ENABLE_DBSTAT_VTAB
  SQLITE_ENABLE_EXPENSIVE_ASSERT
  SQLITE_ENABLE_EXPLAIN_COMMENTS
  SQLITE_ENABLE_FTS
  SQLITE_ENABLE_GEOPOLY
  SQLITE_ENABLE_HIDDEN_COLUMNS
  SQLITE_ENABLE_ICU
  SQLITE_ENABLE_ICU_COLLATIONS
  SQLITE_ENABLE_INTERNAL_FUNCTIONS
  SQLITE_ENABLE_IOTRACE
  SQLITE_ENABLE_LOAD_EXTENSION
  SQLITE_ENABLE_LOCKING_STYLE
  SQLITE_ENABLE_MATH_FUNCTIONS
  SQLITE_ENABLE_MEMORY_MANAGEMENT
  SQLITE_ENABLE_MEMSYS
  SQLITE_ENABLE_MODULE_COMMENTS
  SQLITE_ENABLE_MULTIPLEX
  SQLITE_ENABLE_MULTITHREADED_CHECKS
  SQLITE_ENABLE_NORMALIZE
  SQLITE_ENABLE_NULL_TRIM
  SQLITE_ENABLE_OFFSET_SQL_FUNC
  SQLITE_ENABLE_OVERSIZE_CELL_CHECK
  SQLITE_ENABLE_PREUPDATE_HOOK
  SQLITE_ENABLE_QPSG
  SQLITE_ENABLE_RBU
  SQLITE_ENABLE_RTREE
  SQLITE_ENABLE_SELECTTRACE
  SQLITE_ENABLE_SESSION
  SQLITE_ENABLE_SETLK_TIMEOUT
  SQLITE_ENABLE_SNAPSHOT
  SQLITE_ENABLE_SORTER_MMAP
  SQLITE_ENABLE_SORTER_REFERENCE
  SQLITE_ENABLE_SORTER_REFERENCES
  SQLITE_ENABLE_SQLLOG
  SQLITE_ENABLE_STAT
  SQLITE_ENABLE_STMT_SCANSTATUS
  SQLITE_ENABLE_STMTVTAB
  SQLITE_ENABLE_TREETRACE
  SQLITE_ENABLE_UNKNOWN_FUNCTION
  SQLITE_ENABLE_UNKNOWN_SQL_FUNCTION
  SQLITE_ENABLE_UNLOCK_NOTIFY
  SQLITE_ENABLE_UPDATE_DELETE_LIMIT
  SQLITE_ENABLE_URI_00_ERROR
  SQLITE_ENABLE_VFSTRACE
  SQLITE_ENABLE_WHERETRACE
  SQLITE_ENABLE_ZIPVFS
}

# Parse command-line options.
#
for {set i 0} {$i<[llength $argv]} {incr i} {
  set arg [lindex $argv $i]
  switch -- $arg {
    -start -
    --start {
      incr i
      set startat [lindex $argv $i]
    }
  }
}

# Additional options required for some settings.
#
set More(SQLITE_OMIT_DISKIO) {-DSQLITE_OMIT_WAL}

# Compile-time options for Mac only
#
set MacOnly(SQLITE_ENABLE_LOCKING_STYLE) 1

# Compile-time options that might fail, depending on what libraries
# are installed.  Failures on these tests issue a warning, but testing
# continues.
#
set FailIsOk(SQLITE_ENABLE_ICU) 1
set FailIsOk(SQLITE_ENABLE_ICU_COLLATIONS) 1

file mkdir omittest
foreach sym $CompileOptionsToTest {
  if {[info exists startat]} {
    if {$startat==$sym} {
      unset startat
    } else {
      continue
    }
  }
  if {[info exists MacOnly($sym)] && $tcl_platform(os)!="Darwin"} {
    continue
  }
  set logfile "omittest/$sym.log"
  if {[info exists More($sym)]} {
    append opts "OPT_FEATURE_FLAGS=-D$sym $More($sym)"
  } else {
    set opts OPT_FEATURE_FLAGS=-D$sym
  }
  puts            "make tidy sqlite3.lo $opts"
  if {[catch {exec make tidy sqlite3.lo $opts >& $logfile}]} {
    puts "BUILD FAILED: see $logfile for details"
    if {[info exists FailIsOk($sym)]} {
      set Failure($sym) 1
    } else {
      puts "Note:  After fixes, continue the test using:\n"
      puts "   [info nameofexe] $argv0 --start $sym\n"
      exit 1
    }
  }
}
if {[llength [array names Failure]]>0} {
  puts "BUILD FAILED on the following:"
  foreach sym [array names Failure] {
     puts "  *  $sym"
  }
}
