/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.valuesource;

import java.lang.annotation.ElementType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.config.java.valuesource.ValueResolutionException;
import org.springframework.config.java.valuesource.ValueResolver;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeValueResolver
implements ValueResolver {
    private final LinkedList<ValueResolver> resolvers = new LinkedList();

    public CompositeValueResolver(Map<String, ValueResolver> resolvers) {
        ArrayList keys = new ArrayList(resolvers.keySet());
        Collections.sort(keys);
        Collections.reverse(keys);
        for (String key : keys) {
            this.add(resolvers.get(key));
        }
    }

    public void add(ValueResolver resolver) {
        this.resolvers.add(resolver);
    }

    @Override
    public <T> T resolve(String name, Class<?> requiredType) {
        for (ValueResolver resolver : this.resolvers) {
            try {
                return resolver.resolve(name, requiredType);
            }
            catch (ValueResolutionException valueResolutionException) {}
        }
        throw new ValueResolutionException(name, String.format("Cannot resolve property for name '%s' against resolvers [%s]", name, this.listResolvers()));
    }

    private String listResolvers() {
        ArrayList<String> resolverNames = new ArrayList<String>();
        for (ValueResolver resolver : this.resolvers) {
            resolverNames.add(resolver.getClass().getSimpleName());
        }
        return StringUtils.collectionToCommaDelimitedString(resolverNames);
    }

    public static CompositeValueResolver forMember(DefaultListableBeanFactory beanFactory, Field field) {
        return CompositeValueResolver.forMember(beanFactory, ElementType.FIELD, field.getName(), field.getDeclaringClass());
    }

    public static CompositeValueResolver forMember(DefaultListableBeanFactory beanFactory, Method method) {
        return CompositeValueResolver.forMember(beanFactory, ElementType.METHOD, method.getName(), method.getDeclaringClass());
    }

    private static CompositeValueResolver forMember(DefaultListableBeanFactory beanFactory, ElementType memberType, String memberName, Class<?> declaringClass) {
        Map resolvers = beanFactory.getBeansOfType(ValueResolver.class);
        if (resolvers.size() == 0) {
            String className = declaringClass.getSimpleName();
            throw new IllegalStateException(String.format("No ValueSource bean could be found in beanFactory while trying to resolve @ExternalValue %s %s.%s. Perhaps no @PropertiesValueSource annotation was provided on %s?", memberType.toString().toLowerCase(), className, memberName, className));
        }
        return new CompositeValueResolver(resolvers);
    }
}

