/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util.url;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ivy.util.FileUtil;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.url.URLHandlerRegistry;

public class ApacheURLLister {
    private static final Pattern PATTERN = Pattern.compile("<a[^>]*href=\"([^\"]*)\"[^>]*>(?:<[^>]+>)*?([^<>]+?)(?:<[^>]+>)*?</a>", 2);

    public List listAll(URL url) throws IOException {
        return this.retrieveListing(url, true, true);
    }

    public List listDirectories(URL url) throws IOException {
        return this.retrieveListing(url, false, true);
    }

    public List listFiles(URL url) throws IOException {
        return this.retrieveListing(url, true, false);
    }

    public List retrieveListing(URL url, boolean includeFiles, boolean includeDirectories) throws IOException {
        ArrayList<URL> urlList = new ArrayList<URL>();
        if (!url.getPath().endsWith("/") && !url.getPath().endsWith(".html")) {
            url = new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getPath() + "/");
        }
        BufferedReader r = new BufferedReader(new InputStreamReader(URLHandlerRegistry.getDefault().openStream(url)));
        String htmlText = FileUtil.readEntirely(r);
        Matcher matcher = PATTERN.matcher(htmlText);
        while (matcher.find()) {
            boolean directory;
            int dotIndex;
            String href = matcher.group(1);
            String text = matcher.group(2);
            if (href == null || text == null) continue;
            text = text.trim();
            if (href.startsWith("/")) {
                int slashIndex = href.substring(0, href.length() - 1).lastIndexOf(47);
                href = href.substring(slashIndex + 1);
            }
            if (href.startsWith("./")) {
                href = href.substring("./".length());
            }
            if ((dotIndex = text.indexOf(46)) != -1 && !href.startsWith(text.substring(0, dotIndex)) || dotIndex == -1 && !href.toLowerCase(Locale.US).equals(text.toLowerCase(Locale.US)) || (!(directory = href.endsWith("/")) || !includeDirectories) && (directory || !includeFiles)) continue;
            URL child = new URL(url, href);
            urlList.add(child);
            Message.debug("ApacheURLLister found URL=[" + child + "].");
        }
        return urlList;
    }
}

