/***************************************************************************
 *   Copyright (C) 2008 by Devin Smittle   *
 *   pandagoat@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef __WARCRAFT_INFO_H_
#define __WARCRAFT_INFO_H_ 1

#include <sys/types.h>
#include <glib.h>
#include "tcpip_packet.h"

#define BNET_BYTE 0xFF
#define GAME_BYTE 0xF7


/* a generic warcraft III packet*/
typedef struct{
#define WPH_SIZE 4
  u_char type;    /* either FF(BNET) or F7(GAME) */
  u_char sig;     /* the signature of the type, like a player joined packet */
  u_short size; 
#define WP_SIZE(wp) ((wp)->header->size)
} warcraft_packet_header;



struct warcraft_packet_s{
#define WP_DATA_SIZE(wp) (WP_SIZE(wp) - WPH_SIZE)
  warcraft_packet_header* header;
  u_char* data; /* the remaining part of the packet, containing the data */
};

typedef GSequence warcraft_packets;
warcraft_packets* new_warcraft_packets();

typedef struct warcraft_packet_s warcraft_packet;


int construct_warcraft_packets(const tcpip_packet* packet, 
			      warcraft_packets* out);

void free_packets(warcraft_packets* wps);

void wp_data_destroy_func(gpointer data);

int check_if_known(const tcpip_packet* packet);


int warcraft_packet_size(warcraft_packets* wp);


typedef void (*warcraft_packet_loop_callback)(warcraft_packet* wp, tcpip_packet* tcpipp,  void* args);
void warcraft_packet_loop_through(warcraft_packets* wp, tcpip_packet* tcpipp, warcraft_packet_loop_callback handler, void* args);

#endif /* __WARCRAFT_INFO_H_ */

