/***************************************************************************
 *   Copyright (C) 2008 by Devin Smittle   *
 *   pandagoat@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "warcraft_info.h"
#include "packet_join_request.h"
#include "packet_player_joined.h"
#include "packet_slot_info.h"
#include "packet_player_left.h"
#include "packet_create_game.h"
#include "packet_game_quit.h"
#include "packet_host_echo.h"
#include "packet_accpet_join_request.h"
#include "packet_game_loading.h"
#include "packet_bnet_message.h"
#include "packet_message.h"
#include <stdlib.h>
#include <string.h>
#include <assert.h>

warcraft_packets* new_warcraft_packets()
{
  return  g_sequence_new(NULL);
}

int construct_warcraft_packets(const tcpip_packet* packet, 
			       warcraft_packets* out)
{

  warcraft_packet* wp = g_slice_new(warcraft_packet);
  wp->header = (warcraft_packet_header*)(packet->payload);
  wp->data = (u_char*)(packet->payload + WPH_SIZE);

  /* Check if the packet constructed properly.  A good way is to check if the size is logical. */
  if(WP_SIZE(wp) > packet->payload_size || WP_SIZE(wp) < 4)
    return -1;

  g_sequence_prepend(out, wp);

  int remaining = packet->payload_size - WP_SIZE(wp);
  int offset = WP_SIZE(wp); /* next packet is payload + offset */


  while(remaining > 0)
    {
      warcraft_packet* wpn = g_slice_new(warcraft_packet);
      wpn->header = (warcraft_packet_header*)(packet->payload + offset);
      wpn->data = (u_char*)(packet->payload + WPH_SIZE + offset);
      g_sequence_prepend(out, wpn);
      remaining -= WP_SIZE(wpn);
      offset += WP_SIZE(wpn);

      /* printf("%i  %X   %X\n", remaining, wp->header->type, wp->header->sig); */
      if(remaining < 0 || WP_SIZE(wpn) < 4) /* NOT GOOD O_O */
	break;

    }
  return 1;
}

void free_packets(warcraft_packets* wps)
{
  g_sequence_free(wps);
}

void wp_data_destroy_func(gpointer data)
{
  free(data);
}

int check_if_known(const tcpip_packet* packet)
{
  assert(packet != NULL); 	/* this should not be possible, but a 
				   person is experiencing a problem that this would cause  */
  /* id sig size ?, minimum */
  if(/* packet->payload_size >= 4 */1==1)
    {
      u_char id;
      memmove(&id, packet->rp.payload, 1);
      u_char sig;
      memmove(&sig, packet->rp.payload+1, 1);
   
      if(id == 0xFF)
	{
	  if(sig == SIG_CREATE_GAME)
	    return 1;
	  else if(sig == SIG_GAME_QUIT)
	    return 1;
	  else if(sig == SIG_MESSAGE_BNET)
	    return 1;
	  else if(sig == SIG_MESSAGE_FROM_BNET)
	    return 1;
	  else return -1;
	}
      else if(id == 0xF7)
	{
	  if(sig == SIG_PLAYER_JOIN_REQUEST)
	    return 1;
	  else if(sig == SIG_PLAYER_JOINED)
	    return 1;
	  else if(sig == SIG_SLOT_INFO)
	    return 1;
	  else if(sig == SIG_PLAYER_LEFT)
	    return 1;
	  else if(sig == SIG_HOST_ECHO_REQUEST)
	    return 1;
	  else if(sig == SIG_HOST_ECHO_RESPONSE)
	    return 1;
	  else if(sig == SIG_ACCEPT_JOIN_REQUEST)
	    return 1;
	  else if(sig == SIG_PLAYER_LEAVE_ACCEPTED)
	    return 1;
	  else if(sig == SIG_SLOT_ON_JOIN)
	    return 1;
	  else if(sig == SIG_MESSAGE_HOST)
	    return 1;
	  else if(sig == SIG_GAME_LOADING)
	    return 1;
	  else if(sig == SIG_GAME_LOADED)
	    return 1;
	  else
	    return -1;
	}
      else
	return -1;
    }
  return -1;
}


int warcraft_packet_size(warcraft_packets* wp)
{
  return g_sequence_get_length(wp);
}



void warcraft_packet_loop_through(warcraft_packets* wp, tcpip_packet* tcpipp, warcraft_packet_loop_callback handler, void* args)
{
  GSequenceIter* curr = g_sequence_get_begin_iter((warcraft_packets*)wp);
  while(!g_sequence_iter_is_end(curr))
    {
      handler(g_sequence_get(curr),  tcpipp,  args);      

      curr =  g_sequence_iter_next(curr);
    }
}
