/***************************************************************************
 *   Copyright (C) 2008 by Devin Smittle   *
 *   pandagoat@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "utilities.h"
#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <math.h>
#include <glib.h>

char* get_page(char* url)
{
    if(strstr(url, "http://"))
        url = url + 7;

    char hostname[100];
    strncpy(hostname, url, strstr(url, "/") - url);
    hostname[strstr(url, "/") - url] = '\0';


    int sockfd = socket(PF_INET, SOCK_STREAM, 0);

    struct hostent* h = gethostbyname(hostname);

    struct sockaddr_in dest_addr;
    dest_addr.sin_family = AF_INET;
    dest_addr.sin_port = htons(80);
    dest_addr.sin_addr.s_addr = inet_addr(inet_ntoa(*((struct in_addr *)h->h_addr)));
    memset(dest_addr.sin_zero, '\0', sizeof dest_addr.sin_zero);

    connect(sockfd, (struct sockaddr *)&dest_addr, sizeof dest_addr);

    char get_request[500];
    sprintf(get_request, "GET %s HTTP/1.2\r\nHost: %s\r\n\r\n", strstr(url, "/"), hostname);

    send(sockfd, get_request, strlen(get_request) + 1, 0);

    char* response = (char*)malloc(1);
    unsigned short resp_size = 1;
    *response = '\0';
    int size = -1;
    while(size != 0)
    {
        char buffer[100];
        size = recv(sockfd, buffer, 100, 0);
        response = (char*)realloc(response, resp_size + size);
        memmove(response + resp_size - 1, buffer, size);
        resp_size = resp_size + size;
    }

    return response;
}

char* get_between_tags(char* input, char* open_tag)
{
  char output[500];
  memset(output, '\0', 500);
  memmove(output, strstr(input, open_tag) + strlen(open_tag), strstr(strstr(input, open_tag), "</") - (strstr(input, open_tag) + strlen(open_tag)));
  return g_strdup(output);
}

char* get_device()
{
  char errbuf[PCAP_ERRBUF_SIZE];
  char* dev = pcap_lookupdev(errbuf);
  assert(dev != NULL);
  return dev;
}

char* get_devices()
{
  char* errbuf;
  pcap_if_t* devices;
  pcap_findalldevs(&devices, errbuf);
  return "";
}


pcap_t* open_any_device(pcap_t* handle, char* dev)
{
  char* errbuf;
  bpf_u_int32 net;
  bpf_u_int32 mask;
  
  
  int e = pcap_lookupnet(dev, &net, &mask, errbuf);
  assert(e != -1);
  
  handle = pcap_open_live(dev, 2048, 0, 1000, errbuf);
  assert(handle != NULL);
  
  
  /* setup filter */
  struct bpf_program program;
  e = pcap_compile(handle, &program, "tcp portrange 6112-6119", 0, mask); 
  assert(e != -1); 
  e = pcap_setfilter(handle, &program);
  assert(e != -1);
  
  return handle;
}


void lowercase_string(char* s)
{
  int i = 0;
  for(i = 0; s[i]; i++)
    {
      s[i] = tolower(s[i]);
    }
}
