/***************************************************************************
 *   Copyright (C) 2008 by Devin Smittle   *
 *   pandagoat@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "tcpip_packet.h"
#include <pcap.h>
#include <assert.h>


int construct_packet(const u_char* packet, tcpip_packet* output)
{
  output->eh = (eth_header*)(packet); 
  
  output->ih = (ip_header*)(packet + SIZE_OF_ETHERNET_HEADER);
  
  output->ip_size = IP_HL(output->ih)*4;
  if(output->ip_size < 20)
    return -1;
  
  output->th = (tcp_header*)(packet + SIZE_OF_ETHERNET_HEADER + output->ip_size);
  
  output->tcp_size = TH_OFF(output->th)*4;
  if(output->tcp_size < 20)
    return -1;
  
  output->payload = (u_char*)(packet
			      + SIZE_OF_ETHERNET_HEADER 
			      + output->ip_size
			      + output->tcp_size);
  

  output->payload_size = ntohs(output->ih->length_of_packet) - output->ip_size - output->tcp_size;

  output->original_packet = (u_char*)packet;

  output->rp.eth_header = (u_char*)packet;
  output->rp.ip_header = (u_char*)(packet + ETHH_SIZE);
  output->rp.tcp_header = (u_char*)(packet + ETHH_SIZE + IPH_HEADER_LENGTH(output->rp.ip_header));
  output->rp.payload = (u_char*)(packet + ETHH_SIZE + IPH_HEADER_LENGTH(output->rp.ip_header) + TCPH_HEADER_LENGTH(output->rp.tcp_header));

  return 0;
}

void print_packet(char* file_name, const u_char* packet, int len)
{
  FILE* file = fopen(file_name, "a");
  
  int i = 0;
  for(i = 0; i < len; i++)
    {
      char b[5];
      if((i+1)%10 == 0)
	sprintf(b, "%X\n", packet[i]);
      else
	sprintf(b, "%X ", packet[i]);
      fputs(b, file);
    }
  
  fputs("\n<--------------------->\n", file);
  fflush(file);
  
  fclose(file);	
}
