/***************************************************************************
 *   Copyright (C) 2008 by Devin Smittle   *
 *   pandagoat@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef __SLOT_H_
#define __SLOT_H_ 1

#include <sys/types.h>

typedef struct
{
  u_char pid;
  u_char download_status;
  u_char slot_status;
  u_char controller;
  u_char team_number;
  u_char color_number;
  u_char race;
  u_char controller_type;
  u_char handicap;
} slot_data;

struct _slot
{
  struct _slot* next;
  slot_data* data;
  int index;
};
typedef struct _slot slot;

int construct_slot_list(const u_char* data, slot* node, size_t number_of_slots);

typedef void (*slot_loop_callback)(const slot* slots, const void* args);
void slots_loop_through(const slot* slots, slot_loop_callback handler, const void* args);


#endif /* __SLOT_H_ */

