/***************************************************************************
 *   Copyright (C) 2008 by Devin Smittle   *
 *   pandagoat@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "player_list.h"
#include <stdlib.h>
#include <stdio.h>
#include "tcpip_packet.h"
#include <glib.h>
#include <string.h>


player_list* new_player_list()
{
  player_list* pl = g_slice_new(player_list);
  pl->players = NULL; 		/* empty list */
  pl->pending = NULL;
  pl->pings = NULL;
  return pl;
}



/* HOST */
void players_add_pending(player_join_request_packet* pjrp, player_list* pl)
{
  player* p = g_slice_new(player);
  p->pid = -1;
  p->ping = -1;
  p->ext_addr = pjrp->ext_addr;
  p->name = g_strdup(pjrp->player_name);

  pl->pending = g_list_prepend(pl->pending, p);
}

void players_remove_pending(struct sockaddr_in ext_ip, player_list* pl)
{
  /* player* p = players_get_player_pending(ext_ip, pl); */
  /* if(p) */
  /*   { */
  /*     pl->pending =  g_list_remove(pl->pending, p); */
  /*   } */

  GList* curr = g_list_first(pl->pending);

  while(curr)
    {
      player* p = (player*)curr->data;
      if(p->ext_addr.sin_addr.s_addr == ext_ip.sin_addr.s_addr &&
  	 p->ext_addr.sin_port == ext_ip.sin_port)
	pl->pending = g_list_delete_link (pl->pending, curr);
	/* pl->pending =  g_list_remove(pl->pending, p); */
      
      curr = curr->next;
    }
}

player* players_get_player_pending(struct sockaddr_in ext_ip, player_list* pl)
{
  GList* curr = g_list_first(pl->pending);
  
  while(curr)
    {
      player* p = (player*)curr->data;
      if(p->ext_addr.sin_addr.s_addr == ext_ip.sin_addr.s_addr && 
	 p->ext_addr.sin_port == ext_ip.sin_port)
	return p;
      curr = curr->next;
    }

  return NULL;
}

gchar* players_get_name_pending(const struct sockaddr_in* ipinfo, player_list* pl)
{
  GList* curr = g_list_first(pl->pending);

  while(curr)
    {
      player* p = (player*)curr->data;
      if(p->ext_addr.sin_addr.s_addr == ipinfo->sin_addr.s_addr && 
	 p->ext_addr.sin_port == ipinfo->sin_port)
	return p->name;
      curr = curr->next;
    }

  return NULL;
}



/* HOST AND CLIENT */
void players_add(player* p, player_list* pl)
{
  p->name = g_slice_copy(strlen(p->name)+1, p->name);
  pl->players = g_list_prepend(pl->players, p);
}

void players_remove(int pid, player_list* pl)
{
  /* player* p = players_get(pid, pl); */
  /* if(p) */
  /*   { */
  /*     pl->players = g_list_remove(pl->players, p); */
  /*   } */
  GList* curr = g_list_first(pl->players);
  
  while(curr)
    {
      player* p = (player*)curr->data;
      if(p->pid == pid)
  	{
	  pl->players = g_list_delete_link (pl->players, curr);
	  /* pl->players =  g_list_remove_all(pl->players, p) */;
  	}
      curr = curr->next;
    }
}

player* players_get(int pid, player_list* pl)
{
  GList* curr = g_list_first(pl->players);

  while(curr)
    {
      player* p = (player*)curr->data;
      if(p->pid == pid)
	return p;
      curr = curr->next;
    }

  return NULL;
}

player* players_get_addr(struct in_addr ip, u_short port, player_list* pl)
{
  GList* curr = g_list_first(pl->players);

  while(curr)
    {
      player* p = (player*)curr->data;
      if(p->ext_addr.sin_addr.s_addr == ip.s_addr, p->ext_addr.sin_port == port)
	return p;
      curr = curr->next;
    }

  return NULL;
}

player* players_get_color(enum COLOR color, player_list* pl)
{
  GList* curr = g_list_first(pl->players);

  while(curr)
    {
      player* p = (player*)curr->data;
      if(p->color == color)
	return p;
      curr = curr->next;
    }

  return NULL;
}

player* players_get_ts(int pid, player_list* pl)
{
  GList* curr = g_list_first(player_list_shallow_copy(pl)->players);

  while(curr)
    {
      player* p = (player*)curr->data;
      if(p->pid == pid)
	return p;
      curr = curr->next;
    }

  return NULL;
}




void player_loop_thread(void* args)
{
  struct player_loop_thread_args* a = (struct player_loop_thread_args*)args;
  GList* curr = g_list_last(a->pl->players);

  while(curr)
    {
      player* p = (player*)curr->data;
      a->cb(p->pid, p, a->pl);
      curr = g_list_previous(curr);
    }
};
void players_start_loop(players_loop_callback cb, player_list* pl)
{
  /* pthread_t loopthread; */
  /* struct player_loop_thread_args* args = (struct player_loop_thread_args*)malloc(sizeof(struct player_loop_thread_args)); */
  /* args->cb = cb; */
  /* args->pl =  player_list_shallow_copy(pl);; */
  /* pthread_create(&loopthread, NULL,player_loop_thread, args); */
  player_list* copy = player_list_shallow_copy(pl);
  GList* curr = g_list_last(copy->players);

  while(curr)
    {
      player* p = (player*)curr->data;
      cb(p->pid, p, copy);
      curr = g_list_previous(curr);
    }
}


void players_clear_players(player_list* pl)
{
  g_list_free(pl->players);
  pl->players = NULL;
}

void players_clear_pending(player_list* pl)
{
  g_list_free(pl->pending);
  pl->pending = NULL;
}

void players_clear_pings(player_list* pl)
{
  g_list_free(pl->pings);
  pl->pings = NULL;
}



player_ping* players_add_ping(struct in_addr ip, u_short port, player_list* pl)
{
  player_ping* pp = g_slice_new(player_ping);
  pp->ping = -1;
  pp->id = ip.s_addr + port;

  pl->pings = g_list_prepend(pl->pings, pp);
  return pp;
}

void players_remove_ping(struct in_addr ip, u_short port, player_list* pl)
{
  /* player_ping* pp = players_ping_get(ip, port, pl); */
  /* if(pp != NULL) */
  /*   { */
  /*     pl->pings = g_list_remove_all(pl->pings, pp); */
  /*   } */
  u_long id = ip.s_addr + port;

  GList* curr = g_list_first(pl->pings);

  while(curr)
    {
      player_ping* pp = (player_ping*)curr->data;
      if(id == pp->id)
	pl->pings = g_list_delete_link(pl->pings, curr);
      /* pl->pings = g_list_remove_all(pl->pings, pp); */
   
      curr = curr->next;
    }
}


player_ping* players_ping_get(struct in_addr ip, u_short port, player_list* pl)
{
  GList* curr = g_list_first(pl->pings);
  u_long id = ip.s_addr + port;

  while(curr)
    {
      player_ping* p = (player_ping*)curr->data;
      if(p->id == id)
	return p;
      curr = curr->next;
    }

  return NULL;
}


player_list* player_list_shallow_copy(player_list* pl)
{
  player_list* copy = new_player_list();
  copy->players = g_list_copy(pl->players);
  copy->pending = g_list_copy(pl->pending);
  copy->pings = g_list_copy(pl->pings);
  return copy;
}



/* RED, BLUE, TEAL, PURPLE, YELLOW, OJ, GREEN, PINK, GRAY, LIGHTBLUE, DARKGREEN, BROWN */
int massive_color_parser(char* str)
{
  /* red */
  if(strstr(str, "r") - str == 0)
    return RED;

  /* blue */
  else if(strstr(str, "bl") - str == 0)
    return BLUE;

  /* teal */
  else if(strstr(str, "t") - str == 0)
    return TEAL;

  /* teal */
  else if(strstr(str, "pu") - str == 0)
    return PURPLE;

  /* teal */
  else if(strstr(str, "y") - str == 0)
    return YELLOW;

  /* teal */
  else if(strstr(str, "o") - str == 0)
    return ORANGE;

  /* teal */
  else if(strstr(str, "gree") - str == 0)
    return GREEN;

  /* teal */
  else if(strstr(str, "pi") - str == 0)
    return PINK;

  /* teal */
  else if(strstr(str, "gra") - str == 0 || strstr(str, "grey") - str == 0)
    return GRAY;

  /* teal */
  else if(strstr(str, "l") - str == 0)
    return LIGHTBLUE;

  /* teal */
  else if(strstr(str, "d") - str == 0)
    return DARKGREEN;

  /* teal */
  else if(strstr(str, "br") - str == 0)
    return BROWN;
  else 
    return -1;
}
