/***************************************************************************
 *   Copyright (C) 2008 by Devin Smittle   *
 *   pandagoat@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef __PACKET_SLOT_INFO_H_
#define __PACKET_SLOT_INFO_H_ 1

#include <sys/types.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <sys/socket.h>
#include <net/if.h>
#include "warcraft_info.h"
#include "slot.h"

/* TYPE: F7 */
#define SIG_SLOT_INFO 0x09
#define SIG_SLOT_ON_JOIN 0x04

typedef struct
{
#define SIPH_SIZE 3
  u_short slot_info_size;
  u_char slot_count;
}slot_info_packet_header;


typedef struct
{
#define SIPC_SIZE 6
  u_long tick_count;
  u_char unknown1;
  u_char slot_count;
}slot_info_packet_closer;


typedef struct
{
  slot_info_packet_header* header;
  slot* slots;
  slot_info_packet_closer* closer;
}slot_info_packet;



void construct_slot_info_packet(const warcraft_packet* wp, slot_info_packet* sip);
int slot_info_packet_count_open_slots(const slot_info_packet* sip);




#endif /* __PACKET_SLOT_INFO_H_ */

