/***************************************************************************
 *   Copyright (C) 2008 by Devin Smittle   *
 *   pandagoat@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "packet_slot_info.h"
#include <stdlib.h>
#include <string.h>


void construct_slot_info_packet(const warcraft_packet* wp, slot_info_packet* sip)
{
  sip->header = (slot_info_packet_header*)wp->data;
  sip->slots = (slot*)malloc(sizeof(slot));
  construct_slot_list((u_char*)(wp->data + SIPH_SIZE), sip->slots, sip->header->slot_count);
  sip->closer = (slot_info_packet_closer*)(wp->data + (int)sip->header->slot_count*9);
}


int slot_info_packet_count_open_slots(const slot_info_packet* sip)
{
  int count = 0;
  int i;
  slot* curr = sip->slots;
  for(i = 0; i < sip->header->slot_count; i++)
    {
      if(curr->data->slot_status == 0)
	count++;
      if(i != sip->header->slot_count - 1)
	curr = curr->next;
    }
  return count;
}
