/***************************************************************************
 *   Copyright (C) 2008 by Devin Smittle   *
 *   pandagoat@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "packet_message.h"

void construct_generic_message_packet(const warcraft_packet* wp, 
				      generic_message_packet* out)
{
  out->amount_of_information = wp->data[0];
  out->information = (u_char*)(wp->data + 1);
  out->pid_of_sender = wp->data[out->amount_of_information + 1];
  out->type_of_message = wp->data[out->amount_of_information + 2];
  out->rest_of_message = (u_char*)(wp->data + out->amount_of_information + 3);
}



void construct_bnet_message_packet(const warcraft_packet* wp, 
				   bnet_message_packet* out)
{
  out->message = wp->data;
}
