/***************************************************************************
 *   Copyright (C) 2008 by Devin Smittle   *
 *   pandagoat@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "packet_create_game.h"
#include <string.h>

void construct_create_game_packet(const warcraft_packet* wp, 
				  create_game_packet* output, 
				  const tcpip_packet* for_ip_info)
{
  output->header = (create_game_packet_header*)wp->data;
  output->game_name = (u_char*)(wp->data+CGPH_SIZE);
  output->closer = (create_game_packet_closer*)(wp->data+CGPH_SIZE+strlen(output->game_name)+1);
}


char xtod(char c) {
 if (c>='0' && c<='9') return c-'0';
 if (c>='A' && c<='F') return c-'A'+10;
 if (c>='a' && c<='f') return c-'a'+10;
 return c=0; 
}
int HextoDec(char *hex)
{
  if (*hex==0) return 0;
  return  HextoDec(hex-1)*16 +  xtod(*hex) ;
  
}
int xstrtoi(char *hex)    // hex string to integer
{
  return HextoDec(hex+strlen(hex)-1);
}

long host_count_to_long(char* hc)
{
  char hc_fixed[8] = {hc[7], hc[6], hc[5], hc[4], hc[3], hc[2], hc[1], hc[0]};
  return xstrtoi(hc_fixed);
}

long slot_count_to_long(char sc)
{
  return xtod(sc);
}
