/***************************************************************************
 *   Copyright (C) 2008 by Devin Smittle   *
 *   pandagoat@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "comm.h"
#include <assert.h>
#include <string.h>


void comm_init()
{
  int e = pipe(_fd);
  assert(e == 0);
}

void comm_write(const void* msg)
{
  FILE* o = fdopen(_fd[1], "w");
  if(o == NULL)
    printf("Problem opening the output file descriptor");
  fprintf(o, "%s\n", (u_char*)msg); /* I am not sure if this will work since msg is an array of unsigned chars */
  fflush(o);
  fclose(o);
}


void comm_send_player_joined(struct in_addr ip_p, char pid, u_char* name)
{
  comm_header* h = malloc(sizeof(comm_header));
  h->type = 0xFF;
  h->sig = 0xFF;
  h->size =  4 + 4 + 1 + strlen(name);
  player_joined pj = {ip_p, pid, name};
  u_char* data = (u_char*)&pj;
  comm_message msg = {h, data};
  comm_write((u_char*)&msg);
  free(h);
}

