/***************************************************************************
 *   Copyright (C) 2008 by Devin Smittle   *
 *   pandagoat@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#define DEBUG 1

#include "brain.h"
#include <stdlib.h>
#include <assert.h>
#include <string.h>
#include <dirent.h>
#include <fcntl.h>
#include <sys/ptrace.h>
#include <sys/socket.h>
#include <netdb.h>
#include <errno.h>
#include <GeoIP.h>


/* brain initialization */
void brain_start(char* network_dev, def_function_type on_finished)
{
  /* start sniffing on a seperate thread */
  BRAIN.network_device = g_strdup(network_dev);
  BRAIN.internal_clock = g_timer_new();
  BRAIN.packet_callback = (_wcp_handler)packet_callback;
  BRAIN.players = new_player_list();
  client_state_hosting_connect((_client_hosting_callback)client_state_hosting_changed);

  brain_gain_root();
  nose_start(BRAIN.network_device);
  brain_drop_root();

  BRAIN.brain_thread = nose_sniff_thread(BRAIN.packet_callback);

  brain_get_port();
  brain_get_my_int_ip();
  if(on_finished)
    on_finished();

  /* brain_mind_meld(); */
}









/* denit */
void brain_kill()
{
  nose_stop();
  g_timer_destroy(BRAIN.internal_clock);
}









/* Snoopy's internal clock */
gdouble brain_get_time()
{
  return g_timer_elapsed(BRAIN.internal_clock, NULL);
}






static int brain_get_port()
{
  if(BRAIN.hosting_port == 0) 	/* if it is 0 you should change your port or it has already been set */
    {
      FILE* input = popen("port=\"0x$(cat ${HOME}/.wine/user.reg | grep netgameport | sed s/\'\"netgameport\"=dword:\'// | sed s/....//)\"; echo $port", "r");
      fscanf(input, "%x", &BRAIN.hosting_port);
      pclose(input);
    }
}








/* Priviledge methods */
void brain_drop_root()
{
  int e = setreuid(0, BRAIN.uid);
}
void brain_gain_root()
{
  int e = setreuid(0, 0);
}






/* PINGS */

void brain_players_loop_pings(u_char pid, player* p, player_list* pl)
{
  char* ip = (char*)inet_ntoa(p->ext_addr.sin_addr);
  GeoIP* gi = GeoIP_new(GEOIP_STANDARD);
  char* location = (char*)GeoIP_country_code_by_addr(gi, ip);
  if(!location)
    {
      char ip_range[50];
      strncpy(ip_range, ip, strstr(ip, ".") - ip);
      ip_range[strstr(ip, ".") - ip] = '\0';

      if(atoi(ip_range) == 10)
	location = "LAN\0";
      else if(atoi(ip_range) == 172 || atoi(ip_range) == 192)
	{
	  char ip_sub_range[50];
	  strncpy(ip_sub_range, ip + 4, strstr(ip + 4, ".") - (ip + 4));
	  ip_sub_range[strstr(ip + 4, ".") - (ip + 4)] = '\0';
	  if(atoi(ip_range) == 172 && (atoi(ip_sub_range) >=16 || atoi(ip_sub_range) <=31))
	    location = "LAN\0";
	  if(atoi(ip_range) == 192 && atoi(ip_sub_range) == 168);
	  location = "LAN\0";
	}
      else
	location = "UNKNOWN\0";
    }
  
  
  u_char* name = g_strdup(p->name);
  float ping = p->ping;
  char p_ping[50];
  if(ping == -1)
    ping = brain_try_ping(p->ext_addr.sin_addr);
  if(ping == -1)
    sprintf(p_ping, "%s(t/o, %s%s). ", name, location, brain_check_banlists(p->name)!=-1?", BANNED":"");
  else
    sprintf(p_ping, "%s(%i, %s%s). ", name, (int)ping, location, brain_check_banlists(p->name)!=-1?", BANNED":"");

  strcat(BRAIN.ping_list, p_ping);
  free(gi);
}
void brain_ping_thread(void* args)
{
  /* Loop through each player in the list */
  players_start_loop(brain_players_loop_pings, BRAIN.players);
  ((ping_finished)args)(NULL);
}
void brain_speak_pings(ping_finished cb)
{
  memset(BRAIN.ping_list, '\0', 500 );
  pthread_t ping_thread;
  pthread_create(&ping_thread, NULL, brain_ping_thread, cb);
}
void brain_set_ping_program(char* program)
{
  BRAIN.ping_program = g_strdup(program);
}
float brain_try_ping(struct in_addr ip)
{
  if(BRAIN.ping_program == NULL)
    return -1;
  char cmd[500];

  sprintf(cmd, "%s %s", BRAIN.ping_program, inet_ntoa(ip.s_addr));

  float ping = -1;
  FILE* input = popen(cmd, "r");
  fscanf(input, "%f", &ping);
  pclose(input);

  return ping;
}
void brain_ping_finished_cb(void* args)
{
  brain_place_in_cb(BRAIN.ping_list);
}







/* ips */
void brain_players_loop_ips(u_char pid, player* p, player_list* pl)
{
  char curr_ip[50];
  sprintf(curr_ip, "%s(%s). ", p->name, inet_ntoa(p->ext_addr.sin_addr));
  strcat(BRAIN.ip_list, curr_ip);
}
void brain_speak_ips()
{
  memset(BRAIN.ip_list, '\0', 500 );
  players_start_loop(brain_players_loop_ips, BRAIN.players);
}




/* print lanners */
void brain_players_loop_lan_check(u_char pid, player* p, player_list* pl)
{
  int lanning = -1;
  /* pl should be a copy of the list */
  GList* curr = g_list_last(pl->players);

  while(curr)
    {
      player* _p = (player*)curr->data;
      if(_p->ext_addr.sin_port != p->ext_addr.sin_port && 
	 p->ext_addr.sin_addr.s_addr == _p->ext_addr.sin_addr.s_addr)
	{
	  lanning = 1;
	  break;
	}
      curr = g_list_previous(curr);
    }
  char curr_ip[50];
  sprintf(curr_ip, "%s(%s%s). ", p->name, inet_ntoa(p->ext_addr.sin_addr), lanning==1?" LN":"");
  strcat(BRAIN.ip_list, curr_ip);
}
void brain_speak_ips_with_lanning_players()
{
  memset(BRAIN.ip_list, '\0', 500 );
  players_start_loop(brain_players_loop_lan_check, BRAIN.players);
}







/* get info */
player* brain_get_player_pid(int pid)
{
  return players_get_ts(pid, BRAIN.players);
}
player_list* brain_get_player_list_copy()
{
  return player_list_shallow_copy(BRAIN.players);
}





/* list all player info */
void brain_players_loop_info(u_char pid, player* p, player_list* pl)
{
  char player_info[50];
  sprintf(player_info, "%s PID:%i.\n", p->name, p->pid);
  strcat(BRAIN.player_info, player_info);
}
void brain_speak_player_info()
{
  memset(BRAIN.player_info, '\0', 500);
  players_start_loop(brain_players_loop_info, BRAIN.players);
}








static void brain_get_my_int_ip()
{
}






/*  AUTOREFRESHER */
struct ref_args
{
  char* name;
  int to;
};
static void refresher_thread(void* args)
{
  struct ref_args* rargs = (struct ref_args*)args;
  BRAIN.refreshing = TRUE;
  BRAIN.refresher_thread_alive = TRUE;
  while(BRAIN.refreshing)
    { 			  
      if(BRAIN.in_game_lobby)
	{
	  brain_refresh(rargs->name);
	  sleep(rargs->to);
	}
      else
	sleep(1);
    }
  BRAIN.refresher_thread_alive = FALSE;
  BRAIN.refreshing = FALSE;
}
void brain_start_refreshing(char *name, int to)
{
  if(BRAIN.refreshing)
    {
      brain_stop_refreshing();
      while(BRAIN.refresher_thread_alive)
	{
	  sleep(1);
	}
    }
  struct ref_args* args = (struct ref_args*)malloc(sizeof(struct ref_args));
  args->name = name;
  args->to = to;
  BRAIN.refresher_to = to;
  if(!BRAIN.refreshing)
    pthread_create(&BRAIN.refresher_thread, NULL, refresher_thread, args);
}
void brain_stop_refreshing()
{
  BRAIN.refreshing = FALSE;
}
void brain_refresh(char* name)
{
  u_char type[2] = {0xf7, 0x1e};
  u_char hostcount[4];
  memmove(hostcount, &BRAIN.host_count, 4);
  u_char header[15] = {hostcount[0], hostcount[1], hostcount[2], hostcount[3],
		       0x00, 0x00, 0x00, 0x00,
		       0x00,
		       0xe4, 0xe4,
		       0x00, 0x00, 0x00, 0x00};
  u_char closer[18] = {0x01, 0x00,
		       0x02, 0x00,
		       0x17, 0xe4,
		       0x7f, 0x00, 0x00, 0x01,
		       0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

  u_char* buf = (u_char*)malloc(500);
  
  
  memmove(buf, type, 2);
  u_short size = 4 + 15 + strlen(name) + 1 + 18;
  memmove(buf + 2, (u_char*)&size, 2);
  memmove(buf + 4, header, 15);
  memmove(buf + 4 + 15, name, strlen(name) + 1);
  memmove(buf + 4 + 15 + strlen(name) + 1,
  	  closer, 18);


  struct sockaddr_in to;
  to.sin_family = AF_INET;
  inet_aton("127.0.0.1", &to.sin_addr.s_addr);
  to.sin_port = htons(BRAIN.hosting_port);
  memset(to.sin_zero, '\0', sizeof(to.sin_zero));

  int sockfd[10];
  int errors[10];

  int i;
  for(i = 0; i < 10; i++)
    {
      sockfd[i]= socket(AF_INET, SOCK_STREAM, 0);    
      if(sockfd[i] < 0)
	{
	  printf("Error creating socket %i for auto refreshing. errno=%i\n", i, errno);

	  continue;
	}  
      /* Turn off linger (i dont think this will work for family AF_INET, but heh */
      struct linger l = {1, 0};
      setsockopt(sockfd[i], SOL_SOCKET, SO_LINGER, &l, sizeof(l));

      errors[i] = connect(sockfd[i], (struct sockaddr*)&to, sizeof(to));
      if(errors[i] < 0)
	{
	  printf("Error connecting socket %i for auto refreshing. errno=%i\n", i, errno);
	  continue; 
	}
      int count = send(sockfd[i], buf,
		       size, 
		       0);

    }
  free(buf);
  sleep(1);

  for(i = 0; i < 10; i++)
    {
      if(errors[i] == -1)
	continue;

      int e = shutdown(sockfd[i], 2);
      close(sockfd[i]);
      if(e < 0)
	{
	  printf("Error shutting down socket %i for auto refreshing. errno=%i\n", i, errno);
	}
    }


}





void brain_place_in_cb(char* s)
{
  char cmd[500];

  if(strcmp(PBCOPY, "NOTFOUND") == 0)
    sprintf(cmd, "echo -n \"%s\" | xclip -sel clip", s);
  else if(strcmp(PBCOPY, "FOUND") == 0)
    sprintf(cmd, "echo -n \"%s\" | pbcopy", s);
  else
    sprintf(cmd, "echo \"NO SUITABLE CLIPBOARD PROGRAM FOUND\"");
  system(cmd);
}




/* kicking */
void* kick_thread_func(void* cmd)
{
  brain_gain_root();
  system(cmd);
  brain_drop_root();
}
void brain_kill_connection(char* net_dev, int wait, struct in_addr ip, short port)
{
  int kick_wait = wait==-1?BRAIN.kick_wait:wait;
  char cmd[500];
  sprintf(cmd, "tcpkill -i %s ip host %s and port %d > /dev/null 2>&1 3>&1", 
	  net_dev, 
	  inet_ntoa(ip), 
	  ntohs(port));
  
  pthread_t kick_thread;
  pthread_create(&kick_thread, NULL, kick_thread_func, cmd);
  
  sleep(kick_wait);
  
  brain_gain_root();
  system("killall tcpkill %i > /dev/null 2>&1 3>&1");
  brain_drop_root();

  if(players_get_addr(ip, port, BRAIN.players))
    BRAIN.kick_wait = kick_wait+1;
}












/* banlist */
void brain_add_banlist_file(char* file_name)
{
  BRAIN.banlist_files = g_list_prepend(BRAIN.banlist_files, g_strdup(file_name));
}
int brain_check_banlists(char* account)
{
  GList* curr = g_list_first(BRAIN.banlist_files);

  while(curr)
    {
      char* file_name = (char*)curr->data;
      char reason[500];
      if(banlist_check_account(file_name, account, reason, 500) != -1)
	return 1;
      curr = curr->next;
    }
  return -1;
}




void brain_perm_set_file_to_user(char* file)
{
  char pfix[500];
  sprintf(pfix, "chown %i:%i \"%s\"; chmod ug+rw \"%s\"", BRAIN.uid, BRAIN.gid, file, file);
  system(pfix);
}













/* packet handlers */
static void client_state_hosting_changed(int hosting)
{
}
static void* packet_callback(warcraft_packets* wp, tcpip_packet* p, void* args)
{
  if(wp != NULL)
    warcraft_packet_loop_through(wp, p, (warcraft_packet_loop_callback)warcraft_packets_looper, args);
}
static void* warcraft_packets_looper(warcraft_packet* wp, tcpip_packet* tcpipp,  void* args)
{
  /* I had to move these up here for some random reason */
  if(wp->header->type == 0xF7 &&  wp->header->sig == SIG_PLAYER_LEFT)
      handle_player_left(wp, tcpipp, args);
  else if(wp->header->type == 0xF7 && wp->header->sig == SIG_PLAYER_LEAVE_ACCEPTED)
      handle_player_left(wp, tcpipp, args);
  else if(wp->header->type == 0xF7 && wp->header->sig == SIG_SLOT_INFO)
      handle_slot_info(wp, tcpipp, args);
  else if(wp->header->type == 0xF7 && wp->header->sig == SIG_SLOT_ON_JOIN)
      handle_slot_info(wp, tcpipp, args);
  else if(wp->header->sig == SIG_GAME_LOADED)
    handle_game_loaded(wp, tcpipp, args);
  else if(wp->header->sig == SIG_GAME_LOADING)
    handle_game_loading(wp, tcpipp, args);
  else if(wp->header->sig == SIG_PLAYER_JOINED)
    handle_player_joined(wp, tcpipp, args);

  if(wp->header->type == 0xF7)
    {
      /* CLIENT HOSTING */
      if(CLIENT_HOSTING == 1)
	{
	  if(wp->header->sig == SIG_PLAYER_JOIN_REQUEST)	  /* player requests to join */
	    handle_player_request(wp, tcpipp, args);
	  else if(wp->header->sig == SIG_ACCEPT_JOIN_REQUEST)	  /* player was accepted */
	    handle_player_accepted(wp, tcpipp, args);
	  else if(wp->header->sig == SIG_HOST_ECHO_REQUEST)       /* I sent a request for echo */
	    handle_host_echo_request(wp, tcpipp, args);
	  else if(wp->header->sig == SIG_HOST_ECHO_RESPONSE)      /* I received a echo response */
	    handle_host_echo_response(wp, tcpipp, args);
	  else if(wp->header->sig == SIG_MESSAGE_HOST)
	    handle_message_packet(wp, tcpipp, args);
	}
      /* /\* CLIENT NOT HOSTING *\/ */
      else if(CLIENT_HOSTING == 0)
      	{
	  if(wp->header->sig == SIG_PLAYER_JOIN_REQUEST) /* in order to get client name */
	    handle_player_request(wp, tcpipp, args);
	  else if(wp->header->sig == SIG_ACCEPT_JOIN_REQUEST) /* player was accepted */
	    handle_player_accepted(wp, tcpipp, args);
	}
    }
  else if(wp->header->type = 0xFF)
    {
      if(wp->header->sig == SIG_CREATE_GAME)
	handle_create_game(wp, tcpipp, args);
      else if(wp->header->sig == SIG_GAME_QUIT)
	handle_quit_game(wp, tcpipp, args);
      else if(wp->header->sig == SIG_MESSAGE_BNET)
	handle_message_packet(wp, tcpipp, args);
      else if(wp->header->sig == SIG_MESSAGE_FROM_BNET)
	handle_message_packet(wp, tcpipp, args);
    }
}
static void handle_slot_info(warcraft_packet* wp, tcpip_packet* tcpipp,  void* args)
{
  slot_info_packet sip;
  construct_slot_info_packet(wp, &sip);
  BRAIN.open_slot_count = slot_info_packet_count_open_slots(&sip);

  int i;
  slot* curr = sip.slots;
  for(i = 0; i < sip.header->slot_count; i++)
    {
      player* p = players_get(curr->data->pid, BRAIN.players);
      if(p)
	{
	  p->color = curr->data->color_number;
	}
      if(i != sip.header->slot_count - 1)
	curr = curr->next;
    }
}
static void handle_game_loading(warcraft_packet* wp, tcpip_packet* tcpipp,  void* args)
{
  BRAIN.in_game = TRUE;
  BRAIN.in_game_lobby = FALSE;
  BRAIN.game_start_time = brain_get_time();
}
static void handle_game_loaded(warcraft_packet* wp, tcpip_packet* tcpipp,  void* args)
{
  BRAIN.in_game_lobby = FALSE;
}
static void handle_create_game(warcraft_packet* wp, tcpip_packet* tcpipp,  void* args)
{
  if(!CLIENT_HOSTING)
    {
      create_game_packet cgp;
      construct_create_game_packet(wp, &cgp, tcpipp);
      BRAIN.host_count = CGP_HOST_COUNT_LONG(&cgp);
      BRAIN.free_slot_count = CGP_FREE_SLOT_COUNT_LONG(&cgp);
      BRAIN.open_slot_count = BRAIN.free_slot_count;
      BRAIN.in_game_lobby = TRUE;
      inet_aton("127.0.0.1", &BRAIN.host_ip);
      BRAIN.host_port = BRAIN.hosting_port;
      CLIENT_HOSTING = 1;
    }
}

static void handle_quit_game(warcraft_packet* wp, tcpip_packet* tcpipp,  void* args)
{
  BRAIN.in_game = FALSE;
  BRAIN.in_game_lobby = FALSE;
  CLIENT_HOSTING = 0;
  GAME_NUMBER_OF_PLAYERS = 0;
  players_clear_players(BRAIN.players);
  players_clear_pending(BRAIN.players);
  players_clear_pings(BRAIN.players);
}
static void handle_player_request(warcraft_packet* wp, tcpip_packet* tcpipp,  void* args)
{
  player_join_request_packet pjrp;
  construct_player_join_request_packet(wp, &pjrp, tcpipp);

  if(CLIENT_HOSTING == 1)
    players_add_pending(&pjrp, BRAIN.players);
  else
    {
      memmove(BRAIN.my_name, pjrp.player_name, strlen(pjrp.player_name));
    }
}
static void handle_player_accepted(warcraft_packet* wp, tcpip_packet* tcpipp,  void* args)
{
  if(CLIENT_HOSTING == 0)
    {
      BRAIN.in_game_lobby = 1;
      return;
    }
  accept_join_request_packet ajrp;
  construct_accept_join_request_packet(wp, &ajrp, tcpipp);
  player* requesting_player = players_get_player_pending(ajrp.closer->ext_addr, BRAIN.players);
  if(requesting_player)
    {
      player* p = g_slice_new(player);
      p->pid = ajrp.closer->pid;
      p->ping = -1;
      p->ext_addr = ajrp.closer->ext_addr;
      p->name = g_strdup(requesting_player->name);
      
      players_remove_pending(ajrp.closer->ext_addr, BRAIN.players);
      players_add(p, BRAIN.players);
      GAME_NUMBER_OF_PLAYERS++;
    }
}
static void handle_player_joined(warcraft_packet* wp, tcpip_packet* tcpipp,  void* args)
{
  player_joined_packet pjp;
  construct_player_joined_packet(wp, &pjp);

  if(CLIENT_HOSTING==1 && pjp.header->pid==1)
    {
      memmove(BRAIN.my_name, pjp.player_name, strlen(pjp.player_name));
      return;
    }

  if(players_get(pjp.header->pid, BRAIN.players))
    {
      return;
    }
  player* p = g_slice_new(player);
  p->pid = pjp.header->pid;
  p->ping = -1;
  p->ext_addr = pjp.closer->ext_addr;
  p->name = g_strdup(pjp.player_name);
  
  /* Correct ip if its host */
  if(pjp.closer->ext_addr.sin_addr.s_addr == 0)
    {
      if(CLIENT_HOSTING)
	return;
      p->ext_addr.sin_addr = tcpipp->ih->src;
      p->ext_addr.sin_port = tcpipp->th->src_port;
      BRAIN.host_ip.s_addr = p->ext_addr.sin_addr.s_addr;
      BRAIN.host_port = p->ext_addr.sin_port;
    }
  
  players_add(p, BRAIN.players);
  GAME_NUMBER_OF_PLAYERS++;
}
static void handle_player_left(warcraft_packet* wp, tcpip_packet* tcpipp,  void* args)
{
  player* p;
  if(wp->header->sig == SIG_PLAYER_LEAVE_ACCEPTED) /* host or i left as client*/
    {
      if(!CLIENT_HOSTING)
	{
	  GAME_NUMBER_OF_PLAYERS = 0;
	  players_clear_players(BRAIN.players);
	  players_clear_pending(BRAIN.players);
	  players_clear_pings(BRAIN.players);
	}
      else
	p = players_get_addr(tcpipp->ih->dest, tcpipp->th->dest_port, BRAIN.players);
    }
  else if(wp->header->sig = SIG_PLAYER_LEFT) /* i am client or host sending to clients*/
    {
      player_left_packet plp;
      construct_player_left_packet(wp, &plp);
      p = players_get(plp.pid, BRAIN.players);
    }
  if(p && BRAIN.in_game_lobby)
    {
      players_remove_ping(p->ext_addr.sin_addr, p->ext_addr.sin_port, BRAIN.players);
      players_remove(p->pid, BRAIN.players);
      GAME_NUMBER_OF_PLAYERS--;
    }
}
static void handle_host_echo_request(warcraft_packet* wp, tcpip_packet* tcpipp,  void* args)
{
  gdouble start = brain_get_time();
  player_ping* pp = players_add_ping(tcpipp->ih->dest, tcpipp->th->dest_port, BRAIN.players);
  pp->start_echo = start;
}
static void handle_host_echo_response(warcraft_packet* wp, tcpip_packet* tcpipp,  void* args)
{
  gdouble end = brain_get_time();

  player_ping* pp = players_ping_get(tcpipp->ih->src, tcpipp->th->src_port, BRAIN.players);
  if(pp)
    {
      pp->end_echo = end;

      player* p = players_get_addr(tcpipp->ih->src, tcpipp->th->src_port, BRAIN.players);
      if(p)
	p->ping = GET_PING_MS(pp);

      players_remove_ping(tcpipp->ih->src, tcpipp->th->src_port, BRAIN.players);
    }
}
static void handle_message_packet(warcraft_packet* wp, tcpip_packet* tcpipp,  void* args)
{
  if(wp->header->sig == SIG_MESSAGE_BNET)
    {
      bnet_message_packet bmp;
      construct_bnet_message_packet(wp, &bmp);
      if(strcmp(bmp.message, "/ping") == 0)
	brain_speak_pings(brain_ping_finished_cb);
      else if(strncmp(bmp.message, "/refresh", 8) == 0)
	{
	  if(strncmp((bmp.message+9), "start", 5) == 0)
	    {
	      int to = atoi(bmp.message+15);
	      brain_start_refreshing("|rSnoopyOnLinux", to);
	    }
	  if(strncmp(bmp.message+8, "stop", 4) == 0)
	    {
	      brain_stop_refreshing();
	    }
	}
      else if(strncmp(bmp.message, "/msg", 4) == 0)
	{
	  brain_place_in_cb(BRAIN.start_message);
	}
      else if(strncmp(bmp.message, "/bancolor", 9) == 0)
	{
	  char color[10];
	  char reason[100];
	  memset(color, '\0', 10);
	  memset(reason, '\0', 100);
	  char* first_space = strstr(bmp.message+10, " ");
	  if(first_space)
	    {
	      int len = first_space - (char*)(bmp.message+10);
	      memmove(color, bmp.message+10, len);
	      memmove(reason, first_space+1, strlen(first_space+1));
	      enum COLOR c = massive_color_parser(color);
	      player* p = players_get_color(c, BRAIN.players);
	      if(p)
		{
		  char ban_file[100];
		  sprintf(ban_file, "%s/.snoopy/snoopy_local.bl", getenv("HOME"));
		  char ban_line[100];
		  memset(ban_line, '\0', 100);
		  banlist_ban(ban_file, p->name, brain_get_time()-BRAIN.game_start_time, BRAIN.my_name, reason, BRAIN.realm, ban_line);
		  brain_place_in_cb(ban_line);
		}
	      else
		printf("Unable to ban, no one is color %s\n", color);
	    }
	}
      else if(strncmp(bmp.message, "/banname", 8) == 0)
	{
	  char name[20];
	  char reason[100];
	  memset(reason, '\0', 100);
	  memset(name, '\0', 20);

	  char* first_space = strstr(bmp.message+9, " ");
	  int len = first_space - (char*)(bmp.message+9);
	  memmove(name, bmp.message+9, len);


	  if(first_space)
	    {
	      memmove(reason, first_space+1, strlen(first_space+1));
	      char ban_file[100];
	      sprintf(ban_file, "%s/.snoopy/snoopy_local.bl", getenv("HOME"));
	      char ban_line[100];
	      memset(ban_line, '\0', 100);
	      banlist_ban(ban_file, name, brain_get_time()-BRAIN.game_start_time, BRAIN.my_name, reason, BRAIN.realm, ban_line);
	      brain_place_in_cb(ban_line);
	    }
	}
     else if(strncmp(bmp.message, "/kick", 5) == 0)
	{
	  char color[20];
	  memset(color, '\0', 20);
	  memmove(color, bmp.message+6, strlen(bmp.message+6));
	  player* p = players_get_color(massive_color_parser(color), BRAIN.players);
	  if(p)
	    brain_kill_connection(BRAIN.network_device, -1, p->ext_addr.sin_addr, p->ext_addr.sin_port);
	}
     else if(strncmp(bmp.message, "/follow", 7) == 0)
       {
	 memset(BRAIN.friend_follow, '\0', 100);
	 memmove(BRAIN.friend_follow, bmp.message + 8, strlen(bmp.message+8));
       }
     else if(strncmp(bmp.message, "/ccb", 3) == 0)
       {
	 brain_place_in_cb("");
       }
    }
  else if(wp->header->sig == SIG_MESSAGE_FROM_BNET)
    {
      message_from_bnet_packet mfbp;
      construct_message_from_bnet_packet(wp, &mfbp, tcpipp);  
      lowercase_string(mfbp.account_from);
    
      if(mfbp.type == MFBP_TYPE_FRIEND_JOINED)
	{
	  /* get the game name and put it in the copy buffer if its from the friend we are following */
	  if(strcmp(mfbp.account_from, BRAIN.friend_follow) == 0)
	    {
	      char* called = strstr(mfbp.message, "called");
	      if(called)
		{
		  char* game_name = called+7;
		  int fixed_size = strrchr(game_name, '.') - game_name;
		  char fixed_name[fixed_size+1];
		  memset(fixed_name, '\0', fixed_size+1);
		  memmove(fixed_name, game_name, fixed_size);
		  brain_place_in_cb(fixed_name);
		}
	    }
	}
    }
}







/* MESSAGES */
static void brain_pick_random_player_fallback()
{
   player* p = ((player*)BRAIN.players->players->data);
   BRAIN.message_player_fallback.sin_port = p->ext_addr.sin_port;
   BRAIN.message_player_fallback.sin_addr = p->ext_addr.sin_addr;
}









void brain_mind_meld()
{
  /* scan /proc to find warcraft's pid */
  DIR* ds = opendir("/proc/");
  struct dirent* d;
  int found = -1;
  while(d = readdir(ds))
    {
      if(strcmp(d->d_name, ".") == 0 || strcmp(d->d_name, "..") == 0 )
	continue;
      char status_file[500];
      sprintf(status_file, "/proc/%s/status", d->d_name);
      FILE* fd = fopen(status_file, "r");
      if(!fd)
	continue;
      char proc_name[500];
      fscanf(fd, "Name:	%s", proc_name);
      if(strcmp(proc_name, "war3.exe") == 0)
	{
	  BRAIN.warcraft_pid = atoi(d->d_name);
	  found = 1;
	  break;
	}
    }

  if(found == -1)
    {
      printf("Warcraft III process not found, trying again in 5 seconds.\n\n");
      sleep(5);
      brain_mind_meld();
    }

  if(BRAIN.attached != 2)
    {
      printf("Warcraft III process found, attaching self to process.\n\n");
      ptrace(PTRACE_ATTACH, BRAIN.warcraft_pid, 0, 0);
      ptrace(PTRACE_CONT, BRAIN.warcraft_pid, 0, 0);
      BRAIN.attached = 2;
    }
}


void brain_read_memory(off_t offset, size_t length, void* out)
{
  char mem_file[500];
  sprintf(mem_file, "/proc/%i/mem", BRAIN.warcraft_pid);
  int fd = open(mem_file, O_RDONLY);
  lseek(fd, offset, SEEK_SET);
  read(fd, out, length);
}
