/*
 * Copyright (C) 2001-2003 R. David Quattlebaum <drq@drqware.com>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 */

/* $Id: util.c,v 1.21 2003/05/18 23:11:50 drq Exp $ */

/*
 * special utility functions used thruout scud 
 */

#ifdef WIN32
#include <windows.h>
#include <io.h>
#include <sys/stat.h>
#else
#include <unistd.h>
#include <stdlib.h>
#endif

#include <sys/types.h>
#include <fcntl.h>
#include <stdarg.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>

#include "scud.h"

/*
 * option variables
 */
extern char *progname;
extern int logfile;
extern char *logfilename;
extern int verbose;
extern int console;

char *
strindex(char *str, char ch)
{
   int last = strlen(str);

   if (last == 0)
      return(0);

   for (last--; str[last] != ch; last--) {
      if (last == 0)
         return(0);
   }
   return(&str[last]);
}


static char __log_printf_buffer[65536];

int
log_printf(char * format, ...)
{   
  va_list ap;
  char *buffer = __log_printf_buffer;
  int rc, len, bytes;

  va_start(ap, format);
  rc = vsprintf(buffer, format, ap);
  va_end(ap);

  if (logfile == 0) {
     logfile = open(logfilename, O_WRONLY|O_APPEND|O_CREAT, 0644);
     if (logfile == BAD_FD) {
        perror("log_printf");
        fprintf(stderr, "Log open error, sending to stdout\n");
        console = 1;
     }
  }

  if (!strncmp(buffer, "ERROR:", 6)) {
#ifdef WIN32
#ifdef _CONSOLE
     fprintf(stderr, "%s", buffer);
     fprintf(stderr, "\n\npress Enter to Exit\n");
     gets(buffer);
#else
     MessageBox(NULL, buffer, progname, MB_OK|MB_ICONSTOP);
#endif
#else
     fprintf(stderr, "%s", buffer);
#endif
     exit(1);
  }
  if (console) {
     rc = printf("%s", buffer);
     fflush(stdout);
  }
  if (logfile > 0) {
     len = strlen(buffer);
     bytes = write(logfile, buffer, len);
  }

  return(rc);
}

char lower[BUFLEN];
/*
 * lowercase a string
 */
char *
lowercase(char *str) {
   unsigned int i;
 
   for (i=0; i<strlen(str); i++)
      lower[i] = tolower(str[i]);
   lower[i] = 0;
  
   return(lower);
}


