/*
 * Copyright (C) 2001-2003 R. David Quattlebaum <drq@drqware.com>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 */

/* $Id: modem.h,v 1.11 2003/02/12 19:42:36 drq Exp $ */

/*
 * modem.h - all routines dealing I/O to the modem
 */
#ifndef __modem_h__
#define __modem_h__

/* prototypes */
int modem_read_byte(int fd, char *ch, int timeout);
int modem_read_string(int fd, char *buffer, int buflen, int timeout);
int modem_send_raw(int fd, char *cmd, int len);
int modem_send_command(int fd, char *cmd);
int modem_send_command_reply(int fd, char *cmd, char *reply);
int modem_open(char *device);

#endif
