(release-3006.10)=
# Salt 3006.10 release notes

<!---
Do not edit this file. This is auto generated.
Edit the templates in doc/topics/releases/templates/
for a given release.
-->


<!--
Add release specific details below
-->

<!--
Do not edit the changelog below.
This is auto generated.
-->
## Changelog

### Removed

- Remove psutil_compat.py file, which should have been removed when RHEL 6 EOL [#66467](https://github.com/saltstack/salt/issues/66467)
- Removed dependency on bsdmainutils package for Debian and Ubuntu [#67184](https://github.com/saltstack/salt/issues/67184)


### Deprecated

- Drop Arch Linux support [#66886](https://github.com/saltstack/salt/issues/66886)
- Removed support for end of life Python 3.7 and 3.8 from pre-commit and requirements [#67729](https://github.com/saltstack/salt/issues/67729)


### Fixed

- Commands on Windows are now prefixed with ``cmd /c`` so that compound
  commands (commands separated by ``&&``) run properly when using ``runas`` [#44736](https://github.com/saltstack/salt/issues/44736)
- Issue 58969: Fixes an issue with `saltclass.expand_classes_in_order`
  function where it was losing nested classes states during class
  expansion. The logic now use `salt.utils.odict.OrderedDict` to keep
  the inclusion ordering. [#58969](https://github.com/saltstack/salt/issues/58969)
- Fix issue with RunAs on Windows so that usernames of all numeric characters
  are handled as strings [#59344](https://github.com/saltstack/salt/issues/59344)
- Fixed an issue on Windows where checking success_retcodes when using the
  runas parameter would fail. Now success_retcodes are checked correctly [#59977](https://github.com/saltstack/salt/issues/59977)
- Fix an issue with cmd.script in Windows so that the exit code from a script will
  be passed through to the retcode of the state [#60884](https://github.com/saltstack/salt/issues/60884)
- Fixed an issue uninstalling packages on Windows using pkg.removed where there
  are multiple versions of the same software installed [#61001](https://github.com/saltstack/salt/issues/61001)
- Ensure file clients for runner, wheel, local and caller are available from the client_cache if called upon. [#61416](https://github.com/saltstack/salt/issues/61416)
- Convert stdin string to bytes regardless of stdin_raw_newlines [#62501](https://github.com/saltstack/salt/issues/62501)
- Issue 63933: Fixes an issue with `saltclass.expanded_dict_from_minion`
  function where it was passing a reference to minion `dict` which was
  overridden by nested classes during class expansion. Copy the node
  definition with `copy.deepcopy` instead of passing a reference. [#63933](https://github.com/saltstack/salt/issues/63933)
- Fixed an intermittent issue with file.recurse where the state would
  report failure even on success. Makes sure symlinks are created
  after the target file is created [#64630](https://github.com/saltstack/salt/issues/64630)
- The 'profile' outputter does not crash with incorrectly formatted data [#65104](https://github.com/saltstack/salt/issues/65104)
- Updating version comparison for rpm and removed obsolete comparison methods for rpms [#65443](https://github.com/saltstack/salt/issues/65443)
- Fix batch mode hang indefinitely in some scenarios [#66249](https://github.com/saltstack/salt/issues/66249)
- Applying `selinux.fcontext_policy_present` to a shorter path than an existing entry now works [#66252](https://github.com/saltstack/salt/issues/66252)
- Correct bash-completion for Debian / Ubuntu [#66560](https://github.com/saltstack/salt/issues/66560)
- Fix minion config option startup_states [#66592](https://github.com/saltstack/salt/issues/66592)
- Fixed an issue with cmd.run with requirements when the shell is not the
  default [#66596](https://github.com/saltstack/salt/issues/66596)
- Fixes an issue when getting account names using the get_name function in the
  win_dacl.py salt util. Capability SIDs return ``None``. SIDs for deleted
  accounts return the SID. SIDs for domain accounts where the system is not
  connected to the domain return the SID. [#66637](https://github.com/saltstack/salt/issues/66637)
- Fixed an issue where ``status.master`` wasn't detecting a connection to the
  specified master properly [#66716](https://github.com/saltstack/salt/issues/66716)
- Fixed ``win_wua.available`` when some of the update objects are empty CDispatch
  objects. The ``available`` function no longer crashes [#66718](https://github.com/saltstack/salt/issues/66718)
- Clean up multiprocessing file handles on minion [#66726](https://github.com/saltstack/salt/issues/66726)
- Fixed nacl.keygen for not yet existing sk_file or pk_file [#66772](https://github.com/saltstack/salt/issues/66772)
- fix yaml output [#66783](https://github.com/saltstack/salt/issues/66783)
- Fixed an issue where enabling `grain_opts` in the minion config would cause
  some core grains to be overwritten. [#66784](https://github.com/saltstack/salt/issues/66784)
- Fix an issue where files created using `salt.utils.atomicile.atomic_open()`
  were created with restrictive permissions instead of respecting the umask. [#66786](https://github.com/saltstack/salt/issues/66786)
- Fix bad async_method name on AsyncPubClient class [#66789](https://github.com/saltstack/salt/issues/66789)
- Ensure Manjaro ARM reports the correct os_family of Arch. [#66796](https://github.com/saltstack/salt/issues/66796)
- Removed ``salt.utils.data.decode`` usage from the fileserver. This function was
  necessary to support Python 2. This speeds up loading the list cache by 80-90x. [#66835](https://github.com/saltstack/salt/issues/66835)
- Issue 66837: Fixes an issue with the `network.local_port_tcp` function
  where it was not parsing the IPv4 mapped IPv6 address correctly. The
  ``::ffff:`` is now removed and only the IP address is returned. [#66837](https://github.com/saltstack/salt/issues/66837)
- Better handling output of `systemctl --version` with salt.grains.core._systemd [#66856](https://github.com/saltstack/salt/issues/66856)
- Upgrade relenv to 0.17.3. This release includes python 3.10.15, openssl 3.2.3,
  and fixes for pip 24.2. [#66858](https://github.com/saltstack/salt/issues/66858)
- Remove caching of 'systemctl status' in systemd_service to fix automatic daemon-reload for repeated invocations. [#66864](https://github.com/saltstack/salt/issues/66864)
- Added cryptogrpahy back to base.txt requirements as a dependency [#66883](https://github.com/saltstack/salt/issues/66883)
- Remove "perms" from `linux_acl.list_absent()` documentation [#66891](https://github.com/saltstack/salt/issues/66891)
- Ensure minion start event coroutines are run [#66932](https://github.com/saltstack/salt/issues/66932)
- Allow for secure-boot efivars directory having SecureBoot-xxx files, not directories with a data file [#66955](https://github.com/saltstack/salt/issues/66955)
- Removed the usage of wmic to get the disk and iscsi grains for Windows. The wmic
  binary is being deprecated. [#66959](https://github.com/saltstack/salt/issues/66959)
- Fixes an issue with the LGPO module when trying to parse ADMX/ADML files
  that have a space in the XMLNS url in the policyDefinitionsResources header. [#66992](https://github.com/saltstack/salt/issues/66992)
- Ensured global dunders like __env__ are defined in state module that are run in parallel on spawning platforms [#66996](https://github.com/saltstack/salt/issues/66996)
- Filtered unpicklable objects from the context dict when invoking states in parallel on spawning platforms to avoid a crash [#66999](https://github.com/saltstack/salt/issues/66999)
- Update for deprecation of hex in pygit2 1.15.0 and above [#67017](https://github.com/saltstack/salt/issues/67017)
- Fixed blob path for salt.ufw in the firewall tutorial documentation [#67019](https://github.com/saltstack/salt/issues/67019)
- Update locations for bootstrap scripts, to new infrastructure, GitHub releases for bootstrap [#67020](https://github.com/saltstack/salt/issues/67020)
- Constrained the localfs module to operations inside the specified cachedir [#67031](https://github.com/saltstack/salt/issues/67031)
- Added support for dnf5 (backport from 3007) and update to its new command syntax changes since 2023 [#67057](https://github.com/saltstack/salt/issues/67057)
- Recognise newer AMD GPU devices [#67058](https://github.com/saltstack/salt/issues/67058)
- Fix yumpkg module for Python<3.8 [#67091](https://github.com/saltstack/salt/issues/67091)
- Fixed an issue with making changes to the Windows Firewall when the
  AllowInboundRules setting is set to True [#67122](https://github.com/saltstack/salt/issues/67122)
- Added support and tests for dnf5 to services_need_restart for yum packages [#67177](https://github.com/saltstack/salt/issues/67177)
- Use os.walk to traverse git branches, and no longer replace slash '/' in git branch names [#67722](https://github.com/saltstack/salt/issues/67722)
- Set correct virtual grain in systemd based Podman containers [#67733](https://github.com/saltstack/salt/issues/67733)
- Corrected option --upgrades for dnf[5] for function list_upgrades [#67743](https://github.com/saltstack/salt/issues/67743)
- Fix salt-ssh for hosts that use password as the SSH password [#67754](https://github.com/saltstack/salt/issues/67754)
- Corrected dnf5 option --downloadonly for dnf5 install [#67769](https://github.com/saltstack/salt/issues/67769)
- Upgrade relenv to 0.18.1. Which includes python 3.10.16 and openssl 3.2.4.
  Openssl 3.2.4 fixes CVE-2024-12797 and CVE-2024-13176 [#67792](https://github.com/saltstack/salt/issues/67792)
- Update jinja2 to 3.1.5, advisories GHSA-q2x7-8rv6-6q7h and GHSA-gmj6-6f8f-6699
  Update urllib3 to 1.26.18 advisories GHSA-34jh-p97f-mpxf [#67794](https://github.com/saltstack/salt/issues/67794)
- Ensure salt-cloud has salt-master dependency on Debian and Ubuntu [#67810](https://github.com/saltstack/salt/issues/67810)
- Fix traceback from _send_req_sync method on minion by raising proper timeout error. [#67891](https://github.com/saltstack/salt/issues/67891)


### Added

- Issue #33669: Fixes an issue with the ``ini_managed`` execution module
  where it would always wrap the separator with spaces. Adds a new parameter
  named ``no_spaces`` that will not warp the separator with spaces. [#33669](https://github.com/saltstack/salt/issues/33669)
- Enhance json.find_json to return json even when it contains text on the same line of the last closing parenthesis [#67023](https://github.com/saltstack/salt/issues/67023)
