
///////////////////////////////////////////////////////////
//                                                       //
//                         SAGA                          //
//                                                       //
//      System for Automated Geoscientific Analyses      //
//                                                       //
//                     Tool Library                      //
//                    io_webservices                     //
//                                                       //
//-------------------------------------------------------//
//                                                       //
//                   TLB_Interface.cpp                   //
//                                                       //
//                 Copyright (C) 2020 by                 //
//                      Olaf Conrad                      //
//                                                       //
//-------------------------------------------------------//
//                                                       //
// This file is part of 'SAGA - System for Automated     //
// Geoscientific Analyses'. SAGA is free software; you   //
// can redistribute it and/or modify it under the terms  //
// of the GNU General Public License as published by the //
// Free Software Foundation, either version 2 of the     //
// License, or (at your option) any later version.       //
//                                                       //
// SAGA is distributed in the hope that it will be       //
// useful, but WITHOUT ANY WARRANTY; without even the    //
// implied warranty of MERCHANTABILITY or FITNESS FOR A  //
// PARTICULAR PURPOSE. See the GNU General Public        //
// License for more details.                             //
//                                                       //
// You should have received a copy of the GNU General    //
// Public License along with this program; if not, see   //
// <http://www.gnu.org/licenses/>.                       //
//                                                       //
//-------------------------------------------------------//
//                                                       //
//    e-mail:     oconrad@saga-gis.org                   //
//                                                       //
//    contact:    Olaf Conrad                            //
//                Institute of Geography                 //
//                University of Hamburg                  //
//                Germany                                //
//                                                       //
///////////////////////////////////////////////////////////

//---------------------------------------------------------
// 1. Include the appropriate SAGA-API header...

#include <saga_api/saga_api.h>


//---------------------------------------------------------
// 2. Place general tool library information here...

CSG_String Get_Info(int i)
{
	switch( i )
	{
	case TLB_INFO_Name:	default:
		return( _TL("Web Services" ) );

	case TLB_INFO_Category:
		return( _TL("Import/Export") );

	case TLB_INFO_Author:
		return( "SAGA User Group Associaton (c) 2024" );

	case TLB_INFO_Description:
		return( _TW("Web Services") );

	case TLB_INFO_Version:
		return( "1.0" );

	case TLB_INFO_Menu_Path:
		return( _TL("File|Web Services") );
	}
}


//---------------------------------------------------------
// 3. Include the headers of your tools here...

#include "geocoding.h"
#include "global_tiles.h"
#include "opentopography.h"
#include "usgs_earthquakes.h"
#include "opendata_dgm1.h"


//---------------------------------------------------------
// 4. Allow your tools to be created here...

CSG_Tool *		Create_Tool(int i)
{
	switch( i )
	{
	case  0: return( new CGeoCoding );

#if defined(HAVE_LIBCURL)
	case  1: return( new CSRTM_CGIAR );
//	case  2: return( new CSRTM_USGS );
//	case  3: return( new CCopernicus_DEM );
	case  4: return( new COpenTopography );
	case  5: return( new CUSGS_Earthquakes );
	case  6: return( new COpenData_DGM1_Bayern );
	case  7: return( new COpenData_DGM1_MV );
	case  8: return( new COpenData_DGM1_NI );
	case  9: return( new COpenData_DGM1_NRW );
	case 10: return( new COpenData_DGM1_RLP );
	case 11: return( new COpenData_DGM1_SH );
	case 12: return( new COpenData_DGM1_Sachsen );
	case 13: return( new COpenData_DGM1_Thuringia );
	case 14: return( new COpenData_DGM1_Brandenburg );
#endif

	case 15: return( NULL );
	default: return( TLB_INTERFACE_SKIP_TOOL );
	}
}


///////////////////////////////////////////////////////////
//                                                       //
//                                                       //
//                                                       //
///////////////////////////////////////////////////////////

//---------------------------------------------------------
//{{AFX_SAGA

	TLB_INTERFACE

//}}AFX_SAGA
