/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.proxool;

import java.sql.Connection;
import java.sql.Statement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logicalcobwebs.proxool.ConnectionPoolDefinitionIF;
import org.logicalcobwebs.proxool.ConnectionValidatorIF;

public class DefaultConnectionValidator
implements ConnectionValidatorIF {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validate(ConnectionPoolDefinitionIF cpd, Connection connection) {
        String testSql = cpd.getHouseKeepingTestSql();
        if (testSql == null || testSql.length() == 0) {
            Log log = this.getPoolLog(cpd.getAlias());
            log.warn((Object)"Connection validation requested but house-keeping-test-sql not defined");
            return false;
        }
        Statement st = null;
        try {
            st = connection.createStatement();
            st.execute(testSql);
            boolean bl = true;
            return bl;
        }
        catch (Throwable t) {
            Log log = this.getPoolLog(cpd.getAlias());
            if (log.isDebugEnabled()) {
                log.debug((Object)("A connection failed the validation test with error: " + t));
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (Throwable t) {
                    return false;
                }
            }
        }
    }

    private Log getPoolLog(String poolAlias) {
        return LogFactory.getLog((String)("org.logicalcobwebs.proxool." + poolAlias));
    }
}

