/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.util;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentStats;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.utilint.CmdUtil;
import java.io.File;
import java.io.PrintStream;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.Random;

public class DbCacheSize {
    private static final NumberFormat INT_FORMAT = NumberFormat.getIntegerInstance();
    private static final String HEADER = "    Cache Size      Btree Size  Description\n--------------  --------------  -----------";
    private static final int COLUMN_WIDTH = 14;
    private static final int COLUMN_SEPARATOR = 2;

    public static void main(String[] args) {
        try {
            long records = 0L;
            int keySize = 0;
            int dataSize = 0;
            int nodeMax = 128;
            int density = 80;
            long overhead = 0L;
            File measureDir = null;
            boolean measureRandom = false;
            for (int i = 0; i < args.length; ++i) {
                String name = args[i];
                String val = null;
                if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                    val = args[++i];
                }
                if (name.equals("-records")) {
                    if (val == null) {
                        DbCacheSize.usage("No value after -records");
                    }
                    try {
                        records = Long.parseLong(val);
                    }
                    catch (NumberFormatException e) {
                        DbCacheSize.usage(val + " is not a number");
                    }
                    if (records > 0L) continue;
                    DbCacheSize.usage(val + " is not a positive integer");
                    continue;
                }
                if (name.equals("-key")) {
                    if (val == null) {
                        DbCacheSize.usage("No value after -key");
                    }
                    try {
                        keySize = Integer.parseInt(val);
                    }
                    catch (NumberFormatException e) {
                        DbCacheSize.usage(val + " is not a number");
                    }
                    if (keySize > 0) continue;
                    DbCacheSize.usage(val + " is not a positive integer");
                    continue;
                }
                if (name.equals("-data")) {
                    if (val == null) {
                        DbCacheSize.usage("No value after -data");
                    }
                    try {
                        dataSize = Integer.parseInt(val);
                    }
                    catch (NumberFormatException e) {
                        DbCacheSize.usage(val + " is not a number");
                    }
                    if (dataSize > 0) continue;
                    DbCacheSize.usage(val + " is not a positive integer");
                    continue;
                }
                if (name.equals("-nodemax")) {
                    if (val == null) {
                        DbCacheSize.usage("No value after -nodemax");
                    }
                    try {
                        nodeMax = Integer.parseInt(val);
                    }
                    catch (NumberFormatException e) {
                        DbCacheSize.usage(val + " is not a number");
                    }
                    if (nodeMax > 0) continue;
                    DbCacheSize.usage(val + " is not a positive integer");
                    continue;
                }
                if (name.equals("-density")) {
                    if (val == null) {
                        DbCacheSize.usage("No value after -density");
                    }
                    try {
                        density = Integer.parseInt(val);
                    }
                    catch (NumberFormatException e) {
                        DbCacheSize.usage(val + " is not a number");
                    }
                    if (density >= 1 && density <= 100) continue;
                    DbCacheSize.usage(val + " is not betwen 1 and 100");
                    continue;
                }
                if (name.equals("-overhead")) {
                    if (val == null) {
                        DbCacheSize.usage("No value after -overhead");
                    }
                    try {
                        overhead = Long.parseLong(val);
                    }
                    catch (NumberFormatException e) {
                        DbCacheSize.usage(val + " is not a number");
                    }
                    if (overhead >= 0L) continue;
                    DbCacheSize.usage(val + " is not a non-negative integer");
                    continue;
                }
                if (name.equals("-measure")) {
                    if (val == null) {
                        DbCacheSize.usage("No value after -measure");
                    }
                    measureDir = new File(val);
                    continue;
                }
                if (name.equals("-measurerandom")) {
                    measureRandom = true;
                    continue;
                }
                DbCacheSize.usage("Unknown arg: " + name);
            }
            if (records == 0L) {
                DbCacheSize.usage("-records not specified");
            }
            if (keySize == 0) {
                DbCacheSize.usage("-key not specified");
            }
            DbCacheSize.printCacheSizes(System.out, records, keySize, dataSize, nodeMax, density, overhead);
            if (measureDir != null) {
                DbCacheSize.measure(System.out, measureDir, records, keySize, dataSize, nodeMax, measureRandom);
            }
        }
        catch (Throwable e) {
            e.printStackTrace(System.out);
        }
    }

    private static void usage(String msg) {
        if (msg != null) {
            System.out.println(msg);
        }
        System.out.println("usage:\njava " + CmdUtil.getJavaCommand(DbCacheSize.class) + "\n   -records <count>" + "\n      # Total records (key/data pairs); required" + "\n   -key <bytes> " + "\n      # Average key bytes per record; required" + "\n  [-data <bytes>]" + "\n      # Average data bytes per record; if omitted no leaf" + "\n      # node sizes are included in the output" + "\n  [-nodemax <entries>]" + "\n      # Number of entries per Btree node; default: 128" + "\n  [-density <percentage>]" + "\n      # Percentage of node entries occupied; default: 80" + "\n  [-overhead <bytes>]" + "\n      # Overhead of non-Btree objects (log buffers, locks," + "\n      # etc); default: 10% of total cache size" + "\n  [-measure <environmentHomeDirectory>]" + "\n      # An empty directory used to write a database to find" + "\n      # the actual cache size; default: do not measure" + "\n  [-measurerandom" + "\n      # With -measure insert randomly generated keys;" + "\n      # default: insert sequential keys");
        System.exit(2);
    }

    private static void printCacheSizes(PrintStream out, long records, int keySize, int dataSize, int nodeMax, int density, long overhead) {
        out.println("Inputs: records=" + records + " keySize=" + keySize + " dataSize=" + dataSize + " nodeMax=" + nodeMax + " density=" + density + '%' + " overhead=" + (overhead > 0L ? overhead : 10L) + "%");
        int nodeAvg = nodeMax * density / 100;
        long nBinEntries = records * (long)nodeMax / (long)nodeAvg;
        long nBinNodes = (nBinEntries + (long)nodeMax - 1L) / (long)nodeMax;
        long nInNodes = 0L;
        int nLevels = 1;
        for (long n = nBinNodes; n > 0L; n /= (long)nodeMax) {
            nInNodes += n;
            ++nLevels;
        }
        long minInSize = nInNodes * (long)DbCacheSize.calcInSize(nodeMax, nodeAvg, keySize, true);
        long maxInSize = nInNodes * (long)DbCacheSize.calcInSize(nodeMax, nodeAvg, keySize, false);
        long lnSize = 0L;
        if (dataSize > 0) {
            lnSize = records * (long)DbCacheSize.calcLnSize(dataSize);
        }
        out.println();
        out.println(HEADER);
        out.println(DbCacheSize.line(minInSize, overhead, "Minimum, internal nodes only"));
        out.println(DbCacheSize.line(maxInSize, overhead, "Maximum, internal nodes only"));
        if (dataSize > 0) {
            out.println(DbCacheSize.line(minInSize + lnSize, overhead, "Minimum, internal nodes and leaf nodes"));
            out.println(DbCacheSize.line(maxInSize + lnSize, overhead, "Maximum, internal nodes and leaf nodes"));
        } else {
            out.println("\nTo get leaf node sizing specify -data");
        }
        out.println("\nBtree levels: " + nLevels);
    }

    private static int calcInSize(int nodeMax, int nodeAvg, int keySize, boolean lsnCompression) {
        int size = MemoryBudget.IN_FIXED_OVERHEAD;
        size += MemoryBudget.byteArraySize(nodeMax) + nodeMax * (2 * MemoryBudget.ARRAY_ITEM_OVERHEAD);
        size = lsnCompression ? (size += MemoryBudget.byteArraySize(nodeMax * 2)) : (size += MemoryBudget.BYTE_ARRAY_OVERHEAD + nodeMax * MemoryBudget.LONG_OVERHEAD);
        return size += (nodeAvg + 1) * MemoryBudget.byteArraySize(keySize);
    }

    private static int calcLnSize(int dataSize) {
        return MemoryBudget.LN_OVERHEAD + MemoryBudget.byteArraySize(dataSize);
    }

    private static String line(long btreeSize, long overhead, String comment) {
        long cacheSize = overhead == 0L ? 100L * btreeSize / 90L : btreeSize + overhead;
        StringBuffer buf = new StringBuffer(100);
        DbCacheSize.column(buf, INT_FORMAT.format(cacheSize));
        DbCacheSize.column(buf, INT_FORMAT.format(btreeSize));
        DbCacheSize.column(buf, comment);
        return buf.toString();
    }

    private static void column(StringBuffer buf, String str) {
        int start = buf.length();
        while (buf.length() - start + str.length() < 14) {
            buf.append(' ');
        }
        buf.append(str);
        for (int i = 0; i < 2; ++i) {
            buf.append(' ');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void measure(PrintStream out, File dir, long records, int keySize, int dataSize, int nodeMax, boolean randomKeys) throws DatabaseException {
        String[] fileNames = dir.list();
        if (fileNames != null && fileNames.length > 0) {
            DbCacheSize.usage("Directory is not empty: " + dir);
        }
        Environment env = DbCacheSize.openEnvironment(dir, true);
        Database db = DbCacheSize.openDatabase(env, nodeMax, true);
        try {
            out.println("\nMeasuring with cache size: " + INT_FORMAT.format(env.getConfig().getCacheSize()));
            DbCacheSize.insertRecords(out, env, db, records, keySize, dataSize, randomKeys);
            DbCacheSize.printStats(out, env, "Stats for internal and leaf nodes (after insert)");
            db.close();
            env.close();
            env = DbCacheSize.openEnvironment(dir, false);
            db = DbCacheSize.openDatabase(env, nodeMax, false);
            out.println("\nPreloading with cache size: " + INT_FORMAT.format(env.getConfig().getCacheSize()));
            DbCacheSize.preloadRecords(out, db);
            DbCacheSize.printStats(out, env, "Stats for internal nodes only (after preload)");
        }
        finally {
            try {
                db.close();
                env.close();
            }
            catch (Exception e) {
                out.println("During close: " + e);
            }
        }
    }

    private static Environment openEnvironment(File dir, boolean allowCreate) throws DatabaseException {
        EnvironmentConfig envConfig = new EnvironmentConfig();
        envConfig.setAllowCreate(allowCreate);
        envConfig.setCachePercent(90);
        return new Environment(dir, envConfig);
    }

    private static Database openDatabase(Environment env, int nodeMax, boolean allowCreate) throws DatabaseException {
        DatabaseConfig dbConfig = new DatabaseConfig();
        dbConfig.setAllowCreate(allowCreate);
        dbConfig.setNodeMaxEntries(nodeMax);
        return env.openDatabase(null, "foo", dbConfig);
    }

    private static void insertRecords(PrintStream out, Environment env, Database db, long records, int keySize, int dataSize, boolean randomKeys) throws DatabaseException {
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry data = new DatabaseEntry(new byte[dataSize]);
        BigInteger bigInt = BigInteger.ZERO;
        Random rnd = new Random(123L);
        int i = 0;
        while ((long)i < records) {
            byte[] a;
            if (randomKeys) {
                a = new byte[keySize];
                rnd.nextBytes(a);
                key.setData(a);
            } else {
                a = (bigInt = bigInt.add(BigInteger.ONE)).toByteArray();
                if (a.length < keySize) {
                    byte[] a2 = new byte[keySize];
                    System.arraycopy(a, 0, a2, a2.length - a.length, a.length);
                    a = a2;
                } else if (a.length > keySize) {
                    out.println("*** Key doesn't fit value=" + bigInt + " byte length=" + a.length);
                    return;
                }
                key.setData(a);
            }
            OperationStatus status = db.putNoOverwrite(null, key, data);
            if (status == OperationStatus.KEYEXIST && randomKeys) {
                --i;
                out.println("Random key already exists -- retrying");
            } else {
                if (status != OperationStatus.SUCCESS) {
                    out.println("*** " + status);
                    return;
                }
                if (i % 10000 == 0) {
                    EnvironmentStats stats = env.getStats(null);
                    if (stats.getNNodesScanned() > 0L) {
                        out.println("*** Ran out of cache memory at record " + i + " -- try increasing the Java heap size ***");
                        return;
                    }
                    out.print(".");
                    out.flush();
                }
            }
            ++i;
        }
    }

    private static void preloadRecords(final PrintStream out, Database db) throws DatabaseException {
        Thread thread = new Thread(){

            public void run() {
                try {
                    while (true) {
                        out.print(".");
                        out.flush();
                        Thread.sleep(5000L);
                    }
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        };
        thread.start();
        db.preload(0L);
        thread.interrupt();
        try {
            thread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace(out);
        }
    }

    private static void printStats(PrintStream out, Environment env, String msg) throws DatabaseException {
        out.println();
        out.println(msg + ':');
        EnvironmentStats stats = env.getStats(null);
        out.println("CacheSize=" + INT_FORMAT.format(stats.getCacheTotalBytes()) + " BtreeSize=" + INT_FORMAT.format(stats.getCacheDataBytes()));
        if (stats.getNNodesScanned() > 0L) {
            out.println("*** All records did not fit in the cache ***");
        }
    }
}

