/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentStats;
import com.sleepycat.je.RunRecoveryException;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.cleaner.TrackedFileSummary;
import com.sleepycat.je.cleaner.UtilizationTracker;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.latch.Latch;
import com.sleepycat.je.latch.LatchSupport;
import com.sleepycat.je.log.CheckpointMonitor;
import com.sleepycat.je.log.ChecksumValidator;
import com.sleepycat.je.log.FileHandleSource;
import com.sleepycat.je.log.FileManager;
import com.sleepycat.je.log.FileSource;
import com.sleepycat.je.log.LogBuffer;
import com.sleepycat.je.log.LogBufferPool;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogException;
import com.sleepycat.je.log.LogFileNotFoundException;
import com.sleepycat.je.log.LogSource;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.LoggableObject;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.utilint.Adler32;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.TestHook;
import com.sleepycat.je.utilint.Tracer;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.List;
import java.util.zip.Checksum;

public abstract class LogManager {
    private static final String DEBUG_NAME;
    static final int HEADER_BYTES = 14;
    static final int CHECKSUM_BYTES = 4;
    static final int PREV_BYTES = 4;
    static final int HEADER_CONTENT_BYTES = 10;
    static final int HEADER_CHECKSUM_OFFSET = 0;
    static final int HEADER_ENTRY_TYPE_OFFSET = 4;
    static final int HEADER_VERSION_OFFSET = 5;
    static final int HEADER_PREV_OFFSET = 6;
    static final int HEADER_SIZE_OFFSET = 10;
    protected LogBufferPool logBufferPool;
    protected Latch logWriteLatch;
    private boolean doChecksumOnRead;
    private FileManager fileManager;
    private CheckpointMonitor checkpointMonitor;
    protected EnvironmentImpl envImpl;
    private boolean readOnly;
    private int readBufferSize;
    private long lastLsnAtRecovery = -1L;
    private int nRepeatFaultReads;
    private long nTempBufferWrites;
    private TestHook readHook;
    static final /* synthetic */ boolean $assertionsDisabled;

    public LogManager(EnvironmentImpl envImpl, boolean readOnly) throws DatabaseException {
        this.envImpl = envImpl;
        this.fileManager = envImpl.getFileManager();
        DbConfigManager configManager = envImpl.getConfigManager();
        this.readOnly = readOnly;
        this.logBufferPool = new LogBufferPool(this.fileManager, envImpl);
        this.doChecksumOnRead = configManager.getBoolean(EnvironmentParams.LOG_CHECKSUM_READ);
        this.logWriteLatch = LatchSupport.makeLatch(DEBUG_NAME, envImpl);
        this.readBufferSize = configManager.getInt(EnvironmentParams.LOG_FAULT_READ_SIZE);
        this.checkpointMonitor = new CheckpointMonitor(envImpl);
    }

    public boolean getChecksumOnRead() {
        return this.doChecksumOnRead;
    }

    public long getLastLsnAtRecovery() {
        return this.lastLsnAtRecovery;
    }

    public void setLastLsnAtRecovery(long lastLsnAtRecovery) {
        this.lastLsnAtRecovery = lastLsnAtRecovery;
    }

    public void resetPool(DbConfigManager configManager) throws DatabaseException {
        this.logBufferPool.reset(configManager);
    }

    public long logForceFlush(LoggableObject item, boolean fsyncRequired) throws DatabaseException {
        return this.log(item, false, true, fsyncRequired, false, -1L);
    }

    public long logForceFlip(LoggableObject item) throws DatabaseException {
        return this.log(item, false, true, false, true, -1L);
    }

    public long log(LoggableObject item) throws DatabaseException {
        return this.log(item, false, false, false, false, -1L);
    }

    public long log(LoggableObject item, boolean isProvisional, long oldNodeLsn) throws DatabaseException {
        return this.log(item, isProvisional, false, false, false, oldNodeLsn);
    }

    private long log(LoggableObject item, boolean isProvisional, boolean flushRequired, boolean fsyncRequired, boolean forceNewLogFile, long oldNodeLsn) throws DatabaseException {
        if (this.readOnly) {
            return -1L;
        }
        boolean marshallOutsideLatch = item.marshallOutsideWriteLatch();
        ByteBuffer marshalledBuffer = null;
        UtilizationTracker tracker = this.envImpl.getUtilizationTracker();
        LogResult logResult = null;
        try {
            if (marshallOutsideLatch) {
                int itemSize = item.getLogSize();
                int entrySize = itemSize + 14;
                marshalledBuffer = this.marshallIntoBuffer(item, itemSize, isProvisional, entrySize);
            }
            logResult = this.logItem(item, isProvisional, flushRequired, forceNewLogFile, oldNodeLsn, marshallOutsideLatch, marshalledBuffer, tracker);
        }
        catch (BufferOverflowException e) {
            throw new RunRecoveryException(this.envImpl, (Throwable)e);
        }
        catch (IOException e) {
            throw new DatabaseException(Tracer.getStackTrace(e), e);
        }
        if (fsyncRequired) {
            this.fileManager.groupSync();
        }
        if (logResult.wakeupCheckpointer) {
            this.checkpointMonitor.activate();
        }
        if (logResult.wakeupCleaner) {
            tracker.activateCleaner();
        }
        return logResult.currentLsn;
    }

    protected abstract LogResult logItem(LoggableObject var1, boolean var2, boolean var3, boolean var4, long var5, boolean var7, ByteBuffer var8, UtilizationTracker var9) throws IOException, DatabaseException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LogResult logInternal(LoggableObject item, boolean isProvisional, boolean flushRequired, boolean forceNewLogFile, long oldNodeLsn, boolean marshallOutsideLatch, ByteBuffer marshalledBuffer, UtilizationTracker tracker) throws IOException, DatabaseException {
        LogEntryType entryType = item.getLogType();
        if (oldNodeLsn != -1L) {
            tracker.countObsoleteNode(oldNodeLsn, entryType);
        }
        int entrySize = marshallOutsideLatch ? marshalledBuffer.limit() : item.getLogSize() + 14;
        if (forceNewLogFile) {
            this.fileManager.forceNewLogFile();
        }
        boolean flippedFile = this.fileManager.bumpLsn(entrySize);
        long currentLsn = -1L;
        boolean wakeupCleaner = false;
        boolean usedTemporaryBuffer = false;
        try {
            currentLsn = this.fileManager.getLastUsedLsn();
            wakeupCleaner = tracker.countNewLogEntry(currentLsn, entryType, entrySize);
            if (item.countAsObsoleteWhenLogged()) {
                tracker.countObsoleteNodeInexact(currentLsn, entryType);
            }
            if (!marshallOutsideLatch) {
                marshalledBuffer = this.marshallIntoBuffer(item, entrySize - 14, isProvisional, entrySize);
            }
            if (entrySize != marshalledBuffer.limit()) {
                throw new DatabaseException("Logged item entrySize= " + entrySize + " but marshalledSize=" + marshalledBuffer.limit() + " type=" + entryType + " currentLsn=" + DbLsn.getNoFormatString(currentLsn));
            }
            LogBuffer useLogBuffer = this.logBufferPool.getWriteBuffer(entrySize, flippedFile);
            marshalledBuffer = this.addPrevOffsetAndChecksum(marshalledBuffer, this.fileManager.getPrevEntryOffset(), entrySize);
            useLogBuffer.latchForWrite();
            try {
                ByteBuffer useBuffer = useLogBuffer.getDataBuffer();
                if (useBuffer.capacity() - useBuffer.position() < entrySize) {
                    this.fileManager.writeLogBuffer(new LogBuffer(marshalledBuffer, currentLsn));
                    usedTemporaryBuffer = true;
                    if (!$assertionsDisabled && useBuffer.position() != 0) {
                        throw new AssertionError();
                    }
                    ++this.nTempBufferWrites;
                } else {
                    useBuffer.put(marshalledBuffer);
                }
            }
            finally {
                useLogBuffer.release();
            }
        }
        catch (Exception e) {
            this.fileManager.restoreLastPosition();
            if (e instanceof DatabaseException) {
                throw (DatabaseException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new DatabaseException(e);
        }
        if (!usedTemporaryBuffer) {
            this.logBufferPool.writeCompleted(currentLsn, flushRequired);
        }
        item.postLogWork(currentLsn);
        boolean wakeupCheckpointer = this.checkpointMonitor.recordLogWrite(entrySize, item);
        return new LogResult(currentLsn, wakeupCheckpointer, wakeupCleaner);
    }

    private ByteBuffer marshallIntoBuffer(LoggableObject item, int itemSize, boolean isProvisional, int entrySize) throws DatabaseException {
        ByteBuffer destBuffer = ByteBuffer.allocate(entrySize);
        destBuffer.position(4);
        this.writeHeader(destBuffer, item.getLogType(), itemSize, isProvisional);
        item.writeToLog(destBuffer);
        destBuffer.flip();
        return destBuffer;
    }

    private ByteBuffer addPrevOffsetAndChecksum(ByteBuffer destBuffer, long lastOffset, int entrySize) {
        Checksum checksum = Adler32.makeChecksum();
        destBuffer.position(6);
        LogUtils.writeUnsignedInt(destBuffer, lastOffset);
        checksum.update(destBuffer.array(), 4, entrySize - 4);
        destBuffer.position(0);
        LogUtils.writeUnsignedInt(destBuffer, checksum.getValue());
        destBuffer.position(0);
        return destBuffer;
    }

    ByteBuffer putIntoBuffer(LoggableObject item, int itemSize, long prevLogEntryOffset, boolean isProvisional, int entrySize) throws DatabaseException {
        ByteBuffer destBuffer = this.marshallIntoBuffer(item, itemSize, isProvisional, entrySize);
        return this.addPrevOffsetAndChecksum(destBuffer, 0L, entrySize);
    }

    private void writeHeader(ByteBuffer destBuffer, LogEntryType itemType, int itemSize, boolean isProvisional) {
        byte typeNum = itemType.getTypeNum();
        destBuffer.put(typeNum);
        byte version = itemType.getVersion();
        if (isProvisional) {
            version = LogEntryType.setProvisional(version);
        }
        destBuffer.put(version);
        destBuffer.position(10);
        LogUtils.writeInt(destBuffer, itemSize);
    }

    public LogEntry getLogEntry(long lsn) throws DatabaseException {
        this.envImpl.checkIfInvalid();
        LogSource logSource = this.getLogSource(lsn);
        return this.getLogEntryFromLogSource(lsn, logSource);
    }

    LogEntry getLogEntry(long lsn, RandomAccessFile file) throws DatabaseException {
        return this.getLogEntryFromLogSource(lsn, new FileSource(file, this.readBufferSize, this.fileManager));
    }

    private LogEntry getLogEntryFromLogSource(long lsn, LogSource logSource) throws DatabaseException {
        try {
            long fileOffset = DbLsn.getFileOffset(lsn);
            ByteBuffer entryBuffer = logSource.getBytes(fileOffset);
            ChecksumValidator validator = null;
            long storedChecksum = LogUtils.getUnsignedInt(entryBuffer);
            if (this.doChecksumOnRead) {
                validator = new ChecksumValidator();
                validator.update(this.envImpl, entryBuffer, 10, false);
            }
            byte loggableType = entryBuffer.get();
            byte version = entryBuffer.get();
            entryBuffer.position(entryBuffer.position() + 4);
            int itemSize = LogUtils.readInt(entryBuffer);
            if (entryBuffer.remaining() < itemSize) {
                entryBuffer = logSource.getBytes(fileOffset + 14L, itemSize);
                ++this.nRepeatFaultReads;
            }
            if (this.doChecksumOnRead) {
                validator.update(this.envImpl, entryBuffer, itemSize, false);
                validator.validate(this.envImpl, storedChecksum, lsn);
            }
            if (!$assertionsDisabled && !LogEntryType.isValidType(loggableType)) {
                throw new AssertionError((Object)("Read non-valid log entry type: " + loggableType));
            }
            LogEntry logEntry = LogEntryType.findType(loggableType, version).getNewLogEntry();
            logEntry.readEntry(entryBuffer, itemSize, version, true);
            if (this.readHook != null) {
                this.readHook.doIOHook();
            }
            LogEntry logEntry2 = logEntry;
            return logEntry2;
        }
        catch (DatabaseException e) {
            throw e;
        }
        catch (ClosedChannelException e) {
            throw new RunRecoveryException(this.envImpl, "Channel closed, may be due to thread interrupt", e);
        }
        catch (Exception e) {
            throw new DatabaseException(e);
        }
        finally {
            if (logSource != null) {
                logSource.release();
            }
        }
    }

    public Object get(long lsn) throws DatabaseException {
        LogEntry entry = this.getLogEntry(lsn);
        return entry.getMainItem();
    }

    private LogSource getLogSource(long lsn) throws DatabaseException {
        LogBuffer logBuffer = this.logBufferPool.getReadBuffer(lsn);
        if (logBuffer == null) {
            try {
                return new FileHandleSource(this.fileManager.getFileHandle(DbLsn.getFileNumber(lsn)), this.readBufferSize, this.fileManager);
            }
            catch (LogFileNotFoundException e) {
                throw new LogFileNotFoundException(DbLsn.getNoFormatString(lsn) + ' ' + e.getMessage());
            }
        }
        return logBuffer;
    }

    public void flush() throws DatabaseException {
        if (this.readOnly) {
            return;
        }
        this.flushInternal();
        this.fileManager.syncLogEnd();
    }

    protected abstract void flushInternal() throws LogException, DatabaseException;

    public void loadStats(StatsConfig config, EnvironmentStats stats) throws DatabaseException {
        stats.setNRepeatFaultReads(this.nRepeatFaultReads);
        stats.setNTempBufferWrites(this.nTempBufferWrites);
        if (config.getClear()) {
            this.nRepeatFaultReads = 0;
            this.nTempBufferWrites = 0L;
        }
        this.logBufferPool.loadStats(config, stats);
        this.fileManager.loadStats(config, stats);
    }

    public abstract TrackedFileSummary getUnflushableTrackedSummary(long var1) throws DatabaseException;

    protected TrackedFileSummary getUnflushableTrackedSummaryInternal(long file) throws DatabaseException {
        return this.envImpl.getUtilizationTracker().getUnflushableTrackedSummary(file);
    }

    public abstract void countObsoleteNode(long var1, LogEntryType var3) throws DatabaseException;

    protected void countObsoleteNodeInternal(UtilizationTracker tracker, long lsn, LogEntryType type) throws DatabaseException {
        tracker.countObsoleteNode(lsn, type);
    }

    public abstract void countObsoleteNodes(TrackedFileSummary[] var1) throws DatabaseException;

    protected void countObsoleteNodesInternal(UtilizationTracker tracker, TrackedFileSummary[] summaries) throws DatabaseException {
        for (int i = 0; i < summaries.length; ++i) {
            TrackedFileSummary summary = summaries[i];
            tracker.addSummary(summary.getFileNumber(), summary);
        }
    }

    public abstract void countObsoleteINs(List var1) throws DatabaseException;

    protected void countObsoleteINsInternal(List lsnList) throws DatabaseException {
        UtilizationTracker tracker = this.envImpl.getUtilizationTracker();
        for (int i = 0; i < lsnList.size(); ++i) {
            Long offset = (Long)lsnList.get(i);
            tracker.countObsoleteNode(offset, LogEntryType.LOG_IN);
        }
    }

    public void setReadHook(TestHook hook) {
        this.readHook = hook;
    }

    static {
        $assertionsDisabled = !LogManager.class.desiredAssertionStatus();
        DEBUG_NAME = LogManager.class.getName();
    }

    static class LogResult {
        long currentLsn;
        boolean wakeupCheckpointer;
        boolean wakeupCleaner;

        LogResult(long currentLsn, boolean wakeupCheckpointer, boolean wakeupCleaner) {
            this.currentLsn = currentLsn;
            this.wakeupCheckpointer = wakeupCheckpointer;
            this.wakeupCleaner = wakeupCleaner;
        }
    }
}

